// third_party/blink/public/mojom/messaging/transferable_message.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-params-data.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
TransferableMessage::TransferableMessage()
    : message(),
      ports(),
      stream_channels(),
      array_buffer_contents_array(),
      image_bitmap_contents_array(),
      user_activation() {}

TransferableMessage::TransferableMessage(
    ::blink::BlinkCloneableMessage message_in,
    WTF::Vector<::blink::MessagePortDescriptor> ports_in,
    WTF::Vector<::blink::MessagePortDescriptor> stream_channels_in,
    WTF::Vector<::blink::ArrayBufferContents> array_buffer_contents_array_in,
    WTF::Vector<::SkBitmap> image_bitmap_contents_array_in,
    ::blink::mojom::blink::UserActivationSnapshotPtr user_activation_in)
    : message(std::move(message_in)),
      ports(std::move(ports_in)),
      stream_channels(std::move(stream_channels_in)),
      array_buffer_contents_array(std::move(array_buffer_contents_array_in)),
      image_bitmap_contents_array(std::move(image_bitmap_contents_array_in)),
      user_activation(std::move(user_activation_in)) {}

TransferableMessage::~TransferableMessage() = default;

void TransferableMessage::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("message", base::trace_event::ValueToString(this->message, "<value of type ::blink::BlinkCloneableMessage>"));
  value->BeginArray("ports");
  for (const auto& item0 : this->ports) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::blink::MessagePortDescriptor>"));
  }
  value->EndArray();
  value->BeginArray("stream_channels");
  for (const auto& item0 : this->stream_channels) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::blink::MessagePortDescriptor>"));
  }
  value->EndArray();
  value->BeginArray("array_buffer_contents_array");
  for (const auto& item0 : this->array_buffer_contents_array) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::blink::ArrayBufferContents>"));
  }
  value->EndArray();
  value->BeginArray("image_bitmap_contents_array");
  for (const auto& item0 : this->image_bitmap_contents_array) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::SkBitmap&>"));
  }
  value->EndArray();
  if (this->user_activation.is_null()) {
    value->SetString("user_activation", "nullptr");
  } else {
    value->BeginDictionary("user_activation");
    this->user_activation->AsValueInto(value);
    value->EndDictionary();
  }
}

bool TransferableMessage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::TransferableMessage::DataView, ::blink::mojom::blink::TransferableMessagePtr>::Read(
    ::blink::mojom::blink::TransferableMessage::DataView input,
    ::blink::mojom::blink::TransferableMessagePtr* output) {
  bool success = true;
  ::blink::mojom::blink::TransferableMessagePtr result(::blink::mojom::blink::TransferableMessage::New());
  
      if (success && !input.ReadMessage(&result->message))
        success = false;
      if (success && !input.ReadPorts(&result->ports))
        success = false;
      if (success && !input.ReadStreamChannels(&result->stream_channels))
        success = false;
      if (success && !input.ReadArrayBufferContentsArray(&result->array_buffer_contents_array))
        success = false;
      if (success && !input.ReadImageBitmapContentsArray(&result->image_bitmap_contents_array))
        success = false;
      if (success && !input.ReadUserActivation(&result->user_activation))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif