// third_party/blink/public/mojom/page/drag.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAG_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAG_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/page/drag.mojom-shared.h"
#include "third_party/blink/public/mojom/page/drag.mojom-blink-forward.h"
#include "mojo/public/mojom/base/file_path.mojom-blink.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "services/network/public/mojom/referrer_policy.mojom-blink-forward.h"
#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_drag_drop_token.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/page/drag_mojom_traits.h"
#include "third_party/blink/renderer/platform/mojo/drag_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"




namespace WTF {
struct blink_mojom_internal_DragOperation_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::DragOperation& value) {
    using utype = std::underlying_type<::blink::mojom::DragOperation>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::DragOperation& left, const ::blink::mojom::DragOperation& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::DragOperation>
    : public GenericHashTraits<::blink::mojom::DragOperation> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::DragOperation& value) {
    return value == static_cast<::blink::mojom::DragOperation>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::DragOperation& slot, bool) {
    slot = static_cast<::blink::mojom::DragOperation>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::DragOperation& value) {
    return value == static_cast<::blink::mojom::DragOperation>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {












class PLATFORM_EXPORT DragItem {
 public:
  using DataView = DragItemDataView;
  using Data_ = internal::DragItem_Data;
  using Tag = Data_::DragItem_Tag;

  static DragItemPtr New() {
    return DragItemPtr(base::in_place);
  }
  // Construct an instance holding |string|.
  static DragItemPtr
  NewString(
      DragItemStringPtr string) {
    auto result = DragItemPtr(base::in_place);
    result->set_string(std::move(string));
    return result;
  }
  // Construct an instance holding |file|.
  static DragItemPtr
  NewFile(
      DragItemFilePtr file) {
    auto result = DragItemPtr(base::in_place);
    result->set_file(std::move(file));
    return result;
  }
  // Construct an instance holding |binary|.
  static DragItemPtr
  NewBinary(
      DragItemBinaryPtr binary) {
    auto result = DragItemPtr(base::in_place);
    result->set_binary(std::move(binary));
    return result;
  }
  // Construct an instance holding |file_system_file|.
  static DragItemPtr
  NewFileSystemFile(
      DragItemFileSystemFilePtr file_system_file) {
    auto result = DragItemPtr(base::in_place);
    result->set_file_system_file(std::move(file_system_file));
    return result;
  }

  template <typename U>
  static DragItemPtr From(const U& u) {
    return mojo::TypeConverter<DragItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragItem>::Convert(*this);
  }

  DragItem();
  ~DragItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DragItemPtr>
  DragItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DragItem>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_string() const { return tag_ == Tag::STRING; }

  
  DragItemStringPtr& get_string() const {
    DCHECK(tag_ == Tag::STRING);
    return *(data_.string);
  }

  
  void set_string(
      DragItemStringPtr string);
  
  bool is_file() const { return tag_ == Tag::FILE; }

  
  DragItemFilePtr& get_file() const {
    DCHECK(tag_ == Tag::FILE);
    return *(data_.file);
  }

  
  void set_file(
      DragItemFilePtr file);
  
  bool is_binary() const { return tag_ == Tag::BINARY; }

  
  DragItemBinaryPtr& get_binary() const {
    DCHECK(tag_ == Tag::BINARY);
    return *(data_.binary);
  }

  
  void set_binary(
      DragItemBinaryPtr binary);
  
  bool is_file_system_file() const { return tag_ == Tag::FILE_SYSTEM_FILE; }

  
  DragItemFileSystemFilePtr& get_file_system_file() const {
    DCHECK(tag_ == Tag::FILE_SYSTEM_FILE);
    return *(data_.file_system_file);
  }

  
  void set_file_system_file(
      DragItemFileSystemFilePtr file_system_file);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragItem::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DragItem::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    DragItemStringPtr* string;
    DragItemFilePtr* file;
    DragItemBinaryPtr* binary;
    DragItemFileSystemFilePtr* file_system_file;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class PLATFORM_EXPORT AllowedDragOperations {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AllowedDragOperations, T>::value>;
  using DataView = AllowedDragOperationsDataView;
  using Data_ = internal::AllowedDragOperations_Data;

  template <typename... Args>
  static AllowedDragOperationsPtr New(Args&&... args) {
    return AllowedDragOperationsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AllowedDragOperationsPtr From(const U& u) {
    return mojo::TypeConverter<AllowedDragOperationsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AllowedDragOperations>::Convert(*this);
  }


  AllowedDragOperations();

  AllowedDragOperations(
      bool allow_copy,
      bool allow_link,
      bool allow_generic,
      bool allow_private,
      bool allow_move,
      bool allow_delete);

  ~AllowedDragOperations();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AllowedDragOperationsPtr>
  AllowedDragOperationsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AllowedDragOperations::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AllowedDragOperations::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AllowedDragOperations::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AllowedDragOperations_UnserializedMessageContext<
            UserType, AllowedDragOperations::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<AllowedDragOperations::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return AllowedDragOperations::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AllowedDragOperations_UnserializedMessageContext<
            UserType, AllowedDragOperations::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AllowedDragOperations::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool allow_copy;
  
  bool allow_link;
  
  bool allow_generic;
  
  bool allow_private;
  
  bool allow_move;
  
  bool allow_delete;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AllowedDragOperations::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AllowedDragOperations::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AllowedDragOperations::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AllowedDragOperations::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DragItemString {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DragItemString, T>::value>;
  using DataView = DragItemStringDataView;
  using Data_ = internal::DragItemString_Data;

  template <typename... Args>
  static DragItemStringPtr New(Args&&... args) {
    return DragItemStringPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DragItemStringPtr From(const U& u) {
    return mojo::TypeConverter<DragItemStringPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragItemString>::Convert(*this);
  }


  DragItemString();

  DragItemString(
      const WTF::String& string_type,
      const ::WTF::String& string_data,
      const ::WTF::String& title,
      const base::Optional<::blink::KURL>& base_url);

  ~DragItemString();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DragItemStringPtr>
  DragItemStringPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DragItemString::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DragItemString::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragItemString::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DragItemString_UnserializedMessageContext<
            UserType, DragItemString::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DragItemString::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DragItemString::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DragItemString_UnserializedMessageContext<
            UserType, DragItemString::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DragItemString::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String string_type;
  
  ::WTF::String string_data;
  
  ::WTF::String title;
  
  base::Optional<::blink::KURL> base_url;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DragItemString::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DragItemString::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DragItemString::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DragItemString::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DragItemFile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DragItemFile, T>::value>;
  using DataView = DragItemFileDataView;
  using Data_ = internal::DragItemFile_Data;

  template <typename... Args>
  static DragItemFilePtr New(Args&&... args) {
    return DragItemFilePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DragItemFilePtr From(const U& u) {
    return mojo::TypeConverter<DragItemFilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragItemFile>::Convert(*this);
  }


  DragItemFile();

  DragItemFile(
      const ::base::FilePath& path,
      const ::base::FilePath& display_name,
      ::mojo::PendingRemote<::blink::mojom::blink::NativeFileSystemDragDropToken> native_file_system_token);

  ~DragItemFile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DragItemFilePtr>
  DragItemFilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DragItemFile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DragItemFile::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragItemFile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DragItemFile_UnserializedMessageContext<
            UserType, DragItemFile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DragItemFile::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DragItemFile::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DragItemFile_UnserializedMessageContext<
            UserType, DragItemFile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DragItemFile::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::FilePath path;
  
  ::base::FilePath display_name;
  
  ::mojo::PendingRemote<::blink::mojom::blink::NativeFileSystemDragDropToken> native_file_system_token;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DragItemFile);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DragItemFile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DragItemFile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DragItemFile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DragItemFile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DragItemBinary {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DragItemBinary, T>::value>;
  using DataView = DragItemBinaryDataView;
  using Data_ = internal::DragItemBinary_Data;

  template <typename... Args>
  static DragItemBinaryPtr New(Args&&... args) {
    return DragItemBinaryPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DragItemBinaryPtr From(const U& u) {
    return mojo::TypeConverter<DragItemBinaryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragItemBinary>::Convert(*this);
  }


  DragItemBinary();

  DragItemBinary(
      WTF::Vector<uint8_t> data,
      const ::blink::KURL& source_url,
      const ::base::FilePath& filename_extension,
      const WTF::String& content_disposition);

  ~DragItemBinary();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DragItemBinaryPtr>
  DragItemBinaryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DragItemBinary::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DragItemBinary::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragItemBinary::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DragItemBinary_UnserializedMessageContext<
            UserType, DragItemBinary::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DragItemBinary::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DragItemBinary::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DragItemBinary_UnserializedMessageContext<
            UserType, DragItemBinary::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DragItemBinary::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<uint8_t> data;
  
  ::blink::KURL source_url;
  
  ::base::FilePath filename_extension;
  
  WTF::String content_disposition;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DragItemBinary::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DragItemBinary::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DragItemBinary::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DragItemBinary::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DragItemFileSystemFile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DragItemFileSystemFile, T>::value>;
  using DataView = DragItemFileSystemFileDataView;
  using Data_ = internal::DragItemFileSystemFile_Data;

  template <typename... Args>
  static DragItemFileSystemFilePtr New(Args&&... args) {
    return DragItemFileSystemFilePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DragItemFileSystemFilePtr From(const U& u) {
    return mojo::TypeConverter<DragItemFileSystemFilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragItemFileSystemFile>::Convert(*this);
  }


  DragItemFileSystemFile();

  DragItemFileSystemFile(
      const ::blink::KURL& url,
      int64_t size,
      const WTF::String& file_system_id);

  ~DragItemFileSystemFile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DragItemFileSystemFilePtr>
  DragItemFileSystemFilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DragItemFileSystemFile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DragItemFileSystemFile::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragItemFileSystemFile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DragItemFileSystemFile_UnserializedMessageContext<
            UserType, DragItemFileSystemFile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DragItemFileSystemFile::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DragItemFileSystemFile::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DragItemFileSystemFile_UnserializedMessageContext<
            UserType, DragItemFileSystemFile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DragItemFileSystemFile::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::KURL url;
  
  int64_t size;
  
  WTF::String file_system_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DragItemFileSystemFile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DragItemFileSystemFile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DragItemFileSystemFile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DragItemFileSystemFile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DragData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DragData, T>::value>;
  using DataView = DragDataDataView;
  using Data_ = internal::DragData_Data;

  template <typename... Args>
  static DragDataPtr New(Args&&... args) {
    return DragDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DragDataPtr From(const U& u) {
    return mojo::TypeConverter<DragDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragData>::Convert(*this);
  }


  DragData();

  DragData(
      WTF::Vector<DragItemPtr> items,
      const WTF::String& file_system_id,
      ::network::mojom::blink::ReferrerPolicy referrer_policy);

  ~DragData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DragDataPtr>
  DragDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DragData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DragData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DragData_UnserializedMessageContext<
            UserType, DragData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DragData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DragData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DragData_UnserializedMessageContext<
            UserType, DragData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DragData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<DragItemPtr> items;
  
  WTF::String file_system_id;
  
  ::network::mojom::blink::ReferrerPolicy referrer_policy;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DragData);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DragData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DragData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DragData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DragData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DragEventSourceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DragEventSourceInfo, T>::value>;
  using DataView = DragEventSourceInfoDataView;
  using Data_ = internal::DragEventSourceInfo_Data;

  template <typename... Args>
  static DragEventSourceInfoPtr New(Args&&... args) {
    return DragEventSourceInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DragEventSourceInfoPtr From(const U& u) {
    return mojo::TypeConverter<DragEventSourceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DragEventSourceInfo>::Convert(*this);
  }


  DragEventSourceInfo();

  DragEventSourceInfo(
      const ::gfx::Point& location,
      ::ui::mojom::blink::DragEventSource source);

  ~DragEventSourceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DragEventSourceInfoPtr>
  DragEventSourceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DragEventSourceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DragEventSourceInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DragEventSourceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DragEventSourceInfo_UnserializedMessageContext<
            UserType, DragEventSourceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DragEventSourceInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DragEventSourceInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DragEventSourceInfo_UnserializedMessageContext<
            UserType, DragEventSourceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DragEventSourceInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::Point location;
  
  ::ui::mojom::blink::DragEventSource source;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DragEventSourceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DragEventSourceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DragEventSourceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DragEventSourceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
DragItemPtr DragItem::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::STRING:
      rv->set_string(mojo::Clone(*data_.string));
      break;
    case Tag::FILE:
      rv->set_file(mojo::Clone(*data_.file));
      break;
    case Tag::BINARY:
      rv->set_binary(mojo::Clone(*data_.binary));
      break;
    case Tag::FILE_SYSTEM_FILE:
      rv->set_file_system_file(mojo::Clone(*data_.file_system_file));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DragItem>::value>::type*>
bool DragItem::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::STRING:
      return mojo::Equals(*(data_.string), *(other.data_.string));
    case Tag::FILE:
      return mojo::Equals(*(data_.file), *(other.data_.file));
    case Tag::BINARY:
      return mojo::Equals(*(data_.binary), *(other.data_.binary));
    case Tag::FILE_SYSTEM_FILE:
      return mojo::Equals(*(data_.file_system_file), *(other.data_.file_system_file));
  }

  return false;
}
template <typename StructPtrType>
AllowedDragOperationsPtr AllowedDragOperations::Clone() const {
  return New(
      mojo::Clone(allow_copy),
      mojo::Clone(allow_link),
      mojo::Clone(allow_generic),
      mojo::Clone(allow_private),
      mojo::Clone(allow_move),
      mojo::Clone(allow_delete)
  );
}

template <typename T, AllowedDragOperations::EnableIfSame<T>*>
bool AllowedDragOperations::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allow_copy, other_struct.allow_copy))
    return false;
  if (!mojo::Equals(this->allow_link, other_struct.allow_link))
    return false;
  if (!mojo::Equals(this->allow_generic, other_struct.allow_generic))
    return false;
  if (!mojo::Equals(this->allow_private, other_struct.allow_private))
    return false;
  if (!mojo::Equals(this->allow_move, other_struct.allow_move))
    return false;
  if (!mojo::Equals(this->allow_delete, other_struct.allow_delete))
    return false;
  return true;
}

template <typename T, AllowedDragOperations::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.allow_copy, rhs.allow_copy))
    return true;
  if (std::less<>{}(rhs.allow_copy, lhs.allow_copy))
    return false;
  if (std::less<>{}(lhs.allow_link, rhs.allow_link))
    return true;
  if (std::less<>{}(rhs.allow_link, lhs.allow_link))
    return false;
  if (std::less<>{}(lhs.allow_generic, rhs.allow_generic))
    return true;
  if (std::less<>{}(rhs.allow_generic, lhs.allow_generic))
    return false;
  if (std::less<>{}(lhs.allow_private, rhs.allow_private))
    return true;
  if (std::less<>{}(rhs.allow_private, lhs.allow_private))
    return false;
  if (std::less<>{}(lhs.allow_move, rhs.allow_move))
    return true;
  if (std::less<>{}(rhs.allow_move, lhs.allow_move))
    return false;
  if (std::less<>{}(lhs.allow_delete, rhs.allow_delete))
    return true;
  if (std::less<>{}(rhs.allow_delete, lhs.allow_delete))
    return false;
  return false;
}
template <typename StructPtrType>
DragItemStringPtr DragItemString::Clone() const {
  return New(
      mojo::Clone(string_type),
      mojo::Clone(string_data),
      mojo::Clone(title),
      mojo::Clone(base_url)
  );
}

template <typename T, DragItemString::EnableIfSame<T>*>
bool DragItemString::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->string_type, other_struct.string_type))
    return false;
  if (!mojo::Equals(this->string_data, other_struct.string_data))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->base_url, other_struct.base_url))
    return false;
  return true;
}

template <typename T, DragItemString::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.string_type, rhs.string_type))
    return true;
  if (std::less<>{}(rhs.string_type, lhs.string_type))
    return false;
  if (std::less<>{}(lhs.string_data, rhs.string_data))
    return true;
  if (std::less<>{}(rhs.string_data, lhs.string_data))
    return false;
  if (std::less<>{}(lhs.title, rhs.title))
    return true;
  if (std::less<>{}(rhs.title, lhs.title))
    return false;
  if (std::less<>{}(lhs.base_url, rhs.base_url))
    return true;
  if (std::less<>{}(rhs.base_url, lhs.base_url))
    return false;
  return false;
}
template <typename StructPtrType>
DragItemFilePtr DragItemFile::Clone() const {
  return New(
      mojo::Clone(path),
      mojo::Clone(display_name),
      mojo::Clone(native_file_system_token)
  );
}

template <typename T, DragItemFile::EnableIfSame<T>*>
bool DragItemFile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->native_file_system_token, other_struct.native_file_system_token))
    return false;
  return true;
}

template <typename T, DragItemFile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.path, rhs.path))
    return true;
  if (std::less<>{}(rhs.path, lhs.path))
    return false;
  if (std::less<>{}(lhs.display_name, rhs.display_name))
    return true;
  if (std::less<>{}(rhs.display_name, lhs.display_name))
    return false;
  if (std::less<>{}(lhs.native_file_system_token, rhs.native_file_system_token))
    return true;
  if (std::less<>{}(rhs.native_file_system_token, lhs.native_file_system_token))
    return false;
  return false;
}
template <typename StructPtrType>
DragItemBinaryPtr DragItemBinary::Clone() const {
  return New(
      mojo::Clone(data),
      mojo::Clone(source_url),
      mojo::Clone(filename_extension),
      mojo::Clone(content_disposition)
  );
}

template <typename T, DragItemBinary::EnableIfSame<T>*>
bool DragItemBinary::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->source_url, other_struct.source_url))
    return false;
  if (!mojo::Equals(this->filename_extension, other_struct.filename_extension))
    return false;
  if (!mojo::Equals(this->content_disposition, other_struct.content_disposition))
    return false;
  return true;
}

template <typename T, DragItemBinary::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.data, rhs.data))
    return true;
  if (std::less<>{}(rhs.data, lhs.data))
    return false;
  if (std::less<>{}(lhs.source_url, rhs.source_url))
    return true;
  if (std::less<>{}(rhs.source_url, lhs.source_url))
    return false;
  if (std::less<>{}(lhs.filename_extension, rhs.filename_extension))
    return true;
  if (std::less<>{}(rhs.filename_extension, lhs.filename_extension))
    return false;
  if (std::less<>{}(lhs.content_disposition, rhs.content_disposition))
    return true;
  if (std::less<>{}(rhs.content_disposition, lhs.content_disposition))
    return false;
  return false;
}
template <typename StructPtrType>
DragItemFileSystemFilePtr DragItemFileSystemFile::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(size),
      mojo::Clone(file_system_id)
  );
}

template <typename T, DragItemFileSystemFile::EnableIfSame<T>*>
bool DragItemFileSystemFile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->file_system_id, other_struct.file_system_id))
    return false;
  return true;
}

template <typename T, DragItemFileSystemFile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.size, rhs.size))
    return true;
  if (std::less<>{}(rhs.size, lhs.size))
    return false;
  if (std::less<>{}(lhs.file_system_id, rhs.file_system_id))
    return true;
  if (std::less<>{}(rhs.file_system_id, lhs.file_system_id))
    return false;
  return false;
}
template <typename StructPtrType>
DragDataPtr DragData::Clone() const {
  return New(
      mojo::Clone(items),
      mojo::Clone(file_system_id),
      mojo::Clone(referrer_policy)
  );
}

template <typename T, DragData::EnableIfSame<T>*>
bool DragData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->items, other_struct.items))
    return false;
  if (!mojo::Equals(this->file_system_id, other_struct.file_system_id))
    return false;
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  return true;
}

template <typename T, DragData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.items, rhs.items))
    return true;
  if (std::less<>{}(rhs.items, lhs.items))
    return false;
  if (std::less<>{}(lhs.file_system_id, rhs.file_system_id))
    return true;
  if (std::less<>{}(rhs.file_system_id, lhs.file_system_id))
    return false;
  if (std::less<>{}(lhs.referrer_policy, rhs.referrer_policy))
    return true;
  if (std::less<>{}(rhs.referrer_policy, lhs.referrer_policy))
    return false;
  return false;
}
template <typename StructPtrType>
DragEventSourceInfoPtr DragEventSourceInfo::Clone() const {
  return New(
      mojo::Clone(location),
      mojo::Clone(source)
  );
}

template <typename T, DragEventSourceInfo::EnableIfSame<T>*>
bool DragEventSourceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->location, other_struct.location))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  return true;
}

template <typename T, DragEventSourceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.location, rhs.location))
    return true;
  if (std::less<>{}(rhs.location, lhs.location))
    return false;
  if (std::less<>{}(lhs.source, rhs.source))
    return true;
  if (std::less<>{}(rhs.source, lhs.source))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AllowedDragOperations::DataView,
                                         ::blink::mojom::blink::AllowedDragOperationsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AllowedDragOperationsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AllowedDragOperationsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AllowedDragOperations::allow_copy) allow_copy(
      const ::blink::mojom::blink::AllowedDragOperationsPtr& input) {
    return input->allow_copy;
  }

  static decltype(::blink::mojom::blink::AllowedDragOperations::allow_link) allow_link(
      const ::blink::mojom::blink::AllowedDragOperationsPtr& input) {
    return input->allow_link;
  }

  static decltype(::blink::mojom::blink::AllowedDragOperations::allow_generic) allow_generic(
      const ::blink::mojom::blink::AllowedDragOperationsPtr& input) {
    return input->allow_generic;
  }

  static decltype(::blink::mojom::blink::AllowedDragOperations::allow_private) allow_private(
      const ::blink::mojom::blink::AllowedDragOperationsPtr& input) {
    return input->allow_private;
  }

  static decltype(::blink::mojom::blink::AllowedDragOperations::allow_move) allow_move(
      const ::blink::mojom::blink::AllowedDragOperationsPtr& input) {
    return input->allow_move;
  }

  static decltype(::blink::mojom::blink::AllowedDragOperations::allow_delete) allow_delete(
      const ::blink::mojom::blink::AllowedDragOperationsPtr& input) {
    return input->allow_delete;
  }

  static bool Read(::blink::mojom::blink::AllowedDragOperations::DataView input, ::blink::mojom::blink::AllowedDragOperationsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DragItemString::DataView,
                                         ::blink::mojom::blink::DragItemStringPtr> {
  static bool IsNull(const ::blink::mojom::blink::DragItemStringPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DragItemStringPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DragItemString::string_type)& string_type(
      const ::blink::mojom::blink::DragItemStringPtr& input) {
    return input->string_type;
  }

  static const decltype(::blink::mojom::blink::DragItemString::string_data)& string_data(
      const ::blink::mojom::blink::DragItemStringPtr& input) {
    return input->string_data;
  }

  static const decltype(::blink::mojom::blink::DragItemString::title)& title(
      const ::blink::mojom::blink::DragItemStringPtr& input) {
    return input->title;
  }

  static const decltype(::blink::mojom::blink::DragItemString::base_url)& base_url(
      const ::blink::mojom::blink::DragItemStringPtr& input) {
    return input->base_url;
  }

  static bool Read(::blink::mojom::blink::DragItemString::DataView input, ::blink::mojom::blink::DragItemStringPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DragItemFile::DataView,
                                         ::blink::mojom::blink::DragItemFilePtr> {
  static bool IsNull(const ::blink::mojom::blink::DragItemFilePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DragItemFilePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DragItemFile::path)& path(
      const ::blink::mojom::blink::DragItemFilePtr& input) {
    return input->path;
  }

  static const decltype(::blink::mojom::blink::DragItemFile::display_name)& display_name(
      const ::blink::mojom::blink::DragItemFilePtr& input) {
    return input->display_name;
  }

  static  decltype(::blink::mojom::blink::DragItemFile::native_file_system_token)& native_file_system_token(
       ::blink::mojom::blink::DragItemFilePtr& input) {
    return input->native_file_system_token;
  }

  static bool Read(::blink::mojom::blink::DragItemFile::DataView input, ::blink::mojom::blink::DragItemFilePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DragItemBinary::DataView,
                                         ::blink::mojom::blink::DragItemBinaryPtr> {
  static bool IsNull(const ::blink::mojom::blink::DragItemBinaryPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DragItemBinaryPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DragItemBinary::data)& data(
      const ::blink::mojom::blink::DragItemBinaryPtr& input) {
    return input->data;
  }

  static const decltype(::blink::mojom::blink::DragItemBinary::source_url)& source_url(
      const ::blink::mojom::blink::DragItemBinaryPtr& input) {
    return input->source_url;
  }

  static const decltype(::blink::mojom::blink::DragItemBinary::filename_extension)& filename_extension(
      const ::blink::mojom::blink::DragItemBinaryPtr& input) {
    return input->filename_extension;
  }

  static const decltype(::blink::mojom::blink::DragItemBinary::content_disposition)& content_disposition(
      const ::blink::mojom::blink::DragItemBinaryPtr& input) {
    return input->content_disposition;
  }

  static bool Read(::blink::mojom::blink::DragItemBinary::DataView input, ::blink::mojom::blink::DragItemBinaryPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DragItemFileSystemFile::DataView,
                                         ::blink::mojom::blink::DragItemFileSystemFilePtr> {
  static bool IsNull(const ::blink::mojom::blink::DragItemFileSystemFilePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DragItemFileSystemFilePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DragItemFileSystemFile::url)& url(
      const ::blink::mojom::blink::DragItemFileSystemFilePtr& input) {
    return input->url;
  }

  static decltype(::blink::mojom::blink::DragItemFileSystemFile::size) size(
      const ::blink::mojom::blink::DragItemFileSystemFilePtr& input) {
    return input->size;
  }

  static const decltype(::blink::mojom::blink::DragItemFileSystemFile::file_system_id)& file_system_id(
      const ::blink::mojom::blink::DragItemFileSystemFilePtr& input) {
    return input->file_system_id;
  }

  static bool Read(::blink::mojom::blink::DragItemFileSystemFile::DataView input, ::blink::mojom::blink::DragItemFileSystemFilePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DragData::DataView,
                                         ::blink::mojom::blink::DragDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::DragDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DragDataPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::DragData::items)& items(
       ::blink::mojom::blink::DragDataPtr& input) {
    return input->items;
  }

  static const decltype(::blink::mojom::blink::DragData::file_system_id)& file_system_id(
      const ::blink::mojom::blink::DragDataPtr& input) {
    return input->file_system_id;
  }

  static decltype(::blink::mojom::blink::DragData::referrer_policy) referrer_policy(
      const ::blink::mojom::blink::DragDataPtr& input) {
    return input->referrer_policy;
  }

  static bool Read(::blink::mojom::blink::DragData::DataView input, ::blink::mojom::blink::DragDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DragEventSourceInfo::DataView,
                                         ::blink::mojom::blink::DragEventSourceInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::DragEventSourceInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DragEventSourceInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DragEventSourceInfo::location)& location(
      const ::blink::mojom::blink::DragEventSourceInfoPtr& input) {
    return input->location;
  }

  static decltype(::blink::mojom::blink::DragEventSourceInfo::source) source(
      const ::blink::mojom::blink::DragEventSourceInfoPtr& input) {
    return input->source;
  }

  static bool Read(::blink::mojom::blink::DragEventSourceInfo::DataView input, ::blink::mojom::blink::DragEventSourceInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::DragItem::DataView,
                                        ::blink::mojom::blink::DragItemPtr> {
  static bool IsNull(const ::blink::mojom::blink::DragItemPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DragItemPtr* output) { output->reset(); }

  static ::blink::mojom::blink::DragItem::Tag GetTag(const ::blink::mojom::blink::DragItemPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::blink::DragItemStringPtr& string(const ::blink::mojom::blink::DragItemPtr& input) {
    return input->get_string();
  }

  static  ::blink::mojom::blink::DragItemFilePtr& file( ::blink::mojom::blink::DragItemPtr& input) {
    return input->get_file();
  }

  static const ::blink::mojom::blink::DragItemBinaryPtr& binary(const ::blink::mojom::blink::DragItemPtr& input) {
    return input->get_binary();
  }

  static const ::blink::mojom::blink::DragItemFileSystemFilePtr& file_system_file(const ::blink::mojom::blink::DragItemPtr& input) {
    return input->get_file_system_file();
  }

  static bool Read(::blink::mojom::blink::DragItem::DataView input, ::blink::mojom::blink::DragItemPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAG_MOJOM_BLINK_H_