// third_party/blink/public/mojom/page/drag.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAG_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAG_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/page/drag.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_drag_drop_token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class AllowedDragOperationsDataView;

class DragItemStringDataView;

class DragItemFileDataView;

class DragItemBinaryDataView;

class DragItemFileSystemFileDataView;

class DragDataDataView;

class DragEventSourceInfoDataView;

class DragItemDataView;


}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AllowedDragOperationsDataView> {
  using Data = ::blink::mojom::internal::AllowedDragOperations_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragItemStringDataView> {
  using Data = ::blink::mojom::internal::DragItemString_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragItemFileDataView> {
  using Data = ::blink::mojom::internal::DragItemFile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragItemBinaryDataView> {
  using Data = ::blink::mojom::internal::DragItemBinary_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragItemFileSystemFileDataView> {
  using Data = ::blink::mojom::internal::DragItemFileSystemFile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragDataDataView> {
  using Data = ::blink::mojom::internal::DragData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragEventSourceInfoDataView> {
  using Data = ::blink::mojom::internal::DragEventSourceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragItemDataView> {
  using Data = ::blink::mojom::internal::DragItem_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class DragOperation : int32_t {
  
  kNone = 0,
  
  kCopy = 1,
  
  kLink = 2,
  
  kGeneric = 3,
  
  kPrivate = 4,
  
  kMove = 5,
  
  kDelete = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, DragOperation value);
inline bool IsKnownEnumValue(DragOperation value) {
  return internal::DragOperation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class AllowedDragOperationsDataView {
 public:
  AllowedDragOperationsDataView() {}

  AllowedDragOperationsDataView(
      internal::AllowedDragOperations_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool allow_copy() const {
    return data_->allow_copy;
  }
  bool allow_link() const {
    return data_->allow_link;
  }
  bool allow_generic() const {
    return data_->allow_generic;
  }
  bool allow_private() const {
    return data_->allow_private;
  }
  bool allow_move() const {
    return data_->allow_move;
  }
  bool allow_delete() const {
    return data_->allow_delete;
  }
 private:
  internal::AllowedDragOperations_Data* data_ = nullptr;
};



class DragItemStringDataView {
 public:
  DragItemStringDataView() {}

  DragItemStringDataView(
      internal::DragItemString_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetStringTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStringType(UserType* output) {
    
    auto* pointer = data_->string_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetStringDataDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStringData(UserType* output) {
    
    auto* pointer = data_->string_data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTitle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `title` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTitle` instead "
    "of `ReadTitle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
  inline void GetBaseUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBaseUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `base_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBaseUrl` instead "
    "of `ReadBaseUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->base_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
 private:
  internal::DragItemString_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DragItemFileDataView {
 public:
  DragItemFileDataView() {}

  DragItemFileDataView(
      internal::DragItemFile_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, context_);
  }
  inline void GetDisplayNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeNativeFileSystemToken() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::NativeFileSystemDragDropTokenInterfaceBase>>(
            &data_->native_file_system_token, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::DragItemFile_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DragItemBinaryDataView {
 public:
  DragItemBinaryDataView() {}

  DragItemBinaryDataView(
      internal::DragItemBinary_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  inline void GetSourceUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSourceUrl(UserType* output) {
    
    auto* pointer = data_->source_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetFilenameExtensionDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFilenameExtension(UserType* output) {
    
    auto* pointer = data_->filename_extension.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, context_);
  }
  inline void GetContentDispositionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContentDisposition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `content_disposition` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContentDisposition` instead "
    "of `ReadContentDisposition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->content_disposition.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::DragItemBinary_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DragItemFileSystemFileDataView {
 public:
  DragItemFileSystemFileDataView() {}

  DragItemFileSystemFileDataView(
      internal::DragItemFileSystemFile_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  int64_t size() const {
    return data_->size;
  }
  inline void GetFileSystemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFileSystemId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `file_system_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileSystemId` instead "
    "of `ReadFileSystemId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_system_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::DragItemFileSystemFile_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DragDataDataView {
 public:
  DragDataDataView() {}

  DragDataDataView(
      internal::DragData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetItemsDataView(
      mojo::ArrayDataView<DragItemDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadItems(UserType* output) {
    
    auto* pointer = data_->items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::DragItemDataView>>(
        pointer, output, context_);
  }
  inline void GetFileSystemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFileSystemId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `file_system_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileSystemId` instead "
    "of `ReadFileSystemId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_system_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::ReferrerPolicy>(
        data_value, output);
  }

  ::network::mojom::ReferrerPolicy referrer_policy() const {
    return static_cast<::network::mojom::ReferrerPolicy>(data_->referrer_policy);
  }
 private:
  internal::DragData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DragEventSourceInfoDataView {
 public:
  DragEventSourceInfoDataView() {}

  DragEventSourceInfoDataView(
      internal::DragEventSourceInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetLocationDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLocation(UserType* output) {
    
    auto* pointer = data_->location.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSource(UserType* output) const {
    auto data_value = data_->source;
    return mojo::internal::Deserialize<::ui::mojom::DragEventSource>(
        data_value, output);
  }

  ::ui::mojom::DragEventSource source() const {
    return static_cast<::ui::mojom::DragEventSource>(data_->source);
  }
 private:
  internal::DragEventSourceInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DragItemDataView {
 public:
  using Tag = internal::DragItem_Data::DragItem_Tag;

  DragItemDataView() {}

  DragItemDataView(
      internal::DragItem_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_string() const { return data_->tag == Tag::STRING; }
  inline void GetStringDataView(
      DragItemStringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadString(UserType* output) {
    
    DCHECK(is_string());
    return mojo::internal::Deserialize<::blink::mojom::DragItemStringDataView>(
        data_->data.f_string.Get(), output, context_);
  }
  bool is_file() const { return data_->tag == Tag::FILE; }
  inline void GetFileDataView(
      DragItemFileDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFile(UserType* output) {
    
    DCHECK(is_file());
    return mojo::internal::Deserialize<::blink::mojom::DragItemFileDataView>(
        data_->data.f_file.Get(), output, context_);
  }
  bool is_binary() const { return data_->tag == Tag::BINARY; }
  inline void GetBinaryDataView(
      DragItemBinaryDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBinary(UserType* output) {
    
    DCHECK(is_binary());
    return mojo::internal::Deserialize<::blink::mojom::DragItemBinaryDataView>(
        data_->data.f_binary.Get(), output, context_);
  }
  bool is_file_system_file() const { return data_->tag == Tag::FILE_SYSTEM_FILE; }
  inline void GetFileSystemFileDataView(
      DragItemFileSystemFileDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFileSystemFile(UserType* output) {
    
    DCHECK(is_file_system_file());
    return mojo::internal::Deserialize<::blink::mojom::DragItemFileSystemFileDataView>(
        data_->data.f_file_system_file.Get(), output, context_);
  }

 private:
  internal::DragItem_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::DragOperation>
    : public mojo::internal::EnumHashImpl<::blink::mojom::DragOperation> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::DragOperation, ::blink::mojom::DragOperation> {
  static ::blink::mojom::DragOperation ToMojom(::blink::mojom::DragOperation input) { return input; }
  static bool FromMojom(::blink::mojom::DragOperation input, ::blink::mojom::DragOperation* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragOperation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::DragOperation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::DragOperation>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AllowedDragOperationsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AllowedDragOperationsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::AllowedDragOperations_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->allow_copy = Traits::allow_copy(input);
    (*output)->allow_link = Traits::allow_link(input);
    (*output)->allow_generic = Traits::allow_generic(input);
    (*output)->allow_private = Traits::allow_private(input);
    (*output)->allow_move = Traits::allow_move(input);
    (*output)->allow_delete = Traits::allow_delete(input);
  }

  static bool Deserialize(::blink::mojom::internal::AllowedDragOperations_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AllowedDragOperationsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragItemStringDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragItemStringDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DragItemString_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::string_type(input)) in_string_type = Traits::string_type(input);
    typename decltype((*output)->string_type)::BaseType::BufferWriter
        string_type_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_string_type, buffer, &string_type_writer, context);
    (*output)->string_type.Set(
        string_type_writer.is_null() ? nullptr : string_type_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->string_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null string_type in DragItemString struct");
    decltype(Traits::string_data(input)) in_string_data = Traits::string_data(input);
    typename decltype((*output)->string_data)::BaseType::BufferWriter
        string_data_writer;
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_string_data, buffer, &string_data_writer, context);
    (*output)->string_data.Set(
        string_data_writer.is_null() ? nullptr : string_data_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->string_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null string_data in DragItemString struct");
    decltype(Traits::title(input)) in_title = Traits::title(input);
    typename decltype((*output)->title)::BaseType::BufferWriter
        title_writer;
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_title, buffer, &title_writer, context);
    (*output)->title.Set(
        title_writer.is_null() ? nullptr : title_writer.data());
    decltype(Traits::base_url(input)) in_base_url = Traits::base_url(input);
    typename decltype((*output)->base_url)::BaseType::BufferWriter
        base_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_base_url, buffer, &base_url_writer, context);
    (*output)->base_url.Set(
        base_url_writer.is_null() ? nullptr : base_url_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::DragItemString_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragItemStringDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragItemFileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragItemFileDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DragItemFile_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::path(input)) in_path = Traits::path(input);
    typename decltype((*output)->path)::BaseType::BufferWriter
        path_writer;
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_path, buffer, &path_writer, context);
    (*output)->path.Set(
        path_writer.is_null() ? nullptr : path_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->path.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in DragItemFile struct");
    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    typename decltype((*output)->display_name)::BaseType::BufferWriter
        display_name_writer;
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_display_name, buffer, &display_name_writer, context);
    (*output)->display_name.Set(
        display_name_writer.is_null() ? nullptr : display_name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->display_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_name in DragItemFile struct");
    decltype(Traits::native_file_system_token(input)) in_native_file_system_token = Traits::native_file_system_token(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NativeFileSystemDragDropTokenInterfaceBase>>(
        in_native_file_system_token, &(*output)->native_file_system_token, context);
  }

  static bool Deserialize(::blink::mojom::internal::DragItemFile_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragItemFileDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragItemBinaryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragItemBinaryDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DragItemBinary_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::data(input)) in_data = Traits::data(input);
    typename decltype((*output)->data)::BaseType::BufferWriter
        data_writer;
    const mojo::internal::ContainerValidateParams data_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_data, buffer, &data_writer, &data_validate_params,
        context);
    (*output)->data.Set(
        data_writer.is_null() ? nullptr : data_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in DragItemBinary struct");
    decltype(Traits::source_url(input)) in_source_url = Traits::source_url(input);
    typename decltype((*output)->source_url)::BaseType::BufferWriter
        source_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_source_url, buffer, &source_url_writer, context);
    (*output)->source_url.Set(
        source_url_writer.is_null() ? nullptr : source_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->source_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_url in DragItemBinary struct");
    decltype(Traits::filename_extension(input)) in_filename_extension = Traits::filename_extension(input);
    typename decltype((*output)->filename_extension)::BaseType::BufferWriter
        filename_extension_writer;
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_filename_extension, buffer, &filename_extension_writer, context);
    (*output)->filename_extension.Set(
        filename_extension_writer.is_null() ? nullptr : filename_extension_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->filename_extension.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filename_extension in DragItemBinary struct");
    decltype(Traits::content_disposition(input)) in_content_disposition = Traits::content_disposition(input);
    typename decltype((*output)->content_disposition)::BaseType::BufferWriter
        content_disposition_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_content_disposition, buffer, &content_disposition_writer, context);
    (*output)->content_disposition.Set(
        content_disposition_writer.is_null() ? nullptr : content_disposition_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::DragItemBinary_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragItemBinaryDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragItemFileSystemFileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragItemFileSystemFileDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DragItemFileSystemFile_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in DragItemFileSystemFile struct");
    (*output)->size = Traits::size(input);
    decltype(Traits::file_system_id(input)) in_file_system_id = Traits::file_system_id(input);
    typename decltype((*output)->file_system_id)::BaseType::BufferWriter
        file_system_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_file_system_id, buffer, &file_system_id_writer, context);
    (*output)->file_system_id.Set(
        file_system_id_writer.is_null() ? nullptr : file_system_id_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::DragItemFileSystemFile_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragItemFileSystemFileDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DragData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::items(input)) in_items = Traits::items(input);
    typename decltype((*output)->items)::BaseType::BufferWriter
        items_writer;
    const mojo::internal::ContainerValidateParams items_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::DragItemDataView>>(
        in_items, buffer, &items_writer, &items_validate_params,
        context);
    (*output)->items.Set(
        items_writer.is_null() ? nullptr : items_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->items.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null items in DragData struct");
    decltype(Traits::file_system_id(input)) in_file_system_id = Traits::file_system_id(input);
    typename decltype((*output)->file_system_id)::BaseType::BufferWriter
        file_system_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_file_system_id, buffer, &file_system_id_writer, context);
    (*output)->file_system_id.Set(
        file_system_id_writer.is_null() ? nullptr : file_system_id_writer.data());
    mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
        Traits::referrer_policy(input), &(*output)->referrer_policy);
  }

  static bool Deserialize(::blink::mojom::internal::DragData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragEventSourceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragEventSourceInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DragEventSourceInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::location(input)) in_location = Traits::location(input);
    typename decltype((*output)->location)::BaseType::BufferWriter
        location_writer;
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_location, buffer, &location_writer, context);
    (*output)->location.Set(
        location_writer.is_null() ? nullptr : location_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location in DragEventSourceInfo struct");
    mojo::internal::Serialize<::ui::mojom::DragEventSource>(
        Traits::source(input), &(*output)->source);
  }

  static bool Deserialize(::blink::mojom::internal::DragEventSourceInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragEventSourceInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::DragItemDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DragItem_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::blink::mojom::internal::DragItem_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::blink::mojom::DragItemDataView::Tag::STRING: {
        decltype(Traits::string(input))
            in_string = Traits::string(input);
        typename decltype(result->data.f_string)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::DragItemStringDataView>(
            in_string, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null string in DragItem union");
        result->data.f_string.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::DragItemDataView::Tag::FILE: {
        decltype(Traits::file(input))
            in_file = Traits::file(input);
        typename decltype(result->data.f_file)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::DragItemFileDataView>(
            in_file, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null file in DragItem union");
        result->data.f_file.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::DragItemDataView::Tag::BINARY: {
        decltype(Traits::binary(input))
            in_binary = Traits::binary(input);
        typename decltype(result->data.f_binary)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::DragItemBinaryDataView>(
            in_binary, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null binary in DragItem union");
        result->data.f_binary.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::blink::mojom::DragItemDataView::Tag::FILE_SYSTEM_FILE: {
        decltype(Traits::file_system_file(input))
            in_file_system_file = Traits::file_system_file(input);
        typename decltype(result->data.f_file_system_file)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::blink::mojom::DragItemFileSystemFileDataView>(
            in_file_system_file, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null file_system_file in DragItem union");
        result->data.f_file_system_file.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::DragItem_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragItemDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {



inline void DragItemStringDataView::GetStringTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->string_type.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void DragItemStringDataView::GetStringDataDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->string_data.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}
inline void DragItemStringDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}
inline void DragItemStringDataView::GetBaseUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->base_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}


inline void DragItemFileDataView::GetPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, context_);
}
inline void DragItemFileDataView::GetDisplayNameDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, context_);
}


inline void DragItemBinaryDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}
inline void DragItemBinaryDataView::GetSourceUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->source_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void DragItemBinaryDataView::GetFilenameExtensionDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->filename_extension.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, context_);
}
inline void DragItemBinaryDataView::GetContentDispositionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_disposition.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void DragItemFileSystemFileDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void DragItemFileSystemFileDataView::GetFileSystemIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->file_system_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void DragDataDataView::GetItemsDataView(
    mojo::ArrayDataView<DragItemDataView>* output) {
  auto pointer = data_->items.Get();
  *output = mojo::ArrayDataView<DragItemDataView>(pointer, context_);
}
inline void DragDataDataView::GetFileSystemIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->file_system_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void DragEventSourceInfoDataView::GetLocationDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->location.Get();
  *output = ::gfx::mojom::PointDataView(pointer, context_);
}


inline void DragItemDataView::GetStringDataView(
    DragItemStringDataView* output) {
  DCHECK(is_string());
  *output = DragItemStringDataView(data_->data.f_string.Get(), context_);
}
inline void DragItemDataView::GetFileDataView(
    DragItemFileDataView* output) {
  DCHECK(is_file());
  *output = DragItemFileDataView(data_->data.f_file.Get(), context_);
}
inline void DragItemDataView::GetBinaryDataView(
    DragItemBinaryDataView* output) {
  DCHECK(is_binary());
  *output = DragItemBinaryDataView(data_->data.f_binary.Get(), context_);
}
inline void DragItemDataView::GetFileSystemFileDataView(
    DragItemFileSystemFileDataView* output) {
  DCHECK(is_file_system_file());
  *output = DragItemFileSystemFileDataView(data_->data.f_file_system_file.Get(), context_);
}


}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAG_MOJOM_SHARED_H_