// third_party/blink/public/mojom/page/page.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/page/page.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/page/page.mojom-params-data.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/page/page.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
PageLifecycleState::PageLifecycleState()
    : is_frozen(),
      visibility(),
      is_in_back_forward_cache(),
      pagehide_dispatch() {}

PageLifecycleState::PageLifecycleState(
    bool is_frozen_in,
    ::blink::mojom::PageVisibilityState visibility_in,
    bool is_in_back_forward_cache_in,
    PagehideDispatch pagehide_dispatch_in)
    : is_frozen(std::move(is_frozen_in)),
      visibility(std::move(visibility_in)),
      is_in_back_forward_cache(std::move(is_in_back_forward_cache_in)),
      pagehide_dispatch(std::move(pagehide_dispatch_in)) {}

PageLifecycleState::~PageLifecycleState() = default;
size_t PageLifecycleState::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->is_frozen);
  seed = mojo::internal::Hash(seed, this->visibility);
  seed = mojo::internal::Hash(seed, this->is_in_back_forward_cache);
  seed = mojo::internal::Hash(seed, this->pagehide_dispatch);
  return seed;
}

void PageLifecycleState::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("is_frozen", this->is_frozen);
  value->SetString("visibility", base::trace_event::ValueToString(this->visibility));
  value->SetBoolean("is_in_back_forward_cache", this->is_in_back_forward_cache);
  value->SetString("pagehide_dispatch", base::trace_event::ValueToString(this->pagehide_dispatch));
}

bool PageLifecycleState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PageRestoreParams::PageRestoreParams()
    : navigation_start(),
      pending_history_list_offset(),
      current_history_list_length() {}

PageRestoreParams::PageRestoreParams(
    ::base::TimeTicks navigation_start_in,
    int32_t pending_history_list_offset_in,
    int32_t current_history_list_length_in)
    : navigation_start(std::move(navigation_start_in)),
      pending_history_list_offset(std::move(pending_history_list_offset_in)),
      current_history_list_length(std::move(current_history_list_length_in)) {}

PageRestoreParams::~PageRestoreParams() = default;

void PageRestoreParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("navigation_start", base::trace_event::ValueToString(this->navigation_start, "<value of type ::base::TimeTicks>"));
  value->SetInteger("pending_history_list_offset", this->pending_history_list_offset);
  value->SetInteger("current_history_list_length", this->current_history_list_length);
}

bool PageRestoreParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PageBroadcast::Name_[] = "blink.mojom.PageBroadcast";

class PageBroadcast_SetPageLifecycleState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageBroadcast_SetPageLifecycleState_ForwardToCallback(
      PageBroadcast::SetPageLifecycleStateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PageBroadcast::SetPageLifecycleStateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PageBroadcast_SetPageLifecycleState_ForwardToCallback);
};

PageBroadcastProxy::PageBroadcastProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageBroadcastProxy::SetPageLifecycleState(
    PageLifecycleStatePtr in_state, PageRestoreParamsPtr in_page_restore_params, SetPageLifecycleStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PageBroadcast::SetPageLifecycleState", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_state.is_null()) {
        raw_value->SetString("state", "nullptr");
      } else {
        raw_value->BeginDictionary("state");
        in_state->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_page_restore_params.is_null()) {
        raw_value->SetString("page_restore_params", "nullptr");
      } else {
        raw_value->BeginDictionary("page_restore_params");
        in_page_restore_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPageBroadcast_SetPageLifecycleState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PageBroadcast_SetPageLifecycleState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->state)::BaseType::BufferWriter
      state_writer;
  mojo::internal::Serialize<::blink::mojom::PageLifecycleStateDataView>(
      in_state, buffer, &state_writer, &serialization_context);
  params->state.Set(
      state_writer.is_null() ? nullptr : state_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in PageBroadcast.SetPageLifecycleState request");
  typename decltype(params->page_restore_params)::BaseType::BufferWriter
      page_restore_params_writer;
  mojo::internal::Serialize<::blink::mojom::PageRestoreParamsDataView>(
      in_page_restore_params, buffer, &page_restore_params_writer, &serialization_context);
  params->page_restore_params.Set(
      page_restore_params_writer.is_null() ? nullptr : page_restore_params_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetPageLifecycleState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageBroadcast_SetPageLifecycleState_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PageBroadcastProxy::AudioStateChanged(
    bool in_is_audio_playing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PageBroadcast::AudioStateChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_audio_playing", in_is_audio_playing);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPageBroadcast_AudioStateChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PageBroadcast_AudioStateChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_audio_playing = in_is_audio_playing;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("AudioStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PageBroadcastProxy::SetInsidePortal(
    bool in_is_inside_portal) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PageBroadcast::SetInsidePortal", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_inside_portal", in_is_inside_portal);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPageBroadcast_SetInsidePortal_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PageBroadcast_SetInsidePortal_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_inside_portal = in_is_inside_portal;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetInsidePortal");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PageBroadcastProxy::UpdateWebPreferences(
    const ::blink::web_pref::WebPreferences& in_preferences) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PageBroadcast::UpdateWebPreferences", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("preferences", base::trace_event::ValueToString(in_preferences, "<value of type const ::blink::web_pref::WebPreferences&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPageBroadcast_UpdateWebPreferences_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PageBroadcast_UpdateWebPreferences_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->preferences)::BaseType::BufferWriter
      preferences_writer;
  mojo::internal::Serialize<::blink::mojom::WebPreferencesDataView>(
      in_preferences, buffer, &preferences_writer, &serialization_context);
  params->preferences.Set(
      preferences_writer.is_null() ? nullptr : preferences_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->preferences.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null preferences in PageBroadcast.UpdateWebPreferences request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("UpdateWebPreferences");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class PageBroadcast_SetPageLifecycleState_ProxyToResponder {
 public:
  static PageBroadcast::SetPageLifecycleStateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PageBroadcast_SetPageLifecycleState_ProxyToResponder> proxy(
        new PageBroadcast_SetPageLifecycleState_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PageBroadcast_SetPageLifecycleState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageBroadcast_SetPageLifecycleState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PageBroadcast_SetPageLifecycleState_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PageBroadcast::SetPageLifecycleStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PageBroadcast_SetPageLifecycleState_ProxyToResponder);
};

bool PageBroadcast_SetPageLifecycleState_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PageBroadcast::SetPageLifecycleStateCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PageBroadcast_SetPageLifecycleState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageBroadcast_SetPageLifecycleState_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PageBroadcast_SetPageLifecycleState_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageBroadcast::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PageBroadcast_SetPageLifecycleState_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::PageBroadcast::SetPageLifecycleStateCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPageBroadcast_SetPageLifecycleState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PageBroadcast_SetPageLifecycleState_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PageBroadcast::SetPageLifecycleStateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageBroadcast::Name_);
  message.set_method_name("SetPageLifecycleState");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageBroadcastStubDispatch::Accept(
    PageBroadcast* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPageBroadcast_SetPageLifecycleState_Name: {
      break;
    }
    case internal::kPageBroadcast_AudioStateChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PageBroadcast::AudioStateChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PageBroadcast::AudioStateChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PageBroadcast_AudioStateChanged_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_AudioStateChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_audio_playing{};
      PageBroadcast_AudioStateChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_audio_playing = input_data_view.is_audio_playing();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AudioStateChanged(
std::move(p_is_audio_playing));
      return true;
    }
    case internal::kPageBroadcast_SetInsidePortal_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PageBroadcast::SetInsidePortal",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PageBroadcast::SetInsidePortal");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PageBroadcast_SetInsidePortal_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_SetInsidePortal_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_inside_portal{};
      PageBroadcast_SetInsidePortal_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_inside_portal = input_data_view.is_inside_portal();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInsidePortal(
std::move(p_is_inside_portal));
      return true;
    }
    case internal::kPageBroadcast_UpdateWebPreferences_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PageBroadcast::UpdateWebPreferences",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PageBroadcast::UpdateWebPreferences");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PageBroadcast_UpdateWebPreferences_Params_Data* params =
          reinterpret_cast<internal::PageBroadcast_UpdateWebPreferences_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::web_pref::WebPreferences p_preferences{};
      PageBroadcast_UpdateWebPreferences_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPreferences(&p_preferences))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateWebPreferences(
std::move(p_preferences));
      return true;
    }
  }
  return false;
}

// static
bool PageBroadcastStubDispatch::AcceptWithResponder(
    PageBroadcast* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPageBroadcast_SetPageLifecycleState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PageBroadcast::SetPageLifecycleState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PageBroadcast::SetPageLifecycleState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PageBroadcast_SetPageLifecycleState_Params_Data* params =
          reinterpret_cast<
              internal::PageBroadcast_SetPageLifecycleState_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PageLifecycleStatePtr p_state{};
      PageRestoreParamsPtr p_page_restore_params{};
      PageBroadcast_SetPageLifecycleState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (success && !input_data_view.ReadPageRestoreParams(&p_page_restore_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageBroadcast::Name_, 0, false);
        return false;
      }
      PageBroadcast::SetPageLifecycleStateCallback callback =
          PageBroadcast_SetPageLifecycleState_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPageLifecycleState(
std::move(p_state), 
std::move(p_page_restore_params), std::move(callback));
      return true;
    }
    case internal::kPageBroadcast_AudioStateChanged_Name: {
      break;
    }
    case internal::kPageBroadcast_SetInsidePortal_Name: {
      break;
    }
    case internal::kPageBroadcast_UpdateWebPreferences_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPageBroadcastValidationInfo[] = {
    {&internal::PageBroadcast_SetPageLifecycleState_Params_Data::Validate,
     &internal::PageBroadcast_SetPageLifecycleState_ResponseParams_Data::Validate},
    {&internal::PageBroadcast_AudioStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PageBroadcast_SetInsidePortal_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PageBroadcast_UpdateWebPreferences_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageBroadcastRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PageBroadcast::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPageBroadcastValidationInfo);
}

bool PageBroadcastResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PageBroadcast::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPageBroadcastValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::PageLifecycleState::DataView, ::blink::mojom::PageLifecycleStatePtr>::Read(
    ::blink::mojom::PageLifecycleState::DataView input,
    ::blink::mojom::PageLifecycleStatePtr* output) {
  bool success = true;
  ::blink::mojom::PageLifecycleStatePtr result(::blink::mojom::PageLifecycleState::New());
  
      if (success)
        result->is_frozen = input.is_frozen();
      if (success && !input.ReadVisibility(&result->visibility))
        success = false;
      if (success)
        result->is_in_back_forward_cache = input.is_in_back_forward_cache();
      if (success && !input.ReadPagehideDispatch(&result->pagehide_dispatch))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PageRestoreParams::DataView, ::blink::mojom::PageRestoreParamsPtr>::Read(
    ::blink::mojom::PageRestoreParams::DataView input,
    ::blink::mojom::PageRestoreParamsPtr* output) {
  bool success = true;
  ::blink::mojom::PageRestoreParamsPtr result(::blink::mojom::PageRestoreParams::New());
  
      if (success && !input.ReadNavigationStart(&result->navigation_start))
        success = false;
      if (success)
        result->pending_history_list_offset = input.pending_history_list_offset();
      if (success)
        result->current_history_list_length = input.current_history_list_length();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif