// third_party/blink/public/mojom/page/page.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared.h"
#include "third_party/blink/public/mojom/page/page.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/page/page_visibility_state.mojom-forward.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class PageBroadcastProxy;

template <typename ImplRefTraits>
class PageBroadcastStub;

class PageBroadcastRequestValidator;
class PageBroadcastResponseValidator;


class BLINK_COMMON_EXPORT PageBroadcast
    : public PageBroadcastInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PageBroadcastInterfaceBase;
  using Proxy_ = PageBroadcastProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageBroadcastStub<ImplRefTraits>;

  using RequestValidator_ = PageBroadcastRequestValidator;
  using ResponseValidator_ = PageBroadcastResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetPageLifecycleStateMinVersion = 0,
    kAudioStateChangedMinVersion = 0,
    kSetInsidePortalMinVersion = 0,
    kUpdateWebPreferencesMinVersion = 0,
  };
  virtual ~PageBroadcast() {}


  using SetPageLifecycleStateCallback = base::OnceCallback<void()>;
  
  virtual void SetPageLifecycleState(PageLifecycleStatePtr state, PageRestoreParamsPtr page_restore_params, SetPageLifecycleStateCallback callback) = 0;

  
  virtual void AudioStateChanged(bool is_audio_playing) = 0;

  
  virtual void SetInsidePortal(bool is_inside_portal) = 0;

  
  virtual void UpdateWebPreferences(const ::blink::web_pref::WebPreferences& preferences) = 0;
};



class BLINK_COMMON_EXPORT PageBroadcastProxy
    : public PageBroadcast {
 public:
  using InterfaceType = PageBroadcast;

  explicit PageBroadcastProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetPageLifecycleState(PageLifecycleStatePtr state, PageRestoreParamsPtr page_restore_params, SetPageLifecycleStateCallback callback) final;
  
  void AudioStateChanged(bool is_audio_playing) final;
  
  void SetInsidePortal(bool is_inside_portal) final;
  
  void UpdateWebPreferences(const ::blink::web_pref::WebPreferences& preferences) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT PageBroadcastStubDispatch {
 public:
  static bool Accept(PageBroadcast* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageBroadcast* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageBroadcast>>
class PageBroadcastStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageBroadcastStub() {}
  ~PageBroadcastStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageBroadcastStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageBroadcastStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT PageBroadcastRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT PageBroadcastResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_COMMON_EXPORT PageLifecycleState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageLifecycleState, T>::value>;
  using DataView = PageLifecycleStateDataView;
  using Data_ = internal::PageLifecycleState_Data;

  template <typename... Args>
  static PageLifecycleStatePtr New(Args&&... args) {
    return PageLifecycleStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageLifecycleStatePtr From(const U& u) {
    return mojo::TypeConverter<PageLifecycleStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageLifecycleState>::Convert(*this);
  }


  PageLifecycleState();

  PageLifecycleState(
      bool is_frozen,
      ::blink::mojom::PageVisibilityState visibility,
      bool is_in_back_forward_cache,
      PagehideDispatch pagehide_dispatch);

  ~PageLifecycleState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageLifecycleStatePtr>
  PageLifecycleStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageLifecycleState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageLifecycleState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageLifecycleState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageLifecycleState_UnserializedMessageContext<
            UserType, PageLifecycleState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PageLifecycleState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PageLifecycleState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageLifecycleState_UnserializedMessageContext<
            UserType, PageLifecycleState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageLifecycleState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool is_frozen;
  
  ::blink::mojom::PageVisibilityState visibility;
  
  bool is_in_back_forward_cache;
  
  PagehideDispatch pagehide_dispatch;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageLifecycleState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageLifecycleState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageLifecycleState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageLifecycleState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_COMMON_EXPORT PageRestoreParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageRestoreParams, T>::value>;
  using DataView = PageRestoreParamsDataView;
  using Data_ = internal::PageRestoreParams_Data;

  template <typename... Args>
  static PageRestoreParamsPtr New(Args&&... args) {
    return PageRestoreParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageRestoreParamsPtr From(const U& u) {
    return mojo::TypeConverter<PageRestoreParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageRestoreParams>::Convert(*this);
  }


  PageRestoreParams();

  PageRestoreParams(
      ::base::TimeTicks navigation_start,
      int32_t pending_history_list_offset,
      int32_t current_history_list_length);

  ~PageRestoreParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageRestoreParamsPtr>
  PageRestoreParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageRestoreParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageRestoreParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageRestoreParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageRestoreParams_UnserializedMessageContext<
            UserType, PageRestoreParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PageRestoreParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PageRestoreParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageRestoreParams_UnserializedMessageContext<
            UserType, PageRestoreParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageRestoreParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::TimeTicks navigation_start;
  
  int32_t pending_history_list_offset;
  
  int32_t current_history_list_length;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageRestoreParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageRestoreParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageRestoreParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageRestoreParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PageLifecycleStatePtr PageLifecycleState::Clone() const {
  return New(
      mojo::Clone(is_frozen),
      mojo::Clone(visibility),
      mojo::Clone(is_in_back_forward_cache),
      mojo::Clone(pagehide_dispatch)
  );
}

template <typename T, PageLifecycleState::EnableIfSame<T>*>
bool PageLifecycleState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_frozen, other_struct.is_frozen))
    return false;
  if (!mojo::Equals(this->visibility, other_struct.visibility))
    return false;
  if (!mojo::Equals(this->is_in_back_forward_cache, other_struct.is_in_back_forward_cache))
    return false;
  if (!mojo::Equals(this->pagehide_dispatch, other_struct.pagehide_dispatch))
    return false;
  return true;
}

template <typename T, PageLifecycleState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.is_frozen, rhs.is_frozen))
    return true;
  if (std::less<>{}(rhs.is_frozen, lhs.is_frozen))
    return false;
  if (std::less<>{}(lhs.visibility, rhs.visibility))
    return true;
  if (std::less<>{}(rhs.visibility, lhs.visibility))
    return false;
  if (std::less<>{}(lhs.is_in_back_forward_cache, rhs.is_in_back_forward_cache))
    return true;
  if (std::less<>{}(rhs.is_in_back_forward_cache, lhs.is_in_back_forward_cache))
    return false;
  if (std::less<>{}(lhs.pagehide_dispatch, rhs.pagehide_dispatch))
    return true;
  if (std::less<>{}(rhs.pagehide_dispatch, lhs.pagehide_dispatch))
    return false;
  return false;
}
template <typename StructPtrType>
PageRestoreParamsPtr PageRestoreParams::Clone() const {
  return New(
      mojo::Clone(navigation_start),
      mojo::Clone(pending_history_list_offset),
      mojo::Clone(current_history_list_length)
  );
}

template <typename T, PageRestoreParams::EnableIfSame<T>*>
bool PageRestoreParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->navigation_start, other_struct.navigation_start))
    return false;
  if (!mojo::Equals(this->pending_history_list_offset, other_struct.pending_history_list_offset))
    return false;
  if (!mojo::Equals(this->current_history_list_length, other_struct.current_history_list_length))
    return false;
  return true;
}

template <typename T, PageRestoreParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.navigation_start, rhs.navigation_start))
    return true;
  if (std::less<>{}(rhs.navigation_start, lhs.navigation_start))
    return false;
  if (std::less<>{}(lhs.pending_history_list_offset, rhs.pending_history_list_offset))
    return true;
  if (std::less<>{}(rhs.pending_history_list_offset, lhs.pending_history_list_offset))
    return false;
  if (std::less<>{}(lhs.current_history_list_length, rhs.current_history_list_length))
    return true;
  if (std::less<>{}(rhs.current_history_list_length, lhs.current_history_list_length))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PageLifecycleState::DataView,
                                         ::blink::mojom::PageLifecycleStatePtr> {
  static bool IsNull(const ::blink::mojom::PageLifecycleStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PageLifecycleStatePtr* output) { output->reset(); }

  static decltype(::blink::mojom::PageLifecycleState::is_frozen) is_frozen(
      const ::blink::mojom::PageLifecycleStatePtr& input) {
    return input->is_frozen;
  }

  static decltype(::blink::mojom::PageLifecycleState::visibility) visibility(
      const ::blink::mojom::PageLifecycleStatePtr& input) {
    return input->visibility;
  }

  static decltype(::blink::mojom::PageLifecycleState::is_in_back_forward_cache) is_in_back_forward_cache(
      const ::blink::mojom::PageLifecycleStatePtr& input) {
    return input->is_in_back_forward_cache;
  }

  static decltype(::blink::mojom::PageLifecycleState::pagehide_dispatch) pagehide_dispatch(
      const ::blink::mojom::PageLifecycleStatePtr& input) {
    return input->pagehide_dispatch;
  }

  static bool Read(::blink::mojom::PageLifecycleState::DataView input, ::blink::mojom::PageLifecycleStatePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PageRestoreParams::DataView,
                                         ::blink::mojom::PageRestoreParamsPtr> {
  static bool IsNull(const ::blink::mojom::PageRestoreParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PageRestoreParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PageRestoreParams::navigation_start)& navigation_start(
      const ::blink::mojom::PageRestoreParamsPtr& input) {
    return input->navigation_start;
  }

  static decltype(::blink::mojom::PageRestoreParams::pending_history_list_offset) pending_history_list_offset(
      const ::blink::mojom::PageRestoreParamsPtr& input) {
    return input->pending_history_list_offset;
  }

  static decltype(::blink::mojom::PageRestoreParams::current_history_list_length) current_history_list_length(
      const ::blink::mojom::PageRestoreParamsPtr& input) {
    return input->current_history_list_length;
  }

  static bool Read(::blink::mojom::PageRestoreParams::DataView input, ::blink::mojom::PageRestoreParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_H_