// third_party/blink/public/mojom/prerender/prerender.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/prerender/prerender.mojom-shared.h"
#include "third_party/blink/public/mojom/prerender/prerender.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"




namespace WTF {
struct blink_mojom_internal_PrerenderRelType_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::PrerenderRelType& value) {
    using utype = std::underlying_type<::blink::mojom::PrerenderRelType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::PrerenderRelType& left, const ::blink::mojom::PrerenderRelType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::PrerenderRelType>
    : public GenericHashTraits<::blink::mojom::PrerenderRelType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::PrerenderRelType& value) {
    return value == static_cast<::blink::mojom::PrerenderRelType>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::PrerenderRelType& slot, bool) {
    slot = static_cast<::blink::mojom::PrerenderRelType>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::PrerenderRelType& value) {
    return value == static_cast<::blink::mojom::PrerenderRelType>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class PrerenderProcessorClientProxy;

template <typename ImplRefTraits>
class PrerenderProcessorClientStub;

class PrerenderProcessorClientRequestValidator;


class PLATFORM_EXPORT PrerenderProcessorClient
    : public PrerenderProcessorClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PrerenderProcessorClientInterfaceBase;
  using Proxy_ = PrerenderProcessorClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrerenderProcessorClientStub<ImplRefTraits>;

  using RequestValidator_ = PrerenderProcessorClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnPrerenderStartMinVersion = 0,
    kOnPrerenderStopLoadingMinVersion = 0,
    kOnPrerenderDomContentLoadedMinVersion = 0,
    kOnPrerenderStopMinVersion = 0,
  };
  virtual ~PrerenderProcessorClient() {}

  
  virtual void OnPrerenderStart() = 0;

  
  virtual void OnPrerenderStopLoading() = 0;

  
  virtual void OnPrerenderDomContentLoaded() = 0;

  
  virtual void OnPrerenderStop() = 0;
};

class PrerenderProcessorProxy;

template <typename ImplRefTraits>
class PrerenderProcessorStub;

class PrerenderProcessorRequestValidator;


class PLATFORM_EXPORT PrerenderProcessor
    : public PrerenderProcessorInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PrerenderProcessorInterfaceBase;
  using Proxy_ = PrerenderProcessorProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrerenderProcessorStub<ImplRefTraits>;

  using RequestValidator_ = PrerenderProcessorRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartMinVersion = 0,
    kCancelMinVersion = 0,
    kAbandonMinVersion = 0,
  };
  virtual ~PrerenderProcessor() {}

  
  virtual void Start(PrerenderAttributesPtr prerender_attribute, ::mojo::PendingRemote<PrerenderProcessorClient> prerender_processor_client) = 0;

  
  virtual void Cancel() = 0;

  
  virtual void Abandon() = 0;
};



class PLATFORM_EXPORT PrerenderProcessorClientProxy
    : public PrerenderProcessorClient {
 public:
  using InterfaceType = PrerenderProcessorClient;

  explicit PrerenderProcessorClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPrerenderStart() final;
  
  void OnPrerenderStopLoading() final;
  
  void OnPrerenderDomContentLoaded() final;
  
  void OnPrerenderStop() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT PrerenderProcessorProxy
    : public PrerenderProcessor {
 public:
  using InterfaceType = PrerenderProcessor;

  explicit PrerenderProcessorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Start(PrerenderAttributesPtr prerender_attribute, ::mojo::PendingRemote<PrerenderProcessorClient> prerender_processor_client) final;
  
  void Cancel() final;
  
  void Abandon() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT PrerenderProcessorClientStubDispatch {
 public:
  static bool Accept(PrerenderProcessorClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrerenderProcessorClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrerenderProcessorClient>>
class PrerenderProcessorClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrerenderProcessorClientStub() {}
  ~PrerenderProcessorClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrerenderProcessorClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrerenderProcessorClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PrerenderProcessorStubDispatch {
 public:
  static bool Accept(PrerenderProcessor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrerenderProcessor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrerenderProcessor>>
class PrerenderProcessorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrerenderProcessorStub() {}
  ~PrerenderProcessorStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrerenderProcessorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrerenderProcessorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PrerenderProcessorClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PrerenderProcessorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT PrerenderAttributes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrerenderAttributes, T>::value>;
  using DataView = PrerenderAttributesDataView;
  using Data_ = internal::PrerenderAttributes_Data;

  template <typename... Args>
  static PrerenderAttributesPtr New(Args&&... args) {
    return PrerenderAttributesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrerenderAttributesPtr From(const U& u) {
    return mojo::TypeConverter<PrerenderAttributesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrerenderAttributes>::Convert(*this);
  }


  PrerenderAttributes();

  PrerenderAttributes(
      const ::blink::KURL& url,
      PrerenderRelType rel_type,
      ::blink::mojom::blink::ReferrerPtr referrer,
      const ::gfx::Size& view_size);

  ~PrerenderAttributes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrerenderAttributesPtr>
  PrerenderAttributesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrerenderAttributes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrerenderAttributes::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrerenderAttributes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrerenderAttributes_UnserializedMessageContext<
            UserType, PrerenderAttributes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PrerenderAttributes::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PrerenderAttributes::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrerenderAttributes_UnserializedMessageContext<
            UserType, PrerenderAttributes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrerenderAttributes::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::KURL url;
  
  PrerenderRelType rel_type;
  
  ::blink::mojom::blink::ReferrerPtr referrer;
  
  ::gfx::Size view_size;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PrerenderAttributes);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrerenderAttributes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrerenderAttributes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrerenderAttributes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrerenderAttributes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PrerenderAttributesPtr PrerenderAttributes::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(rel_type),
      mojo::Clone(referrer),
      mojo::Clone(view_size)
  );
}

template <typename T, PrerenderAttributes::EnableIfSame<T>*>
bool PrerenderAttributes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->rel_type, other_struct.rel_type))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->view_size, other_struct.view_size))
    return false;
  return true;
}

template <typename T, PrerenderAttributes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.rel_type, rhs.rel_type))
    return true;
  if (std::less<>{}(rhs.rel_type, lhs.rel_type))
    return false;
  if (std::less<>{}(lhs.referrer, rhs.referrer))
    return true;
  if (std::less<>{}(rhs.referrer, lhs.referrer))
    return false;
  if (std::less<>{}(lhs.view_size, rhs.view_size))
    return true;
  if (std::less<>{}(rhs.view_size, lhs.view_size))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PrerenderAttributes::DataView,
                                         ::blink::mojom::blink::PrerenderAttributesPtr> {
  static bool IsNull(const ::blink::mojom::blink::PrerenderAttributesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PrerenderAttributesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PrerenderAttributes::url)& url(
      const ::blink::mojom::blink::PrerenderAttributesPtr& input) {
    return input->url;
  }

  static decltype(::blink::mojom::blink::PrerenderAttributes::rel_type) rel_type(
      const ::blink::mojom::blink::PrerenderAttributesPtr& input) {
    return input->rel_type;
  }

  static const decltype(::blink::mojom::blink::PrerenderAttributes::referrer)& referrer(
      const ::blink::mojom::blink::PrerenderAttributesPtr& input) {
    return input->referrer;
  }

  static const decltype(::blink::mojom::blink::PrerenderAttributes::view_size)& view_size(
      const ::blink::mojom::blink::PrerenderAttributesPtr& input) {
    return input->view_size;
  }

  static bool Read(::blink::mojom::blink::PrerenderAttributes::DataView input, ::blink::mojom::blink::PrerenderAttributesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_BLINK_H_