// third_party/blink/public/mojom/service_worker/embedded_worker.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.h"
#include "third_party/blink/public/mojom/worker/subresource_loader_updater.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-shared.h"
#include "third_party/blink/public/mojom/renderer_preference_watcher.mojom-shared.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_provider.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-shared.h"
#include "third_party/blink/public/mojom/worker/worker_content_settings_proxy.mojom-shared.h"
#include "third_party/blink/public/mojom/web_feature/web_feature.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class EmbeddedWorkerStartParamsDataView;

class EmbeddedWorkerStartTimingDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::EmbeddedWorkerStartParamsDataView> {
  using Data = ::blink::mojom::internal::EmbeddedWorkerStartParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::EmbeddedWorkerStartTimingDataView> {
  using Data = ::blink::mojom::internal::EmbeddedWorkerStartTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {
// Interface base classes. They are used for type safety check.
class EmbeddedWorkerInstanceClientInterfaceBase {};

using EmbeddedWorkerInstanceClientPtrDataView =
    mojo::InterfacePtrDataView<EmbeddedWorkerInstanceClientInterfaceBase>;
using EmbeddedWorkerInstanceClientRequestDataView =
    mojo::InterfaceRequestDataView<EmbeddedWorkerInstanceClientInterfaceBase>;
using EmbeddedWorkerInstanceClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<EmbeddedWorkerInstanceClientInterfaceBase>;
using EmbeddedWorkerInstanceClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<EmbeddedWorkerInstanceClientInterfaceBase>;
class EmbeddedWorkerInstanceHostInterfaceBase {};

using EmbeddedWorkerInstanceHostPtrDataView =
    mojo::InterfacePtrDataView<EmbeddedWorkerInstanceHostInterfaceBase>;
using EmbeddedWorkerInstanceHostRequestDataView =
    mojo::InterfaceRequestDataView<EmbeddedWorkerInstanceHostInterfaceBase>;
using EmbeddedWorkerInstanceHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<EmbeddedWorkerInstanceHostInterfaceBase>;
using EmbeddedWorkerInstanceHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<EmbeddedWorkerInstanceHostInterfaceBase>;


class EmbeddedWorkerStartParamsDataView {
 public:
  EmbeddedWorkerStartParamsDataView() {}

  EmbeddedWorkerStartParamsDataView(
      internal::EmbeddedWorkerStartParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int64_t service_worker_version_id() const {
    return data_->service_worker_version_id;
  }
  inline void GetScopeDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScope(UserType* output) {
    
    auto* pointer = data_->scope.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetScriptUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScriptUrl(UserType* output) {
    
    auto* pointer = data_->script_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScriptType(UserType* output) const {
    auto data_value = data_->script_type;
    return mojo::internal::Deserialize<::blink::mojom::ScriptType>(
        data_value, output);
  }

  ::blink::mojom::ScriptType script_type() const {
    return static_cast<::blink::mojom::ScriptType>(data_->script_type);
  }
  inline void GetOutsideFetchClientSettingsObjectDataView(
      ::blink::mojom::FetchClientSettingsObjectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOutsideFetchClientSettingsObject(UserType* output) {
    
    auto* pointer = data_->outside_fetch_client_settings_object.Get();
    return mojo::internal::Deserialize<::blink::mojom::FetchClientSettingsObjectDataView>(
        pointer, output, context_);
  }
  inline void GetUserAgentDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUserAgent(UserType* output) {
    
    auto* pointer = data_->user_agent.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetUaMetadataDataView(
      ::blink::mojom::UserAgentMetadataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUaMetadata(UserType* output) {
    
    auto* pointer = data_->ua_metadata.Get();
    return mojo::internal::Deserialize<::blink::mojom::UserAgentMetadataDataView>(
        pointer, output, context_);
  }
  int32_t service_worker_route_id() const {
    return data_->service_worker_route_id;
  }
  inline void GetDevtoolsWorkerTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDevtoolsWorkerToken(UserType* output) {
    
    auto* pointer = data_->devtools_worker_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  inline void GetScriptUrlToSkipThrottlingDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScriptUrlToSkipThrottling(UserType* output) {
    
    auto* pointer = data_->script_url_to_skip_throttling.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  bool wait_for_debugger() const {
    return data_->wait_for_debugger;
  }
  bool is_installed() const {
    return data_->is_installed;
  }
  inline void GetRendererPreferencesDataView(
      ::blink::mojom::RendererPreferencesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRendererPreferences(UserType* output) {
    
    auto* pointer = data_->renderer_preferences.Get();
    return mojo::internal::Deserialize<::blink::mojom::RendererPreferencesDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeServiceWorkerReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::ServiceWorkerInterfaceBase>>(
            &data_->service_worker_receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeControllerReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::ControllerServiceWorkerInterfaceBase>>(
            &data_->controller_receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetInstalledScriptsInfoDataView(
      ::blink::mojom::ServiceWorkerInstalledScriptsInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInstalledScriptsInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ServiceWorkerInstalledScriptsInfoDataView, UserType>(),
    "Attempting to read the optional `installed_scripts_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInstalledScriptsInfo` instead "
    "of `ReadInstalledScriptsInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->installed_scripts_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerInstalledScriptsInfoDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeInstanceHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::EmbeddedWorkerInstanceHostAssociatedPtrInfoDataView>(
            &data_->instance_host, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetProviderInfoDataView(
      ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadProviderInfo(UserType* output) {
    
    auto* pointer = data_->provider_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerProviderInfoForStartWorkerDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeContentSettingsProxy() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::WorkerContentSettingsProxyInterfaceBase>>(
            &data_->content_settings_proxy, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakePreferenceWatcherReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::RendererPreferenceWatcherInterfaceBase>>(
            &data_->preference_watcher_receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetSubresourceLoaderFactoriesDataView(
      ::blink::mojom::URLLoaderFactoryBundleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSubresourceLoaderFactories(UserType* output) {
    
    auto* pointer = data_->subresource_loader_factories.Get();
    return mojo::internal::Deserialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeSubresourceLoaderUpdater() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::SubresourceLoaderUpdaterInterfaceBase>>(
            &data_->subresource_loader_updater, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetServiceWorkerTokenDataView(
      ::blink::mojom::ServiceWorkerTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadServiceWorkerToken(UserType* output) {
    
    auto* pointer = data_->service_worker_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerTokenDataView>(
        pointer, output, context_);
  }
  int64_t ukm_source_id() const {
    return data_->ukm_source_id;
  }
 private:
  internal::EmbeddedWorkerStartParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class EmbeddedWorkerStartTimingDataView {
 public:
  EmbeddedWorkerStartTimingDataView() {}

  EmbeddedWorkerStartTimingDataView(
      internal::EmbeddedWorkerStartTiming_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetStartWorkerReceivedTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStartWorkerReceivedTime(UserType* output) {
    
    auto* pointer = data_->start_worker_received_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetScriptEvaluationStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScriptEvaluationStartTime(UserType* output) {
    
    auto* pointer = data_->script_evaluation_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetScriptEvaluationEndTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScriptEvaluationEndTime(UserType* output) {
    
    auto* pointer = data_->script_evaluation_end_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
 private:
  internal::EmbeddedWorkerStartTiming_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EmbeddedWorkerStartParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::EmbeddedWorkerStartParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::EmbeddedWorkerStartParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->service_worker_version_id = Traits::service_worker_version_id(input);
    decltype(Traits::scope(input)) in_scope = Traits::scope(input);
    typename decltype((*output)->scope)::BaseType::BufferWriter
        scope_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_scope, buffer, &scope_writer, context);
    (*output)->scope.Set(
        scope_writer.is_null() ? nullptr : scope_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->scope.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scope in EmbeddedWorkerStartParams struct");
    decltype(Traits::script_url(input)) in_script_url = Traits::script_url(input);
    typename decltype((*output)->script_url)::BaseType::BufferWriter
        script_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_script_url, buffer, &script_url_writer, context);
    (*output)->script_url.Set(
        script_url_writer.is_null() ? nullptr : script_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->script_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null script_url in EmbeddedWorkerStartParams struct");
    mojo::internal::Serialize<::blink::mojom::ScriptType>(
        Traits::script_type(input), &(*output)->script_type);
    decltype(Traits::outside_fetch_client_settings_object(input)) in_outside_fetch_client_settings_object = Traits::outside_fetch_client_settings_object(input);
    typename decltype((*output)->outside_fetch_client_settings_object)::BaseType::BufferWriter
        outside_fetch_client_settings_object_writer;
    mojo::internal::Serialize<::blink::mojom::FetchClientSettingsObjectDataView>(
        in_outside_fetch_client_settings_object, buffer, &outside_fetch_client_settings_object_writer, context);
    (*output)->outside_fetch_client_settings_object.Set(
        outside_fetch_client_settings_object_writer.is_null() ? nullptr : outside_fetch_client_settings_object_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->outside_fetch_client_settings_object.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null outside_fetch_client_settings_object in EmbeddedWorkerStartParams struct");
    decltype(Traits::user_agent(input)) in_user_agent = Traits::user_agent(input);
    typename decltype((*output)->user_agent)::BaseType::BufferWriter
        user_agent_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_user_agent, buffer, &user_agent_writer, context);
    (*output)->user_agent.Set(
        user_agent_writer.is_null() ? nullptr : user_agent_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->user_agent.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null user_agent in EmbeddedWorkerStartParams struct");
    decltype(Traits::ua_metadata(input)) in_ua_metadata = Traits::ua_metadata(input);
    typename decltype((*output)->ua_metadata)::BaseType::BufferWriter
        ua_metadata_writer;
    mojo::internal::Serialize<::blink::mojom::UserAgentMetadataDataView>(
        in_ua_metadata, buffer, &ua_metadata_writer, context);
    (*output)->ua_metadata.Set(
        ua_metadata_writer.is_null() ? nullptr : ua_metadata_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->ua_metadata.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ua_metadata in EmbeddedWorkerStartParams struct");
    (*output)->service_worker_route_id = Traits::service_worker_route_id(input);
    decltype(Traits::devtools_worker_token(input)) in_devtools_worker_token = Traits::devtools_worker_token(input);
    typename decltype((*output)->devtools_worker_token)::BaseType::BufferWriter
        devtools_worker_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_devtools_worker_token, buffer, &devtools_worker_token_writer, context);
    (*output)->devtools_worker_token.Set(
        devtools_worker_token_writer.is_null() ? nullptr : devtools_worker_token_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->devtools_worker_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null devtools_worker_token in EmbeddedWorkerStartParams struct");
    decltype(Traits::script_url_to_skip_throttling(input)) in_script_url_to_skip_throttling = Traits::script_url_to_skip_throttling(input);
    typename decltype((*output)->script_url_to_skip_throttling)::BaseType::BufferWriter
        script_url_to_skip_throttling_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_script_url_to_skip_throttling, buffer, &script_url_to_skip_throttling_writer, context);
    (*output)->script_url_to_skip_throttling.Set(
        script_url_to_skip_throttling_writer.is_null() ? nullptr : script_url_to_skip_throttling_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->script_url_to_skip_throttling.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null script_url_to_skip_throttling in EmbeddedWorkerStartParams struct");
    (*output)->wait_for_debugger = Traits::wait_for_debugger(input);
    (*output)->is_installed = Traits::is_installed(input);
    decltype(Traits::renderer_preferences(input)) in_renderer_preferences = Traits::renderer_preferences(input);
    typename decltype((*output)->renderer_preferences)::BaseType::BufferWriter
        renderer_preferences_writer;
    mojo::internal::Serialize<::blink::mojom::RendererPreferencesDataView>(
        in_renderer_preferences, buffer, &renderer_preferences_writer, context);
    (*output)->renderer_preferences.Set(
        renderer_preferences_writer.is_null() ? nullptr : renderer_preferences_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->renderer_preferences.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null renderer_preferences in EmbeddedWorkerStartParams struct");
    decltype(Traits::service_worker_receiver(input)) in_service_worker_receiver = Traits::service_worker_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ServiceWorkerInterfaceBase>>(
        in_service_worker_receiver, &(*output)->service_worker_receiver, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->service_worker_receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid service_worker_receiver in EmbeddedWorkerStartParams struct");
    decltype(Traits::controller_receiver(input)) in_controller_receiver = Traits::controller_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ControllerServiceWorkerInterfaceBase>>(
        in_controller_receiver, &(*output)->controller_receiver, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->controller_receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid controller_receiver in EmbeddedWorkerStartParams struct");
    decltype(Traits::installed_scripts_info(input)) in_installed_scripts_info = Traits::installed_scripts_info(input);
    typename decltype((*output)->installed_scripts_info)::BaseType::BufferWriter
        installed_scripts_info_writer;
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerInstalledScriptsInfoDataView>(
        in_installed_scripts_info, buffer, &installed_scripts_info_writer, context);
    (*output)->installed_scripts_info.Set(
        installed_scripts_info_writer.is_null() ? nullptr : installed_scripts_info_writer.data());
    decltype(Traits::instance_host(input)) in_instance_host = Traits::instance_host(input);
    mojo::internal::Serialize<::blink::mojom::EmbeddedWorkerInstanceHostAssociatedPtrInfoDataView>(
        in_instance_host, &(*output)->instance_host, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->instance_host),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid instance_host in EmbeddedWorkerStartParams struct");
    decltype(Traits::provider_info(input)) in_provider_info = Traits::provider_info(input);
    typename decltype((*output)->provider_info)::BaseType::BufferWriter
        provider_info_writer;
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerProviderInfoForStartWorkerDataView>(
        in_provider_info, buffer, &provider_info_writer, context);
    (*output)->provider_info.Set(
        provider_info_writer.is_null() ? nullptr : provider_info_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->provider_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null provider_info in EmbeddedWorkerStartParams struct");
    decltype(Traits::content_settings_proxy(input)) in_content_settings_proxy = Traits::content_settings_proxy(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::WorkerContentSettingsProxyInterfaceBase>>(
        in_content_settings_proxy, &(*output)->content_settings_proxy, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->content_settings_proxy),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid content_settings_proxy in EmbeddedWorkerStartParams struct");
    decltype(Traits::preference_watcher_receiver(input)) in_preference_watcher_receiver = Traits::preference_watcher_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::RendererPreferenceWatcherInterfaceBase>>(
        in_preference_watcher_receiver, &(*output)->preference_watcher_receiver, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->preference_watcher_receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid preference_watcher_receiver in EmbeddedWorkerStartParams struct");
    decltype(Traits::subresource_loader_factories(input)) in_subresource_loader_factories = Traits::subresource_loader_factories(input);
    typename decltype((*output)->subresource_loader_factories)::BaseType::BufferWriter
        subresource_loader_factories_writer;
    mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
        in_subresource_loader_factories, buffer, &subresource_loader_factories_writer, context);
    (*output)->subresource_loader_factories.Set(
        subresource_loader_factories_writer.is_null() ? nullptr : subresource_loader_factories_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->subresource_loader_factories.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subresource_loader_factories in EmbeddedWorkerStartParams struct");
    decltype(Traits::subresource_loader_updater(input)) in_subresource_loader_updater = Traits::subresource_loader_updater(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SubresourceLoaderUpdaterInterfaceBase>>(
        in_subresource_loader_updater, &(*output)->subresource_loader_updater, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->subresource_loader_updater),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid subresource_loader_updater in EmbeddedWorkerStartParams struct");
    decltype(Traits::service_worker_token(input)) in_service_worker_token = Traits::service_worker_token(input);
    typename decltype((*output)->service_worker_token)::BaseType::BufferWriter
        service_worker_token_writer;
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerTokenDataView>(
        in_service_worker_token, buffer, &service_worker_token_writer, context);
    (*output)->service_worker_token.Set(
        service_worker_token_writer.is_null() ? nullptr : service_worker_token_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->service_worker_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null service_worker_token in EmbeddedWorkerStartParams struct");
    (*output)->ukm_source_id = Traits::ukm_source_id(input);
  }

  static bool Deserialize(::blink::mojom::internal::EmbeddedWorkerStartParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::EmbeddedWorkerStartParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EmbeddedWorkerStartTimingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::EmbeddedWorkerStartTimingDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::EmbeddedWorkerStartTiming_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::start_worker_received_time(input)) in_start_worker_received_time = Traits::start_worker_received_time(input);
    typename decltype((*output)->start_worker_received_time)::BaseType::BufferWriter
        start_worker_received_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_start_worker_received_time, buffer, &start_worker_received_time_writer, context);
    (*output)->start_worker_received_time.Set(
        start_worker_received_time_writer.is_null() ? nullptr : start_worker_received_time_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->start_worker_received_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_worker_received_time in EmbeddedWorkerStartTiming struct");
    decltype(Traits::script_evaluation_start_time(input)) in_script_evaluation_start_time = Traits::script_evaluation_start_time(input);
    typename decltype((*output)->script_evaluation_start_time)::BaseType::BufferWriter
        script_evaluation_start_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_script_evaluation_start_time, buffer, &script_evaluation_start_time_writer, context);
    (*output)->script_evaluation_start_time.Set(
        script_evaluation_start_time_writer.is_null() ? nullptr : script_evaluation_start_time_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->script_evaluation_start_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null script_evaluation_start_time in EmbeddedWorkerStartTiming struct");
    decltype(Traits::script_evaluation_end_time(input)) in_script_evaluation_end_time = Traits::script_evaluation_end_time(input);
    typename decltype((*output)->script_evaluation_end_time)::BaseType::BufferWriter
        script_evaluation_end_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_script_evaluation_end_time, buffer, &script_evaluation_end_time_writer, context);
    (*output)->script_evaluation_end_time.Set(
        script_evaluation_end_time_writer.is_null() ? nullptr : script_evaluation_end_time_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->script_evaluation_end_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null script_evaluation_end_time in EmbeddedWorkerStartTiming struct");
  }

  static bool Deserialize(::blink::mojom::internal::EmbeddedWorkerStartTiming_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::EmbeddedWorkerStartTimingDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void EmbeddedWorkerStartParamsDataView::GetScopeDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->scope.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void EmbeddedWorkerStartParamsDataView::GetScriptUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->script_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void EmbeddedWorkerStartParamsDataView::GetOutsideFetchClientSettingsObjectDataView(
    ::blink::mojom::FetchClientSettingsObjectDataView* output) {
  auto pointer = data_->outside_fetch_client_settings_object.Get();
  *output = ::blink::mojom::FetchClientSettingsObjectDataView(pointer, context_);
}
inline void EmbeddedWorkerStartParamsDataView::GetUserAgentDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->user_agent.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void EmbeddedWorkerStartParamsDataView::GetUaMetadataDataView(
    ::blink::mojom::UserAgentMetadataDataView* output) {
  auto pointer = data_->ua_metadata.Get();
  *output = ::blink::mojom::UserAgentMetadataDataView(pointer, context_);
}
inline void EmbeddedWorkerStartParamsDataView::GetDevtoolsWorkerTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_worker_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void EmbeddedWorkerStartParamsDataView::GetScriptUrlToSkipThrottlingDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->script_url_to_skip_throttling.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void EmbeddedWorkerStartParamsDataView::GetRendererPreferencesDataView(
    ::blink::mojom::RendererPreferencesDataView* output) {
  auto pointer = data_->renderer_preferences.Get();
  *output = ::blink::mojom::RendererPreferencesDataView(pointer, context_);
}
inline void EmbeddedWorkerStartParamsDataView::GetInstalledScriptsInfoDataView(
    ::blink::mojom::ServiceWorkerInstalledScriptsInfoDataView* output) {
  auto pointer = data_->installed_scripts_info.Get();
  *output = ::blink::mojom::ServiceWorkerInstalledScriptsInfoDataView(pointer, context_);
}
inline void EmbeddedWorkerStartParamsDataView::GetProviderInfoDataView(
    ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerDataView* output) {
  auto pointer = data_->provider_info.Get();
  *output = ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerDataView(pointer, context_);
}
inline void EmbeddedWorkerStartParamsDataView::GetSubresourceLoaderFactoriesDataView(
    ::blink::mojom::URLLoaderFactoryBundleDataView* output) {
  auto pointer = data_->subresource_loader_factories.Get();
  *output = ::blink::mojom::URLLoaderFactoryBundleDataView(pointer, context_);
}
inline void EmbeddedWorkerStartParamsDataView::GetServiceWorkerTokenDataView(
    ::blink::mojom::ServiceWorkerTokenDataView* output) {
  auto pointer = data_->service_worker_token.Get();
  *output = ::blink::mojom::ServiceWorkerTokenDataView(pointer, context_);
}


inline void EmbeddedWorkerStartTimingDataView::GetStartWorkerReceivedTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->start_worker_received_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void EmbeddedWorkerStartTimingDataView::GetScriptEvaluationStartTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->script_evaluation_start_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void EmbeddedWorkerStartTimingDataView::GetScriptEvaluationEndTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->script_evaluation_end_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_SHARED_H_