// third_party/blink/public/mojom/service_worker/embedded_worker.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-forward.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom-forward.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-forward.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom.h"
#include "third_party/blink/public/mojom/worker/subresource_loader_updater.mojom.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom.h"
#include "third_party/blink/public/mojom/renderer_preference_watcher.mojom.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_provider.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom.h"
#include "third_party/blink/public/mojom/worker/worker_content_settings_proxy.mojom.h"
#include "third_party/blink/public/mojom/web_feature/web_feature.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class EmbeddedWorkerInstanceClientProxy;

template <typename ImplRefTraits>
class EmbeddedWorkerInstanceClientStub;

class EmbeddedWorkerInstanceClientRequestValidator;


class BLINK_COMMON_EXPORT EmbeddedWorkerInstanceClient
    : public EmbeddedWorkerInstanceClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = EmbeddedWorkerInstanceClientInterfaceBase;
  using Proxy_ = EmbeddedWorkerInstanceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = EmbeddedWorkerInstanceClientStub<ImplRefTraits>;

  using RequestValidator_ = EmbeddedWorkerInstanceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartWorkerMinVersion = 0,
    kStopWorkerMinVersion = 0,
  };
  virtual ~EmbeddedWorkerInstanceClient() {}

  
  virtual void StartWorker(EmbeddedWorkerStartParamsPtr params) = 0;

  
  virtual void StopWorker() = 0;
};

class EmbeddedWorkerInstanceHostProxy;

template <typename ImplRefTraits>
class EmbeddedWorkerInstanceHostStub;

class EmbeddedWorkerInstanceHostRequestValidator;
class EmbeddedWorkerInstanceHostResponseValidator;


class BLINK_COMMON_EXPORT EmbeddedWorkerInstanceHost
    : public EmbeddedWorkerInstanceHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = EmbeddedWorkerInstanceHostInterfaceBase;
  using Proxy_ = EmbeddedWorkerInstanceHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = EmbeddedWorkerInstanceHostStub<ImplRefTraits>;

  using RequestValidator_ = EmbeddedWorkerInstanceHostRequestValidator;
  using ResponseValidator_ = EmbeddedWorkerInstanceHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestTerminationMinVersion = 0,
    kCountFeatureMinVersion = 0,
    kOnReadyForInspectionMinVersion = 0,
    kOnScriptLoadedMinVersion = 0,
    kOnScriptEvaluationStartMinVersion = 0,
    kOnStartedMinVersion = 0,
    kOnReportExceptionMinVersion = 0,
    kOnReportConsoleMessageMinVersion = 0,
    kOnStoppedMinVersion = 0,
  };
  virtual ~EmbeddedWorkerInstanceHost() {}


  using RequestTerminationCallback = base::OnceCallback<void(bool)>;
  
  virtual void RequestTermination(RequestTerminationCallback callback) = 0;

  
  virtual void CountFeature(::blink::mojom::WebFeature feature) = 0;

  
  virtual void OnReadyForInspection(::mojo::PendingRemote<::blink::mojom::DevToolsAgent> agent, ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> agent_host) = 0;

  
  virtual void OnScriptLoaded() = 0;

  
  virtual void OnScriptEvaluationStart() = 0;

  
  virtual void OnStarted(::blink::mojom::ServiceWorkerStartStatus status, bool has_fetch_handler, int32_t thread_id, EmbeddedWorkerStartTimingPtr start_timing) = 0;

  
  virtual void OnReportException(const ::base::string16& error_message, int32_t line_number, int32_t column_number, const ::GURL& source_url) = 0;

  
  virtual void OnReportConsoleMessage(::blink::mojom::ConsoleMessageSource source, ::blink::mojom::ConsoleMessageLevel message_level, const ::base::string16& message, int32_t line_number, const ::GURL& source_url) = 0;

  
  virtual void OnStopped() = 0;
};



class BLINK_COMMON_EXPORT EmbeddedWorkerInstanceClientProxy
    : public EmbeddedWorkerInstanceClient {
 public:
  using InterfaceType = EmbeddedWorkerInstanceClient;

  explicit EmbeddedWorkerInstanceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartWorker(EmbeddedWorkerStartParamsPtr params) final;
  
  void StopWorker() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT EmbeddedWorkerInstanceHostProxy
    : public EmbeddedWorkerInstanceHost {
 public:
  using InterfaceType = EmbeddedWorkerInstanceHost;

  explicit EmbeddedWorkerInstanceHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestTermination(RequestTerminationCallback callback) final;
  
  void CountFeature(::blink::mojom::WebFeature feature) final;
  
  void OnReadyForInspection(::mojo::PendingRemote<::blink::mojom::DevToolsAgent> agent, ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> agent_host) final;
  
  void OnScriptLoaded() final;
  
  void OnScriptEvaluationStart() final;
  
  void OnStarted(::blink::mojom::ServiceWorkerStartStatus status, bool has_fetch_handler, int32_t thread_id, EmbeddedWorkerStartTimingPtr start_timing) final;
  
  void OnReportException(const ::base::string16& error_message, int32_t line_number, int32_t column_number, const ::GURL& source_url) final;
  
  void OnReportConsoleMessage(::blink::mojom::ConsoleMessageSource source, ::blink::mojom::ConsoleMessageLevel message_level, const ::base::string16& message, int32_t line_number, const ::GURL& source_url) final;
  
  void OnStopped() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT EmbeddedWorkerInstanceClientStubDispatch {
 public:
  static bool Accept(EmbeddedWorkerInstanceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      EmbeddedWorkerInstanceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<EmbeddedWorkerInstanceClient>>
class EmbeddedWorkerInstanceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  EmbeddedWorkerInstanceClientStub() {}
  ~EmbeddedWorkerInstanceClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedWorkerInstanceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedWorkerInstanceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT EmbeddedWorkerInstanceHostStubDispatch {
 public:
  static bool Accept(EmbeddedWorkerInstanceHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      EmbeddedWorkerInstanceHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<EmbeddedWorkerInstanceHost>>
class EmbeddedWorkerInstanceHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  EmbeddedWorkerInstanceHostStub() {}
  ~EmbeddedWorkerInstanceHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedWorkerInstanceHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedWorkerInstanceHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT EmbeddedWorkerInstanceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT EmbeddedWorkerInstanceHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT EmbeddedWorkerInstanceHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_COMMON_EXPORT EmbeddedWorkerStartParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EmbeddedWorkerStartParams, T>::value>;
  using DataView = EmbeddedWorkerStartParamsDataView;
  using Data_ = internal::EmbeddedWorkerStartParams_Data;

  template <typename... Args>
  static EmbeddedWorkerStartParamsPtr New(Args&&... args) {
    return EmbeddedWorkerStartParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EmbeddedWorkerStartParamsPtr From(const U& u) {
    return mojo::TypeConverter<EmbeddedWorkerStartParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EmbeddedWorkerStartParams>::Convert(*this);
  }


  EmbeddedWorkerStartParams();

  EmbeddedWorkerStartParams(
      int64_t service_worker_version_id,
      const ::GURL& scope,
      const ::GURL& script_url,
      ::blink::mojom::ScriptType script_type,
      ::blink::mojom::FetchClientSettingsObjectPtr outside_fetch_client_settings_object,
      const std::string& user_agent,
      const ::blink::UserAgentMetadata& ua_metadata,
      int32_t service_worker_route_id,
      const ::base::UnguessableToken& devtools_worker_token,
      const ::GURL& script_url_to_skip_throttling,
      bool wait_for_debugger,
      bool is_installed,
      ::blink::mojom::RendererPreferencesPtr renderer_preferences,
      ::mojo::PendingReceiver<::blink::mojom::ServiceWorker> service_worker_receiver,
      ::mojo::PendingReceiver<::blink::mojom::ControllerServiceWorker> controller_receiver,
      ::blink::mojom::ServiceWorkerInstalledScriptsInfoPtr installed_scripts_info,
      ::mojo::PendingAssociatedRemote<EmbeddedWorkerInstanceHost> instance_host,
      ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr provider_info,
      ::mojo::PendingRemote<::blink::mojom::WorkerContentSettingsProxy> content_settings_proxy,
      ::mojo::PendingReceiver<::blink::mojom::RendererPreferenceWatcher> preference_watcher_receiver,
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories,
      ::mojo::PendingReceiver<::blink::mojom::SubresourceLoaderUpdater> subresource_loader_updater,
      const ::blink::ServiceWorkerToken& service_worker_token,
      int64_t ukm_source_id);

  ~EmbeddedWorkerStartParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EmbeddedWorkerStartParamsPtr>
  EmbeddedWorkerStartParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EmbeddedWorkerStartParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EmbeddedWorkerStartParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EmbeddedWorkerStartParams_UnserializedMessageContext<
            UserType, EmbeddedWorkerStartParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<EmbeddedWorkerStartParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return EmbeddedWorkerStartParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EmbeddedWorkerStartParams_UnserializedMessageContext<
            UserType, EmbeddedWorkerStartParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EmbeddedWorkerStartParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int64_t service_worker_version_id;
  
  ::GURL scope;
  
  ::GURL script_url;
  
  ::blink::mojom::ScriptType script_type;
  
  ::blink::mojom::FetchClientSettingsObjectPtr outside_fetch_client_settings_object;
  
  std::string user_agent;
  
  ::blink::UserAgentMetadata ua_metadata;
  
  int32_t service_worker_route_id;
  
  ::base::UnguessableToken devtools_worker_token;
  
  ::GURL script_url_to_skip_throttling;
  
  bool wait_for_debugger;
  
  bool is_installed;
  
  ::blink::mojom::RendererPreferencesPtr renderer_preferences;
  
  ::mojo::PendingReceiver<::blink::mojom::ServiceWorker> service_worker_receiver;
  
  ::mojo::PendingReceiver<::blink::mojom::ControllerServiceWorker> controller_receiver;
  
  ::blink::mojom::ServiceWorkerInstalledScriptsInfoPtr installed_scripts_info;
  
  ::mojo::PendingAssociatedRemote<EmbeddedWorkerInstanceHost> instance_host;
  
  ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr provider_info;
  
  ::mojo::PendingRemote<::blink::mojom::WorkerContentSettingsProxy> content_settings_proxy;
  
  ::mojo::PendingReceiver<::blink::mojom::RendererPreferenceWatcher> preference_watcher_receiver;
  
  ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories;
  
  ::mojo::PendingReceiver<::blink::mojom::SubresourceLoaderUpdater> subresource_loader_updater;
  
  ::blink::ServiceWorkerToken service_worker_token;
  
  int64_t ukm_source_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(EmbeddedWorkerStartParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT EmbeddedWorkerStartTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EmbeddedWorkerStartTiming, T>::value>;
  using DataView = EmbeddedWorkerStartTimingDataView;
  using Data_ = internal::EmbeddedWorkerStartTiming_Data;

  template <typename... Args>
  static EmbeddedWorkerStartTimingPtr New(Args&&... args) {
    return EmbeddedWorkerStartTimingPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EmbeddedWorkerStartTimingPtr From(const U& u) {
    return mojo::TypeConverter<EmbeddedWorkerStartTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EmbeddedWorkerStartTiming>::Convert(*this);
  }


  EmbeddedWorkerStartTiming();

  EmbeddedWorkerStartTiming(
      ::base::TimeTicks start_worker_received_time,
      ::base::TimeTicks script_evaluation_start_time,
      ::base::TimeTicks script_evaluation_end_time);

  ~EmbeddedWorkerStartTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EmbeddedWorkerStartTimingPtr>
  EmbeddedWorkerStartTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EmbeddedWorkerStartTiming::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EmbeddedWorkerStartTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EmbeddedWorkerStartTiming_UnserializedMessageContext<
            UserType, EmbeddedWorkerStartTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<EmbeddedWorkerStartTiming::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return EmbeddedWorkerStartTiming::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EmbeddedWorkerStartTiming_UnserializedMessageContext<
            UserType, EmbeddedWorkerStartTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EmbeddedWorkerStartTiming::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::TimeTicks start_worker_received_time;
  
  ::base::TimeTicks script_evaluation_start_time;
  
  ::base::TimeTicks script_evaluation_end_time;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
EmbeddedWorkerStartParamsPtr EmbeddedWorkerStartParams::Clone() const {
  return New(
      mojo::Clone(service_worker_version_id),
      mojo::Clone(scope),
      mojo::Clone(script_url),
      mojo::Clone(script_type),
      mojo::Clone(outside_fetch_client_settings_object),
      mojo::Clone(user_agent),
      mojo::Clone(ua_metadata),
      mojo::Clone(service_worker_route_id),
      mojo::Clone(devtools_worker_token),
      mojo::Clone(script_url_to_skip_throttling),
      mojo::Clone(wait_for_debugger),
      mojo::Clone(is_installed),
      mojo::Clone(renderer_preferences),
      mojo::Clone(service_worker_receiver),
      mojo::Clone(controller_receiver),
      mojo::Clone(installed_scripts_info),
      mojo::Clone(instance_host),
      mojo::Clone(provider_info),
      mojo::Clone(content_settings_proxy),
      mojo::Clone(preference_watcher_receiver),
      mojo::Clone(subresource_loader_factories),
      mojo::Clone(subresource_loader_updater),
      mojo::Clone(service_worker_token),
      mojo::Clone(ukm_source_id)
  );
}

template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>*>
bool EmbeddedWorkerStartParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->service_worker_version_id, other_struct.service_worker_version_id))
    return false;
  if (!mojo::Equals(this->scope, other_struct.scope))
    return false;
  if (!mojo::Equals(this->script_url, other_struct.script_url))
    return false;
  if (!mojo::Equals(this->script_type, other_struct.script_type))
    return false;
  if (!mojo::Equals(this->outside_fetch_client_settings_object, other_struct.outside_fetch_client_settings_object))
    return false;
  if (!mojo::Equals(this->user_agent, other_struct.user_agent))
    return false;
  if (!mojo::Equals(this->ua_metadata, other_struct.ua_metadata))
    return false;
  if (!mojo::Equals(this->service_worker_route_id, other_struct.service_worker_route_id))
    return false;
  if (!mojo::Equals(this->devtools_worker_token, other_struct.devtools_worker_token))
    return false;
  if (!mojo::Equals(this->script_url_to_skip_throttling, other_struct.script_url_to_skip_throttling))
    return false;
  if (!mojo::Equals(this->wait_for_debugger, other_struct.wait_for_debugger))
    return false;
  if (!mojo::Equals(this->is_installed, other_struct.is_installed))
    return false;
  if (!mojo::Equals(this->renderer_preferences, other_struct.renderer_preferences))
    return false;
  if (!mojo::Equals(this->service_worker_receiver, other_struct.service_worker_receiver))
    return false;
  if (!mojo::Equals(this->controller_receiver, other_struct.controller_receiver))
    return false;
  if (!mojo::Equals(this->installed_scripts_info, other_struct.installed_scripts_info))
    return false;
  if (!mojo::Equals(this->instance_host, other_struct.instance_host))
    return false;
  if (!mojo::Equals(this->provider_info, other_struct.provider_info))
    return false;
  if (!mojo::Equals(this->content_settings_proxy, other_struct.content_settings_proxy))
    return false;
  if (!mojo::Equals(this->preference_watcher_receiver, other_struct.preference_watcher_receiver))
    return false;
  if (!mojo::Equals(this->subresource_loader_factories, other_struct.subresource_loader_factories))
    return false;
  if (!mojo::Equals(this->subresource_loader_updater, other_struct.subresource_loader_updater))
    return false;
  if (!mojo::Equals(this->service_worker_token, other_struct.service_worker_token))
    return false;
  if (!mojo::Equals(this->ukm_source_id, other_struct.ukm_source_id))
    return false;
  return true;
}

template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.service_worker_version_id, rhs.service_worker_version_id))
    return true;
  if (std::less<>{}(rhs.service_worker_version_id, lhs.service_worker_version_id))
    return false;
  if (std::less<>{}(lhs.scope, rhs.scope))
    return true;
  if (std::less<>{}(rhs.scope, lhs.scope))
    return false;
  if (std::less<>{}(lhs.script_url, rhs.script_url))
    return true;
  if (std::less<>{}(rhs.script_url, lhs.script_url))
    return false;
  if (std::less<>{}(lhs.script_type, rhs.script_type))
    return true;
  if (std::less<>{}(rhs.script_type, lhs.script_type))
    return false;
  if (std::less<>{}(lhs.outside_fetch_client_settings_object, rhs.outside_fetch_client_settings_object))
    return true;
  if (std::less<>{}(rhs.outside_fetch_client_settings_object, lhs.outside_fetch_client_settings_object))
    return false;
  if (std::less<>{}(lhs.user_agent, rhs.user_agent))
    return true;
  if (std::less<>{}(rhs.user_agent, lhs.user_agent))
    return false;
  if (std::less<>{}(lhs.ua_metadata, rhs.ua_metadata))
    return true;
  if (std::less<>{}(rhs.ua_metadata, lhs.ua_metadata))
    return false;
  if (std::less<>{}(lhs.service_worker_route_id, rhs.service_worker_route_id))
    return true;
  if (std::less<>{}(rhs.service_worker_route_id, lhs.service_worker_route_id))
    return false;
  if (std::less<>{}(lhs.devtools_worker_token, rhs.devtools_worker_token))
    return true;
  if (std::less<>{}(rhs.devtools_worker_token, lhs.devtools_worker_token))
    return false;
  if (std::less<>{}(lhs.script_url_to_skip_throttling, rhs.script_url_to_skip_throttling))
    return true;
  if (std::less<>{}(rhs.script_url_to_skip_throttling, lhs.script_url_to_skip_throttling))
    return false;
  if (std::less<>{}(lhs.wait_for_debugger, rhs.wait_for_debugger))
    return true;
  if (std::less<>{}(rhs.wait_for_debugger, lhs.wait_for_debugger))
    return false;
  if (std::less<>{}(lhs.is_installed, rhs.is_installed))
    return true;
  if (std::less<>{}(rhs.is_installed, lhs.is_installed))
    return false;
  if (std::less<>{}(lhs.renderer_preferences, rhs.renderer_preferences))
    return true;
  if (std::less<>{}(rhs.renderer_preferences, lhs.renderer_preferences))
    return false;
  if (std::less<>{}(lhs.service_worker_receiver, rhs.service_worker_receiver))
    return true;
  if (std::less<>{}(rhs.service_worker_receiver, lhs.service_worker_receiver))
    return false;
  if (std::less<>{}(lhs.controller_receiver, rhs.controller_receiver))
    return true;
  if (std::less<>{}(rhs.controller_receiver, lhs.controller_receiver))
    return false;
  if (std::less<>{}(lhs.installed_scripts_info, rhs.installed_scripts_info))
    return true;
  if (std::less<>{}(rhs.installed_scripts_info, lhs.installed_scripts_info))
    return false;
  if (std::less<>{}(lhs.instance_host, rhs.instance_host))
    return true;
  if (std::less<>{}(rhs.instance_host, lhs.instance_host))
    return false;
  if (std::less<>{}(lhs.provider_info, rhs.provider_info))
    return true;
  if (std::less<>{}(rhs.provider_info, lhs.provider_info))
    return false;
  if (std::less<>{}(lhs.content_settings_proxy, rhs.content_settings_proxy))
    return true;
  if (std::less<>{}(rhs.content_settings_proxy, lhs.content_settings_proxy))
    return false;
  if (std::less<>{}(lhs.preference_watcher_receiver, rhs.preference_watcher_receiver))
    return true;
  if (std::less<>{}(rhs.preference_watcher_receiver, lhs.preference_watcher_receiver))
    return false;
  if (std::less<>{}(lhs.subresource_loader_factories, rhs.subresource_loader_factories))
    return true;
  if (std::less<>{}(rhs.subresource_loader_factories, lhs.subresource_loader_factories))
    return false;
  if (std::less<>{}(lhs.subresource_loader_updater, rhs.subresource_loader_updater))
    return true;
  if (std::less<>{}(rhs.subresource_loader_updater, lhs.subresource_loader_updater))
    return false;
  if (std::less<>{}(lhs.service_worker_token, rhs.service_worker_token))
    return true;
  if (std::less<>{}(rhs.service_worker_token, lhs.service_worker_token))
    return false;
  if (std::less<>{}(lhs.ukm_source_id, rhs.ukm_source_id))
    return true;
  if (std::less<>{}(rhs.ukm_source_id, lhs.ukm_source_id))
    return false;
  return false;
}
template <typename StructPtrType>
EmbeddedWorkerStartTimingPtr EmbeddedWorkerStartTiming::Clone() const {
  return New(
      mojo::Clone(start_worker_received_time),
      mojo::Clone(script_evaluation_start_time),
      mojo::Clone(script_evaluation_end_time)
  );
}

template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>*>
bool EmbeddedWorkerStartTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->start_worker_received_time, other_struct.start_worker_received_time))
    return false;
  if (!mojo::Equals(this->script_evaluation_start_time, other_struct.script_evaluation_start_time))
    return false;
  if (!mojo::Equals(this->script_evaluation_end_time, other_struct.script_evaluation_end_time))
    return false;
  return true;
}

template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.start_worker_received_time, rhs.start_worker_received_time))
    return true;
  if (std::less<>{}(rhs.start_worker_received_time, lhs.start_worker_received_time))
    return false;
  if (std::less<>{}(lhs.script_evaluation_start_time, rhs.script_evaluation_start_time))
    return true;
  if (std::less<>{}(rhs.script_evaluation_start_time, lhs.script_evaluation_start_time))
    return false;
  if (std::less<>{}(lhs.script_evaluation_end_time, rhs.script_evaluation_end_time))
    return true;
  if (std::less<>{}(rhs.script_evaluation_end_time, lhs.script_evaluation_end_time))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::EmbeddedWorkerStartParams::DataView,
                                         ::blink::mojom::EmbeddedWorkerStartParamsPtr> {
  static bool IsNull(const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::EmbeddedWorkerStartParamsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::EmbeddedWorkerStartParams::service_worker_version_id) service_worker_version_id(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->service_worker_version_id;
  }

  static const decltype(::blink::mojom::EmbeddedWorkerStartParams::scope)& scope(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->scope;
  }

  static const decltype(::blink::mojom::EmbeddedWorkerStartParams::script_url)& script_url(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->script_url;
  }

  static decltype(::blink::mojom::EmbeddedWorkerStartParams::script_type) script_type(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->script_type;
  }

  static const decltype(::blink::mojom::EmbeddedWorkerStartParams::outside_fetch_client_settings_object)& outside_fetch_client_settings_object(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->outside_fetch_client_settings_object;
  }

  static const decltype(::blink::mojom::EmbeddedWorkerStartParams::user_agent)& user_agent(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->user_agent;
  }

  static const decltype(::blink::mojom::EmbeddedWorkerStartParams::ua_metadata)& ua_metadata(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->ua_metadata;
  }

  static decltype(::blink::mojom::EmbeddedWorkerStartParams::service_worker_route_id) service_worker_route_id(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->service_worker_route_id;
  }

  static const decltype(::blink::mojom::EmbeddedWorkerStartParams::devtools_worker_token)& devtools_worker_token(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->devtools_worker_token;
  }

  static const decltype(::blink::mojom::EmbeddedWorkerStartParams::script_url_to_skip_throttling)& script_url_to_skip_throttling(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->script_url_to_skip_throttling;
  }

  static decltype(::blink::mojom::EmbeddedWorkerStartParams::wait_for_debugger) wait_for_debugger(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->wait_for_debugger;
  }

  static decltype(::blink::mojom::EmbeddedWorkerStartParams::is_installed) is_installed(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->is_installed;
  }

  static const decltype(::blink::mojom::EmbeddedWorkerStartParams::renderer_preferences)& renderer_preferences(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->renderer_preferences;
  }

  static  decltype(::blink::mojom::EmbeddedWorkerStartParams::service_worker_receiver)& service_worker_receiver(
       ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->service_worker_receiver;
  }

  static  decltype(::blink::mojom::EmbeddedWorkerStartParams::controller_receiver)& controller_receiver(
       ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->controller_receiver;
  }

  static  decltype(::blink::mojom::EmbeddedWorkerStartParams::installed_scripts_info)& installed_scripts_info(
       ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->installed_scripts_info;
  }

  static  decltype(::blink::mojom::EmbeddedWorkerStartParams::instance_host)& instance_host(
       ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->instance_host;
  }

  static  decltype(::blink::mojom::EmbeddedWorkerStartParams::provider_info)& provider_info(
       ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->provider_info;
  }

  static  decltype(::blink::mojom::EmbeddedWorkerStartParams::content_settings_proxy)& content_settings_proxy(
       ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->content_settings_proxy;
  }

  static  decltype(::blink::mojom::EmbeddedWorkerStartParams::preference_watcher_receiver)& preference_watcher_receiver(
       ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->preference_watcher_receiver;
  }

  static  decltype(::blink::mojom::EmbeddedWorkerStartParams::subresource_loader_factories)& subresource_loader_factories(
       ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->subresource_loader_factories;
  }

  static  decltype(::blink::mojom::EmbeddedWorkerStartParams::subresource_loader_updater)& subresource_loader_updater(
       ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->subresource_loader_updater;
  }

  static const decltype(::blink::mojom::EmbeddedWorkerStartParams::service_worker_token)& service_worker_token(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->service_worker_token;
  }

  static decltype(::blink::mojom::EmbeddedWorkerStartParams::ukm_source_id) ukm_source_id(
      const ::blink::mojom::EmbeddedWorkerStartParamsPtr& input) {
    return input->ukm_source_id;
  }

  static bool Read(::blink::mojom::EmbeddedWorkerStartParams::DataView input, ::blink::mojom::EmbeddedWorkerStartParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::EmbeddedWorkerStartTiming::DataView,
                                         ::blink::mojom::EmbeddedWorkerStartTimingPtr> {
  static bool IsNull(const ::blink::mojom::EmbeddedWorkerStartTimingPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::EmbeddedWorkerStartTimingPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::EmbeddedWorkerStartTiming::start_worker_received_time)& start_worker_received_time(
      const ::blink::mojom::EmbeddedWorkerStartTimingPtr& input) {
    return input->start_worker_received_time;
  }

  static const decltype(::blink::mojom::EmbeddedWorkerStartTiming::script_evaluation_start_time)& script_evaluation_start_time(
      const ::blink::mojom::EmbeddedWorkerStartTimingPtr& input) {
    return input->script_evaluation_start_time;
  }

  static const decltype(::blink::mojom::EmbeddedWorkerStartTiming::script_evaluation_end_time)& script_evaluation_end_time(
      const ::blink::mojom::EmbeddedWorkerStartTimingPtr& input) {
    return input->script_evaluation_end_time;
  }

  static bool Read(::blink::mojom::EmbeddedWorkerStartTiming::DataView input, ::blink::mojom::EmbeddedWorkerStartTimingPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_H_