// third_party/blink/public/mojom/service_worker/service_worker_provider.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_PROVIDER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_PROVIDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_provider.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_provider.mojom-forward.h"
#include "services/network/public/mojom/url_loader_factory.mojom.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker_mode.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container_type.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class ServiceWorkerWorkerClientProxy;

template <typename ImplRefTraits>
class ServiceWorkerWorkerClientStub;

class ServiceWorkerWorkerClientRequestValidator;


class BLINK_COMMON_EXPORT ServiceWorkerWorkerClient
    : public ServiceWorkerWorkerClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceWorkerWorkerClientInterfaceBase;
  using Proxy_ = ServiceWorkerWorkerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerWorkerClientStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerWorkerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnControllerChangedMinVersion = 0,
  };
  virtual ~ServiceWorkerWorkerClient() {}

  
  virtual void OnControllerChanged(::blink::mojom::ControllerServiceWorkerMode mode) = 0;
};

class ServiceWorkerWorkerClientRegistryProxy;

template <typename ImplRefTraits>
class ServiceWorkerWorkerClientRegistryStub;

class ServiceWorkerWorkerClientRegistryRequestValidator;


class BLINK_COMMON_EXPORT ServiceWorkerWorkerClientRegistry
    : public ServiceWorkerWorkerClientRegistryInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceWorkerWorkerClientRegistryInterfaceBase;
  using Proxy_ = ServiceWorkerWorkerClientRegistryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerWorkerClientRegistryStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerWorkerClientRegistryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRegisterWorkerClientMinVersion = 0,
    kCloneWorkerClientRegistryMinVersion = 0,
  };
  virtual ~ServiceWorkerWorkerClientRegistry() {}

  
  virtual void RegisterWorkerClient(::mojo::PendingRemote<ServiceWorkerWorkerClient> client) = 0;

  
  virtual void CloneWorkerClientRegistry(::mojo::PendingReceiver<ServiceWorkerWorkerClientRegistry> host) = 0;
};



class BLINK_COMMON_EXPORT ServiceWorkerWorkerClientProxy
    : public ServiceWorkerWorkerClient {
 public:
  using InterfaceType = ServiceWorkerWorkerClient;

  explicit ServiceWorkerWorkerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnControllerChanged(::blink::mojom::ControllerServiceWorkerMode mode) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT ServiceWorkerWorkerClientRegistryProxy
    : public ServiceWorkerWorkerClientRegistry {
 public:
  using InterfaceType = ServiceWorkerWorkerClientRegistry;

  explicit ServiceWorkerWorkerClientRegistryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RegisterWorkerClient(::mojo::PendingRemote<ServiceWorkerWorkerClient> client) final;
  
  void CloneWorkerClientRegistry(::mojo::PendingReceiver<ServiceWorkerWorkerClientRegistry> host) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ServiceWorkerWorkerClientStubDispatch {
 public:
  static bool Accept(ServiceWorkerWorkerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerWorkerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerWorkerClient>>
class ServiceWorkerWorkerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerWorkerClientStub() {}
  ~ServiceWorkerWorkerClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerWorkerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerWorkerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ServiceWorkerWorkerClientRegistryStubDispatch {
 public:
  static bool Accept(ServiceWorkerWorkerClientRegistry* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerWorkerClientRegistry* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerWorkerClientRegistry>>
class ServiceWorkerWorkerClientRegistryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerWorkerClientRegistryStub() {}
  ~ServiceWorkerWorkerClientRegistryStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerWorkerClientRegistryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerWorkerClientRegistryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ServiceWorkerWorkerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ServiceWorkerWorkerClientRegistryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT ServiceWorkerProviderInfoForStartWorker {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerProviderInfoForStartWorker, T>::value>;
  using DataView = ServiceWorkerProviderInfoForStartWorkerDataView;
  using Data_ = internal::ServiceWorkerProviderInfoForStartWorker_Data;

  template <typename... Args>
  static ServiceWorkerProviderInfoForStartWorkerPtr New(Args&&... args) {
    return ServiceWorkerProviderInfoForStartWorkerPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerProviderInfoForStartWorkerPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerProviderInfoForStartWorkerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerProviderInfoForStartWorker>::Convert(*this);
  }


  ServiceWorkerProviderInfoForStartWorker();

  ServiceWorkerProviderInfoForStartWorker(
      ::mojo::PendingAssociatedRemote<::blink::mojom::ServiceWorkerContainerHost> host_remote,
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> script_loader_factory_remote,
      ::mojo::PendingRemote<::blink::mojom::CacheStorage> cache_storage,
      ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker);

  ~ServiceWorkerProviderInfoForStartWorker();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerProviderInfoForStartWorkerPtr>
  ServiceWorkerProviderInfoForStartWorkerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerProviderInfoForStartWorker::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerProviderInfoForStartWorker::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerProviderInfoForStartWorker::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerProviderInfoForStartWorker_UnserializedMessageContext<
            UserType, ServiceWorkerProviderInfoForStartWorker::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ServiceWorkerProviderInfoForStartWorker::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ServiceWorkerProviderInfoForStartWorker::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerProviderInfoForStartWorker_UnserializedMessageContext<
            UserType, ServiceWorkerProviderInfoForStartWorker::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerProviderInfoForStartWorker::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::PendingAssociatedRemote<::blink::mojom::ServiceWorkerContainerHost> host_remote;
  
  ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> script_loader_factory_remote;
  
  ::mojo::PendingRemote<::blink::mojom::CacheStorage> cache_storage;
  
  ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerProviderInfoForStartWorker);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerProviderInfoForStartWorker::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerProviderInfoForStartWorker::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerProviderInfoForStartWorker::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerProviderInfoForStartWorker::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ServiceWorkerProviderInfoForStartWorkerPtr ServiceWorkerProviderInfoForStartWorker::Clone() const {
  return New(
      mojo::Clone(host_remote),
      mojo::Clone(script_loader_factory_remote),
      mojo::Clone(cache_storage),
      mojo::Clone(browser_interface_broker)
  );
}

template <typename T, ServiceWorkerProviderInfoForStartWorker::EnableIfSame<T>*>
bool ServiceWorkerProviderInfoForStartWorker::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->host_remote, other_struct.host_remote))
    return false;
  if (!mojo::Equals(this->script_loader_factory_remote, other_struct.script_loader_factory_remote))
    return false;
  if (!mojo::Equals(this->cache_storage, other_struct.cache_storage))
    return false;
  if (!mojo::Equals(this->browser_interface_broker, other_struct.browser_interface_broker))
    return false;
  return true;
}

template <typename T, ServiceWorkerProviderInfoForStartWorker::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.host_remote, rhs.host_remote))
    return true;
  if (std::less<>{}(rhs.host_remote, lhs.host_remote))
    return false;
  if (std::less<>{}(lhs.script_loader_factory_remote, rhs.script_loader_factory_remote))
    return true;
  if (std::less<>{}(rhs.script_loader_factory_remote, lhs.script_loader_factory_remote))
    return false;
  if (std::less<>{}(lhs.cache_storage, rhs.cache_storage))
    return true;
  if (std::less<>{}(rhs.cache_storage, lhs.cache_storage))
    return false;
  if (std::less<>{}(lhs.browser_interface_broker, rhs.browser_interface_broker))
    return true;
  if (std::less<>{}(rhs.browser_interface_broker, lhs.browser_interface_broker))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerProviderInfoForStartWorker::DataView,
                                         ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::ServiceWorkerProviderInfoForStartWorker::host_remote)& host_remote(
       ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr& input) {
    return input->host_remote;
  }

  static  decltype(::blink::mojom::ServiceWorkerProviderInfoForStartWorker::script_loader_factory_remote)& script_loader_factory_remote(
       ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr& input) {
    return input->script_loader_factory_remote;
  }

  static  decltype(::blink::mojom::ServiceWorkerProviderInfoForStartWorker::cache_storage)& cache_storage(
       ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr& input) {
    return input->cache_storage;
  }

  static  decltype(::blink::mojom::ServiceWorkerProviderInfoForStartWorker::browser_interface_broker)& browser_interface_broker(
       ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr& input) {
    return input->browser_interface_broker;
  }

  static bool Read(::blink::mojom::ServiceWorkerProviderInfoForStartWorker::DataView input, ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_PROVIDER_MOJOM_H_