// third_party/blink/public/mojom/timing/resource_timing.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/timing/resource_timing.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class ServerTimingInfoDataView;

class ResourceTimingInfoDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ServerTimingInfoDataView> {
  using Data = ::blink::mojom::internal::ServerTimingInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ResourceTimingInfoDataView> {
  using Data = ::blink::mojom::internal::ResourceTimingInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


class ServerTimingInfoDataView {
 public:
  ServerTimingInfoDataView() {}

  ServerTimingInfoDataView(
      internal::ServerTimingInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  double duration() const {
    return data_->duration;
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::ServerTimingInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ResourceTimingInfoDataView {
 public:
  ResourceTimingInfoDataView() {}

  ResourceTimingInfoDataView(
      internal::ResourceTimingInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStartTime(UserType* output) {
    
    auto* pointer = data_->start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetAlpnNegotiatedProtocolDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAlpnNegotiatedProtocol(UserType* output) {
    
    auto* pointer = data_->alpn_negotiated_protocol.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetConnectionInfoDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadConnectionInfo(UserType* output) {
    
    auto* pointer = data_->connection_info.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetTimingDataView(
      ::network::mojom::LoadTimingInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTiming(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::LoadTimingInfoDataView, UserType>(),
    "Attempting to read the optional `timing` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTiming` instead "
    "of `ReadTiming if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timing.Get();
    return mojo::internal::Deserialize<::network::mojom::LoadTimingInfoDataView>(
        pointer, output, context_);
  }
  inline void GetLastRedirectEndTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLastRedirectEndTime(UserType* output) {
    
    auto* pointer = data_->last_redirect_end_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetResponseEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResponseEnd(UserType* output) {
    
    auto* pointer = data_->response_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContextType(UserType* output) const {
    auto data_value = data_->context_type;
    return mojo::internal::Deserialize<::blink::mojom::RequestContextType>(
        data_value, output);
  }

  ::blink::mojom::RequestContextType context_type() const {
    return static_cast<::blink::mojom::RequestContextType>(data_->context_type);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestDestination(UserType* output) const {
    auto data_value = data_->request_destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }

  ::network::mojom::RequestDestination request_destination() const {
    return static_cast<::network::mojom::RequestDestination>(data_->request_destination);
  }
  uint64_t transfer_size() const {
    return data_->transfer_size;
  }
  uint64_t encoded_body_size() const {
    return data_->encoded_body_size;
  }
  uint64_t decoded_body_size() const {
    return data_->decoded_body_size;
  }
  bool did_reuse_connection() const {
    return data_->did_reuse_connection;
  }
  bool is_secure_context() const {
    return data_->is_secure_context;
  }
  bool allow_timing_details() const {
    return data_->allow_timing_details;
  }
  bool allow_redirect_details() const {
    return data_->allow_redirect_details;
  }
  bool allow_negative_values() const {
    return data_->allow_negative_values;
  }
  inline void GetServerTimingDataView(
      mojo::ArrayDataView<ServerTimingInfoDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadServerTiming(UserType* output) {
    
    auto* pointer = data_->server_timing.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ServerTimingInfoDataView>>(
        pointer, output, context_);
  }
 private:
  internal::ResourceTimingInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServerTimingInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServerTimingInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ServerTimingInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::name(input)) in_name = Traits::name(input);
    typename decltype((*output)->name)::BaseType::BufferWriter
        name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, buffer, &name_writer, context);
    (*output)->name.Set(
        name_writer.is_null() ? nullptr : name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ServerTimingInfo struct");
    (*output)->duration = Traits::duration(input);
    decltype(Traits::description(input)) in_description = Traits::description(input);
    typename decltype((*output)->description)::BaseType::BufferWriter
        description_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_description, buffer, &description_writer, context);
    (*output)->description.Set(
        description_writer.is_null() ? nullptr : description_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->description.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description in ServerTimingInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::ServerTimingInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServerTimingInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ResourceTimingInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ResourceTimingInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ResourceTimingInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::name(input)) in_name = Traits::name(input);
    typename decltype((*output)->name)::BaseType::BufferWriter
        name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, buffer, &name_writer, context);
    (*output)->name.Set(
        name_writer.is_null() ? nullptr : name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ResourceTimingInfo struct");
    decltype(Traits::start_time(input)) in_start_time = Traits::start_time(input);
    typename decltype((*output)->start_time)::BaseType::BufferWriter
        start_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_start_time, buffer, &start_time_writer, context);
    (*output)->start_time.Set(
        start_time_writer.is_null() ? nullptr : start_time_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->start_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_time in ResourceTimingInfo struct");
    decltype(Traits::alpn_negotiated_protocol(input)) in_alpn_negotiated_protocol = Traits::alpn_negotiated_protocol(input);
    typename decltype((*output)->alpn_negotiated_protocol)::BaseType::BufferWriter
        alpn_negotiated_protocol_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_alpn_negotiated_protocol, buffer, &alpn_negotiated_protocol_writer, context);
    (*output)->alpn_negotiated_protocol.Set(
        alpn_negotiated_protocol_writer.is_null() ? nullptr : alpn_negotiated_protocol_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->alpn_negotiated_protocol.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alpn_negotiated_protocol in ResourceTimingInfo struct");
    decltype(Traits::connection_info(input)) in_connection_info = Traits::connection_info(input);
    typename decltype((*output)->connection_info)::BaseType::BufferWriter
        connection_info_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_connection_info, buffer, &connection_info_writer, context);
    (*output)->connection_info.Set(
        connection_info_writer.is_null() ? nullptr : connection_info_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->connection_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null connection_info in ResourceTimingInfo struct");
    decltype(Traits::timing(input)) in_timing = Traits::timing(input);
    typename decltype((*output)->timing)::BaseType::BufferWriter
        timing_writer;
    mojo::internal::Serialize<::network::mojom::LoadTimingInfoDataView>(
        in_timing, buffer, &timing_writer, context);
    (*output)->timing.Set(
        timing_writer.is_null() ? nullptr : timing_writer.data());
    decltype(Traits::last_redirect_end_time(input)) in_last_redirect_end_time = Traits::last_redirect_end_time(input);
    typename decltype((*output)->last_redirect_end_time)::BaseType::BufferWriter
        last_redirect_end_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_last_redirect_end_time, buffer, &last_redirect_end_time_writer, context);
    (*output)->last_redirect_end_time.Set(
        last_redirect_end_time_writer.is_null() ? nullptr : last_redirect_end_time_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->last_redirect_end_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_redirect_end_time in ResourceTimingInfo struct");
    decltype(Traits::response_end(input)) in_response_end = Traits::response_end(input);
    typename decltype((*output)->response_end)::BaseType::BufferWriter
        response_end_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_response_end, buffer, &response_end_writer, context);
    (*output)->response_end.Set(
        response_end_writer.is_null() ? nullptr : response_end_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->response_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_end in ResourceTimingInfo struct");
    mojo::internal::Serialize<::blink::mojom::RequestContextType>(
        Traits::context_type(input), &(*output)->context_type);
    mojo::internal::Serialize<::network::mojom::RequestDestination>(
        Traits::request_destination(input), &(*output)->request_destination);
    (*output)->transfer_size = Traits::transfer_size(input);
    (*output)->encoded_body_size = Traits::encoded_body_size(input);
    (*output)->decoded_body_size = Traits::decoded_body_size(input);
    (*output)->did_reuse_connection = Traits::did_reuse_connection(input);
    (*output)->is_secure_context = Traits::is_secure_context(input);
    (*output)->allow_timing_details = Traits::allow_timing_details(input);
    (*output)->allow_redirect_details = Traits::allow_redirect_details(input);
    (*output)->allow_negative_values = Traits::allow_negative_values(input);
    decltype(Traits::server_timing(input)) in_server_timing = Traits::server_timing(input);
    typename decltype((*output)->server_timing)::BaseType::BufferWriter
        server_timing_writer;
    const mojo::internal::ContainerValidateParams server_timing_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ServerTimingInfoDataView>>(
        in_server_timing, buffer, &server_timing_writer, &server_timing_validate_params,
        context);
    (*output)->server_timing.Set(
        server_timing_writer.is_null() ? nullptr : server_timing_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->server_timing.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null server_timing in ResourceTimingInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::ResourceTimingInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ResourceTimingInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void ServerTimingInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ServerTimingInfoDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void ResourceTimingInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ResourceTimingInfoDataView::GetStartTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->start_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void ResourceTimingInfoDataView::GetAlpnNegotiatedProtocolDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->alpn_negotiated_protocol.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ResourceTimingInfoDataView::GetConnectionInfoDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->connection_info.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ResourceTimingInfoDataView::GetTimingDataView(
    ::network::mojom::LoadTimingInfoDataView* output) {
  auto pointer = data_->timing.Get();
  *output = ::network::mojom::LoadTimingInfoDataView(pointer, context_);
}
inline void ResourceTimingInfoDataView::GetLastRedirectEndTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->last_redirect_end_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void ResourceTimingInfoDataView::GetResponseEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->response_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void ResourceTimingInfoDataView::GetServerTimingDataView(
    mojo::ArrayDataView<ServerTimingInfoDataView>* output) {
  auto pointer = data_->server_timing.Get();
  *output = mojo::ArrayDataView<ServerTimingInfoDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_SHARED_H_