// third_party/blink/public/mojom/worker/shared_worker_client.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_CLIENT_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_CLIENT_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char SharedWorkerClient::Name_[] = "blink.mojom.SharedWorkerClient";

SharedWorkerClientProxy::SharedWorkerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedWorkerClientProxy::OnCreated(
    ::blink::mojom::SharedWorkerCreationContextType in_creation_context_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerClient::OnCreated", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("creation_context_type", base::trace_event::ValueToString(in_creation_context_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSharedWorkerClient_OnCreated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SharedWorkerClient_OnCreated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::SharedWorkerCreationContextType>(
      in_creation_context_type, &params->creation_context_type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerClient::Name_);
  message.set_method_name("OnCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SharedWorkerClientProxy::OnConnected(
    const std::vector<::blink::mojom::WebFeature>& in_features_used) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerClient::OnConnected", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("features_used");
      for (const auto& item0 : in_features_used) {
        raw_value->AppendString(base::trace_event::ValueToString(item0));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSharedWorkerClient_OnConnected_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SharedWorkerClient_OnConnected_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->features_used)::BaseType::BufferWriter
      features_used_writer;
  const mojo::internal::ContainerValidateParams features_used_validate_params(
      0, ::blink::mojom::internal::WebFeature_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebFeature>>(
      in_features_used, buffer, &features_used_writer, &features_used_validate_params,
      &serialization_context);
  params->features_used.Set(
      features_used_writer.is_null() ? nullptr : features_used_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->features_used.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null features_used in SharedWorkerClient.OnConnected request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerClient::Name_);
  message.set_method_name("OnConnected");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SharedWorkerClientProxy::OnScriptLoadFailed(
    const std::string& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerClient::OnScriptLoadFailed", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("error_message", in_error_message);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSharedWorkerClient_OnScriptLoadFailed_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SharedWorkerClient_OnScriptLoadFailed_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->error_message)::BaseType::BufferWriter
      error_message_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, buffer, &error_message_writer, &serialization_context);
  params->error_message.Set(
      error_message_writer.is_null() ? nullptr : error_message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in SharedWorkerClient.OnScriptLoadFailed request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerClient::Name_);
  message.set_method_name("OnScriptLoadFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SharedWorkerClientProxy::OnFeatureUsed(
    ::blink::mojom::WebFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SharedWorkerClient::OnFeatureUsed", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("feature", base::trace_event::ValueToString(in_feature));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSharedWorkerClient_OnFeatureUsed_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SharedWorkerClient_OnFeatureUsed_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::WebFeature>(
      in_feature, &params->feature);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedWorkerClient::Name_);
  message.set_method_name("OnFeatureUsed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SharedWorkerClientStubDispatch::Accept(
    SharedWorkerClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSharedWorkerClient_OnCreated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerClient::OnCreated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerClient::OnCreated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerClient_OnCreated_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerClient_OnCreated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::SharedWorkerCreationContextType p_creation_context_type{};
      SharedWorkerClient_OnCreated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCreationContextType(&p_creation_context_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCreated(
std::move(p_creation_context_type));
      return true;
    }
    case internal::kSharedWorkerClient_OnConnected_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerClient::OnConnected",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerClient::OnConnected");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerClient_OnConnected_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerClient_OnConnected_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<::blink::mojom::WebFeature> p_features_used{};
      SharedWorkerClient_OnConnected_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFeaturesUsed(&p_features_used))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnected(
std::move(p_features_used));
      return true;
    }
    case internal::kSharedWorkerClient_OnScriptLoadFailed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerClient::OnScriptLoadFailed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerClient::OnScriptLoadFailed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerClient_OnScriptLoadFailed_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerClient_OnScriptLoadFailed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_error_message{};
      SharedWorkerClient_OnScriptLoadFailed_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScriptLoadFailed(
std::move(p_error_message));
      return true;
    }
    case internal::kSharedWorkerClient_OnFeatureUsed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SharedWorkerClient::OnFeatureUsed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SharedWorkerClient::OnFeatureUsed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SharedWorkerClient_OnFeatureUsed_Params_Data* params =
          reinterpret_cast<internal::SharedWorkerClient_OnFeatureUsed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::WebFeature p_feature{};
      SharedWorkerClient_OnFeatureUsed_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedWorkerClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFeatureUsed(
std::move(p_feature));
      return true;
    }
  }
  return false;
}

// static
bool SharedWorkerClientStubDispatch::AcceptWithResponder(
    SharedWorkerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSharedWorkerClient_OnCreated_Name: {
      break;
    }
    case internal::kSharedWorkerClient_OnConnected_Name: {
      break;
    }
    case internal::kSharedWorkerClient_OnScriptLoadFailed_Name: {
      break;
    }
    case internal::kSharedWorkerClient_OnFeatureUsed_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSharedWorkerClientValidationInfo[] = {
    {&internal::SharedWorkerClient_OnCreated_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SharedWorkerClient_OnConnected_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SharedWorkerClient_OnScriptLoadFailed_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SharedWorkerClient_OnFeatureUsed_Params_Data::Validate,
     nullptr /* no response */},
};

bool SharedWorkerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SharedWorkerClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSharedWorkerClientValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif