// ui/accessibility/mojom/ax_node_data.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/accessibility/mojom/ax_node_data.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared.h"







namespace ax {
namespace mojom {
class AXNodeDataDataView;



}  // namespace mojom
}  // namespace ax

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXNodeDataDataView> {
  using Data = ::ax::mojom::internal::AXNodeData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax {
namespace mojom {


class AXNodeDataDataView {
 public:
  AXNodeDataDataView() {}

  AXNodeDataDataView(
      internal::AXNodeData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRole(UserType* output) const {
    auto data_value = data_->role;
    return mojo::internal::Deserialize<::ax::mojom::Role>(
        data_value, output);
  }

  ::ax::mojom::Role role() const {
    return static_cast<::ax::mojom::Role>(data_->role);
  }
  uint32_t state() const {
    return data_->state;
  }
  uint64_t actions() const {
    return data_->actions;
  }
  inline void GetStringAttributesDataView(
      mojo::MapDataView<::ax::mojom::StringAttribute, mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStringAttributes(UserType* output) {
    
    auto* pointer = data_->string_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::ax::mojom::StringAttribute, mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetIntAttributesDataView(
      mojo::MapDataView<::ax::mojom::IntAttribute, int32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIntAttributes(UserType* output) {
    
    auto* pointer = data_->int_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::ax::mojom::IntAttribute, int32_t>>(
        pointer, output, context_);
  }
  inline void GetFloatAttributesDataView(
      mojo::MapDataView<::ax::mojom::FloatAttribute, float>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFloatAttributes(UserType* output) {
    
    auto* pointer = data_->float_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::ax::mojom::FloatAttribute, float>>(
        pointer, output, context_);
  }
  inline void GetBoolAttributesDataView(
      mojo::MapDataView<::ax::mojom::BoolAttribute, bool>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBoolAttributes(UserType* output) {
    
    auto* pointer = data_->bool_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::ax::mojom::BoolAttribute, bool>>(
        pointer, output, context_);
  }
  inline void GetIntlistAttributesDataView(
      mojo::MapDataView<::ax::mojom::IntListAttribute, mojo::ArrayDataView<int32_t>>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIntlistAttributes(UserType* output) {
    
    auto* pointer = data_->intlist_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::ax::mojom::IntListAttribute, mojo::ArrayDataView<int32_t>>>(
        pointer, output, context_);
  }
  inline void GetStringlistAttributesDataView(
      mojo::MapDataView<::ax::mojom::StringListAttribute, mojo::ArrayDataView<mojo::StringDataView>>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStringlistAttributes(UserType* output) {
    
    auto* pointer = data_->stringlist_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::ax::mojom::StringListAttribute, mojo::ArrayDataView<mojo::StringDataView>>>(
        pointer, output, context_);
  }
  inline void GetHtmlAttributesDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHtmlAttributes(UserType* output) {
    
    auto* pointer = data_->html_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetChildIdsDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadChildIds(UserType* output) {
    
    auto* pointer = data_->child_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, context_);
  }
  inline void GetRelativeBoundsDataView(
      ::ax::mojom::AXRelativeBoundsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRelativeBounds(UserType* output) {
    
    auto* pointer = data_->relative_bounds.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXRelativeBoundsDataView>(
        pointer, output, context_);
  }
 private:
  internal::AXNodeData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace ax

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXNodeDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXNodeDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::ax::mojom::internal::AXNodeData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->id = Traits::id(input);
    mojo::internal::Serialize<::ax::mojom::Role>(
        Traits::role(input), &(*output)->role);
    (*output)->state = Traits::state(input);
    (*output)->actions = Traits::actions(input);
    decltype(Traits::string_attributes(input)) in_string_attributes = Traits::string_attributes(input);
    typename decltype((*output)->string_attributes)::BaseType::BufferWriter
        string_attributes_writer;
    const mojo::internal::ContainerValidateParams string_attributes_validate_params(
        new mojo::internal::ContainerValidateParams(0, ::ax::mojom::internal::StringAttribute_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
    mojo::internal::Serialize<mojo::MapDataView<::ax::mojom::StringAttribute, mojo::StringDataView>>(
        in_string_attributes, buffer, &string_attributes_writer, &string_attributes_validate_params,
        context);
    (*output)->string_attributes.Set(
        string_attributes_writer.is_null() ? nullptr : string_attributes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->string_attributes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null string_attributes in AXNodeData struct");
    decltype(Traits::int_attributes(input)) in_int_attributes = Traits::int_attributes(input);
    typename decltype((*output)->int_attributes)::BaseType::BufferWriter
        int_attributes_writer;
    const mojo::internal::ContainerValidateParams int_attributes_validate_params(
        new mojo::internal::ContainerValidateParams(0, ::ax::mojom::internal::IntAttribute_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<::ax::mojom::IntAttribute, int32_t>>(
        in_int_attributes, buffer, &int_attributes_writer, &int_attributes_validate_params,
        context);
    (*output)->int_attributes.Set(
        int_attributes_writer.is_null() ? nullptr : int_attributes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->int_attributes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null int_attributes in AXNodeData struct");
    decltype(Traits::float_attributes(input)) in_float_attributes = Traits::float_attributes(input);
    typename decltype((*output)->float_attributes)::BaseType::BufferWriter
        float_attributes_writer;
    const mojo::internal::ContainerValidateParams float_attributes_validate_params(
        new mojo::internal::ContainerValidateParams(0, ::ax::mojom::internal::FloatAttribute_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<::ax::mojom::FloatAttribute, float>>(
        in_float_attributes, buffer, &float_attributes_writer, &float_attributes_validate_params,
        context);
    (*output)->float_attributes.Set(
        float_attributes_writer.is_null() ? nullptr : float_attributes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->float_attributes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null float_attributes in AXNodeData struct");
    decltype(Traits::bool_attributes(input)) in_bool_attributes = Traits::bool_attributes(input);
    typename decltype((*output)->bool_attributes)::BaseType::BufferWriter
        bool_attributes_writer;
    const mojo::internal::ContainerValidateParams bool_attributes_validate_params(
        new mojo::internal::ContainerValidateParams(0, ::ax::mojom::internal::BoolAttribute_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<::ax::mojom::BoolAttribute, bool>>(
        in_bool_attributes, buffer, &bool_attributes_writer, &bool_attributes_validate_params,
        context);
    (*output)->bool_attributes.Set(
        bool_attributes_writer.is_null() ? nullptr : bool_attributes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->bool_attributes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bool_attributes in AXNodeData struct");
    decltype(Traits::intlist_attributes(input)) in_intlist_attributes = Traits::intlist_attributes(input);
    typename decltype((*output)->intlist_attributes)::BaseType::BufferWriter
        intlist_attributes_writer;
    const mojo::internal::ContainerValidateParams intlist_attributes_validate_params(
        new mojo::internal::ContainerValidateParams(0, ::ax::mojom::internal::IntListAttribute_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
    mojo::internal::Serialize<mojo::MapDataView<::ax::mojom::IntListAttribute, mojo::ArrayDataView<int32_t>>>(
        in_intlist_attributes, buffer, &intlist_attributes_writer, &intlist_attributes_validate_params,
        context);
    (*output)->intlist_attributes.Set(
        intlist_attributes_writer.is_null() ? nullptr : intlist_attributes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->intlist_attributes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null intlist_attributes in AXNodeData struct");
    decltype(Traits::stringlist_attributes(input)) in_stringlist_attributes = Traits::stringlist_attributes(input);
    typename decltype((*output)->stringlist_attributes)::BaseType::BufferWriter
        stringlist_attributes_writer;
    const mojo::internal::ContainerValidateParams stringlist_attributes_validate_params(
        new mojo::internal::ContainerValidateParams(0, ::ax::mojom::internal::StringListAttribute_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr))));
    mojo::internal::Serialize<mojo::MapDataView<::ax::mojom::StringListAttribute, mojo::ArrayDataView<mojo::StringDataView>>>(
        in_stringlist_attributes, buffer, &stringlist_attributes_writer, &stringlist_attributes_validate_params,
        context);
    (*output)->stringlist_attributes.Set(
        stringlist_attributes_writer.is_null() ? nullptr : stringlist_attributes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->stringlist_attributes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null stringlist_attributes in AXNodeData struct");
    decltype(Traits::html_attributes(input)) in_html_attributes = Traits::html_attributes(input);
    typename decltype((*output)->html_attributes)::BaseType::BufferWriter
        html_attributes_writer;
    const mojo::internal::ContainerValidateParams html_attributes_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        in_html_attributes, buffer, &html_attributes_writer, &html_attributes_validate_params,
        context);
    (*output)->html_attributes.Set(
        html_attributes_writer.is_null() ? nullptr : html_attributes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->html_attributes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null html_attributes in AXNodeData struct");
    decltype(Traits::child_ids(input)) in_child_ids = Traits::child_ids(input);
    typename decltype((*output)->child_ids)::BaseType::BufferWriter
        child_ids_writer;
    const mojo::internal::ContainerValidateParams child_ids_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
        in_child_ids, buffer, &child_ids_writer, &child_ids_validate_params,
        context);
    (*output)->child_ids.Set(
        child_ids_writer.is_null() ? nullptr : child_ids_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->child_ids.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null child_ids in AXNodeData struct");
    decltype(Traits::relative_bounds(input)) in_relative_bounds = Traits::relative_bounds(input);
    typename decltype((*output)->relative_bounds)::BaseType::BufferWriter
        relative_bounds_writer;
    mojo::internal::Serialize<::ax::mojom::AXRelativeBoundsDataView>(
        in_relative_bounds, buffer, &relative_bounds_writer, context);
    (*output)->relative_bounds.Set(
        relative_bounds_writer.is_null() ? nullptr : relative_bounds_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->relative_bounds.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null relative_bounds in AXNodeData struct");
  }

  static bool Deserialize(::ax::mojom::internal::AXNodeData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXNodeDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax {
namespace mojom {

inline void AXNodeDataDataView::GetStringAttributesDataView(
    mojo::MapDataView<::ax::mojom::StringAttribute, mojo::StringDataView>* output) {
  auto pointer = data_->string_attributes.Get();
  *output = mojo::MapDataView<::ax::mojom::StringAttribute, mojo::StringDataView>(pointer, context_);
}
inline void AXNodeDataDataView::GetIntAttributesDataView(
    mojo::MapDataView<::ax::mojom::IntAttribute, int32_t>* output) {
  auto pointer = data_->int_attributes.Get();
  *output = mojo::MapDataView<::ax::mojom::IntAttribute, int32_t>(pointer, context_);
}
inline void AXNodeDataDataView::GetFloatAttributesDataView(
    mojo::MapDataView<::ax::mojom::FloatAttribute, float>* output) {
  auto pointer = data_->float_attributes.Get();
  *output = mojo::MapDataView<::ax::mojom::FloatAttribute, float>(pointer, context_);
}
inline void AXNodeDataDataView::GetBoolAttributesDataView(
    mojo::MapDataView<::ax::mojom::BoolAttribute, bool>* output) {
  auto pointer = data_->bool_attributes.Get();
  *output = mojo::MapDataView<::ax::mojom::BoolAttribute, bool>(pointer, context_);
}
inline void AXNodeDataDataView::GetIntlistAttributesDataView(
    mojo::MapDataView<::ax::mojom::IntListAttribute, mojo::ArrayDataView<int32_t>>* output) {
  auto pointer = data_->intlist_attributes.Get();
  *output = mojo::MapDataView<::ax::mojom::IntListAttribute, mojo::ArrayDataView<int32_t>>(pointer, context_);
}
inline void AXNodeDataDataView::GetStringlistAttributesDataView(
    mojo::MapDataView<::ax::mojom::StringListAttribute, mojo::ArrayDataView<mojo::StringDataView>>* output) {
  auto pointer = data_->stringlist_attributes.Get();
  *output = mojo::MapDataView<::ax::mojom::StringListAttribute, mojo::ArrayDataView<mojo::StringDataView>>(pointer, context_);
}
inline void AXNodeDataDataView::GetHtmlAttributesDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->html_attributes.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, context_);
}
inline void AXNodeDataDataView::GetChildIdsDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->child_ids.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, context_);
}
inline void AXNodeDataDataView::GetRelativeBoundsDataView(
    ::ax::mojom::AXRelativeBoundsDataView* output) {
  auto pointer = data_->relative_bounds.Get();
  *output = ::ax::mojom::AXRelativeBoundsDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace ax

#endif  // UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_SHARED_H_