// ui/gfx/mojom/native_handle_types.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_H_
#define UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "ui/gfx/mojom/native_handle_types.mojom-shared.h"
#include "ui/gfx/mojom/native_handle_types.mojom-forward.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "ui/gfx/mojom/native_handle_types_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace gfx {
namespace mojom {







class  GpuMemoryBufferPlatformHandle {
 public:
  using DataView = GpuMemoryBufferPlatformHandleDataView;
  using Data_ = internal::GpuMemoryBufferPlatformHandle_Data;
  using Tag = Data_::GpuMemoryBufferPlatformHandle_Tag;

  static GpuMemoryBufferPlatformHandlePtr New() {
    return GpuMemoryBufferPlatformHandlePtr(base::in_place);
  }
  // Construct an instance holding |shared_memory_handle|.
  static GpuMemoryBufferPlatformHandlePtr
  NewSharedMemoryHandle(
      ::base::UnsafeSharedMemoryRegion shared_memory_handle) {
    auto result = GpuMemoryBufferPlatformHandlePtr(base::in_place);
    result->set_shared_memory_handle(std::move(shared_memory_handle));
    return result;
  }
  // Construct an instance holding |native_pixmap_handle|.
  static GpuMemoryBufferPlatformHandlePtr
  NewNativePixmapHandle(
      ::gfx::NativePixmapHandle native_pixmap_handle) {
    auto result = GpuMemoryBufferPlatformHandlePtr(base::in_place);
    result->set_native_pixmap_handle(std::move(native_pixmap_handle));
    return result;
  }

  template <typename U>
  static GpuMemoryBufferPlatformHandlePtr From(const U& u) {
    return mojo::TypeConverter<GpuMemoryBufferPlatformHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuMemoryBufferPlatformHandle>::Convert(*this);
  }

  GpuMemoryBufferPlatformHandle();
  ~GpuMemoryBufferPlatformHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GpuMemoryBufferPlatformHandlePtr>
  GpuMemoryBufferPlatformHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GpuMemoryBufferPlatformHandle>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_shared_memory_handle() const { return tag_ == Tag::SHARED_MEMORY_HANDLE; }

  
  ::base::UnsafeSharedMemoryRegion& get_shared_memory_handle() const {
    DCHECK(tag_ == Tag::SHARED_MEMORY_HANDLE);
    return *(data_.shared_memory_handle);
  }

  
  void set_shared_memory_handle(
      ::base::UnsafeSharedMemoryRegion shared_memory_handle);
  
  bool is_native_pixmap_handle() const { return tag_ == Tag::NATIVE_PIXMAP_HANDLE; }

  
  ::gfx::NativePixmapHandle& get_native_pixmap_handle() const {
    DCHECK(tag_ == Tag::NATIVE_PIXMAP_HANDLE);
    return *(data_.native_pixmap_handle);
  }

  
  void set_native_pixmap_handle(
      ::gfx::NativePixmapHandle native_pixmap_handle);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuMemoryBufferPlatformHandle::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GpuMemoryBufferPlatformHandle::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    ::base::UnsafeSharedMemoryRegion* shared_memory_handle;
    ::gfx::NativePixmapHandle* native_pixmap_handle;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  NativePixmapPlane {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NativePixmapPlane, T>::value>;
  using DataView = NativePixmapPlaneDataView;
  using Data_ = internal::NativePixmapPlane_Data;

  template <typename... Args>
  static NativePixmapPlanePtr New(Args&&... args) {
    return NativePixmapPlanePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NativePixmapPlanePtr From(const U& u) {
    return mojo::TypeConverter<NativePixmapPlanePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NativePixmapPlane>::Convert(*this);
  }


  NativePixmapPlane();

  NativePixmapPlane(
      uint32_t stride,
      uint64_t offset,
      uint64_t size,
      ::mojo::PlatformHandle buffer_handle);

  ~NativePixmapPlane();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NativePixmapPlanePtr>
  NativePixmapPlanePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NativePixmapPlane::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NativePixmapPlane::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NativePixmapPlane::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NativePixmapPlane_UnserializedMessageContext<
            UserType, NativePixmapPlane::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NativePixmapPlane::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return NativePixmapPlane::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NativePixmapPlane_UnserializedMessageContext<
            UserType, NativePixmapPlane::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NativePixmapPlane::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t stride;
  
  uint64_t offset;
  
  uint64_t size;
  
  ::mojo::PlatformHandle buffer_handle;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(NativePixmapPlane);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NativePixmapPlane::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NativePixmapPlane::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NativePixmapPlane::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NativePixmapPlane::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NativePixmapHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NativePixmapHandle, T>::value>;
  using DataView = NativePixmapHandleDataView;
  using Data_ = internal::NativePixmapHandle_Data;

  template <typename... Args>
  static NativePixmapHandlePtr New(Args&&... args) {
    return NativePixmapHandlePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NativePixmapHandlePtr From(const U& u) {
    return mojo::TypeConverter<NativePixmapHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NativePixmapHandle>::Convert(*this);
  }


  NativePixmapHandle();

  NativePixmapHandle(
      std::vector<::gfx::NativePixmapPlane> planes,
      uint64_t modifier);

  ~NativePixmapHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NativePixmapHandlePtr>
  NativePixmapHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NativePixmapHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NativePixmapHandle::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NativePixmapHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NativePixmapHandle_UnserializedMessageContext<
            UserType, NativePixmapHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NativePixmapHandle::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return NativePixmapHandle::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NativePixmapHandle_UnserializedMessageContext<
            UserType, NativePixmapHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NativePixmapHandle::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<::gfx::NativePixmapPlane> planes;
  
  uint64_t modifier;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(NativePixmapHandle);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NativePixmapHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NativePixmapHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NativePixmapHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NativePixmapHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
GpuMemoryBufferPlatformHandlePtr GpuMemoryBufferPlatformHandle::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::SHARED_MEMORY_HANDLE:
      rv->set_shared_memory_handle(mojo::Clone(*data_.shared_memory_handle));
      break;
    case Tag::NATIVE_PIXMAP_HANDLE:
      rv->set_native_pixmap_handle(mojo::Clone(*data_.native_pixmap_handle));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GpuMemoryBufferPlatformHandle>::value>::type*>
bool GpuMemoryBufferPlatformHandle::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::SHARED_MEMORY_HANDLE:
      return mojo::Equals(*(data_.shared_memory_handle), *(other.data_.shared_memory_handle));
    case Tag::NATIVE_PIXMAP_HANDLE:
      return mojo::Equals(*(data_.native_pixmap_handle), *(other.data_.native_pixmap_handle));
  }

  return false;
}
template <typename StructPtrType>
NativePixmapPlanePtr NativePixmapPlane::Clone() const {
  return New(
      mojo::Clone(stride),
      mojo::Clone(offset),
      mojo::Clone(size),
      mojo::Clone(buffer_handle)
  );
}

template <typename T, NativePixmapPlane::EnableIfSame<T>*>
bool NativePixmapPlane::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stride, other_struct.stride))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->buffer_handle, other_struct.buffer_handle))
    return false;
  return true;
}

template <typename T, NativePixmapPlane::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.stride, rhs.stride))
    return true;
  if (std::less<>{}(rhs.stride, lhs.stride))
    return false;
  if (std::less<>{}(lhs.offset, rhs.offset))
    return true;
  if (std::less<>{}(rhs.offset, lhs.offset))
    return false;
  if (std::less<>{}(lhs.size, rhs.size))
    return true;
  if (std::less<>{}(rhs.size, lhs.size))
    return false;
  if (std::less<>{}(lhs.buffer_handle, rhs.buffer_handle))
    return true;
  if (std::less<>{}(rhs.buffer_handle, lhs.buffer_handle))
    return false;
  return false;
}
template <typename StructPtrType>
NativePixmapHandlePtr NativePixmapHandle::Clone() const {
  return New(
      mojo::Clone(planes),
      mojo::Clone(modifier)
  );
}

template <typename T, NativePixmapHandle::EnableIfSame<T>*>
bool NativePixmapHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->planes, other_struct.planes))
    return false;
  if (!mojo::Equals(this->modifier, other_struct.modifier))
    return false;
  return true;
}

template <typename T, NativePixmapHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.planes, rhs.planes))
    return true;
  if (std::less<>{}(rhs.planes, lhs.planes))
    return false;
  if (std::less<>{}(lhs.modifier, rhs.modifier))
    return true;
  if (std::less<>{}(rhs.modifier, lhs.modifier))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace gfx

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::NativePixmapPlane::DataView,
                                         ::gfx::mojom::NativePixmapPlanePtr> {
  static bool IsNull(const ::gfx::mojom::NativePixmapPlanePtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::NativePixmapPlanePtr* output) { output->reset(); }

  static decltype(::gfx::mojom::NativePixmapPlane::stride) stride(
      const ::gfx::mojom::NativePixmapPlanePtr& input) {
    return input->stride;
  }

  static decltype(::gfx::mojom::NativePixmapPlane::offset) offset(
      const ::gfx::mojom::NativePixmapPlanePtr& input) {
    return input->offset;
  }

  static decltype(::gfx::mojom::NativePixmapPlane::size) size(
      const ::gfx::mojom::NativePixmapPlanePtr& input) {
    return input->size;
  }

  static  decltype(::gfx::mojom::NativePixmapPlane::buffer_handle)& buffer_handle(
       ::gfx::mojom::NativePixmapPlanePtr& input) {
    return input->buffer_handle;
  }

  static bool Read(::gfx::mojom::NativePixmapPlane::DataView input, ::gfx::mojom::NativePixmapPlanePtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::NativePixmapHandle::DataView,
                                         ::gfx::mojom::NativePixmapHandlePtr> {
  static bool IsNull(const ::gfx::mojom::NativePixmapHandlePtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::NativePixmapHandlePtr* output) { output->reset(); }

  static  decltype(::gfx::mojom::NativePixmapHandle::planes)& planes(
       ::gfx::mojom::NativePixmapHandlePtr& input) {
    return input->planes;
  }

  static decltype(::gfx::mojom::NativePixmapHandle::modifier) modifier(
      const ::gfx::mojom::NativePixmapHandlePtr& input) {
    return input->modifier;
  }

  static bool Read(::gfx::mojom::NativePixmapHandle::DataView input, ::gfx::mojom::NativePixmapHandlePtr* output);
};


template <>
struct  UnionTraits<::gfx::mojom::GpuMemoryBufferPlatformHandle::DataView,
                                        ::gfx::mojom::GpuMemoryBufferPlatformHandlePtr> {
  static bool IsNull(const ::gfx::mojom::GpuMemoryBufferPlatformHandlePtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::GpuMemoryBufferPlatformHandlePtr* output) { output->reset(); }

  static ::gfx::mojom::GpuMemoryBufferPlatformHandle::Tag GetTag(const ::gfx::mojom::GpuMemoryBufferPlatformHandlePtr& input) {
    return input->which();
  }

  static  ::base::UnsafeSharedMemoryRegion& shared_memory_handle( ::gfx::mojom::GpuMemoryBufferPlatformHandlePtr& input) {
    return input->get_shared_memory_handle();
  }

  static  ::gfx::NativePixmapHandle& native_pixmap_handle( ::gfx::mojom::GpuMemoryBufferPlatformHandlePtr& input) {
    return input->get_native_pixmap_handle();
  }

  static bool Read(::gfx::mojom::GpuMemoryBufferPlatformHandle::DataView input, ::gfx::mojom::GpuMemoryBufferPlatformHandlePtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_H_