// ui/gfx/mojom/swap_timings.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_SWAP_TIMINGS_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_SWAP_TIMINGS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/gfx/mojom/swap_timings.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"







namespace gfx {
namespace mojom {
class SwapTimingsDataView;



}  // namespace mojom
}  // namespace gfx

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::SwapTimingsDataView> {
  using Data = ::gfx::mojom::internal::SwapTimings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx {
namespace mojom {


class SwapTimingsDataView {
 public:
  SwapTimingsDataView() {}

  SwapTimingsDataView(
      internal::SwapTimings_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSwapStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSwapStart(UserType* output) {
    
    auto* pointer = data_->swap_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetSwapEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSwapEnd(UserType* output) {
    
    auto* pointer = data_->swap_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
 private:
  internal::SwapTimings_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace gfx

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::SwapTimingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::SwapTimingsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gfx::mojom::internal::SwapTimings_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::swap_start(input)) in_swap_start = Traits::swap_start(input);
    typename decltype((*output)->swap_start)::BaseType::BufferWriter
        swap_start_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_swap_start, buffer, &swap_start_writer, context);
    (*output)->swap_start.Set(
        swap_start_writer.is_null() ? nullptr : swap_start_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->swap_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null swap_start in SwapTimings struct");
    decltype(Traits::swap_end(input)) in_swap_end = Traits::swap_end(input);
    typename decltype((*output)->swap_end)::BaseType::BufferWriter
        swap_end_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_swap_end, buffer, &swap_end_writer, context);
    (*output)->swap_end.Set(
        swap_end_writer.is_null() ? nullptr : swap_end_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->swap_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null swap_end in SwapTimings struct");
  }

  static bool Deserialize(::gfx::mojom::internal::SwapTimings_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::SwapTimingsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx {
namespace mojom {

inline void SwapTimingsDataView::GetSwapStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->swap_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void SwapTimingsDataView::GetSwapEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->swap_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace gfx

#endif  // UI_GFX_MOJOM_SWAP_TIMINGS_MOJOM_SHARED_H_