// ui/gl/mojom/hdr_metadata.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GL_MOJOM_HDR_METADATA_MOJOM_BLINK_H_
#define UI_GL_MOJOM_HDR_METADATA_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "ui/gl/mojom/hdr_metadata.mojom-shared.h"
#include "ui/gl/mojom/hdr_metadata.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"







// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace gl {
namespace mojom {
namespace blink {









class  MasteringMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MasteringMetadata, T>::value>;
  using DataView = MasteringMetadataDataView;
  using Data_ = internal::MasteringMetadata_Data;

  template <typename... Args>
  static MasteringMetadataPtr New(Args&&... args) {
    return MasteringMetadataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MasteringMetadataPtr From(const U& u) {
    return mojo::TypeConverter<MasteringMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MasteringMetadata>::Convert(*this);
  }


  MasteringMetadata();

  MasteringMetadata(
      const ::gfx::PointF& primary_r,
      const ::gfx::PointF& primary_g,
      const ::gfx::PointF& primary_b,
      const ::gfx::PointF& white_point,
      float luminance_max,
      float luminance_min);

  ~MasteringMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MasteringMetadataPtr>
  MasteringMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MasteringMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MasteringMetadata::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MasteringMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MasteringMetadata_UnserializedMessageContext<
            UserType, MasteringMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MasteringMetadata::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return MasteringMetadata::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MasteringMetadata_UnserializedMessageContext<
            UserType, MasteringMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MasteringMetadata::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::PointF primary_r;
  
  ::gfx::PointF primary_g;
  
  ::gfx::PointF primary_b;
  
  ::gfx::PointF white_point;
  
  float luminance_max;
  
  float luminance_min;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MasteringMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MasteringMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MasteringMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MasteringMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  HDRMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HDRMetadata, T>::value>;
  using DataView = HDRMetadataDataView;
  using Data_ = internal::HDRMetadata_Data;

  template <typename... Args>
  static HDRMetadataPtr New(Args&&... args) {
    return HDRMetadataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HDRMetadataPtr From(const U& u) {
    return mojo::TypeConverter<HDRMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HDRMetadata>::Convert(*this);
  }


  HDRMetadata();

  HDRMetadata(
      MasteringMetadataPtr mastering_metadata,
      uint32_t max_content_light_level,
      uint32_t max_frame_average_light_level);

  ~HDRMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HDRMetadataPtr>
  HDRMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HDRMetadata::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HDRMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HDRMetadata_UnserializedMessageContext<
            UserType, HDRMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HDRMetadata::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return HDRMetadata::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HDRMetadata_UnserializedMessageContext<
            UserType, HDRMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HDRMetadata::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  MasteringMetadataPtr mastering_metadata;
  
  uint32_t max_content_light_level;
  
  uint32_t max_frame_average_light_level;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(HDRMetadata);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MasteringMetadataPtr MasteringMetadata::Clone() const {
  return New(
      mojo::Clone(primary_r),
      mojo::Clone(primary_g),
      mojo::Clone(primary_b),
      mojo::Clone(white_point),
      mojo::Clone(luminance_max),
      mojo::Clone(luminance_min)
  );
}

template <typename T, MasteringMetadata::EnableIfSame<T>*>
bool MasteringMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primary_r, other_struct.primary_r))
    return false;
  if (!mojo::Equals(this->primary_g, other_struct.primary_g))
    return false;
  if (!mojo::Equals(this->primary_b, other_struct.primary_b))
    return false;
  if (!mojo::Equals(this->white_point, other_struct.white_point))
    return false;
  if (!mojo::Equals(this->luminance_max, other_struct.luminance_max))
    return false;
  if (!mojo::Equals(this->luminance_min, other_struct.luminance_min))
    return false;
  return true;
}

template <typename T, MasteringMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.primary_r, rhs.primary_r))
    return true;
  if (std::less<>{}(rhs.primary_r, lhs.primary_r))
    return false;
  if (std::less<>{}(lhs.primary_g, rhs.primary_g))
    return true;
  if (std::less<>{}(rhs.primary_g, lhs.primary_g))
    return false;
  if (std::less<>{}(lhs.primary_b, rhs.primary_b))
    return true;
  if (std::less<>{}(rhs.primary_b, lhs.primary_b))
    return false;
  if (std::less<>{}(lhs.white_point, rhs.white_point))
    return true;
  if (std::less<>{}(rhs.white_point, lhs.white_point))
    return false;
  if (std::less<>{}(lhs.luminance_max, rhs.luminance_max))
    return true;
  if (std::less<>{}(rhs.luminance_max, lhs.luminance_max))
    return false;
  if (std::less<>{}(lhs.luminance_min, rhs.luminance_min))
    return true;
  if (std::less<>{}(rhs.luminance_min, lhs.luminance_min))
    return false;
  return false;
}
template <typename StructPtrType>
HDRMetadataPtr HDRMetadata::Clone() const {
  return New(
      mojo::Clone(mastering_metadata),
      mojo::Clone(max_content_light_level),
      mojo::Clone(max_frame_average_light_level)
  );
}

template <typename T, HDRMetadata::EnableIfSame<T>*>
bool HDRMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mastering_metadata, other_struct.mastering_metadata))
    return false;
  if (!mojo::Equals(this->max_content_light_level, other_struct.max_content_light_level))
    return false;
  if (!mojo::Equals(this->max_frame_average_light_level, other_struct.max_frame_average_light_level))
    return false;
  return true;
}

template <typename T, HDRMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.mastering_metadata, rhs.mastering_metadata))
    return true;
  if (std::less<>{}(rhs.mastering_metadata, lhs.mastering_metadata))
    return false;
  if (std::less<>{}(lhs.max_content_light_level, rhs.max_content_light_level))
    return true;
  if (std::less<>{}(rhs.max_content_light_level, lhs.max_content_light_level))
    return false;
  if (std::less<>{}(lhs.max_frame_average_light_level, rhs.max_frame_average_light_level))
    return true;
  if (std::less<>{}(rhs.max_frame_average_light_level, lhs.max_frame_average_light_level))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace gl

namespace mojo {


template <>
struct  StructTraits<::gl::mojom::blink::MasteringMetadata::DataView,
                                         ::gl::mojom::blink::MasteringMetadataPtr> {
  static bool IsNull(const ::gl::mojom::blink::MasteringMetadataPtr& input) { return !input; }
  static void SetToNull(::gl::mojom::blink::MasteringMetadataPtr* output) { output->reset(); }

  static const decltype(::gl::mojom::blink::MasteringMetadata::primary_r)& primary_r(
      const ::gl::mojom::blink::MasteringMetadataPtr& input) {
    return input->primary_r;
  }

  static const decltype(::gl::mojom::blink::MasteringMetadata::primary_g)& primary_g(
      const ::gl::mojom::blink::MasteringMetadataPtr& input) {
    return input->primary_g;
  }

  static const decltype(::gl::mojom::blink::MasteringMetadata::primary_b)& primary_b(
      const ::gl::mojom::blink::MasteringMetadataPtr& input) {
    return input->primary_b;
  }

  static const decltype(::gl::mojom::blink::MasteringMetadata::white_point)& white_point(
      const ::gl::mojom::blink::MasteringMetadataPtr& input) {
    return input->white_point;
  }

  static decltype(::gl::mojom::blink::MasteringMetadata::luminance_max) luminance_max(
      const ::gl::mojom::blink::MasteringMetadataPtr& input) {
    return input->luminance_max;
  }

  static decltype(::gl::mojom::blink::MasteringMetadata::luminance_min) luminance_min(
      const ::gl::mojom::blink::MasteringMetadataPtr& input) {
    return input->luminance_min;
  }

  static bool Read(::gl::mojom::blink::MasteringMetadata::DataView input, ::gl::mojom::blink::MasteringMetadataPtr* output);
};


template <>
struct  StructTraits<::gl::mojom::blink::HDRMetadata::DataView,
                                         ::gl::mojom::blink::HDRMetadataPtr> {
  static bool IsNull(const ::gl::mojom::blink::HDRMetadataPtr& input) { return !input; }
  static void SetToNull(::gl::mojom::blink::HDRMetadataPtr* output) { output->reset(); }

  static const decltype(::gl::mojom::blink::HDRMetadata::mastering_metadata)& mastering_metadata(
      const ::gl::mojom::blink::HDRMetadataPtr& input) {
    return input->mastering_metadata;
  }

  static decltype(::gl::mojom::blink::HDRMetadata::max_content_light_level) max_content_light_level(
      const ::gl::mojom::blink::HDRMetadataPtr& input) {
    return input->max_content_light_level;
  }

  static decltype(::gl::mojom::blink::HDRMetadata::max_frame_average_light_level) max_frame_average_light_level(
      const ::gl::mojom::blink::HDRMetadataPtr& input) {
    return input->max_frame_average_light_level;
  }

  static bool Read(::gl::mojom::blink::HDRMetadata::DataView input, ::gl::mojom::blink::HDRMetadataPtr* output);
};

}  // namespace mojo

#endif  // UI_GL_MOJOM_HDR_METADATA_MOJOM_BLINK_H_