# frozen_string_literal: true

require_relative '../../../spec_helper'

describe Wpxf::Net::CookieJar do
  let(:subject) { Wpxf::Net::CookieJar.new }

  describe '#parse_cookie' do
    it 'parses a single cookie into the hash' do
      cookie = { 'key' => 'value' }
      expect(subject.parse_cookie('key=value; path=/')).to eq cookie
    end
  end

  describe '#parse' do
    it 'parses a single cookie into the hash when the arg is a string' do
      cookie = { 'key' => 'value' }
      expect(subject.parse('key=value; path=/')).to eq cookie
    end

    it 'parses multiple cookies into the hash when the arg is an array' do
      cookies = { 'key' => 'value', 'foo' => 'bar' }
      raw_cookies = ['key=value; path=/', 'foo=bar; path=/']
      expect(subject.parse(raw_cookies)).to eq cookies
    end
  end
end
