// A Bison parser, made by GNU Bison 3.8.2.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.



// First part of user prologue.
#line 11 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"

namespace hilti { namespace detail { class Parser; } }

#include <hilti/compiler/context.h>
#include <hilti/compiler/detail/parser/driver.h>
#include <hilti/ast/builder/all.h>

#line 41 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"


#include <hilti/compiler/detail/parser/scanner.h>

#undef yylex
#define yylex driver->scanner()->lex

static hilti::Meta toMeta(hilti::detail::parser::location l) {
    return hilti::Meta(hilti::Location(*l.begin.filename, l.begin.line, l.end.line, l.begin.column,
                                       (l.end.column > 0 ? l.end.column - 1 : 0)));
}

static hilti::QualifiedType* iteratorForType(hilti::Builder* builder, hilti::QualifiedType* t, hilti::Meta m) {
    if ( auto iter = t->type()->iteratorType() )
        return iter;
    else {
        hilti::logger().error(hilti::util::fmt("type '%s' is not iterable", *t), m.location());
        return builder->qualifiedType(builder->typeError(), hilti::Constness::Const);
        }
}

static hilti::QualifiedType* viewForType(hilti::Builder* builder, hilti::QualifiedType* t, hilti::Meta m) {
    if ( auto v = t->type()->viewType() )
        return v;
    else {
        hilti::logger().error(hilti::util::fmt("type '%s' is not viewable", *t), m.location());
        return builder->qualifiedType(builder->typeError(), hilti::Constness::Const);
        }
}

#define __loc__ toMeta(yylhs.location)

#define YYLLOC_DEFAULT(Current, Rhs, N)                                                                                \
do {                                                                                                                   \
    bool done = false;                                                                                                 \
    for ( int i = 1; i <= N; i++ ) {                                                                                   \
        if ( YYRHSLOC(Rhs, i).begin.line != YYRHSLOC(Rhs, i).end.line ||                                               \
             YYRHSLOC(Rhs, i).begin.column != YYRHSLOC(Rhs, i).end.column ) {                                          \
            (Current).begin = YYRHSLOC(Rhs, i).begin;                                                                  \
            (Current).end = YYRHSLOC(Rhs, N).end;                                                                      \
            done = true;                                                                                               \
            break;                                                                                                     \
        }                                                                                                              \
    }                                                                                                                  \
    if ( ! done )                                                                                                      \
        (Current).begin = (Current).end = YYRHSLOC(Rhs, 0).end;                                                        \
} while ( false )

static int _field_width = 0;


#line 101 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"


#include "__parser.h"




#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif


// Whether we are compiled with exception support.
#ifndef YY_EXCEPTIONS
# if defined __GNUC__ && !defined __EXCEPTIONS
#  define YY_EXCEPTIONS 0
# else
#  define YY_EXCEPTIONS 1
# endif
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K].location)
/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

# ifndef YYLLOC_DEFAULT
#  define YYLLOC_DEFAULT(Current, Rhs, N)                               \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).begin  = YYRHSLOC (Rhs, 1).begin;                   \
          (Current).end    = YYRHSLOC (Rhs, N).end;                     \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).begin = (Current).end = YYRHSLOC (Rhs, 0).end;      \
        }                                                               \
    while (false)
# endif


// Enable debugging if requested.
#if YYDEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << '\n';                       \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yy_stack_print_ ();                \
  } while (false)

#else // !YYDEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YY_USE (Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void> (0)
# define YY_STACK_PRINT()                static_cast<void> (0)

#endif // !YYDEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyla.clear ())

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)

#line 29 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
namespace hilti { namespace detail { namespace parser {
#line 199 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"

  /// Build a parser object.
  Parser::Parser (Driver* driver_yyarg, Builder* builder_yyarg)
#if YYDEBUG
    : yydebug_ (false),
      yycdebug_ (&std::cerr),
#else
    :
#endif
      driver (driver_yyarg),
      builder (builder_yyarg)
  {}

  Parser::~Parser ()
  {}

  Parser::syntax_error::~syntax_error () YY_NOEXCEPT YY_NOTHROW
  {}

  /*---------.
  | symbol.  |
  `---------*/

  // basic_symbol.
  template <typename Base>
  Parser::basic_symbol<Base>::basic_symbol (const basic_symbol& that)
    : Base (that)
    , value ()
    , location (that.location)
  {
    switch (this->kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
        value.copy< bool > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.copy< double > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_attribute: // attribute
        value.copy< hilti::Attribute* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_attributes: // opt_attributes
        value.copy< hilti::AttributeSet* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.copy< hilti::Ctor* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_struct_field: // struct_field
      case symbol_kind::S_union_field: // union_field
        value.copy< hilti::Declaration* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_fields: // struct_fields
      case symbol_kind::S_opt_union_fields: // opt_union_fields
      case symbol_kind::S_union_fields: // union_fields
        value.copy< hilti::Declarations > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_default_expr: // opt_func_default_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.copy< hilti::Expression* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_type_arguments: // opt_type_arguments
      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.copy< hilti::Expressions > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_function_with_body: // function_with_body
      case symbol_kind::S_method_with_body: // method_with_body
      case symbol_kind::S_hook_with_body: // hook_with_body
      case symbol_kind::S_function_without_body: // function_without_body
        value.copy< hilti::Function* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_function_id: // function_id
      case symbol_kind::S_scoped_function_id: // scoped_function_id
        value.copy< hilti::ID > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_qtype: // qtype
        value.copy< hilti::QualifiedType* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.copy< hilti::Statement* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.copy< hilti::Statements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_func_param_type: // func_param_type
      case symbol_kind::S_base_type_no_attrs: // base_type_no_attrs
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_function_type: // function_type
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_union_type: // union_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
        value.copy< hilti::UnqualifiedType* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.copy< hilti::ctor::map::Element* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.copy< hilti::ctor::map::Elements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.copy< hilti::ctor::regexp::Pattern > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.copy< hilti::ctor::regexp::Patterns > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.copy< hilti::ctor::struct_::Field* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.copy< hilti::ctor::struct_::Fields > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.copy< hilti::declaration::Linkage > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.copy< hilti::parameter::Kind > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.copy< hilti::statement::switch_::Case* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_switch_cases: // opt_switch_cases
      case symbol_kind::S_switch_cases: // switch_cases
        value.copy< hilti::statement::switch_::Cases > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_try_catch: // try_catch
        value.copy< hilti::statement::try_::Catch* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_try_catches: // try_catches
        value.copy< hilti::statement::try_::Catches > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.copy< hilti::type::bitfield::BitRange* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.copy< hilti::type::bitfield::BitRanges > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.copy< hilti::type::enum_::Label* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.copy< hilti::type::enum_::Labels > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.copy< hilti::type::function::CallingConvention > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
      case symbol_kind::S_func_flavor: // func_flavor
        value.copy< hilti::type::function::Flavor > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_func_param: // func_param
        value.copy< hilti::type::function::Parameter* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_struct_params: // opt_struct_params
        value.copy< hilti::type::function::Parameters > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.copy< hilti::type::tuple::Element* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.copy< hilti::type::tuple::Elements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.copy< std::pair<Declarations, Statements> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_SCOPED_FINALIZE: // "scoped ~finally"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.copy< std::string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
        value.copy< uint64_t > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

  }




  template <typename Base>
  Parser::symbol_kind_type
  Parser::basic_symbol<Base>::type_get () const YY_NOEXCEPT
  {
    return this->kind ();
  }


  template <typename Base>
  bool
  Parser::basic_symbol<Base>::empty () const YY_NOEXCEPT
  {
    return this->kind () == symbol_kind::S_YYEMPTY;
  }

  template <typename Base>
  void
  Parser::basic_symbol<Base>::move (basic_symbol& s)
  {
    super_type::move (s);
    switch (this->kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
        value.move< bool > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.move< double > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_attribute: // attribute
        value.move< hilti::Attribute* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_attributes: // opt_attributes
        value.move< hilti::AttributeSet* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.move< hilti::Ctor* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_struct_field: // struct_field
      case symbol_kind::S_union_field: // union_field
        value.move< hilti::Declaration* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_struct_fields: // struct_fields
      case symbol_kind::S_opt_union_fields: // opt_union_fields
      case symbol_kind::S_union_fields: // union_fields
        value.move< hilti::Declarations > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_func_default_expr: // opt_func_default_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.move< hilti::Expression* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_type_arguments: // opt_type_arguments
      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.move< hilti::Expressions > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_function_with_body: // function_with_body
      case symbol_kind::S_method_with_body: // method_with_body
      case symbol_kind::S_hook_with_body: // hook_with_body
      case symbol_kind::S_function_without_body: // function_without_body
        value.move< hilti::Function* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_function_id: // function_id
      case symbol_kind::S_scoped_function_id: // scoped_function_id
        value.move< hilti::ID > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_qtype: // qtype
        value.move< hilti::QualifiedType* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.move< hilti::Statement* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.move< hilti::Statements > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_func_param_type: // func_param_type
      case symbol_kind::S_base_type_no_attrs: // base_type_no_attrs
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_function_type: // function_type
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_union_type: // union_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
        value.move< hilti::UnqualifiedType* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.move< hilti::ctor::map::Element* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.move< hilti::ctor::map::Elements > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.move< hilti::ctor::regexp::Pattern > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.move< hilti::ctor::regexp::Patterns > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.move< hilti::ctor::struct_::Field* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.move< hilti::ctor::struct_::Fields > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.move< hilti::declaration::Linkage > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.move< hilti::parameter::Kind > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.move< hilti::statement::switch_::Case* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_switch_cases: // opt_switch_cases
      case symbol_kind::S_switch_cases: // switch_cases
        value.move< hilti::statement::switch_::Cases > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_try_catch: // try_catch
        value.move< hilti::statement::try_::Catch* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_try_catches: // try_catches
        value.move< hilti::statement::try_::Catches > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.move< hilti::type::bitfield::BitRange* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.move< hilti::type::bitfield::BitRanges > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.move< hilti::type::enum_::Label* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.move< hilti::type::enum_::Labels > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.move< hilti::type::function::CallingConvention > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
      case symbol_kind::S_func_flavor: // func_flavor
        value.move< hilti::type::function::Flavor > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_func_param: // func_param
        value.move< hilti::type::function::Parameter* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_struct_params: // opt_struct_params
        value.move< hilti::type::function::Parameters > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.move< hilti::type::tuple::Element* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.move< hilti::type::tuple::Elements > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.move< std::pair<Declarations, Statements> > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_SCOPED_FINALIZE: // "scoped ~finally"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.move< std::string > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
        value.move< uint64_t > (YY_MOVE (s.value));
        break;

      default:
        break;
    }

    location = YY_MOVE (s.location);
  }

  // by_kind.
  Parser::by_kind::by_kind () YY_NOEXCEPT
    : kind_ (symbol_kind::S_YYEMPTY)
  {}

#if 201103L <= YY_CPLUSPLUS
  Parser::by_kind::by_kind (by_kind&& that) YY_NOEXCEPT
    : kind_ (that.kind_)
  {
    that.clear ();
  }
#endif

  Parser::by_kind::by_kind (const by_kind& that) YY_NOEXCEPT
    : kind_ (that.kind_)
  {}

  Parser::by_kind::by_kind (token_kind_type t) YY_NOEXCEPT
    : kind_ (yytranslate_ (t))
  {}



  void
  Parser::by_kind::clear () YY_NOEXCEPT
  {
    kind_ = symbol_kind::S_YYEMPTY;
  }

  void
  Parser::by_kind::move (by_kind& that)
  {
    kind_ = that.kind_;
    that.clear ();
  }

  Parser::symbol_kind_type
  Parser::by_kind::kind () const YY_NOEXCEPT
  {
    return kind_;
  }


  Parser::symbol_kind_type
  Parser::by_kind::type_get () const YY_NOEXCEPT
  {
    return this->kind ();
  }



  // by_state.
  Parser::by_state::by_state () YY_NOEXCEPT
    : state (empty_state)
  {}

  Parser::by_state::by_state (const by_state& that) YY_NOEXCEPT
    : state (that.state)
  {}

  void
  Parser::by_state::clear () YY_NOEXCEPT
  {
    state = empty_state;
  }

  void
  Parser::by_state::move (by_state& that)
  {
    state = that.state;
    that.clear ();
  }

  Parser::by_state::by_state (state_type s) YY_NOEXCEPT
    : state (s)
  {}

  Parser::symbol_kind_type
  Parser::by_state::kind () const YY_NOEXCEPT
  {
    if (state == empty_state)
      return symbol_kind::S_YYEMPTY;
    else
      return YY_CAST (symbol_kind_type, yystos_[+state]);
  }

  Parser::stack_symbol_type::stack_symbol_type ()
  {}

  Parser::stack_symbol_type::stack_symbol_type (YY_RVREF (stack_symbol_type) that)
    : super_type (YY_MOVE (that.state), YY_MOVE (that.location))
  {
    switch (that.kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
        value.YY_MOVE_OR_COPY< bool > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.YY_MOVE_OR_COPY< double > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_attribute: // attribute
        value.YY_MOVE_OR_COPY< hilti::Attribute* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_attributes: // opt_attributes
        value.YY_MOVE_OR_COPY< hilti::AttributeSet* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.YY_MOVE_OR_COPY< hilti::Ctor* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_struct_field: // struct_field
      case symbol_kind::S_union_field: // union_field
        value.YY_MOVE_OR_COPY< hilti::Declaration* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_fields: // struct_fields
      case symbol_kind::S_opt_union_fields: // opt_union_fields
      case symbol_kind::S_union_fields: // union_fields
        value.YY_MOVE_OR_COPY< hilti::Declarations > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_default_expr: // opt_func_default_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.YY_MOVE_OR_COPY< hilti::Expression* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_type_arguments: // opt_type_arguments
      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.YY_MOVE_OR_COPY< hilti::Expressions > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_function_with_body: // function_with_body
      case symbol_kind::S_method_with_body: // method_with_body
      case symbol_kind::S_hook_with_body: // hook_with_body
      case symbol_kind::S_function_without_body: // function_without_body
        value.YY_MOVE_OR_COPY< hilti::Function* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_function_id: // function_id
      case symbol_kind::S_scoped_function_id: // scoped_function_id
        value.YY_MOVE_OR_COPY< hilti::ID > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_qtype: // qtype
        value.YY_MOVE_OR_COPY< hilti::QualifiedType* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.YY_MOVE_OR_COPY< hilti::Statement* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.YY_MOVE_OR_COPY< hilti::Statements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_func_param_type: // func_param_type
      case symbol_kind::S_base_type_no_attrs: // base_type_no_attrs
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_function_type: // function_type
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_union_type: // union_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
        value.YY_MOVE_OR_COPY< hilti::UnqualifiedType* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.YY_MOVE_OR_COPY< hilti::ctor::map::Element* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.YY_MOVE_OR_COPY< hilti::ctor::map::Elements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.YY_MOVE_OR_COPY< hilti::ctor::regexp::Pattern > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.YY_MOVE_OR_COPY< hilti::ctor::regexp::Patterns > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.YY_MOVE_OR_COPY< hilti::ctor::struct_::Field* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.YY_MOVE_OR_COPY< hilti::ctor::struct_::Fields > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.YY_MOVE_OR_COPY< hilti::declaration::Linkage > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.YY_MOVE_OR_COPY< hilti::parameter::Kind > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.YY_MOVE_OR_COPY< hilti::statement::switch_::Case* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_switch_cases: // opt_switch_cases
      case symbol_kind::S_switch_cases: // switch_cases
        value.YY_MOVE_OR_COPY< hilti::statement::switch_::Cases > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_try_catch: // try_catch
        value.YY_MOVE_OR_COPY< hilti::statement::try_::Catch* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_try_catches: // try_catches
        value.YY_MOVE_OR_COPY< hilti::statement::try_::Catches > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.YY_MOVE_OR_COPY< hilti::type::bitfield::BitRange* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.YY_MOVE_OR_COPY< hilti::type::bitfield::BitRanges > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.YY_MOVE_OR_COPY< hilti::type::enum_::Label* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.YY_MOVE_OR_COPY< hilti::type::enum_::Labels > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.YY_MOVE_OR_COPY< hilti::type::function::CallingConvention > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
      case symbol_kind::S_func_flavor: // func_flavor
        value.YY_MOVE_OR_COPY< hilti::type::function::Flavor > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_func_param: // func_param
        value.YY_MOVE_OR_COPY< hilti::type::function::Parameter* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_struct_params: // opt_struct_params
        value.YY_MOVE_OR_COPY< hilti::type::function::Parameters > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.YY_MOVE_OR_COPY< hilti::type::tuple::Element* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.YY_MOVE_OR_COPY< hilti::type::tuple::Elements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.YY_MOVE_OR_COPY< std::pair<Declarations, Statements> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_SCOPED_FINALIZE: // "scoped ~finally"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.YY_MOVE_OR_COPY< std::string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
        value.YY_MOVE_OR_COPY< uint64_t > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

#if 201103L <= YY_CPLUSPLUS
    // that is emptied.
    that.state = empty_state;
#endif
  }

  Parser::stack_symbol_type::stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) that)
    : super_type (s, YY_MOVE (that.location))
  {
    switch (that.kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
        value.move< bool > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.move< double > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_attribute: // attribute
        value.move< hilti::Attribute* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_attributes: // opt_attributes
        value.move< hilti::AttributeSet* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.move< hilti::Ctor* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_struct_field: // struct_field
      case symbol_kind::S_union_field: // union_field
        value.move< hilti::Declaration* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_fields: // struct_fields
      case symbol_kind::S_opt_union_fields: // opt_union_fields
      case symbol_kind::S_union_fields: // union_fields
        value.move< hilti::Declarations > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_default_expr: // opt_func_default_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.move< hilti::Expression* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_type_arguments: // opt_type_arguments
      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.move< hilti::Expressions > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_function_with_body: // function_with_body
      case symbol_kind::S_method_with_body: // method_with_body
      case symbol_kind::S_hook_with_body: // hook_with_body
      case symbol_kind::S_function_without_body: // function_without_body
        value.move< hilti::Function* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_function_id: // function_id
      case symbol_kind::S_scoped_function_id: // scoped_function_id
        value.move< hilti::ID > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_qtype: // qtype
        value.move< hilti::QualifiedType* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.move< hilti::Statement* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.move< hilti::Statements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_func_param_type: // func_param_type
      case symbol_kind::S_base_type_no_attrs: // base_type_no_attrs
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_function_type: // function_type
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_union_type: // union_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
        value.move< hilti::UnqualifiedType* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.move< hilti::ctor::map::Element* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.move< hilti::ctor::map::Elements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.move< hilti::ctor::regexp::Pattern > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.move< hilti::ctor::regexp::Patterns > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.move< hilti::ctor::struct_::Field* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.move< hilti::ctor::struct_::Fields > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.move< hilti::declaration::Linkage > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.move< hilti::parameter::Kind > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.move< hilti::statement::switch_::Case* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_switch_cases: // opt_switch_cases
      case symbol_kind::S_switch_cases: // switch_cases
        value.move< hilti::statement::switch_::Cases > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_try_catch: // try_catch
        value.move< hilti::statement::try_::Catch* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_try_catches: // try_catches
        value.move< hilti::statement::try_::Catches > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.move< hilti::type::bitfield::BitRange* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.move< hilti::type::bitfield::BitRanges > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.move< hilti::type::enum_::Label* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.move< hilti::type::enum_::Labels > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.move< hilti::type::function::CallingConvention > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
      case symbol_kind::S_func_flavor: // func_flavor
        value.move< hilti::type::function::Flavor > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_func_param: // func_param
        value.move< hilti::type::function::Parameter* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_struct_params: // opt_struct_params
        value.move< hilti::type::function::Parameters > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.move< hilti::type::tuple::Element* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.move< hilti::type::tuple::Elements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.move< std::pair<Declarations, Statements> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_SCOPED_FINALIZE: // "scoped ~finally"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.move< std::string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
        value.move< uint64_t > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

    // that is emptied.
    that.kind_ = symbol_kind::S_YYEMPTY;
  }

#if YY_CPLUSPLUS < 201103L
  Parser::stack_symbol_type&
  Parser::stack_symbol_type::operator= (const stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
        value.copy< bool > (that.value);
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.copy< double > (that.value);
        break;

      case symbol_kind::S_attribute: // attribute
        value.copy< hilti::Attribute* > (that.value);
        break;

      case symbol_kind::S_opt_attributes: // opt_attributes
        value.copy< hilti::AttributeSet* > (that.value);
        break;

      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.copy< hilti::Ctor* > (that.value);
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_struct_field: // struct_field
      case symbol_kind::S_union_field: // union_field
        value.copy< hilti::Declaration* > (that.value);
        break;

      case symbol_kind::S_struct_fields: // struct_fields
      case symbol_kind::S_opt_union_fields: // opt_union_fields
      case symbol_kind::S_union_fields: // union_fields
        value.copy< hilti::Declarations > (that.value);
        break;

      case symbol_kind::S_opt_func_default_expr: // opt_func_default_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.copy< hilti::Expression* > (that.value);
        break;

      case symbol_kind::S_opt_type_arguments: // opt_type_arguments
      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.copy< hilti::Expressions > (that.value);
        break;

      case symbol_kind::S_function_with_body: // function_with_body
      case symbol_kind::S_method_with_body: // method_with_body
      case symbol_kind::S_hook_with_body: // hook_with_body
      case symbol_kind::S_function_without_body: // function_without_body
        value.copy< hilti::Function* > (that.value);
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_function_id: // function_id
      case symbol_kind::S_scoped_function_id: // scoped_function_id
        value.copy< hilti::ID > (that.value);
        break;

      case symbol_kind::S_qtype: // qtype
        value.copy< hilti::QualifiedType* > (that.value);
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.copy< hilti::Statement* > (that.value);
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.copy< hilti::Statements > (that.value);
        break;

      case symbol_kind::S_func_param_type: // func_param_type
      case symbol_kind::S_base_type_no_attrs: // base_type_no_attrs
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_function_type: // function_type
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_union_type: // union_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
        value.copy< hilti::UnqualifiedType* > (that.value);
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.copy< hilti::ctor::map::Element* > (that.value);
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.copy< hilti::ctor::map::Elements > (that.value);
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.copy< hilti::ctor::regexp::Pattern > (that.value);
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.copy< hilti::ctor::regexp::Patterns > (that.value);
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.copy< hilti::ctor::struct_::Field* > (that.value);
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.copy< hilti::ctor::struct_::Fields > (that.value);
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.copy< hilti::declaration::Linkage > (that.value);
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.copy< hilti::parameter::Kind > (that.value);
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.copy< hilti::statement::switch_::Case* > (that.value);
        break;

      case symbol_kind::S_opt_switch_cases: // opt_switch_cases
      case symbol_kind::S_switch_cases: // switch_cases
        value.copy< hilti::statement::switch_::Cases > (that.value);
        break;

      case symbol_kind::S_try_catch: // try_catch
        value.copy< hilti::statement::try_::Catch* > (that.value);
        break;

      case symbol_kind::S_try_catches: // try_catches
        value.copy< hilti::statement::try_::Catches > (that.value);
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.copy< hilti::type::bitfield::BitRange* > (that.value);
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.copy< hilti::type::bitfield::BitRanges > (that.value);
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.copy< hilti::type::enum_::Label* > (that.value);
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.copy< hilti::type::enum_::Labels > (that.value);
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.copy< hilti::type::function::CallingConvention > (that.value);
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
      case symbol_kind::S_func_flavor: // func_flavor
        value.copy< hilti::type::function::Flavor > (that.value);
        break;

      case symbol_kind::S_func_param: // func_param
        value.copy< hilti::type::function::Parameter* > (that.value);
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_struct_params: // opt_struct_params
        value.copy< hilti::type::function::Parameters > (that.value);
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.copy< hilti::type::tuple::Element* > (that.value);
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.copy< hilti::type::tuple::Elements > (that.value);
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.copy< std::pair<Declarations, Statements> > (that.value);
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_SCOPED_FINALIZE: // "scoped ~finally"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.copy< std::string > (that.value);
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
        value.copy< uint64_t > (that.value);
        break;

      default:
        break;
    }

    location = that.location;
    return *this;
  }

  Parser::stack_symbol_type&
  Parser::stack_symbol_type::operator= (stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
        value.move< bool > (that.value);
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.move< double > (that.value);
        break;

      case symbol_kind::S_attribute: // attribute
        value.move< hilti::Attribute* > (that.value);
        break;

      case symbol_kind::S_opt_attributes: // opt_attributes
        value.move< hilti::AttributeSet* > (that.value);
        break;

      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.move< hilti::Ctor* > (that.value);
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_struct_field: // struct_field
      case symbol_kind::S_union_field: // union_field
        value.move< hilti::Declaration* > (that.value);
        break;

      case symbol_kind::S_struct_fields: // struct_fields
      case symbol_kind::S_opt_union_fields: // opt_union_fields
      case symbol_kind::S_union_fields: // union_fields
        value.move< hilti::Declarations > (that.value);
        break;

      case symbol_kind::S_opt_func_default_expr: // opt_func_default_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.move< hilti::Expression* > (that.value);
        break;

      case symbol_kind::S_opt_type_arguments: // opt_type_arguments
      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.move< hilti::Expressions > (that.value);
        break;

      case symbol_kind::S_function_with_body: // function_with_body
      case symbol_kind::S_method_with_body: // method_with_body
      case symbol_kind::S_hook_with_body: // hook_with_body
      case symbol_kind::S_function_without_body: // function_without_body
        value.move< hilti::Function* > (that.value);
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_function_id: // function_id
      case symbol_kind::S_scoped_function_id: // scoped_function_id
        value.move< hilti::ID > (that.value);
        break;

      case symbol_kind::S_qtype: // qtype
        value.move< hilti::QualifiedType* > (that.value);
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.move< hilti::Statement* > (that.value);
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.move< hilti::Statements > (that.value);
        break;

      case symbol_kind::S_func_param_type: // func_param_type
      case symbol_kind::S_base_type_no_attrs: // base_type_no_attrs
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_function_type: // function_type
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_union_type: // union_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
        value.move< hilti::UnqualifiedType* > (that.value);
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.move< hilti::ctor::map::Element* > (that.value);
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.move< hilti::ctor::map::Elements > (that.value);
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.move< hilti::ctor::regexp::Pattern > (that.value);
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.move< hilti::ctor::regexp::Patterns > (that.value);
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.move< hilti::ctor::struct_::Field* > (that.value);
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.move< hilti::ctor::struct_::Fields > (that.value);
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.move< hilti::declaration::Linkage > (that.value);
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.move< hilti::parameter::Kind > (that.value);
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.move< hilti::statement::switch_::Case* > (that.value);
        break;

      case symbol_kind::S_opt_switch_cases: // opt_switch_cases
      case symbol_kind::S_switch_cases: // switch_cases
        value.move< hilti::statement::switch_::Cases > (that.value);
        break;

      case symbol_kind::S_try_catch: // try_catch
        value.move< hilti::statement::try_::Catch* > (that.value);
        break;

      case symbol_kind::S_try_catches: // try_catches
        value.move< hilti::statement::try_::Catches > (that.value);
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.move< hilti::type::bitfield::BitRange* > (that.value);
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.move< hilti::type::bitfield::BitRanges > (that.value);
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.move< hilti::type::enum_::Label* > (that.value);
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.move< hilti::type::enum_::Labels > (that.value);
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.move< hilti::type::function::CallingConvention > (that.value);
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
      case symbol_kind::S_func_flavor: // func_flavor
        value.move< hilti::type::function::Flavor > (that.value);
        break;

      case symbol_kind::S_func_param: // func_param
        value.move< hilti::type::function::Parameter* > (that.value);
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_struct_params: // opt_struct_params
        value.move< hilti::type::function::Parameters > (that.value);
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.move< hilti::type::tuple::Element* > (that.value);
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.move< hilti::type::tuple::Elements > (that.value);
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.move< std::pair<Declarations, Statements> > (that.value);
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_SCOPED_FINALIZE: // "scoped ~finally"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.move< std::string > (that.value);
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
        value.move< uint64_t > (that.value);
        break;

      default:
        break;
    }

    location = that.location;
    // that is emptied.
    that.state = empty_state;
    return *this;
  }
#endif

  template <typename Base>
  void
  Parser::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);
  }

#if YYDEBUG
  template <typename Base>
  void
  Parser::yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YY_USE (yyoutput);
    if (yysym.empty ())
      yyo << "empty symbol";
    else
      {
        symbol_kind_type yykind = yysym.kind ();
        yyo << (yykind < YYNTOKENS ? "token" : "nterm")
            << ' ' << yysym.name () << " ("
            << yysym.location << ": ";
        YY_USE (yykind);
        yyo << ')';
      }
  }
#endif

  void
  Parser::yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym)
  {
    if (m)
      YY_SYMBOL_PRINT (m, sym);
    yystack_.push (YY_MOVE (sym));
  }

  void
  Parser::yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym)
  {
#if 201103L <= YY_CPLUSPLUS
    yypush_ (m, stack_symbol_type (s, std::move (sym)));
#else
    stack_symbol_type ss (s, sym);
    yypush_ (m, ss);
#endif
  }

  void
  Parser::yypop_ (int n) YY_NOEXCEPT
  {
    yystack_.pop (n);
  }

#if YYDEBUG
  std::ostream&
  Parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  Parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  Parser::debug_level_type
  Parser::debug_level () const
  {
    return yydebug_;
  }

  void
  Parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // YYDEBUG

  Parser::state_type
  Parser::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - YYNTOKENS] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - YYNTOKENS];
  }

  bool
  Parser::yy_pact_value_is_default_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yypact_ninf_;
  }

  bool
  Parser::yy_table_value_is_error_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yytable_ninf_;
  }

  int
  Parser::operator() ()
  {
    return parse ();
  }

  int
  Parser::parse ()
  {
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The locations where the error started and ended.
    stack_symbol_type yyerror_range[3];

    /// The return value of parse ().
    int yyresult;

#if YY_EXCEPTIONS
    try
#endif // YY_EXCEPTIONS
      {
    YYCDEBUG << "Starting parse\n";


    // User initialization code.
#line 22 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
{
    yyla.location.begin.filename = yyla.location.end.filename = driver->currentFile();
}

#line 1947 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"


    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, YY_MOVE (yyla));

  /*-----------------------------------------------.
  | yynewstate -- push a new symbol on the stack.  |
  `-----------------------------------------------*/
  yynewstate:
    YYCDEBUG << "Entering state " << int (yystack_[0].state) << '\n';
    YY_STACK_PRINT ();

    // Accept?
    if (yystack_[0].state == yyfinal_)
      YYACCEPT;

    goto yybackup;


  /*-----------.
  | yybackup.  |
  `-----------*/
  yybackup:
    // Try to take a decision without lookahead.
    yyn = yypact_[+yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyla.empty ())
      {
        YYCDEBUG << "Reading a token\n";
#if YY_EXCEPTIONS
        try
#endif // YY_EXCEPTIONS
          {
            yyla.kind_ = yytranslate_ (yylex (&yyla.value, &yyla.location, driver));
          }
#if YY_EXCEPTIONS
        catch (const syntax_error& yyexc)
          {
            YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
            error (yyexc);
            goto yyerrlab1;
          }
#endif // YY_EXCEPTIONS
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    if (yyla.kind () == symbol_kind::S_YYerror)
    {
      // The scanner already issued an error message, process directly
      // to error recovery.  But do not keep the error token as
      // lookahead, it is too special and may lead us to an endless
      // loop in error recovery. */
      yyla.kind_ = symbol_kind::S_YYUNDEF;
      goto yyerrlab1;
    }

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.kind ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.kind ())
      {
        goto yydefault;
      }

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        yyn = -yyn;
        goto yyreduce;
      }

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", state_type (yyn), YY_MOVE (yyla));
    goto yynewstate;


  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[+yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;


  /*-----------------------------.
  | yyreduce -- do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_ (yystack_[yylen].state, yyr1_[yyn]);
      /* Variants are always initialized to an empty instance of the
         correct type. The default '$$ = $1' action is NOT applied
         when using variants.  */
      switch (yyr1_[yyn])
    {
      case symbol_kind::S_CBOOL: // "bool value"
        yylhs.value.emplace< bool > ();
        break;

      case symbol_kind::S_CUREAL: // "real value"
        yylhs.value.emplace< double > ();
        break;

      case symbol_kind::S_attribute: // attribute
        yylhs.value.emplace< hilti::Attribute* > ();
        break;

      case symbol_kind::S_opt_attributes: // opt_attributes
        yylhs.value.emplace< hilti::AttributeSet* > ();
        break;

      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        yylhs.value.emplace< hilti::Ctor* > ();
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_struct_field: // struct_field
      case symbol_kind::S_union_field: // union_field
        yylhs.value.emplace< hilti::Declaration* > ();
        break;

      case symbol_kind::S_struct_fields: // struct_fields
      case symbol_kind::S_opt_union_fields: // opt_union_fields
      case symbol_kind::S_union_fields: // union_fields
        yylhs.value.emplace< hilti::Declarations > ();
        break;

      case symbol_kind::S_opt_func_default_expr: // opt_func_default_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        yylhs.value.emplace< hilti::Expression* > ();
        break;

      case symbol_kind::S_opt_type_arguments: // opt_type_arguments
      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        yylhs.value.emplace< hilti::Expressions > ();
        break;

      case symbol_kind::S_function_with_body: // function_with_body
      case symbol_kind::S_method_with_body: // method_with_body
      case symbol_kind::S_hook_with_body: // hook_with_body
      case symbol_kind::S_function_without_body: // function_without_body
        yylhs.value.emplace< hilti::Function* > ();
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_function_id: // function_id
      case symbol_kind::S_scoped_function_id: // scoped_function_id
        yylhs.value.emplace< hilti::ID > ();
        break;

      case symbol_kind::S_qtype: // qtype
        yylhs.value.emplace< hilti::QualifiedType* > ();
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        yylhs.value.emplace< hilti::Statement* > ();
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        yylhs.value.emplace< hilti::Statements > ();
        break;

      case symbol_kind::S_func_param_type: // func_param_type
      case symbol_kind::S_base_type_no_attrs: // base_type_no_attrs
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_function_type: // function_type
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_union_type: // union_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
        yylhs.value.emplace< hilti::UnqualifiedType* > ();
        break;

      case symbol_kind::S_map_elem: // map_elem
        yylhs.value.emplace< hilti::ctor::map::Element* > ();
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        yylhs.value.emplace< hilti::ctor::map::Elements > ();
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        yylhs.value.emplace< hilti::ctor::regexp::Pattern > ();
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        yylhs.value.emplace< hilti::ctor::regexp::Patterns > ();
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        yylhs.value.emplace< hilti::ctor::struct_::Field* > ();
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        yylhs.value.emplace< hilti::ctor::struct_::Fields > ();
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        yylhs.value.emplace< hilti::declaration::Linkage > ();
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        yylhs.value.emplace< hilti::parameter::Kind > ();
        break;

      case symbol_kind::S_switch_case: // switch_case
        yylhs.value.emplace< hilti::statement::switch_::Case* > ();
        break;

      case symbol_kind::S_opt_switch_cases: // opt_switch_cases
      case symbol_kind::S_switch_cases: // switch_cases
        yylhs.value.emplace< hilti::statement::switch_::Cases > ();
        break;

      case symbol_kind::S_try_catch: // try_catch
        yylhs.value.emplace< hilti::statement::try_::Catch* > ();
        break;

      case symbol_kind::S_try_catches: // try_catches
        yylhs.value.emplace< hilti::statement::try_::Catches > ();
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        yylhs.value.emplace< hilti::type::bitfield::BitRange* > ();
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        yylhs.value.emplace< hilti::type::bitfield::BitRanges > ();
        break;

      case symbol_kind::S_enum_label: // enum_label
        yylhs.value.emplace< hilti::type::enum_::Label* > ();
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        yylhs.value.emplace< hilti::type::enum_::Labels > ();
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        yylhs.value.emplace< hilti::type::function::CallingConvention > ();
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
      case symbol_kind::S_func_flavor: // func_flavor
        yylhs.value.emplace< hilti::type::function::Flavor > ();
        break;

      case symbol_kind::S_func_param: // func_param
        yylhs.value.emplace< hilti::type::function::Parameter* > ();
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_struct_params: // opt_struct_params
        yylhs.value.emplace< hilti::type::function::Parameters > ();
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        yylhs.value.emplace< hilti::type::tuple::Element* > ();
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        yylhs.value.emplace< hilti::type::tuple::Elements > ();
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        yylhs.value.emplace< std::pair<Declarations, Statements> > ();
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_SCOPED_FINALIZE: // "scoped ~finally"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        yylhs.value.emplace< std::string > ();
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
        yylhs.value.emplace< uint64_t > ();
        break;

      default:
        break;
    }


      // Default location.
      {
        stack_type::slice range (yystack_, yylen);
        YYLLOC_DEFAULT (yylhs.location, range, yylen);
        yyerror_range[1].location = yylhs.location;
      }

      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
#if YY_EXCEPTIONS
      try
#endif // YY_EXCEPTIONS
        {
          switch (yyn)
            {
  case 2: // module: "module" local_id '{' global_scope_items '}'
#line 306 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { auto uid = declaration::module::UID(yystack_[3].value.as < hilti::ID > (), hilti::rt::filesystem::path(*driver->currentFile()));
                                                   auto m = builder->declarationModule(uid, {}, std::move(yystack_[1].value.as < std::pair<Declarations, Statements> > ().first), std::move(yystack_[1].value.as < std::pair<Declarations, Statements> > ().second), __loc__);
                                                   driver->setDestinationModule(std::move(m));
                                                 }
#line 2318 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 3: // local_id: "identifier"
#line 314 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { std::string name(yystack_[0].value.as < std::string > ());

                                                   if ( ! driver->builder()->options().skip_validation ) {
                                                       if ( name.find('-') != std::string::npos )
                                                           hilti::logger().error(util::fmt("Invalid ID '%s': cannot contain '-'", name), __loc__.location());
                                                       if ( name.substr(0, 2) == "__" && name != "__hook_to_string" )
                                                           hilti::logger().error(util::fmt("Invalid ID '%s': cannot start with '__'", name), __loc__.location());
                                                   }

                                                   yylhs.value.as < hilti::ID > () = hilti::ID(std::move(name));
                                                 }
#line 2334 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 4: // scoped_id: local_id
#line 326 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ID > () = std::move(yystack_[0].value.as < hilti::ID > ()); }
#line 2340 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 5: // scoped_id: "scoped identifier"
#line 327 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ID > () = hilti::ID(yystack_[0].value.as < std::string > ()); }
#line 2346 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 6: // $@1: %empty
#line 329 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                { driver->enableDottedIDMode(); }
#line 2352 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 7: // $@2: %empty
#line 331 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                { driver->disableDottedIDMode(); }
#line 2358 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 8: // dotted_id: $@1 "dotted identifier" $@2
#line 331 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                   { yylhs.value.as < hilti::ID > () = hilti::ID(yystack_[1].value.as < std::string > ()); }
#line 2364 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 9: // global_scope_items: global_scope_items global_scope_decl
#line 337 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < std::pair<Declarations, Statements> > () = std::move(yystack_[1].value.as < std::pair<Declarations, Statements> > ()); yylhs.value.as < std::pair<Declarations, Statements> > ().first.push_back(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2370 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 10: // global_scope_items: global_scope_items stmt
#line 339 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < std::pair<Declarations, Statements> > () = std::move(yystack_[1].value.as < std::pair<Declarations, Statements> > ()); yylhs.value.as < std::pair<Declarations, Statements> > ().second.push_back(yystack_[0].value.as < hilti::Statement* > ()); }
#line 2376 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 11: // global_scope_items: %empty
#line 340 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < std::pair<Declarations, Statements> > () = {}; }
#line 2382 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 12: // global_scope_decl: type_decl
#line 344 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = std::move(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2388 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 13: // global_scope_decl: constant_decl
#line 345 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = std::move(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2394 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 14: // global_scope_decl: global_decl
#line 346 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = std::move(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2400 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 15: // global_scope_decl: function_decl
#line 347 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = std::move(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2406 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 16: // global_scope_decl: import_decl
#line 348 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = std::move(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2412 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 17: // global_scope_decl: property_decl
#line 349 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = std::move(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2418 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 18: // type_decl: opt_linkage "type" scoped_id '=' qtype opt_attributes ';'
#line 352 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationType(std::move(yystack_[4].value.as < hilti::ID > ()), std::move(yystack_[2].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::AttributeSet* > ()), std::move(yystack_[6].value.as < hilti::declaration::Linkage > ()), __loc__); }
#line 2424 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 19: // constant_decl: opt_linkage "const" scoped_id '=' expr ';'
#line 355 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationConstant(yystack_[3].value.as < hilti::ID > (), yystack_[1].value.as < hilti::Expression* > (), yystack_[5].value.as < hilti::declaration::Linkage > (), __loc__); }
#line 2430 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 20: // constant_decl: opt_linkage "const" type scoped_id '=' expr ';'
#line 357 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationConstant(yystack_[3].value.as < hilti::ID > (), builder->qualifiedType(yystack_[4].value.as < hilti::UnqualifiedType* > (), Constness::Const), yystack_[1].value.as < hilti::Expression* > (), yystack_[6].value.as < hilti::declaration::Linkage > (), __loc__); }
#line 2436 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 21: // local_decl: "local" local_id '=' expr ';'
#line 360 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                { yylhs.value.as < hilti::Declaration* > () = builder->declarationLocalVariable(yystack_[3].value.as < hilti::ID > (), yystack_[1].value.as < hilti::Expression* > (), __loc__); }
#line 2442 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 22: // local_decl: "local" qtype local_id opt_type_arguments ';'
#line 361 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                            { yylhs.value.as < hilti::Declaration* > () = builder->declarationLocalVariable(yystack_[2].value.as < hilti::ID > (), yystack_[3].value.as < hilti::QualifiedType* > (), yystack_[1].value.as < hilti::Expressions > (), {}, __loc__); }
#line 2448 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 23: // local_decl: "local" qtype local_id '=' expr ';'
#line 363 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationLocalVariable(yystack_[3].value.as < hilti::ID > (), yystack_[4].value.as < hilti::QualifiedType* > (), yystack_[1].value.as < hilti::Expression* > (), __loc__); }
#line 2454 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 24: // local_decl: "local" "auto" local_id '=' expr ';'
#line 365 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationLocalVariable(yystack_[3].value.as < hilti::ID > (), yystack_[1].value.as < hilti::Expression* > (), __loc__); }
#line 2460 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 25: // local_init_decl: "local" qtype local_id '=' expr
#line 370 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationLocalVariable(yystack_[2].value.as < hilti::ID > (), yystack_[3].value.as < hilti::QualifiedType* > (), yystack_[0].value.as < hilti::Expression* > (), __loc__); }
#line 2466 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 26: // local_init_decl: "local" "auto" local_id '=' expr
#line 372 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationLocalVariable(yystack_[2].value.as < hilti::ID > (), yystack_[0].value.as < hilti::Expression* > (), __loc__); }
#line 2472 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 27: // global_decl: opt_linkage "global" scoped_id '=' expr ';'
#line 376 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationGlobalVariable(yystack_[3].value.as < hilti::ID > (), yystack_[1].value.as < hilti::Expression* > (), yystack_[5].value.as < hilti::declaration::Linkage > (), __loc__); }
#line 2478 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 28: // global_decl: opt_linkage "global" qtype scoped_id opt_type_arguments ';'
#line 378 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationGlobalVariable(yystack_[2].value.as < hilti::ID > (), yystack_[3].value.as < hilti::QualifiedType* > (), yystack_[1].value.as < hilti::Expressions > (), {}, yystack_[5].value.as < hilti::declaration::Linkage > (), __loc__); }
#line 2484 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 29: // global_decl: opt_linkage "global" qtype scoped_id '=' expr ';'
#line 380 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationGlobalVariable(yystack_[3].value.as < hilti::ID > (), yystack_[4].value.as < hilti::QualifiedType* > (), yystack_[1].value.as < hilti::Expression* > (), yystack_[6].value.as < hilti::declaration::Linkage > (), __loc__); }
#line 2490 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 30: // global_decl: opt_linkage "global" "auto" scoped_id '=' expr ';'
#line 382 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationGlobalVariable(yystack_[3].value.as < hilti::ID > (), yystack_[1].value.as < hilti::Expression* > (), yystack_[6].value.as < hilti::declaration::Linkage > (), __loc__); }
#line 2496 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 31: // opt_type_arguments: '(' opt_exprs ')'
#line 386 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = std::move(yystack_[1].value.as < hilti::Expressions > ()); }
#line 2502 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 32: // opt_type_arguments: %empty
#line 387 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions{}; }
#line 2508 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 33: // function_decl: opt_linkage "function" function_with_body
#line 390 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationFunction(yystack_[0].value.as < hilti::Function* > (), yystack_[2].value.as < hilti::declaration::Linkage > (), __loc__); }
#line 2514 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 34: // function_decl: opt_linkage "hook" hook_with_body
#line 391 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                             { yylhs.value.as < hilti::Declaration* > () = builder->declarationFunction(yystack_[0].value.as < hilti::Function* > (), yystack_[2].value.as < hilti::declaration::Linkage > (), __loc__); }
#line 2520 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 35: // function_decl: "method" method_with_body
#line 394 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationFunction(yystack_[0].value.as < hilti::Function* > (), hilti::declaration::Linkage::Struct, __loc__); }
#line 2526 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 36: // function_decl: "declare" opt_linkage function_without_body ';'
#line 396 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationFunction(yystack_[1].value.as < hilti::Function* > (), yystack_[2].value.as < hilti::declaration::Linkage > (), __loc__); }
#line 2532 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 37: // import_decl: "import" local_id ';'
#line 399 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationImportedModule(std::move(yystack_[1].value.as < hilti::ID > ()), std::string(".hlt"), __loc__); }
#line 2538 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 38: // import_decl: "import" local_id "from" dotted_id ';'
#line 400 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                   { yylhs.value.as < hilti::Declaration* > () = builder->declarationImportedModule(std::move(yystack_[3].value.as < hilti::ID > ()), std::string(".hlt"), std::move(yystack_[1].value.as < hilti::ID > ()), __loc__); }
#line 2544 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 39: // property_decl: "property" ';'
#line 404 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationProperty(ID(std::move(yystack_[1].value.as < std::string > ())), __loc__); }
#line 2550 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 40: // property_decl: "property" '=' expr ';'
#line 405 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationProperty(ID(std::move(yystack_[3].value.as < std::string > ())), std::move(yystack_[1].value.as < hilti::Expression* > ()), __loc__); }
#line 2556 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 41: // opt_linkage: "public"
#line 407 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Linkage > () = hilti::declaration::Linkage::Public; }
#line 2562 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 42: // opt_linkage: "private"
#line 408 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Linkage > () = hilti::declaration::Linkage::Private; }
#line 2568 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 43: // opt_linkage: "init"
#line 409 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Linkage > () = hilti::declaration::Linkage::Init; }
#line 2574 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 44: // opt_linkage: "preinit"
#line 410 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Linkage > () = hilti::declaration::Linkage::PreInit; }
#line 2580 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 45: // opt_linkage: %empty
#line 411 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Linkage > () = hilti::declaration::Linkage::Private; }
#line 2586 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 46: // function_id: local_id
#line 415 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ID > () = std::move(yystack_[0].value.as < hilti::ID > ()); }
#line 2592 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 47: // function_id: "~finally"
#line 416 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ID > () = hilti::ID("~finally"); }
#line 2598 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 48: // scoped_function_id: function_id
#line 419 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ID > () = std::move(yystack_[0].value.as < hilti::ID > ()); }
#line 2604 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 49: // scoped_function_id: "scoped identifier"
#line 420 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ID > () = hilti::ID(yystack_[0].value.as < std::string > ()); }
#line 2610 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 50: // scoped_function_id: "scoped ~finally"
#line 421 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ID > () = hilti::ID(yystack_[0].value.as < std::string > ()); }
#line 2616 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 51: // function_with_body: opt_func_cc qtype scoped_function_id '(' opt_func_params ')' opt_attributes braced_block
#line 425 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 {
                                                    auto ftype = builder->typeFunction(yystack_[6].value.as < hilti::QualifiedType* > (), yystack_[3].value.as < hilti::type::function::Parameters > (), type::function::Flavor::Function, yystack_[7].value.as < hilti::type::function::CallingConvention > (), __loc__);
                                                    yylhs.value.as < hilti::Function* > () = builder->function(yystack_[5].value.as < hilti::ID > (), ftype->as<type::Function>(), yystack_[0].value.as < hilti::Statement* > (), yystack_[1].value.as < hilti::AttributeSet* > (), __loc__);
                                                 }
#line 2625 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 52: // method_with_body: opt_func_cc qtype scoped_function_id '(' opt_func_params ')' opt_attributes braced_block
#line 432 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 {
                                                    auto ftype = builder->typeFunction(yystack_[6].value.as < hilti::QualifiedType* > (), yystack_[3].value.as < hilti::type::function::Parameters > (), type::function::Flavor::Method, yystack_[7].value.as < hilti::type::function::CallingConvention > (), __loc__);
                                                    yylhs.value.as < hilti::Function* > () = builder->function(yystack_[5].value.as < hilti::ID > (), ftype->as<type::Function>(), yystack_[0].value.as < hilti::Statement* > (), yystack_[1].value.as < hilti::AttributeSet* > (), __loc__);
                                                 }
#line 2634 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 53: // hook_with_body: opt_func_cc qtype scoped_function_id '(' opt_func_params ')' opt_attributes braced_block
#line 439 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 {
                                                    auto ftype = builder->typeFunction(yystack_[6].value.as < hilti::QualifiedType* > (), yystack_[3].value.as < hilti::type::function::Parameters > (), type::function::Flavor::Hook, yystack_[7].value.as < hilti::type::function::CallingConvention > (), __loc__);
                                                    yylhs.value.as < hilti::Function* > () = builder->function(yystack_[5].value.as < hilti::ID > (), ftype->as<type::Function>(), yystack_[0].value.as < hilti::Statement* > (), yystack_[1].value.as < hilti::AttributeSet* > (), __loc__);
                                                 }
#line 2643 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 54: // function_without_body: opt_func_flavor opt_func_cc qtype scoped_function_id '(' opt_func_params ')' opt_attributes
#line 446 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 {
                                                    auto ftype = builder->typeFunction(yystack_[5].value.as < hilti::QualifiedType* > (), yystack_[2].value.as < hilti::type::function::Parameters > (), yystack_[7].value.as < hilti::type::function::Flavor > (), yystack_[6].value.as < hilti::type::function::CallingConvention > (), __loc__);
                                                    yylhs.value.as < hilti::Function* > () = builder->function(yystack_[4].value.as < hilti::ID > (), std::move(ftype), {}, yystack_[0].value.as < hilti::AttributeSet* > (), __loc__);
                                                 }
#line 2652 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 55: // opt_func_flavor: func_flavor
#line 451 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::Flavor > () = yystack_[0].value.as < hilti::type::function::Flavor > (); }
#line 2658 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 56: // opt_func_flavor: %empty
#line 452 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::Flavor > () = hilti::type::function::Flavor::Function; }
#line 2664 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 57: // func_flavor: "method"
#line 454 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::Flavor > () = hilti::type::function::Flavor::Method; }
#line 2670 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 58: // func_flavor: "hook"
#line 455 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::Flavor > () = hilti::type::function::Flavor::Hook; }
#line 2676 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 59: // opt_func_cc: "extern"
#line 457 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::CallingConvention > () = hilti::type::function::CallingConvention::Extern; }
#line 2682 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 60: // opt_func_cc: "extern-no-suspend"
#line 458 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::CallingConvention > () = hilti::type::function::CallingConvention::ExternNoSuspend; }
#line 2688 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 61: // opt_func_cc: %empty
#line 459 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::CallingConvention > () = hilti::type::function::CallingConvention::Standard; }
#line 2694 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 62: // opt_func_params: func_params
#line 461 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::Parameters > () = std::move(yystack_[0].value.as < hilti::type::function::Parameters > ()); }
#line 2700 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 63: // opt_func_params: %empty
#line 462 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::Parameters > () = hilti::type::function::Parameters(); }
#line 2706 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 64: // func_params: func_params ',' func_param
#line 464 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                         { yylhs.value.as < hilti::type::function::Parameters > () = std::move(yystack_[2].value.as < hilti::type::function::Parameters > ()); yylhs.value.as < hilti::type::function::Parameters > ().push_back(yystack_[0].value.as < hilti::type::function::Parameter* > ()); }
#line 2712 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 65: // func_params: func_param
#line 465 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::Parameters > () = hilti::type::function::Parameters{yystack_[0].value.as < hilti::type::function::Parameter* > ()}; }
#line 2718 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 66: // func_param: opt_func_param_kind func_param_type local_id opt_func_default_expr opt_attributes
#line 468 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::Parameter* > () = builder->declarationParameter(yystack_[2].value.as < hilti::ID > (), yystack_[3].value.as < hilti::UnqualifiedType* > (), yystack_[4].value.as < hilti::parameter::Kind > (), yystack_[1].value.as < hilti::Expression* > (), yystack_[0].value.as < hilti::AttributeSet* > (), __loc__); }
#line 2724 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 67: // func_param_type: type
#line 471 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 2730 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 68: // func_param_type: "auto"
#line 472 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeAuto(__loc__); }
#line 2736 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 69: // opt_func_param_kind: "copy"
#line 476 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::parameter::Kind > () = hilti::parameter::Kind::Copy; }
#line 2742 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 70: // opt_func_param_kind: "inout"
#line 477 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::parameter::Kind > () = hilti::parameter::Kind::InOut; }
#line 2748 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 71: // opt_func_param_kind: %empty
#line 478 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::parameter::Kind > () = hilti::parameter::Kind::In; }
#line 2754 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 72: // opt_func_default_expr: '=' expr
#line 481 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 2760 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 73: // opt_func_default_expr: %empty
#line 482 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = {}; }
#line 2766 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 74: // block: stmt
#line 487 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { if ( ! yystack_[0].value.as < hilti::Statement* > ()->isA<hilti::statement::Block>() )
                                                     yylhs.value.as < hilti::Statement* > () = builder->statementBlock({std::move(yystack_[0].value.as < hilti::Statement* > ())}, __loc__);
                                                   else
                                                     yylhs.value.as < hilti::Statement* > () = std::move(yystack_[0].value.as < hilti::Statement* > ());
                                                 }
#line 2776 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 75: // braced_block: '{' opt_stmts '}'
#line 494 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementBlock(std::move(yystack_[1].value.as < hilti::Statements > ()), __loc__); }
#line 2782 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 76: // opt_stmts: stmts
#line 496 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statements > () = std::move(yystack_[0].value.as < hilti::Statements > ()); }
#line 2788 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 77: // opt_stmts: %empty
#line 497 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statements > () = hilti::Statements(); }
#line 2794 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 78: // stmts: stmts stmt
#line 499 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statements > () = std::move(yystack_[1].value.as < hilti::Statements > ()); yylhs.value.as < hilti::Statements > ().push_back(yystack_[0].value.as < hilti::Statement* > ()); }
#line 2800 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 79: // stmts: stmt
#line 500 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statements > () = hilti::Statements{std::move(yystack_[0].value.as < hilti::Statement* > ())}; }
#line 2806 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 80: // stmt: stmt_expr ';'
#line 502 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = std::move(yystack_[1].value.as < hilti::Statement* > ()); }
#line 2812 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 81: // stmt: stmt_decl
#line 503 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = std::move(yystack_[0].value.as < hilti::Statement* > ()); }
#line 2818 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 82: // stmt: braced_block
#line 504 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = std::move(yystack_[0].value.as < hilti::Statement* > ()); }
#line 2824 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 83: // stmt: "return" ';'
#line 505 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementReturn(__loc__); }
#line 2830 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 84: // stmt: "return" expr ';'
#line 506 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementReturn(std::move(yystack_[1].value.as < hilti::Expression* > ()), __loc__); }
#line 2836 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 85: // stmt: "throw" expr ';'
#line 507 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementThrow(std::move(yystack_[1].value.as < hilti::Expression* > ()), __loc__); }
#line 2842 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 86: // stmt: "throw" ';'
#line 508 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementThrow(__loc__); }
#line 2848 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 87: // stmt: "yield" ';'
#line 509 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementYield(__loc__); }
#line 2854 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 88: // stmt: "break" ';'
#line 510 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementBreak(__loc__); }
#line 2860 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 89: // stmt: "continue" ';'
#line 511 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementContinue(__loc__); }
#line 2866 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 90: // stmt: "if" '(' expr ')' block opt_else_block
#line 513 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementIf(std::move(yystack_[3].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Statement* > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 2872 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 91: // stmt: "if" '(' local_init_decl ')' block opt_else_block
#line 515 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementIf(std::move(yystack_[3].value.as < hilti::Declaration* > ()), {}, std::move(yystack_[1].value.as < hilti::Statement* > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 2878 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 92: // stmt: "if" '(' local_init_decl ';' expr ')' block opt_else_block
#line 517 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementIf(std::move(yystack_[5].value.as < hilti::Declaration* > ()), std::move(yystack_[3].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Statement* > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 2884 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 93: // stmt: "while" '(' local_init_decl ';' expr ')' block opt_else_block
#line 519 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementWhile(std::move(yystack_[5].value.as < hilti::Declaration* > ()), std::move(yystack_[3].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Statement* > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 2890 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 94: // stmt: "while" '(' expr ')' block opt_else_block
#line 521 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementWhile(std::move(yystack_[3].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Statement* > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 2896 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 95: // stmt: "while" '(' local_init_decl ')' block opt_else_block
#line 523 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementWhile(std::move(yystack_[3].value.as < hilti::Declaration* > ()), {}, std::move(yystack_[1].value.as < hilti::Statement* > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 2902 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 96: // stmt: "for" '(' local_id "in" expr ')' block
#line 525 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementFor(std::move(yystack_[4].value.as < hilti::ID > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 2908 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 97: // stmt: "switch" '(' expr ')' '{' opt_switch_cases '}'
#line 527 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementSwitch(std::move(yystack_[4].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::statement::switch_::Cases > ()), __loc__); }
#line 2914 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 98: // stmt: "switch" '(' local_init_decl ')' '{' opt_switch_cases '}'
#line 529 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementSwitch(std::move(yystack_[4].value.as < hilti::Declaration* > ()), std::move(yystack_[1].value.as < hilti::statement::switch_::Cases > ()), __loc__); }
#line 2920 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 99: // stmt: "try" block try_catches
#line 531 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementTry(std::move(yystack_[1].value.as < hilti::Statement* > ()), std::move(yystack_[0].value.as < hilti::statement::try_::Catches > ()), __loc__); }
#line 2926 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 100: // stmt: "assert" expr ';'
#line 532 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementAssert(std::move(yystack_[1].value.as < hilti::Expression* > ()), {}, __loc__); }
#line 2932 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 101: // stmt: "assert-exception" expr_no_or_error ':' expr ';'
#line 534 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementAssert(hilti::statement::assert::Exception(), std::move(yystack_[3].value.as < hilti::Expression* > ()), {}, std::move(yystack_[1].value.as < hilti::Expression* > ()), __loc__); }
#line 2938 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 102: // stmt: "assert-exception" expr_no_or_error ';'
#line 536 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementAssert(hilti::statement::assert::Exception(), std::move(yystack_[1].value.as < hilti::Expression* > ()), {}, {}, __loc__); }
#line 2944 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 103: // stmt: "add" expr ';'
#line 538 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { auto op = yystack_[1].value.as < hilti::Expression* > ()->tryAs<hilti::expression::UnresolvedOperator>();
                                                   if ( ! (op && op->kind() == hilti::operator_::Kind::Index) )
                                                        error(yylhs.location, "'add' must be used with index expression only");

                                                   auto expr = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Add, op->operands(), __loc__);
                                                   yylhs.value.as < hilti::Statement* > () = builder->statementExpression(std::move(expr), __loc__);
                                                 }
#line 2956 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 104: // stmt: "delete" expr ';'
#line 546 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { auto op = yystack_[1].value.as < hilti::Expression* > ()->tryAs<hilti::expression::UnresolvedOperator>();
                                                   if ( ! (op && op->kind() == hilti::operator_::Kind::Index) )
                                                        error(yylhs.location, "'delete' must be used with index expressions only");

                                                   auto expr = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Delete, op->operands(), __loc__);
                                                   yylhs.value.as < hilti::Statement* > () = builder->statementExpression(std::move(expr), __loc__);
                                                 }
#line 2968 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 105: // stmt: "unset" expr ';'
#line 554 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { auto op = yystack_[1].value.as < hilti::Expression* > ()->tryAs<hilti::expression::UnresolvedOperator>();
                                                   if ( ! (op && op->kind() == hilti::operator_::Kind::Member) )
                                                        error(yylhs.location, "'unset' must be used with member expressions only");

                                                   auto expr = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Unset, op->operands(), __loc__);
                                                   yylhs.value.as < hilti::Statement* > () = builder->statementExpression(std::move(expr), __loc__);
                                                 }
#line 2980 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 106: // opt_else_block: "else" block
#line 564 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = std::move(yystack_[0].value.as < hilti::Statement* > ()); }
#line 2986 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 107: // opt_else_block: %empty
#line 565 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = {}; }
#line 2992 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 108: // opt_switch_cases: switch_cases
#line 568 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::statement::switch_::Cases > () = std::move(yystack_[0].value.as < hilti::statement::switch_::Cases > ()); }
#line 2998 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 109: // opt_switch_cases: %empty
#line 569 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::statement::switch_::Cases > () = {}; }
#line 3004 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 110: // switch_cases: switch_cases switch_case
#line 571 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::statement::switch_::Cases > () = std::move(yystack_[1].value.as < hilti::statement::switch_::Cases > ()); yylhs.value.as < hilti::statement::switch_::Cases > ().push_back(std::move(yystack_[0].value.as < hilti::statement::switch_::Case* > ())); }
#line 3010 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 111: // switch_cases: switch_case
#line 572 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::statement::switch_::Cases > () = hilti::statement::switch_::Cases({std::move(yystack_[0].value.as < hilti::statement::switch_::Case* > ())}); }
#line 3016 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 112: // switch_case: "case" case_exprs ':' block
#line 574 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                      { yylhs.value.as < hilti::statement::switch_::Case* > () = builder->statementSwitchCase(std::move(yystack_[2].value.as < hilti::Expressions > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 3022 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 113: // switch_case: "default" ':' block
#line 575 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::statement::switch_::Case* > () = builder->statementSwitchCase(hilti::statement::switch_::Default(), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 3028 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 114: // case_exprs: case_exprs ',' expr_no_or_error
#line 577 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = std::move(yystack_[2].value.as < hilti::Expressions > ()); yylhs.value.as < hilti::Expressions > ().push_back(std::move(yystack_[0].value.as < hilti::Expression* > ())); }
#line 3034 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 115: // case_exprs: expr_no_or_error
#line 578 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions{std::move(yystack_[0].value.as < hilti::Expression* > ())}; }
#line 3040 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 116: // try_catches: try_catches try_catch
#line 580 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::statement::try_::Catches > () = std::move(yystack_[1].value.as < hilti::statement::try_::Catches > ()); yylhs.value.as < hilti::statement::try_::Catches > ().push_back(std::move(yystack_[0].value.as < hilti::statement::try_::Catch* > ())); }
#line 3046 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 117: // try_catches: try_catch
#line 581 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::statement::try_::Catches > () = hilti::statement::try_::Catches({ std::move(yystack_[0].value.as < hilti::statement::try_::Catch* > ()) }); }
#line 3052 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 118: // try_catch: "catch" '(' func_param_type local_id ')' block
#line 584 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::statement::try_::Catch* > () = builder->statementTryCatch(builder->declarationParameter(yystack_[2].value.as < hilti::ID > (), yystack_[3].value.as < hilti::UnqualifiedType* > (), parameter::Kind::In, {}, {}, __loc__), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 3058 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 119: // try_catch: "catch" block
#line 585 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::statement::try_::Catch* > () = builder->statementTryCatch(std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 3064 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 120: // stmt_decl: local_decl
#line 587 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementDeclaration(yystack_[0].value.as < hilti::Declaration* > (), __loc__); }
#line 3070 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 121: // stmt_decl: type_decl
#line 588 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementDeclaration(yystack_[0].value.as < hilti::Declaration* > (), __loc__); }
#line 3076 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 122: // stmt_decl: constant_decl
#line 589 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementDeclaration(yystack_[0].value.as < hilti::Declaration* > (), __loc__); }
#line 3082 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 123: // stmt_expr: expr
#line 592 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementExpression(yystack_[0].value.as < hilti::Expression* > (), __loc__); }
#line 3088 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 124: // base_type_no_attrs: "any"
#line 597 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeAny(__loc__); }
#line 3094 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 125: // base_type_no_attrs: "addr"
#line 598 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeAddress(__loc__); }
#line 3100 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 126: // base_type_no_attrs: "bool"
#line 599 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeBool(__loc__); }
#line 3106 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 127: // base_type_no_attrs: "bytes"
#line 600 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeBytes(__loc__); }
#line 3112 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 128: // base_type_no_attrs: "error"
#line 601 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeError(__loc__); }
#line 3118 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 129: // base_type_no_attrs: "interval"
#line 602 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeInterval(__loc__); }
#line 3124 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 130: // base_type_no_attrs: "net"
#line 603 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeNetwork(__loc__); }
#line 3130 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 131: // base_type_no_attrs: "port"
#line 604 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typePort(__loc__); }
#line 3136 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 132: // base_type_no_attrs: "real"
#line 605 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeReal(__loc__); }
#line 3142 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 133: // base_type_no_attrs: "regexp"
#line 606 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeRegExp(__loc__); }
#line 3148 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 134: // base_type_no_attrs: "stream"
#line 607 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeStream(__loc__); }
#line 3154 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 135: // base_type_no_attrs: "string"
#line 608 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeString(__loc__); }
#line 3160 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 136: // base_type_no_attrs: "time"
#line 609 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeTime(__loc__); }
#line 3166 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 137: // base_type_no_attrs: "type"
#line 610 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeTypeInfo(__loc__); }
#line 3172 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 138: // base_type_no_attrs: "void"
#line 611 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeVoid(__loc__); }
#line 3178 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 139: // base_type_no_attrs: "int" type_param_begin "unsigned integer value" type_param_end
#line 613 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeSignedInteger(yystack_[1].value.as < uint64_t > (), __loc__); }
#line 3184 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 140: // base_type_no_attrs: "int" type_param_begin '*' type_param_end
#line 614 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeSignedInteger(hilti::type::Wildcard(), __loc__); }
#line 3190 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 141: // base_type_no_attrs: "uint" type_param_begin "unsigned integer value" type_param_end
#line 615 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeUnsignedInteger(yystack_[1].value.as < uint64_t > (), __loc__); }
#line 3196 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 142: // base_type_no_attrs: "uint" type_param_begin '*' type_param_end
#line 616 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeUnsignedInteger(hilti::type::Wildcard(), __loc__); }
#line 3202 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 143: // base_type_no_attrs: "optional" type_param_begin qtype type_param_end
#line 618 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeOptional(yystack_[1].value.as < hilti::QualifiedType* > (), __loc__); }
#line 3208 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 144: // base_type_no_attrs: "result" type_param_begin qtype type_param_end
#line 619 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeResult(yystack_[1].value.as < hilti::QualifiedType* > (), __loc__); }
#line 3214 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 145: // base_type_no_attrs: "view" type_param_begin qtype type_param_end
#line 620 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = viewForType(builder, std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__)->type(); }
#line 3220 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 146: // base_type_no_attrs: "iterator" type_param_begin qtype type_param_end
#line 621 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = iteratorForType(builder, std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__)->type(); }
#line 3226 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 147: // base_type_no_attrs: "strong_ref" type_param_begin qtype type_param_end
#line 622 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeStrongReference(yystack_[1].value.as < hilti::QualifiedType* > (), __loc__); }
#line 3232 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 148: // base_type_no_attrs: "strong_ref" type_param_begin '*' type_param_end
#line 623 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeStrongReference(hilti::type::Wildcard(), __loc__); }
#line 3238 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 149: // base_type_no_attrs: "value_ref" type_param_begin qtype type_param_end
#line 624 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeValueReference(yystack_[1].value.as < hilti::QualifiedType* > (), __loc__); }
#line 3244 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 150: // base_type_no_attrs: "value_ref" type_param_begin '*' type_param_end
#line 625 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeValueReference(hilti::type::Wildcard(), __loc__); }
#line 3250 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 151: // base_type_no_attrs: "weak_ref" type_param_begin qtype type_param_end
#line 626 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeWeakReference(yystack_[1].value.as < hilti::QualifiedType* > (), __loc__); }
#line 3256 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 152: // base_type_no_attrs: "weak_ref" type_param_begin '*' type_param_end
#line 627 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeWeakReference(hilti::type::Wildcard(), __loc__); }
#line 3262 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 153: // base_type_no_attrs: "list" type_param_begin '*' type_param_end
#line 629 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeList(hilti::type::Wildcard(), __loc__); }
#line 3268 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 154: // base_type_no_attrs: "list" type_param_begin qtype type_param_end
#line 630 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeList(std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__); }
#line 3274 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 155: // base_type_no_attrs: "vector" type_param_begin '*' type_param_end
#line 631 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeVector(hilti::type::Wildcard(), __loc__); }
#line 3280 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 156: // base_type_no_attrs: "vector" type_param_begin qtype type_param_end
#line 632 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeVector(std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__); }
#line 3286 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 157: // base_type_no_attrs: "set" type_param_begin '*' type_param_end
#line 633 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeSet(hilti::type::Wildcard(), __loc__); }
#line 3292 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 158: // base_type_no_attrs: "set" type_param_begin qtype type_param_end
#line 634 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeSet(std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__); }
#line 3298 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 159: // base_type_no_attrs: "map" type_param_begin '*' type_param_end
#line 635 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeMap(hilti::type::Wildcard(), __loc__); }
#line 3304 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 160: // base_type_no_attrs: "map" type_param_begin qtype ',' qtype type_param_end
#line 636 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeMap(std::move(yystack_[3].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__); }
#line 3310 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 161: // base_type_no_attrs: "exception"
#line 638 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeException(__loc__); }
#line 3316 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 162: // base_type_no_attrs: '[' "exception" ':' type ']'
#line 639 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeException(std::move(yystack_[1].value.as < hilti::UnqualifiedType* > ()), __loc__); }
#line 3322 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 163: // base_type_no_attrs: "library type" '(' "string value" ')'
#line 641 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeLibrary(std::move(yystack_[1].value.as < std::string > ()), __loc__); }
#line 3328 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 164: // base_type_no_attrs: "const library type" '(' "string value" ')'
#line 643 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeLibrary(Constness::Const, std::move(yystack_[1].value.as < std::string > ()), __loc__); }
#line 3334 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 165: // base_type_no_attrs: tuple_type
#line 645 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3340 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 166: // base_type_no_attrs: struct_type
#line 646 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3346 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 167: // base_type_no_attrs: union_type
#line 647 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3352 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 168: // base_type_no_attrs: enum_type
#line 648 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3358 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 169: // base_type_no_attrs: bitfield_type
#line 649 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3364 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 170: // base_type: base_type_no_attrs
#line 652 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = yystack_[0].value.as < hilti::UnqualifiedType* > (); }
#line 3370 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 171: // type: base_type
#line 655 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3376 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 172: // type: function_type
#line 656 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3382 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 173: // type: scoped_id
#line 657 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeName(std::move(yystack_[0].value.as < hilti::ID > ()), __loc__); }
#line 3388 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 174: // qtype: type
#line 660 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::QualifiedType* > () = builder->qualifiedType(std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()), Constness::Mutable, __loc__); }
#line 3394 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 175: // qtype: "const" type
#line 661 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::QualifiedType* > () = builder->qualifiedType(std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()), Constness::Const, __loc__); }
#line 3400 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 176: // qtype: "auto"
#line 662 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::QualifiedType* > () = builder->qualifiedType(builder->typeAuto(__loc__), Constness::Const, __loc__); }
#line 3406 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 177: // type_param_begin: '<'
#line 667 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
              { driver->disableExpressionMode(); }
#line 3412 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 178: // type_param_end: '>'
#line 671 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
              { driver->enableExpressionMode(); }
#line 3418 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 179: // function_type: opt_func_flavor "function" '(' opt_func_params ')' "->" qtype
#line 674 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeFunction(yystack_[0].value.as < hilti::QualifiedType* > (), yystack_[3].value.as < hilti::type::function::Parameters > (), yystack_[6].value.as < hilti::type::function::Flavor > (), type::function::CallingConvention::Standard, __loc__); }
#line 3424 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 180: // tuple_type: "tuple" type_param_begin '*' type_param_end
#line 677 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeTuple(hilti::type::Wildcard(), __loc__); }
#line 3430 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 181: // tuple_type: "tuple" type_param_begin tuple_type_elems type_param_end
#line 678 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeTuple(std::move(yystack_[1].value.as < hilti::type::tuple::Elements > ()), __loc__); }
#line 3436 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 182: // tuple_type_elems: tuple_type_elems ',' tuple_type_elem
#line 683 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::tuple::Elements > () = std::move(yystack_[2].value.as < hilti::type::tuple::Elements > ()); yylhs.value.as < hilti::type::tuple::Elements > ().push_back(std::move(yystack_[0].value.as < hilti::type::tuple::Element* > ())); }
#line 3442 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 183: // tuple_type_elems: tuple_type_elem
#line 684 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::tuple::Elements > () = hilti::type::tuple::Elements{std::move(yystack_[0].value.as < hilti::type::tuple::Element* > ())}; }
#line 3448 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 184: // tuple_type_elem: qtype
#line 688 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                  { yylhs.value.as < hilti::type::tuple::Element* > () = builder->typeTupleElement(hilti::ID(), std::move(yystack_[0].value.as < hilti::QualifiedType* > ()), __loc__); }
#line 3454 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 185: // tuple_type_elem: local_id ':' qtype
#line 689 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                  { yylhs.value.as < hilti::type::tuple::Element* > () = builder->typeTupleElement(std::move(yystack_[2].value.as < hilti::ID > ()), std::move(yystack_[0].value.as < hilti::QualifiedType* > ()), __loc__); }
#line 3460 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 186: // struct_type: "struct" opt_struct_params '{' struct_fields '}'
#line 692 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                   { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeStruct(std::move(yystack_[3].value.as < hilti::type::function::Parameters > ()), std::move(yystack_[1].value.as < hilti::Declarations > ()), __loc__); }
#line 3466 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 187: // opt_struct_params: '(' opt_func_params ')'
#line 695 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::Parameters > () = std::move(yystack_[1].value.as < hilti::type::function::Parameters > ()); }
#line 3472 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 188: // opt_struct_params: %empty
#line 696 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::Parameters > () = hilti::type::function::Parameters{}; }
#line 3478 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 189: // struct_fields: struct_fields struct_field
#line 698 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declarations > () = std::move(yystack_[1].value.as < hilti::Declarations > ()); yylhs.value.as < hilti::Declarations > ().push_back(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 3484 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 190: // struct_fields: %empty
#line 699 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declarations > () = hilti::Declarations{}; }
#line 3490 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 191: // struct_field: qtype local_id opt_attributes ';'
#line 701 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                  { yylhs.value.as < hilti::Declaration* > () = builder->declarationField(std::move(yystack_[2].value.as < hilti::ID > ()), std::move(yystack_[3].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::AttributeSet* > ()), __loc__); }
#line 3496 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 192: // struct_field: func_flavor opt_func_cc qtype function_id '(' opt_func_params ')' opt_attributes ';'
#line 702 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                                                     {
                                                   auto ftype = builder->typeFunction(std::move(yystack_[6].value.as < hilti::QualifiedType* > ()), std::move(yystack_[3].value.as < hilti::type::function::Parameters > ()), yystack_[8].value.as < hilti::type::function::Flavor > (), yystack_[7].value.as < hilti::type::function::CallingConvention > (), __loc__);
                                                   yylhs.value.as < hilti::Declaration* > () = builder->declarationField(std::move(yystack_[5].value.as < hilti::ID > ()), std::move(ftype), yystack_[1].value.as < hilti::AttributeSet* > (), __loc__);
                                                   }
#line 3505 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 193: // struct_field: func_flavor opt_func_cc qtype function_id '(' opt_func_params ')' opt_attributes braced_block
#line 706 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                                                              {
                                                   auto ftype = builder->typeFunction(std::move(yystack_[6].value.as < hilti::QualifiedType* > ()), std::move(yystack_[3].value.as < hilti::type::function::Parameters > ()), yystack_[8].value.as < hilti::type::function::Flavor > (), yystack_[7].value.as < hilti::type::function::CallingConvention > (), __loc__);
                                                   auto func = builder->function(yystack_[5].value.as < hilti::ID > (), std::move(ftype), std::move(yystack_[0].value.as < hilti::Statement* > ()), {});
                                                   yylhs.value.as < hilti::Declaration* > () = builder->declarationField(yystack_[5].value.as < hilti::ID > (), std::move(func), yystack_[1].value.as < hilti::AttributeSet* > (), __loc__);
                                                   }
#line 3515 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 194: // union_type: "union" opt_attributes '{' opt_union_fields '}'
#line 713 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeUnion(std::move(yystack_[1].value.as < hilti::Declarations > ()), __loc__); }
#line 3521 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 195: // opt_union_fields: union_fields
#line 715 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declarations > () = yystack_[0].value.as < hilti::Declarations > (); }
#line 3527 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 196: // opt_union_fields: %empty
#line 716 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declarations > () = hilti::Declarations{}; }
#line 3533 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 197: // union_fields: union_fields ',' union_field
#line 718 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declarations > () = std::move(yystack_[2].value.as < hilti::Declarations > ()); yylhs.value.as < hilti::Declarations > ().push_back(std::move(yystack_[0].value.as < hilti::Declaration* > ())); }
#line 3539 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 198: // union_fields: union_field
#line 719 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declarations > () = hilti::Declarations{}; yylhs.value.as < hilti::Declarations > ().push_back(std::move(yystack_[0].value.as < hilti::Declaration* > ())); }
#line 3545 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 199: // union_field: qtype local_id opt_attributes
#line 721 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                  { yylhs.value.as < hilti::Declaration* > () = builder->declarationField(std::move(yystack_[1].value.as < hilti::ID > ()), std::move(yystack_[2].value.as < hilti::QualifiedType* > ()), std::move(yystack_[0].value.as < hilti::AttributeSet* > ()), __loc__); }
#line 3551 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 200: // enum_type: "enum" '{' enum_labels '}'
#line 723 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeEnum(std::move(yystack_[1].value.as < hilti::type::enum_::Labels > ()), __loc__); }
#line 3557 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 201: // enum_type: "enum" '<' '*' '>'
#line 724 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeEnum(type::Wildcard(), __loc__); }
#line 3563 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 202: // enum_labels: enum_labels ',' enum_label
#line 726 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::enum_::Labels > () = std::move(yystack_[2].value.as < hilti::type::enum_::Labels > ()); yylhs.value.as < hilti::type::enum_::Labels > ().push_back(std::move(yystack_[0].value.as < hilti::type::enum_::Label* > ())); }
#line 3569 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 203: // enum_labels: enum_labels ','
#line 727 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::enum_::Labels > () = std::move(yystack_[1].value.as < hilti::type::enum_::Labels > ()); }
#line 3575 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 204: // enum_labels: enum_label
#line 728 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::enum_::Labels > () = hilti::type::enum_::Labels(); yylhs.value.as < hilti::type::enum_::Labels > ().push_back(std::move(yystack_[0].value.as < hilti::type::enum_::Label* > ())); }
#line 3581 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 205: // enum_label: local_id
#line 731 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::enum_::Label* > () = builder->typeEnumLabel(std::move(yystack_[0].value.as < hilti::ID > ()), __loc__); }
#line 3587 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 206: // enum_label: local_id '=' "unsigned integer value"
#line 732 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::enum_::Label* > () = builder->typeEnumLabel(std::move(yystack_[2].value.as < hilti::ID > ()), yystack_[0].value.as < uint64_t > (), __loc__); }
#line 3593 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 207: // $@3: %empty
#line 736 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { _field_width = yystack_[1].value.as < uint64_t > (); }
#line 3599 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 208: // bitfield_type: "bitfield" '(' "unsigned integer value" ')' $@3 '{' opt_bitfield_bit_ranges '}'
#line 738 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeBitfield(yystack_[5].value.as < uint64_t > (), yystack_[1].value.as < hilti::type::bitfield::BitRanges > (), {}, __loc__); }
#line 3605 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 209: // opt_bitfield_bit_ranges: bitfield_bit_ranges
#line 742 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::bitfield::BitRanges > () = std::move(yystack_[0].value.as < hilti::type::bitfield::BitRanges > ()); }
#line 3611 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 210: // opt_bitfield_bit_ranges: %empty
#line 743 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::bitfield::BitRanges > () = type::bitfield::BitRanges(); }
#line 3617 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 211: // bitfield_bit_ranges: bitfield_bit_ranges bitfield_bit_range
#line 747 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::bitfield::BitRanges > () = std::move(yystack_[1].value.as < hilti::type::bitfield::BitRanges > ()); yylhs.value.as < hilti::type::bitfield::BitRanges > ().push_back(std::move(yystack_[0].value.as < hilti::type::bitfield::BitRange* > ()));  }
#line 3623 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 212: // bitfield_bit_ranges: bitfield_bit_range
#line 748 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::bitfield::BitRanges > () = type::bitfield::BitRanges(); yylhs.value.as < hilti::type::bitfield::BitRanges > ().push_back(std::move(yystack_[0].value.as < hilti::type::bitfield::BitRange* > ())); }
#line 3629 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 213: // bitfield_bit_range: local_id ':' "unsigned integer value" ".." "unsigned integer value" opt_attributes ';'
#line 752 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::bitfield::BitRange* > () = builder->typeBitfieldBitRange(std::move(yystack_[6].value.as < hilti::ID > ()), yystack_[4].value.as < uint64_t > (), yystack_[2].value.as < uint64_t > (), _field_width, std::move(yystack_[1].value.as < hilti::AttributeSet* > ()), __loc__); }
#line 3635 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 214: // bitfield_bit_range: local_id ':' "unsigned integer value" opt_attributes ';'
#line 754 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::bitfield::BitRange* > () = builder->typeBitfieldBitRange(std::move(yystack_[4].value.as < hilti::ID > ()), yystack_[2].value.as < uint64_t > (), yystack_[2].value.as < uint64_t > (), _field_width, std::move(yystack_[1].value.as < hilti::AttributeSet* > ()), __loc__); }
#line 3641 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 215: // expr: expr_or_error
#line 757 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 3647 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 216: // expr_no_or_error: expr_1
#line 761 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 3653 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 217: // opt_exprs: exprs
#line 763 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = std::move(yystack_[0].value.as < hilti::Expressions > ()); }
#line 3659 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 218: // opt_exprs: %empty
#line 764 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions(); }
#line 3665 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 219: // exprs: exprs ',' expr
#line 766 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = std::move(yystack_[2].value.as < hilti::Expressions > ()); yylhs.value.as < hilti::Expressions > ().push_back(std::move(yystack_[0].value.as < hilti::Expression* > ())); }
#line 3671 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 220: // exprs: expr
#line 767 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions{std::move(yystack_[0].value.as < hilti::Expression* > ())}; }
#line 3677 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 221: // expr_or_error: expr_1
#line 769 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 3683 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 222: // expr_or_error: expr_1 ':' expr
#line 770 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionConditionTest(std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__); }
#line 3689 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 223: // expr_1: expr_1 '=' expr_1
#line 773 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionAssign(std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__); }
#line 3695 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 224: // expr_1: expr_1 "-=" expr_1
#line 774 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::DifferenceAssign, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3701 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 225: // expr_1: expr_1 "+=" expr_1
#line 775 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::SumAssign, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3707 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 226: // expr_1: expr_1 "*=" expr_1
#line 776 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::MultipleAssign, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3713 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 227: // expr_1: expr_1 "/=" expr_1
#line 777 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::DivisionAssign, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3719 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 228: // expr_1: expr_1 '?' expr_1 ':' expr_1
#line 778 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionTernary(std::move(yystack_[4].value.as < hilti::Expression* > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__); }
#line 3725 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 229: // expr_1: expr_1 "||" expr_1
#line 779 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionLogicalOr(std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__); }
#line 3731 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 230: // expr_1: expr_1 "&&" expr_1
#line 780 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionLogicalAnd(std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__); }
#line 3737 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 231: // expr_1: expr_1 "==" expr_1
#line 781 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Equal, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3743 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 232: // expr_1: expr_1 "!=" expr_1
#line 782 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Unequal, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3749 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 233: // expr_1: expr_1 '<' expr_1
#line 783 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Lower, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3755 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 234: // expr_1: expr_1 '>' expr_1
#line 784 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Greater, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3761 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 235: // expr_1: expr_1 ">=" expr_1
#line 785 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::GreaterEqual, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3767 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 236: // expr_1: expr_1 "<=" expr_1
#line 786 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::LowerEqual, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3773 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 237: // expr_1: expr_1 '|' expr_1
#line 787 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::BitOr, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3779 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 238: // expr_1: expr_1 '^' expr_1
#line 788 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::BitXor, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3785 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 239: // expr_1: expr_1 '&' expr_1
#line 789 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::BitAnd, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3791 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 240: // expr_1: expr_1 "<<" expr_1
#line 790 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::ShiftLeft, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3797 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 241: // expr_1: expr_1 ">>" expr_1
#line 791 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::ShiftRight, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3803 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 242: // expr_1: expr_1 '+' expr_1
#line 792 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Sum, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3809 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 243: // expr_1: expr_1 '-' expr_1
#line 793 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Difference, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3815 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 244: // expr_1: expr_1 '%' expr_1
#line 794 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Modulo, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3821 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 245: // expr_1: expr_1 '*' expr_1
#line 795 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Multiple, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3827 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 246: // expr_1: expr_1 '/' expr_1
#line 796 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Division, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3833 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 247: // expr_1: expr_1 "**" expr_1
#line 797 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Power, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3839 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 248: // expr_1: '!' expr_1
#line 798 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionLogicalNot(std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__); }
#line 3845 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 249: // expr_1: '*' expr_1
#line 799 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Deref, {std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3851 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 250: // expr_1: '~' expr_1
#line 800 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Negate, {std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3857 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 251: // expr_1: '-' expr_1
#line 801 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::SignNeg, {std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3863 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 252: // expr_1: '|' expr_1 '|'
#line 802 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Size, {std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 3869 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 253: // expr_1: "--" expr_1
#line 803 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::DecrPrefix, {std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3875 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 254: // expr_1: "++" expr_1
#line 804 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::IncrPrefix, {std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3881 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 255: // expr_1: expr_1 '[' expr ']'
#line 805 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Index, {std::move(yystack_[3].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 3887 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 256: // expr_1: expr_1 '.' member_expr
#line 806 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Member, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3893 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 257: // expr_1: expr_1 '.' member_expr '(' opt_exprs ')'
#line 807 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                           { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::MemberCall, {std::move(yystack_[5].value.as < hilti::Expression* > ()), std::move(yystack_[3].value.as < hilti::Expression* > ()), builder->expressionCtor(builder->ctorTuple(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__))}, __loc__); }
#line 3899 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 258: // expr_1: expr_1 "--"
#line 808 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::DecrPostfix, {std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 3905 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 259: // expr_1: expr_1 "++"
#line 809 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::IncrPostfix, {std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 3911 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 260: // expr_1: expr_1 "?." member_expr
#line 810 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::HasMember, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3917 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 261: // expr_1: expr_1 ".?" member_expr
#line 811 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::TryMember, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3923 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 262: // expr_1: expr_1 "in" expr_1
#line 812 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::In, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3929 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 263: // expr_1: expr_1 "!in" expr_1
#line 813 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionLogicalNot(builder->expressionUnresolvedOperator(hilti::operator_::Kind::In, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__)); }
#line 3935 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 264: // expr_1: call_expr
#line 814 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 3941 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 265: // expr_1: "cast" type_param_begin qtype type_param_end '(' expr ')'
#line 815 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                          { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Cast, {std::move(yystack_[1].value.as < hilti::Expression* > ()), builder->expressionType(std::move(yystack_[4].value.as < hilti::QualifiedType* > ()))}, __loc__); }
#line 3947 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 266: // expr_1: "pack" tuple_expr
#line 816 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                  { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Pack, {std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 3953 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 267: // expr_1: "unpack" type_param_begin qtype type_param_end tuple_expr
#line 817 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                                          { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Unpack, {builder->expressionType(std::move(yystack_[2].value.as < hilti::QualifiedType* > ())), std::move(yystack_[0].value.as < hilti::Expression* > ()), builder->expressionCtor(builder->ctorBool(false), __loc__)}, __loc__); }
#line 3959 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 268: // expr_1: "begin" '(' expr ')'
#line 818 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Begin, {std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 3965 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 269: // expr_1: "end" '(' expr ')'
#line 819 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::End, {std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 3971 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 270: // expr_1: "move" '(' expr ')'
#line 820 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionMove(std::move(yystack_[1].value.as < hilti::Expression* > ()), __loc__); }
#line 3977 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 271: // expr_1: "new" ctor
#line 821 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::New, {builder->expressionCtor(std::move(yystack_[0].value.as < hilti::Ctor* > ()), __loc__),             builder->expressionCtor(builder->ctorTuple({}, __loc__))}, __loc__); }
#line 3983 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 272: // expr_1: "new" qtype
#line 822 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::New, {builder->expressionType(std::move(yystack_[0].value.as < hilti::QualifiedType* > ())), builder->expressionCtor(builder->ctorTuple({}, __loc__))}, __loc__); }
#line 3989 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 273: // expr_1: "new" qtype '(' opt_exprs ')'
#line 823 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::New, {builder->expressionType(std::move(yystack_[3].value.as < hilti::QualifiedType* > ())), builder->expressionCtor(builder->ctorTuple(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__))}, __loc__); }
#line 3995 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 274: // expr_1: "typeinfo" '(' expr ')'
#line 824 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionTypeInfo(std::move(yystack_[1].value.as < hilti::Expression* > ()), __loc__); }
#line 4001 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 275: // expr_1: "typeinfo" '(' base_type ')'
#line 825 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionTypeInfo(builder->expressionType(builder->qualifiedType(std::move(yystack_[1].value.as < hilti::UnqualifiedType* > ()), Constness::Mutable)), __loc__); }
#line 4007 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 276: // expr_1: ctor
#line 826 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionCtor(std::move(yystack_[0].value.as < hilti::Ctor* > ()), __loc__); }
#line 4013 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 277: // expr_1: ctor_expr
#line 827 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 4019 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 278: // expr_1: '[' expr "for" local_id "in" expr ']'
#line 828 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionListComprehension(std::move(yystack_[1].value.as < hilti::Expression* > ()), std::move(yystack_[5].value.as < hilti::Expression* > ()), std::move(yystack_[3].value.as < hilti::ID > ()), {},  __loc__); }
#line 4025 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 279: // expr_1: '[' expr "for" local_id "in" expr "if" expr ']'
#line 829 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                            { yylhs.value.as < hilti::Expression* > () = builder->expressionListComprehension(std::move(yystack_[3].value.as < hilti::Expression* > ()), std::move(yystack_[7].value.as < hilti::Expression* > ()), std::move(yystack_[5].value.as < hilti::ID > ()), std::move(yystack_[1].value.as < hilti::Expression* > ()),  __loc__); }
#line 4031 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 280: // expr_1: '(' expr ')'
#line 830 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionGrouping(std::move(yystack_[1].value.as < hilti::Expression* > ())); }
#line 4037 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 281: // expr_1: scoped_id
#line 831 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionName(std::move(yystack_[0].value.as < hilti::ID > ()), __loc__); }
#line 4043 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 282: // expr_1: "$$"
#line 832 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionName(std::move("__dd"), __loc__); }
#line 4049 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 283: // expr_1: "scope"
#line 833 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionKeyword(hilti::expression::keyword::Kind::Scope, __loc__); }
#line 4055 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 284: // call_expr: expr_1 '(' opt_exprs ')'
#line 836 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Call, {std::move(yystack_[3].value.as < hilti::Expression* > ()), builder->expressionCtor(builder->ctorTuple(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__))}, __loc__); }
#line 4061 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 285: // member_expr: local_id
#line 840 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionMember(std::move(yystack_[0].value.as < hilti::ID > ()), __loc__); }
#line 4067 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 286: // member_expr: "error"
#line 841 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionMember(ID("error"), __loc__); }
#line 4073 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 287: // ctor: "bool value"
#line 845 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorBool(yystack_[0].value.as < bool > (), __loc__); }
#line 4079 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 288: // ctor: "bytes value"
#line 846 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorBytes(std::move(yystack_[0].value.as < std::string > ()), __loc__); }
#line 4085 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 289: // ctor: "string value"
#line 847 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorString(yystack_[0].value.as < std::string > (), false, __loc__); }
#line 4091 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 290: // ctor: "unsigned integer value"
#line 848 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorUnsignedInteger(yystack_[0].value.as < uint64_t > (), 64, __loc__); }
#line 4097 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 291: // ctor: '+' "unsigned integer value"
#line 849 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { if ( yystack_[0].value.as < uint64_t > () > static_cast<uint64_t>(std::numeric_limits<int64_t>::max()) )
                                                    logger().error("integer constant out of range", __loc__.location());

                                                   yylhs.value.as < hilti::Ctor* > () = builder->ctorSignedInteger(yystack_[0].value.as < uint64_t > (), 64, __loc__);
                                                 }
#line 4107 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 292: // ctor: "real value"
#line 854 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorReal(yystack_[0].value.as < double > (), __loc__); }
#line 4113 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 293: // ctor: '+' "real value"
#line 855 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorReal(yystack_[0].value.as < double > (), __loc__);; }
#line 4119 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 294: // ctor: "Null"
#line 856 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorNull(__loc__); }
#line 4125 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 295: // ctor: "address value"
#line 858 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorAddress(hilti::rt::Address(yystack_[0].value.as < std::string > ()), __loc__); }
#line 4131 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 296: // ctor: "address value" '/' "unsigned integer value"
#line 859 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorNetwork(hilti::rt::Network(yystack_[2].value.as < std::string > (), yystack_[0].value.as < uint64_t > ()), __loc__); }
#line 4137 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 297: // ctor: "port value"
#line 860 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorPort(hilti::rt::Port(yystack_[0].value.as < std::string > ()), __loc__); }
#line 4143 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 298: // ctor: "optional" '(' expr ')'
#line 865 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorOptional(std::move(yystack_[1].value.as < hilti::Expression* > ()), __loc__); }
#line 4149 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 299: // ctor: "default" type_param_begin type type_param_end '(' opt_exprs ')'
#line 867 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorDefault(std::move(yystack_[4].value.as < hilti::UnqualifiedType* > ()), std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 4155 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 300: // ctor: list
#line 868 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 4161 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 301: // ctor: map
#line 869 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 4167 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 302: // ctor: regexp
#line 870 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 4173 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 303: // ctor: set
#line 871 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 4179 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 304: // ctor: struct_
#line 872 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 4185 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 305: // ctor: tuple
#line 873 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 4191 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 306: // ctor_expr: "interval" '(' expr ')'
#line 876 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("interval", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4197 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 307: // ctor_expr: "interval_ns" '(' expr ')'
#line 877 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("interval_ns", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4203 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 308: // ctor_expr: "time" '(' expr ')'
#line 878 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("time", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4209 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 309: // ctor_expr: "time_ns" '(' expr ')'
#line 879 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("time_ns", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4215 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 310: // ctor_expr: "stream" '(' expr ')'
#line 880 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("stream", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4221 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 311: // ctor_expr: "error" '(' expr ')'
#line 881 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("error", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4227 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 312: // ctor_expr: "int8" '(' expr ')'
#line 882 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("int8", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4233 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 313: // ctor_expr: "int16" '(' expr ')'
#line 883 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("int16", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4239 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 314: // ctor_expr: "int32" '(' expr ')'
#line 884 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("int32", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4245 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 315: // ctor_expr: "int64" '(' expr ')'
#line 885 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("int64", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4251 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 316: // ctor_expr: "uint8" '(' expr ')'
#line 886 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("uint8", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4257 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 317: // ctor_expr: "uint16" '(' expr ')'
#line 887 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("uint16", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4263 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 318: // ctor_expr: "uint32" '(' expr ')'
#line 888 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("uint32", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4269 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 319: // ctor_expr: "uint64" '(' expr ')'
#line 889 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("uint64", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 4275 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 320: // ctor_expr: "port" '(' expr ',' expr ')'
#line 890 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("port", {std::move(yystack_[3].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 4281 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 321: // tuple: '(' opt_tuple_elems1 ')'
#line 893 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorTuple(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 4287 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 322: // opt_tuple_elems1: tuple_elem
#line 896 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions{std::move(yystack_[0].value.as < hilti::Expression* > ())}; }
#line 4293 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 323: // opt_tuple_elems1: tuple_elem ',' opt_tuple_elems2
#line 897 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions{std::move(yystack_[2].value.as < hilti::Expression* > ())}; yylhs.value.as < hilti::Expressions > ().insert(yylhs.value.as < hilti::Expressions > ().end(), yystack_[0].value.as < hilti::Expressions > ().begin(), yystack_[0].value.as < hilti::Expressions > ().end()); }
#line 4299 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 324: // opt_tuple_elems1: %empty
#line 898 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions(); }
#line 4305 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 325: // opt_tuple_elems2: tuple_elem
#line 901 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions{ std::move(yystack_[0].value.as < hilti::Expression* > ())}; }
#line 4311 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 326: // opt_tuple_elems2: tuple_elem ',' opt_tuple_elems2
#line 902 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions{std::move(yystack_[2].value.as < hilti::Expression* > ())}; yylhs.value.as < hilti::Expressions > ().insert(yylhs.value.as < hilti::Expressions > ().end(), yystack_[0].value.as < hilti::Expressions > ().begin(), yystack_[0].value.as < hilti::Expressions > ().end()); }
#line 4317 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 327: // opt_tuple_elems2: %empty
#line 903 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions(); }
#line 4323 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 328: // tuple_elem: expr
#line 906 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 4329 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 329: // tuple_expr: tuple
#line 909 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionCtor(std::move(yystack_[0].value.as < hilti::Ctor* > ()), __loc__); }
#line 4335 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 330: // list: '[' opt_exprs ']'
#line 911 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorList(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 4341 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 331: // list: "list" '(' opt_exprs ')'
#line 912 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorList(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 4347 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 332: // list: "list" type_param_begin qtype type_param_end '(' opt_tuple_elems1 ')'
#line 914 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorList(std::move(yystack_[4].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 4353 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 333: // list: "vector" '(' opt_exprs ')'
#line 915 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorVector(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 4359 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 334: // list: "vector" type_param_begin qtype type_param_end '(' opt_tuple_elems1 ')'
#line 917 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorVector(std::move(yystack_[4].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 4365 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 335: // set: "set" '(' opt_exprs ')'
#line 919 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorSet(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 4371 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 336: // set: "set" type_param_begin qtype type_param_end '(' opt_tuple_elems1 ')'
#line 921 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorSet(std::move(yystack_[4].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 4377 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 337: // map: "map" '(' opt_map_elems ')'
#line 923 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorMap(std::move(yystack_[1].value.as < hilti::ctor::map::Elements > ()), __loc__); }
#line 4383 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 338: // map: "map" type_param_begin qtype ',' qtype type_param_end '(' opt_map_elems ')'
#line 925 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorMap(std::move(yystack_[6].value.as < hilti::QualifiedType* > ()), std::move(yystack_[4].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::ctor::map::Elements > ()), __loc__); }
#line 4389 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 339: // struct_: '[' struct_elems ']'
#line 927 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                             { yylhs.value.as < hilti::Ctor* > () = builder->ctorStruct(std::move(yystack_[1].value.as < hilti::ctor::struct_::Fields > ()), __loc__); }
#line 4395 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 340: // struct_elems: struct_elems ',' struct_elem
#line 929 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::struct_::Fields > () = std::move(yystack_[2].value.as < hilti::ctor::struct_::Fields > ()); yylhs.value.as < hilti::ctor::struct_::Fields > ().push_back(yystack_[0].value.as < hilti::ctor::struct_::Field* > ()); }
#line 4401 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 341: // struct_elems: struct_elem
#line 930 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::struct_::Fields > () = hilti::ctor::struct_::Fields{ std::move(yystack_[0].value.as < hilti::ctor::struct_::Field* > ()) }; }
#line 4407 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 342: // struct_elem: '$' local_id '=' expr
#line 932 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::struct_::Field* > () = builder->ctorStructField(std::move(yystack_[2].value.as < hilti::ID > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())); }
#line 4413 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 343: // regexp: re_patterns opt_attributes
#line 934 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorRegExp(std::move(yystack_[1].value.as < hilti::ctor::regexp::Patterns > ()), std::move(yystack_[0].value.as < hilti::AttributeSet* > ()), __loc__); }
#line 4419 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 344: // re_patterns: re_patterns '|' re_pattern_constant
#line 937 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::regexp::Patterns > () = yystack_[2].value.as < hilti::ctor::regexp::Patterns > (); yylhs.value.as < hilti::ctor::regexp::Patterns > ().push_back(std::move(yystack_[0].value.as < hilti::ctor::regexp::Pattern > ())); }
#line 4425 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 345: // re_patterns: re_pattern_constant
#line 938 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::regexp::Patterns > () = hilti::ctor::regexp::Patterns{std::move(yystack_[0].value.as < hilti::ctor::regexp::Pattern > ())}; }
#line 4431 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 346: // $@4: %empty
#line 941 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                    { driver->enablePatternMode(); }
#line 4437 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 347: // $@5: %empty
#line 941 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                             { driver->disablePatternMode(); }
#line 4443 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 348: // re_pattern_constant: '/' $@4 "regular expression value" $@5 '/' opt_re_pattern_constant_flags
#line 942 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 {
                                                   yylhs.value.as < hilti::ctor::regexp::Pattern > () = yystack_[0].value.as < hilti::ctor::regexp::Pattern > ();
                                                   yylhs.value.as < hilti::ctor::regexp::Pattern > ().setValue(yystack_[3].value.as < std::string > ());
                                                 }
#line 4452 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 349: // opt_re_pattern_constant_flags: local_id opt_re_pattern_constant_flags
#line 949 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 {
                                                   yylhs.value.as < hilti::ctor::regexp::Pattern > () = yystack_[0].value.as < hilti::ctor::regexp::Pattern > ();
                                                   if ( yystack_[1].value.as < hilti::ID > () == ID("i") )
                                                       yylhs.value.as < hilti::ctor::regexp::Pattern > ().setCaseInsensitive(true);
                                                   else
                                                       error(yylhs.location, "unknown regular expression flag");
                                                 }
#line 4464 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 350: // opt_re_pattern_constant_flags: '$' '(' "unsigned integer value" ')' opt_re_pattern_constant_flags
#line 957 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 {
                                                   yylhs.value.as < hilti::ctor::regexp::Pattern > () = yystack_[0].value.as < hilti::ctor::regexp::Pattern > ();
                                                   yylhs.value.as < hilti::ctor::regexp::Pattern > ().setMatchID(yystack_[2].value.as < uint64_t > ());
                                                 }
#line 4473 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 351: // opt_re_pattern_constant_flags: %empty
#line 961 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::regexp::Pattern > () = {}; }
#line 4479 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 352: // opt_map_elems: map_elems
#line 963 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::map::Elements > () = std::move(yystack_[0].value.as < hilti::ctor::map::Elements > ()); }
#line 4485 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 353: // opt_map_elems: %empty
#line 964 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::map::Elements > () = hilti::ctor::map::Elements(); }
#line 4491 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 354: // map_elems: map_elems ',' map_elem
#line 966 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::map::Elements > () = std::move(yystack_[2].value.as < hilti::ctor::map::Elements > ()); yylhs.value.as < hilti::ctor::map::Elements > ().push_back(std::move(yystack_[0].value.as < hilti::ctor::map::Element* > ())); }
#line 4497 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 355: // map_elems: map_elem
#line 967 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::map::Elements > () = hilti::ctor::map::Elements(); yylhs.value.as < hilti::ctor::map::Elements > ().push_back(std::move(yystack_[0].value.as < hilti::ctor::map::Element* > ())); }
#line 4503 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 356: // map_elem: expr_no_or_error ':' expr
#line 969 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::map::Element* > () = builder->ctorMapElement(yystack_[2].value.as < hilti::Expression* > (), yystack_[0].value.as < hilti::Expression* > (), __loc__); }
#line 4509 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 357: // attribute: "attribute"
#line 972 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { try {
                                                       yylhs.value.as < hilti::Attribute* > () = builder->attribute(hilti::attribute::kind::from_string(yystack_[0].value.as < std::string > ()), __loc__);
                                                   } catch ( std::out_of_range& e ) {
                                                       error(yylhs.location, hilti::util::fmt("unknown attribute '%s'", yystack_[0].value.as < std::string > ()));
                                                       yylhs.value.as < hilti::Attribute* > () = nullptr;
                                                   }
                                                 }
#line 4521 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 358: // attribute: "attribute" '=' expr
#line 979 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                 { try {
                                                       yylhs.value.as < hilti::Attribute* > () = builder->attribute(hilti::attribute::kind::from_string(yystack_[2].value.as < std::string > ()), std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__);
                                                   } catch ( std::out_of_range& e ) {
                                                       error(yylhs.location, hilti::util::fmt("unknown attribute '%s'", yystack_[2].value.as < std::string > ()));
                                                       yylhs.value.as < hilti::Attribute* > () = nullptr;
                                                   }
                                                 }
#line 4533 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 359: // opt_attributes: opt_attributes attribute
#line 988 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                { if ( yystack_[0].value.as < hilti::Attribute* > () )
                                                    yystack_[1].value.as < hilti::AttributeSet* > ()->add(builder->context(), yystack_[0].value.as < hilti::Attribute* > ());

                                                  yylhs.value.as < hilti::AttributeSet* > () = yystack_[1].value.as < hilti::AttributeSet* > ();
                                                }
#line 4543 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;

  case 360: // opt_attributes: %empty
#line 993 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
                                                { yylhs.value.as < hilti::AttributeSet* > () = builder->attributeSet({}, __loc__); }
#line 4549 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"
    break;


#line 4553 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"

            default:
              break;
            }
        }
#if YY_EXCEPTIONS
      catch (const syntax_error& yyexc)
        {
          YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
          error (yyexc);
          YYERROR;
        }
#endif // YY_EXCEPTIONS
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, YY_MOVE (yylhs));
    }
    goto yynewstate;


  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        context yyctx (*this, yyla);
        std::string msg = yysyntax_error_ (yyctx);
        error (yyla.location, YY_MOVE (msg));
      }


    yyerror_range[1].location = yyla.location;
    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.kind () == symbol_kind::S_YYEOF)
          YYABORT;
        else if (!yyla.empty ())
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyla.clear ();
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:
    /* Pacify compilers when the user code never invokes YYERROR and
       the label yyerrorlab therefore never appears in user code.  */
    if (false)
      YYERROR;

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    YY_STACK_PRINT ();
    goto yyerrlab1;


  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    // Pop stack until we find a state that shifts the error token.
    for (;;)
      {
        yyn = yypact_[+yystack_[0].state];
        if (!yy_pact_value_is_default_ (yyn))
          {
            yyn += symbol_kind::S_YYerror;
            if (0 <= yyn && yyn <= yylast_
                && yycheck_[yyn] == symbol_kind::S_YYerror)
              {
                yyn = yytable_[yyn];
                if (0 < yyn)
                  break;
              }
          }

        // Pop the current state because it cannot handle the error token.
        if (yystack_.size () == 1)
          YYABORT;

        yyerror_range[1].location = yystack_[0].location;
        yy_destroy_ ("Error: popping", yystack_[0]);
        yypop_ ();
        YY_STACK_PRINT ();
      }
    {
      stack_symbol_type error_token;

      yyerror_range[2].location = yyla.location;
      YYLLOC_DEFAULT (error_token.location, yyerror_range, 2);

      // Shift the error token.
      error_token.state = state_type (yyn);
      yypush_ ("Shifting", YY_MOVE (error_token));
    }
    goto yynewstate;


  /*-------------------------------------.
  | yyacceptlab -- YYACCEPT comes here.  |
  `-------------------------------------*/
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;


  /*-----------------------------------.
  | yyabortlab -- YYABORT comes here.  |
  `-----------------------------------*/
  yyabortlab:
    yyresult = 1;
    goto yyreturn;


  /*-----------------------------------------------------.
  | yyreturn -- parsing is finished, return the result.  |
  `-----------------------------------------------------*/
  yyreturn:
    if (!yyla.empty ())
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    YY_STACK_PRINT ();
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
#if YY_EXCEPTIONS
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack\n";
        // Do not try to display the values of the reclaimed symbols,
        // as their printers might throw an exception.
        if (!yyla.empty ())
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
#endif // YY_EXCEPTIONS
  }

  void
  Parser::error (const syntax_error& yyexc)
  {
    error (yyexc.location, yyexc.what ());
  }

  /* Return YYSTR after stripping away unnecessary quotes and
     backslashes, so that it's suitable for yyerror.  The heuristic is
     that double-quoting is unnecessary unless the string contains an
     apostrophe, a comma, or backslash (other than backslash-backslash).
     YYSTR is taken from yytname.  */
  std::string
  Parser::yytnamerr_ (const char *yystr)
  {
    if (*yystr == '"')
      {
        std::string yyr;
        char const *yyp = yystr;

        for (;;)
          switch (*++yyp)
            {
            case '\'':
            case ',':
              goto do_not_strip_quotes;

            case '\\':
              if (*++yyp != '\\')
                goto do_not_strip_quotes;
              else
                goto append;

            append:
            default:
              yyr += *yyp;
              break;

            case '"':
              return yyr;
            }
      do_not_strip_quotes: ;
      }

    return yystr;
  }

  std::string
  Parser::symbol_name (symbol_kind_type yysymbol)
  {
    return yytnamerr_ (yytname_[yysymbol]);
  }



  // Parser::context.
  Parser::context::context (const Parser& yyparser, const symbol_type& yyla)
    : yyparser_ (yyparser)
    , yyla_ (yyla)
  {}

  int
  Parser::context::expected_tokens (symbol_kind_type yyarg[], int yyargn) const
  {
    // Actual number of expected tokens
    int yycount = 0;

    const int yyn = yypact_[+yyparser_.yystack_[0].state];
    if (!yy_pact_value_is_default_ (yyn))
      {
        /* Start YYX at -YYN if negative to avoid negative indexes in
           YYCHECK.  In other words, skip the first -YYN actions for
           this state because they are default actions.  */
        const int yyxbegin = yyn < 0 ? -yyn : 0;
        // Stay within bounds of both yycheck and yytname.
        const int yychecklim = yylast_ - yyn + 1;
        const int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
        for (int yyx = yyxbegin; yyx < yyxend; ++yyx)
          if (yycheck_[yyx + yyn] == yyx && yyx != symbol_kind::S_YYerror
              && !yy_table_value_is_error_ (yytable_[yyx + yyn]))
            {
              if (!yyarg)
                ++yycount;
              else if (yycount == yyargn)
                return 0;
              else
                yyarg[yycount++] = YY_CAST (symbol_kind_type, yyx);
            }
      }

    if (yyarg && yycount == 0 && 0 < yyargn)
      yyarg[0] = symbol_kind::S_YYEMPTY;
    return yycount;
  }






  int
  Parser::yy_syntax_error_arguments_ (const context& yyctx,
                                                 symbol_kind_type yyarg[], int yyargn) const
  {
    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yyla) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
       - Of course, the expected token list depends on states to have
         correct lookahead information, and it depends on the parser not
         to perform extra reductions after fetching a lookahead from the
         scanner and before detecting a syntax error.  Thus, state merging
         (from LALR or IELR) and default reductions corrupt the expected
         token list.  However, the list is correct for canonical LR with
         one exception: it will still contain any token that will not be
         accepted due to an error action in a later state.
    */

    if (!yyctx.lookahead ().empty ())
      {
        if (yyarg)
          yyarg[0] = yyctx.token ();
        int yyn = yyctx.expected_tokens (yyarg ? yyarg + 1 : yyarg, yyargn - 1);
        return yyn + 1;
      }
    return 0;
  }

  // Generate an error message.
  std::string
  Parser::yysyntax_error_ (const context& yyctx) const
  {
    // Its maximum.
    enum { YYARGS_MAX = 5 };
    // Arguments of yyformat.
    symbol_kind_type yyarg[YYARGS_MAX];
    int yycount = yy_syntax_error_arguments_ (yyctx, yyarg, YYARGS_MAX);

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
      default: // Avoid compiler warnings.
        YYCASE_ (0, YY_("syntax error"));
        YYCASE_ (1, YY_("syntax error, unexpected %s"));
        YYCASE_ (2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_ (3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_ (4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_ (5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    std::string yyres;
    // Argument number.
    std::ptrdiff_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += symbol_name (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const short Parser::yypact_ninf_ = -709;

  const short Parser::yytable_ninf_ = -325;

  const short
  Parser::yypact_[] =
  {
     -55,    43,    54,  -709,   -87,  -709,  -709,  1919,  -709,   -66,
    -709,  -709,   -61,  -709,  -709,  -709,  -709,  3431,  3431,  3431,
     -60,   -56,    -4,  -709,   -22,   -39,    -4,  3431,  -709,   -10,
      -6,    15,    29,    43,  -709,    34,    48,    50,    64,    65,
      66,   -88,  5144,   -62,    95,  3431,    68,  3747,    69,    70,
    3431,    71,  -709,  -709,  -709,  2927,  -709,   -26,    72,    75,
      76,    77,  3095,  2591,    78,    79,    80,    82,    83,    -4,
    3431,   -19,    85,     4,  3431,   173,  3431,  3431,  -709,  1245,
    2255,  -709,  3431,  3431,  3431,  -709,  -709,  -709,  1414,  1582,
    -709,  -709,  -709,  -709,  -709,    99,  -709,  -709,  -709,    40,
    -709,  -709,  5850,  -709,  -709,  -709,  -709,  -709,  -709,  -709,
    -709,  -709,    98,  -709,  3431,  -709,   175,    62,    92,    -7,
    6084,  3431,  -709,  -709,  5271,  -709,   -43,  5779,   101,  3431,
    3431,    43,  3263,   -42,  3431,  3431,  3431,  3431,  3431,  3431,
    3431,  5271,  -709,  -709,   253,   120,  -709,  -709,  5779,  -709,
      -9,  -709,  -709,  -709,    -4,  -709,    -4,   123,   124,    -4,
      -4,  -709,  -709,    -4,  -709,    -4,  -709,    -4,    -4,  -709,
    -709,   125,  -709,    -4,  -709,    -4,  -709,    -4,    -4,  -709,
      -4,    -4,   240,   146,  -709,   236,  -709,  -709,  -709,  -709,
      43,  -709,  -709,  -709,  -709,  -709,  -709,  3431,  5271,  -709,
    -709,  -709,  5271,   475,  3431,  -709,   -88,   -62,    32,   -26,
     -19,  1076,  3431,   131,  -709,  3431,  -709,  -709,   634,  3431,
    -709,   135,  3431,  5271,  3431,  3263,  3431,  3431,  -709,   136,
    -709,  -709,    -2,   271,  -709,  2087,  3431,  3431,  3431,  3431,
    5271,   141,  3431,  5271,  3263,  -709,  6201,  -709,  -709,   662,
     664,   297,    43,   255,   143,   147,    33,  -709,   150,  2423,
    -709,   149,   156,   158,   670,   749,  5779,    95,  5398,    95,
     209,  -709,  3431,  3431,  3431,  3431,    26,  3431,  3431,  3431,
    -709,  3431,  3431,  3431,  3431,  -709,  3431,  3431,  3431,  3431,
      26,  3431,  3431,  3431,  3431,  3431,  3431,  3431,  3431,  3431,
    3431,  3431,  3431,  3431,    26,  3431,  3431,   165,   325,   164,
    -709,  -709,  -709,  3431,  -709,   168,   180,   167,    95,   180,
    -709,   171,   172,   274,  5525,  -120,   177,  -709,  -709,   178,
     179,   181,   182,   184,   185,  -709,   186,   180,   193,   331,
    -709,   189,    43,    13,  5271,   349,   350,  4128,  4255,  5271,
    4382,  5271,  4509,   -23,   194,  4636,    21,    10,  4763,  5271,
    4890,  5017,   210,  3431,   195,  -114,   214,   198,   192,  -709,
     199,    39,   202,  4128,  4255,  4509,  4763,  -709,  3431,   203,
     205,  -709,   204,   180,   207,   212,   213,   215,   217,  -709,
    2759,   354,  -709,    -6,    65,    71,    72,    76,  1076,   220,
     223,   224,   226,   227,   230,   180,  -709,   234,   180,   -70,
     235,  3599,  -709,   231,    43,  -709,  3431,   232,  -709,  -709,
    -709,  -709,  -709,  3431,   258,   209,  -709,  5271,   211,   260,
     209,  -709,  5271,   261,  7051,  6311,  7291,   -41,  -709,  -709,
    -709,  7131,   504,  6421,  7324,  7211,  6971,  6531,   -33,   273,
     586,  6641,  -709,  6751,  5967,  -709,   764,  5931,   947,  6048,
     414,    30,   964,   254,   384,   451,   244,   248,   252,  -709,
     275,  -709,  -709,   256,  -709,  -709,   257,  -709,  5271,   259,
    -709,  -709,  3431,   425,    43,  3431,  2591,  2591,   262,   424,
    -709,  -709,  -709,  -709,  -709,  -709,  -709,   267,  3431,   269,
     286,   291,   -16,  -709,   180,   180,   180,   278,   281,   180,
     180,   180,   272,   180,   180,   180,   180,   180,   180,  -709,
    -709,   282,   283,  -709,  5652,  -709,   180,   292,  -709,   -76,
    -709,   180,   180,  3874,   180,   180,   180,   180,   180,   180,
     180,  5779,   277,   -23,  3431,  3431,   285,  3431,  -709,  3431,
    5271,  -709,  -709,  -709,  -709,  -709,   287,  -709,   180,   284,
     180,   180,   288,  -709,  3431,  -709,   290,  -709,   294,   295,
    -709,  -709,  1750,  -709,  -709,  -709,  -709,  -709,  -709,  -709,
    -709,    70,  -709,   293,  3431,  2591,  2591,   301,  3431,   387,
    -709,  -709,  -709,   298,  3431,   316,    39,   318,  3431,  -106,
      39,  5271,  3431,  3431,  -709,  -709,  3431,  -709,  3431,    39,
    3431,   300,   321,   322,   303,   427,   428,  -709,  -709,  3431,
     307,  -709,  -709,   465,  -709,    43,  -709,  -709,  -709,  -709,
    -709,  -709,  -709,  -709,  5271,  -709,  -709,  -709,  -709,  -709,
    -709,  -709,    20,  -709,    43,  -709,  4001,  -709,  5271,  5271,
    -709,  -709,  -709,    43,   320,   314,  -709,  -709,  -709,  -709,
    -709,  -709,  -709,  -709,   323,  -709,   324,   328,   327,  -709,
    -709,  -709,   180,   -23,   319,  5271,   329,   334,  -709,   338,
    3431,    61,    61,   488,    43,  -709,  3431,   341,   442,   443,
       3,  -709,  3431,  3431,   347,  3431,   355,  3431,   348,  3431,
     359,   361,  -709,  6861,   358,  -709,   365,   367,   368,  2591,
    3431,  3431,  2591,  2591,  -709,  -709,  -709,   369,  -709,   363,
    -709,  -709,   180,  -709,   390,  -709,   139,    43,  -709,  -709,
    -709,  -709,  -709,  5271,  -709,   514,  -709,  -709,   376,   380,
     180,  -709,   389,  3431,   394,   393,    61,  -709,   395,   396,
     399,  2591,  -709,  -709,   408,     3,  -709,   -47,  -709,  -709,
     397,   -23,   417,  -709,   419,  -709,   -23,     7,  -709,  -709,
     -23,  -709,  -709,  -709,  -709,   513,  -709,  -709,    43,  -709,
    3431,  -709,  5271,  -709,   558,  -709,  5271,  3431,  -709,   420,
    -709,   -98,  -709,  2591,  -709,  -709,  -709,  2591,  -709,   538,
     576,  -709,  3431,  -709,  -709,   421,  -709,  -709,   422,  -709,
     423,  -709,   445,   433,    43,  -709,  -709,   558,    28,     9,
    -709,   431,    17,  2591,  3431,  -709,  -709,  -709,   434,   436,
    -709,  -709,  -709,   581,  -709,  -709,   437,  -709,  -709,  -709,
    -709,  -709,     3,  -709,    17,    17,   558,   555,   -23,  -709,
    -709,  -709,   596,    11,   444,  -709,  -709,  -709,    12,     5,
    -709,  -709,  -709
  };

  const short
  Parser::yydefact_[] =
  {
       0,     0,     0,     3,     0,     1,    11,    45,     5,     0,
     289,   288,   295,   297,   292,   290,   287,     0,     0,     0,
       0,     0,     0,   294,     0,    45,     0,     0,   282,     0,
       0,     0,     0,     0,    43,     0,     0,     0,     0,     0,
       0,     0,    56,     0,    61,     0,     0,    56,     0,     0,
       0,     0,    44,    42,    41,     0,   283,     0,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   346,   218,
      45,     2,   324,     0,     0,     4,   281,     9,    12,    13,
     120,    14,    15,    16,    17,     0,    82,    10,    81,     0,
     123,   215,   221,   264,   276,   277,   305,   300,   303,   301,
     304,   302,   360,   345,     0,    39,     0,     0,     0,     0,
     216,     0,    88,   177,    56,    89,    56,    56,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     218,    56,   125,   124,     0,     0,   126,   127,    56,   132,
       0,   128,   161,    58,     0,   129,     0,     0,     0,     0,
       0,    57,   130,     0,   131,     0,   133,     0,     0,   134,
     135,   188,   136,     0,   137,     0,   360,     0,     0,   138,
       0,     0,     0,     4,   173,     0,    55,   170,   171,   174,
       0,   172,   165,   166,   167,   168,   169,   353,    56,    59,
      60,    35,    56,   253,     0,   176,     0,     0,     0,     0,
       0,   218,   324,   272,   271,     0,   329,   266,   254,     0,
      83,     0,   218,    56,     0,     0,     0,     0,    86,     0,
     121,   122,     0,     0,    74,     0,     0,     0,     0,     0,
      56,     0,   218,    56,     0,    87,     0,   293,   291,   251,
     249,     0,     0,   220,     0,   217,     0,   341,     0,    45,
      79,   328,     0,   322,   248,   250,    56,    61,    56,    61,
       0,    80,     0,     0,     0,     0,     0,     0,     0,     0,
     258,     0,     0,     0,     0,   259,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   218,     0,   343,     0,
     296,   103,   100,     0,   102,     0,     0,     0,    61,     0,
     104,     0,     0,     0,    56,     0,     0,     6,    37,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,     0,
     175,     0,     0,     0,    56,     0,     0,    56,    56,    56,
      56,    56,    56,    71,     0,    56,     0,     0,    56,    56,
      56,    56,     0,     0,     0,    32,     0,     0,   352,   355,
       0,     0,     0,    56,    56,    56,    56,   328,   218,     0,
       0,    84,     0,     0,     0,     0,     0,     0,     0,    85,
      45,    99,   117,   128,   129,   131,   134,   136,   218,     0,
       0,     0,     0,     0,     0,     0,   105,     0,     0,     0,
       0,   252,   347,     0,     0,   330,     0,     0,   339,    75,
      78,   280,   321,   327,   173,     0,    33,    56,     0,   173,
       0,    34,    56,     0,   230,   227,   231,   235,   286,   285,
     260,   262,   236,   224,   232,   263,   229,   225,   247,   240,
     241,   226,   261,   223,     0,   222,   233,   234,   237,   238,
     239,   242,   243,   244,   245,   246,   256,     0,     0,   344,
     357,   359,    40,     0,   268,   178,     0,    36,    56,     0,
     269,   311,     0,     0,     0,     0,    45,    45,     0,     0,
     313,   314,   315,   312,   306,   307,   331,     0,     0,     0,
       0,   205,     0,   204,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    69,
      70,     0,    62,    65,    56,   190,     0,     4,   184,     0,
     183,     0,     0,    56,     0,     0,     0,     0,     0,     0,
       0,    56,     0,    71,     0,   218,     0,     0,   337,     0,
      56,    49,    50,    47,    46,    48,     0,   270,     0,     0,
       0,     0,     0,   298,     0,   335,     0,   310,     0,     0,
     308,   309,    56,   119,   116,   275,   274,   317,   318,   319,
     316,     0,   333,     0,     0,    45,    45,     0,     0,     0,
     219,   340,   323,   325,     0,     0,     0,     0,     0,    32,
       0,    56,     0,   218,   255,   284,     0,   101,     0,     0,
     218,     0,     0,     0,     0,   107,   107,    38,     7,   324,
       0,   207,   201,     0,   200,   203,   139,   140,   146,   163,
     164,   153,   154,   159,    56,   143,   148,   147,   144,   157,
     158,   187,    71,    68,     0,    67,    56,   180,    56,    56,
     181,   141,   142,     0,     0,   195,   198,   155,   156,   145,
     150,   149,   152,   151,     0,    21,     0,     0,     0,    22,
     356,   354,     0,    71,   154,    56,   158,   156,   273,     0,
     324,   109,   109,   281,     0,   267,   324,     0,   107,   107,
     351,   342,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,   360,   228,     0,   358,     0,     0,     0,    45,
       0,     0,    45,    45,    91,    90,     8,     0,    24,     0,
     206,   202,     0,    64,    73,   186,    61,     0,   189,   185,
     182,   360,   194,    56,   162,     0,    23,    31,     0,     0,
       0,   320,     0,     0,     0,     0,   108,   111,     0,     0,
       0,    45,    95,    94,     0,   351,   348,     0,   326,    19,
       0,    71,     0,    27,     0,    28,    71,     0,   257,   265,
      71,   299,    96,    26,    25,   107,   106,   332,   210,   160,
       0,   360,    56,   360,   199,   197,    56,   353,   360,   160,
     336,     0,   115,    45,    98,   110,    97,    45,   334,   107,
       0,   349,     0,   278,    20,     0,    30,    29,     0,    18,
       0,    92,     0,     0,   209,   212,    72,    66,     0,     0,
     179,     0,     0,    45,     0,   113,   118,    93,     0,     0,
     360,   360,   360,     0,   208,   211,     0,   191,   338,    52,
     112,   114,   351,   279,     0,     0,    54,   360,    71,   350,
      51,    53,     0,     0,     0,   360,   214,   360,     0,     0,
     213,   192,   193
  };

  const short
  Parser::yypgoto_[] =
  {
    -709,  -709,    -1,   360,  -709,  -709,  -709,  -709,  -709,   606,
     607,  -709,  -168,  -709,    19,  -709,  -709,  -709,    84,  -199,
    -441,  -709,  -709,  -709,  -709,   494,   -17,  -260,  -533,  -709,
      -5,    55,  -709,  -709,  -375,  -615,  -709,  -709,     6,  -605,
     -49,  -709,  -110,  -709,  -709,   247,  -709,  -709,  -709,   404,
    -125,   501,   346,   486,  -709,  -709,  -709,    -3,  -709,  -709,
    -709,  -709,  -709,  -709,  -709,   -89,  -709,  -709,    22,  -709,
    -709,  -709,  -709,  -165,    87,   -18,  -135,  -709,  -709,   -15,
    -709,  -251,   603,  -709,   -46,  -592,   -38,  -415,    73,  -709,
    -709,  -709,  -709,  -709,   239,  -709,  -709,   351,  -709,  -709,
    -708,  -130,  -709,   119,  -709,   116
  };

  const short
  Parser::yydefgoto_[] =
  {
       0,     2,    85,    86,   488,   489,   716,     7,    87,   230,
     231,    90,   325,    91,   546,    92,    93,    94,   232,   555,
     556,   426,   201,   431,   317,   185,   186,   202,   521,   522,
     523,   644,   524,   781,   233,    96,   258,   259,   234,   714,
     745,   746,   747,   791,   391,   392,    98,    99,   187,   188,
     189,   528,   349,   476,   191,   192,   529,   530,   193,   354,
     646,   728,   194,   654,   655,   656,   195,   502,   503,   196,
     719,   813,   814,   815,   100,   366,   254,   255,   101,   102,
     103,   440,   104,   105,   106,   262,   592,   263,   217,   107,
     108,   109,   110,   256,   257,   111,   112,   113,   251,   587,
     756,   367,   368,   369,   471,   308
  };

  const short
  Parser::yytable_[] =
  {
       4,   119,   319,   216,   120,   336,     3,   427,   593,   432,
     666,   715,   470,    97,   470,   573,   470,   470,   470,   470,
     519,   327,   802,   340,   470,   153,   276,   717,   504,     3,
     203,     3,   133,    34,   276,   218,   531,   544,   266,   452,
       1,   183,     3,   551,   552,   699,     3,   801,   161,   485,
     520,   486,   280,   466,     5,   823,   545,   385,   478,   246,
     280,   249,   250,   519,   545,   285,   123,   286,   264,   265,
      52,    53,    54,   285,   824,   286,   409,   287,   288,   475,
       6,   438,   140,   752,   753,   114,   260,   382,   742,   553,
     290,    95,   123,   520,   750,   743,   649,   276,   290,   584,
     553,   585,   116,   115,   117,   118,   744,   407,   197,   126,
     121,   615,   616,   122,   128,   296,   297,   298,   299,   300,
     301,   302,   303,   280,   304,   305,   803,   328,   123,   306,
     323,   270,   304,   305,   849,   123,   285,   306,   286,   266,
     739,   425,   221,   338,   222,   341,   313,   125,   -63,   229,
     123,   242,   624,   199,   200,   696,   625,   241,   342,   701,
     129,   290,   314,   267,   130,   268,   253,   269,   707,   261,
     811,   468,    80,   245,   861,   505,   809,   533,   837,   754,
     856,   860,   120,   532,    80,   131,   123,   247,   248,   365,
     310,   301,   302,   303,   827,   304,   305,   199,   200,   132,
     306,   309,   215,   -55,   134,   417,   418,   839,   315,   271,
     688,   689,     3,     8,     3,     8,   321,   322,   135,   326,
     136,   329,   330,   331,   332,   333,   334,   335,   805,   850,
     851,   311,   270,   808,   137,   138,   139,   810,   204,   215,
     212,   219,   224,   562,   862,   225,   226,   227,   235,   236,
     237,   413,   238,   239,   307,   244,     3,   434,   435,   436,
     437,   312,   441,   442,   443,   420,   444,   445,   446,   447,
     320,   448,   449,   450,   451,   439,   453,   454,   593,   456,
     457,   458,   459,   460,   461,   462,   463,   464,   465,   439,
     339,   372,   357,   345,   346,   353,   362,   363,   335,   377,
     364,   378,   379,   439,   381,   389,   380,   390,   412,   335,
     406,   384,   386,   387,   388,   854,   415,   414,   419,   416,
     421,   276,   400,   401,   402,   403,   404,   422,    78,   335,
     423,   410,   470,   472,   772,   475,   477,   775,   776,   474,
     276,   501,   480,   481,   498,   482,   499,   280,   487,   490,
     491,   500,   492,   493,   527,   494,   495,   496,   507,   508,
     285,   525,   286,   541,   549,   543,   280,   547,   124,   548,
     554,   550,   127,   557,   563,   565,   799,   564,   567,   285,
     455,   286,   588,   568,   569,   290,   570,   141,   571,   198,
     390,   575,   467,   335,   576,   577,   458,   578,   579,   645,
     473,   580,   184,   223,   290,   582,   586,   184,   252,   594,
     668,   598,   601,   589,   603,   240,   664,   243,   825,   304,
     305,   604,   826,   605,   306,   607,   606,   608,     3,   610,
     618,   617,   299,   300,   301,   302,   303,   619,   304,   305,
     621,   622,   623,   306,   634,   648,   665,   645,   840,   629,
     542,   276,   630,   641,   669,   642,   675,   673,   692,   678,
     680,   681,   682,   686,   690,   335,   782,   695,   704,   697,
     693,   709,   710,   711,   712,   708,   718,   280,   713,   713,
     720,   276,   612,   613,   184,   253,   733,   184,   732,   619,
     285,  -173,   286,   713,   713,   735,   734,   736,   737,   680,
     343,   184,   344,   590,   686,   347,   348,   280,   184,   741,
     377,   350,   751,   351,   352,   290,   759,   763,   276,   355,
     285,   356,   286,   358,   359,   761,   360,   361,   765,   768,
     778,   766,   287,   288,   120,   216,   769,   770,   786,   771,
     777,   780,   276,   190,   280,   290,   787,   793,   213,   304,
     305,   788,   373,   374,   306,   375,   376,   285,   184,   286,
     790,   794,   184,   796,   713,   470,   804,   797,   280,   611,
     798,   276,   614,   299,   300,   301,   302,   303,   800,   304,
     305,   285,   290,   184,   306,   620,   806,   703,   807,   713,
     787,   828,   830,   831,   832,   554,   847,   280,   833,   554,
     184,   834,   838,   184,   852,   842,   290,   848,   554,   843,
     285,   855,   286,    88,    89,   857,   304,   305,   700,   836,
     318,   306,   287,   288,   501,   316,   424,   684,   429,   726,
     433,   667,   335,   748,   670,   290,   795,   723,   574,   399,
     304,   305,   337,   724,   785,   306,   730,   721,   527,   835,
     214,   679,   731,   276,   685,   758,   591,   821,   469,   261,
     296,   297,   298,   299,   300,   301,   302,   303,   671,   304,
     305,   687,     0,     0,   306,   691,     0,     0,     0,   280,
       0,   694,     0,   749,   184,   698,     0,     0,     0,   755,
     335,     0,   285,   705,   286,   706,     0,   335,     0,   370,
       0,   276,     0,   371,   184,     0,   377,   184,   184,   184,
     184,   184,   184,     0,     0,   184,     0,   290,   184,   184,
     184,   184,     0,     0,   383,   792,   783,   280,   120,   276,
       0,   276,     0,   184,   184,   184,   184,   276,     0,     0,
     285,   405,     0,     0,   408,   299,   300,   301,   302,   303,
       0,   304,   305,     0,   755,   280,   306,   280,     0,     0,
       0,     0,     0,   280,     0,   290,     0,   377,   285,   430,
     285,     0,   120,   377,     0,     0,   285,   812,     0,   757,
     377,     0,   760,     0,   762,   595,   764,   184,   597,     0,
     599,     0,   184,   290,     0,   290,     0,   773,   774,   304,
     305,   290,     0,     0,   306,   479,   841,     0,     0,   120,
       0,     0,     0,   812,     0,     0,   276,   554,   767,     0,
       0,     0,     0,   497,     0,   484,     0,   304,   305,   304,
     305,   276,   306,     0,   306,   304,   305,     0,   184,     0,
     306,   755,   280,     0,     0,   506,     0,   784,   510,   512,
     513,   515,   516,   518,     0,   285,     0,   280,     0,   535,
     536,   538,   540,     0,     0,     0,     0,   816,     0,   566,
     285,     0,   286,     0,   558,   559,   560,   561,     0,     0,
     290,     0,   287,   288,   184,     0,     0,     0,     0,   829,
       0,   581,     0,   184,   583,   290,     0,   817,     0,   819,
       0,   184,     0,     0,   822,     0,     0,     0,     0,     0,
     184,     0,     0,     0,   304,   305,     0,     0,     0,   306,
     296,   297,   298,   299,   300,   301,   302,   303,   596,   304,
     305,     0,   683,   600,   306,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   844,   845,   846,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   184,     0,   853,     0,     0,     0,     0,     0,     0,
       0,   858,     0,   859,     0,     0,     0,     0,     0,   609,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     626,   627,   628,     0,   184,   631,   632,   633,     0,   635,
     636,   637,   638,   639,   640,     0,   184,     0,   184,   184,
       0,     0,   647,     0,   276,   650,     0,   651,   652,     0,
     657,   658,   659,   660,   661,   662,   663,     0,     0,     0,
       0,   276,     0,     0,   653,   184,     0,     0,     0,     0,
     280,     0,     0,     0,   674,     0,   676,   677,     0,     0,
       0,   672,     0,   285,     0,   286,     0,   280,     0,     0,
       0,     0,     0,     0,     0,   287,   288,     0,     0,     0,
     285,     0,   286,     0,     0,     0,     0,     0,   290,     3,
       8,     0,     0,     0,     0,    10,    11,     0,    12,    13,
      14,    15,    16,   184,     0,   290,     0,     0,     0,     0,
       0,     0,   702,    20,   297,   298,   299,   300,   301,   302,
     303,    22,   304,   305,     0,    23,     0,   306,     0,     0,
       0,    26,     0,     0,    28,   301,   302,   303,    29,   304,
     305,    30,   362,     0,   306,   722,     0,     0,     0,     0,
       0,     0,   184,     0,     0,     0,   184,   727,     0,   729,
       0,    35,    36,    37,    38,    39,    40,     0,   738,     0,
       0,     0,     0,    41,     0,    43,     0,     0,     0,    45,
       0,     0,    46,    47,     0,     0,   740,    48,     0,     0,
      49,     0,    50,    51,     0,     0,     0,     0,     0,     0,
       0,     0,    56,    57,     0,     0,    58,     0,     0,     0,
      60,    61,     0,     0,     0,     0,     0,     0,   779,     0,
      64,     0,    65,    66,    67,    68,     0,    69,     0,    71,
       0,     0,     0,     0,     0,     0,   789,     0,     0,     0,
       0,     0,    74,     0,   653,    75,    76,     0,    77,    78,
       0,     0,    79,     0,     0,     0,    82,     0,     3,     8,
      83,    84,   252,     0,    10,    11,     0,    12,    13,    14,
      15,    16,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    20,     0,     0,     0,     0,     0,     0,     0,
      22,     0,     0,   818,    23,     0,     0,   820,     0,     0,
      26,     0,     0,    28,     0,     0,     0,    29,     0,     0,
      30,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,    36,    37,    38,    39,    40,     0,     0,     0,     0,
       0,     0,    41,     0,    43,     0,     0,     0,    45,     0,
       0,    46,    47,     0,     0,     0,    48,     0,     0,    49,
       0,    50,    51,     0,     0,     0,     0,     0,     0,     0,
       0,    56,    57,     0,     0,    58,     0,     0,     0,    60,
      61,     0,     0,     0,     0,     0,     0,     0,     0,    64,
       0,    65,    66,    67,    68,     0,    69,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    74,     0,     0,    75,    76,     0,    77,    78,     0,
       0,    79,     0,     0,     0,    82,     0,   -12,   -12,    83,
      84,   252,   -12,   -12,   -12,     0,   -12,   -12,   -12,   -12,
     -12,   -12,   -12,   -12,     0,     0,     0,     0,     0,     0,
       0,   -12,     0,     0,   -12,     0,     0,     0,     0,   -12,
       0,     0,     0,   -12,   -12,   -12,     0,     0,   -12,   -12,
     -12,     0,   -12,     0,     0,     0,   -12,     0,     0,   -12,
       0,     0,     0,     0,     0,     0,   -12,     0,   -12,     0,
     -12,     0,   -12,   -12,   -12,     0,   -12,     0,     0,   -12,
     -12,   -12,   -12,   -12,   -12,     0,     0,     0,     0,     0,
       0,   -12,   -12,   -12,     0,   -12,     0,   -12,     0,     0,
     -12,   -12,     0,     0,     0,   -12,     0,     0,   -12,     0,
     -12,   -12,     0,   -12,   -12,   -12,     0,     0,     0,   -12,
     -12,   -12,     0,     0,   -12,     0,     0,   -12,   -12,   -12,
       0,     0,     0,   -12,   -12,     0,     0,   -12,   -12,     0,
     -12,   -12,   -12,   -12,     0,   -12,   -12,   -12,     0,     0,
     -12,     0,     0,     0,   -12,     0,     0,     0,     0,     0,
     -12,     0,     0,   -12,   -12,     0,   -12,   -12,     0,     0,
     -12,   -12,   -12,     0,   -12,   -13,   -13,     0,   -12,   -12,
     -13,   -13,   -13,     0,   -13,   -13,   -13,   -13,   -13,   -13,
     -13,   -13,     0,     0,     0,     0,     0,     0,     0,   -13,
       0,     0,   -13,     0,     0,     0,     0,   -13,     0,     0,
       0,   -13,   -13,   -13,     0,     0,   -13,   -13,   -13,     0,
     -13,     0,     0,     0,   -13,     0,     0,   -13,     0,     0,
       0,     0,     0,     0,   -13,     0,   -13,     0,   -13,     0,
     -13,   -13,   -13,     0,   -13,     0,     0,   -13,   -13,   -13,
     -13,   -13,   -13,     0,     0,     0,     0,     0,     0,   -13,
     -13,   -13,     0,   -13,     0,   -13,     0,     0,   -13,   -13,
       0,     0,     0,   -13,     0,     0,   -13,     0,   -13,   -13,
       0,   -13,   -13,   -13,     0,     0,     0,   -13,   -13,   -13,
       0,     0,   -13,     0,     0,   -13,   -13,   -13,     0,     0,
       0,   -13,   -13,     0,     0,   -13,   -13,     0,   -13,   -13,
     -13,   -13,     0,   -13,   -13,   -13,     0,     0,   -13,     0,
       0,     0,   -13,     0,     0,     0,     0,     0,   -13,     0,
       0,   -13,   -13,     0,   -13,   -13,     0,     0,   -13,   -13,
     -13,     0,   -13,     3,     8,     0,   -13,   -13,     0,    10,
      11,     0,    12,    13,    14,    15,    16,     0,     0,     0,
     142,     0,     0,   143,     0,   643,     0,    20,   145,   146,
       0,   147,     0,     0,     0,    22,     0,     0,     0,    23,
       0,     0,     0,     0,     0,    26,     0,     0,    28,     0,
     149,     0,    29,   150,     0,   393,   152,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   153,     0,
       0,     0,     0,     0,   154,    35,    36,    37,    38,   394,
      40,     0,   156,     0,     0,   157,   158,   206,     0,   207,
       0,   161,     0,    45,     0,     0,    46,    47,     0,   162,
       0,   208,     0,     0,    49,     0,    50,   395,     0,     0,
       0,     0,   165,   166,   167,     0,    56,   209,     0,     0,
     396,   170,   171,     0,   397,    61,     0,     0,     0,     0,
       0,     0,   173,   174,    64,   175,    65,    66,    67,    68,
     176,    69,     0,   210,   178,   179,     0,     0,   180,   181,
       0,     0,     0,     0,     0,     0,    74,     0,     0,    75,
      76,     0,    77,    78,     0,     0,   398,     0,     0,     0,
      82,  -324,     3,     8,    83,    84,     0,     9,    10,    11,
       0,    12,    13,    14,    15,    16,    17,    18,    19,     0,
       0,     0,     0,     0,     0,     0,    20,     0,     0,    21,
       0,     0,     0,     0,    22,     0,     0,     0,    23,     0,
      24,     0,     0,    25,    26,    27,     0,    28,     0,     0,
       0,    29,     0,     0,    30,     0,     0,     0,     0,     0,
       0,    31,     0,     0,     0,     0,     0,     0,    32,    33,
       0,    34,     0,     0,    35,    36,    37,    38,    39,    40,
       0,     0,     0,     0,     0,     0,    41,    42,    43,     0,
      44,     0,    45,     0,     0,    46,    47,     0,     0,     0,
      48,     0,     0,    49,     0,    50,    51,     0,    52,    53,
      54,     0,     0,     0,    55,    56,    57,     0,     0,    58,
       0,     0,    59,    60,    61,     0,     0,     0,    62,    63,
       0,     0,     0,    64,     0,    65,    66,    67,    68,     0,
      69,    70,    71,     0,     0,    72,     0,     0,     0,    73,
       0,     0,     0,     0,     0,    74,     0,     0,    75,    76,
       0,    77,    78,     0,     0,    79,    80,    81,     0,    82,
       3,     8,     0,    83,    84,     0,    10,    11,     0,    12,
      13,    14,    15,    16,     0,     0,     0,   142,     0,     0,
     143,     0,     0,     0,    20,   145,   146,     0,   147,     0,
       0,     0,    22,     0,     0,     0,    23,     0,     0,     0,
       0,     0,    26,     0,     0,    28,     0,   149,     0,    29,
     150,     0,   393,   152,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   154,    35,    36,    37,    38,   394,    40,     0,   156,
       0,     0,   157,   158,   206,     0,   207,     0,     0,     0,
      45,     0,     0,    46,    47,     0,   162,     0,   208,     0,
       0,    49,     0,    50,   395,     0,     0,     0,     0,   165,
     166,   167,     0,    56,   209,     0,     0,   396,   170,   171,
       0,   397,    61,     0,     0,     0,     0,     0,     0,   173,
     174,    64,   175,    65,    66,    67,    68,   176,    69,     0,
     210,   178,   179,     0,     0,   180,   181,     0,     0,     0,
       0,     0,     0,    74,     0,     0,    75,    76,     0,    77,
      78,     0,     0,   398,     0,     0,     0,    82,     3,     8,
       0,    83,    84,     0,    10,    11,     0,    12,    13,    14,
      15,    16,    17,    18,    19,     0,     0,     0,     0,     0,
       0,     0,    20,     0,     0,    21,     0,     0,     0,     0,
      22,     0,     0,     0,    23,     0,    24,     0,     0,     0,
      26,    27,     0,    28,     0,     0,     0,    29,     0,     0,
      30,     0,     0,     0,     0,     0,     0,    31,     0,     0,
       0,     0,     0,     0,    32,     0,     0,    34,     0,     0,
      35,    36,    37,    38,    39,    40,     0,     0,     0,     0,
       0,     0,    41,    42,    43,     0,     0,     0,    45,     0,
       0,    46,    47,     0,     0,     0,    48,     0,     0,    49,
       0,    50,    51,     0,    52,    53,    54,     0,     0,     0,
      55,    56,    57,     0,     0,    58,     0,     0,    59,    60,
      61,     0,     0,     0,    62,    63,     0,     0,     0,    64,
       0,    65,    66,    67,    68,     0,    69,    70,    71,     0,
       0,    72,     0,     0,     0,    73,     0,     0,     0,     0,
       0,    74,     0,     0,    75,    76,     0,    77,    78,     0,
       0,    79,    80,   -77,     0,    82,     3,     8,     0,    83,
      84,     0,    10,    11,     0,    12,    13,    14,    15,    16,
      17,    18,    19,     0,     0,     0,     0,     0,     0,     0,
      20,     0,     0,    21,     0,     0,     0,     0,    22,     0,
       0,     0,    23,     0,    24,     0,     0,     0,    26,    27,
       0,    28,     0,     0,     0,    29,     0,     0,    30,     0,
       0,     0,     0,     0,     0,    31,     0,     0,     0,     0,
       0,     0,    32,     0,     0,    34,     0,     0,    35,    36,
      37,    38,    39,    40,     0,     0,     0,     0,     0,     0,
      41,    42,    43,     0,     0,     0,    45,     0,     0,    46,
      47,     0,     0,     0,    48,     0,     0,    49,     0,    50,
      51,     0,    52,    53,    54,     0,     0,     0,    55,    56,
      57,     0,     0,    58,     0,     0,    59,    60,    61,     0,
       0,     0,    62,    63,     0,     0,     0,    64,     0,    65,
      66,    67,    68,     0,    69,    70,    71,     0,     0,    72,
       0,     0,     0,    73,     0,     0,     0,     0,     0,    74,
       0,     0,    75,    76,     0,    77,    78,     0,     0,    79,
      80,   -76,     0,    82,     3,     8,     0,    83,    84,     0,
      10,    11,     0,    12,    13,    14,    15,    16,    17,    18,
      19,     0,     0,     0,     0,     0,     0,     0,    20,     0,
       0,    21,     0,     0,     0,     0,    22,     0,     0,     0,
      23,     0,    24,     0,     0,     0,    26,    27,     0,    28,
       0,     0,     0,    29,     0,     0,    30,     0,     0,     0,
       0,     0,     0,    31,     0,     0,     0,     0,     0,     0,
      32,     0,     0,    34,     0,     0,    35,    36,    37,    38,
      39,    40,     0,     0,     0,     0,     0,     0,    41,    42,
      43,     0,     0,     0,    45,     0,     0,    46,    47,     0,
       0,     0,    48,     0,     0,    49,     0,    50,    51,     0,
      52,    53,    54,     0,     0,     0,    55,    56,    57,     0,
       0,    58,     0,     0,    59,    60,    61,     0,     0,     0,
      62,    63,     0,     0,     0,    64,     0,    65,    66,    67,
      68,     0,    69,    70,    71,     0,     0,    72,     0,     0,
       0,    73,     0,     0,     0,     0,     0,    74,     0,     0,
      75,    76,     0,    77,    78,     0,     0,    79,    80,     0,
       0,    82,     3,     8,     0,    83,    84,     0,    10,    11,
       0,    12,    13,    14,    15,    16,    17,    18,    19,     0,
       0,     0,     0,     0,     0,     0,    20,     0,     0,    21,
       0,     0,     0,     0,    22,     0,     0,     0,    23,     0,
      24,     0,     0,     0,    26,    27,     0,    28,     0,     0,
       0,    29,     0,     0,    30,     0,     0,     0,     0,     0,
       0,    31,     0,     0,     0,     0,     0,     0,    32,     0,
       0,    34,     0,     0,    35,    36,    37,    38,    39,    40,
       0,     0,     0,     0,     0,     0,    41,    42,    43,     0,
       0,     0,    45,     0,     0,    46,    47,     0,     0,     0,
      48,     0,     0,    49,     0,    50,    51,     0,    52,    53,
      54,     0,     0,     0,    55,    56,    57,     0,     0,    58,
       0,     0,    59,    60,    61,     0,     0,     0,    62,    63,
       0,     0,     0,    64,     0,    65,    66,    67,    68,     0,
      69,    70,    71,     0,     0,    72,     0,     0,     0,    73,
       0,     0,     0,     0,     0,    74,     0,     0,    75,    76,
       0,    77,    78,     0,     0,    79,    80,     0,     0,   572,
       3,     8,     0,    83,    84,     0,    10,    11,     0,    12,
      13,    14,    15,    16,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    20,     0,     0,     0,     0,     0,
       0,     0,    22,     0,     0,     0,    23,     0,     0,     0,
       0,     0,    26,     0,     0,    28,     0,     0,     0,    29,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,    36,    37,    38,    39,    40,     0,     0,
       0,     0,     0,     0,    41,     0,    43,     0,     0,     0,
      45,     0,     0,    46,    47,     0,     0,     0,    48,     0,
       0,    49,     0,    50,    51,     0,     0,     0,     0,     0,
       0,     0,     0,    56,    57,     0,     0,    58,     0,     0,
       0,    60,    61,     0,     0,     0,     0,     0,     0,     0,
       0,    64,     0,    65,    66,    67,    68,     0,    69,     0,
      71,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    74,     0,     0,    75,    76,     0,    77,
      78,     0,     0,    79,     0,     0,   220,    82,     3,     8,
       0,    83,    84,     0,    10,    11,     0,    12,    13,    14,
      15,    16,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    20,     0,     0,     0,     0,     0,     0,     0,
      22,     0,     0,     0,    23,     0,     0,     0,     0,     0,
      26,     0,     0,    28,     0,     0,     0,    29,     0,     0,
      30,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,    36,    37,    38,    39,    40,     0,     0,     0,     0,
       0,     0,    41,     0,    43,     0,     0,     0,    45,     0,
       0,    46,    47,     0,     0,     0,    48,     0,     0,    49,
       0,    50,    51,     0,     0,     0,     0,     0,     0,     0,
       0,    56,    57,     0,     0,    58,     0,     0,     0,    60,
      61,     0,     0,     0,     0,     0,     0,     0,     0,    64,
       0,    65,    66,    67,    68,     0,    69,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    74,     0,     0,    75,    76,     0,    77,    78,     0,
       0,    79,     0,     0,   228,    82,     3,     8,     0,    83,
      84,     0,    10,    11,     0,    12,    13,    14,    15,    16,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      20,     0,     0,     0,     0,     0,     0,     0,    22,     0,
       0,     0,    23,     0,     0,     0,     0,     0,    26,     0,
       0,    28,     0,     0,     0,    29,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,    36,
      37,    38,    39,    40,     0,     0,     0,     0,     0,     0,
      41,   324,    43,     0,     0,     0,    45,     0,     0,    46,
      47,     0,     0,     0,    48,     0,     0,    49,     0,    50,
      51,     0,     0,     0,     0,     0,     0,     0,     0,    56,
      57,     0,     0,    58,     0,     0,     0,    60,    61,     0,
       0,     0,     0,     0,     0,     0,     0,    64,     0,    65,
      66,    67,    68,     0,    69,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    74,
       0,     0,    75,    76,     0,    77,    78,     0,     0,    79,
       0,     0,     0,    82,     3,     8,     0,    83,    84,     0,
      10,    11,     0,    12,    13,    14,    15,    16,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    20,     0,
       0,     0,     0,     0,     0,     0,    22,     0,     0,     0,
      23,     0,     0,     0,     0,     0,    26,     0,     0,    28,
       0,     0,     0,    29,     0,     0,    30,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,    36,    37,    38,
      39,    40,     0,     0,     0,     0,     0,     0,    41,     0,
      43,     0,     0,     0,    45,     0,     0,    46,    47,     0,
       0,     0,    48,     0,     0,    49,     0,    50,    51,     0,
       0,     0,     0,     0,     0,     0,     0,    56,    57,     0,
       0,    58,     0,     0,     0,    60,    61,     0,     0,     0,
       0,     0,     0,     0,     0,    64,     0,    65,    66,    67,
      68,     0,    69,     0,    71,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    74,     0,     0,
      75,    76,     0,    77,    78,     0,     0,    79,     0,     0,
       0,    82,     3,     8,     0,    83,    84,     0,    10,    11,
       0,    12,    13,    14,    15,    16,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    20,     0,     0,     0,
       0,     0,     0,     0,    22,     0,     0,     0,    23,     0,
       0,     0,     0,     0,    26,     0,     0,    28,     0,     0,
       0,    29,     0,     0,    30,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,    36,    37,    38,    39,    40,
       0,     0,     0,     0,     0,     0,    41,     0,    43,     0,
       0,     0,    45,     0,     0,    46,    47,     0,     0,     0,
      48,     0,     0,    49,     0,    50,    51,     0,     0,     0,
       0,     0,     0,     0,     0,    56,    57,     0,     0,    58,
       0,     0,     0,    60,    61,     0,     0,     0,     0,     0,
       0,     0,     0,    64,     0,    65,    66,    67,    68,     0,
      69,     0,    71,     0,     0,     0,     0,     0,     0,     0,
       3,     8,     0,     0,     0,     0,    10,    11,     0,    12,
      13,    14,    15,    16,     0,    79,     0,   142,     0,    82,
     143,     0,   205,    83,    84,   145,   146,     0,   147,     0,
       0,     0,     0,     0,     0,     0,    23,   148,     0,     0,
       0,     0,    26,     0,     0,     0,     0,   149,     0,     0,
     150,     0,   151,   152,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   153,     0,     0,     0,     0,
       0,   154,     0,     0,     0,     0,   155,     0,     0,   156,
       0,     0,   157,   158,   206,     0,   207,     0,   161,     0,
       0,     0,     0,     0,     0,     0,   162,     0,   208,     0,
       0,     0,     0,     0,   164,     0,     0,     0,     0,   165,
     166,   167,     0,     0,   209,     0,     0,   169,   170,   171,
       0,   172,     0,     0,     0,     0,     0,     3,     8,   173,
     174,     0,   175,     0,     0,     0,     0,   176,     0,     0,
     210,   178,   179,     0,   142,   180,   181,   143,     0,   205,
       0,     0,   145,   146,     0,   147,    75,     0,     0,     0,
      78,     0,     0,   211,   148,     0,     0,   212,     0,     0,
       0,     0,     0,     0,   149,     0,     0,   150,     0,   151,
     152,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   153,     0,     0,     0,     0,     0,   154,     0,
       0,     0,     0,   155,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,     0,     0,     0,     0,
       0,     0,     0,   162,     0,   163,     0,     0,     0,     0,
       0,   164,     0,     0,     0,     0,   165,   166,   167,     0,
       0,   168,     0,     0,   169,   170,   171,     0,   172,     0,
       0,     0,     0,     0,     3,     8,   173,   174,     0,   175,
       0,     0,     0,     0,   176,     0,     0,   177,   178,   179,
       0,   142,   180,   181,   143,     0,   205,     0,     0,   145,
     146,     0,   147,     0,     0,     0,     0,     0,     0,     0,
     182,   148,  -196,     0,     0,     0,     0,     0,     0,     0,
       0,   149,     0,     0,   150,     0,   151,   152,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   153,
       0,     0,     0,     0,     0,   154,     0,     0,     0,     0,
     155,     0,     0,   156,     0,     0,   157,   158,   159,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,     0,
     162,     0,   163,     0,     0,     0,     0,     0,   164,     0,
       0,     0,     0,   165,   166,   167,     0,     0,   168,     0,
       0,   169,   170,   171,     0,   172,     0,     0,     0,     0,
       0,     3,     8,   173,   174,     0,   175,     0,     0,     0,
       0,   176,     0,     0,   177,   178,   179,     0,   142,   180,
     181,   143,     0,   205,     0,     0,   145,   146,     0,   147,
       0,     0,     0,     0,     0,     0,     0,   182,   148,   725,
       0,     0,     0,     0,     0,     0,     0,     0,   149,     0,
       0,   150,     0,   151,   152,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   153,     0,     0,     0,
       0,     0,   154,     0,     0,     0,     0,   155,     0,     0,
     156,     0,     0,   157,   158,   159,     0,   160,     0,   161,
       0,     0,     0,     0,     0,     0,     0,   162,     0,   163,
       0,     0,     0,     0,     0,   164,     0,     0,     0,     0,
     165,   166,   167,     0,     0,   168,     0,     0,   169,   170,
     171,     0,   172,     0,     0,     0,     0,     0,     3,     8,
     173,   174,     0,   175,     0,     0,     0,     0,   176,     0,
       0,   177,   178,   179,     0,   142,   180,   181,   143,     0,
     205,     0,     0,   145,   146,     0,   147,     0,     0,     0,
     509,     0,     0,     0,   182,   148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   149,     0,     0,   150,     0,
     151,   152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   153,     0,     0,     0,     0,     0,   154,
       0,     0,     0,     0,   155,     0,     0,   156,     0,     0,
     157,   158,   159,     0,   160,     0,   161,     0,     0,     0,
       0,     0,     0,     0,   162,     0,   163,     0,     0,     0,
       0,     0,   164,     0,     0,     0,     0,   165,   166,   167,
       0,     0,   168,     0,     0,   169,   170,   171,     0,   172,
       0,     0,     0,     0,     0,     3,     8,   173,   174,     0,
     175,     0,     0,     0,     0,   176,     0,     0,   177,   178,
     179,     0,   142,   180,   181,   143,     0,   205,     0,     0,
     145,   146,     0,   147,     0,     0,     0,   511,     0,     0,
       0,   182,   148,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   149,     0,     0,   150,     0,   151,   152,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     153,     0,     0,     0,     0,     0,   154,     0,     0,     0,
       0,   155,     0,     0,   156,     0,     0,   157,   158,   159,
       0,   160,     0,   161,     0,     0,     0,     0,     0,     0,
       0,   162,     0,   163,     0,     0,     0,     0,     0,   164,
       0,     0,     0,     0,   165,   166,   167,     0,     0,   168,
       0,     0,   169,   170,   171,     0,   172,     0,     0,     0,
       0,     0,     3,     8,   173,   174,     0,   175,     0,     0,
       0,     0,   176,     0,     0,   177,   178,   179,     0,   142,
     180,   181,   143,     0,   205,     0,     0,   145,   146,     0,
     147,     0,     0,     0,   514,     0,     0,     0,   182,   148,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   149,
       0,     0,   150,     0,   151,   152,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   153,     0,     0,
       0,     0,     0,   154,     0,     0,     0,     0,   155,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,     0,     0,     0,     0,     0,     0,     0,   162,     0,
     163,     0,     0,     0,     0,     0,   164,     0,     0,     0,
       0,   165,   166,   167,     0,     0,   168,     0,     0,   169,
     170,   171,     0,   172,     0,     0,     0,     0,     0,     3,
       8,   173,   174,     0,   175,     0,     0,     0,     0,   176,
       0,     0,   177,   178,   179,     0,   142,   180,   181,   143,
       0,   205,     0,     0,   145,   146,     0,   147,     0,     0,
       0,   517,     0,     0,     0,   182,   148,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   149,     0,     0,   150,
       0,   151,   152,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   153,     0,     0,     0,     0,     0,
     154,     0,     0,     0,     0,   155,     0,     0,   156,     0,
       0,   157,   158,   159,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,     0,   162,     0,   163,     0,     0,
       0,     0,     0,   164,     0,     0,     0,     0,   165,   166,
     167,     0,     0,   168,     0,     0,   169,   170,   171,     0,
     172,     0,     0,     0,     0,     0,     3,     8,   173,   174,
       0,   175,     0,     0,     0,     0,   176,     0,     0,   177,
     178,   179,     0,   142,   180,   181,   143,     0,   205,     0,
       0,   145,   146,     0,   147,     0,     0,     0,   526,     0,
       0,     0,   182,   148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   149,     0,     0,   150,     0,   151,   152,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   153,     0,     0,     0,     0,     0,   154,     0,     0,
       0,     0,   155,     0,     0,   156,     0,     0,   157,   158,
     159,     0,   160,     0,   161,     0,     0,     0,     0,     0,
       0,     0,   162,     0,   163,     0,     0,     0,     0,     0,
     164,     0,     0,     0,     0,   165,   166,   167,     0,     0,
     168,     0,     0,   169,   170,   171,     0,   172,     0,     0,
       0,     0,     0,     3,     8,   173,   174,     0,   175,     0,
       0,     0,     0,   176,     0,     0,   177,   178,   179,     0,
     142,   180,   181,   143,     0,   205,     0,     0,   145,   146,
       0,   147,     0,     0,     0,   534,     0,     0,     0,   182,
     148,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     149,     0,     0,   150,     0,   151,   152,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   153,     0,
       0,     0,     0,     0,   154,     0,     0,     0,     0,   155,
       0,     0,   156,     0,     0,   157,   158,   159,     0,   160,
       0,   161,     0,     0,     0,     0,     0,     0,     0,   162,
       0,   163,     0,     0,     0,     0,     0,   164,     0,     0,
       0,     0,   165,   166,   167,     0,     0,   168,     0,     0,
     169,   170,   171,     0,   172,     0,     0,     0,     0,     0,
       3,     8,   173,   174,     0,   175,     0,     0,     0,     0,
     176,     0,     0,   177,   178,   179,     0,   142,   180,   181,
     143,     0,   205,     0,     0,   145,   146,     0,   147,     0,
       0,     0,   537,     0,     0,     0,   182,   148,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   149,     0,     0,
     150,     0,   151,   152,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   153,     0,     0,     0,     0,
       0,   154,     0,     0,     0,     0,   155,     0,     0,   156,
       0,     0,   157,   158,   159,     0,   160,     0,   161,     0,
       0,     0,     0,     0,     0,     0,   162,     0,   163,     0,
       0,     0,     0,     0,   164,     0,     0,     0,     0,   165,
     166,   167,     0,     0,   168,     0,     0,   169,   170,   171,
       0,   172,     0,     0,     0,     0,     0,     3,     8,   173,
     174,     0,   175,     0,     0,     0,     0,   176,     0,     0,
     177,   178,   179,     0,   142,   180,   181,   143,     0,   144,
       0,     0,   145,   146,     0,   147,     0,     0,     0,   539,
       0,     0,     0,   182,   148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   149,     0,     0,   150,     0,   151,
     152,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   153,     0,     0,     0,     0,     0,   154,     0,
       0,     0,     0,   155,     0,     0,   156,     0,     0,   157,
     158,   159,     0,   160,     0,   161,     0,     0,     0,     0,
       0,     0,     0,   162,     0,   163,     0,     0,     0,     0,
       0,   164,     0,     0,     0,     0,   165,   166,   167,     0,
       0,   168,     0,     0,   169,   170,   171,     0,   172,     0,
       0,     0,     0,     0,     3,     8,   173,   174,     0,   175,
       0,     0,     0,     0,   176,     0,     0,   177,   178,   179,
       0,   142,   180,   181,   143,     0,   205,     0,     0,   145,
     146,     0,   147,     0,     0,     0,     0,     0,     0,     0,
     182,   148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   149,     0,     0,   150,     0,   151,   152,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   153,
       0,     0,     0,     0,     0,   154,     0,     0,     0,     0,
     155,     0,     0,   156,     0,     0,   157,   158,   159,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,     0,
     162,     0,   163,     0,     0,     0,     0,     0,   164,     0,
       0,     0,     0,   165,   166,   167,     0,     0,   168,     0,
       0,   169,   170,   171,     0,   172,     0,     0,     0,     0,
       0,     3,     8,   173,   174,     0,   175,     0,     0,     0,
       0,   176,     0,     0,   177,   178,   179,     0,   142,   180,
     181,   143,     0,   428,     0,     0,   145,   146,     0,   147,
       0,     0,     0,     0,     0,     0,     0,   182,   148,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   149,     0,
       0,   150,     0,   151,   152,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   153,     0,     0,     0,
       0,     0,   154,     0,     0,     0,     0,   155,     0,     0,
     156,     0,     0,   157,   158,   159,     0,   160,     0,   161,
       0,     0,     0,     0,     0,     0,     0,   162,     0,   163,
       0,     0,     0,     0,     0,   164,     0,     0,     0,     0,
     165,   166,   167,     0,     0,   168,     0,     0,   169,   170,
     171,     0,   172,     0,     0,     0,     0,     0,     3,     8,
     173,   174,     0,   175,     0,     0,     0,     0,   176,     0,
       0,   177,   178,   179,     0,   142,   180,   181,   143,     0,
     483,     0,     0,   145,   146,     0,   147,     0,     0,     0,
       0,     0,     0,     0,   182,   148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   149,     0,     0,   150,     0,
     151,   152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   153,     0,     0,     0,     0,     0,   154,
       0,     0,     0,     0,   155,     0,     0,   156,     0,     0,
     157,   158,   159,     0,   160,     0,   161,     0,     0,     0,
       0,     0,     0,     0,   162,     0,   163,     0,     0,     0,
       0,     0,   164,     0,     0,     0,     0,   165,   166,   167,
       0,     0,   168,     0,     0,   169,   170,   171,     0,   172,
       0,     0,     0,     0,     0,     3,     8,   173,   174,     0,
     175,     0,     0,     0,     0,   176,     0,     0,   177,   178,
     179,     0,   142,   180,   181,   143,     0,   643,     0,     0,
     145,   146,     0,   147,     0,     0,     0,     0,     0,     0,
       0,   182,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   149,     0,     0,   150,     0,   151,   152,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     153,     0,     0,     0,     0,     0,   154,     0,     0,     0,
       0,   155,     0,     0,   156,     0,     0,   157,   158,   159,
       0,   160,     0,   161,     0,     0,     0,     0,     0,     0,
       0,   162,     0,   163,     0,     0,     0,     0,     0,   164,
       0,     0,     0,     0,   165,   166,   167,     0,     0,   168,
       0,     0,   169,   170,   171,     0,   172,     0,     0,     0,
       0,     0,     3,     8,   173,   174,     0,   175,     0,     0,
       0,     0,   176,     0,     0,   177,   178,   179,     0,   142,
     180,   181,   143,     0,     0,     0,     0,   145,   146,     0,
     147,     0,     0,     0,     0,     0,     0,     0,   182,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   149,
       0,     0,   150,     0,   151,   152,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   153,     0,     0,
       0,     0,     0,   154,     0,     0,     0,     0,   155,     0,
       0,   156,     0,     0,   157,   158,   159,     0,   160,     0,
     161,     0,   272,     0,     0,     0,     0,     0,   162,     0,
     163,     0,     0,     0,     0,     0,   164,     0,     0,     0,
       0,   165,   166,   167,     0,     0,   168,   273,     0,   169,
     170,   171,     0,   172,   274,     0,     0,     0,     0,     0,
       0,   173,   174,     0,   175,   275,     0,   276,     0,   176,
       0,   277,   177,   178,   179,     0,     0,   180,   181,     0,
       0,     0,     0,     0,   278,     0,     0,     0,     0,     0,
       0,     0,   279,   280,     0,   182,     0,     0,   281,     0,
     282,     0,   283,     0,     0,   284,   285,     0,   286,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   287,   288,
       0,     0,     0,     0,     0,     0,     0,     0,   289,     0,
       0,   290,     0,     0,     0,     0,     0,     0,     0,   272,
       0,     0,     0,     0,     0,     0,     0,     0,   276,     0,
       0,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   273,   304,   305,     0,     0,     0,
     306,   274,     0,     0,   280,     0,     0,     0,     0,     0,
       0,     0,   275,     0,   276,     0,     0,   285,   277,   286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   287,
     288,   278,     0,     0,     0,     0,     0,     0,     0,   279,
     280,     0,   290,     0,     0,   281,     0,   282,     0,   283,
       0,     0,   284,   285,     0,   286,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   287,   288,   296,   297,   298,
     299,   300,   301,   302,   303,   289,   304,   305,   290,     0,
       0,   306,     0,     0,     0,     0,   272,     0,     0,     0,
       0,     0,     0,     0,     0,   276,     0,     0,   291,   292,
     602,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   273,   304,   305,     0,     0,     0,   306,   274,     0,
       0,   280,     0,     0,     0,     0,     0,     0,     0,   275,
       0,   276,     0,     0,   285,   277,   286,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   287,   288,   278,     0,
       0,     0,     0,     0,     0,     0,   279,   280,     0,   290,
       0,     0,   281,     0,   282,     0,   283,     0,     0,   284,
     285,     0,   286,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   287,   288,     0,     0,   298,   299,   300,   301,
     302,   303,   289,   304,   305,   290,     0,     0,   306,     0,
       0,     0,     0,   272,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   291,   292,     0,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   273,   304,
     305,     0,     0,     0,   306,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,     0,   276,     0,
       0,     0,   277,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   278,     0,     0,     0,     0,
       0,     0,     0,   279,   280,     0,     0,     0,     0,   281,
       0,   282,     0,   283,     0,     0,   284,   285,     0,   286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   287,
     288,     0,     0,     0,     0,     0,     0,     0,     0,   289,
       0,     0,   290,   272,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   291,   292,     0,   294,   295,   411,   297,   298,
     299,   300,   301,   302,   303,   274,   304,   305,     0,     0,
       0,   306,     0,     0,     0,     0,   275,     0,   276,     0,
       0,     0,   277,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   278,     0,     0,     0,     0,
       0,     0,     0,     0,   280,     0,     0,     0,     0,   281,
       0,   282,     0,   283,     0,     0,     0,   285,     0,   286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   287,
     288,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   290,   272,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   292,     0,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   274,   304,   305,     0,     0,
       0,   306,     0,     0,     0,     0,   275,     0,   276,     0,
       0,     0,   277,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   278,     0,     0,     0,     0,
       0,     0,     0,     0,   280,     0,     0,     0,     0,   281,
       0,   282,     0,   283,     0,     0,     0,   285,     0,   286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   287,
     288,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   290,   272,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   292,     0,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   274,   304,   305,     0,     0,
       0,   306,     0,     0,     0,     0,   275,     0,   276,     0,
       0,     0,   277,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   278,     0,     0,     0,     0,
       0,     0,     0,     0,   280,     0,     0,     0,     0,   281,
       0,   282,     0,   283,     0,     0,     0,   285,     0,   286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   287,
     288,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   290,   272,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   292,     0,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   274,   304,   305,     0,     0,
       0,   306,     0,     0,     0,     0,   275,     0,   276,     0,
       0,     0,   277,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   278,     0,     0,     0,     0,
       0,     0,     0,     0,   280,     0,     0,     0,     0,   281,
       0,   282,     0,   283,     0,     0,     0,   285,     0,   286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   287,
     288,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   290,   272,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   292,     0,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   274,   304,   305,     0,     0,
       0,   306,     0,     0,     0,     0,   275,     0,   276,     0,
       0,     0,   277,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   278,     0,     0,     0,     0,
       0,     0,     0,     0,   280,     0,     0,     0,     0,   281,
       0,   282,     0,   283,     0,     0,     0,   285,     0,   286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   287,
     288,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   290,   272,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   292,     0,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   274,   304,   305,     0,     0,
       0,   306,     0,     0,     0,     0,   275,     0,   276,     0,
       0,     0,   277,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   278,     0,     0,     0,     0,
       0,     0,     0,     0,   280,     0,     0,     0,     0,   281,
       0,   282,     0,   283,     0,     0,     0,   285,     0,   286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   287,
     288,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   290,   272,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   274,   304,   305,     0,     0,
       0,   306,     0,     0,     0,     0,   275,     0,   276,     0,
       0,     0,   277,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   278,     0,     0,     0,     0,
       0,     0,     0,     0,   280,     0,     0,     0,     0,   281,
       0,   282,     0,     0,     0,     0,     0,   285,     0,   286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   287,
     288,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   290,     0,     0,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,     0,   276,     0,
       0,     0,   277,     0,     0,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   278,   304,   305,     0,     0,
       0,   306,     0,     0,   280,     0,     0,     0,     0,   281,
       0,   282,     0,     0,     0,     0,     0,   285,     0,   286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   287,
     288,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   290,     0,     0,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,     0,   276,     0,
       0,     0,     0,     0,     0,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   278,   304,   305,     0,     0,
       0,   306,     0,     0,   280,     0,     0,     0,     0,   281,
       0,     0,     0,     0,     0,     0,     0,   285,     0,   286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   287,
     288,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   290,     0,     0,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,     0,   276,     0,
       0,     0,     0,     0,     0,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   278,   304,   305,     0,     0,
       0,   306,     0,     0,   280,     0,     0,     0,     0,   281,
       0,     0,     0,     0,     0,     0,     0,   285,     0,   286,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   287,
     288,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   290,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,     0,   276,     0,
       0,     0,     0,     0,     0,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   278,   304,   305,     0,     0,
       0,   306,     0,     0,   280,     0,     0,     0,     0,   275,
       0,   276,     0,     0,     0,     0,     0,   285,     0,   286,
       0,     0,     0,     0,     0,     0,     0,     0,   278,   287,
     288,     0,     0,     0,     0,     0,     0,   280,     0,     0,
       0,     0,   290,     0,     0,     0,     0,     0,     0,     0,
     285,     0,   286,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   287,   288,     0,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   290,   304,   305,     0,     0,
       0,   306,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,     0,   304,
     305,     0,     0,     0,   306
  };

  const short
  Parser::yycheck_[] =
  {
       1,    19,   127,    49,    19,   140,     3,   267,   423,   269,
     543,   616,     7,     7,     7,   390,     7,     7,     7,     7,
      43,    63,    69,   148,     7,    68,    67,   619,    15,     3,
      45,     3,    33,    72,    67,    50,    15,   151,    40,   290,
      95,    42,     3,     4,     5,   151,     3,   755,    91,   169,
      73,   171,    93,   304,     0,   153,   170,   225,   318,    74,
      93,    76,    77,    43,   170,   106,   154,   108,    83,    84,
     109,   110,   111,   106,   172,   108,   244,   118,   119,   155,
     167,    55,   170,   688,   689,   151,    80,   222,   680,    61,
     131,     7,   154,    73,   686,    34,   172,    67,   131,   169,
      61,   171,   163,   169,    17,    18,    45,   242,   170,    25,
     170,   486,   487,   169,    27,   156,   157,   158,   159,   160,
     161,   162,   163,    93,   165,   166,   173,   169,   154,   170,
     131,   133,   165,   166,   842,   154,   106,   170,   108,    40,
     673,   266,    55,   144,   170,   154,   153,   169,   171,    62,
     154,   170,   168,    58,    59,   596,   172,    70,   167,   600,
     170,   131,   169,    64,   170,    66,    79,    68,   609,    82,
     775,   306,   167,   169,   169,   162,   169,   167,   169,   176,
     169,   169,   197,   162,   167,   170,   154,    14,    15,   190,
      15,   161,   162,   163,   799,   165,   166,    58,    59,   170,
     170,   114,   170,    64,   170,   172,   173,   822,   121,   169,
     585,   586,     3,     4,     3,     4,   129,   130,   170,   132,
     170,   134,   135,   136,   137,   138,   139,   140,   761,   844,
     845,   169,   133,   766,   170,   170,   170,   770,   170,   170,
     170,   170,   170,   378,   859,   170,   170,   170,   170,   170,
     170,   252,   170,   170,   156,   170,     3,   272,   273,   274,
     275,   169,   277,   278,   279,   259,   281,   282,   283,   284,
     169,   286,   287,   288,   289,   276,   291,   292,   693,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   290,
     170,   204,   176,   170,   170,   170,    56,   151,   211,   212,
      64,   170,   215,   304,   169,   169,   219,    36,    11,   222,
     169,   224,   225,   226,   227,   848,   173,    62,   168,   172,
     171,    67,   235,   236,   237,   238,   239,   171,   163,   242,
     172,   244,     7,   169,   709,   155,   169,   712,   713,   171,
      67,   342,   171,   171,   151,    71,    15,    93,   171,   171,
     171,   162,   171,   171,   355,   171,   171,   171,     9,     9,
     106,   167,   108,   153,   172,   170,    93,   153,    22,   171,
     371,   172,    26,   171,   171,   171,   751,   172,   171,   106,
     293,   108,   151,   171,   171,   131,   171,    41,   171,    43,
      36,   171,   305,   306,   171,   171,   411,   171,   171,   524,
     313,   171,    42,    57,   131,   171,   171,    47,   176,   151,
     545,   151,   151,   414,   170,    69,   541,    71,   793,   165,
     166,   173,   797,   171,   170,   169,   151,   170,     3,   170,
       6,   169,   159,   160,   161,   162,   163,   170,   165,   166,
     171,   155,   151,   170,   172,   153,   169,   572,   823,   171,
     363,    67,   171,   171,   169,   172,   172,   170,    71,   171,
     170,   167,   167,   170,   163,   378,   726,   151,   603,   151,
     172,   171,   151,   151,   171,   610,   169,    93,    51,    51,
      15,    67,   483,   484,   124,   398,   172,   127,   168,   170,
     106,     3,   108,    51,    51,   171,   173,   169,   171,   170,
     154,   141,   156,   416,   170,   159,   160,    93,   148,   171,
     423,   165,   171,   167,   168,   131,   169,   169,    67,   173,
     106,   175,   108,   177,   178,   170,   180,   181,   169,   171,
     167,   170,   118,   119,   549,   581,   171,   170,    24,   171,
     171,   151,    67,    42,    93,   131,   170,   153,    47,   165,
     166,   171,   206,   207,   170,   209,   210,   106,   198,   108,
     171,   168,   202,   168,    51,     7,   169,   171,    93,   482,
     171,    67,   485,   159,   160,   161,   162,   163,   170,   165,
     166,   106,   131,   223,   170,   498,   169,   602,   169,    51,
     170,    15,   171,   171,   171,   596,    15,    93,   153,   600,
     240,   168,   171,   243,    49,   171,   131,   170,   609,   173,
     106,    15,   108,     7,     7,   171,   165,   166,   599,   818,
     126,   170,   118,   119,   625,   124,   266,   572,   268,   646,
     270,   544,   545,   682,   547,   131,   746,   642,   391,   235,
     165,   166,   141,   644,   733,   170,   649,   625,   649,   814,
      47,   564,   653,    67,   581,   693,   417,   787,   307,   572,
     156,   157,   158,   159,   160,   161,   162,   163,   549,   165,
     166,   584,    -1,    -1,   170,   588,    -1,    -1,    -1,    93,
      -1,   594,    -1,   684,   324,   598,    -1,    -1,    -1,   690,
     603,    -1,   106,   606,   108,   608,    -1,   610,    -1,   198,
      -1,    67,    -1,   202,   344,    -1,   619,   347,   348,   349,
     350,   351,   352,    -1,    -1,   355,    -1,   131,   358,   359,
     360,   361,    -1,    -1,   223,   743,   727,    93,   743,    67,
      -1,    67,    -1,   373,   374,   375,   376,    67,    -1,    -1,
     106,   240,    -1,    -1,   243,   159,   160,   161,   162,   163,
      -1,   165,   166,    -1,   755,    93,   170,    93,    -1,    -1,
      -1,    -1,    -1,    93,    -1,   131,    -1,   680,   106,   268,
     106,    -1,   787,   686,    -1,    -1,   106,   778,    -1,   692,
     693,    -1,   695,    -1,   697,   425,   699,   427,   428,    -1,
     430,    -1,   432,   131,    -1,   131,    -1,   710,   711,   165,
     166,   131,    -1,    -1,   170,   319,   824,    -1,    -1,   824,
      -1,    -1,    -1,   814,    -1,    -1,    67,   818,   702,    -1,
      -1,    -1,    -1,   337,    -1,   324,    -1,   165,   166,   165,
     166,    67,   170,    -1,   170,   165,   166,    -1,   478,    -1,
     170,   842,    93,    -1,    -1,   344,    -1,   731,   347,   348,
     349,   350,   351,   352,    -1,   106,    -1,    93,    -1,   358,
     359,   360,   361,    -1,    -1,    -1,    -1,   780,    -1,   383,
     106,    -1,   108,    -1,   373,   374,   375,   376,    -1,    -1,
     131,    -1,   118,   119,   524,    -1,    -1,    -1,    -1,   802,
      -1,   405,    -1,   533,   408,   131,    -1,   781,    -1,   783,
      -1,   541,    -1,    -1,   788,    -1,    -1,    -1,    -1,    -1,
     550,    -1,    -1,    -1,   165,   166,    -1,    -1,    -1,   170,
     156,   157,   158,   159,   160,   161,   162,   163,   427,   165,
     166,    -1,   572,   432,   170,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   830,   831,   832,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   601,    -1,   847,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   855,    -1,   857,    -1,    -1,    -1,    -1,    -1,   478,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     504,   505,   506,    -1,   634,   509,   510,   511,    -1,   513,
     514,   515,   516,   517,   518,    -1,   646,    -1,   648,   649,
      -1,    -1,   526,    -1,    67,   529,    -1,   531,   532,    -1,
     534,   535,   536,   537,   538,   539,   540,    -1,    -1,    -1,
      -1,    67,    -1,    -1,   533,   675,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,    -1,
      -1,   550,    -1,   106,    -1,   108,    -1,    93,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   118,   119,    -1,    -1,    -1,
     106,    -1,   108,    -1,    -1,    -1,    -1,    -1,   131,     3,
       4,    -1,    -1,    -1,    -1,     9,    10,    -1,    12,    13,
      14,    15,    16,   733,    -1,   131,    -1,    -1,    -1,    -1,
      -1,    -1,   601,    27,   157,   158,   159,   160,   161,   162,
     163,    35,   165,   166,    -1,    39,    -1,   170,    -1,    -1,
      -1,    45,    -1,    -1,    48,   161,   162,   163,    52,   165,
     166,    55,    56,    -1,   170,   634,    -1,    -1,    -1,    -1,
      -1,    -1,   782,    -1,    -1,    -1,   786,   646,    -1,   648,
      -1,    75,    76,    77,    78,    79,    80,    -1,   672,    -1,
      -1,    -1,    -1,    87,    -1,    89,    -1,    -1,    -1,    93,
      -1,    -1,    96,    97,    -1,    -1,   675,   101,    -1,    -1,
     104,    -1,   106,   107,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   116,   117,    -1,    -1,   120,    -1,    -1,    -1,
     124,   125,    -1,    -1,    -1,    -1,    -1,    -1,   722,    -1,
     134,    -1,   136,   137,   138,   139,    -1,   141,    -1,   143,
      -1,    -1,    -1,    -1,    -1,    -1,   740,    -1,    -1,    -1,
      -1,    -1,   156,    -1,   733,   159,   160,    -1,   162,   163,
      -1,    -1,   166,    -1,    -1,    -1,   170,    -1,     3,     4,
     174,   175,   176,    -1,     9,    10,    -1,    12,    13,    14,
      15,    16,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      35,    -1,    -1,   782,    39,    -1,    -1,   786,    -1,    -1,
      45,    -1,    -1,    48,    -1,    -1,    -1,    52,    -1,    -1,
      55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    77,    78,    79,    80,    -1,    -1,    -1,    -1,
      -1,    -1,    87,    -1,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    97,    -1,    -1,    -1,   101,    -1,    -1,   104,
      -1,   106,   107,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   116,   117,    -1,    -1,   120,    -1,    -1,    -1,   124,
     125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,
      -1,   136,   137,   138,   139,    -1,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   156,    -1,    -1,   159,   160,    -1,   162,   163,    -1,
      -1,   166,    -1,    -1,    -1,   170,    -1,     3,     4,   174,
     175,   176,     8,     9,    10,    -1,    12,    13,    14,    15,
      16,    17,    18,    19,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    27,    -1,    -1,    30,    -1,    -1,    -1,    -1,    35,
      -1,    -1,    -1,    39,    40,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    -1,    -1,    55,
      -1,    -1,    -1,    -1,    -1,    -1,    62,    -1,    64,    -1,
      66,    -1,    68,    69,    70,    -1,    72,    -1,    -1,    75,
      76,    77,    78,    79,    80,    -1,    -1,    -1,    -1,    -1,
      -1,    87,    88,    89,    -1,    91,    -1,    93,    -1,    -1,
      96,    97,    -1,    -1,    -1,   101,    -1,    -1,   104,    -1,
     106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,   115,
     116,   117,    -1,    -1,   120,    -1,    -1,   123,   124,   125,
      -1,    -1,    -1,   129,   130,    -1,    -1,   133,   134,    -1,
     136,   137,   138,   139,    -1,   141,   142,   143,    -1,    -1,
     146,    -1,    -1,    -1,   150,    -1,    -1,    -1,    -1,    -1,
     156,    -1,    -1,   159,   160,    -1,   162,   163,    -1,    -1,
     166,   167,   168,    -1,   170,     3,     4,    -1,   174,   175,
       8,     9,    10,    -1,    12,    13,    14,    15,    16,    17,
      18,    19,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    27,
      -1,    -1,    30,    -1,    -1,    -1,    -1,    35,    -1,    -1,
      -1,    39,    40,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    -1,    -1,    55,    -1,    -1,
      -1,    -1,    -1,    -1,    62,    -1,    64,    -1,    66,    -1,
      68,    69,    70,    -1,    72,    -1,    -1,    75,    76,    77,
      78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    87,
      88,    89,    -1,    91,    -1,    93,    -1,    -1,    96,    97,
      -1,    -1,    -1,   101,    -1,    -1,   104,    -1,   106,   107,
      -1,   109,   110,   111,    -1,    -1,    -1,   115,   116,   117,
      -1,    -1,   120,    -1,    -1,   123,   124,   125,    -1,    -1,
      -1,   129,   130,    -1,    -1,   133,   134,    -1,   136,   137,
     138,   139,    -1,   141,   142,   143,    -1,    -1,   146,    -1,
      -1,    -1,   150,    -1,    -1,    -1,    -1,    -1,   156,    -1,
      -1,   159,   160,    -1,   162,   163,    -1,    -1,   166,   167,
     168,    -1,   170,     3,     4,    -1,   174,   175,    -1,     9,
      10,    -1,    12,    13,    14,    15,    16,    -1,    -1,    -1,
      20,    -1,    -1,    23,    -1,    25,    -1,    27,    28,    29,
      -1,    31,    -1,    -1,    -1,    35,    -1,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,    -1,
      50,    -1,    52,    53,    -1,    55,    56,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,
      -1,    -1,    -1,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    -1,    -1,    85,    86,    87,    -1,    89,
      -1,    91,    -1,    93,    -1,    -1,    96,    97,    -1,    99,
      -1,   101,    -1,    -1,   104,    -1,   106,   107,    -1,    -1,
      -1,    -1,   112,   113,   114,    -1,   116,   117,    -1,    -1,
     120,   121,   122,    -1,   124,   125,    -1,    -1,    -1,    -1,
      -1,    -1,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,    -1,   143,   144,   145,    -1,    -1,   148,   149,
      -1,    -1,    -1,    -1,    -1,    -1,   156,    -1,    -1,   159,
     160,    -1,   162,   163,    -1,    -1,   166,    -1,    -1,    -1,
     170,   171,     3,     4,   174,   175,    -1,     8,     9,    10,
      -1,    12,    13,    14,    15,    16,    17,    18,    19,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    27,    -1,    -1,    30,
      -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,    39,    -1,
      41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    -1,    -1,    55,    -1,    -1,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      -1,    72,    -1,    -1,    75,    76,    77,    78,    79,    80,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    88,    89,    -1,
      91,    -1,    93,    -1,    -1,    96,    97,    -1,    -1,    -1,
     101,    -1,    -1,   104,    -1,   106,   107,    -1,   109,   110,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,   120,
      -1,    -1,   123,   124,   125,    -1,    -1,    -1,   129,   130,
      -1,    -1,    -1,   134,    -1,   136,   137,   138,   139,    -1,
     141,   142,   143,    -1,    -1,   146,    -1,    -1,    -1,   150,
      -1,    -1,    -1,    -1,    -1,   156,    -1,    -1,   159,   160,
      -1,   162,   163,    -1,    -1,   166,   167,   168,    -1,   170,
       3,     4,    -1,   174,   175,    -1,     9,    10,    -1,    12,
      13,    14,    15,    16,    -1,    -1,    -1,    20,    -1,    -1,
      23,    -1,    -1,    -1,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    45,    -1,    -1,    48,    -1,    50,    -1,    52,
      53,    -1,    55,    56,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      -1,    -1,    85,    86,    87,    -1,    89,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    -1,    99,    -1,   101,    -1,
      -1,   104,    -1,   106,   107,    -1,    -1,    -1,    -1,   112,
     113,   114,    -1,   116,   117,    -1,    -1,   120,   121,   122,
      -1,   124,   125,    -1,    -1,    -1,    -1,    -1,    -1,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,    -1,
     143,   144,   145,    -1,    -1,   148,   149,    -1,    -1,    -1,
      -1,    -1,    -1,   156,    -1,    -1,   159,   160,    -1,   162,
     163,    -1,    -1,   166,    -1,    -1,    -1,   170,     3,     4,
      -1,   174,   175,    -1,     9,    10,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    27,    -1,    -1,    30,    -1,    -1,    -1,    -1,
      35,    -1,    -1,    -1,    39,    -1,    41,    -1,    -1,    -1,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    -1,    -1,
      55,    -1,    -1,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    -1,    -1,    72,    -1,    -1,
      75,    76,    77,    78,    79,    80,    -1,    -1,    -1,    -1,
      -1,    -1,    87,    88,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    97,    -1,    -1,    -1,   101,    -1,    -1,   104,
      -1,   106,   107,    -1,   109,   110,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,    -1,   120,    -1,    -1,   123,   124,
     125,    -1,    -1,    -1,   129,   130,    -1,    -1,    -1,   134,
      -1,   136,   137,   138,   139,    -1,   141,   142,   143,    -1,
      -1,   146,    -1,    -1,    -1,   150,    -1,    -1,    -1,    -1,
      -1,   156,    -1,    -1,   159,   160,    -1,   162,   163,    -1,
      -1,   166,   167,   168,    -1,   170,     3,     4,    -1,   174,
     175,    -1,     9,    10,    -1,    12,    13,    14,    15,    16,
      17,    18,    19,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      27,    -1,    -1,    30,    -1,    -1,    -1,    -1,    35,    -1,
      -1,    -1,    39,    -1,    41,    -1,    -1,    -1,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    -1,    -1,    55,    -1,
      -1,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    -1,    -1,    72,    -1,    -1,    75,    76,
      77,    78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      97,    -1,    -1,    -1,   101,    -1,    -1,   104,    -1,   106,
     107,    -1,   109,   110,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,    -1,   120,    -1,    -1,   123,   124,   125,    -1,
      -1,    -1,   129,   130,    -1,    -1,    -1,   134,    -1,   136,
     137,   138,   139,    -1,   141,   142,   143,    -1,    -1,   146,
      -1,    -1,    -1,   150,    -1,    -1,    -1,    -1,    -1,   156,
      -1,    -1,   159,   160,    -1,   162,   163,    -1,    -1,   166,
     167,   168,    -1,   170,     3,     4,    -1,   174,   175,    -1,
       9,    10,    -1,    12,    13,    14,    15,    16,    17,    18,
      19,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    27,    -1,
      -1,    30,    -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,
      39,    -1,    41,    -1,    -1,    -1,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    -1,    -1,    55,    -1,    -1,    -1,
      -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    -1,    -1,    72,    -1,    -1,    75,    76,    77,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    87,    88,
      89,    -1,    -1,    -1,    93,    -1,    -1,    96,    97,    -1,
      -1,    -1,   101,    -1,    -1,   104,    -1,   106,   107,    -1,
     109,   110,   111,    -1,    -1,    -1,   115,   116,   117,    -1,
      -1,   120,    -1,    -1,   123,   124,   125,    -1,    -1,    -1,
     129,   130,    -1,    -1,    -1,   134,    -1,   136,   137,   138,
     139,    -1,   141,   142,   143,    -1,    -1,   146,    -1,    -1,
      -1,   150,    -1,    -1,    -1,    -1,    -1,   156,    -1,    -1,
     159,   160,    -1,   162,   163,    -1,    -1,   166,   167,    -1,
      -1,   170,     3,     4,    -1,   174,   175,    -1,     9,    10,
      -1,    12,    13,    14,    15,    16,    17,    18,    19,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    27,    -1,    -1,    30,
      -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,    39,    -1,
      41,    -1,    -1,    -1,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    -1,    -1,    55,    -1,    -1,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    -1,    -1,    -1,    -1,    69,    -1,
      -1,    72,    -1,    -1,    75,    76,    77,    78,    79,    80,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    97,    -1,    -1,    -1,
     101,    -1,    -1,   104,    -1,   106,   107,    -1,   109,   110,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,   120,
      -1,    -1,   123,   124,   125,    -1,    -1,    -1,   129,   130,
      -1,    -1,    -1,   134,    -1,   136,   137,   138,   139,    -1,
     141,   142,   143,    -1,    -1,   146,    -1,    -1,    -1,   150,
      -1,    -1,    -1,    -1,    -1,   156,    -1,    -1,   159,   160,
      -1,   162,   163,    -1,    -1,   166,   167,    -1,    -1,   170,
       3,     4,    -1,   174,   175,    -1,     9,    10,    -1,    12,
      13,    14,    15,    16,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    27,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    45,    -1,    -1,    48,    -1,    -1,    -1,    52,
      -1,    -1,    55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    -1,    -1,
      -1,    -1,    -1,    -1,    87,    -1,    89,    -1,    -1,    -1,
      93,    -1,    -1,    96,    97,    -1,    -1,    -1,   101,    -1,
      -1,   104,    -1,   106,   107,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   116,   117,    -1,    -1,   120,    -1,    -1,
      -1,   124,   125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   134,    -1,   136,   137,   138,   139,    -1,   141,    -1,
     143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   156,    -1,    -1,   159,   160,    -1,   162,
     163,    -1,    -1,   166,    -1,    -1,   169,   170,     3,     4,
      -1,   174,   175,    -1,     9,    10,    -1,    12,    13,    14,
      15,    16,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      35,    -1,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    48,    -1,    -1,    -1,    52,    -1,    -1,
      55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    77,    78,    79,    80,    -1,    -1,    -1,    -1,
      -1,    -1,    87,    -1,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    97,    -1,    -1,    -1,   101,    -1,    -1,   104,
      -1,   106,   107,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   116,   117,    -1,    -1,   120,    -1,    -1,    -1,   124,
     125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,
      -1,   136,   137,   138,   139,    -1,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   156,    -1,    -1,   159,   160,    -1,   162,   163,    -1,
      -1,   166,    -1,    -1,   169,   170,     3,     4,    -1,   174,
     175,    -1,     9,    10,    -1,    12,    13,    14,    15,    16,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      27,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    48,    -1,    -1,    -1,    52,    -1,    -1,    55,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    -1,    -1,    -1,    -1,    -1,    -1,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      97,    -1,    -1,    -1,   101,    -1,    -1,   104,    -1,   106,
     107,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,
     117,    -1,    -1,   120,    -1,    -1,    -1,   124,   125,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,    -1,   136,
     137,   138,   139,    -1,   141,    -1,   143,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   156,
      -1,    -1,   159,   160,    -1,   162,   163,    -1,    -1,   166,
      -1,    -1,    -1,   170,     3,     4,    -1,   174,   175,    -1,
       9,    10,    -1,    12,    13,    14,    15,    16,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    27,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,
      -1,    -1,    -1,    52,    -1,    -1,    55,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,
      79,    80,    -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,
      89,    -1,    -1,    -1,    93,    -1,    -1,    96,    97,    -1,
      -1,    -1,   101,    -1,    -1,   104,    -1,   106,   107,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,   117,    -1,
      -1,   120,    -1,    -1,    -1,   124,   125,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   134,    -1,   136,   137,   138,
     139,    -1,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   156,    -1,    -1,
     159,   160,    -1,   162,   163,    -1,    -1,   166,    -1,    -1,
      -1,   170,     3,     4,    -1,   174,   175,    -1,     9,    10,
      -1,    12,    13,    14,    15,    16,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    27,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    35,    -1,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    -1,    -1,    48,    -1,    -1,
      -1,    52,    -1,    -1,    55,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,    80,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    97,    -1,    -1,    -1,
     101,    -1,    -1,   104,    -1,   106,   107,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   116,   117,    -1,    -1,   120,
      -1,    -1,    -1,   124,   125,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   134,    -1,   136,   137,   138,   139,    -1,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,     4,    -1,    -1,    -1,    -1,     9,    10,    -1,    12,
      13,    14,    15,    16,    -1,   166,    -1,    20,    -1,   170,
      23,    -1,    25,   174,   175,    28,    29,    -1,    31,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    39,    40,    -1,    -1,
      -1,    -1,    45,    -1,    -1,    -1,    -1,    50,    -1,    -1,
      53,    -1,    55,    56,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,
      -1,    74,    -1,    -1,    -1,    -1,    79,    -1,    -1,    82,
      -1,    -1,    85,    86,    87,    -1,    89,    -1,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,   101,    -1,
      -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,   112,
     113,   114,    -1,    -1,   117,    -1,    -1,   120,   121,   122,
      -1,   124,    -1,    -1,    -1,    -1,    -1,     3,     4,   132,
     133,    -1,   135,    -1,    -1,    -1,    -1,   140,    -1,    -1,
     143,   144,   145,    -1,    20,   148,   149,    23,    -1,    25,
      -1,    -1,    28,    29,    -1,    31,   159,    -1,    -1,    -1,
     163,    -1,    -1,   166,    40,    -1,    -1,   170,    -1,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    -1,    53,    -1,    55,
      56,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    74,    -1,
      -1,    -1,    -1,    79,    -1,    -1,    82,    -1,    -1,    85,
      86,    87,    -1,    89,    -1,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    99,    -1,   101,    -1,    -1,    -1,    -1,
      -1,   107,    -1,    -1,    -1,    -1,   112,   113,   114,    -1,
      -1,   117,    -1,    -1,   120,   121,   122,    -1,   124,    -1,
      -1,    -1,    -1,    -1,     3,     4,   132,   133,    -1,   135,
      -1,    -1,    -1,    -1,   140,    -1,    -1,   143,   144,   145,
      -1,    20,   148,   149,    23,    -1,    25,    -1,    -1,    28,
      29,    -1,    31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     166,    40,   168,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    50,    -1,    -1,    53,    -1,    55,    56,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      -1,    -1,    -1,    -1,    -1,    74,    -1,    -1,    -1,    -1,
      79,    -1,    -1,    82,    -1,    -1,    85,    86,    87,    -1,
      89,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,   101,    -1,    -1,    -1,    -1,    -1,   107,    -1,
      -1,    -1,    -1,   112,   113,   114,    -1,    -1,   117,    -1,
      -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,    -1,
      -1,     3,     4,   132,   133,    -1,   135,    -1,    -1,    -1,
      -1,   140,    -1,    -1,   143,   144,   145,    -1,    20,   148,
     149,    23,    -1,    25,    -1,    -1,    28,    29,    -1,    31,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    40,   168,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      -1,    53,    -1,    55,    56,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,
      -1,    -1,    74,    -1,    -1,    -1,    -1,    79,    -1,    -1,
      82,    -1,    -1,    85,    86,    87,    -1,    89,    -1,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,   101,
      -1,    -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,
     112,   113,   114,    -1,    -1,   117,    -1,    -1,   120,   121,
     122,    -1,   124,    -1,    -1,    -1,    -1,    -1,     3,     4,
     132,   133,    -1,   135,    -1,    -1,    -1,    -1,   140,    -1,
      -1,   143,   144,   145,    -1,    20,   148,   149,    23,    -1,
      25,    -1,    -1,    28,    29,    -1,    31,    -1,    -1,    -1,
     162,    -1,    -1,    -1,   166,    40,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    -1,    53,    -1,
      55,    56,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    74,
      -1,    -1,    -1,    -1,    79,    -1,    -1,    82,    -1,    -1,
      85,    86,    87,    -1,    89,    -1,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,   101,    -1,    -1,    -1,
      -1,    -1,   107,    -1,    -1,    -1,    -1,   112,   113,   114,
      -1,    -1,   117,    -1,    -1,   120,   121,   122,    -1,   124,
      -1,    -1,    -1,    -1,    -1,     3,     4,   132,   133,    -1,
     135,    -1,    -1,    -1,    -1,   140,    -1,    -1,   143,   144,
     145,    -1,    20,   148,   149,    23,    -1,    25,    -1,    -1,
      28,    29,    -1,    31,    -1,    -1,    -1,   162,    -1,    -1,
      -1,   166,    40,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    50,    -1,    -1,    53,    -1,    55,    56,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    -1,    -1,    -1,    -1,    -1,    74,    -1,    -1,    -1,
      -1,    79,    -1,    -1,    82,    -1,    -1,    85,    86,    87,
      -1,    89,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    99,    -1,   101,    -1,    -1,    -1,    -1,    -1,   107,
      -1,    -1,    -1,    -1,   112,   113,   114,    -1,    -1,   117,
      -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,
      -1,    -1,     3,     4,   132,   133,    -1,   135,    -1,    -1,
      -1,    -1,   140,    -1,    -1,   143,   144,   145,    -1,    20,
     148,   149,    23,    -1,    25,    -1,    -1,    28,    29,    -1,
      31,    -1,    -1,    -1,   162,    -1,    -1,    -1,   166,    40,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    -1,    53,    -1,    55,    56,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,
      -1,    -1,    -1,    74,    -1,    -1,    -1,    -1,    79,    -1,
      -1,    82,    -1,    -1,    85,    86,    87,    -1,    89,    -1,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
     101,    -1,    -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,
      -1,   112,   113,   114,    -1,    -1,   117,    -1,    -1,   120,
     121,   122,    -1,   124,    -1,    -1,    -1,    -1,    -1,     3,
       4,   132,   133,    -1,   135,    -1,    -1,    -1,    -1,   140,
      -1,    -1,   143,   144,   145,    -1,    20,   148,   149,    23,
      -1,    25,    -1,    -1,    28,    29,    -1,    31,    -1,    -1,
      -1,   162,    -1,    -1,    -1,   166,    40,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    50,    -1,    -1,    53,
      -1,    55,    56,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      74,    -1,    -1,    -1,    -1,    79,    -1,    -1,    82,    -1,
      -1,    85,    86,    87,    -1,    89,    -1,    91,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    -1,   101,    -1,    -1,
      -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,   112,   113,
     114,    -1,    -1,   117,    -1,    -1,   120,   121,   122,    -1,
     124,    -1,    -1,    -1,    -1,    -1,     3,     4,   132,   133,
      -1,   135,    -1,    -1,    -1,    -1,   140,    -1,    -1,   143,
     144,   145,    -1,    20,   148,   149,    23,    -1,    25,    -1,
      -1,    28,    29,    -1,    31,    -1,    -1,    -1,   162,    -1,
      -1,    -1,   166,    40,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    50,    -1,    -1,    53,    -1,    55,    56,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    68,    -1,    -1,    -1,    -1,    -1,    74,    -1,    -1,
      -1,    -1,    79,    -1,    -1,    82,    -1,    -1,    85,    86,
      87,    -1,    89,    -1,    91,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,   101,    -1,    -1,    -1,    -1,    -1,
     107,    -1,    -1,    -1,    -1,   112,   113,   114,    -1,    -1,
     117,    -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,
      -1,    -1,    -1,     3,     4,   132,   133,    -1,   135,    -1,
      -1,    -1,    -1,   140,    -1,    -1,   143,   144,   145,    -1,
      20,   148,   149,    23,    -1,    25,    -1,    -1,    28,    29,
      -1,    31,    -1,    -1,    -1,   162,    -1,    -1,    -1,   166,
      40,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      50,    -1,    -1,    53,    -1,    55,    56,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,
      -1,    -1,    -1,    -1,    74,    -1,    -1,    -1,    -1,    79,
      -1,    -1,    82,    -1,    -1,    85,    86,    87,    -1,    89,
      -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,
      -1,   101,    -1,    -1,    -1,    -1,    -1,   107,    -1,    -1,
      -1,    -1,   112,   113,   114,    -1,    -1,   117,    -1,    -1,
     120,   121,   122,    -1,   124,    -1,    -1,    -1,    -1,    -1,
       3,     4,   132,   133,    -1,   135,    -1,    -1,    -1,    -1,
     140,    -1,    -1,   143,   144,   145,    -1,    20,   148,   149,
      23,    -1,    25,    -1,    -1,    28,    29,    -1,    31,    -1,
      -1,    -1,   162,    -1,    -1,    -1,   166,    40,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    50,    -1,    -1,
      53,    -1,    55,    56,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,
      -1,    74,    -1,    -1,    -1,    -1,    79,    -1,    -1,    82,
      -1,    -1,    85,    86,    87,    -1,    89,    -1,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,   101,    -1,
      -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,   112,
     113,   114,    -1,    -1,   117,    -1,    -1,   120,   121,   122,
      -1,   124,    -1,    -1,    -1,    -1,    -1,     3,     4,   132,
     133,    -1,   135,    -1,    -1,    -1,    -1,   140,    -1,    -1,
     143,   144,   145,    -1,    20,   148,   149,    23,    -1,    25,
      -1,    -1,    28,    29,    -1,    31,    -1,    -1,    -1,   162,
      -1,    -1,    -1,   166,    40,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    -1,    53,    -1,    55,
      56,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    74,    -1,
      -1,    -1,    -1,    79,    -1,    -1,    82,    -1,    -1,    85,
      86,    87,    -1,    89,    -1,    91,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    99,    -1,   101,    -1,    -1,    -1,    -1,
      -1,   107,    -1,    -1,    -1,    -1,   112,   113,   114,    -1,
      -1,   117,    -1,    -1,   120,   121,   122,    -1,   124,    -1,
      -1,    -1,    -1,    -1,     3,     4,   132,   133,    -1,   135,
      -1,    -1,    -1,    -1,   140,    -1,    -1,   143,   144,   145,
      -1,    20,   148,   149,    23,    -1,    25,    -1,    -1,    28,
      29,    -1,    31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     166,    40,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    50,    -1,    -1,    53,    -1,    55,    56,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      -1,    -1,    -1,    -1,    -1,    74,    -1,    -1,    -1,    -1,
      79,    -1,    -1,    82,    -1,    -1,    85,    86,    87,    -1,
      89,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,   101,    -1,    -1,    -1,    -1,    -1,   107,    -1,
      -1,    -1,    -1,   112,   113,   114,    -1,    -1,   117,    -1,
      -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,    -1,
      -1,     3,     4,   132,   133,    -1,   135,    -1,    -1,    -1,
      -1,   140,    -1,    -1,   143,   144,   145,    -1,    20,   148,
     149,    23,    -1,    25,    -1,    -1,    28,    29,    -1,    31,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    40,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    50,    -1,
      -1,    53,    -1,    55,    56,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,    -1,
      -1,    -1,    74,    -1,    -1,    -1,    -1,    79,    -1,    -1,
      82,    -1,    -1,    85,    86,    87,    -1,    89,    -1,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,   101,
      -1,    -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,    -1,
     112,   113,   114,    -1,    -1,   117,    -1,    -1,   120,   121,
     122,    -1,   124,    -1,    -1,    -1,    -1,    -1,     3,     4,
     132,   133,    -1,   135,    -1,    -1,    -1,    -1,   140,    -1,
      -1,   143,   144,   145,    -1,    20,   148,   149,    23,    -1,
      25,    -1,    -1,    28,    29,    -1,    31,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   166,    40,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    50,    -1,    -1,    53,    -1,
      55,    56,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    74,
      -1,    -1,    -1,    -1,    79,    -1,    -1,    82,    -1,    -1,
      85,    86,    87,    -1,    89,    -1,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,   101,    -1,    -1,    -1,
      -1,    -1,   107,    -1,    -1,    -1,    -1,   112,   113,   114,
      -1,    -1,   117,    -1,    -1,   120,   121,   122,    -1,   124,
      -1,    -1,    -1,    -1,    -1,     3,     4,   132,   133,    -1,
     135,    -1,    -1,    -1,    -1,   140,    -1,    -1,   143,   144,
     145,    -1,    20,   148,   149,    23,    -1,    25,    -1,    -1,
      28,    29,    -1,    31,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   166,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    50,    -1,    -1,    53,    -1,    55,    56,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    -1,    -1,    -1,    -1,    -1,    74,    -1,    -1,    -1,
      -1,    79,    -1,    -1,    82,    -1,    -1,    85,    86,    87,
      -1,    89,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    99,    -1,   101,    -1,    -1,    -1,    -1,    -1,   107,
      -1,    -1,    -1,    -1,   112,   113,   114,    -1,    -1,   117,
      -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,
      -1,    -1,     3,     4,   132,   133,    -1,   135,    -1,    -1,
      -1,    -1,   140,    -1,    -1,   143,   144,   145,    -1,    20,
     148,   149,    23,    -1,    -1,    -1,    -1,    28,    29,    -1,
      31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    -1,    53,    -1,    55,    56,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    -1,    -1,
      -1,    -1,    -1,    74,    -1,    -1,    -1,    -1,    79,    -1,
      -1,    82,    -1,    -1,    85,    86,    87,    -1,    89,    -1,
      91,    -1,    22,    -1,    -1,    -1,    -1,    -1,    99,    -1,
     101,    -1,    -1,    -1,    -1,    -1,   107,    -1,    -1,    -1,
      -1,   112,   113,   114,    -1,    -1,   117,    47,    -1,   120,
     121,   122,    -1,   124,    54,    -1,    -1,    -1,    -1,    -1,
      -1,   132,   133,    -1,   135,    65,    -1,    67,    -1,   140,
      -1,    71,   143,   144,   145,    -1,    -1,   148,   149,    -1,
      -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    92,    93,    -1,   166,    -1,    -1,    98,    -1,
     100,    -1,   102,    -1,    -1,   105,   106,    -1,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,   119,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,    -1,
      -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    22,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,    -1,
      -1,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,    47,   165,   166,    -1,    -1,    -1,
     170,    54,    -1,    -1,    93,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    65,    -1,    67,    -1,    -1,   106,    71,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
     119,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,
      93,    -1,   131,    -1,    -1,    98,    -1,   100,    -1,   102,
      -1,    -1,   105,   106,    -1,   108,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   118,   119,   156,   157,   158,
     159,   160,   161,   162,   163,   128,   165,   166,   131,    -1,
      -1,   170,    -1,    -1,    -1,    -1,    22,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,   151,   152,
     153,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,    47,   165,   166,    -1,    -1,    -1,   170,    54,    -1,
      -1,    93,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    65,
      -1,    67,    -1,    -1,   106,    71,   108,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   118,   119,    84,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    92,    93,    -1,   131,
      -1,    -1,    98,    -1,   100,    -1,   102,    -1,    -1,   105,
     106,    -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   118,   119,    -1,    -1,   158,   159,   160,   161,
     162,   163,   128,   165,   166,   131,    -1,    -1,   170,    -1,
      -1,    -1,    -1,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   151,   152,    -1,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,    47,   165,
     166,    -1,    -1,    -1,   170,    54,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    65,    -1,    67,    -1,
      -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    92,    93,    -1,    -1,    -1,    -1,    98,
      -1,   100,    -1,   102,    -1,    -1,   105,   106,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   128,
      -1,    -1,   131,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   151,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,    54,   165,   166,    -1,    -1,
      -1,   170,    -1,    -1,    -1,    -1,    65,    -1,    67,    -1,
      -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    -1,    -1,    -1,    -1,    98,
      -1,   100,    -1,   102,    -1,    -1,    -1,   106,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,    54,   165,   166,    -1,    -1,
      -1,   170,    -1,    -1,    -1,    -1,    65,    -1,    67,    -1,
      -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    -1,    -1,    -1,    -1,    98,
      -1,   100,    -1,   102,    -1,    -1,    -1,   106,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,    54,   165,   166,    -1,    -1,
      -1,   170,    -1,    -1,    -1,    -1,    65,    -1,    67,    -1,
      -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    -1,    -1,    -1,    -1,    98,
      -1,   100,    -1,   102,    -1,    -1,    -1,   106,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,    54,   165,   166,    -1,    -1,
      -1,   170,    -1,    -1,    -1,    -1,    65,    -1,    67,    -1,
      -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    -1,    -1,    -1,    -1,    98,
      -1,   100,    -1,   102,    -1,    -1,    -1,   106,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,    54,   165,   166,    -1,    -1,
      -1,   170,    -1,    -1,    -1,    -1,    65,    -1,    67,    -1,
      -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    -1,    -1,    -1,    -1,    98,
      -1,   100,    -1,   102,    -1,    -1,    -1,   106,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   152,    -1,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,    54,   165,   166,    -1,    -1,
      -1,   170,    -1,    -1,    -1,    -1,    65,    -1,    67,    -1,
      -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    -1,    -1,    -1,    -1,    98,
      -1,   100,    -1,   102,    -1,    -1,    -1,   106,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,    54,   165,   166,    -1,    -1,
      -1,   170,    -1,    -1,    -1,    -1,    65,    -1,    67,    -1,
      -1,    -1,    71,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    -1,    -1,    -1,    -1,    98,
      -1,   100,    -1,    -1,    -1,    -1,    -1,   106,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    -1,    54,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    65,    -1,    67,    -1,
      -1,    -1,    71,    -1,    -1,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,    84,   165,   166,    -1,    -1,
      -1,   170,    -1,    -1,    93,    -1,    -1,    -1,    -1,    98,
      -1,   100,    -1,    -1,    -1,    -1,    -1,   106,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    -1,    54,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    65,    -1,    67,    -1,
      -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,    84,   165,   166,    -1,    -1,
      -1,   170,    -1,    -1,    93,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    -1,    54,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    65,    -1,    67,    -1,
      -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,    84,   165,   166,    -1,    -1,
      -1,   170,    -1,    -1,    93,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    65,    -1,    67,    -1,
      -1,    -1,    -1,    -1,    -1,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,    84,   165,   166,    -1,    -1,
      -1,   170,    -1,    -1,    93,    -1,    -1,    -1,    -1,    65,
      -1,    67,    -1,    -1,    -1,    -1,    -1,   106,    -1,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,   118,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    93,    -1,    -1,
      -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     106,    -1,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   118,   119,    -1,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   131,   165,   166,    -1,    -1,
      -1,   170,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,    -1,   165,
     166,    -1,    -1,    -1,   170
  };

  const short
  Parser::yystos_[] =
  {
       0,    95,   178,     3,   179,     0,   167,   184,     4,     8,
       9,    10,    12,    13,    14,    15,    16,    17,    18,    19,
      27,    30,    35,    39,    41,    44,    45,    46,    48,    52,
      55,    62,    69,    70,    72,    75,    76,    77,    78,    79,
      80,    87,    88,    89,    91,    93,    96,    97,   101,   104,
     106,   107,   109,   110,   111,   115,   116,   117,   120,   123,
     124,   125,   129,   130,   134,   136,   137,   138,   139,   141,
     142,   143,   146,   150,   156,   159,   160,   162,   163,   166,
     167,   168,   170,   174,   175,   179,   180,   185,   186,   187,
     188,   190,   192,   193,   194,   195,   212,   215,   223,   224,
     251,   255,   256,   257,   259,   260,   261,   266,   267,   268,
     269,   272,   273,   274,   151,   169,   163,   251,   251,   252,
     256,   170,   169,   154,   229,   169,   195,   229,   251,   170,
     170,   170,   170,   179,   170,   170,   170,   170,   170,   170,
     170,   229,    20,    23,    25,    28,    29,    31,    40,    50,
      53,    55,    56,    68,    74,    79,    82,    85,    86,    87,
      89,    91,    99,   101,   107,   112,   113,   114,   117,   120,
     121,   122,   124,   132,   133,   135,   140,   143,   144,   145,
     148,   149,   166,   179,   180,   202,   203,   225,   226,   227,
     228,   231,   232,   235,   239,   243,   246,   170,   229,    58,
      59,   199,   204,   256,   170,    25,    87,    89,   101,   117,
     143,   166,   170,   228,   259,   170,   261,   265,   256,   170,
     169,   251,   170,   229,   170,   170,   170,   170,   169,   251,
     186,   187,   195,   211,   215,   170,   170,   170,   170,   170,
     229,   251,   170,   229,   170,   169,   256,    14,    15,   256,
     256,   275,   176,   251,   253,   254,   270,   271,   213,   214,
     215,   251,   262,   264,   256,   256,    40,    64,    66,    68,
     133,   169,    22,    47,    54,    65,    67,    71,    84,    92,
      93,    98,   100,   102,   105,   106,   108,   118,   119,   128,
     131,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   165,   166,   170,   156,   282,   251,
      15,   169,   169,   153,   169,   251,   228,   201,   202,   227,
     169,   251,   251,   179,    88,   189,   251,    63,   169,   251,
     251,   251,   251,   251,   251,   251,   253,   228,   179,   170,
     227,   154,   167,   229,   229,   170,   170,   229,   229,   229,
     229,   229,   229,   170,   236,   229,   229,   282,   229,   229,
     229,   229,    56,   151,    64,   179,   252,   278,   279,   280,
     228,   228,   251,   229,   229,   229,   229,   251,   170,   251,
     251,   169,   253,   228,   251,   189,   251,   251,   251,   169,
      36,   221,   222,    55,    79,   107,   120,   124,   166,   226,
     251,   251,   251,   251,   251,   228,   169,   253,   228,   189,
     251,   156,    11,   179,    62,   173,   172,   172,   173,   168,
     215,   171,   171,   172,   180,   227,   198,   204,    25,   180,
     228,   200,   204,   180,   256,   256,   256,   256,    55,   179,
     258,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     256,   256,   258,   256,   256,   251,   256,   256,   256,   256,
     256,   256,   256,   256,   256,   256,   258,   251,   253,   274,
       7,   281,   169,   251,   171,   155,   230,   169,   204,   230,
     171,   171,    71,    25,   228,   169,   171,   171,   181,   182,
     171,   171,   171,   171,   171,   171,   171,   230,   151,    15,
     162,   179,   244,   245,    15,   162,   228,     9,     9,   162,
     228,   162,   228,   228,   162,   228,   228,   162,   228,    43,
      73,   205,   206,   207,   209,   167,   162,   179,   228,   233,
     234,    15,   162,   167,   162,   228,   228,   162,   228,   162,
     228,   153,   251,   170,   151,   170,   191,   153,   171,   172,
     172,     4,     5,    61,   179,   196,   197,   171,   228,   228,
     228,   228,   253,   171,   172,   171,   230,   171,   171,   171,
     171,   171,   170,   211,   222,   171,   171,   171,   171,   171,
     171,   230,   171,   230,   169,   171,   171,   276,   151,   179,
     251,   271,   263,   264,   151,   180,   228,   180,   151,   180,
     228,   151,   153,   170,   173,   171,   151,   169,   170,   228,
     170,   251,   179,   179,   251,   211,   211,   169,     6,   170,
     251,   171,   155,   151,   168,   172,   230,   230,   230,   171,
     171,   230,   230,   230,   172,   230,   230,   230,   230,   230,
     230,   171,   172,    25,   208,   227,   237,   230,   153,   172,
     230,   230,   230,   228,   240,   241,   242,   230,   230,   230,
     230,   230,   230,   230,   227,   169,   205,   251,   253,   169,
     251,   280,   228,   170,   230,   172,   230,   230,   171,   251,
     170,   167,   167,   180,   208,   265,   170,   251,   211,   211,
     163,   251,    71,   172,   251,   151,   197,   151,   251,   151,
     191,   197,   228,   256,   253,   251,   251,   197,   253,   171,
     151,   151,   171,    51,   216,   216,   183,   262,   169,   247,
      15,   245,   228,   207,   179,   168,   203,   228,   238,   228,
     234,   179,   168,   172,   173,   171,   169,   171,   230,   205,
     228,   171,   262,    34,    45,   217,   218,   219,   217,   179,
     262,   171,   216,   216,   176,   179,   277,   251,   263,   169,
     251,   170,   251,   169,   251,   169,   170,   282,   171,   171,
     170,   171,   211,   251,   251,   211,   211,   171,   167,   230,
     151,   210,   204,   179,   282,   242,    24,   170,   171,   230,
     171,   220,   252,   153,   168,   219,   168,   171,   171,   211,
     170,   277,    69,   173,   169,   205,   169,   169,   205,   169,
     205,   216,   179,   248,   249,   250,   251,   282,   228,   282,
     228,   278,   282,   153,   172,   211,   211,   216,    15,   251,
     171,   171,   171,   153,   168,   250,   196,   169,   171,   212,
     211,   252,   171,   173,   282,   282,   282,    15,   170,   277,
     212,   212,    49,   282,   205,    15,   169,   171,   282,   282,
     169,   169,   212
  };

  const short
  Parser::yyr1_[] =
  {
       0,   177,   178,   179,   180,   180,   182,   183,   181,   184,
     184,   184,   185,   185,   185,   185,   185,   185,   186,   187,
     187,   188,   188,   188,   188,   189,   189,   190,   190,   190,
     190,   191,   191,   192,   192,   192,   192,   193,   193,   194,
     194,   195,   195,   195,   195,   195,   196,   196,   197,   197,
     197,   198,   199,   200,   201,   202,   202,   203,   203,   204,
     204,   204,   205,   205,   206,   206,   207,   208,   208,   209,
     209,   209,   210,   210,   211,   212,   213,   213,   214,   214,
     215,   215,   215,   215,   215,   215,   215,   215,   215,   215,
     215,   215,   215,   215,   215,   215,   215,   215,   215,   215,
     215,   215,   215,   215,   215,   215,   216,   216,   217,   217,
     218,   218,   219,   219,   220,   220,   221,   221,   222,   222,
     223,   223,   223,   224,   225,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   225,
     226,   227,   227,   227,   228,   228,   228,   229,   230,   231,
     232,   232,   233,   233,   234,   234,   235,   236,   236,   237,
     237,   238,   238,   238,   239,   240,   240,   241,   241,   242,
     243,   243,   244,   244,   244,   245,   245,   247,   246,   248,
     248,   249,   249,   250,   250,   251,   252,   253,   253,   254,
     254,   255,   255,   256,   256,   256,   256,   256,   256,   256,
     256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     256,   256,   256,   256,   256,   256,   256,   256,   256,   256,
     256,   256,   256,   256,   257,   258,   258,   259,   259,   259,
     259,   259,   259,   259,   259,   259,   259,   259,   259,   259,
     259,   259,   259,   259,   259,   259,   260,   260,   260,   260,
     260,   260,   260,   260,   260,   260,   260,   260,   260,   260,
     260,   261,   262,   262,   262,   263,   263,   263,   264,   265,
     266,   266,   266,   266,   266,   267,   267,   268,   268,   269,
     270,   270,   271,   272,   273,   273,   275,   276,   274,   277,
     277,   277,   278,   278,   279,   279,   280,   281,   281,   282,
     282
  };

  const signed char
  Parser::yyr2_[] =
  {
       0,     2,     5,     1,     1,     1,     0,     0,     3,     2,
       2,     0,     1,     1,     1,     1,     1,     1,     7,     6,
       7,     5,     5,     6,     6,     5,     5,     6,     6,     7,
       7,     3,     0,     3,     3,     2,     4,     3,     5,     2,
       4,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     8,     8,     8,     8,     1,     0,     1,     1,     1,
       1,     0,     1,     0,     3,     1,     5,     1,     1,     1,
       1,     0,     2,     0,     1,     3,     1,     0,     2,     1,
       2,     1,     1,     2,     3,     3,     2,     2,     2,     2,
       6,     6,     8,     8,     6,     6,     7,     7,     7,     3,
       3,     5,     3,     3,     3,     3,     2,     0,     1,     0,
       2,     1,     4,     3,     3,     1,     2,     1,     6,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       6,     1,     5,     4,     4,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     7,
       4,     4,     3,     1,     1,     3,     5,     3,     0,     2,
       0,     4,     9,     9,     5,     1,     0,     3,     1,     3,
       4,     4,     3,     2,     1,     1,     3,     0,     8,     1,
       0,     2,     1,     7,     5,     1,     1,     1,     0,     3,
       1,     1,     3,     3,     3,     3,     3,     3,     5,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
       2,     2,     3,     2,     2,     4,     3,     6,     2,     2,
       3,     3,     3,     3,     1,     7,     2,     5,     4,     4,
       4,     2,     2,     5,     4,     4,     1,     1,     7,     9,
       3,     1,     1,     1,     4,     1,     1,     1,     1,     1,
       1,     2,     1,     2,     1,     1,     3,     1,     4,     7,
       1,     1,     1,     1,     1,     1,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       6,     3,     1,     3,     0,     1,     3,     0,     1,     1,
       3,     4,     7,     4,     7,     4,     7,     4,     9,     3,
       3,     1,     4,     2,     3,     1,     0,     0,     6,     2,
       5,     0,     1,     0,     3,     1,     3,     1,     3,     2,
       0
  };


#if YYDEBUG || 1
  // YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
  // First, the terminals, then, starting at \a YYNTOKENS, nonterminals.
  const char*
  const Parser::yytname_[] =
  {
  "\"<end of input>\"", "error", "\"invalid token\"", "\"identifier\"",
  "\"scoped identifier\"", "\"scoped ~finally\"", "\"dotted identifier\"",
  "\"attribute\"", "\"property\"", "\"string value\"", "\"bytes value\"",
  "\"regular expression value\"", "\"address value\"", "\"port value\"",
  "\"real value\"", "\"unsigned integer value\"", "\"bool value\"",
  "\"add\"", "\"assert\"", "\"assert-exception\"", "\"addr\"", "\"after\"",
  "\"&&\"", "\"any\"", "\"->\"", "\"auto\"", "\"at\"", "\"begin\"",
  "\"bitfield\"", "\"bool\"", "\"break\"", "\"bytes\"", "\"caddr\"",
  "\"callable\"", "\"case\"", "\"cast\"", "\"catch\"", "\"channel\"",
  "\"classifier\"", "\"Null\"", "\"const\"", "\"continue\"", "\"context\"",
  "\"copy\"", "\"declare\"", "\"default\"", "\"delete\"", "\"/=\"",
  "\"$$\"", "\"..\"", "\"real\"", "\"else\"", "\"end\"", "\"enum\"",
  "\"==\"", "\"error\"", "\"exception\"", "\"export\"", "\"extern\"",
  "\"extern-no-suspend\"", "\"file\"", "\"~finally\"", "\"for\"",
  "\"from\"", "\"function\"", "\">=\"", "\"global\"", "\"?.\"", "\"hook\"",
  "\"if\"", "\"import\"", "\"in\"", "\"init\"", "\"inout\"", "\"int\"",
  "\"int16\"", "\"int32\"", "\"int64\"", "\"int8\"", "\"interval\"",
  "\"interval_ns\"", "\"iosrc\"", "\"iterator\"", "\"const_iterator\"",
  "\"<=\"", "\"library type\"", "\"const library type\"", "\"list\"",
  "\"local\"", "\"map\"", "\"match_token_state\"", "\"method\"", "\"-=\"",
  "\"--\"", "\"%\"", "\"module\"", "\"move\"", "\"new\"", "\"!=\"",
  "\"net\"", "\"!in\"", "\"optional\"", "\"||\"", "\"overlay\"",
  "\"pack\"", "\"+=\"", "\"++\"", "\"port\"", "\"**\"", "\"preinit\"",
  "\"private\"", "\"public\"", "\"strong_ref\"", "\"regexp\"",
  "\"result\"", "\"return\"", "\"scope\"", "\"set\"", "\"<<\"", "\">>\"",
  "\"stream\"", "\"string\"", "\"struct\"", "\"switch\"", "\"time\"",
  "\"time_ns\"", "\"timer\"", "\"timer_mgr\"", "\"*=\"", "\"throw\"",
  "\"try\"", "\".?\"", "\"tuple\"", "\"type\"", "\"typeinfo\"", "\"uint\"",
  "\"uint16\"", "\"uint32\"", "\"uint64\"", "\"uint8\"", "\"union\"",
  "\"unpack\"", "\"unset\"", "\"vector\"", "\"view\"", "\"void\"",
  "\"while\"", "\"with\"", "\"value_ref\"", "\"weak_ref\"", "\"yield\"",
  "'='", "'?'", "':'", "'<'", "'>'", "'|'", "'^'", "'&'", "'+'", "'-'",
  "'%'", "'*'", "'/'", "UNARY_PREC", "'.'", "'['", "'{'", "'}'", "';'",
  "'('", "')'", "','", "']'", "'!'", "'~'", "'$'", "$accept", "module",
  "local_id", "scoped_id", "dotted_id", "$@1", "$@2", "global_scope_items",
  "global_scope_decl", "type_decl", "constant_decl", "local_decl",
  "local_init_decl", "global_decl", "opt_type_arguments", "function_decl",
  "import_decl", "property_decl", "opt_linkage", "function_id",
  "scoped_function_id", "function_with_body", "method_with_body",
  "hook_with_body", "function_without_body", "opt_func_flavor",
  "func_flavor", "opt_func_cc", "opt_func_params", "func_params",
  "func_param", "func_param_type", "opt_func_param_kind",
  "opt_func_default_expr", "block", "braced_block", "opt_stmts", "stmts",
  "stmt", "opt_else_block", "opt_switch_cases", "switch_cases",
  "switch_case", "case_exprs", "try_catches", "try_catch", "stmt_decl",
  "stmt_expr", "base_type_no_attrs", "base_type", "type", "qtype",
  "type_param_begin", "type_param_end", "function_type", "tuple_type",
  "tuple_type_elems", "tuple_type_elem", "struct_type",
  "opt_struct_params", "struct_fields", "struct_field", "union_type",
  "opt_union_fields", "union_fields", "union_field", "enum_type",
  "enum_labels", "enum_label", "bitfield_type", "$@3",
  "opt_bitfield_bit_ranges", "bitfield_bit_ranges", "bitfield_bit_range",
  "expr", "expr_no_or_error", "opt_exprs", "exprs", "expr_or_error",
  "expr_1", "call_expr", "member_expr", "ctor", "ctor_expr", "tuple",
  "opt_tuple_elems1", "opt_tuple_elems2", "tuple_elem", "tuple_expr",
  "list", "set", "map", "struct_", "struct_elems", "struct_elem", "regexp",
  "re_patterns", "re_pattern_constant", "$@4", "$@5",
  "opt_re_pattern_constant_flags", "opt_map_elems", "map_elems",
  "map_elem", "attribute", "opt_attributes", YY_NULLPTR
  };
#endif


#if YYDEBUG
  const short
  Parser::yyrline_[] =
  {
       0,   305,   305,   314,   326,   327,   329,   331,   329,   336,
     338,   340,   344,   345,   346,   347,   348,   349,   351,   354,
     356,   360,   361,   362,   364,   369,   371,   375,   377,   379,
     381,   386,   387,   389,   391,   394,   395,   399,   400,   404,
     405,   407,   408,   409,   410,   411,   415,   416,   419,   420,
     421,   424,   431,   438,   445,   451,   452,   454,   455,   457,
     458,   459,   461,   462,   464,   465,   467,   471,   472,   476,
     477,   478,   481,   482,   487,   494,   496,   497,   499,   500,
     502,   503,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   514,   516,   518,   520,   522,   524,   526,   528,   530,
     532,   533,   535,   538,   546,   554,   564,   565,   568,   569,
     571,   572,   574,   575,   577,   578,   580,   581,   583,   585,
     587,   588,   589,   592,   597,   598,   599,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   610,   611,   613,
     614,   615,   616,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   629,   630,   631,   632,   633,   634,   635,
     636,   638,   639,   641,   642,   645,   646,   647,   648,   649,
     652,   655,   656,   657,   660,   661,   662,   666,   670,   673,
     677,   678,   682,   684,   688,   689,   692,   695,   696,   698,
     699,   701,   702,   706,   712,   715,   716,   718,   719,   721,
     723,   724,   726,   727,   728,   731,   732,   736,   735,   741,
     743,   746,   748,   751,   753,   757,   761,   763,   764,   766,
     767,   769,   770,   773,   774,   775,   776,   777,   778,   779,
     780,   781,   782,   783,   784,   785,   786,   787,   788,   789,
     790,   791,   792,   793,   794,   795,   796,   797,   798,   799,
     800,   801,   802,   803,   804,   805,   806,   807,   808,   809,
     810,   811,   812,   813,   814,   815,   816,   817,   818,   819,
     820,   821,   822,   823,   824,   825,   826,   827,   828,   829,
     830,   831,   832,   833,   836,   840,   841,   845,   846,   847,
     848,   849,   854,   855,   856,   858,   859,   860,   865,   866,
     868,   869,   870,   871,   872,   873,   876,   877,   878,   879,
     880,   881,   882,   883,   884,   885,   886,   887,   888,   889,
     890,   893,   896,   897,   898,   901,   902,   903,   906,   909,
     911,   912,   913,   915,   916,   919,   920,   923,   924,   927,
     929,   930,   932,   934,   936,   938,   941,   941,   941,   948,
     956,   961,   963,   964,   966,   967,   969,   972,   979,   988,
     993
  };

  void
  Parser::yy_stack_print_ () const
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << int (i->state);
    *yycdebug_ << '\n';
  }

  void
  Parser::yy_reduce_print_ (int yyrule) const
  {
    int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):\n";
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // YYDEBUG

  Parser::symbol_kind_type
  Parser::yytranslate_ (int t) YY_NOEXCEPT
  {
    // YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to
    // TOKEN-NUM as returned by yylex.
    static
    const unsigned char
    translate_table[] =
    {
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   174,     2,     2,   176,   161,   158,     2,
     170,   171,   162,   159,   172,   160,   165,   163,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   153,   169,
     154,   151,   155,   152,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   166,     2,   173,   157,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   167,   156,   168,   175,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   164
    };
    // Last valid token kind.
    const int code_max = 406;

    if (t <= 0)
      return symbol_kind::S_YYEOF;
    else if (t <= code_max)
      return static_cast <symbol_kind_type> (translate_table[t]);
    else
      return symbol_kind::S_YYUNDEF;
  }

#line 29 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
} } } // hilti::detail::parser
#line 7015 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.cc"

#line 995 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"


void hilti::detail::parser::Parser::error(const Parser::location_type& l, const std::string& m) {
    driver->error(m, toMeta(l));
}
