// A Bison parser, made by GNU Bison 3.8.2.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.



// First part of user prologue.
#line 11 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"

namespace spicy { namespace detail { class Parser; } }

#include <hilti/compiler/context.h>
#include <spicy/compiler/detail/parser/driver.h>
#include <spicy/ast/builder/builder.h>

#line 41 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"


#include <spicy/compiler/detail/parser/scanner.h>

#undef yylex
#define yylex driver->scanner()->lex

static hilti::Meta toMeta(spicy::detail::parser::location l) {
    return hilti::Meta(hilti::Location(*l.begin.filename, l.begin.line, l.end.line, l.begin.column,
                                       (l.end.column > 0 ? l.end.column - 1 : 0)));
}

static hilti::QualifiedType* iteratorForType(spicy::Builder* builder, hilti::QualifiedType* t, hilti::Meta m) {
    if ( auto iter = t->type()->iteratorType() )
        return iter;
    else {
        hilti::logger().error(hilti::util::fmt("type '%s' is not iterable", *t), m.location());
        return builder->qualifiedType(builder->typeError(), hilti::Constness::Const);
        }
}

static hilti::QualifiedType* viewForType(spicy::Builder* builder, hilti::QualifiedType* t, hilti::Meta m) {
    if ( auto v = t->type()->viewType() )
        return v;
    else {
        hilti::logger().error(hilti::util::fmt("type '%s' is not viewable", *t), m.location());
        return builder->qualifiedType(builder->typeError(), hilti::Constness::Const);
        }
}

/**
 * Checks if an unsigned integer value can be represented as an int64_t.
 *
 * @param x value to check
 * @param positive if false, check if ``-x`` can be represented instead of ``x`` itself.
 * @param m location information to associate with error message.
 * @return *x* on success, or zero on failure as a temporary stand-in; in the
 * latter cases an error is reported, too
 */
static uint64_t check_int64_range(uint64_t x, bool positive, const hilti::Meta& m) {
    uint64_t max = (positive ? std::numeric_limits<int64_t>::max() : std::fabs(std::numeric_limits<int64_t>::min()));
    if ( x <= max )
        return x;

    hilti::logger().error("signed integer value out of range", m.location());
    return 0; // Return dummy value
}

#define __loc__ toMeta(yylhs.location)

#define YYLLOC_DEFAULT(Current, Rhs, N)                                                                                \
do {                                                                                                                   \
    bool done = false;                                                                                                 \
    for ( int i = 1; i <= N; i++ ) {                                                                                   \
        if ( YYRHSLOC(Rhs, i).begin.line != YYRHSLOC(Rhs, i).end.line ||                                               \
             YYRHSLOC(Rhs, i).begin.column != YYRHSLOC(Rhs, i).end.column ) {                                          \
            (Current).begin = YYRHSLOC(Rhs, i).begin;                                                                  \
            (Current).end = YYRHSLOC(Rhs, N).end;                                                                      \
            done = true;                                                                                               \
            break;                                                                                                     \
        }                                                                                                              \
    }                                                                                                                  \
    if ( ! done )                                                                                                      \
        (Current).begin = (Current).end = YYRHSLOC(Rhs, 0).end;                                                        \
} while ( false )

static int _field_width = 0;

// We keep a stack of doc strings here that's maintained during parsing. There
// would actually be a much nicer way of doing this through Bison's mid-action
// rules, but unfortunately those have a bug with Bison < 3.1 that prevents
// passing results back from a mid-action rule; see
// https://stackoverflow.com/questions/44811550/bison-c-mid-rule-value-lost-with-variants.
//
// Bison 3.1 fixes this and introduces a new, nicer typing syntax for
// mid-action rules as well; see
// https://www.gnu.org/software/bison/manual/html_node/Typed-Mid_002dRule-Actions.html#Typed-Mid_002dRule-Actions
// Unfortunately, we cannot rely on having 3.1 yet, because some of our
// supported platforms do not provide it. Once we can, we should get rid of
// this stack and move to that new syntax instead.
static std::vector<hilti::DocString> _docs;


#line 133 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"


#include "__parser.h"




#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif


// Whether we are compiled with exception support.
#ifndef YY_EXCEPTIONS
# if defined __GNUC__ && !defined __EXCEPTIONS
#  define YY_EXCEPTIONS 0
# else
#  define YY_EXCEPTIONS 1
# endif
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K].location)
/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

# ifndef YYLLOC_DEFAULT
#  define YYLLOC_DEFAULT(Current, Rhs, N)                               \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).begin  = YYRHSLOC (Rhs, 1).begin;                   \
          (Current).end    = YYRHSLOC (Rhs, N).end;                     \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).begin = (Current).end = YYRHSLOC (Rhs, 0).end;      \
        }                                                               \
    while (false)
# endif


// Enable debugging if requested.
#if YYDEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << '\n';                       \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yy_stack_print_ ();                \
  } while (false)

#else // !YYDEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YY_USE (Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void> (0)
# define YY_STACK_PRINT()                static_cast<void> (0)

#endif // !YYDEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyla.clear ())

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)

#line 29 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
namespace spicy { namespace detail { namespace parser {
#line 231 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"

  /// Build a parser object.
  Parser::Parser (Driver* driver_yyarg, Builder* builder_yyarg)
#if YYDEBUG
    : yydebug_ (false),
      yycdebug_ (&std::cerr),
#else
    :
#endif
      driver (driver_yyarg),
      builder (builder_yyarg)
  {}

  Parser::~Parser ()
  {}

  Parser::syntax_error::~syntax_error () YY_NOEXCEPT YY_NOTHROW
  {}

  /*---------.
  | symbol.  |
  `---------*/

  // basic_symbol.
  template <typename Base>
  Parser::basic_symbol<Base>::basic_symbol (const basic_symbol& that)
    : Base (that)
    , value ()
    , location (that.location)
  {
    switch (this->kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
      case symbol_kind::S_opt_skip: // opt_skip
      case symbol_kind::S_opt_skip_: // opt_skip_
        value.copy< bool > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.copy< double > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_hook_attribute: // unit_hook_attribute
      case symbol_kind::S_attribute: // attribute
        value.copy< hilti::Attribute* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_unit_hook_attributes: // opt_unit_hook_attributes
      case symbol_kind::S_opt_attributes: // opt_attributes
        value.copy< hilti::AttributeSet* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_field_ctor: // unit_field_ctor
      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_vector: // vector
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.copy< hilti::Ctor* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_hook_decl: // hook_decl
      case symbol_kind::S_struct_field: // struct_field
        value.copy< hilti::Declaration* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_fields: // struct_fields
        value.copy< hilti::Declarations > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_init_expression: // opt_init_expression
      case symbol_kind::S_opt_bitfield_range_value: // opt_bitfield_range_value
      case symbol_kind::S_unit_field_repeat: // unit_field_repeat
      case symbol_kind::S_opt_unit_field_repeat: // opt_unit_field_repeat
      case symbol_kind::S_opt_unit_field_condition: // opt_unit_field_condition
      case symbol_kind::S_opt_unit_switch_expr: // opt_unit_switch_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.copy< hilti::Expression* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_unit_field_args: // opt_unit_field_args
      case symbol_kind::S_opt_unit_field_sinks: // opt_unit_field_sinks
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.copy< hilti::Expressions > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_opt_unit_field_id: // opt_unit_field_id
      case symbol_kind::S_unit_hook_id: // unit_hook_id
        value.copy< hilti::ID > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_func_result: // func_result
      case symbol_kind::S_opt_func_result: // opt_func_result
      case symbol_kind::S_qtype: // qtype
      case symbol_kind::S_unit_field_base_type: // unit_field_base_type
        value.copy< hilti::QualifiedType* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.copy< hilti::Statement* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.copy< hilti::Statements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_base_type_no_ref: // base_type_no_ref
      case symbol_kind::S_reference_type: // reference_type
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_type_no_ref: // type_no_ref
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
      case symbol_kind::S_unit_type: // unit_type
        value.copy< hilti::UnqualifiedType* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.copy< hilti::ctor::map::Element* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.copy< hilti::ctor::map::Elements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.copy< hilti::ctor::regexp::Pattern > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.copy< hilti::ctor::regexp::Patterns > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.copy< hilti::ctor::struct_::Field* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.copy< hilti::ctor::struct_::Fields > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.copy< hilti::declaration::Linkage > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_unit_params: // opt_unit_params
      case symbol_kind::S_opt_unit_hook_params: // opt_unit_hook_params
        value.copy< hilti::declaration::Parameters > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.copy< hilti::parameter::Kind > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.copy< hilti::statement::switch_::Case* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_switch_cases: // switch_cases
        value.copy< hilti::statement::switch_::Cases > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.copy< hilti::type::bitfield::BitRange* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.copy< hilti::type::bitfield::BitRanges > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.copy< hilti::type::enum_::Label* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.copy< hilti::type::enum_::Labels > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.copy< hilti::type::function::CallingConvention > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
        value.copy< hilti::type::function::Flavor > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_func_param: // func_param
        value.copy< hilti::type::function::Parameter* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.copy< hilti::type::tuple::Element* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.copy< hilti::type::tuple::Elements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_const_sint: // const_sint
        value.copy< int64_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_hook: // unit_hook
        value.copy< spicy::declaration::Hook* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_unit_item_hooks: // opt_unit_item_hooks
      case symbol_kind::S_unit_hooks: // unit_hooks
        value.copy< spicy::declaration::Hooks > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_item: // unit_item
      case symbol_kind::S_unit_variable: // unit_variable
      case symbol_kind::S_unit_sink: // unit_sink
      case symbol_kind::S_unit_property: // unit_property
      case symbol_kind::S_unit_field: // unit_field
      case symbol_kind::S_unit_field_in_container: // unit_field_in_container
      case symbol_kind::S_scoped_id_in_container: // scoped_id_in_container
      case symbol_kind::S_unit_wide_hook: // unit_wide_hook
      case symbol_kind::S_unit_switch: // unit_switch
      case symbol_kind::S_unit_block: // unit_block
        value.copy< spicy::type::unit::Item* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_items: // unit_items
      case symbol_kind::S_opt_unit_items: // opt_unit_items
      case symbol_kind::S_opt_unit_block_else_items: // opt_unit_block_else_items
        value.copy< spicy::type::unit::Items > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_switch_case: // unit_switch_case
        value.copy< spicy::type::unit::item::switch_::Case* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_switch_cases: // unit_switch_cases
        value.copy< spicy::type::unit::item::switch_::Cases > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.copy< std::pair<hilti::Declarations, hilti::Statements> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_decl_type_and_init: // global_decl_type_and_init
        value.copy< std::pair<hilti::QualifiedType*, hilti::Expression*> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_HOOK_IDENT: // "hook identifier"
      case symbol_kind::S_DOLLAR_IDENT: // "$-identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_PREPROCESSOR: // "preprocessor directive"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CERROR: // "error value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.copy< std::string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
      case symbol_kind::S_DOLLAR_NUMBER: // "$<N>"
      case symbol_kind::S_const_uint: // const_uint
        value.copy< uint64_t > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

  }




  template <typename Base>
  Parser::symbol_kind_type
  Parser::basic_symbol<Base>::type_get () const YY_NOEXCEPT
  {
    return this->kind ();
  }


  template <typename Base>
  bool
  Parser::basic_symbol<Base>::empty () const YY_NOEXCEPT
  {
    return this->kind () == symbol_kind::S_YYEMPTY;
  }

  template <typename Base>
  void
  Parser::basic_symbol<Base>::move (basic_symbol& s)
  {
    super_type::move (s);
    switch (this->kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
      case symbol_kind::S_opt_skip: // opt_skip
      case symbol_kind::S_opt_skip_: // opt_skip_
        value.move< bool > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.move< double > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_unit_hook_attribute: // unit_hook_attribute
      case symbol_kind::S_attribute: // attribute
        value.move< hilti::Attribute* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_unit_hook_attributes: // opt_unit_hook_attributes
      case symbol_kind::S_opt_attributes: // opt_attributes
        value.move< hilti::AttributeSet* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_unit_field_ctor: // unit_field_ctor
      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_vector: // vector
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.move< hilti::Ctor* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_hook_decl: // hook_decl
      case symbol_kind::S_struct_field: // struct_field
        value.move< hilti::Declaration* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_struct_fields: // struct_fields
        value.move< hilti::Declarations > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_init_expression: // opt_init_expression
      case symbol_kind::S_opt_bitfield_range_value: // opt_bitfield_range_value
      case symbol_kind::S_unit_field_repeat: // unit_field_repeat
      case symbol_kind::S_opt_unit_field_repeat: // opt_unit_field_repeat
      case symbol_kind::S_opt_unit_field_condition: // opt_unit_field_condition
      case symbol_kind::S_opt_unit_switch_expr: // opt_unit_switch_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.move< hilti::Expression* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_unit_field_args: // opt_unit_field_args
      case symbol_kind::S_opt_unit_field_sinks: // opt_unit_field_sinks
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.move< hilti::Expressions > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_opt_unit_field_id: // opt_unit_field_id
      case symbol_kind::S_unit_hook_id: // unit_hook_id
        value.move< hilti::ID > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_func_result: // func_result
      case symbol_kind::S_opt_func_result: // opt_func_result
      case symbol_kind::S_qtype: // qtype
      case symbol_kind::S_unit_field_base_type: // unit_field_base_type
        value.move< hilti::QualifiedType* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.move< hilti::Statement* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.move< hilti::Statements > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_base_type_no_ref: // base_type_no_ref
      case symbol_kind::S_reference_type: // reference_type
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_type_no_ref: // type_no_ref
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
      case symbol_kind::S_unit_type: // unit_type
        value.move< hilti::UnqualifiedType* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.move< hilti::ctor::map::Element* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.move< hilti::ctor::map::Elements > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.move< hilti::ctor::regexp::Pattern > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.move< hilti::ctor::regexp::Patterns > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.move< hilti::ctor::struct_::Field* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.move< hilti::ctor::struct_::Fields > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.move< hilti::declaration::Linkage > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_unit_params: // opt_unit_params
      case symbol_kind::S_opt_unit_hook_params: // opt_unit_hook_params
        value.move< hilti::declaration::Parameters > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.move< hilti::parameter::Kind > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.move< hilti::statement::switch_::Case* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_switch_cases: // switch_cases
        value.move< hilti::statement::switch_::Cases > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.move< hilti::type::bitfield::BitRange* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.move< hilti::type::bitfield::BitRanges > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.move< hilti::type::enum_::Label* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.move< hilti::type::enum_::Labels > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.move< hilti::type::function::CallingConvention > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
        value.move< hilti::type::function::Flavor > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_func_param: // func_param
        value.move< hilti::type::function::Parameter* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.move< hilti::type::tuple::Element* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.move< hilti::type::tuple::Elements > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_const_sint: // const_sint
        value.move< int64_t > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_unit_hook: // unit_hook
        value.move< spicy::declaration::Hook* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_opt_unit_item_hooks: // opt_unit_item_hooks
      case symbol_kind::S_unit_hooks: // unit_hooks
        value.move< spicy::declaration::Hooks > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_unit_item: // unit_item
      case symbol_kind::S_unit_variable: // unit_variable
      case symbol_kind::S_unit_sink: // unit_sink
      case symbol_kind::S_unit_property: // unit_property
      case symbol_kind::S_unit_field: // unit_field
      case symbol_kind::S_unit_field_in_container: // unit_field_in_container
      case symbol_kind::S_scoped_id_in_container: // scoped_id_in_container
      case symbol_kind::S_unit_wide_hook: // unit_wide_hook
      case symbol_kind::S_unit_switch: // unit_switch
      case symbol_kind::S_unit_block: // unit_block
        value.move< spicy::type::unit::Item* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_unit_items: // unit_items
      case symbol_kind::S_opt_unit_items: // opt_unit_items
      case symbol_kind::S_opt_unit_block_else_items: // opt_unit_block_else_items
        value.move< spicy::type::unit::Items > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_unit_switch_case: // unit_switch_case
        value.move< spicy::type::unit::item::switch_::Case* > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_unit_switch_cases: // unit_switch_cases
        value.move< spicy::type::unit::item::switch_::Cases > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.move< std::pair<hilti::Declarations, hilti::Statements> > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_global_decl_type_and_init: // global_decl_type_and_init
        value.move< std::pair<hilti::QualifiedType*, hilti::Expression*> > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_HOOK_IDENT: // "hook identifier"
      case symbol_kind::S_DOLLAR_IDENT: // "$-identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_PREPROCESSOR: // "preprocessor directive"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CERROR: // "error value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.move< std::string > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
      case symbol_kind::S_DOLLAR_NUMBER: // "$<N>"
      case symbol_kind::S_const_uint: // const_uint
        value.move< uint64_t > (YY_MOVE (s.value));
        break;

      default:
        break;
    }

    location = YY_MOVE (s.location);
  }

  // by_kind.
  Parser::by_kind::by_kind () YY_NOEXCEPT
    : kind_ (symbol_kind::S_YYEMPTY)
  {}

#if 201103L <= YY_CPLUSPLUS
  Parser::by_kind::by_kind (by_kind&& that) YY_NOEXCEPT
    : kind_ (that.kind_)
  {
    that.clear ();
  }
#endif

  Parser::by_kind::by_kind (const by_kind& that) YY_NOEXCEPT
    : kind_ (that.kind_)
  {}

  Parser::by_kind::by_kind (token_kind_type t) YY_NOEXCEPT
    : kind_ (yytranslate_ (t))
  {}



  void
  Parser::by_kind::clear () YY_NOEXCEPT
  {
    kind_ = symbol_kind::S_YYEMPTY;
  }

  void
  Parser::by_kind::move (by_kind& that)
  {
    kind_ = that.kind_;
    that.clear ();
  }

  Parser::symbol_kind_type
  Parser::by_kind::kind () const YY_NOEXCEPT
  {
    return kind_;
  }


  Parser::symbol_kind_type
  Parser::by_kind::type_get () const YY_NOEXCEPT
  {
    return this->kind ();
  }



  // by_state.
  Parser::by_state::by_state () YY_NOEXCEPT
    : state (empty_state)
  {}

  Parser::by_state::by_state (const by_state& that) YY_NOEXCEPT
    : state (that.state)
  {}

  void
  Parser::by_state::clear () YY_NOEXCEPT
  {
    state = empty_state;
  }

  void
  Parser::by_state::move (by_state& that)
  {
    state = that.state;
    that.clear ();
  }

  Parser::by_state::by_state (state_type s) YY_NOEXCEPT
    : state (s)
  {}

  Parser::symbol_kind_type
  Parser::by_state::kind () const YY_NOEXCEPT
  {
    if (state == empty_state)
      return symbol_kind::S_YYEMPTY;
    else
      return YY_CAST (symbol_kind_type, yystos_[+state]);
  }

  Parser::stack_symbol_type::stack_symbol_type ()
  {}

  Parser::stack_symbol_type::stack_symbol_type (YY_RVREF (stack_symbol_type) that)
    : super_type (YY_MOVE (that.state), YY_MOVE (that.location))
  {
    switch (that.kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
      case symbol_kind::S_opt_skip: // opt_skip
      case symbol_kind::S_opt_skip_: // opt_skip_
        value.YY_MOVE_OR_COPY< bool > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.YY_MOVE_OR_COPY< double > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_hook_attribute: // unit_hook_attribute
      case symbol_kind::S_attribute: // attribute
        value.YY_MOVE_OR_COPY< hilti::Attribute* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_unit_hook_attributes: // opt_unit_hook_attributes
      case symbol_kind::S_opt_attributes: // opt_attributes
        value.YY_MOVE_OR_COPY< hilti::AttributeSet* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_field_ctor: // unit_field_ctor
      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_vector: // vector
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.YY_MOVE_OR_COPY< hilti::Ctor* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_hook_decl: // hook_decl
      case symbol_kind::S_struct_field: // struct_field
        value.YY_MOVE_OR_COPY< hilti::Declaration* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_fields: // struct_fields
        value.YY_MOVE_OR_COPY< hilti::Declarations > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_init_expression: // opt_init_expression
      case symbol_kind::S_opt_bitfield_range_value: // opt_bitfield_range_value
      case symbol_kind::S_unit_field_repeat: // unit_field_repeat
      case symbol_kind::S_opt_unit_field_repeat: // opt_unit_field_repeat
      case symbol_kind::S_opt_unit_field_condition: // opt_unit_field_condition
      case symbol_kind::S_opt_unit_switch_expr: // opt_unit_switch_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.YY_MOVE_OR_COPY< hilti::Expression* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_unit_field_args: // opt_unit_field_args
      case symbol_kind::S_opt_unit_field_sinks: // opt_unit_field_sinks
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.YY_MOVE_OR_COPY< hilti::Expressions > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_opt_unit_field_id: // opt_unit_field_id
      case symbol_kind::S_unit_hook_id: // unit_hook_id
        value.YY_MOVE_OR_COPY< hilti::ID > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_func_result: // func_result
      case symbol_kind::S_opt_func_result: // opt_func_result
      case symbol_kind::S_qtype: // qtype
      case symbol_kind::S_unit_field_base_type: // unit_field_base_type
        value.YY_MOVE_OR_COPY< hilti::QualifiedType* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.YY_MOVE_OR_COPY< hilti::Statement* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.YY_MOVE_OR_COPY< hilti::Statements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_base_type_no_ref: // base_type_no_ref
      case symbol_kind::S_reference_type: // reference_type
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_type_no_ref: // type_no_ref
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
      case symbol_kind::S_unit_type: // unit_type
        value.YY_MOVE_OR_COPY< hilti::UnqualifiedType* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.YY_MOVE_OR_COPY< hilti::ctor::map::Element* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.YY_MOVE_OR_COPY< hilti::ctor::map::Elements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.YY_MOVE_OR_COPY< hilti::ctor::regexp::Pattern > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.YY_MOVE_OR_COPY< hilti::ctor::regexp::Patterns > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.YY_MOVE_OR_COPY< hilti::ctor::struct_::Field* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.YY_MOVE_OR_COPY< hilti::ctor::struct_::Fields > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.YY_MOVE_OR_COPY< hilti::declaration::Linkage > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_unit_params: // opt_unit_params
      case symbol_kind::S_opt_unit_hook_params: // opt_unit_hook_params
        value.YY_MOVE_OR_COPY< hilti::declaration::Parameters > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.YY_MOVE_OR_COPY< hilti::parameter::Kind > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.YY_MOVE_OR_COPY< hilti::statement::switch_::Case* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_switch_cases: // switch_cases
        value.YY_MOVE_OR_COPY< hilti::statement::switch_::Cases > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.YY_MOVE_OR_COPY< hilti::type::bitfield::BitRange* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.YY_MOVE_OR_COPY< hilti::type::bitfield::BitRanges > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.YY_MOVE_OR_COPY< hilti::type::enum_::Label* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.YY_MOVE_OR_COPY< hilti::type::enum_::Labels > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.YY_MOVE_OR_COPY< hilti::type::function::CallingConvention > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
        value.YY_MOVE_OR_COPY< hilti::type::function::Flavor > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_func_param: // func_param
        value.YY_MOVE_OR_COPY< hilti::type::function::Parameter* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.YY_MOVE_OR_COPY< hilti::type::tuple::Element* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.YY_MOVE_OR_COPY< hilti::type::tuple::Elements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_const_sint: // const_sint
        value.YY_MOVE_OR_COPY< int64_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_hook: // unit_hook
        value.YY_MOVE_OR_COPY< spicy::declaration::Hook* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_unit_item_hooks: // opt_unit_item_hooks
      case symbol_kind::S_unit_hooks: // unit_hooks
        value.YY_MOVE_OR_COPY< spicy::declaration::Hooks > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_item: // unit_item
      case symbol_kind::S_unit_variable: // unit_variable
      case symbol_kind::S_unit_sink: // unit_sink
      case symbol_kind::S_unit_property: // unit_property
      case symbol_kind::S_unit_field: // unit_field
      case symbol_kind::S_unit_field_in_container: // unit_field_in_container
      case symbol_kind::S_scoped_id_in_container: // scoped_id_in_container
      case symbol_kind::S_unit_wide_hook: // unit_wide_hook
      case symbol_kind::S_unit_switch: // unit_switch
      case symbol_kind::S_unit_block: // unit_block
        value.YY_MOVE_OR_COPY< spicy::type::unit::Item* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_items: // unit_items
      case symbol_kind::S_opt_unit_items: // opt_unit_items
      case symbol_kind::S_opt_unit_block_else_items: // opt_unit_block_else_items
        value.YY_MOVE_OR_COPY< spicy::type::unit::Items > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_switch_case: // unit_switch_case
        value.YY_MOVE_OR_COPY< spicy::type::unit::item::switch_::Case* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_switch_cases: // unit_switch_cases
        value.YY_MOVE_OR_COPY< spicy::type::unit::item::switch_::Cases > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.YY_MOVE_OR_COPY< std::pair<hilti::Declarations, hilti::Statements> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_decl_type_and_init: // global_decl_type_and_init
        value.YY_MOVE_OR_COPY< std::pair<hilti::QualifiedType*, hilti::Expression*> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_HOOK_IDENT: // "hook identifier"
      case symbol_kind::S_DOLLAR_IDENT: // "$-identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_PREPROCESSOR: // "preprocessor directive"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CERROR: // "error value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.YY_MOVE_OR_COPY< std::string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
      case symbol_kind::S_DOLLAR_NUMBER: // "$<N>"
      case symbol_kind::S_const_uint: // const_uint
        value.YY_MOVE_OR_COPY< uint64_t > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

#if 201103L <= YY_CPLUSPLUS
    // that is emptied.
    that.state = empty_state;
#endif
  }

  Parser::stack_symbol_type::stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) that)
    : super_type (s, YY_MOVE (that.location))
  {
    switch (that.kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
      case symbol_kind::S_opt_skip: // opt_skip
      case symbol_kind::S_opt_skip_: // opt_skip_
        value.move< bool > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.move< double > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_hook_attribute: // unit_hook_attribute
      case symbol_kind::S_attribute: // attribute
        value.move< hilti::Attribute* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_unit_hook_attributes: // opt_unit_hook_attributes
      case symbol_kind::S_opt_attributes: // opt_attributes
        value.move< hilti::AttributeSet* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_field_ctor: // unit_field_ctor
      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_vector: // vector
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.move< hilti::Ctor* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_hook_decl: // hook_decl
      case symbol_kind::S_struct_field: // struct_field
        value.move< hilti::Declaration* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_fields: // struct_fields
        value.move< hilti::Declarations > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_init_expression: // opt_init_expression
      case symbol_kind::S_opt_bitfield_range_value: // opt_bitfield_range_value
      case symbol_kind::S_unit_field_repeat: // unit_field_repeat
      case symbol_kind::S_opt_unit_field_repeat: // opt_unit_field_repeat
      case symbol_kind::S_opt_unit_field_condition: // opt_unit_field_condition
      case symbol_kind::S_opt_unit_switch_expr: // opt_unit_switch_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.move< hilti::Expression* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_unit_field_args: // opt_unit_field_args
      case symbol_kind::S_opt_unit_field_sinks: // opt_unit_field_sinks
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.move< hilti::Expressions > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_opt_unit_field_id: // opt_unit_field_id
      case symbol_kind::S_unit_hook_id: // unit_hook_id
        value.move< hilti::ID > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_func_result: // func_result
      case symbol_kind::S_opt_func_result: // opt_func_result
      case symbol_kind::S_qtype: // qtype
      case symbol_kind::S_unit_field_base_type: // unit_field_base_type
        value.move< hilti::QualifiedType* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.move< hilti::Statement* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.move< hilti::Statements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_base_type_no_ref: // base_type_no_ref
      case symbol_kind::S_reference_type: // reference_type
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_type_no_ref: // type_no_ref
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
      case symbol_kind::S_unit_type: // unit_type
        value.move< hilti::UnqualifiedType* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.move< hilti::ctor::map::Element* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.move< hilti::ctor::map::Elements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.move< hilti::ctor::regexp::Pattern > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.move< hilti::ctor::regexp::Patterns > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.move< hilti::ctor::struct_::Field* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.move< hilti::ctor::struct_::Fields > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.move< hilti::declaration::Linkage > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_unit_params: // opt_unit_params
      case symbol_kind::S_opt_unit_hook_params: // opt_unit_hook_params
        value.move< hilti::declaration::Parameters > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.move< hilti::parameter::Kind > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.move< hilti::statement::switch_::Case* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_switch_cases: // switch_cases
        value.move< hilti::statement::switch_::Cases > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.move< hilti::type::bitfield::BitRange* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.move< hilti::type::bitfield::BitRanges > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.move< hilti::type::enum_::Label* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.move< hilti::type::enum_::Labels > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.move< hilti::type::function::CallingConvention > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
        value.move< hilti::type::function::Flavor > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_func_param: // func_param
        value.move< hilti::type::function::Parameter* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.move< hilti::type::tuple::Element* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.move< hilti::type::tuple::Elements > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_const_sint: // const_sint
        value.move< int64_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_hook: // unit_hook
        value.move< spicy::declaration::Hook* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_opt_unit_item_hooks: // opt_unit_item_hooks
      case symbol_kind::S_unit_hooks: // unit_hooks
        value.move< spicy::declaration::Hooks > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_item: // unit_item
      case symbol_kind::S_unit_variable: // unit_variable
      case symbol_kind::S_unit_sink: // unit_sink
      case symbol_kind::S_unit_property: // unit_property
      case symbol_kind::S_unit_field: // unit_field
      case symbol_kind::S_unit_field_in_container: // unit_field_in_container
      case symbol_kind::S_scoped_id_in_container: // scoped_id_in_container
      case symbol_kind::S_unit_wide_hook: // unit_wide_hook
      case symbol_kind::S_unit_switch: // unit_switch
      case symbol_kind::S_unit_block: // unit_block
        value.move< spicy::type::unit::Item* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_items: // unit_items
      case symbol_kind::S_opt_unit_items: // opt_unit_items
      case symbol_kind::S_opt_unit_block_else_items: // opt_unit_block_else_items
        value.move< spicy::type::unit::Items > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_switch_case: // unit_switch_case
        value.move< spicy::type::unit::item::switch_::Case* > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_unit_switch_cases: // unit_switch_cases
        value.move< spicy::type::unit::item::switch_::Cases > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.move< std::pair<hilti::Declarations, hilti::Statements> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_global_decl_type_and_init: // global_decl_type_and_init
        value.move< std::pair<hilti::QualifiedType*, hilti::Expression*> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_HOOK_IDENT: // "hook identifier"
      case symbol_kind::S_DOLLAR_IDENT: // "$-identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_PREPROCESSOR: // "preprocessor directive"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CERROR: // "error value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.move< std::string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
      case symbol_kind::S_DOLLAR_NUMBER: // "$<N>"
      case symbol_kind::S_const_uint: // const_uint
        value.move< uint64_t > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

    // that is emptied.
    that.kind_ = symbol_kind::S_YYEMPTY;
  }

#if YY_CPLUSPLUS < 201103L
  Parser::stack_symbol_type&
  Parser::stack_symbol_type::operator= (const stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
      case symbol_kind::S_opt_skip: // opt_skip
      case symbol_kind::S_opt_skip_: // opt_skip_
        value.copy< bool > (that.value);
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.copy< double > (that.value);
        break;

      case symbol_kind::S_unit_hook_attribute: // unit_hook_attribute
      case symbol_kind::S_attribute: // attribute
        value.copy< hilti::Attribute* > (that.value);
        break;

      case symbol_kind::S_opt_unit_hook_attributes: // opt_unit_hook_attributes
      case symbol_kind::S_opt_attributes: // opt_attributes
        value.copy< hilti::AttributeSet* > (that.value);
        break;

      case symbol_kind::S_unit_field_ctor: // unit_field_ctor
      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_vector: // vector
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.copy< hilti::Ctor* > (that.value);
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_hook_decl: // hook_decl
      case symbol_kind::S_struct_field: // struct_field
        value.copy< hilti::Declaration* > (that.value);
        break;

      case symbol_kind::S_struct_fields: // struct_fields
        value.copy< hilti::Declarations > (that.value);
        break;

      case symbol_kind::S_opt_init_expression: // opt_init_expression
      case symbol_kind::S_opt_bitfield_range_value: // opt_bitfield_range_value
      case symbol_kind::S_unit_field_repeat: // unit_field_repeat
      case symbol_kind::S_opt_unit_field_repeat: // opt_unit_field_repeat
      case symbol_kind::S_opt_unit_field_condition: // opt_unit_field_condition
      case symbol_kind::S_opt_unit_switch_expr: // opt_unit_switch_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.copy< hilti::Expression* > (that.value);
        break;

      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_unit_field_args: // opt_unit_field_args
      case symbol_kind::S_opt_unit_field_sinks: // opt_unit_field_sinks
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.copy< hilti::Expressions > (that.value);
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_opt_unit_field_id: // opt_unit_field_id
      case symbol_kind::S_unit_hook_id: // unit_hook_id
        value.copy< hilti::ID > (that.value);
        break;

      case symbol_kind::S_func_result: // func_result
      case symbol_kind::S_opt_func_result: // opt_func_result
      case symbol_kind::S_qtype: // qtype
      case symbol_kind::S_unit_field_base_type: // unit_field_base_type
        value.copy< hilti::QualifiedType* > (that.value);
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.copy< hilti::Statement* > (that.value);
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.copy< hilti::Statements > (that.value);
        break;

      case symbol_kind::S_base_type_no_ref: // base_type_no_ref
      case symbol_kind::S_reference_type: // reference_type
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_type_no_ref: // type_no_ref
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
      case symbol_kind::S_unit_type: // unit_type
        value.copy< hilti::UnqualifiedType* > (that.value);
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.copy< hilti::ctor::map::Element* > (that.value);
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.copy< hilti::ctor::map::Elements > (that.value);
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.copy< hilti::ctor::regexp::Pattern > (that.value);
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.copy< hilti::ctor::regexp::Patterns > (that.value);
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.copy< hilti::ctor::struct_::Field* > (that.value);
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.copy< hilti::ctor::struct_::Fields > (that.value);
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.copy< hilti::declaration::Linkage > (that.value);
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_unit_params: // opt_unit_params
      case symbol_kind::S_opt_unit_hook_params: // opt_unit_hook_params
        value.copy< hilti::declaration::Parameters > (that.value);
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.copy< hilti::parameter::Kind > (that.value);
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.copy< hilti::statement::switch_::Case* > (that.value);
        break;

      case symbol_kind::S_switch_cases: // switch_cases
        value.copy< hilti::statement::switch_::Cases > (that.value);
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.copy< hilti::type::bitfield::BitRange* > (that.value);
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.copy< hilti::type::bitfield::BitRanges > (that.value);
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.copy< hilti::type::enum_::Label* > (that.value);
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.copy< hilti::type::enum_::Labels > (that.value);
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.copy< hilti::type::function::CallingConvention > (that.value);
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
        value.copy< hilti::type::function::Flavor > (that.value);
        break;

      case symbol_kind::S_func_param: // func_param
        value.copy< hilti::type::function::Parameter* > (that.value);
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.copy< hilti::type::tuple::Element* > (that.value);
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.copy< hilti::type::tuple::Elements > (that.value);
        break;

      case symbol_kind::S_const_sint: // const_sint
        value.copy< int64_t > (that.value);
        break;

      case symbol_kind::S_unit_hook: // unit_hook
        value.copy< spicy::declaration::Hook* > (that.value);
        break;

      case symbol_kind::S_opt_unit_item_hooks: // opt_unit_item_hooks
      case symbol_kind::S_unit_hooks: // unit_hooks
        value.copy< spicy::declaration::Hooks > (that.value);
        break;

      case symbol_kind::S_unit_item: // unit_item
      case symbol_kind::S_unit_variable: // unit_variable
      case symbol_kind::S_unit_sink: // unit_sink
      case symbol_kind::S_unit_property: // unit_property
      case symbol_kind::S_unit_field: // unit_field
      case symbol_kind::S_unit_field_in_container: // unit_field_in_container
      case symbol_kind::S_scoped_id_in_container: // scoped_id_in_container
      case symbol_kind::S_unit_wide_hook: // unit_wide_hook
      case symbol_kind::S_unit_switch: // unit_switch
      case symbol_kind::S_unit_block: // unit_block
        value.copy< spicy::type::unit::Item* > (that.value);
        break;

      case symbol_kind::S_unit_items: // unit_items
      case symbol_kind::S_opt_unit_items: // opt_unit_items
      case symbol_kind::S_opt_unit_block_else_items: // opt_unit_block_else_items
        value.copy< spicy::type::unit::Items > (that.value);
        break;

      case symbol_kind::S_unit_switch_case: // unit_switch_case
        value.copy< spicy::type::unit::item::switch_::Case* > (that.value);
        break;

      case symbol_kind::S_unit_switch_cases: // unit_switch_cases
        value.copy< spicy::type::unit::item::switch_::Cases > (that.value);
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.copy< std::pair<hilti::Declarations, hilti::Statements> > (that.value);
        break;

      case symbol_kind::S_global_decl_type_and_init: // global_decl_type_and_init
        value.copy< std::pair<hilti::QualifiedType*, hilti::Expression*> > (that.value);
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_HOOK_IDENT: // "hook identifier"
      case symbol_kind::S_DOLLAR_IDENT: // "$-identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_PREPROCESSOR: // "preprocessor directive"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CERROR: // "error value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.copy< std::string > (that.value);
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
      case symbol_kind::S_DOLLAR_NUMBER: // "$<N>"
      case symbol_kind::S_const_uint: // const_uint
        value.copy< uint64_t > (that.value);
        break;

      default:
        break;
    }

    location = that.location;
    return *this;
  }

  Parser::stack_symbol_type&
  Parser::stack_symbol_type::operator= (stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
      case symbol_kind::S_opt_skip: // opt_skip
      case symbol_kind::S_opt_skip_: // opt_skip_
        value.move< bool > (that.value);
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.move< double > (that.value);
        break;

      case symbol_kind::S_unit_hook_attribute: // unit_hook_attribute
      case symbol_kind::S_attribute: // attribute
        value.move< hilti::Attribute* > (that.value);
        break;

      case symbol_kind::S_opt_unit_hook_attributes: // opt_unit_hook_attributes
      case symbol_kind::S_opt_attributes: // opt_attributes
        value.move< hilti::AttributeSet* > (that.value);
        break;

      case symbol_kind::S_unit_field_ctor: // unit_field_ctor
      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_vector: // vector
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.move< hilti::Ctor* > (that.value);
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_hook_decl: // hook_decl
      case symbol_kind::S_struct_field: // struct_field
        value.move< hilti::Declaration* > (that.value);
        break;

      case symbol_kind::S_struct_fields: // struct_fields
        value.move< hilti::Declarations > (that.value);
        break;

      case symbol_kind::S_opt_init_expression: // opt_init_expression
      case symbol_kind::S_opt_bitfield_range_value: // opt_bitfield_range_value
      case symbol_kind::S_unit_field_repeat: // unit_field_repeat
      case symbol_kind::S_opt_unit_field_repeat: // opt_unit_field_repeat
      case symbol_kind::S_opt_unit_field_condition: // opt_unit_field_condition
      case symbol_kind::S_opt_unit_switch_expr: // opt_unit_switch_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.move< hilti::Expression* > (that.value);
        break;

      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_unit_field_args: // opt_unit_field_args
      case symbol_kind::S_opt_unit_field_sinks: // opt_unit_field_sinks
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.move< hilti::Expressions > (that.value);
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_opt_unit_field_id: // opt_unit_field_id
      case symbol_kind::S_unit_hook_id: // unit_hook_id
        value.move< hilti::ID > (that.value);
        break;

      case symbol_kind::S_func_result: // func_result
      case symbol_kind::S_opt_func_result: // opt_func_result
      case symbol_kind::S_qtype: // qtype
      case symbol_kind::S_unit_field_base_type: // unit_field_base_type
        value.move< hilti::QualifiedType* > (that.value);
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.move< hilti::Statement* > (that.value);
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.move< hilti::Statements > (that.value);
        break;

      case symbol_kind::S_base_type_no_ref: // base_type_no_ref
      case symbol_kind::S_reference_type: // reference_type
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_type_no_ref: // type_no_ref
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
      case symbol_kind::S_unit_type: // unit_type
        value.move< hilti::UnqualifiedType* > (that.value);
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.move< hilti::ctor::map::Element* > (that.value);
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.move< hilti::ctor::map::Elements > (that.value);
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.move< hilti::ctor::regexp::Pattern > (that.value);
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.move< hilti::ctor::regexp::Patterns > (that.value);
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.move< hilti::ctor::struct_::Field* > (that.value);
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.move< hilti::ctor::struct_::Fields > (that.value);
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.move< hilti::declaration::Linkage > (that.value);
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_unit_params: // opt_unit_params
      case symbol_kind::S_opt_unit_hook_params: // opt_unit_hook_params
        value.move< hilti::declaration::Parameters > (that.value);
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.move< hilti::parameter::Kind > (that.value);
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.move< hilti::statement::switch_::Case* > (that.value);
        break;

      case symbol_kind::S_switch_cases: // switch_cases
        value.move< hilti::statement::switch_::Cases > (that.value);
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.move< hilti::type::bitfield::BitRange* > (that.value);
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.move< hilti::type::bitfield::BitRanges > (that.value);
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.move< hilti::type::enum_::Label* > (that.value);
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.move< hilti::type::enum_::Labels > (that.value);
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.move< hilti::type::function::CallingConvention > (that.value);
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
        value.move< hilti::type::function::Flavor > (that.value);
        break;

      case symbol_kind::S_func_param: // func_param
        value.move< hilti::type::function::Parameter* > (that.value);
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.move< hilti::type::tuple::Element* > (that.value);
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.move< hilti::type::tuple::Elements > (that.value);
        break;

      case symbol_kind::S_const_sint: // const_sint
        value.move< int64_t > (that.value);
        break;

      case symbol_kind::S_unit_hook: // unit_hook
        value.move< spicy::declaration::Hook* > (that.value);
        break;

      case symbol_kind::S_opt_unit_item_hooks: // opt_unit_item_hooks
      case symbol_kind::S_unit_hooks: // unit_hooks
        value.move< spicy::declaration::Hooks > (that.value);
        break;

      case symbol_kind::S_unit_item: // unit_item
      case symbol_kind::S_unit_variable: // unit_variable
      case symbol_kind::S_unit_sink: // unit_sink
      case symbol_kind::S_unit_property: // unit_property
      case symbol_kind::S_unit_field: // unit_field
      case symbol_kind::S_unit_field_in_container: // unit_field_in_container
      case symbol_kind::S_scoped_id_in_container: // scoped_id_in_container
      case symbol_kind::S_unit_wide_hook: // unit_wide_hook
      case symbol_kind::S_unit_switch: // unit_switch
      case symbol_kind::S_unit_block: // unit_block
        value.move< spicy::type::unit::Item* > (that.value);
        break;

      case symbol_kind::S_unit_items: // unit_items
      case symbol_kind::S_opt_unit_items: // opt_unit_items
      case symbol_kind::S_opt_unit_block_else_items: // opt_unit_block_else_items
        value.move< spicy::type::unit::Items > (that.value);
        break;

      case symbol_kind::S_unit_switch_case: // unit_switch_case
        value.move< spicy::type::unit::item::switch_::Case* > (that.value);
        break;

      case symbol_kind::S_unit_switch_cases: // unit_switch_cases
        value.move< spicy::type::unit::item::switch_::Cases > (that.value);
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.move< std::pair<hilti::Declarations, hilti::Statements> > (that.value);
        break;

      case symbol_kind::S_global_decl_type_and_init: // global_decl_type_and_init
        value.move< std::pair<hilti::QualifiedType*, hilti::Expression*> > (that.value);
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_HOOK_IDENT: // "hook identifier"
      case symbol_kind::S_DOLLAR_IDENT: // "$-identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_PREPROCESSOR: // "preprocessor directive"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CERROR: // "error value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.move< std::string > (that.value);
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
      case symbol_kind::S_DOLLAR_NUMBER: // "$<N>"
      case symbol_kind::S_const_uint: // const_uint
        value.move< uint64_t > (that.value);
        break;

      default:
        break;
    }

    location = that.location;
    // that is emptied.
    that.state = empty_state;
    return *this;
  }
#endif

  template <typename Base>
  void
  Parser::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);
  }

#if YYDEBUG
  template <typename Base>
  void
  Parser::yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YY_USE (yyoutput);
    if (yysym.empty ())
      yyo << "empty symbol";
    else
      {
        symbol_kind_type yykind = yysym.kind ();
        yyo << (yykind < YYNTOKENS ? "token" : "nterm")
            << ' ' << yysym.name () << " ("
            << yysym.location << ": ";
        YY_USE (yykind);
        yyo << ')';
      }
  }
#endif

  void
  Parser::yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym)
  {
    if (m)
      YY_SYMBOL_PRINT (m, sym);
    yystack_.push (YY_MOVE (sym));
  }

  void
  Parser::yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym)
  {
#if 201103L <= YY_CPLUSPLUS
    yypush_ (m, stack_symbol_type (s, std::move (sym)));
#else
    stack_symbol_type ss (s, sym);
    yypush_ (m, ss);
#endif
  }

  void
  Parser::yypop_ (int n) YY_NOEXCEPT
  {
    yystack_.pop (n);
  }

#if YYDEBUG
  std::ostream&
  Parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  Parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  Parser::debug_level_type
  Parser::debug_level () const
  {
    return yydebug_;
  }

  void
  Parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // YYDEBUG

  Parser::state_type
  Parser::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - YYNTOKENS] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - YYNTOKENS];
  }

  bool
  Parser::yy_pact_value_is_default_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yypact_ninf_;
  }

  bool
  Parser::yy_table_value_is_error_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yytable_ninf_;
  }

  int
  Parser::operator() ()
  {
    return parse ();
  }

  int
  Parser::parse ()
  {
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The locations where the error started and ended.
    stack_symbol_type yyerror_range[3];

    /// The return value of parse ().
    int yyresult;

#if YY_EXCEPTIONS
    try
#endif // YY_EXCEPTIONS
      {
    YYCDEBUG << "Starting parse\n";


    // User initialization code.
#line 22 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
{
    yyla.location.begin.filename = yyla.location.end.filename = driver->currentFile();
}

#line 2255 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"


    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, YY_MOVE (yyla));

  /*-----------------------------------------------.
  | yynewstate -- push a new symbol on the stack.  |
  `-----------------------------------------------*/
  yynewstate:
    YYCDEBUG << "Entering state " << int (yystack_[0].state) << '\n';
    YY_STACK_PRINT ();

    // Accept?
    if (yystack_[0].state == yyfinal_)
      YYACCEPT;

    goto yybackup;


  /*-----------.
  | yybackup.  |
  `-----------*/
  yybackup:
    // Try to take a decision without lookahead.
    yyn = yypact_[+yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyla.empty ())
      {
        YYCDEBUG << "Reading a token\n";
#if YY_EXCEPTIONS
        try
#endif // YY_EXCEPTIONS
          {
            yyla.kind_ = yytranslate_ (yylex (&yyla.value, &yyla.location, driver));
          }
#if YY_EXCEPTIONS
        catch (const syntax_error& yyexc)
          {
            YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
            error (yyexc);
            goto yyerrlab1;
          }
#endif // YY_EXCEPTIONS
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    if (yyla.kind () == symbol_kind::S_YYerror)
    {
      // The scanner already issued an error message, process directly
      // to error recovery.  But do not keep the error token as
      // lookahead, it is too special and may lead us to an endless
      // loop in error recovery. */
      yyla.kind_ = symbol_kind::S_YYUNDEF;
      goto yyerrlab1;
    }

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.kind ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.kind ())
      {
        goto yydefault;
      }

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        yyn = -yyn;
        goto yyreduce;
      }

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", state_type (yyn), YY_MOVE (yyla));
    goto yynewstate;


  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[+yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;


  /*-----------------------------.
  | yyreduce -- do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_ (yystack_[yylen].state, yyr1_[yyn]);
      /* Variants are always initialized to an empty instance of the
         correct type. The default '$$ = $1' action is NOT applied
         when using variants.  */
      switch (yyr1_[yyn])
    {
      case symbol_kind::S_CBOOL: // "bool value"
      case symbol_kind::S_opt_skip: // opt_skip
      case symbol_kind::S_opt_skip_: // opt_skip_
        yylhs.value.emplace< bool > ();
        break;

      case symbol_kind::S_CUREAL: // "real value"
        yylhs.value.emplace< double > ();
        break;

      case symbol_kind::S_unit_hook_attribute: // unit_hook_attribute
      case symbol_kind::S_attribute: // attribute
        yylhs.value.emplace< hilti::Attribute* > ();
        break;

      case symbol_kind::S_opt_unit_hook_attributes: // opt_unit_hook_attributes
      case symbol_kind::S_opt_attributes: // opt_attributes
        yylhs.value.emplace< hilti::AttributeSet* > ();
        break;

      case symbol_kind::S_unit_field_ctor: // unit_field_ctor
      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_vector: // vector
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        yylhs.value.emplace< hilti::Ctor* > ();
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_hook_decl: // hook_decl
      case symbol_kind::S_struct_field: // struct_field
        yylhs.value.emplace< hilti::Declaration* > ();
        break;

      case symbol_kind::S_struct_fields: // struct_fields
        yylhs.value.emplace< hilti::Declarations > ();
        break;

      case symbol_kind::S_opt_init_expression: // opt_init_expression
      case symbol_kind::S_opt_bitfield_range_value: // opt_bitfield_range_value
      case symbol_kind::S_unit_field_repeat: // unit_field_repeat
      case symbol_kind::S_opt_unit_field_repeat: // opt_unit_field_repeat
      case symbol_kind::S_opt_unit_field_condition: // opt_unit_field_condition
      case symbol_kind::S_opt_unit_switch_expr: // opt_unit_switch_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        yylhs.value.emplace< hilti::Expression* > ();
        break;

      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_unit_field_args: // opt_unit_field_args
      case symbol_kind::S_opt_unit_field_sinks: // opt_unit_field_sinks
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        yylhs.value.emplace< hilti::Expressions > ();
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_opt_unit_field_id: // opt_unit_field_id
      case symbol_kind::S_unit_hook_id: // unit_hook_id
        yylhs.value.emplace< hilti::ID > ();
        break;

      case symbol_kind::S_func_result: // func_result
      case symbol_kind::S_opt_func_result: // opt_func_result
      case symbol_kind::S_qtype: // qtype
      case symbol_kind::S_unit_field_base_type: // unit_field_base_type
        yylhs.value.emplace< hilti::QualifiedType* > ();
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        yylhs.value.emplace< hilti::Statement* > ();
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        yylhs.value.emplace< hilti::Statements > ();
        break;

      case symbol_kind::S_base_type_no_ref: // base_type_no_ref
      case symbol_kind::S_reference_type: // reference_type
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_type_no_ref: // type_no_ref
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
      case symbol_kind::S_unit_type: // unit_type
        yylhs.value.emplace< hilti::UnqualifiedType* > ();
        break;

      case symbol_kind::S_map_elem: // map_elem
        yylhs.value.emplace< hilti::ctor::map::Element* > ();
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        yylhs.value.emplace< hilti::ctor::map::Elements > ();
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        yylhs.value.emplace< hilti::ctor::regexp::Pattern > ();
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        yylhs.value.emplace< hilti::ctor::regexp::Patterns > ();
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        yylhs.value.emplace< hilti::ctor::struct_::Field* > ();
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        yylhs.value.emplace< hilti::ctor::struct_::Fields > ();
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        yylhs.value.emplace< hilti::declaration::Linkage > ();
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_unit_params: // opt_unit_params
      case symbol_kind::S_opt_unit_hook_params: // opt_unit_hook_params
        yylhs.value.emplace< hilti::declaration::Parameters > ();
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        yylhs.value.emplace< hilti::parameter::Kind > ();
        break;

      case symbol_kind::S_switch_case: // switch_case
        yylhs.value.emplace< hilti::statement::switch_::Case* > ();
        break;

      case symbol_kind::S_switch_cases: // switch_cases
        yylhs.value.emplace< hilti::statement::switch_::Cases > ();
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        yylhs.value.emplace< hilti::type::bitfield::BitRange* > ();
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        yylhs.value.emplace< hilti::type::bitfield::BitRanges > ();
        break;

      case symbol_kind::S_enum_label: // enum_label
        yylhs.value.emplace< hilti::type::enum_::Label* > ();
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        yylhs.value.emplace< hilti::type::enum_::Labels > ();
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        yylhs.value.emplace< hilti::type::function::CallingConvention > ();
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
        yylhs.value.emplace< hilti::type::function::Flavor > ();
        break;

      case symbol_kind::S_func_param: // func_param
        yylhs.value.emplace< hilti::type::function::Parameter* > ();
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        yylhs.value.emplace< hilti::type::tuple::Element* > ();
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        yylhs.value.emplace< hilti::type::tuple::Elements > ();
        break;

      case symbol_kind::S_const_sint: // const_sint
        yylhs.value.emplace< int64_t > ();
        break;

      case symbol_kind::S_unit_hook: // unit_hook
        yylhs.value.emplace< spicy::declaration::Hook* > ();
        break;

      case symbol_kind::S_opt_unit_item_hooks: // opt_unit_item_hooks
      case symbol_kind::S_unit_hooks: // unit_hooks
        yylhs.value.emplace< spicy::declaration::Hooks > ();
        break;

      case symbol_kind::S_unit_item: // unit_item
      case symbol_kind::S_unit_variable: // unit_variable
      case symbol_kind::S_unit_sink: // unit_sink
      case symbol_kind::S_unit_property: // unit_property
      case symbol_kind::S_unit_field: // unit_field
      case symbol_kind::S_unit_field_in_container: // unit_field_in_container
      case symbol_kind::S_scoped_id_in_container: // scoped_id_in_container
      case symbol_kind::S_unit_wide_hook: // unit_wide_hook
      case symbol_kind::S_unit_switch: // unit_switch
      case symbol_kind::S_unit_block: // unit_block
        yylhs.value.emplace< spicy::type::unit::Item* > ();
        break;

      case symbol_kind::S_unit_items: // unit_items
      case symbol_kind::S_opt_unit_items: // opt_unit_items
      case symbol_kind::S_opt_unit_block_else_items: // opt_unit_block_else_items
        yylhs.value.emplace< spicy::type::unit::Items > ();
        break;

      case symbol_kind::S_unit_switch_case: // unit_switch_case
        yylhs.value.emplace< spicy::type::unit::item::switch_::Case* > ();
        break;

      case symbol_kind::S_unit_switch_cases: // unit_switch_cases
        yylhs.value.emplace< spicy::type::unit::item::switch_::Cases > ();
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        yylhs.value.emplace< std::pair<hilti::Declarations, hilti::Statements> > ();
        break;

      case symbol_kind::S_global_decl_type_and_init: // global_decl_type_and_init
        yylhs.value.emplace< std::pair<hilti::QualifiedType*, hilti::Expression*> > ();
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_HOOK_IDENT: // "hook identifier"
      case symbol_kind::S_DOLLAR_IDENT: // "$-identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_PREPROCESSOR: // "preprocessor directive"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CERROR: // "error value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        yylhs.value.emplace< std::string > ();
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
      case symbol_kind::S_DOLLAR_NUMBER: // "$<N>"
      case symbol_kind::S_const_uint: // const_uint
        yylhs.value.emplace< uint64_t > ();
        break;

      default:
        break;
    }


      // Default location.
      {
        stack_type::slice range (yystack_, yylen);
        YYLLOC_DEFAULT (yylhs.location, range, yylen);
        yyerror_range[1].location = yylhs.location;
      }

      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
#if YY_EXCEPTIONS
      try
#endif // YY_EXCEPTIONS
        {
          switch (yyn)
            {
  case 4: // start_expr: expr
#line 352 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { driver->setDestinationExpression(std::move(yystack_[0].value.as < hilti::Expression* > ())); }
#line 2669 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 5: // $@1: %empty
#line 354 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { _docs.emplace_back(driver->docGetAndClear()); }
#line 2675 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 6: // module: MODULE local_id ';' $@1 global_scope_items
#line 355 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { auto uid = hilti::declaration::module::UID(yystack_[3].value.as < hilti::ID > (), hilti::rt::filesystem::path(*driver->currentFile()));
                                                   auto m = builder->declarationModule(uid, {}, std::move(yystack_[0].value.as < std::pair<hilti::Declarations, hilti::Statements> > ().first), std::move(yystack_[0].value.as < std::pair<hilti::Declarations, hilti::Statements> > ().second), __loc__);
                                                   m->setDocumentation(_docs.back());
                                                   driver->setDestinationModule(std::move(m));
                                                 }
#line 2685 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 7: // local_id: "identifier"
#line 364 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { std::string name(yystack_[0].value.as < std::string > ());

                                                   if ( ! driver->builder()->options().skip_validation ) {
                                                       if ( name.find('-') != std::string::npos)
                                                           hilti::logger().error(hilti::util::fmt("Invalid ID '%s': cannot contain '-'", name), __loc__.location());
                                                       if ( name.substr(0, 2) == "__" )
                                                           hilti::logger().error(hilti::util::fmt("Invalid ID '%s': cannot start with '__'", name), __loc__.location());
                                                   }

                                                   yylhs.value.as < hilti::ID > () = hilti::ID(std::move(name));
                                                 }
#line 2701 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 8: // scoped_id: local_id
#line 376 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ID > () = std::move(yystack_[0].value.as < hilti::ID > ()); }
#line 2707 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 9: // scoped_id: "scoped identifier"
#line 377 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ID > () = hilti::ID(yystack_[0].value.as < std::string > ()); }
#line 2713 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 10: // $@2: %empty
#line 379 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                { driver->enableDottedIDMode(); }
#line 2719 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 11: // $@3: %empty
#line 381 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                { driver->disableDottedIDMode(); }
#line 2725 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 12: // dotted_id: $@2 "dotted identifier" $@3
#line 381 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                   { yylhs.value.as < hilti::ID > () = hilti::ID(yystack_[1].value.as < std::string > ()); }
#line 2731 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 13: // global_scope_items: global_scope_items global_scope_decl
#line 387 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < std::pair<hilti::Declarations, hilti::Statements> > () = std::move(yystack_[1].value.as < std::pair<hilti::Declarations, hilti::Statements> > ()); yylhs.value.as < std::pair<hilti::Declarations, hilti::Statements> > ().first.push_back(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2737 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 14: // global_scope_items: global_scope_items stmt
#line 389 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < std::pair<hilti::Declarations, hilti::Statements> > () = std::move(yystack_[1].value.as < std::pair<hilti::Declarations, hilti::Statements> > ()); yylhs.value.as < std::pair<hilti::Declarations, hilti::Statements> > ().second.push_back(yystack_[0].value.as < hilti::Statement* > ()); }
#line 2743 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 15: // global_scope_items: %empty
#line 390 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < std::pair<hilti::Declarations, hilti::Statements> > () = {}; }
#line 2749 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 16: // global_scope_decl: type_decl
#line 394 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = std::move(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2755 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 17: // global_scope_decl: constant_decl
#line 395 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = std::move(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2761 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 18: // global_scope_decl: global_decl
#line 396 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = std::move(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2767 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 19: // global_scope_decl: function_decl
#line 397 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = std::move(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2773 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 20: // global_scope_decl: import_decl
#line 398 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = std::move(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2779 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 21: // global_scope_decl: property_decl
#line 399 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = std::move(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2785 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 22: // global_scope_decl: hook_decl
#line 400 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = std::move(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 2791 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 23: // $@4: %empty
#line 402 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { _docs.emplace_back(driver->docGetAndClear()); }
#line 2797 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 24: // type_decl: opt_linkage TYPE scoped_id '=' $@4 qtype opt_attributes ';'
#line 403 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { if ( auto u = yystack_[2].value.as < hilti::QualifiedType* > ()->type()->tryAs<type::Unit>(); u && yystack_[1].value.as < hilti::AttributeSet* > () && *yystack_[1].value.as < hilti::AttributeSet* > () ) {
                                                      u->setAttributes(builder->context(), yystack_[1].value.as < hilti::AttributeSet* > ());
                                                      yystack_[1].value.as < hilti::AttributeSet* > () = {}; // don't associate with declaration
                                                   }

                                                   // Type decls can have attributes, but only for certain types
                                                   if ( yystack_[1].value.as < hilti::AttributeSet* > () && ! yystack_[1].value.as < hilti::AttributeSet* > ()->attributes().empty() ) {
                                                      auto ty = yystack_[2].value.as < hilti::QualifiedType* > ()->type();
                                                      if ( ! (ty->isA<hilti::type::Struct>() || ty->isA<hilti::type::Enum>() || ty->isA<hilti::type::Bitfield>()) )
                                                          error(yystack_[1].location, "attributes are not allowed on type aliases");
                                                   }

                                                   yylhs.value.as < hilti::Declaration* > () = builder->declarationType(std::move(yystack_[5].value.as < hilti::ID > ()), std::move(yystack_[2].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::AttributeSet* > ()), std::move(yystack_[7].value.as < hilti::declaration::Linkage > ()), __loc__);
                                                   yylhs.value.as < hilti::Declaration* > ()->setDocumentation(_docs.back());
                                                   _docs.pop_back();
                                                 }
#line 2818 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 25: // $@5: %empty
#line 420 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { _docs.emplace_back(driver->docGetAndClear()); }
#line 2824 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 26: // constant_decl: opt_linkage CONST scoped_id $@5 '=' expr ';'
#line 421 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationConstant(yystack_[4].value.as < hilti::ID > (), yystack_[1].value.as < hilti::Expression* > (), yystack_[6].value.as < hilti::declaration::Linkage > (), __loc__);
                                                   yylhs.value.as < hilti::Declaration* > ()->setDocumentation(_docs.back());
                                                   _docs.pop_back();
                                                 }
#line 2833 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 27: // $@6: %empty
#line 426 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { _docs.emplace_back(driver->docGetAndClear()); }
#line 2839 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 28: // constant_decl: opt_linkage CONST scoped_id $@6 ':' qtype '=' expr ';'
#line 427 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                  { yylhs.value.as < hilti::Declaration* > () = builder->declarationConstant(yystack_[6].value.as < hilti::ID > (), yystack_[3].value.as < hilti::QualifiedType* > (), yystack_[1].value.as < hilti::Expression* > (), yystack_[8].value.as < hilti::declaration::Linkage > (), __loc__);
                                                   yylhs.value.as < hilti::Declaration* > ()->setDocumentation(_docs.back());
                                                   _docs.pop_back();
                                                 }
#line 2848 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 29: // local_decl: LOCAL scoped_id '=' expr ';'
#line 433 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationLocalVariable(yystack_[3].value.as < hilti::ID > (), yystack_[1].value.as < hilti::Expression* > (), __loc__); }
#line 2854 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 30: // local_decl: LOCAL scoped_id ':' qtype ';'
#line 434 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                  { yylhs.value.as < hilti::Declaration* > () = builder->declarationLocalVariable(yystack_[3].value.as < hilti::ID > (), yystack_[1].value.as < hilti::QualifiedType* > (), {}, __loc__); }
#line 2860 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 31: // local_decl: LOCAL scoped_id ':' qtype '=' expr ';'
#line 436 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationLocalVariable(yystack_[5].value.as < hilti::ID > (), yystack_[3].value.as < hilti::QualifiedType* > (), yystack_[1].value.as < hilti::Expression* > (), __loc__); }
#line 2866 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 32: // local_init_decl: LOCAL local_id ':' qtype '=' expr
#line 441 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationLocalVariable(yystack_[4].value.as < hilti::ID > (), yystack_[2].value.as < hilti::QualifiedType* > (), yystack_[0].value.as < hilti::Expression* > (), __loc__); }
#line 2872 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 33: // local_init_decl: LOCAL local_id '=' expr
#line 443 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationLocalVariable(yystack_[2].value.as < hilti::ID > (), yystack_[0].value.as < hilti::Expression* > (), __loc__); }
#line 2878 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 34: // $@7: %empty
#line 446 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { _docs.emplace_back(driver->docGetAndClear()); }
#line 2884 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 35: // global_decl: opt_linkage GLOBAL scoped_id $@7 '=' expr ';'
#line 447 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationGlobalVariable(yystack_[4].value.as < hilti::ID > (), yystack_[1].value.as < hilti::Expression* > (), yystack_[6].value.as < hilti::declaration::Linkage > (), __loc__);
                                                   yylhs.value.as < hilti::Declaration* > ()->setDocumentation(_docs.back());
                                                   _docs.pop_back();
                                                 }
#line 2893 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 36: // $@8: %empty
#line 452 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { _docs.emplace_back(driver->docGetAndClear()); }
#line 2899 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 37: // global_decl: opt_linkage GLOBAL scoped_id $@8 ':' global_decl_type_and_init
#line 453 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationGlobalVariable(yystack_[3].value.as < hilti::ID > (), yystack_[0].value.as < std::pair<hilti::QualifiedType*, hilti::Expression*> > ().first, yystack_[0].value.as < std::pair<hilti::QualifiedType*, hilti::Expression*> > ().second, yystack_[5].value.as < hilti::declaration::Linkage > (), __loc__);
                                                   yylhs.value.as < hilti::Declaration* > ()->setDocumentation(_docs.back());
                                                   _docs.pop_back();
                                                 }
#line 2908 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 38: // global_decl_type_and_init: qtype ';'
#line 460 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                  { yylhs.value.as < std::pair<hilti::QualifiedType*, hilti::Expression*> > () = std::make_pair(yystack_[1].value.as < hilti::QualifiedType* > (), nullptr); }
#line 2914 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 39: // global_decl_type_and_init: qtype '=' expr ';'
#line 461 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                  { yylhs.value.as < std::pair<hilti::QualifiedType*, hilti::Expression*> > () = std::make_pair(yystack_[3].value.as < hilti::QualifiedType* > (), yystack_[1].value.as < hilti::Expression* > ()); }
#line 2920 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 40: // $@9: %empty
#line 464 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { _docs.emplace_back(driver->docGetAndClear()); }
#line 2926 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 41: // function_decl: opt_linkage FUNCTION opt_func_flavor opt_func_cc scoped_id '(' opt_func_params ')' opt_func_result opt_attributes $@9 ';'
#line 465 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 {
                                                    auto ftype = builder->typeFunction(yystack_[3].value.as < hilti::QualifiedType* > (), yystack_[5].value.as < hilti::declaration::Parameters > (), yystack_[9].value.as < hilti::type::function::Flavor > (), yystack_[8].value.as < hilti::type::function::CallingConvention > (), __loc__);
                                                    auto func = builder->function(yystack_[7].value.as < hilti::ID > (), std::move(ftype), {}, yystack_[2].value.as < hilti::AttributeSet* > (), __loc__);
                                                    yylhs.value.as < hilti::Declaration* > () = builder->declarationFunction(std::move(func), yystack_[11].value.as < hilti::declaration::Linkage > (), __loc__);
                                                    yylhs.value.as < hilti::Declaration* > ()->setDocumentation(_docs.back());
                                                    _docs.pop_back();
                                                 }
#line 2938 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 42: // $@10: %empty
#line 474 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { _docs.emplace_back(driver->docGetAndClear()); }
#line 2944 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 43: // function_decl: opt_linkage FUNCTION opt_func_flavor opt_func_cc scoped_id '(' opt_func_params ')' opt_func_result opt_attributes $@10 braced_block
#line 475 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 {
                                                    auto ftype = builder->typeFunction(yystack_[3].value.as < hilti::QualifiedType* > (), yystack_[5].value.as < hilti::declaration::Parameters > (), yystack_[9].value.as < hilti::type::function::Flavor > (), yystack_[8].value.as < hilti::type::function::CallingConvention > (), __loc__);
                                                    auto func = builder->function(yystack_[7].value.as < hilti::ID > (), std::move(ftype), yystack_[0].value.as < hilti::Statement* > (), yystack_[2].value.as < hilti::AttributeSet* > (), __loc__);
                                                    yylhs.value.as < hilti::Declaration* > () = builder->declarationFunction(std::move(func), yystack_[11].value.as < hilti::declaration::Linkage > (), __loc__);
                                                    yylhs.value.as < hilti::Declaration* > ()->setDocumentation(_docs.back());
                                                    _docs.pop_back();
                                                 }
#line 2956 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 44: // import_decl: IMPORT local_id ';'
#line 484 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationImportedModule(std::move(yystack_[1].value.as < hilti::ID > ()), std::string(".spicy"), __loc__); }
#line 2962 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 45: // import_decl: IMPORT local_id FROM dotted_id ';'
#line 485 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                   { yylhs.value.as < hilti::Declaration* > () = builder->declarationImportedModule(std::move(yystack_[3].value.as < hilti::ID > ()), std::string(".spicy"), std::move(yystack_[1].value.as < hilti::ID > ()), __loc__); }
#line 2968 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 46: // property_decl: "property" ';'
#line 488 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationProperty(ID(std::move(yystack_[1].value.as < std::string > ())), __loc__); }
#line 2974 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 47: // property_decl: "property" '=' expr ';'
#line 489 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declaration* > () = builder->declarationProperty(ID(std::move(yystack_[3].value.as < std::string > ())), std::move(yystack_[1].value.as < hilti::Expression* > ()), __loc__); }
#line 2980 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 48: // hook_decl: ON unit_hook_id unit_hook
#line 492 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { ID unit = yystack_[1].value.as < hilti::ID > ().namespace_();
                                                   if ( unit.empty() )
                                                      error(yylhs.location, "hook requires unit namespace");

                                                   yylhs.value.as < hilti::Declaration* > () = builder->declarationUnitHook(std::move(yystack_[1].value.as < hilti::ID > ()), std::move(yystack_[0].value.as < spicy::declaration::Hook* > ()), __loc__);
                                                 }
#line 2991 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 49: // opt_linkage: PUBLIC
#line 500 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Linkage > () = hilti::declaration::Linkage::Public; }
#line 2997 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 50: // opt_linkage: PRIVATE
#line 501 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Linkage > () = hilti::declaration::Linkage::Private; }
#line 3003 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 51: // opt_linkage: %empty
#line 502 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Linkage > () = hilti::declaration::Linkage::Private; }
#line 3009 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 52: // opt_func_flavor: %empty
#line 506 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::Flavor > () = hilti::type::function::Flavor::Function; }
#line 3015 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 53: // opt_func_cc: "string value"
#line 508 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { try {
                                                       yylhs.value.as < hilti::type::function::CallingConvention > () = hilti::type::function::calling_convention::from_string(yystack_[0].value.as < std::string > ());
                                                   } catch ( std::out_of_range& e ) {
                                                       error(yylhs.location, "unknown calling convention");
                                                   }
                                                 }
#line 3026 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 54: // opt_func_cc: %empty
#line 514 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::CallingConvention > () = hilti::type::function::CallingConvention::Standard; }
#line 3032 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 55: // opt_func_params: func_params
#line 518 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Parameters > () = std::move(yystack_[0].value.as < hilti::declaration::Parameters > ()); }
#line 3038 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 56: // opt_func_params: %empty
#line 519 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Parameters > () = hilti::type::function::Parameters{}; }
#line 3044 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 57: // func_params: func_params ',' func_param
#line 521 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Parameters > () = std::move(yystack_[2].value.as < hilti::declaration::Parameters > ()); yylhs.value.as < hilti::declaration::Parameters > ().push_back(yystack_[0].value.as < hilti::type::function::Parameter* > ()); }
#line 3050 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 58: // func_params: func_param
#line 522 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Parameters > () = hilti::type::function::Parameters{yystack_[0].value.as < hilti::type::function::Parameter* > ()}; }
#line 3056 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 59: // func_param: opt_func_param_kind local_id ':' type opt_init_expression opt_attributes
#line 525 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::function::Parameter* > () = builder->declarationParameter(yystack_[4].value.as < hilti::ID > (), yystack_[2].value.as < hilti::UnqualifiedType* > (), yystack_[5].value.as < hilti::parameter::Kind > (), yystack_[1].value.as < hilti::Expression* > (), yystack_[0].value.as < hilti::AttributeSet* > (), __loc__); }
#line 3062 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 60: // func_result: ':' qtype
#line 527 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::QualifiedType* > () = std::move(yystack_[0].value.as < hilti::QualifiedType* > ()); }
#line 3068 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 61: // opt_func_result: func_result
#line 529 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::QualifiedType* > () = std::move(yystack_[0].value.as < hilti::QualifiedType* > ()); }
#line 3074 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 62: // opt_func_result: %empty
#line 530 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::QualifiedType* > () = builder->qualifiedType(builder->typeVoid(), hilti::Constness::Const); }
#line 3080 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 63: // opt_func_param_kind: INOUT
#line 533 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::parameter::Kind > () = hilti::parameter::Kind::InOut; }
#line 3086 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 64: // opt_func_param_kind: %empty
#line 534 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::parameter::Kind > () = hilti::parameter::Kind::In; }
#line 3092 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 65: // opt_init_expression: '=' expr
#line 537 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 3098 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 66: // opt_init_expression: %empty
#line 538 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = {}; }
#line 3104 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 67: // block: stmt
#line 543 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { if ( ! yystack_[0].value.as < hilti::Statement* > ()->isA<hilti::statement::Block>() )
                                                     yylhs.value.as < hilti::Statement* > () = builder->statementBlock({std::move(yystack_[0].value.as < hilti::Statement* > ())}, __loc__);
                                                   else
                                                     yylhs.value.as < hilti::Statement* > () = std::move(yystack_[0].value.as < hilti::Statement* > ());
                                                 }
#line 3114 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 68: // braced_block: '{' opt_stmts '}'
#line 550 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementBlock(std::move(yystack_[1].value.as < hilti::Statements > ()), __loc__); }
#line 3120 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 69: // opt_stmts: stmts
#line 552 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statements > () = std::move(yystack_[0].value.as < hilti::Statements > ()); }
#line 3126 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 70: // opt_stmts: %empty
#line 553 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statements > () = hilti::Statements{}; }
#line 3132 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 71: // stmts: stmts stmt
#line 555 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statements > () = std::move(yystack_[1].value.as < hilti::Statements > ()); yylhs.value.as < hilti::Statements > ().push_back(yystack_[0].value.as < hilti::Statement* > ()); }
#line 3138 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 72: // stmts: stmt
#line 556 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statements > () = Statements{std::move(yystack_[0].value.as < hilti::Statement* > ())}; }
#line 3144 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 73: // stmt: stmt_expr ';'
#line 558 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = std::move(yystack_[1].value.as < hilti::Statement* > ()); }
#line 3150 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 74: // stmt: stmt_decl
#line 559 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = std::move(yystack_[0].value.as < hilti::Statement* > ()); }
#line 3156 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 75: // stmt: braced_block
#line 560 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = std::move(yystack_[0].value.as < hilti::Statement* > ()); }
#line 3162 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 76: // stmt: "assert" expr ';'
#line 561 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementAssert(std::move(yystack_[1].value.as < hilti::Expression* > ()), {}, __loc__); }
#line 3168 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 77: // stmt: "assert-exception" expr_no_or_error ':' expr ';'
#line 563 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementAssert(hilti::statement::assert::Exception(), std::move(yystack_[3].value.as < hilti::Expression* > ()), {}, std::move(yystack_[1].value.as < hilti::Expression* > ()), __loc__); }
#line 3174 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 78: // stmt: "assert-exception" expr_no_or_error ';'
#line 565 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementAssert(hilti::statement::assert::Exception(), std::move(yystack_[1].value.as < hilti::Expression* > ()), {}, {}, __loc__); }
#line 3180 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 79: // stmt: BREAK ';'
#line 566 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementBreak(__loc__); }
#line 3186 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 80: // stmt: CONTINUE ';'
#line 567 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementContinue(__loc__); }
#line 3192 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 81: // stmt: FOR '(' local_id IN expr ')' block
#line 569 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementFor(std::move(yystack_[4].value.as < hilti::ID > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 3198 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 82: // stmt: IF '(' expr ')' block opt_else_block
#line 571 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementIf(std::move(yystack_[3].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Statement* > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 3204 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 83: // stmt: IF '(' local_init_decl ')' block opt_else_block
#line 573 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementIf(std::move(yystack_[3].value.as < hilti::Declaration* > ()), {}, std::move(yystack_[1].value.as < hilti::Statement* > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 3210 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 84: // stmt: IF '(' local_init_decl ';' expr ')' block opt_else_block
#line 575 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementIf(std::move(yystack_[5].value.as < hilti::Declaration* > ()), std::move(yystack_[3].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Statement* > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 3216 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 85: // stmt: PRINT opt_exprs ';'
#line 576 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementPrint(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 3222 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 86: // stmt: RETURN ';'
#line 577 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementReturn(__loc__); }
#line 3228 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 87: // stmt: RETURN expr ';'
#line 578 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementReturn(std::move(yystack_[1].value.as < hilti::Expression* > ()), __loc__); }
#line 3234 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 88: // stmt: STOP ';'
#line 579 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementStop(__loc__); }
#line 3240 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 89: // stmt: THROW expr ';'
#line 580 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementThrow(builder->exception(builder->typeName("~spicy_rt::ParseError"), yystack_[1].value.as < hilti::Expression* > (), __loc__), __loc__); }
#line 3246 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 90: // stmt: SWITCH '(' expr ')' '{' switch_cases '}'
#line 582 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementSwitch(std::move(yystack_[4].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::statement::switch_::Cases > ()), __loc__); }
#line 3252 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 91: // stmt: SWITCH '(' local_init_decl ')' '{' switch_cases '}'
#line 584 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementSwitch(std::move(yystack_[4].value.as < hilti::Declaration* > ()), std::move(yystack_[1].value.as < hilti::statement::switch_::Cases > ()), __loc__); }
#line 3258 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 92: // stmt: "confirm" ';'
#line 585 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementConfirm(__loc__); }
#line 3264 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 93: // stmt: "reject" ';'
#line 586 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementReject(__loc__); }
#line 3270 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 94: // stmt: WHILE '(' local_init_decl ';' expr ')' block
#line 588 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementWhile(std::move(yystack_[4].value.as < hilti::Declaration* > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), nullptr, __loc__); }
#line 3276 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 95: // stmt: WHILE '(' expr ')' block
#line 590 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementWhile(std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), nullptr, __loc__); }
#line 3282 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 96: // stmt: WHILE '(' local_init_decl ')' block
#line 592 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementWhile(std::move(yystack_[2].value.as < hilti::Declaration* > ()), {}, std::move(yystack_[0].value.as < hilti::Statement* > ()), nullptr, __loc__); }
#line 3288 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 97: // stmt: ADD expr ';'
#line 594 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { auto op = yystack_[1].value.as < hilti::Expression* > ()->tryAs<hilti::expression::UnresolvedOperator>();
                                                   if ( ! (op && op->kind() == hilti::operator_::Kind::Index) )
                                                        error(yylhs.location, "'add' must be used with index expression only");

                                                   auto expr = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Add, op->operands(), __loc__);
                                                   yylhs.value.as < hilti::Statement* > () = builder->statementExpression(std::move(expr), __loc__);
                                                 }
#line 3300 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 98: // stmt: DELETE expr ';'
#line 602 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { auto op = yystack_[1].value.as < hilti::Expression* > ()->tryAs<hilti::expression::UnresolvedOperator>();
                                                   if ( ! (op && op->kind() == hilti::operator_::Kind::Index) )
                                                        error(yylhs.location, "'delete' must be used with index expressions only");

                                                   auto expr = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Delete, op->operands(), __loc__);
                                                   yylhs.value.as < hilti::Statement* > () = builder->statementExpression(std::move(expr), __loc__);
                                                 }
#line 3312 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 99: // stmt: UNSET expr ';'
#line 610 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { auto op = yystack_[1].value.as < hilti::Expression* > ()->tryAs<hilti::expression::UnresolvedOperator>();
                                                   if ( ! (op && op->kind() == hilti::operator_::Kind::Member) )
                                                        error(yylhs.location, "'unset' must be used with member expressions only");

                                                   auto expr = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Unset, op->operands(), __loc__);
                                                   yylhs.value.as < hilti::Statement* > () = builder->statementExpression(std::move(expr), __loc__);
                                                 }
#line 3324 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 100: // opt_else_block: ELSE block
#line 621 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = std::move(yystack_[0].value.as < hilti::Statement* > ()); }
#line 3330 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 101: // opt_else_block: %empty
#line 622 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = {}; }
#line 3336 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 102: // switch_cases: switch_cases switch_case
#line 624 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::statement::switch_::Cases > () = std::move(yystack_[1].value.as < hilti::statement::switch_::Cases > ()); yylhs.value.as < hilti::statement::switch_::Cases > ().push_back(std::move(yystack_[0].value.as < hilti::statement::switch_::Case* > ())); }
#line 3342 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 103: // switch_cases: switch_case
#line 625 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::statement::switch_::Cases > () = hilti::statement::switch_::Cases({ std::move(yystack_[0].value.as < hilti::statement::switch_::Case* > ()) }); }
#line 3348 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 104: // switch_case: CASE case_exprs ':' block
#line 627 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                      { yylhs.value.as < hilti::statement::switch_::Case* > () = builder->statementSwitchCase(std::move(yystack_[2].value.as < hilti::Expressions > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 3354 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 105: // switch_case: DEFAULT ':' block
#line 628 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::statement::switch_::Case* > () = builder->statementSwitchCase(hilti::statement::switch_::Default(), std::move(yystack_[0].value.as < hilti::Statement* > ()), __loc__); }
#line 3360 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 106: // case_exprs: case_exprs ',' expr_no_or_error
#line 630 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = std::move(yystack_[2].value.as < hilti::Expressions > ()); yylhs.value.as < hilti::Expressions > ().push_back(std::move(yystack_[0].value.as < hilti::Expression* > ())); }
#line 3366 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 107: // case_exprs: expr_no_or_error
#line 631 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions{std::move(yystack_[0].value.as < hilti::Expression* > ())}; }
#line 3372 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 108: // stmt_decl: local_decl
#line 633 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementDeclaration(yystack_[0].value.as < hilti::Declaration* > (), __loc__); }
#line 3378 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 109: // stmt_decl: type_decl
#line 634 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementDeclaration(yystack_[0].value.as < hilti::Declaration* > (), __loc__); }
#line 3384 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 110: // stmt_decl: constant_decl
#line 635 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementDeclaration(yystack_[0].value.as < hilti::Declaration* > (), __loc__); }
#line 3390 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 111: // stmt_expr: expr
#line 638 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Statement* > () = builder->statementExpression(yystack_[0].value.as < hilti::Expression* > (), __loc__); }
#line 3396 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 112: // base_type_no_ref: ANY
#line 643 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeAny(__loc__); }
#line 3402 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 113: // base_type_no_ref: ADDRESS
#line 644 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeAddress(__loc__); }
#line 3408 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 114: // base_type_no_ref: BOOL
#line 645 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeBool(__loc__); }
#line 3414 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 115: // base_type_no_ref: BYTES
#line 646 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeBytes(__loc__); }
#line 3420 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 116: // base_type_no_ref: __ERROR
#line 647 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeError(__loc__); }
#line 3426 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 117: // base_type_no_ref: INTERVAL
#line 648 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeInterval(__loc__); }
#line 3432 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 118: // base_type_no_ref: NETWORK
#line 649 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeNetwork(__loc__); }
#line 3438 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 119: // base_type_no_ref: PORT
#line 650 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typePort(__loc__); }
#line 3444 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 120: // base_type_no_ref: REAL
#line 651 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeReal(__loc__); }
#line 3450 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 121: // base_type_no_ref: REGEXP
#line 652 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeRegExp(__loc__); }
#line 3456 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 122: // base_type_no_ref: "stream"
#line 653 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeStream(__loc__); }
#line 3462 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 123: // base_type_no_ref: STRING
#line 654 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeString(__loc__); }
#line 3468 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 124: // base_type_no_ref: TIME
#line 655 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeTime(__loc__); }
#line 3474 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 125: // base_type_no_ref: TYPE
#line 656 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeTypeInfo(__loc__); }
#line 3480 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 126: // base_type_no_ref: VOID
#line 657 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeVoid(__loc__); }
#line 3486 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 127: // base_type_no_ref: INT8
#line 659 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeSignedInteger(8, __loc__); }
#line 3492 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 128: // base_type_no_ref: INT16
#line 660 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeSignedInteger(16, __loc__); }
#line 3498 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 129: // base_type_no_ref: INT32
#line 661 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeSignedInteger(32, __loc__); }
#line 3504 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 130: // base_type_no_ref: INT64
#line 662 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeSignedInteger(64, __loc__); }
#line 3510 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 131: // base_type_no_ref: UINT8
#line 663 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeUnsignedInteger(8, __loc__); }
#line 3516 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 132: // base_type_no_ref: UINT16
#line 664 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeUnsignedInteger(16, __loc__); }
#line 3522 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 133: // base_type_no_ref: UINT32
#line 665 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeUnsignedInteger(32, __loc__); }
#line 3528 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 134: // base_type_no_ref: UINT64
#line 666 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeUnsignedInteger(64, __loc__); }
#line 3534 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 135: // base_type_no_ref: CONST_ITERATOR type_param_begin qtype type_param_end
#line 668 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                                          { yylhs.value.as < hilti::UnqualifiedType* > () = iteratorForType(builder, std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__)->type(); }
#line 3540 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 136: // base_type_no_ref: ITERATOR type_param_begin qtype type_param_end
#line 669 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                                          { yylhs.value.as < hilti::UnqualifiedType* > () = iteratorForType(builder, std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__)->type(); }
#line 3546 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 137: // base_type_no_ref: OPTIONAL type_param_begin qtype type_param_end
#line 670 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                                          { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeOptional(yystack_[1].value.as < hilti::QualifiedType* > (), __loc__); }
#line 3552 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 138: // base_type_no_ref: RESULT type_param_begin qtype type_param_end
#line 671 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                                          { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeResult(yystack_[1].value.as < hilti::QualifiedType* > (), __loc__); }
#line 3558 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 139: // base_type_no_ref: VIEW type_param_begin qtype type_param_end
#line 672 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                                          { yylhs.value.as < hilti::UnqualifiedType* > () = viewForType(builder, std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__)->type(); }
#line 3564 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 140: // base_type_no_ref: MAP type_param_begin qtype ',' qtype type_param_end
#line 674 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                                           { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeMap(std::move(yystack_[3].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__); }
#line 3570 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 141: // base_type_no_ref: SET type_param_begin qtype type_param_end
#line 675 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                                          { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeSet(std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__); }
#line 3576 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 142: // base_type_no_ref: VECTOR type_param_begin qtype type_param_end
#line 676 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                                          { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeVector(std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__); }
#line 3582 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 143: // base_type_no_ref: SINK
#line 678 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeSink(__loc__); }
#line 3588 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 144: // base_type_no_ref: LIBRARY_TYPE '(' "string value" ')'
#line 680 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeLibrary(std::move(yystack_[1].value.as < std::string > ()), __loc__); }
#line 3594 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 145: // base_type_no_ref: LIBRARY_TYPE_CONST '(' "string value" ')'
#line 682 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeLibrary(hilti::Constness::Const, std::move(yystack_[1].value.as < std::string > ()), __loc__); }
#line 3600 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 146: // base_type_no_ref: tuple_type
#line 684 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3606 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 147: // base_type_no_ref: struct_type
#line 685 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3612 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 148: // base_type_no_ref: enum_type
#line 686 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3618 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 149: // base_type_no_ref: bitfield_type
#line 687 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3624 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 150: // base_type_no_ref: unit_type
#line 688 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3630 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 151: // reference_type: qtype '&'
#line 693 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yystack_[1].value.as < hilti::QualifiedType* > ()->setSide(hilti::Side::LHS);
                                                   yystack_[1].value.as < hilti::QualifiedType* > ()->setConst(hilti::Constness::Mutable);
                                                   yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeStrongReference(std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__);
                                                 }
#line 3639 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 152: // base_type: base_type_no_ref
#line 698 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3645 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 153: // reference_type: qtype '&'
#line 699 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yystack_[1].value.as < hilti::QualifiedType* > ()->setSide(hilti::Side::LHS);
                                                   yystack_[1].value.as < hilti::QualifiedType* > ()->setConst(hilti::Constness::Mutable);
                                                   yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeStrongReference(std::move(yystack_[1].value.as < hilti::QualifiedType* > ()), __loc__);
                                                 }
#line 3654 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 154: // type: base_type
#line 705 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3660 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 155: // type: reference_type
#line 706 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3666 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 156: // type: scoped_id
#line 707 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeName(std::move(yystack_[0].value.as < hilti::ID > ())); }
#line 3672 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 157: // type_no_ref: base_type
#line 710 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()); }
#line 3678 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 158: // type_no_ref: scoped_id
#line 711 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeName(std::move(yystack_[0].value.as < hilti::ID > ())); }
#line 3684 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 159: // qtype: type_no_ref
#line 714 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::QualifiedType* > () = builder->qualifiedType(std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()), hilti::Constness::Mutable, __loc__); }
#line 3690 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 160: // qtype: CONST type_no_ref
#line 715 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::QualifiedType* > () = builder->qualifiedType(std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()), hilti::Constness::Const, __loc__); }
#line 3696 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 161: // qtype: reference_type
#line 716 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::QualifiedType* > () = builder->qualifiedType(std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()), hilti::Constness::Const, __loc__); }
#line 3702 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 162: // qtype: AUTO
#line 717 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::QualifiedType* > () = builder->qualifiedType(builder->typeAuto(__loc__), hilti::Constness::Const, __loc__); }
#line 3708 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 163: // type_param_begin: '<'
#line 722 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
              { driver->disableExpressionMode(); }
#line 3714 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 164: // type_param_end: '>'
#line 726 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
              { driver->enableExpressionMode(); }
#line 3720 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 165: // tuple_type: TUPLE type_param_begin '*' type_param_end
#line 728 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeTuple(hilti::type::Wildcard(), __loc__); }
#line 3726 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 166: // tuple_type: TUPLE type_param_begin tuple_type_elems type_param_end
#line 729 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                                         { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeTuple(std::move(yystack_[1].value.as < hilti::type::tuple::Elements > ()), __loc__); }
#line 3732 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 167: // tuple_type_elems: tuple_type_elems ',' tuple_type_elem
#line 734 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::tuple::Elements > () = std::move(yystack_[2].value.as < hilti::type::tuple::Elements > ()); yylhs.value.as < hilti::type::tuple::Elements > ().push_back(std::move(yystack_[0].value.as < hilti::type::tuple::Element* > ())); }
#line 3738 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 168: // tuple_type_elems: tuple_type_elems ','
#line 735 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::tuple::Elements > () = std::move(yystack_[1].value.as < hilti::type::tuple::Elements > ()); }
#line 3744 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 169: // tuple_type_elems: tuple_type_elem
#line 736 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::tuple::Elements > () = hilti::type::tuple::Elements{std::move(yystack_[0].value.as < hilti::type::tuple::Element* > ())}; }
#line 3750 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 170: // tuple_type_elem: qtype
#line 740 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                  { yylhs.value.as < hilti::type::tuple::Element* > () = builder->typeTupleElement(std::move(yystack_[0].value.as < hilti::QualifiedType* > ())); }
#line 3756 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 171: // tuple_type_elem: local_id ':' qtype
#line 741 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                  { yylhs.value.as < hilti::type::tuple::Element* > () = builder->typeTupleElement(std::move(yystack_[2].value.as < hilti::ID > ()), std::move(yystack_[0].value.as < hilti::QualifiedType* > ())); }
#line 3762 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 172: // struct_type: STRUCT '{' struct_fields '}'
#line 744 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeStruct(std::move(yystack_[1].value.as < hilti::Declarations > ()), __loc__); }
#line 3768 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 173: // struct_fields: struct_fields struct_field
#line 746 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declarations > () = std::move(yystack_[1].value.as < hilti::Declarations > ()); yylhs.value.as < hilti::Declarations > ().push_back(yystack_[0].value.as < hilti::Declaration* > ()); }
#line 3774 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 174: // struct_fields: %empty
#line 747 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Declarations > () = Declarations{}; }
#line 3780 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 175: // struct_field: local_id ':' qtype opt_attributes ';'
#line 749 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                      { yylhs.value.as < hilti::Declaration* > () = builder->declarationField(std::move(yystack_[4].value.as < hilti::ID > ()), std::move(yystack_[2].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::AttributeSet* > ()), __loc__); }
#line 3786 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 176: // enum_type: ENUM '{' enum_labels '}'
#line 751 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeEnum(std::move(yystack_[1].value.as < hilti::type::enum_::Labels > ()), __loc__); }
#line 3792 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 177: // enum_labels: enum_labels ',' enum_label
#line 753 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::enum_::Labels > () = std::move(yystack_[2].value.as < hilti::type::enum_::Labels > ()); yylhs.value.as < hilti::type::enum_::Labels > ().push_back(std::move(yystack_[0].value.as < hilti::type::enum_::Label* > ())); }
#line 3798 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 178: // enum_labels: enum_labels ','
#line 754 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::enum_::Labels > () = std::move(yystack_[1].value.as < hilti::type::enum_::Labels > ()); }
#line 3804 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 179: // enum_labels: enum_label
#line 755 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::enum_::Labels > () = hilti::type::enum_::Labels(); yylhs.value.as < hilti::type::enum_::Labels > ().push_back(std::move(yystack_[0].value.as < hilti::type::enum_::Label* > ())); }
#line 3810 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 180: // enum_label: local_id
#line 758 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::enum_::Label* > () = builder->typeEnumLabel(std::move(yystack_[0].value.as < hilti::ID > ()), __loc__); }
#line 3816 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 181: // enum_label: local_id '=' "unsigned integer value"
#line 759 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::enum_::Label* > () = builder->typeEnumLabel(std::move(yystack_[2].value.as < hilti::ID > ()), yystack_[0].value.as < uint64_t > (), __loc__); }
#line 3822 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 182: // $@11: %empty
#line 763 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { _field_width = yystack_[1].value.as < uint64_t > (); }
#line 3828 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 183: // bitfield_type: BITFIELD '(' "unsigned integer value" ')' $@11 '{' opt_bitfield_bit_ranges '}'
#line 765 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeBitfield(yystack_[5].value.as < uint64_t > (), yystack_[1].value.as < hilti::type::bitfield::BitRanges > (), {}, __loc__); }
#line 3834 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 184: // opt_bitfield_bit_ranges: bitfield_bit_ranges
#line 769 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::bitfield::BitRanges > () = std::move(yystack_[0].value.as < hilti::type::bitfield::BitRanges > ()); }
#line 3840 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 185: // opt_bitfield_bit_ranges: %empty
#line 770 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::bitfield::BitRanges > () = hilti::type::bitfield::BitRanges(); }
#line 3846 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 186: // bitfield_bit_ranges: bitfield_bit_ranges bitfield_bit_range
#line 774 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::bitfield::BitRanges > () = std::move(yystack_[1].value.as < hilti::type::bitfield::BitRanges > ()); yylhs.value.as < hilti::type::bitfield::BitRanges > ().push_back(std::move(yystack_[0].value.as < hilti::type::bitfield::BitRange* > ()));  }
#line 3852 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 187: // bitfield_bit_ranges: bitfield_bit_range
#line 775 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::bitfield::BitRanges > () = hilti::type::bitfield::BitRanges(); yylhs.value.as < hilti::type::bitfield::BitRanges > ().push_back(std::move(yystack_[0].value.as < hilti::type::bitfield::BitRange* > ())); }
#line 3858 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 188: // bitfield_bit_range: local_id ':' "unsigned integer value" DOTDOT "unsigned integer value" opt_bitfield_range_value opt_attributes ';'
#line 779 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::bitfield::BitRange* > () = builder->typeBitfieldBitRange(std::move(yystack_[7].value.as < hilti::ID > ()), yystack_[5].value.as < uint64_t > (), yystack_[3].value.as < uint64_t > (), _field_width, std::move(yystack_[1].value.as < hilti::AttributeSet* > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), __loc__); }
#line 3864 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 189: // bitfield_bit_range: local_id ':' "unsigned integer value" opt_bitfield_range_value opt_attributes ';'
#line 781 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::type::bitfield::BitRange* > () = builder->typeBitfieldBitRange(std::move(yystack_[5].value.as < hilti::ID > ()), yystack_[3].value.as < uint64_t > (), yystack_[3].value.as < uint64_t > (), _field_width, std::move(yystack_[1].value.as < hilti::AttributeSet* > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), __loc__); }
#line 3870 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 190: // opt_bitfield_range_value: '=' expr
#line 784 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 3876 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 191: // opt_bitfield_range_value: %empty
#line 785 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = {}; }
#line 3882 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 192: // unit_type: UNIT opt_unit_params '{' opt_unit_items '}'
#line 792 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::UnqualifiedType* > () = builder->typeUnit(std::move(yystack_[3].value.as < hilti::declaration::Parameters > ()), std::move(yystack_[1].value.as < spicy::type::unit::Items > ()), {}, __loc__); }
#line 3888 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 193: // opt_unit_params: '(' opt_func_params ')'
#line 795 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Parameters > () = std::move(yystack_[1].value.as < hilti::declaration::Parameters > ()); }
#line 3894 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 194: // opt_unit_params: %empty
#line 796 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Parameters > () = hilti::type::function::Parameters{}; }
#line 3900 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 195: // unit_items: unit_items unit_item
#line 798 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Items > () = std::move(yystack_[1].value.as < spicy::type::unit::Items > ()); yylhs.value.as < spicy::type::unit::Items > ().push_back(std::move(yystack_[0].value.as < spicy::type::unit::Item* > ())); }
#line 3906 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 196: // unit_items: unit_item
#line 799 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Items > () = spicy::type::unit::Items(); yylhs.value.as < spicy::type::unit::Items > ().push_back(yystack_[0].value.as < spicy::type::unit::Item* > ()); }
#line 3912 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 197: // opt_unit_items: unit_items
#line 801 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Items > () = std::move(yystack_[0].value.as < spicy::type::unit::Items > ());}
#line 3918 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 198: // opt_unit_items: %empty
#line 802 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Items > () = spicy::type::unit::Items{}; }
#line 3924 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 199: // unit_item: unit_field
#line 805 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = std::move(yystack_[0].value.as < spicy::type::unit::Item* > ()); }
#line 3930 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 200: // unit_item: unit_variable
#line 806 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = std::move(yystack_[0].value.as < spicy::type::unit::Item* > ()); }
#line 3936 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 201: // unit_item: unit_wide_hook
#line 807 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = std::move(yystack_[0].value.as < spicy::type::unit::Item* > ()); }
#line 3942 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 202: // unit_item: unit_property
#line 808 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = std::move(yystack_[0].value.as < spicy::type::unit::Item* > ()); }
#line 3948 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 203: // unit_item: unit_sink
#line 809 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = std::move(yystack_[0].value.as < spicy::type::unit::Item* > ()); }
#line 3954 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 204: // unit_item: unit_switch
#line 810 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = std::move(yystack_[0].value.as < spicy::type::unit::Item* > ()); }
#line 3960 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 205: // unit_item: unit_block
#line 811 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = std::move(yystack_[0].value.as < spicy::type::unit::Item* > ()); }
#line 3966 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 206: // unit_variable: VAR local_id ':' qtype opt_init_expression opt_attributes ';'
#line 816 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemVariable(std::move(yystack_[5].value.as < hilti::ID > ()), std::move(yystack_[3].value.as < hilti::QualifiedType* > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::AttributeSet* > ()), __loc__); }
#line 3972 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 207: // unit_sink: SINK local_id opt_attributes ';'
#line 818 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemSink(std::move(yystack_[2].value.as < hilti::ID > ()), std::move(yystack_[1].value.as < hilti::AttributeSet* > ()), __loc__); }
#line 3978 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 208: // unit_property: "property" opt_attributes ';'
#line 820 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemProperty(ID(std::move(yystack_[2].value.as < std::string > ())), std::move(yystack_[1].value.as < hilti::AttributeSet* > ()), false, __loc__); }
#line 3984 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 209: // unit_property: "property" '=' expr opt_attributes ';'
#line 822 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemProperty(ID(std::move(yystack_[4].value.as < std::string > ())), std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::AttributeSet* > ()), false, __loc__); }
#line 3990 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 210: // unit_property: "property" '=' base_type_no_ref ';'
#line 823 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                        { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemProperty(ID(std::move(yystack_[3].value.as < std::string > ())), builder->expressionType(builder->qualifiedType(std::move(yystack_[1].value.as < hilti::UnqualifiedType* > ()), hilti::Constness::Mutable)), {}, false, __loc__); }
#line 3996 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 211: // unit_field_base_type: base_type
#line 825 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                   {   if ( yystack_[0].value.as < hilti::UnqualifiedType* > ()->isA<hilti::type::Vector>() )
                                                         error(yylhs.location, "vector<T> syntax is no longer supported for parsing sequences; use T[] instead.");
                                                     yylhs.value.as < hilti::QualifiedType* > () = builder->qualifiedType(std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()), hilti::Constness::Mutable);
                                                 }
#line 4005 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 212: // unit_field: opt_unit_field_id ':' opt_skip unit_field_base_type opt_attributes opt_unit_field_condition opt_unit_field_sinks opt_unit_item_hooks
#line 831 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemUnresolvedField(std::move(yystack_[7].value.as < hilti::ID > ()), std::move(yystack_[4].value.as < hilti::QualifiedType* > ()), yystack_[5].value.as < bool > (), {}, std::move(yystack_[1].value.as < hilti::Expressions > ()), std::move(yystack_[3].value.as < hilti::AttributeSet* > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < spicy::declaration::Hooks > ()), __loc__); }
#line 4011 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 213: // unit_field: opt_unit_field_id ':' opt_skip unit_field_base_type unit_field_repeat opt_attributes opt_unit_field_condition opt_unit_field_sinks opt_unit_item_hooks
#line 833 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 {   auto typeField = builder->typeUnitItemUnresolvedField({}, std::move(yystack_[5].value.as < hilti::QualifiedType* > ()), false, {}, {}, {}, {}, {}, toMeta(yystack_[5].location));
                                                     yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemUnresolvedField(std::move(yystack_[8].value.as < hilti::ID > ()), std::move(typeField), yystack_[6].value.as < bool > (), {}, std::move(yystack_[4].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Expressions > ()), std::move(yystack_[3].value.as < hilti::AttributeSet* > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < spicy::declaration::Hooks > ()), __loc__);
                                                 }
#line 4019 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 214: // unit_field: opt_unit_field_id ':' opt_skip unit_field_ctor opt_unit_field_repeat opt_attributes opt_unit_field_condition opt_unit_field_sinks opt_unit_item_hooks
#line 838 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemUnresolvedField(std::move(yystack_[8].value.as < hilti::ID > ()), std::move(yystack_[5].value.as < hilti::Ctor* > ()), yystack_[6].value.as < bool > (), {}, std::move(yystack_[4].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Expressions > ()), std::move(yystack_[3].value.as < hilti::AttributeSet* > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < spicy::declaration::Hooks > ()), __loc__); }
#line 4025 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 215: // unit_field: opt_unit_field_id ':' opt_skip scoped_id opt_unit_field_args opt_attributes opt_unit_field_condition opt_unit_field_sinks opt_unit_item_hooks
#line 841 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemUnresolvedField(std::move(yystack_[8].value.as < hilti::ID > ()), std::move(yystack_[5].value.as < hilti::ID > ()), yystack_[6].value.as < bool > (), std::move(yystack_[4].value.as < hilti::Expressions > ()), std::move(yystack_[1].value.as < hilti::Expressions > ()), std::move(yystack_[3].value.as < hilti::AttributeSet* > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < spicy::declaration::Hooks > ()), __loc__); }
#line 4031 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 216: // unit_field: opt_unit_field_id ':' opt_skip scoped_id_in_container unit_field_repeat opt_attributes opt_unit_field_condition opt_unit_field_sinks opt_unit_item_hooks
#line 843 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemUnresolvedField(std::move(yystack_[8].value.as < hilti::ID > ()), yystack_[5].value.as < spicy::type::unit::Item* > (), yystack_[6].value.as < bool > (), {}, std::move(yystack_[4].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Expressions > ()), std::move(yystack_[3].value.as < hilti::AttributeSet* > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < spicy::declaration::Hooks > ()), __loc__); }
#line 4037 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 217: // unit_field: opt_unit_field_id ':' opt_skip '(' unit_field_in_container ')' opt_unit_field_repeat opt_attributes opt_unit_field_condition opt_unit_field_sinks opt_unit_item_hooks
#line 845 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemUnresolvedField(std::move(yystack_[10].value.as < hilti::ID > ()), std::move(yystack_[6].value.as < spicy::type::unit::Item* > ()), yystack_[8].value.as < bool > (), {}, std::move(yystack_[4].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Expressions > ()), std::move(yystack_[3].value.as < hilti::AttributeSet* > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < spicy::declaration::Hooks > ()), __loc__); }
#line 4043 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 218: // const_sint: "unsigned integer value"
#line 847 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < int64_t > () = check_int64_range(yystack_[0].value.as < uint64_t > (), true, __loc__); }
#line 4049 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 219: // const_sint: '+' "unsigned integer value"
#line 848 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < int64_t > () = check_int64_range(yystack_[0].value.as < uint64_t > (), true, __loc__); }
#line 4055 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 220: // const_sint: '-' "unsigned integer value"
#line 849 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < int64_t > () = -check_int64_range(yystack_[0].value.as < uint64_t > (), false, __loc__); }
#line 4061 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 221: // const_uint: "unsigned integer value"
#line 851 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < uint64_t > () = yystack_[0].value.as < uint64_t > (); }
#line 4067 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 222: // const_uint: '+' "unsigned integer value"
#line 852 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < uint64_t > () = yystack_[0].value.as < uint64_t > (); }
#line 4073 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 223: // unit_field_ctor: ctor
#line 855 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 4079 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 224: // unit_field_ctor: UINT8 '(' const_uint ')'
#line 856 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorUnsignedInteger(yystack_[1].value.as < uint64_t > (), 8, __loc__); }
#line 4085 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 225: // unit_field_ctor: UINT16 '(' const_uint ')'
#line 857 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorUnsignedInteger(yystack_[1].value.as < uint64_t > (), 16, __loc__); }
#line 4091 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 226: // unit_field_ctor: UINT32 '(' const_uint ')'
#line 858 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorUnsignedInteger(yystack_[1].value.as < uint64_t > (), 32, __loc__); }
#line 4097 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 227: // unit_field_ctor: UINT64 '(' const_uint ')'
#line 859 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorUnsignedInteger(yystack_[1].value.as < uint64_t > (), 64, __loc__); }
#line 4103 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 228: // unit_field_ctor: INT8 '(' const_sint ')'
#line 860 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorSignedInteger(yystack_[1].value.as < int64_t > (), 8, __loc__); }
#line 4109 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 229: // unit_field_ctor: INT16 '(' const_sint ')'
#line 861 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorSignedInteger(yystack_[1].value.as < int64_t > (), 16, __loc__); }
#line 4115 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 230: // unit_field_ctor: INT32 '(' const_sint ')'
#line 862 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorSignedInteger(yystack_[1].value.as < int64_t > (), 32, __loc__); }
#line 4121 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 231: // unit_field_ctor: INT64 '(' const_sint ')'
#line 863 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorSignedInteger(yystack_[1].value.as < int64_t > (), 64, __loc__); }
#line 4127 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 232: // unit_field_in_container: unit_field_ctor opt_unit_field_args opt_attributes
#line 867 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemUnresolvedField({}, std::move(yystack_[2].value.as < hilti::Ctor* > ()), false, std::move(yystack_[1].value.as < hilti::Expressions > ()), {}, {}, std::move(yystack_[0].value.as < hilti::AttributeSet* > ()), {}, {}, __loc__); }
#line 4133 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 233: // unit_field_in_container: scoped_id opt_unit_field_args opt_attributes
#line 869 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemUnresolvedField({}, std::move(yystack_[2].value.as < hilti::ID > ()), false, std::move(yystack_[1].value.as < hilti::Expressions > ()), {}, std::move(yystack_[0].value.as < hilti::AttributeSet* > ()), {}, {}, __loc__); }
#line 4139 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 234: // unit_field_in_container: scoped_id_in_container unit_field_repeat opt_attributes
#line 871 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemUnresolvedField({}, yystack_[2].value.as < spicy::type::unit::Item* > (), false, {}, std::move(yystack_[1].value.as < hilti::Expression* > ()), {}, std::move(yystack_[0].value.as < hilti::AttributeSet* > ()), {}, {}, __loc__); }
#line 4145 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 235: // unit_field_in_container: unit_field_base_type opt_unit_field_args opt_attributes
#line 873 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemUnresolvedField({}, yystack_[2].value.as < hilti::QualifiedType* > (), false, std::move(yystack_[1].value.as < hilti::Expressions > ()), {}, std::move(yystack_[0].value.as < hilti::AttributeSet* > ()), {}, {}, __loc__); }
#line 4151 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 236: // unit_field_in_container: unit_field_base_type unit_field_repeat opt_unit_field_args opt_attributes
#line 875 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 {   auto typeField = builder->typeUnitItemUnresolvedField({}, std::move(yystack_[3].value.as < hilti::QualifiedType* > ()), false, {}, {}, {}, {}, {}, toMeta(yystack_[3].location));
                                                     yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemUnresolvedField({}, std::move(typeField), false, {}, std::move(yystack_[2].value.as < hilti::Expression* > ()), {}, std::move(yystack_[0].value.as < hilti::AttributeSet* > ()), {}, {}, __loc__);
                                                 }
#line 4159 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 237: // scoped_id_in_container: scoped_id opt_unit_field_args
#line 880 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemUnresolvedField({}, std::move(yystack_[1].value.as < hilti::ID > ()), false, std::move(yystack_[0].value.as < hilti::Expressions > ()), {}, {}, {}, {}, __loc__); }
#line 4165 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 238: // unit_wide_hook: ON unit_hook_id unit_hook
#line 882 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemUnitHook(std::move(yystack_[1].value.as < hilti::ID > ()), std::move(yystack_[0].value.as < spicy::declaration::Hook* > ()), __loc__); }
#line 4171 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 239: // opt_unit_field_id: local_id
#line 885 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ID > () = std::move(yystack_[0].value.as < hilti::ID > ()); }
#line 4177 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 240: // opt_unit_field_id: %empty
#line 886 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ID > () = {}; }
#line 4183 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 241: // $@12: %empty
#line 889 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
              { driver->enableNewKeywordMode(); }
#line 4189 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 242: // opt_skip: $@12 opt_skip_
#line 891 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
              { driver->disableNewKeywordMode(); yylhs.value.as < bool > () = yystack_[0].value.as < bool > (); }
#line 4195 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 243: // opt_skip_: SKIP
#line 894 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < bool > () = true; }
#line 4201 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 244: // opt_skip_: %empty
#line 895 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < bool > () = false; }
#line 4207 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 245: // opt_unit_field_args: '(' opt_exprs ')'
#line 898 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = std::move(yystack_[1].value.as < hilti::Expressions > ()); }
#line 4213 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 246: // opt_unit_field_args: %empty
#line 899 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions(); }
#line 4219 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 247: // unit_field_repeat: '[' expr ']'
#line 902 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[1].value.as < hilti::Expression* > ()); }
#line 4225 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 248: // unit_field_repeat: '[' ']'
#line 903 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->null(); }
#line 4231 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 249: // opt_unit_field_repeat: unit_field_repeat
#line 906 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 4237 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 250: // opt_unit_field_repeat: %empty
#line 907 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = {}; }
#line 4243 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 251: // opt_unit_field_condition: IF '(' expr ')'
#line 910 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[1].value.as < hilti::Expression* > ()); }
#line 4249 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 252: // opt_unit_field_condition: %empty
#line 911 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = {}; }
#line 4255 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 253: // opt_unit_field_sinks: ARROW exprs
#line 914 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = std::move(yystack_[0].value.as < hilti::Expressions > ()); }
#line 4261 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 254: // opt_unit_field_sinks: %empty
#line 915 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions(); }
#line 4267 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 255: // opt_unit_item_hooks: unit_hooks
#line 918 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::declaration::Hooks > () = std::move(yystack_[0].value.as < spicy::declaration::Hooks > ()); }
#line 4273 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 256: // opt_unit_item_hooks: ';'
#line 919 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::declaration::Hooks > () = spicy::declaration::Hooks(); }
#line 4279 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 257: // unit_hooks: unit_hooks unit_hook
#line 921 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::declaration::Hooks > () = std::move(yystack_[1].value.as < spicy::declaration::Hooks > ()); yylhs.value.as < spicy::declaration::Hooks > ().push_back(std::move(yystack_[0].value.as < spicy::declaration::Hook* > ())); }
#line 4285 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 258: // unit_hooks: unit_hook
#line 922 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::declaration::Hooks > () = spicy::declaration::Hooks{std::move(yystack_[0].value.as < spicy::declaration::Hook* > ())}; }
#line 4291 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 259: // unit_hook: opt_unit_hook_params opt_unit_hook_attributes braced_block
#line 925 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::declaration::Hook* > () = builder->declarationHook(std::move(yystack_[2].value.as < hilti::declaration::Parameters > ()), std::move(yystack_[0].value.as < hilti::Statement* > ()), std::move(yystack_[1].value.as < hilti::AttributeSet* > ()), __loc__); }
#line 4297 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 260: // opt_unit_hook_params: '(' opt_func_params ')'
#line 928 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Parameters > () = std::move(yystack_[1].value.as < hilti::declaration::Parameters > ()); }
#line 4303 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 261: // opt_unit_hook_params: %empty
#line 929 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::declaration::Parameters > () = hilti::type::function::Parameters{}; }
#line 4309 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 262: // opt_unit_hook_attributes: opt_unit_hook_attributes unit_hook_attribute
#line 933 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yystack_[1].value.as < hilti::AttributeSet* > ()->add(builder->context(), yystack_[0].value.as < hilti::Attribute* > ()); yylhs.value.as < hilti::AttributeSet* > () = std::move(yystack_[1].value.as < hilti::AttributeSet* > ()); }
#line 4315 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 263: // opt_unit_hook_attributes: %empty
#line 934 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::AttributeSet* > () = builder->attributeSet({}, __loc__); }
#line 4321 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 264: // $@13: %empty
#line 936 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
              { driver->enableHookIDMode(); }
#line 4327 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 265: // $@14: %empty
#line 938 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
              { driver->disableHookIDMode(); }
#line 4333 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 266: // unit_hook_id: $@13 "hook identifier" $@14
#line 938 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                               { yylhs.value.as < hilti::ID > () = hilti::ID(hilti::util::replace(yystack_[1].value.as < std::string > (), "%", "0x25_")); }
#line 4339 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 267: // unit_hook_attribute: FOREACH
#line 941 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Attribute* > () = builder->attribute(attribute::kind::Foreach, __loc__); }
#line 4345 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 268: // unit_hook_attribute: PRIORITY '=' expr
#line 942 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Attribute* > () = builder->attribute(attribute::kind::Priority, std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__); }
#line 4351 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 269: // unit_hook_attribute: "property"
#line 943 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { try {
                                                       yylhs.value.as < hilti::Attribute* > () = builder->attribute(hilti::attribute::kind::from_string(yystack_[0].value.as < std::string > ()), __loc__);
                                                   } catch ( std::out_of_range& e ) {
                                                       error(yylhs.location, hilti::util::fmt("unknown attribute '%s'", yystack_[0].value.as < std::string > ()));
                                                   }
                                                 }
#line 4362 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 270: // unit_hook_attribute: "attribute"
#line 949 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { try {
                                                       yylhs.value.as < hilti::Attribute* > () = builder->attribute(hilti::attribute::kind::from_string(yystack_[0].value.as < std::string > ()), __loc__);
                                                   } catch ( std::out_of_range& e ) {
                                                       error(yylhs.location, hilti::util::fmt("unknown attribute '%s'", yystack_[0].value.as < std::string > ()));
                                                   }
                                                 }
#line 4373 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 271: // unit_switch: SWITCH opt_unit_switch_expr '{' unit_switch_cases '}' opt_attributes opt_unit_field_condition ';'
#line 957 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemSwitch(std::move(yystack_[6].value.as < hilti::Expression* > ()), std::move(yystack_[4].value.as < spicy::type::unit::item::switch_::Cases > ()), std::move(yystack_[1].value.as < hilti::Expression* > ()), {}, std::move(yystack_[2].value.as < hilti::AttributeSet* > ()), __loc__); }
#line 4379 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 272: // opt_unit_switch_expr: '(' expr ')'
#line 959 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[1].value.as < hilti::Expression* > ()); }
#line 4385 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 273: // opt_unit_switch_expr: %empty
#line 960 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = {}; }
#line 4391 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 274: // unit_switch_cases: unit_switch_cases unit_switch_case
#line 964 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::item::switch_::Cases > () = std::move(yystack_[1].value.as < spicy::type::unit::item::switch_::Cases > ()); yylhs.value.as < spicy::type::unit::item::switch_::Cases > ().push_back(std::move(yystack_[0].value.as < spicy::type::unit::item::switch_::Case* > ())); }
#line 4397 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 275: // unit_switch_cases: unit_switch_case
#line 965 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::item::switch_::Cases > () = spicy::type::unit::item::switch_::Cases(); yylhs.value.as < spicy::type::unit::item::switch_::Cases > ().push_back(std::move(yystack_[0].value.as < spicy::type::unit::item::switch_::Case* > ())); }
#line 4403 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 276: // unit_switch_case: exprs ARROW '{' unit_items '}'
#line 968 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::item::switch_::Case* > () = builder->typeUnitItemSwitchCase(yystack_[4].value.as < hilti::Expressions > (), yystack_[1].value.as < spicy::type::unit::Items > (), __loc__); }
#line 4409 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 277: // unit_switch_case: '*' ARROW '{' unit_items '}'
#line 969 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::item::switch_::Case* > () = builder->typeUnitItemSwitchCase(yystack_[1].value.as < spicy::type::unit::Items > (), false, __loc__); }
#line 4415 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 278: // unit_switch_case: ARROW '{' unit_items '}'
#line 970 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::item::switch_::Case* > () = builder->typeUnitItemSwitchCase(yystack_[1].value.as < spicy::type::unit::Items > (), true, __loc__); }
#line 4421 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 279: // unit_switch_case: exprs ARROW unit_item
#line 971 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::item::switch_::Case* > () = builder->typeUnitItemSwitchCase(yystack_[2].value.as < hilti::Expressions > (), {yystack_[0].value.as < spicy::type::unit::Item* > ()}, __loc__); }
#line 4427 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 280: // unit_switch_case: '*' ARROW unit_item
#line 972 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::item::switch_::Case* > () = builder->typeUnitItemSwitchCase(type::unit::Items{yystack_[0].value.as < spicy::type::unit::Item* > ()}, false, __loc__); }
#line 4433 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 281: // unit_switch_case: ARROW unit_item
#line 973 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::item::switch_::Case* > () = builder->typeUnitItemSwitchCase(type::unit::Items{yystack_[0].value.as < spicy::type::unit::Item* > ()}, true, __loc__); }
#line 4439 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 282: // opt_unit_block_else_items: ELSE '{' opt_unit_items '}'
#line 976 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Items > () = std::move(yystack_[1].value.as < spicy::type::unit::Items > ()); }
#line 4445 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 283: // opt_unit_block_else_items: %empty
#line 977 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Items > () = {}; }
#line 4451 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 284: // unit_block: IF '(' expr ')' '{' opt_unit_items '}' opt_unit_block_else_items ';'
#line 980 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < spicy::type::unit::Item* > () = builder->typeUnitItemBlock(std::move(yystack_[6].value.as < hilti::Expression* > ()), std::move(yystack_[3].value.as < spicy::type::unit::Items > ()), std::move(yystack_[1].value.as < spicy::type::unit::Items > ()), {}, __loc__); }
#line 4457 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 285: // $@15: %empty
#line 987 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
              { driver->enableExpressionMode(); }
#line 4463 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 286: // $@16: %empty
#line 989 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
              { driver->disableExpressionMode(); }
#line 4469 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 287: // expr: $@15 expr_or_error $@16
#line 990 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[1].value.as < hilti::Expression* > ()); }
#line 4475 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 288: // expr_no_or_error: expr_1
#line 994 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 4481 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 289: // opt_exprs: exprs
#line 996 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = std::move(yystack_[0].value.as < hilti::Expressions > ()); }
#line 4487 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 290: // opt_exprs: %empty
#line 997 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = Expressions(); }
#line 4493 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 291: // exprs: exprs ',' expr
#line 999 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = std::move(yystack_[2].value.as < hilti::Expressions > ()); yylhs.value.as < hilti::Expressions > ().push_back(std::move(yystack_[0].value.as < hilti::Expression* > ())); }
#line 4499 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 292: // exprs: expr
#line 1000 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = Expressions{std::move(yystack_[0].value.as < hilti::Expression* > ())}; }
#line 4505 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 293: // expr_or_error: expr_1
#line 1002 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 4511 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 294: // expr_or_error: expr_1 ':' expr
#line 1003 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionConditionTest(std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__); }
#line 4517 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 295: // expr_1: expr_1 '=' expr_1
#line 1006 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionAssign(std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__); }
#line 4523 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 296: // expr_1: expr_1 MINUSASSIGN expr_1
#line 1007 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::DifferenceAssign, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4529 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 297: // expr_1: expr_1 PLUSASSIGN expr_1
#line 1008 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::SumAssign, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4535 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 298: // expr_1: expr_1 TIMESASSIGN expr_1
#line 1009 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::MultipleAssign, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4541 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 299: // expr_1: expr_1 DIVIDEASSIGN expr_1
#line 1010 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::DivisionAssign, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4547 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 300: // expr_1: expr_1 '?' expr_1 ':' expr_1
#line 1011 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionTernary(std::move(yystack_[4].value.as < hilti::Expression* > ()), std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__); }
#line 4553 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 301: // expr_1: expr_1 OR expr_1
#line 1012 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionLogicalOr(std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__); }
#line 4559 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 302: // expr_1: expr_1 AND expr_1
#line 1013 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionLogicalAnd(std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__); }
#line 4565 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 303: // expr_1: expr_1 EQ expr_1
#line 1014 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Equal, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4571 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 304: // expr_1: expr_1 NEQ expr_1
#line 1015 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Unequal, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4577 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 305: // expr_1: expr_1 '<' expr_1
#line 1016 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Lower, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4583 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 306: // expr_1: expr_1 '>' expr_1
#line 1017 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Greater, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4589 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 307: // expr_1: expr_1 GEQ expr_1
#line 1018 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::GreaterEqual, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4595 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 308: // expr_1: expr_1 LEQ expr_1
#line 1019 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::LowerEqual, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4601 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 309: // expr_1: expr_1 '|' expr_1
#line 1020 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::BitOr, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4607 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 310: // expr_1: expr_1 '^' expr_1
#line 1021 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::BitXor, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4613 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 311: // expr_1: expr_1 '&' expr_1
#line 1022 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::BitAnd, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4619 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 312: // expr_1: expr_1 SHIFTLEFT expr_1
#line 1023 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::ShiftLeft, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4625 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 313: // expr_1: expr_1 SHIFTRIGHT expr_1
#line 1024 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::ShiftRight, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4631 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 314: // expr_1: expr_1 '+' expr_1
#line 1025 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Sum, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4637 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 315: // expr_1: expr_1 '-' expr_1
#line 1026 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Difference, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4643 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 316: // expr_1: expr_1 '%' expr_1
#line 1027 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Modulo, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4649 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 317: // expr_1: expr_1 '*' expr_1
#line 1028 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Multiple, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4655 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 318: // expr_1: expr_1 '/' expr_1
#line 1029 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Division, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4661 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 319: // expr_1: expr_1 POW expr_1
#line 1030 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Power, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4667 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 320: // expr_1: '!' expr_1
#line 1031 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionLogicalNot(std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__); }
#line 4673 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 321: // expr_1: '*' expr_1
#line 1032 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Deref, {std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4679 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 322: // expr_1: '~' expr_1
#line 1033 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Negate, {std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4685 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 323: // expr_1: '-' expr_1
#line 1034 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::SignNeg, {std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4691 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 324: // expr_1: '|' expr_1 '|'
#line 1035 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Size, {std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 4697 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 325: // expr_1: MINUSMINUS expr_1
#line 1036 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::DecrPrefix, {std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4703 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 326: // expr_1: PLUSPLUS expr_1
#line 1037 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::IncrPrefix, {std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4709 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 327: // expr_1: expr_1 '[' expr ']'
#line 1038 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Index, {std::move(yystack_[3].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 4715 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 328: // expr_1: expr_1 '.' member_expr
#line 1039 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Member, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4721 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 329: // expr_1: expr_1 '.' member_expr '(' opt_exprs ')'
#line 1040 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                           { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::MemberCall, {std::move(yystack_[5].value.as < hilti::Expression* > ()), std::move(yystack_[3].value.as < hilti::Expression* > ()), builder->expressionCtor(builder->ctorTuple(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__))}, __loc__); }
#line 4727 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 330: // expr_1: expr_1 MINUSMINUS
#line 1041 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::DecrPostfix, {std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 4733 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 331: // expr_1: expr_1 PLUSPLUS
#line 1042 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::IncrPostfix, {std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 4739 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 332: // expr_1: expr_1 HASATTR member_expr
#line 1043 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::HasMember, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4745 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 333: // expr_1: expr_1 TRYATTR member_expr
#line 1044 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::TryMember, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4751 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 334: // expr_1: expr_1 IN expr_1
#line 1045 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::In, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4757 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 335: // expr_1: expr_1 NOT_IN expr_1
#line 1046 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionLogicalNot(builder->expressionUnresolvedOperator(hilti::operator_::Kind::In, {std::move(yystack_[2].value.as < hilti::Expression* > ()), std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__)); }
#line 4763 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 336: // expr_1: call_expr
#line 1047 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 4769 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 337: // expr_1: CAST type_param_begin qtype type_param_end '(' expr ')'
#line 1048 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                                          { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Cast, {std::move(yystack_[1].value.as < hilti::Expression* > ()), builder->expressionType(std::move(yystack_[4].value.as < hilti::QualifiedType* > ()))}, __loc__); }
#line 4775 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 338: // expr_1: PACK tuple_expr
#line 1049 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Pack, {std::move(yystack_[0].value.as < hilti::Expression* > ())}, __loc__); }
#line 4781 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 339: // expr_1: UNPACK type_param_begin qtype type_param_end tuple_expr
#line 1050 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                                          { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Unpack, {builder->expressionType(std::move(yystack_[2].value.as < hilti::QualifiedType* > ())), std::move(yystack_[0].value.as < hilti::Expression* > ()), builder->expressionCtor(builder->ctorBool(true), __loc__)}, __loc__); }
#line 4787 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 340: // expr_1: BEGIN_ '(' expr ')'
#line 1051 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Begin, {std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 4793 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 341: // expr_1: END_ '(' expr ')'
#line 1052 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::End, {std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 4799 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 342: // expr_1: NEW base_type_no_ref
#line 1053 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::New, {builder->expressionCtor(builder->ctorDefault(std::move(yystack_[0].value.as < hilti::UnqualifiedType* > ()))), builder->expressionCtor(builder->ctorTuple({}, __loc__))}, __loc__); }
#line 4805 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 343: // expr_1: NEW ctor
#line 1054 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::New, {builder->expressionCtor(std::move(yystack_[0].value.as < hilti::Ctor* > ()), __loc__),             builder->expressionCtor(builder->ctorTuple({}, __loc__))}, __loc__); }
#line 4811 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 344: // expr_1: NEW scoped_id
#line 1055 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::New, {builder->expressionName(std::move(yystack_[0].value.as < hilti::ID > ()), __loc__), builder->expressionCtor(builder->ctorTuple({}, __loc__))}, __loc__); }
#line 4817 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 345: // expr_1: NEW scoped_id '(' opt_exprs ')'
#line 1056 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::New, {builder->expressionName(std::move(yystack_[3].value.as < hilti::ID > ()), __loc__), builder->expressionCtor(builder->ctorTuple(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__))}, __loc__); }
#line 4823 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 346: // expr_1: TYPEINFO '(' expr ')'
#line 1057 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionTypeInfo(std::move(yystack_[1].value.as < hilti::Expression* > ()), __loc__); }
#line 4829 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 347: // expr_1: TYPEINFO '(' base_type ')'
#line 1058 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionTypeInfo(builder->expressionType(builder->qualifiedType(std::move(yystack_[1].value.as < hilti::UnqualifiedType* > ()), hilti::Constness::Mutable)), __loc__); }
#line 4835 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 348: // expr_1: ctor
#line 1059 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionCtor(std::move(yystack_[0].value.as < hilti::Ctor* > ()), __loc__); }
#line 4841 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 349: // expr_1: ctor_expr
#line 1060 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 4847 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 350: // expr_1: '[' expr FOR local_id IN expr ']'
#line 1061 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionListComprehension(std::move(yystack_[1].value.as < hilti::Expression* > ()), std::move(yystack_[5].value.as < hilti::Expression* > ()), std::move(yystack_[3].value.as < hilti::ID > ()), {},  __loc__); }
#line 4853 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 351: // expr_1: '[' expr FOR local_id IN expr IF expr ']'
#line 1062 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                            { yylhs.value.as < hilti::Expression* > () = builder->expressionListComprehension(std::move(yystack_[3].value.as < hilti::Expression* > ()), std::move(yystack_[7].value.as < hilti::Expression* > ()), std::move(yystack_[5].value.as < hilti::ID > ()), std::move(yystack_[1].value.as < hilti::Expression* > ()),  __loc__); }
#line 4859 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 352: // expr_1: '(' expr ')'
#line 1063 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionGrouping(std::move(yystack_[1].value.as < hilti::Expression* > ())); }
#line 4865 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 353: // expr_1: scoped_id
#line 1064 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionName(std::move(yystack_[0].value.as < hilti::ID > ()), __loc__); }
#line 4871 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 354: // expr_1: DOLLARDOLLAR
#line 1065 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionName(std::move("__dd"), __loc__);}
#line 4877 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 355: // expr_1: "$<N>"
#line 1066 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { // $N -> $@[N] (with $@ being available internally only, not exposed to users)
                                                   auto captures = builder->expressionKeyword(hilti::expression::keyword::Kind::Captures, builder->qualifiedType(builder->typeName("~hilti::Captures"), hilti::Constness::Mutable), __loc__);
                                                   auto index = builder->expressionCtor(builder->ctorUnsignedInteger(yystack_[0].value.as < uint64_t > (), 64, __loc__), __loc__);
                                                   yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Index, {std::move(captures), std::move(index)}, __loc__);
                                                 }
#line 4887 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 356: // call_expr: expr_1 '(' opt_exprs ')'
#line 1073 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionUnresolvedOperator(hilti::operator_::Kind::Call, {std::move(yystack_[3].value.as < hilti::Expression* > ()), builder->expressionCtor(builder->ctorTuple(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__))}, __loc__); }
#line 4893 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 357: // member_expr: local_id
#line 1077 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionMember(std::move(yystack_[0].value.as < hilti::ID > ()), __loc__); }
#line 4899 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 358: // member_expr: "stream"
#line 1078 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionMember(ID("stream"), __loc__); }
#line 4905 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 359: // ctor: "address value"
#line 1082 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorAddress(hilti::rt::Address(yystack_[0].value.as < std::string > ()), __loc__); }
#line 4911 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 360: // ctor: "address value" '/' "unsigned integer value"
#line 1083 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorNetwork(hilti::rt::Network(yystack_[2].value.as < std::string > (), yystack_[0].value.as < uint64_t > ()), __loc__); }
#line 4917 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 361: // ctor: "bool value"
#line 1084 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorBool(yystack_[0].value.as < bool > (), __loc__); }
#line 4923 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 362: // ctor: "bytes value"
#line 1085 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorBytes(std::move(yystack_[0].value.as < std::string > ()), __loc__); }
#line 4929 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 363: // ctor: "error value"
#line 1086 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorError(std::move(yystack_[0].value.as < std::string > ()), __loc__); }
#line 4935 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 364: // ctor: "port value"
#line 1087 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorPort(hilti::rt::Port(yystack_[0].value.as < std::string > ()), __loc__); }
#line 4941 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 365: // ctor: "null value"
#line 1088 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorNull(__loc__); }
#line 4947 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 366: // ctor: "string value"
#line 1089 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorString(yystack_[0].value.as < std::string > (), false, __loc__); }
#line 4953 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 367: // ctor: "unsigned integer value"
#line 1090 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorUnsignedInteger(yystack_[0].value.as < uint64_t > (), 64, __loc__); }
#line 4959 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 368: // ctor: '+' "unsigned integer value"
#line 1091 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { if ( yystack_[0].value.as < uint64_t > () > static_cast<uint64_t>(std::numeric_limits<int64_t>::max()) )
                                                    hilti::logger().error("integer constant out of range", __loc__.location());

                                                   yylhs.value.as < hilti::Ctor* > () = builder->ctorSignedInteger(yystack_[0].value.as < uint64_t > (), 64, __loc__);
                                                 }
#line 4969 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 369: // ctor: "real value"
#line 1096 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorReal(yystack_[0].value.as < double > (), __loc__); }
#line 4975 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 370: // ctor: '+' "real value"
#line 1097 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorReal(yystack_[0].value.as < double > (), __loc__);; }
#line 4981 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 371: // ctor: OPTIONAL '(' expr ')'
#line 1102 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorOptional(std::move(yystack_[1].value.as < hilti::Expression* > ()), __loc__); }
#line 4987 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 372: // ctor: RESULT '(' expr ')'
#line 1103 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorResult(std::move(yystack_[1].value.as < hilti::Expression* > ()), __loc__); }
#line 4993 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 373: // ctor: list
#line 1105 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 4999 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 374: // ctor: map
#line 1106 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 5005 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 375: // ctor: regexp
#line 1107 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 5011 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 376: // ctor: set
#line 1108 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 5017 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 377: // ctor: struct_
#line 1109 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 5023 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 378: // ctor: tuple
#line 1110 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 5029 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 379: // ctor: vector
#line 1111 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = std::move(yystack_[0].value.as < hilti::Ctor* > ()); }
#line 5035 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 380: // ctor_expr: INTERVAL '(' expr ')'
#line 1114 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("interval", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 5041 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 381: // ctor_expr: INTERVAL_NS '(' expr ')'
#line 1115 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("interval_ns", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 5047 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 382: // ctor_expr: TIME '(' expr ')'
#line 1116 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("time", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 5053 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 383: // ctor_expr: TIME_NS '(' expr ')'
#line 1117 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("time_ns", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 5059 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 384: // ctor_expr: "stream" '(' expr ')'
#line 1118 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("stream", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 5065 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 385: // ctor_expr: INT8 '(' expr ')'
#line 1119 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("int8", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 5071 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 386: // ctor_expr: INT16 '(' expr ')'
#line 1120 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("int16", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 5077 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 387: // ctor_expr: INT32 '(' expr ')'
#line 1121 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("int32", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 5083 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 388: // ctor_expr: INT64 '(' expr ')'
#line 1122 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("int64", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 5089 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 389: // ctor_expr: UINT8 '(' expr ')'
#line 1123 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("uint8", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 5095 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 390: // ctor_expr: UINT16 '(' expr ')'
#line 1124 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("uint16", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 5101 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 391: // ctor_expr: UINT32 '(' expr ')'
#line 1125 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("uint32", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 5107 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 392: // ctor_expr: UINT64 '(' expr ')'
#line 1126 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("uint64", { std::move(yystack_[1].value.as < hilti::Expression* > ()) }, __loc__); }
#line 5113 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 393: // ctor_expr: PORT '(' expr ',' expr ')'
#line 1127 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->namedCtor("port", {std::move(yystack_[3].value.as < hilti::Expression* > ()), std::move(yystack_[1].value.as < hilti::Expression* > ())}, __loc__); }
#line 5119 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 394: // tuple: '(' opt_tuple_elems1 ')'
#line 1130 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorTuple(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 5125 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 395: // tuple: TUPLE '(' opt_exprs ')'
#line 1131 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorTuple(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 5131 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 396: // opt_tuple_elems1: tuple_elem
#line 1134 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions{std::move(yystack_[0].value.as < hilti::Expression* > ())}; }
#line 5137 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 397: // opt_tuple_elems1: tuple_elem ',' opt_tuple_elems2
#line 1135 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions{std::move(yystack_[2].value.as < hilti::Expression* > ())}; yylhs.value.as < hilti::Expressions > ().insert(yylhs.value.as < hilti::Expressions > ().end(), yystack_[0].value.as < hilti::Expressions > ().begin(), yystack_[0].value.as < hilti::Expressions > ().end()); }
#line 5143 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 398: // opt_tuple_elems1: %empty
#line 1136 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions(); }
#line 5149 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 399: // opt_tuple_elems2: tuple_elem
#line 1139 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions{std::move(yystack_[0].value.as < hilti::Expression* > ())}; }
#line 5155 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 400: // opt_tuple_elems2: tuple_elem ',' opt_tuple_elems2
#line 1140 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions{std::move(yystack_[2].value.as < hilti::Expression* > ())}; yylhs.value.as < hilti::Expressions > ().insert(yylhs.value.as < hilti::Expressions > ().end(), yystack_[0].value.as < hilti::Expressions > ().begin(), yystack_[0].value.as < hilti::Expressions > ().end()); }
#line 5161 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 401: // opt_tuple_elems2: tuple_elem
#line 1141 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions{std::move(yystack_[0].value.as < hilti::Expression* > ())}; }
#line 5167 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 402: // opt_tuple_elems2: %empty
#line 1142 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expressions > () = hilti::Expressions(); }
#line 5173 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 403: // tuple_elem: expr
#line 1145 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = std::move(yystack_[0].value.as < hilti::Expression* > ()); }
#line 5179 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 404: // tuple_elem: NONE
#line 1146 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionCtor(builder->ctorNull(__loc__), __loc__); }
#line 5185 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 405: // tuple_expr: tuple
#line 1148 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Expression* > () = builder->expressionCtor(std::move(yystack_[0].value.as < hilti::Ctor* > ()), __loc__); }
#line 5191 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 406: // list: '[' opt_exprs ']'
#line 1150 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorList(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 5197 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 407: // list: LIST '(' opt_exprs ')'
#line 1151 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorList(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 5203 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 408: // list: LIST type_param_begin qtype type_param_end '(' opt_tuple_elems1 ')'
#line 1153 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorList(std::move(yystack_[4].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 5209 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 409: // vector: VECTOR '(' opt_exprs ')'
#line 1155 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorVector(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 5215 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 410: // vector: VECTOR type_param_begin qtype type_param_end '(' opt_tuple_elems1 ')'
#line 1157 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorVector(std::move(yystack_[4].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 5221 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 411: // set: SET '(' opt_exprs ')'
#line 1159 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorSet(std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 5227 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 412: // set: SET type_param_begin qtype type_param_end '(' opt_tuple_elems1 ')'
#line 1161 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorSet(std::move(yystack_[4].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::Expressions > ()), __loc__); }
#line 5233 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 413: // map: MAP '(' opt_map_elems ')'
#line 1163 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorMap(std::move(yystack_[1].value.as < hilti::ctor::map::Elements > ()), __loc__); }
#line 5239 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 414: // map: MAP type_param_begin qtype ',' qtype type_param_end '(' opt_map_elems ')'
#line 1165 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorMap(std::move(yystack_[6].value.as < hilti::QualifiedType* > ()), std::move(yystack_[4].value.as < hilti::QualifiedType* > ()), std::move(yystack_[1].value.as < hilti::ctor::map::Elements > ()), __loc__); }
#line 5245 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 415: // struct_: '[' struct_elems ']'
#line 1167 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorStruct(std::move(yystack_[1].value.as < hilti::ctor::struct_::Fields > ()), __loc__); }
#line 5251 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 416: // struct_elems: struct_elems ',' struct_elem
#line 1170 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::struct_::Fields > () = std::move(yystack_[2].value.as < hilti::ctor::struct_::Fields > ()); yylhs.value.as < hilti::ctor::struct_::Fields > ().push_back(yystack_[0].value.as < hilti::ctor::struct_::Field* > ()); }
#line 5257 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 417: // struct_elems: struct_elem
#line 1171 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::struct_::Fields > () = hilti::ctor::struct_::Fields{ std::move(yystack_[0].value.as < hilti::ctor::struct_::Field* > ()) }; }
#line 5263 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 418: // struct_elem: "$-identifier" '=' expr
#line 1173 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::struct_::Field* > () = builder->ctorStructField(hilti::ID(std::move(yystack_[2].value.as < std::string > ())), std::move(yystack_[0].value.as < hilti::Expression* > ())); }
#line 5269 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 419: // regexp: re_patterns
#line 1175 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::Ctor* > () = builder->ctorRegExp(std::move(yystack_[0].value.as < hilti::ctor::regexp::Patterns > ()), {}, __loc__); }
#line 5275 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 420: // re_patterns: re_patterns '|' re_pattern_constant
#line 1178 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::regexp::Patterns > () = yystack_[2].value.as < hilti::ctor::regexp::Patterns > (); yylhs.value.as < hilti::ctor::regexp::Patterns > ().push_back(std::move(yystack_[0].value.as < hilti::ctor::regexp::Pattern > ())); }
#line 5281 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 421: // re_patterns: re_pattern_constant
#line 1179 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::regexp::Patterns > () = hilti::ctor::regexp::Patterns{std::move(yystack_[0].value.as < hilti::ctor::regexp::Pattern > ())}; }
#line 5287 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 422: // $@17: %empty
#line 1182 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                    { driver->enablePatternMode(); }
#line 5293 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 423: // $@18: %empty
#line 1182 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                             { driver->disablePatternMode(); }
#line 5299 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 424: // re_pattern_constant: '/' $@17 "regular expression value" $@18 '/' opt_re_pattern_constant_flags
#line 1183 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 {
                                                   yylhs.value.as < hilti::ctor::regexp::Pattern > () = yystack_[0].value.as < hilti::ctor::regexp::Pattern > ();
                                                   yylhs.value.as < hilti::ctor::regexp::Pattern > ().setValue(yystack_[3].value.as < std::string > ());
                                                 }
#line 5308 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 425: // opt_re_pattern_constant_flags: local_id opt_re_pattern_constant_flags
#line 1190 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 {
                                                   yylhs.value.as < hilti::ctor::regexp::Pattern > () = yystack_[0].value.as < hilti::ctor::regexp::Pattern > ();
                                                   if ( yystack_[1].value.as < hilti::ID > () == ID("i") )
                                                       yylhs.value.as < hilti::ctor::regexp::Pattern > ().setCaseInsensitive(true);
                                                   else
                                                       error(yylhs.location, "unknown regular expression flag");
                                                 }
#line 5320 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 426: // opt_re_pattern_constant_flags: '$' '(' "unsigned integer value" ')' opt_re_pattern_constant_flags
#line 1198 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 {
                                                   yylhs.value.as < hilti::ctor::regexp::Pattern > () = yystack_[0].value.as < hilti::ctor::regexp::Pattern > ();
                                                   yylhs.value.as < hilti::ctor::regexp::Pattern > ().setMatchID(yystack_[2].value.as < uint64_t > ());
                                                 }
#line 5329 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 427: // opt_re_pattern_constant_flags: %empty
#line 1202 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::regexp::Pattern > () = {}; }
#line 5335 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 428: // opt_map_elems: map_elems
#line 1204 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::map::Elements > () = std::move(yystack_[0].value.as < hilti::ctor::map::Elements > ()); }
#line 5341 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 429: // opt_map_elems: %empty
#line 1205 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::map::Elements > () = hilti::ctor::map::Elements(); }
#line 5347 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 430: // map_elems: map_elems ',' map_elem
#line 1207 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::map::Elements > () = std::move(yystack_[2].value.as < hilti::ctor::map::Elements > ()); yylhs.value.as < hilti::ctor::map::Elements > ().push_back(std::move(yystack_[0].value.as < hilti::ctor::map::Element* > ())); }
#line 5353 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 431: // map_elems: map_elem
#line 1208 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::map::Elements > () = hilti::ctor::map::Elements(); yylhs.value.as < hilti::ctor::map::Elements > ().push_back(std::move(yystack_[0].value.as < hilti::ctor::map::Element* > ())); }
#line 5359 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 432: // map_elem: expr_no_or_error ':' expr
#line 1210 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                 { yylhs.value.as < hilti::ctor::map::Element* > () = builder->ctorMapElement(yystack_[2].value.as < hilti::Expression* > (), yystack_[0].value.as < hilti::Expression* > ()); }
#line 5365 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 433: // attribute: "attribute"
#line 1214 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                { try {
                                                       yylhs.value.as < hilti::Attribute* > () = builder->attribute(hilti::attribute::kind::from_string(yystack_[0].value.as < std::string > ()), __loc__);
                                                   } catch ( std::out_of_range& e ) {
                                                       error(yylhs.location, hilti::util::fmt("unknown attribute '%s'", yystack_[0].value.as < std::string > ()));
                                                       yylhs.value.as < hilti::Attribute* > () = nullptr;
                                                   }
                                                }
#line 5377 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 434: // attribute: "attribute" '=' expr
#line 1221 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                { try {
                                                       yylhs.value.as < hilti::Attribute* > () = builder->attribute(hilti::attribute::kind::from_string(yystack_[2].value.as < std::string > ()), std::move(yystack_[0].value.as < hilti::Expression* > ()), __loc__);
                                                   } catch ( std::out_of_range& e ) {
                                                       error(yylhs.location, hilti::util::fmt("unknown attribute '%s'", yystack_[2].value.as < std::string > ()));
                                                       yylhs.value.as < hilti::Attribute* > () = nullptr;
                                                   }
                                                }
#line 5389 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 435: // opt_attributes: opt_attributes attribute
#line 1230 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                { if ( yystack_[0].value.as < hilti::Attribute* > () )
                                                    yystack_[1].value.as < hilti::AttributeSet* > ()->add(builder->context(), yystack_[0].value.as < hilti::Attribute* > ());

                                                  yylhs.value.as < hilti::AttributeSet* > () = yystack_[1].value.as < hilti::AttributeSet* > ();
                                                }
#line 5399 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;

  case 436: // opt_attributes: %empty
#line 1235 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
                                                { yylhs.value.as < hilti::AttributeSet* > () = builder->attributeSet({}, __loc__); }
#line 5405 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"
    break;


#line 5409 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"

            default:
              break;
            }
        }
#if YY_EXCEPTIONS
      catch (const syntax_error& yyexc)
        {
          YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
          error (yyexc);
          YYERROR;
        }
#endif // YY_EXCEPTIONS
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, YY_MOVE (yylhs));
    }
    goto yynewstate;


  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        context yyctx (*this, yyla);
        std::string msg = yysyntax_error_ (yyctx);
        error (yyla.location, YY_MOVE (msg));
      }


    yyerror_range[1].location = yyla.location;
    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.kind () == symbol_kind::S_YYEOF)
          YYABORT;
        else if (!yyla.empty ())
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyla.clear ();
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:
    /* Pacify compilers when the user code never invokes YYERROR and
       the label yyerrorlab therefore never appears in user code.  */
    if (false)
      YYERROR;

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    YY_STACK_PRINT ();
    goto yyerrlab1;


  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    // Pop stack until we find a state that shifts the error token.
    for (;;)
      {
        yyn = yypact_[+yystack_[0].state];
        if (!yy_pact_value_is_default_ (yyn))
          {
            yyn += symbol_kind::S_YYerror;
            if (0 <= yyn && yyn <= yylast_
                && yycheck_[yyn] == symbol_kind::S_YYerror)
              {
                yyn = yytable_[yyn];
                if (0 < yyn)
                  break;
              }
          }

        // Pop the current state because it cannot handle the error token.
        if (yystack_.size () == 1)
          YYABORT;

        yyerror_range[1].location = yystack_[0].location;
        yy_destroy_ ("Error: popping", yystack_[0]);
        yypop_ ();
        YY_STACK_PRINT ();
      }
    {
      stack_symbol_type error_token;

      yyerror_range[2].location = yyla.location;
      YYLLOC_DEFAULT (error_token.location, yyerror_range, 2);

      // Shift the error token.
      error_token.state = state_type (yyn);
      yypush_ ("Shifting", YY_MOVE (error_token));
    }
    goto yynewstate;


  /*-------------------------------------.
  | yyacceptlab -- YYACCEPT comes here.  |
  `-------------------------------------*/
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;


  /*-----------------------------------.
  | yyabortlab -- YYABORT comes here.  |
  `-----------------------------------*/
  yyabortlab:
    yyresult = 1;
    goto yyreturn;


  /*-----------------------------------------------------.
  | yyreturn -- parsing is finished, return the result.  |
  `-----------------------------------------------------*/
  yyreturn:
    if (!yyla.empty ())
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    YY_STACK_PRINT ();
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
#if YY_EXCEPTIONS
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack\n";
        // Do not try to display the values of the reclaimed symbols,
        // as their printers might throw an exception.
        if (!yyla.empty ())
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
#endif // YY_EXCEPTIONS
  }

  void
  Parser::error (const syntax_error& yyexc)
  {
    error (yyexc.location, yyexc.what ());
  }

  /* Return YYSTR after stripping away unnecessary quotes and
     backslashes, so that it's suitable for yyerror.  The heuristic is
     that double-quoting is unnecessary unless the string contains an
     apostrophe, a comma, or backslash (other than backslash-backslash).
     YYSTR is taken from yytname.  */
  std::string
  Parser::yytnamerr_ (const char *yystr)
  {
    if (*yystr == '"')
      {
        std::string yyr;
        char const *yyp = yystr;

        for (;;)
          switch (*++yyp)
            {
            case '\'':
            case ',':
              goto do_not_strip_quotes;

            case '\\':
              if (*++yyp != '\\')
                goto do_not_strip_quotes;
              else
                goto append;

            append:
            default:
              yyr += *yyp;
              break;

            case '"':
              return yyr;
            }
      do_not_strip_quotes: ;
      }

    return yystr;
  }

  std::string
  Parser::symbol_name (symbol_kind_type yysymbol)
  {
    return yytnamerr_ (yytname_[yysymbol]);
  }



  // Parser::context.
  Parser::context::context (const Parser& yyparser, const symbol_type& yyla)
    : yyparser_ (yyparser)
    , yyla_ (yyla)
  {}

  int
  Parser::context::expected_tokens (symbol_kind_type yyarg[], int yyargn) const
  {
    // Actual number of expected tokens
    int yycount = 0;

    const int yyn = yypact_[+yyparser_.yystack_[0].state];
    if (!yy_pact_value_is_default_ (yyn))
      {
        /* Start YYX at -YYN if negative to avoid negative indexes in
           YYCHECK.  In other words, skip the first -YYN actions for
           this state because they are default actions.  */
        const int yyxbegin = yyn < 0 ? -yyn : 0;
        // Stay within bounds of both yycheck and yytname.
        const int yychecklim = yylast_ - yyn + 1;
        const int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
        for (int yyx = yyxbegin; yyx < yyxend; ++yyx)
          if (yycheck_[yyx + yyn] == yyx && yyx != symbol_kind::S_YYerror
              && !yy_table_value_is_error_ (yytable_[yyx + yyn]))
            {
              if (!yyarg)
                ++yycount;
              else if (yycount == yyargn)
                return 0;
              else
                yyarg[yycount++] = YY_CAST (symbol_kind_type, yyx);
            }
      }

    if (yyarg && yycount == 0 && 0 < yyargn)
      yyarg[0] = symbol_kind::S_YYEMPTY;
    return yycount;
  }






  int
  Parser::yy_syntax_error_arguments_ (const context& yyctx,
                                                 symbol_kind_type yyarg[], int yyargn) const
  {
    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yyla) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
       - Of course, the expected token list depends on states to have
         correct lookahead information, and it depends on the parser not
         to perform extra reductions after fetching a lookahead from the
         scanner and before detecting a syntax error.  Thus, state merging
         (from LALR or IELR) and default reductions corrupt the expected
         token list.  However, the list is correct for canonical LR with
         one exception: it will still contain any token that will not be
         accepted due to an error action in a later state.
    */

    if (!yyctx.lookahead ().empty ())
      {
        if (yyarg)
          yyarg[0] = yyctx.token ();
        int yyn = yyctx.expected_tokens (yyarg ? yyarg + 1 : yyarg, yyargn - 1);
        return yyn + 1;
      }
    return 0;
  }

  // Generate an error message.
  std::string
  Parser::yysyntax_error_ (const context& yyctx) const
  {
    // Its maximum.
    enum { YYARGS_MAX = 5 };
    // Arguments of yyformat.
    symbol_kind_type yyarg[YYARGS_MAX];
    int yycount = yy_syntax_error_arguments_ (yyctx, yyarg, YYARGS_MAX);

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
      default: // Avoid compiler warnings.
        YYCASE_ (0, YY_("syntax error"));
        YYCASE_ (1, YY_("syntax error, unexpected %s"));
        YYCASE_ (2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_ (3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_ (4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_ (5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    std::string yyres;
    // Argument number.
    std::ptrdiff_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += symbol_name (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const short Parser::yypact_ninf_ = -739;

  const short Parser::yytable_ninf_ = -403;

  const short
  Parser::yypact_[] =
  {
     291,   -14,  -739,   109,   121,  -739,  -739,  -739,  1340,  -739,
    -739,   -31,  -739,  -739,  -739,  -739,    13,  -739,  -739,  -739,
    -739,  -739,  -739,    63,    55,  -739,    90,   100,   152,   158,
     165,   171,   200,   -85,   113,  1340,  1870,   208,   -96,  1340,
     214,   217,   136,   221,   234,   237,   241,   271,   282,   284,
     293,   304,    55,   170,  1340,   394,  1340,  1340,  -739,    20,
     -72,  1340,  1340,  -739,  -739,  -739,  2583,  -739,  -739,  -739,
    -739,  -739,  -739,  -739,  -739,  -739,  -739,   124,  -739,  -739,
     406,  -739,  -739,  2398,  -739,  -739,  -739,  -739,  -739,  -739,
    -739,   311,  2398,  1340,  2398,   399,  -739,  -739,   320,  -739,
    -739,  -739,   323,  -739,  -739,  -739,  -739,  -739,  -739,    55,
      55,   327,   328,   113,  -739,   194,  -739,  -739,   205,   136,
    -739,  -739,  -739,   326,  -739,   206,  -739,  -739,  -739,  -739,
    -739,   330,   170,    55,  -739,    20,   -72,   331,  -739,  -739,
    -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,   476,  -739,
    -739,   311,  2398,  -739,  -739,  -739,   311,  3557,  -739,  -739,
    -739,  -739,  2398,   311,  2398,  2813,  -739,  -739,   652,   671,
     487,   342,   445,   334,   338,   167,  -739,  -739,   340,   341,
     347,   789,   827,  -739,  1340,  1340,  1340,  1340,    30,  1340,
    1340,  1340,  -739,  1340,  1340,  1340,  1340,  -739,  1340,  1340,
    1340,  1340,    30,  1340,  1340,  -739,  1340,  1340,  1340,  1340,
    1340,  1340,  1340,  1340,  1340,  1340,    30,  -739,   311,   351,
    -739,  -739,   352,  -739,  2522,    55,    55,    55,    55,    55,
      55,  -739,  -739,  -739,  -739,  -739,   238,   355,   357,   363,
     364,   369,   371,   374,  -739,   375,   238,   395,  2894,   376,
     380,  -739,  -102,   532,   121,  2398,  2398,   540,   541,  2398,
    2398,  2398,  2398,  -739,  2153,    49,   384,  2398,  2398,  -739,
     311,   387,   388,   390,   392,   238,   396,   401,   407,   408,
     416,   419,   420,   421,   423,   424,   238,   425,   238,  1505,
    -739,  -739,   121,  -739,  -739,   549,  -739,  -739,  -739,   -63,
    3670,  2975,  3865,  3965,  -739,  -739,  -739,  3751,  3980,  3056,
    3946,  3832,  3461,  3137,   266,  1401,  1502,  3218,  -739,  3299,
    2698,  -739,  4052,  4067,   717,  4082,  1703,  1273,  1616,   310,
     570,   663,   400,   391,   426,  -739,  1589,  -739,  -739,  2398,
    2398,  2398,  -739,   174,   428,  -739,  -739,  -739,  -739,  -739,
    -739,  -739,  -739,   430,  -739,  -739,  1340,  2398,   431,   450,
     141,  -739,   238,   238,   433,   437,   -53,   238,   238,   238,
      19,   454,   458,   457,   -90,  -739,  -739,   448,   449,  -739,
     121,   480,   238,   238,   453,  -739,  -739,  -739,  -739,   455,
    -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,
     -96,  -739,   460,   464,  -739,   548,  -739,  -739,  -739,   289,
    1340,   311,  -739,  -739,   -65,  -739,  1340,  -739,   459,   463,
    -739,   466,   468,   121,   462,  -739,   465,  -739,  -739,   470,
     471,   473,   475,   481,  -739,  -739,   479,   587,  -739,  1007,
    1175,  -739,  -739,  -739,  -739,  -739,  -739,   190,  -739,  -739,
    -739,   482,  -739,   103,   238,   238,  -739,   -72,  -739,  -739,
     238,  -739,   624,   121,  -739,  -739,  -739,  -739,  -739,  2398,
    -739,  -739,   483,  -739,   501,  -739,  -739,  2398,  2398,  -739,
    -739,   582,   508,   513,   495,  -739,   121,   496,   121,  -739,
     480,   493,  -739,  -739,  -739,  -739,  -739,  -739,   515,  -739,
    -739,   503,  -739,  -739,   506,   -72,  -739,   -72,    14,  -739,
     -63,  3380,   510,  -739,  -739,   514,   229,   516,  -739,  -739,
     519,   121,   592,   -18,   199,   512,   675,   520,  -739,   521,
    -739,   592,  -739,  -739,   523,   524,   592,  -739,  -739,   -11,
     527,  2217,  -739,   462,  -739,   462,   462,  -739,  2398,  -739,
    -739,   526,   534,   525,   530,  -739,  -739,   238,  2398,   457,
    -739,  -739,  2398,  3632,    17,  -739,   512,  -739,  -739,   533,
     554,  -739,  -739,  -739,  -739,   539,   545,   555,    14,  -739,
     -36,  -739,  -739,   542,  -739,  -739,  -739,  -739,  -739,   646,
     121,   192,   553,  -739,  -739,  -739,  2398,    49,  -739,  -739,
    -739,  -739,  -739,   556,   557,  -739,  -739,   230,   558,  -739,
    -739,   573,   719,   581,   591,   238,  -739,  -739,  1340,   121,
     576,   457,   585,   589,   595,   598,   457,   590,  -739,   599,
    -739,  -739,   594,  -739,    27,   601,    -7,  2398,  2028,   636,
    -739,  -739,   741,  -739,  -739,  -739,  -739,   604,  -739,   257,
    -739,  2291,  2291,   605,   767,   607,   -67,   608,    64,  -739,
     609,   616,  -739,  2291,  2291,   627,   628,  -739,   462,   639,
     643,  -739,  -739,   630,   645,   625,   121,  -739,    29,  -739,
    -739,  -739,    35,  -739,   629,  -739,  -739,   111,   773,    -2,
    -739,     1,   -44,   640,   644,   649,   650,   654,   656,   657,
     660,  1712,   668,  -739,   673,   673,   673,  -739,  -739,  -739,
     669,   641,  -739,   672,  -739,  2398,   674,   762,  -739,   791,
    -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,   691,
    -739,  -739,   264,   264,   676,  -739,  -739,  -739,  2398,   678,
    -739,  2398,  2398,  -739,   825,  -739,  -739,  -739,  -739,   838,
    -739,  -739,   480,   461,  -739,   267,  -739,  -739,   383,  -739,
      85,    85,    85,    85,    12,    12,    12,    12,   680,   -89,
     680,   681,   673,   311,   688,   682,  -739,    77,  -739,  -739,
    -739,    14,  -739,  2291,  -739,    71,  2291,  2291,  -739,  -739,
    -739,   686,  -739,  1340,   705,    25,  -739,    40,  2291,   690,
     159,    49,   692,  -739,   147,   457,    59,   689,    31,   461,
    -739,   105,   461,  -739,    38,  -739,   841,   843,   694,   696,
     700,   701,  -739,   863,   714,   715,   720,   722,   688,  -739,
     680,  -739,   673,  -739,   725,   110,  -739,   724,   119,   730,
     859,   148,   231,  -739,  -739,  -739,   848,  -739,  -739,  -739,
    -111,  -739,  2291,  -739,  -739,  -739,  -739,  -739,  -739,   732,
    -739,  -739,  -739,    39,   884,  -739,  -739,   853,  -739,    45,
     738,   130,  -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,
    -739,  -739,  -739,  -739,   838,   838,  -739,   838,  -739,   838,
    -739,   859,  -739,   859,  -739,  -739,   302,   859,   859,  -739,
    -739,  2291,  1340,  -739,   739,   760,   745,  -739,   777,  -739,
      42,   774,   779,  -739,  -739,  -739,   838,   251,   302,   302,
     778,   338,  -739,  -739,   247,  -739,   302,   302,  -739,  -739,
    -739,  2398,  -739,  -739,  -739,  -739,  -739,   480,  -739,   859,
    -739,  -739,  -739,  -739,  -739,  -739,   457,    11,    47,   782,
     302,   781,   780,  -739,  -739,  -739,  -739,  -739
  };

  const short
  Parser::yydefact_[] =
  {
       0,     0,   285,     0,     0,     2,     3,     4,     0,     1,
       7,     0,     9,   366,   362,   363,   359,   364,   369,   367,
     355,   361,   365,     0,     0,   354,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   422,   285,
     285,     0,     0,     8,   353,   286,   293,   336,   348,   349,
     378,   373,   379,   376,   374,   377,   375,   419,   421,     5,
       0,   285,   163,     0,   285,   285,   285,   285,   285,   285,
     285,   285,     0,   429,     0,   325,   113,   112,     0,   114,
     115,   120,     0,   116,   128,   129,   130,   127,   117,     0,
       0,     0,     0,     0,   118,     0,   119,   121,     0,     0,
     143,   122,   123,     0,   124,     0,   125,   132,   133,   134,
     131,   194,     0,     0,   126,   285,   285,   344,   342,   146,
     147,   148,   149,   150,   343,   285,   405,   338,   326,   285,
     285,   285,     0,   285,   285,   285,   285,   285,   285,   285,
     285,   285,     0,   285,     0,     0,   370,   368,   323,   321,
       0,     0,   292,     0,   289,     0,   417,   404,   403,     0,
     396,   320,   322,   287,     0,     0,     0,     0,     0,     0,
       0,     0,   330,     0,     0,     0,     0,   331,     0,     0,
       0,     0,     0,     0,     0,   285,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   285,   285,     0,
      15,   360,     0,   162,     0,     0,     0,     0,     0,     0,
       0,   158,   152,   161,   157,   159,     0,     0,     0,     0,
       0,     0,     0,     0,   292,     0,     0,     0,   288,     0,
     428,   431,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,     0,    56,     0,     0,     0,   403,
     285,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   324,
     423,   285,     0,   406,   285,     0,   415,   352,   394,   285,
     302,   299,   303,   307,   358,   357,   332,   334,   308,   296,
     304,   335,   301,   297,   319,   312,   313,   298,   333,   295,
       0,   294,   305,   306,   309,   310,   311,   314,   315,   316,
     317,   318,   328,     0,     0,   420,   285,   340,   160,     0,
       0,     0,   164,   151,     0,   341,   386,   387,   388,   385,
     380,   381,   407,     0,   285,   413,     0,     0,     0,   180,
       0,   179,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     8,   170,     0,   169,    63,     0,    55,    58,
       0,   198,     0,     0,     0,   371,   285,   372,   411,     0,
     384,   382,   383,   395,   347,   346,   390,   391,   392,   389,
       0,   409,     0,     0,   418,     0,   291,   416,   397,   399,
       0,   285,   327,   356,     0,   285,     0,   285,     0,     0,
     285,     0,     0,     0,     0,   264,   285,    50,    49,   285,
       0,     0,     0,     0,   285,   285,     0,   285,    13,    16,
      17,   108,    18,    19,    20,    21,    22,     0,    75,    14,
      74,     0,   111,     0,     0,     0,   285,   285,   432,   430,
       0,   182,     0,   178,   176,   136,   135,   144,   145,     0,
     137,   138,   141,   172,     0,   173,   165,     0,   168,   166,
     193,    64,     0,   436,     0,   264,     0,   273,     0,   239,
     197,     0,   196,   200,   203,   202,   199,   201,     0,   204,
     205,   142,   139,   345,     0,   285,   339,   285,   427,   285,
     285,   300,     0,   285,    46,     0,     0,     0,    79,    80,
       0,     0,   285,     0,     0,   261,     0,     0,    86,     0,
      88,   285,    92,    93,     0,     0,   285,   109,   110,     0,
       0,   285,    72,     0,    52,     0,     0,    73,     0,   141,
     142,     0,     0,     0,     0,   181,   177,     0,     0,   171,
     167,    57,     0,   285,     0,   285,   261,   436,   285,     0,
       0,   195,   192,   241,   393,     0,     0,     0,   427,   424,
       0,   400,   329,     0,    76,   285,    78,    97,    98,     0,
       0,     0,     0,    10,    44,   285,     0,    56,    48,   263,
     265,    85,    87,     0,     0,    89,    99,     0,     0,    68,
      71,    25,    54,    34,     0,     0,   337,   408,   429,   185,
     140,   436,   156,   155,   154,    66,     0,     0,   436,   433,
     208,   435,     0,   238,     0,     0,   285,     0,     0,   244,
     412,   410,     0,   425,   285,   350,    47,     0,   285,     0,
     285,   285,   285,     0,     0,     0,     0,     0,     0,   266,
       0,     0,   285,   285,   285,     0,     0,    53,     0,     0,
       0,    23,   140,     0,     0,     0,   184,   187,     0,   285,
     436,   210,     0,   285,     0,   207,   272,   240,     0,   285,
     275,     0,    66,   128,   129,   130,   127,   132,   133,   134,
     131,   285,   246,   211,   436,   250,     0,   223,   243,   242,
       0,     0,    77,     0,   285,     0,     0,   101,    67,   101,
      45,    11,    29,   285,    30,   260,   270,   269,   267,     0,
     259,   262,     0,     0,     0,    96,    95,   285,     0,     0,
     285,     0,     0,   414,     0,   183,   186,   175,    65,    59,
     209,   434,   198,   240,   281,   240,   436,   274,   240,   436,
       0,     0,     0,     0,     0,     0,     0,     0,   246,   246,
     246,     0,     0,   285,   436,   285,   436,   252,   249,   436,
     436,   427,   351,   285,    33,     0,   285,   285,    83,    82,
      12,     0,   285,     0,     0,     0,   103,     0,   285,     0,
       0,    56,     0,    37,     0,   436,   191,     0,   240,   240,
     280,   252,   240,   279,     0,   218,     0,     0,     0,     0,
       0,     0,   221,     0,     0,     0,     0,     0,   436,   436,
     246,   436,   250,   436,     0,   252,   248,     0,   252,     0,
     254,   252,   252,   426,    81,   285,   101,   100,    31,   268,
       0,   107,   285,    91,   102,    90,    94,    26,   285,     0,
      35,   285,    38,     0,     0,   285,   436,   283,   278,   240,
       0,   240,   206,   219,   220,   229,   230,   231,   228,   222,
     225,   226,   227,   224,   233,   235,   436,   232,   436,   234,
     245,   254,   247,   254,   285,   285,   261,   254,   254,    32,
      84,   285,     0,   105,     0,    62,     0,    24,   191,   190,
       0,     0,     0,   277,   271,   276,   236,   252,   261,   261,
       0,   253,   256,   212,   255,   258,   261,   261,   104,   106,
      28,     0,    61,   436,    39,   436,   189,   198,   284,   254,
     215,   213,   251,   257,   214,   216,    60,    40,     0,     0,
     261,     0,     0,   188,   282,   217,    41,    43
  };

  const short
  Parser::yypgoto_[] =
  {
    -739,  -739,  -739,  -739,  -739,    -4,   -24,  -739,  -739,  -739,
    -739,  -739,   612,  -739,   613,  -739,  -739,  -739,  -270,  -739,
    -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,  -739,   619,
    -739,  -739,  -581,  -739,   478,  -739,  -739,  -739,   265,  -607,
    -647,  -739,  -739,  -316,  -695,   227,  -379,  -739,  -739,  -739,
     -34,   402,  -153,  -739,   737,    23,   776,  -237,  -739,  -739,
     484,  -739,  -739,  -739,  -739,  -739,   500,  -739,  -739,  -739,
    -739,   290,    57,  -739,  -739,  -712,  -738,  -484,  -739,  -739,
    -739,   268,  -739,  -331,  -319,   269,  -739,   270,  -739,  -739,
    -739,  -739,  -739,  -521,  -441,   135,  -549,  -545,  -483,  -739,
    -522,  -739,  -739,   488,  -739,  -739,  -739,  -739,  -739,  -739,
     279,  -739,  -739,     5,  -739,  -739,  -411,   -76,  -626,  -739,
     728,  -739,    95,   -35,  -739,   -30,  -397,   467,  -286,   572,
    -739,  -739,  -739,  -739,  -739,  -739,   679,  -739,  -739,   756,
    -739,  -739,  -560,   358,  -739,   622,  -739,  -353
  };

  const short
  Parser::yydefgoto_[] =
  {
       0,     3,     6,     5,   220,    63,    64,   653,   654,   790,
     336,   438,   537,   742,   538,   665,   666,   441,   591,   442,
     669,   670,   803,   443,   951,   952,   444,   445,   446,   539,
     612,   668,   377,   378,   379,   932,   933,   380,   680,   717,
     448,   540,   541,   718,   788,   795,   796,   850,   450,   451,
     232,   233,   234,   625,   235,   373,   260,   344,   139,   374,
     375,   140,   370,   475,   141,   360,   361,   142,   554,   675,
     676,   677,   866,   143,   266,   490,   491,   492,   493,   494,
     495,   704,   496,   818,   824,   705,   771,   706,   497,   498,
     638,   639,   709,   774,   778,   779,   840,   896,   923,   924,
     925,   599,   658,   525,   526,   659,   731,   499,   569,   689,
     690,   912,   500,   244,     8,   183,   247,   173,   174,    65,
     248,    67,   306,    68,    69,    70,   179,   408,   180,   147,
      71,    72,    73,    74,    75,   175,   176,    76,    77,    78,
     170,   403,   579,   249,   250,   251,   631,   564
  };

  const short
  Parser::yytable_[] =
  {
      11,   144,   138,   598,   280,   516,   571,     7,   146,   353,
     691,   730,   137,   409,   807,   245,   657,    10,   643,   629,
     449,   687,    10,   177,   789,   629,   687,   171,   543,   758,
     822,   644,   177,    10,    10,   629,    46,   629,   389,   901,
     483,   808,   593,   629,   633,   719,   629,   629,    10,   400,
     629,   402,   -64,   343,   483,   629,   735,   736,   902,   231,
     552,   793,   342,   691,   172,   178,    82,   357,   231,   794,
     231,   136,   726,   727,   775,   274,   793,     4,   773,   478,
     279,   723,    91,   513,   794,   629,   222,   287,   343,   237,
     238,   239,   240,   241,   242,   243,  -398,   869,   484,   724,
     871,   514,   343,   815,   679,  -402,   236,   864,   575,     9,
     576,   343,   484,   629,    10,   246,   469,   252,   629,   376,
     483,   542,   546,   728,    10,   465,   466,   629,   231,   485,
     470,   471,   472,    10,   476,    79,   645,   479,   231,   483,
     231,   269,   334,   485,   839,   501,   502,   486,   594,   304,
     271,   900,   688,   487,   272,   273,   629,   688,   276,   277,
     278,   486,   281,   282,   283,   284,   285,   487,   823,   756,
     294,   729,   839,    80,   488,   275,   844,   839,   484,   846,
     847,   -42,  -151,   630,   305,   286,   839,   288,   488,   577,
     473,   856,  -290,   685,   384,   747,   853,   484,   305,   949,
     231,   750,   868,   754,   872,   907,    82,   865,   936,   485,
     321,   855,   305,   953,   634,   839,   913,   549,   550,   845,
     859,   843,   333,   553,   409,   610,   343,   486,   485,   543,
      81,   231,   231,   487,   437,   231,   231,   231,   231,   629,
     231,   816,   817,   231,   231,   903,   486,   828,   829,   831,
     359,   544,   487,   545,   488,  -261,  -255,    84,   343,   629,
     372,   603,   870,   776,    82,   780,   607,    85,   678,   921,
      10,   810,   548,   488,   813,   682,   483,   219,   362,   363,
      93,   753,   366,   367,   368,   369,   891,    82,   405,   893,
     382,   383,   897,   898,   928,   861,   404,   318,   839,   406,
     793,   915,   343,   151,   269,   957,  -261,   858,   794,   886,
     463,   332,   464,   862,   343,   231,   231,   231,   839,    86,
     620,    82,  -151,   546,   571,    87,  -151,   749,   830,  -151,
     188,   833,    88,   231,   484,   512,   295,   163,    89,   296,
    -151,   452,  -151,  -151,  -151,    82,   918,   595,   919,   596,
     527,   777,   926,   927,  -261,   192,    82,    82,   650,   458,
     651,   145,   453,   454,   455,   485,   474,    90,   939,   197,
     146,   198,   150,   156,   188,   145,   482,   489,   672,   585,
     460,   149,   851,   486,   150,   571,    10,   571,   153,   487,
     342,   504,   483,   343,   950,   586,   662,   202,   663,   192,
     524,   154,   943,   811,   155,   714,   814,   715,   156,   624,
     488,   166,   167,   197,   597,   198,   854,  -261,   854,   523,
     515,   835,   517,   838,   221,   520,   841,   842,   216,   217,
     819,   820,   821,   218,   529,   940,   941,   809,   157,   534,
     535,   202,   452,   944,   945,   231,   825,   826,   827,   158,
     484,   159,   863,   231,   231,     1,     2,  -399,   510,   359,
     160,   551,   269,   188,    10,    10,    12,   955,   922,   597,
     483,   161,   216,   217,   372,   884,   885,   218,   887,  -290,
     889,   485,   567,    10,   570,   703,   489,   253,   192,   483,
     291,   929,   557,   254,   257,   258,   263,   265,   270,   486,
     559,   290,   197,   292,   578,   487,   293,   294,   297,   298,
     269,    58,   269,   910,   580,   269,   299,   589,   583,   611,
     337,   613,   614,   345,   231,   346,   488,   592,   484,   627,
     202,   347,   348,   916,   231,   917,   604,   349,   622,   350,
     188,   608,   351,   352,   355,   354,   452,   484,   703,   356,
     358,   364,   365,   812,   381,   385,   171,   386,   387,   485,
     388,   216,   217,   412,   390,   192,   218,   411,   628,   391,
     632,   615,   231,   635,   578,   392,   393,   486,   485,   197,
     947,   621,   948,   487,   394,   626,   649,   395,   396,   397,
     647,   398,   399,   401,   413,   456,   486,   457,   462,   461,
     655,   467,   487,   707,   488,   468,   342,   202,   477,   415,
     416,   417,   343,   231,   702,   674,   480,   509,   481,   656,
     418,   503,   505,   488,   508,   518,   -51,   507,   419,   519,
    -240,  -290,   420,   521,   188,   522,   528,   530,   216,   217,
     531,   532,   555,   218,   739,   421,   536,   533,   547,   711,
     505,   558,   376,   713,   422,   716,   452,   452,   562,   192,
     692,   563,   565,   568,   572,   573,   707,   734,   452,   452,
     507,   424,   674,   197,   574,   198,   590,   768,   582,   597,
     584,   600,   587,   489,   748,   588,   601,   602,   751,   605,
     606,   231,   618,   426,   616,   427,   428,   834,   609,   429,
     619,   202,   617,   636,   637,   430,   269,   640,   646,   431,
     432,   433,   434,   641,   231,   648,   188,   231,   231,   784,
     -51,   652,   642,   -27,   660,   661,   664,   188,   791,   435,
     667,   -36,   216,   217,   436,   188,    66,   218,   785,   671,
    -158,   192,   799,   618,  -161,   802,   679,   683,   489,   489,
    -157,   489,   192,   708,   489,   197,   681,   437,   -70,   710,
     192,   800,   684,    95,   804,   805,   197,   148,   198,   686,
     712,   720,   721,   722,   197,   737,   725,   578,   738,   732,
     837,   188,   165,   202,   168,   169,   733,   740,   452,   181,
     182,   452,   452,   741,   202,   744,   745,   849,   743,   752,
      83,   755,   202,   452,   489,   489,   192,   760,   489,    92,
      94,   761,   787,   782,   216,   217,   762,   763,   152,   218,
     197,   764,   198,   765,   766,   216,   217,   767,   162,   164,
     218,   199,   200,   216,   217,   773,   775,   781,   218,   792,
     783,   787,   786,   806,   798,   801,   629,   773,   202,   832,
     899,  -237,   848,   188,   836,   852,   857,   452,   860,   873,
     867,   874,   875,   904,   876,   489,   906,   489,   877,   878,
     909,   209,   210,   211,   212,   213,   214,   215,   192,   216,
     217,   879,   880,   881,   218,   255,   256,   895,   882,   259,
     883,   188,   197,   890,   261,   262,   892,   894,   787,   920,
     905,   264,   908,   911,   914,   930,   452,   231,   267,   268,
     931,   934,   300,   301,   302,   303,   192,   307,   308,   309,
     202,   310,   311,   312,   313,   865,   314,   315,   316,   317,
     197,   319,   320,   489,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   937,   938,   942,   956,   439,   440,
     437,   216,   217,   954,   946,   447,   218,   759,   202,   561,
     797,   338,   560,   556,   623,   935,   746,   888,   757,   769,
     770,   772,   506,   566,   407,   335,   673,   581,   459,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,     0,     0,
       0,   339,     0,   261,   340,   264,   341,   -16,     0,     0,
     -16,   -16,     0,     0,     0,     0,   -16,   324,   -16,   -16,
     -16,     0,   -16,   -16,   -16,   -16,   -16,   -16,   -16,   -16,
     -16,   -16,     0,     0,     0,     0,     0,     0,   -16,     0,
     -16,     0,     0,     0,   -16,     0,   -16,     0,   -16,     0,
       0,     0,   -16,     0,   -16,     0,     0,     0,   -16,     0,
       0,     0,     0,     0,     0,   -16,     0,     0,   -16,     0,
     -16,     0,     0,     0,   -16,   -16,     0,     0,     0,   -16,
     -16,   -16,   -16,   -16,   -16,     0,     0,     0,     0,     0,
     -16,   -16,   -16,     0,     0,     0,   -16,     0,     0,     0,
       0,   -16,     0,     0,     0,   -16,   -16,     0,   -16,     0,
     -16,   -16,     0,   -16,     0,   -16,   -16,     0,   -16,   -16,
     -16,     0,     0,     0,     0,   -16,   -16,     0,     0,   -16,
     -16,   -16,   -16,   -16,   -16,     0,     0,     0,   511,   -16,
     -16,   -16,     0,   -16,   -16,   -16,   -16,     0,   -16,   -16,
       0,   -16,     0,     0,   -16,     0,     0,     0,     0,     0,
     -16,     0,     0,   -16,   -16,     0,   -16,   -16,     0,     0,
     -16,     0,     0,     0,   -16,   -17,     0,   -16,   -17,   -17,
     -16,   -16,     0,     0,   -17,     0,   -17,   -17,   -17,     0,
     -17,   -17,   -17,   -17,   -17,   -17,   -17,   -17,   -17,   -17,
       0,     0,     0,     0,     0,     0,   -17,     0,   -17,     0,
       0,     0,   -17,     0,   -17,     0,   -17,     0,     0,     0,
     -17,     0,   -17,     0,     0,     0,   -17,     0,     0,     0,
       0,     0,     0,   -17,     0,     0,   -17,     0,   -17,     0,
       0,     0,   -17,   -17,     0,     0,     0,   -17,   -17,   -17,
     -17,   -17,   -17,     0,     0,     0,     0,     0,   -17,   -17,
     -17,     0,     0,     0,   -17,     0,     0,     0,     0,   -17,
       0,     0,     0,   -17,   -17,     0,   -17,     0,   -17,   -17,
       0,   -17,     0,   -17,   -17,     0,   -17,   -17,   -17,     0,
       0,     0,     0,   -17,   -17,     0,     0,   -17,   -17,   -17,
     -17,   -17,   -17,     0,     0,     0,     0,   -17,   -17,   -17,
       0,   -17,   -17,   -17,   -17,     0,   -17,   -17,     0,   -17,
       0,     0,   -17,     0,     0,     0,     0,     0,   -17,     0,
       0,   -17,   -17,     0,   -17,   -17,     0,   188,   -17,     0,
       0,     0,   -17,    10,    12,   -17,     0,     0,   -17,   -17,
       0,    13,    14,    15,     0,    16,    17,    18,    19,    20,
      21,    22,   192,     0,     0,     0,     0,     0,     0,     0,
       0,    23,     0,     0,     0,     0,   197,    24,   198,     0,
       0,     0,     0,     0,     0,     0,     0,    25,     0,     0,
       0,    26,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   202,     0,     0,     0,     0,     0,
       0,     0,    27,    28,    29,    30,    31,    32,     0,     0,
       0,     0,     0,    33,     0,    34,     0,     0,     0,    35,
       0,   213,   214,   215,    36,   216,   217,     0,     0,    37,
     218,    38,     0,    39,    40,     0,     0,     0,     0,     0,
       0,    41,     0,    42,     0,     0,     0,     0,     0,    43,
       0,     0,     0,     0,     0,   188,    44,    45,     0,     0,
       0,     0,    46,     0,    47,     0,    48,    49,    50,    51,
       0,    52,     0,     0,    53,     0,     0,     0,     0,     0,
     192,     0,     0,    54,     0,     0,    55,    56,     0,    57,
      58,     0,     0,    59,   197,     0,   198,    60,    10,    12,
       0,     0,     0,    61,    62,     0,    13,    14,    15,     0,
      16,    17,    18,    19,    20,    21,    22,     0,     0,     0,
       0,     0,   202,     0,     0,     0,    23,     0,     0,     0,
       0,     0,    24,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    25,     0,     0,     0,    26,   211,   212,   213,
     214,   215,     0,   216,   217,     0,   188,     0,   218,     0,
       0,     0,     0,     0,     0,     0,     0,    27,    28,    29,
      30,    31,    32,     0,     0,     0,     0,     0,    33,    -6,
      34,   192,     0,     0,    35,     0,     0,     0,   414,    36,
       0,     0,     0,     0,    37,   197,    38,   198,    39,    40,
       0,   415,   416,   417,     0,     0,    41,     0,    42,     0,
       0,     0,   418,     0,    43,     0,     0,     0,   -51,     0,
     419,    44,    45,   202,   420,     0,     0,    46,     0,    47,
       0,    48,    49,    50,    51,     0,    52,   421,     0,    53,
     -51,     0,   -51,     0,     0,     0,   422,   423,   211,   212,
     213,   214,   215,     0,   216,   217,     0,     0,    59,   218,
       0,     0,    60,   424,     0,     0,     0,     0,    61,    62,
     188,     0,     0,     0,     0,     0,     0,   425,     0,     0,
       0,     0,     0,     0,     0,   426,     0,   427,   428,     0,
       0,   429,     0,     0,     0,   192,     0,   430,     0,     0,
       0,   431,   432,   433,   434,    10,    12,     0,     0,   197,
       0,   198,   -51,    13,    14,    15,     0,    16,    17,    18,
      19,   435,    21,    22,     0,     0,   436,    96,     0,    97,
       0,     0,    98,     0,    99,     0,   100,   202,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   437,
       0,   101,     0,     0,   102,     0,   103,   188,     0,     0,
       0,     0,     0,     0,   213,   214,   215,     0,   216,   217,
       0,     0,     0,   218,   693,   694,   695,   696,   108,     0,
     109,   110,   192,   111,   112,    33,     0,   113,     0,     0,
       0,     0,     0,     0,     0,   114,   197,   177,   198,     0,
       0,   115,     0,     0,     0,     0,   116,   199,   200,     0,
       0,     0,   117,   118,     0,   119,     0,     0,   120,     0,
       0,   121,   122,   123,   202,     0,     0,     0,   124,     0,
       0,     0,     0,     0,   125,   126,     0,     0,   697,   698,
     699,   700,   131,     0,     0,     0,   132,   133,   134,   211,
     212,   213,   214,   215,     0,   216,   217,     0,    55,     0,
     218,     0,    58,    10,    12,   135,     0,     0,     0,   136,
    -398,    13,    14,    15,     0,    16,    17,    18,    19,     0,
      21,    22,     0,     0,     0,    96,     0,    97,     0,     0,
      98,     0,    99,     0,   100,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   101,
       0,     0,   102,     0,   103,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   104,   105,   106,   107,   108,     0,   109,   110,
       0,   111,   112,    33,     0,   113,     0,     0,     0,     0,
       0,     0,     0,   114,     0,     0,     0,     0,     0,   115,
       0,     0,     0,     0,   116,     0,     0,     0,     0,     0,
     117,   118,     0,   119,     0,     0,   120,     0,     0,   121,
     122,   123,     0,     0,     0,     0,   124,     0,     0,     0,
       0,     0,   125,   126,     0,     0,   127,   128,   129,   130,
     131,     0,     0,     0,   132,   133,   134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    55,     0,     0,     0,
      58,    10,    12,   135,     0,     0,     0,   136,     0,    13,
      14,    15,     0,    16,    17,    18,    19,     0,    21,    22,
       0,     0,     0,    96,     0,    97,     0,     0,    98,     0,
      99,     0,   100,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   101,     0,     0,
     102,     0,   103,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     693,   694,   695,   696,   108,     0,   109,   110,     0,   111,
     112,    33,     0,   113,     0,     0,     0,     0,     0,     0,
       0,   114,     0,     0,     0,     0,     0,   115,     0,     0,
       0,     0,   116,     0,     0,     0,     0,     0,   117,   118,
       0,   119,     0,     0,   120,     0,     0,   121,   122,   123,
       0,     0,     0,     0,   124,     0,    10,    12,     0,     0,
     125,   126,     0,     0,   697,   698,   699,   700,   131,     0,
       0,     0,   132,   133,   134,     0,     0,     0,    96,     0,
      97,     0,   223,    98,    55,    99,     0,   100,    58,     0,
       0,   135,   224,     0,     0,   701,     0,     0,     0,     0,
       0,     0,   101,     0,     0,   102,     0,   103,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   104,   105,   106,   107,   108,
       0,   109,   110,     0,   111,   112,     0,     0,   225,   415,
     416,   417,     0,     0,     0,     0,   114,     0,     0,     0,
     418,     0,   226,     0,     0,     0,   -51,   116,   419,     0,
       0,     0,   420,   117,   227,     0,   228,     0,     0,   120,
       0,     0,   121,   122,   123,   421,     0,     0,     0,   124,
       0,     0,     0,     0,   422,   229,   126,     0,     0,   127,
     128,   129,   130,   131,     0,     0,     0,   230,   133,   134,
       0,   424,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   371,   415,   416,   417,     0,     0,     0,     0,
       0,     0,     0,   426,   418,   427,   428,     0,     0,   429,
     -51,     0,   419,     0,     0,   430,   420,     0,     0,   431,
     432,   433,   434,     0,     0,     0,     0,     0,     0,   421,
     -51,     0,     0,     0,     0,     0,     0,     0,   422,   435,
       0,     0,     0,     0,   436,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   424,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   437,   -69,     0,
       0,     0,     0,     0,     0,     0,     0,   426,     0,   427,
     428,    10,    12,   429,     0,     0,     0,     0,     0,   430,
       0,     0,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,     0,    96,   -51,    97,     0,   223,    98,     0,
      99,     0,   100,   435,     0,     0,     0,   224,   436,     0,
       0,     0,     0,     0,     0,     0,     0,   101,     0,     0,
     102,     0,   103,     0,     0,     0,     0,     0,     0,     0,
       0,   437,     0,     0,     0,     0,     0,     0,     0,     0,
     104,   105,   106,   107,   108,     0,   109,   110,     0,   111,
     112,     0,     0,   225,     0,     0,     0,     0,     0,     0,
       0,   114,     0,     0,     0,     0,     0,   226,     0,     0,
       0,     0,   116,     0,     0,     0,     0,     0,   117,   227,
       0,   228,     0,     0,   120,     0,     0,   121,   122,   123,
       0,     0,     0,     0,   124,    10,    12,     0,     0,     0,
     229,   126,     0,     0,   127,   128,   129,   130,   131,     0,
       0,     0,   230,   133,   134,     0,     0,    96,     0,    97,
       0,     0,    98,     0,    99,     0,   100,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   101,     0,     0,   102,     0,   103,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   104,   105,   106,   107,   108,     0,
     109,   110,     0,   111,   112,     0,     0,   225,     0,   184,
       0,     0,     0,     0,     0,   114,     0,     0,     0,     0,
       0,   226,     0,     0,     0,     0,   116,     0,     0,   185,
       0,     0,   117,   227,     0,   228,   186,     0,   120,     0,
       0,   121,   122,   123,     0,   187,     0,   188,   124,     0,
       0,     0,   189,     0,   229,   126,     0,     0,   127,   128,
     129,   130,   131,   190,     0,     0,   230,   133,   134,     0,
       0,   191,   192,     0,     0,   193,     0,     0,     0,   194,
       0,     0,     0,   195,     0,   196,   197,     0,   198,     0,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   184,     0,     0,     0,     0,     0,
       0,   203,   204,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   185,   216,   217,     0,     0,     0,
     218,   186,     0,     0,     0,     0,     0,     0,     0,     0,
     187,     0,   188,     0,     0,     0,     0,   189,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   190,     0,
       0,     0,     0,     0,     0,     0,   191,   192,     0,     0,
     193,     0,     0,     0,   194,     0,     0,     0,   195,     0,
     196,   197,     0,   198,     0,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   184,
       0,     0,     0,     0,     0,     0,   203,   204,   410,   206,
     207,   208,   209,   210,   211,   212,   213,   214,   215,   185,
     216,   217,     0,     0,     0,   218,   186,     0,     0,     0,
       0,     0,     0,     0,     0,   187,     0,   188,     0,     0,
       0,     0,   189,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   190,     0,     0,     0,     0,     0,     0,
       0,   191,   192,     0,     0,   193,     0,     0,     0,   194,
       0,     0,     0,   195,     0,   196,   197,     0,   198,     0,
     184,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     185,     0,   201,     0,   202,     0,     0,   186,     0,     0,
       0,     0,     0,     0,     0,     0,   187,     0,   188,     0,
       0,   203,   204,   189,   206,   207,   289,   209,   210,   211,
     212,   213,   214,   215,   190,   216,   217,     0,     0,     0,
     218,     0,   191,   192,     0,     0,   193,     0,     0,     0,
     194,     0,     0,     0,   195,     0,   196,   197,     0,   198,
       0,   184,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   201,     0,   202,     0,     0,   186,     0,
       0,     0,     0,     0,     0,     0,     0,   187,     0,   188,
       0,     0,   203,   204,   189,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   215,   190,   216,   217,     0,     0,
       0,   218,     0,     0,   192,     0,     0,   193,     0,     0,
       0,   194,     0,     0,     0,   195,     0,     0,   197,     0,
     198,     0,   184,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   202,     0,     0,   186,
       0,     0,     0,     0,     0,     0,     0,     0,   187,     0,
     188,     0,     0,     0,   204,   189,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   190,   216,   217,     0,
       0,     0,   218,     0,     0,   192,     0,     0,   193,     0,
       0,     0,   194,     0,     0,     0,   195,     0,     0,   197,
       0,   198,     0,   184,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   202,     0,     0,
     186,     0,     0,     0,     0,     0,     0,     0,     0,   187,
       0,   188,     0,     0,     0,   204,   189,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,   190,   216,   217,
       0,     0,     0,   218,     0,     0,   192,     0,     0,   193,
       0,     0,     0,   194,     0,     0,     0,   195,     0,     0,
     197,     0,   198,     0,   184,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   202,     0,
       0,   186,     0,     0,     0,     0,     0,     0,     0,     0,
     187,     0,   188,     0,     0,     0,   204,   189,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   190,   216,
     217,     0,     0,     0,   218,     0,     0,   192,     0,     0,
     193,     0,     0,     0,   194,     0,     0,     0,   195,     0,
       0,   197,     0,   198,     0,   184,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   202,
       0,     0,   186,     0,     0,     0,     0,     0,     0,     0,
       0,   187,     0,   188,     0,     0,     0,   204,   189,   206,
     207,   208,   209,   210,   211,   212,   213,   214,   215,   190,
     216,   217,     0,     0,     0,   218,     0,     0,   192,     0,
       0,   193,     0,     0,     0,   194,     0,     0,     0,   195,
       0,     0,   197,     0,   198,     0,   184,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     202,     0,     0,   186,     0,     0,     0,     0,     0,     0,
       0,     0,   187,     0,   188,     0,     0,     0,   204,   189,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     190,   216,   217,     0,     0,     0,   218,     0,     0,   192,
       0,     0,   193,     0,     0,     0,   194,     0,     0,     0,
     195,     0,     0,   197,     0,   198,     0,   184,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   202,     0,     0,   186,     0,     0,     0,     0,     0,
       0,     0,     0,   187,     0,   188,     0,     0,     0,     0,
     189,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   190,   216,   217,     0,     0,     0,   218,     0,     0,
     192,     0,     0,   193,     0,     0,     0,   194,     0,     0,
       0,     0,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,     0,
       0,     0,    96,     0,    97,     0,     0,    98,     0,    99,
       0,   100,   202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   101,     0,     0,   102,
       0,   103,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,     0,   216,   217,     0,     0,     0,   218,   104,
     105,   106,   107,   108,     0,   109,   110,     0,   111,   112,
       0,     0,   225,     0,     0,     0,     0,     0,     0,     0,
     114,     0,     0,     0,     0,     0,   226,    96,     0,    97,
       0,   116,    98,     0,    99,     0,   100,   117,   227,     0,
     228,     0,     0,   120,     0,     0,   121,   122,   123,     0,
       0,   101,     0,   124,   102,     0,   103,     0,     0,   229,
     126,     0,     0,   127,   128,   129,   130,   131,     0,     0,
       0,   230,   133,   134,   104,   105,   106,   107,   108,     0,
     109,   110,     0,   111,   112,     0,     0,   225,     0,     0,
       0,     0,     0,   186,     0,   114,     0,     0,     0,     0,
       0,   226,   187,     0,   188,     0,   116,     0,     0,   189,
       0,     0,   117,   227,     0,   228,     0,     0,   120,     0,
     190,   121,   122,   123,     0,     0,     0,     0,   124,   192,
       0,     0,   193,     0,   229,   126,   194,     0,   127,   128,
     129,   130,   131,   197,     0,   198,   230,   133,   134,     0,
       0,     0,     0,     0,   199,   200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   202,     0,     0,   186,     0,     0,     0,     0,     0,
       0,     0,     0,   187,     0,   188,     0,     0,     0,     0,
       0,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   190,   216,   217,     0,     0,     0,   218,     0,     0,
     192,     0,     0,   193,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   202,     0,     0,   186,     0,     0,     0,     0,
       0,     0,     0,     0,   187,     0,   188,     0,     0,     0,
       0,     0,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   190,   216,   217,     0,     0,     0,   218,     0,
       0,   192,     0,     0,   193,     0,     0,   187,     0,   188,
       0,     0,     0,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,     0,   190,   199,   200,     0,     0,
       0,     0,     0,     0,   192,     0,     0,     0,     0,     0,
       0,     0,     0,   202,     0,     0,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   206,   207,   208,   209,   210,   211,   212,
     213,   214,   215,     0,   216,   217,   202,     0,     0,   218,
       0,     0,     0,     0,     0,     0,     0,     0,   187,     0,
     188,     0,     0,     0,     0,     0,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   190,   216,   217,   188,
       0,     0,   218,     0,     0,   192,     0,     0,     0,     0,
       0,     0,     0,     0,   188,     0,     0,     0,     0,   197,
       0,   198,     0,     0,   192,     0,     0,     0,     0,     0,
     199,   200,     0,     0,     0,     0,     0,     0,   197,   192,
     198,     0,     0,     0,     0,     0,     0,   202,     0,   199,
     200,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,     0,     0,   199,   200,   202,   206,   207,   208,
     209,   210,   211,   212,   213,   214,   215,     0,   216,   217,
       0,   202,     0,   218,     0,     0,   188,     0,   208,   209,
     210,   211,   212,   213,   214,   215,     0,   216,   217,     0,
       0,   188,   218,   208,   209,   210,   211,   212,   213,   214,
     215,   192,   216,   217,     0,     0,   188,   218,     0,     0,
       0,     0,     0,     0,     0,   197,   192,   198,     0,     0,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     197,   192,   198,     0,     0,     0,     0,     0,     0,     0,
       0,   199,   200,   202,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,     0,     0,   199,   200,   202,     0,
       0,     0,     0,     0,     0,   208,   209,   210,   211,   212,
     213,   214,   215,   202,   216,   217,     0,     0,     0,   218,
     208,   209,   210,   211,   212,   213,   214,   215,     0,   216,
     217,     0,     0,     0,   218,     0,     0,   210,   211,   212,
     213,   214,   215,     0,   216,   217,     0,     0,     0,   218
  };

  const short
  Parser::yycheck_[] =
  {
       4,    36,    36,   525,   157,   416,   490,     2,    38,   246,
     636,   658,    36,   299,   752,    91,   597,     3,   578,     8,
     336,    28,     3,    95,   719,     8,    28,     7,    39,    28,
      18,    67,    95,     3,     3,     8,   132,     8,   275,   150,
       9,   753,    60,     8,   566,   652,     8,     8,     3,   286,
       8,   288,     3,   155,     9,     8,   663,   664,   169,    83,
     457,    36,   152,   689,    59,    60,   151,   169,    92,    44,
      94,   167,     8,     9,   163,   151,    36,    91,   167,   169,
     156,   148,   167,   148,    44,     8,    81,   163,   155,    84,
      85,    86,    87,    88,    89,    90,   168,   809,    67,   166,
     812,   166,   155,    18,   148,   168,    83,    48,   505,     0,
     507,   155,    67,     8,     3,    92,   169,    94,     8,    70,
       9,   437,   133,    59,     3,   362,   363,     8,   152,    98,
     367,   368,   369,     3,   371,   166,   172,   374,   162,     9,
     164,   136,   218,    98,    67,   382,   383,   116,   166,   119,
     145,   846,   159,   122,   149,   150,     8,   159,   153,   154,
     155,   116,   157,   158,   159,   160,   161,   122,   156,   171,
     169,   107,    67,   160,   143,   152,   783,    67,    67,   786,
     787,   170,     8,   166,   188,   162,    67,   164,   143,   175,
     171,   798,   172,   166,   270,   166,   171,    67,   202,   937,
     224,   166,   171,   687,   166,   166,   151,   148,   166,    98,
     205,   171,   216,   166,   567,    67,   171,   454,   455,   148,
     801,   781,   217,   460,   510,   541,   155,   116,    98,    39,
     167,   255,   256,   122,   170,   259,   260,   261,   262,     8,
     264,   156,   157,   267,   268,   852,   116,   768,   769,   770,
     254,    61,   122,    63,   143,     8,     9,   167,   155,     8,
     264,   531,   811,   704,   151,   706,   536,   167,   621,   895,
       3,   755,   169,   143,   758,   628,     9,   153,   255,   256,
     167,   170,   259,   260,   261,   262,   835,   151,   292,   838,
     267,   268,   841,   842,   901,   148,   291,   202,    67,   294,
      36,   171,   155,   167,   299,   952,    59,   148,    44,   830,
     169,   216,   171,   166,   155,   339,   340,   341,    67,   167,
     557,   151,   148,   133,   808,   167,   152,   680,   769,   155,
      64,   772,   167,   357,    67,   411,   169,   167,   167,   172,
     166,   336,   168,   169,   170,   151,   891,   148,   893,   150,
     426,   704,   897,   898,   107,    89,   151,   151,   166,   354,
     168,   167,   339,   340,   341,    98,   370,   167,   917,   103,
     400,   105,   167,   167,    64,   167,   380,   381,   615,   150,
     357,   167,   793,   116,   167,   869,     3,   871,   167,   122,
     152,   386,     9,   155,   939,   166,   166,   131,   168,    89,
     424,   167,   924,   756,   167,   148,   759,   150,   167,   562,
     143,    17,    18,   103,   167,   105,   795,   170,   797,   423,
     415,   774,   417,   776,    18,   420,   779,   780,   162,   163,
     761,   762,   763,   167,   429,   918,   919,   170,   167,   434,
     435,   131,   437,   926,   927,   469,   765,   766,   767,   167,
      67,   167,   805,   477,   478,   164,   165,   168,   169,   463,
     167,   456,   457,    64,     3,     3,     4,   950,   166,   167,
       9,   167,   162,   163,   478,   828,   829,   167,   831,   168,
     833,    98,   486,     3,   488,   638,   490,   167,    89,     9,
     148,   902,   469,   170,   167,   167,   170,   167,   167,   116,
     477,    14,   103,    58,   508,   122,   172,   169,   168,   168,
     505,   160,   507,   866,   509,   510,   169,   521,   513,   543,
     168,   545,   546,   168,   548,   168,   143,   522,    67,   563,
     131,   168,   168,   886,   558,   888,   531,   168,   562,   168,
      64,   536,   168,   168,   168,   150,   541,    67,   701,   169,
      18,    11,    11,   170,   170,   168,     7,   169,   168,    98,
     168,   162,   163,   172,   168,    89,   167,   167,   563,   168,
     565,   548,   596,   568,   578,   168,   168,   116,    98,   103,
     933,   558,   935,   122,   168,   562,   590,   168,   168,   168,
     585,   168,   168,   168,   168,   167,   116,   167,   148,   168,
     595,   168,   122,   638,   143,   168,   152,   131,   150,    22,
      23,    24,   155,   637,   638,   619,   168,    69,   169,   596,
      33,   168,   167,   143,   160,   166,    39,   167,    41,   166,
     150,   166,    45,   167,    64,   167,   166,   166,   162,   163,
     167,   166,    18,   167,   668,    58,   167,   166,   166,   644,
     167,   150,    70,   648,    67,   650,   651,   652,   150,    89,
     637,   148,   167,   167,   171,   150,   701,   662,   663,   664,
     167,    84,   676,   103,   168,   105,    84,   701,   168,   167,
     166,     6,   166,   687,   679,   166,   166,   166,   683,   166,
     166,   715,   167,   106,   168,   108,   109,   773,   171,   112,
     170,   131,   168,   170,   150,   118,   701,   168,   166,   122,
     123,   124,   125,   168,   738,    69,    64,   741,   742,   714,
     133,   168,   167,   150,   168,   168,   168,    64,   723,   142,
      11,   150,   162,   163,   147,    64,     8,   167,   715,   148,
     155,    89,   737,   167,   155,   740,   148,   148,   752,   753,
     155,   755,    89,   117,   758,   103,   166,   170,   171,    18,
      89,   738,   168,    35,   741,   742,   103,    39,   105,   168,
     166,   166,     5,   166,   103,   148,   168,   781,   150,   170,
     775,    64,    54,   131,    56,    57,   170,   148,   783,    61,
      62,   786,   787,   150,   131,   150,   171,   792,   168,   170,
      24,    28,   131,   798,   808,   809,    89,   167,   812,    33,
      34,   167,    50,   172,   162,   163,   167,   167,    42,   167,
     103,   167,   105,   167,   167,   162,   163,   167,    52,    53,
     167,   114,   115,   162,   163,   167,   163,   168,   167,   148,
     168,    50,   168,    18,   168,   167,     8,   167,   131,   168,
     845,   163,   166,    64,   172,   150,   166,   852,   166,    18,
     171,    18,   168,   858,   168,   869,   861,   871,   168,   168,
     865,   154,   155,   156,   157,   158,   159,   160,    89,   162,
     163,    18,   168,   168,   167,   109,   110,    28,   168,   113,
     168,    64,   103,   168,   118,   119,   172,   167,    50,   894,
     168,   125,    18,    50,   166,   166,   901,   931,   132,   133,
     150,   166,   184,   185,   186,   187,    89,   189,   190,   191,
     131,   193,   194,   195,   196,   148,   198,   199,   200,   201,
     103,   203,   204,   937,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   170,   166,   168,   166,   336,   336,
     170,   162,   163,   171,   931,   336,   167,   692,   131,   481,
     733,   224,   478,   463,   562,   908,   676,   832,   689,   701,
     701,   701,   400,   485,   295,   219,   618,   510,   356,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   162,
     163,    -1,    -1,    -1,   167,    -1,    -1,    -1,    -1,    -1,
      -1,   225,    -1,   227,   228,   229,   230,     0,    -1,    -1,
       3,     4,    -1,    -1,    -1,    -1,     9,   289,    11,    12,
      13,    -1,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    -1,    -1,    31,    -1,
      33,    -1,    -1,    -1,    37,    -1,    39,    -1,    41,    -1,
      -1,    -1,    45,    -1,    47,    -1,    -1,    -1,    51,    -1,
      -1,    -1,    -1,    -1,    -1,    58,    -1,    -1,    61,    -1,
      63,    -1,    -1,    -1,    67,    68,    -1,    -1,    -1,    72,
      73,    74,    75,    76,    77,    -1,    -1,    -1,    -1,    -1,
      83,    84,    85,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    94,    -1,    -1,    -1,    98,    99,    -1,   101,    -1,
     103,   104,    -1,   106,    -1,   108,   109,    -1,   111,   112,
     113,    -1,    -1,    -1,    -1,   118,   119,    -1,    -1,   122,
     123,   124,   125,   126,   127,    -1,    -1,    -1,   410,   132,
     133,   134,    -1,   136,   137,   138,   139,    -1,   141,   142,
      -1,   144,    -1,    -1,   147,    -1,    -1,    -1,    -1,    -1,
     153,    -1,    -1,   156,   157,    -1,   159,   160,    -1,    -1,
     163,    -1,    -1,    -1,   167,     0,    -1,   170,     3,     4,
     173,   174,    -1,    -1,     9,    -1,    11,    12,    13,    -1,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    -1,    31,    -1,    33,    -1,
      -1,    -1,    37,    -1,    39,    -1,    41,    -1,    -1,    -1,
      45,    -1,    47,    -1,    -1,    -1,    51,    -1,    -1,    -1,
      -1,    -1,    -1,    58,    -1,    -1,    61,    -1,    63,    -1,
      -1,    -1,    67,    68,    -1,    -1,    -1,    72,    73,    74,
      75,    76,    77,    -1,    -1,    -1,    -1,    -1,    83,    84,
      85,    -1,    -1,    -1,    89,    -1,    -1,    -1,    -1,    94,
      -1,    -1,    -1,    98,    99,    -1,   101,    -1,   103,   104,
      -1,   106,    -1,   108,   109,    -1,   111,   112,   113,    -1,
      -1,    -1,    -1,   118,   119,    -1,    -1,   122,   123,   124,
     125,   126,   127,    -1,    -1,    -1,    -1,   132,   133,   134,
      -1,   136,   137,   138,   139,    -1,   141,   142,    -1,   144,
      -1,    -1,   147,    -1,    -1,    -1,    -1,    -1,   153,    -1,
      -1,   156,   157,    -1,   159,   160,    -1,    64,   163,    -1,
      -1,    -1,   167,     3,     4,   170,    -1,    -1,   173,   174,
      -1,    11,    12,    13,    -1,    15,    16,    17,    18,    19,
      20,    21,    89,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    31,    -1,    -1,    -1,    -1,   103,    37,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    47,    -1,    -1,
      -1,    51,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   131,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    73,    74,    75,    76,    77,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    85,    -1,    -1,    -1,    89,
      -1,   158,   159,   160,    94,   162,   163,    -1,    -1,    99,
     167,   101,    -1,   103,   104,    -1,    -1,    -1,    -1,    -1,
      -1,   111,    -1,   113,    -1,    -1,    -1,    -1,    -1,   119,
      -1,    -1,    -1,    -1,    -1,    64,   126,   127,    -1,    -1,
      -1,    -1,   132,    -1,   134,    -1,   136,   137,   138,   139,
      -1,   141,    -1,    -1,   144,    -1,    -1,    -1,    -1,    -1,
      89,    -1,    -1,   153,    -1,    -1,   156,   157,    -1,   159,
     160,    -1,    -1,   163,   103,    -1,   105,   167,     3,     4,
      -1,    -1,    -1,   173,   174,    -1,    11,    12,    13,    -1,
      15,    16,    17,    18,    19,    20,    21,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    -1,    -1,    31,    -1,    -1,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    47,    -1,    -1,    -1,    51,   156,   157,   158,
     159,   160,    -1,   162,   163,    -1,    64,    -1,   167,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    73,    74,
      75,    76,    77,    -1,    -1,    -1,    -1,    -1,    83,     0,
      85,    89,    -1,    -1,    89,    -1,    -1,    -1,     9,    94,
      -1,    -1,    -1,    -1,    99,   103,   101,   105,   103,   104,
      -1,    22,    23,    24,    -1,    -1,   111,    -1,   113,    -1,
      -1,    -1,    33,    -1,   119,    -1,    -1,    -1,    39,    -1,
      41,   126,   127,   131,    45,    -1,    -1,   132,    -1,   134,
      -1,   136,   137,   138,   139,    -1,   141,    58,    -1,   144,
      61,    -1,    63,    -1,    -1,    -1,    67,    68,   156,   157,
     158,   159,   160,    -1,   162,   163,    -1,    -1,   163,   167,
      -1,    -1,   167,    84,    -1,    -1,    -1,    -1,   173,   174,
      64,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   106,    -1,   108,   109,    -1,
      -1,   112,    -1,    -1,    -1,    89,    -1,   118,    -1,    -1,
      -1,   122,   123,   124,   125,     3,     4,    -1,    -1,   103,
      -1,   105,   133,    11,    12,    13,    -1,    15,    16,    17,
      18,   142,    20,    21,    -1,    -1,   147,    25,    -1,    27,
      -1,    -1,    30,    -1,    32,    -1,    34,   131,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   170,
      -1,    49,    -1,    -1,    52,    -1,    54,    64,    -1,    -1,
      -1,    -1,    -1,    -1,   158,   159,   160,    -1,   162,   163,
      -1,    -1,    -1,   167,    72,    73,    74,    75,    76,    -1,
      78,    79,    89,    81,    82,    83,    -1,    85,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    93,   103,    95,   105,    -1,
      -1,    99,    -1,    -1,    -1,    -1,   104,   114,   115,    -1,
      -1,    -1,   110,   111,    -1,   113,    -1,    -1,   116,    -1,
      -1,   119,   120,   121,   131,    -1,    -1,    -1,   126,    -1,
      -1,    -1,    -1,    -1,   132,   133,    -1,    -1,   136,   137,
     138,   139,   140,    -1,    -1,    -1,   144,   145,   146,   156,
     157,   158,   159,   160,    -1,   162,   163,    -1,   156,    -1,
     167,    -1,   160,     3,     4,   163,    -1,    -1,    -1,   167,
     168,    11,    12,    13,    -1,    15,    16,    17,    18,    -1,
      20,    21,    -1,    -1,    -1,    25,    -1,    27,    -1,    -1,
      30,    -1,    32,    -1,    34,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    49,
      -1,    -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    73,    74,    75,    76,    -1,    78,    79,
      -1,    81,    82,    83,    -1,    85,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    -1,    -1,    -1,    -1,    -1,    99,
      -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,
     110,   111,    -1,   113,    -1,    -1,   116,    -1,    -1,   119,
     120,   121,    -1,    -1,    -1,    -1,   126,    -1,    -1,    -1,
      -1,    -1,   132,   133,    -1,    -1,   136,   137,   138,   139,
     140,    -1,    -1,    -1,   144,   145,   146,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   156,    -1,    -1,    -1,
     160,     3,     4,   163,    -1,    -1,    -1,   167,    -1,    11,
      12,    13,    -1,    15,    16,    17,    18,    -1,    20,    21,
      -1,    -1,    -1,    25,    -1,    27,    -1,    -1,    30,    -1,
      32,    -1,    34,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    49,    -1,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    83,    -1,    85,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,
      -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,   110,   111,
      -1,   113,    -1,    -1,   116,    -1,    -1,   119,   120,   121,
      -1,    -1,    -1,    -1,   126,    -1,     3,     4,    -1,    -1,
     132,   133,    -1,    -1,   136,   137,   138,   139,   140,    -1,
      -1,    -1,   144,   145,   146,    -1,    -1,    -1,    25,    -1,
      27,    -1,    29,    30,   156,    32,    -1,    34,   160,    -1,
      -1,   163,    39,    -1,    -1,   167,    -1,    -1,    -1,    -1,
      -1,    -1,    49,    -1,    -1,    52,    -1,    54,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    73,    74,    75,    76,
      -1,    78,    79,    -1,    81,    82,    -1,    -1,    85,    22,
      23,    24,    -1,    -1,    -1,    -1,    93,    -1,    -1,    -1,
      33,    -1,    99,    -1,    -1,    -1,    39,   104,    41,    -1,
      -1,    -1,    45,   110,   111,    -1,   113,    -1,    -1,   116,
      -1,    -1,   119,   120,   121,    58,    -1,    -1,    -1,   126,
      -1,    -1,    -1,    -1,    67,   132,   133,    -1,    -1,   136,
     137,   138,   139,   140,    -1,    -1,    -1,   144,   145,   146,
      -1,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   159,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   106,    33,   108,   109,    -1,    -1,   112,
      39,    -1,    41,    -1,    -1,   118,    45,    -1,    -1,   122,
     123,   124,   125,    -1,    -1,    -1,    -1,    -1,    -1,    58,
     133,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,   142,
      -1,    -1,    -1,    -1,   147,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   170,   171,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   106,    -1,   108,
     109,     3,     4,   112,    -1,    -1,    -1,    -1,    -1,   118,
      -1,    -1,    -1,   122,   123,   124,   125,    -1,    -1,    -1,
      -1,    -1,    -1,    25,   133,    27,    -1,    29,    30,    -1,
      32,    -1,    34,   142,    -1,    -1,    -1,    39,   147,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    49,    -1,    -1,
      52,    -1,    54,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   170,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    73,    74,    75,    76,    -1,    78,    79,    -1,    81,
      82,    -1,    -1,    85,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,
      -1,    -1,   104,    -1,    -1,    -1,    -1,    -1,   110,   111,
      -1,   113,    -1,    -1,   116,    -1,    -1,   119,   120,   121,
      -1,    -1,    -1,    -1,   126,     3,     4,    -1,    -1,    -1,
     132,   133,    -1,    -1,   136,   137,   138,   139,   140,    -1,
      -1,    -1,   144,   145,   146,    -1,    -1,    25,    -1,    27,
      -1,    -1,    30,    -1,    32,    -1,    34,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    49,    -1,    -1,    52,    -1,    54,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    73,    74,    75,    76,    -1,
      78,    79,    -1,    81,    82,    -1,    -1,    85,    -1,    26,
      -1,    -1,    -1,    -1,    -1,    93,    -1,    -1,    -1,    -1,
      -1,    99,    -1,    -1,    -1,    -1,   104,    -1,    -1,    46,
      -1,    -1,   110,   111,    -1,   113,    53,    -1,   116,    -1,
      -1,   119,   120,   121,    -1,    62,    -1,    64,   126,    -1,
      -1,    -1,    69,    -1,   132,   133,    -1,    -1,   136,   137,
     138,   139,   140,    80,    -1,    -1,   144,   145,   146,    -1,
      -1,    88,    89,    -1,    -1,    92,    -1,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,   102,   103,    -1,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   129,    -1,   131,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,    -1,    -1,
      -1,   148,   149,   150,   151,   152,   153,   154,   155,   156,
     157,   158,   159,   160,    46,   162,   163,    -1,    -1,    -1,
     167,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      62,    -1,    64,    -1,    -1,    -1,    -1,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    88,    89,    -1,    -1,
      92,    -1,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
     102,   103,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   129,    -1,   131,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    26,
      -1,    -1,    -1,    -1,    -1,    -1,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,    46,
     162,   163,    -1,    -1,    -1,   167,    53,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    62,    -1,    64,    -1,    -1,
      -1,    -1,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    80,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    88,    89,    -1,    -1,    92,    -1,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,   102,   103,    -1,   105,    -1,
      26,    -1,    -1,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      46,    -1,   129,    -1,   131,    -1,    -1,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    62,    -1,    64,    -1,
      -1,   148,   149,    69,   151,   152,   153,   154,   155,   156,
     157,   158,   159,   160,    80,   162,   163,    -1,    -1,    -1,
     167,    -1,    88,    89,    -1,    -1,    92,    -1,    -1,    -1,
      96,    -1,    -1,    -1,   100,    -1,   102,   103,    -1,   105,
      -1,    26,    -1,    -1,    -1,    -1,    -1,    -1,   114,   115,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   129,    -1,   131,    -1,    -1,    53,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    62,    -1,    64,
      -1,    -1,   148,   149,    69,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,    80,   162,   163,    -1,    -1,
      -1,   167,    -1,    -1,    89,    -1,    -1,    92,    -1,    -1,
      -1,    96,    -1,    -1,    -1,   100,    -1,    -1,   103,    -1,
     105,    -1,    26,    -1,    -1,    -1,    -1,    -1,    -1,   114,
     115,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    62,    -1,
      64,    -1,    -1,    -1,   149,    69,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,    80,   162,   163,    -1,
      -1,    -1,   167,    -1,    -1,    89,    -1,    -1,    92,    -1,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,   103,
      -1,   105,    -1,    26,    -1,    -1,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,    -1,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    62,
      -1,    64,    -1,    -1,    -1,   149,    69,   151,   152,   153,
     154,   155,   156,   157,   158,   159,   160,    80,   162,   163,
      -1,    -1,    -1,   167,    -1,    -1,    89,    -1,    -1,    92,
      -1,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,
     103,    -1,   105,    -1,    26,    -1,    -1,    -1,    -1,    -1,
      -1,   114,   115,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,
      -1,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      62,    -1,    64,    -1,    -1,    -1,   149,    69,   151,   152,
     153,   154,   155,   156,   157,   158,   159,   160,    80,   162,
     163,    -1,    -1,    -1,   167,    -1,    -1,    89,    -1,    -1,
      92,    -1,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,   103,    -1,   105,    -1,    26,    -1,    -1,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,
      -1,    -1,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    62,    -1,    64,    -1,    -1,    -1,   149,    69,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,    80,
     162,   163,    -1,    -1,    -1,   167,    -1,    -1,    89,    -1,
      -1,    92,    -1,    -1,    -1,    96,    -1,    -1,    -1,   100,
      -1,    -1,   103,    -1,   105,    -1,    26,    -1,    -1,    -1,
      -1,    -1,    -1,   114,   115,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,    -1,    -1,    53,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    62,    -1,    64,    -1,    -1,    -1,   149,    69,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
      80,   162,   163,    -1,    -1,    -1,   167,    -1,    -1,    89,
      -1,    -1,    92,    -1,    -1,    -1,    96,    -1,    -1,    -1,
     100,    -1,    -1,   103,    -1,   105,    -1,    26,    -1,    -1,
      -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   131,    -1,    -1,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    62,    -1,    64,    -1,    -1,    -1,    -1,
      69,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,    80,   162,   163,    -1,    -1,    -1,   167,    -1,    -1,
      89,    -1,    -1,    92,    -1,    -1,    -1,    96,    -1,    -1,
      -1,    -1,    -1,    -1,   103,    -1,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,    -1,    25,    -1,    27,    -1,    -1,    30,    -1,    32,
      -1,    34,   131,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    49,    -1,    -1,    52,
      -1,    54,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,    -1,   162,   163,    -1,    -1,    -1,   167,    72,
      73,    74,    75,    76,    -1,    78,    79,    -1,    81,    82,
      -1,    -1,    85,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    -1,    -1,    -1,    -1,    -1,    99,    25,    -1,    27,
      -1,   104,    30,    -1,    32,    -1,    34,   110,   111,    -1,
     113,    -1,    -1,   116,    -1,    -1,   119,   120,   121,    -1,
      -1,    49,    -1,   126,    52,    -1,    54,    -1,    -1,   132,
     133,    -1,    -1,   136,   137,   138,   139,   140,    -1,    -1,
      -1,   144,   145,   146,    72,    73,    74,    75,    76,    -1,
      78,    79,    -1,    81,    82,    -1,    -1,    85,    -1,    -1,
      -1,    -1,    -1,    53,    -1,    93,    -1,    -1,    -1,    -1,
      -1,    99,    62,    -1,    64,    -1,   104,    -1,    -1,    69,
      -1,    -1,   110,   111,    -1,   113,    -1,    -1,   116,    -1,
      80,   119,   120,   121,    -1,    -1,    -1,    -1,   126,    89,
      -1,    -1,    92,    -1,   132,   133,    96,    -1,   136,   137,
     138,   139,   140,   103,    -1,   105,   144,   145,   146,    -1,
      -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   131,    -1,    -1,    53,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    62,    -1,    64,    -1,    -1,    -1,    -1,
      -1,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,    80,   162,   163,    -1,    -1,    -1,   167,    -1,    -1,
      89,    -1,    -1,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   103,    -1,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   131,    -1,    -1,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    62,    -1,    64,    -1,    -1,    -1,
      -1,    -1,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,    80,   162,   163,    -1,    -1,    -1,   167,    -1,
      -1,    89,    -1,    -1,    92,    -1,    -1,    62,    -1,    64,
      -1,    -1,    -1,    -1,    -1,   103,    -1,   105,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    80,   114,   115,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   131,    -1,    -1,    -1,    -1,   103,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   114,
     115,    -1,    -1,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   131,    -1,    -1,   167,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    62,    -1,
      64,    -1,    -1,    -1,    -1,    -1,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,    80,   162,   163,    64,
      -1,    -1,   167,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    64,    -1,    -1,    -1,    -1,   103,
      -1,   105,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,    -1,    -1,   103,    89,
     105,    -1,    -1,    -1,    -1,    -1,    -1,   131,    -1,   114,
     115,    -1,    -1,   103,    -1,   105,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   114,   115,   131,   151,   152,   153,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
      -1,   131,    -1,   167,    -1,    -1,    64,    -1,   153,   154,
     155,   156,   157,   158,   159,   160,    -1,   162,   163,    -1,
      -1,    64,   167,   153,   154,   155,   156,   157,   158,   159,
     160,    89,   162,   163,    -1,    -1,    64,   167,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   103,    89,   105,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,
     103,    89,   105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   114,   115,   131,    -1,   103,    -1,   105,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   114,   115,   131,    -1,
      -1,    -1,    -1,    -1,    -1,   153,   154,   155,   156,   157,
     158,   159,   160,   131,   162,   163,    -1,    -1,    -1,   167,
     153,   154,   155,   156,   157,   158,   159,   160,    -1,   162,
     163,    -1,    -1,    -1,   167,    -1,    -1,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,    -1,    -1,    -1,   167
  };

  const short
  Parser::yystos_[] =
  {
       0,   164,   165,   177,    91,   179,   178,   289,   290,     0,
       3,   181,     4,    11,    12,    13,    15,    16,    17,    18,
      19,    20,    21,    31,    37,    47,    51,    72,    73,    74,
      75,    76,    77,    83,    85,    89,    94,    99,   101,   103,
     104,   111,   113,   119,   126,   127,   132,   134,   136,   137,
     138,   139,   141,   144,   153,   156,   157,   159,   160,   163,
     167,   173,   174,   181,   182,   295,   296,   297,   299,   300,
     301,   306,   307,   308,   309,   310,   313,   314,   315,   166,
     160,   167,   151,   232,   167,   167,   167,   167,   167,   167,
     167,   167,   232,   167,   232,   296,    25,    27,    30,    32,
      34,    49,    52,    54,    72,    73,    74,    75,    76,    78,
      79,    81,    82,    85,    93,    99,   104,   110,   111,   113,
     116,   119,   120,   121,   126,   132,   133,   136,   137,   138,
     139,   140,   144,   145,   146,   163,   167,   182,   226,   234,
     237,   240,   243,   249,   299,   167,   301,   305,   296,   167,
     167,   167,   232,   167,   167,   167,   167,   167,   167,   167,
     167,   167,   232,   167,   232,   296,    17,    18,   296,   296,
     316,     7,   289,   293,   294,   311,   312,    95,   289,   302,
     304,   296,   296,   291,    26,    46,    53,    62,    64,    69,
      80,    88,    89,    92,    96,   100,   102,   103,   105,   114,
     115,   129,   131,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   162,   163,   167,   153,
     180,    18,   289,    29,    39,    85,    99,   111,   113,   132,
     144,   182,   226,   227,   228,   230,   231,   289,   289,   289,
     289,   289,   289,   289,   289,   293,   231,   292,   296,   319,
     320,   321,   231,   167,   170,   232,   232,   167,   167,   232,
     232,   232,   232,   170,   232,   167,   250,   232,   232,   289,
     167,   289,   289,   289,   293,   231,   289,   289,   289,   293,
     228,   289,   289,   289,   289,   289,   231,   293,   231,   153,
      14,   148,    58,   172,   169,   169,   172,   168,   168,   169,
     296,   296,   296,   296,   119,   181,   298,   296,   296,   296,
     296,   296,   296,   296,   296,   296,   296,   296,   298,   296,
     296,   289,   296,   296,   296,   296,   296,   296,   296,   296,
     296,   296,   298,   289,   293,   315,   186,   168,   230,   232,
     232,   232,   152,   155,   233,   168,   168,   168,   168,   168,
     168,   168,   168,   233,   150,   168,   169,   169,    18,   181,
     241,   242,   231,   231,    11,    11,   231,   231,   231,   231,
     238,   159,   181,   231,   235,   236,    70,   208,   209,   210,
     213,   170,   231,   231,   293,   168,   169,   168,   168,   233,
     168,   168,   168,   168,   168,   168,   168,   168,   168,   168,
     233,   168,   233,   317,   289,   181,   289,   312,   303,   304,
     150,   167,   172,   168,     9,    22,    23,    24,    33,    41,
      45,    58,    67,    68,    84,    98,   106,   108,   109,   112,
     118,   122,   123,   124,   125,   142,   147,   170,   187,   188,
     190,   193,   195,   199,   202,   203,   204,   205,   216,   219,
     224,   225,   289,   231,   231,   231,   167,   167,   289,   321,
     231,   168,   148,   169,   171,   233,   233,   168,   168,   169,
     233,   233,   233,   171,   181,   239,   233,   150,   169,   233,
     168,   169,   181,     9,    67,    98,   116,   122,   143,   181,
     251,   252,   253,   254,   255,   256,   258,   264,   265,   283,
     288,   233,   233,   168,   289,   167,   305,   167,   160,    69,
     169,   296,   293,   148,   166,   289,   292,   289,   166,   166,
     289,   167,   167,   181,   182,   279,   280,   293,   166,   289,
     166,   167,   166,   166,   289,   289,   167,   188,   190,   205,
     217,   218,   219,    39,    61,    63,   133,   166,   169,   233,
     233,   289,   302,   233,   244,    18,   242,   231,   150,   231,
     236,   210,   150,   148,   323,   167,   279,   181,   167,   284,
     181,   253,   171,   150,   168,   302,   302,   175,   181,   318,
     289,   303,   168,   289,   166,   150,   166,   166,   166,   181,
      84,   194,   289,    60,   166,   148,   150,   167,   276,   277,
       6,   166,   166,   194,   289,   166,   166,   194,   289,   171,
     219,   182,   206,   182,   182,   231,   168,   168,   167,   170,
     233,   231,   182,   227,   228,   229,   231,   226,   289,     8,
     166,   322,   289,   276,   323,   289,   170,   150,   266,   267,
     168,   168,   167,   318,    67,   172,   166,   289,    69,   181,
     166,   168,   168,   183,   184,   289,   231,   208,   278,   281,
     168,   168,   166,   168,   168,   191,   192,    11,   207,   196,
     197,   148,   233,   319,   181,   245,   246,   247,   323,   148,
     214,   166,   323,   148,   168,   166,   168,    28,   159,   285,
     286,   294,   231,    72,    73,    74,    75,   136,   137,   138,
     139,   167,   182,   228,   257,   261,   263,   299,   117,   268,
      18,   289,   166,   289,   148,   150,   289,   215,   219,   215,
     166,     5,   166,   148,   166,   168,     8,     9,    59,   107,
     216,   282,   170,   170,   289,   215,   215,   148,   150,   182,
     148,   150,   189,   168,   150,   171,   247,   166,   289,   323,
     166,   289,   170,   170,   253,    28,   171,   286,    28,   214,
     167,   167,   167,   167,   167,   167,   167,   167,   182,   257,
     261,   262,   263,   167,   269,   163,   270,   323,   270,   271,
     270,   168,   172,   168,   289,   231,   168,    50,   220,   220,
     185,   289,   148,    36,    44,   221,   222,   221,   168,   289,
     231,   167,   289,   198,   231,   231,    18,   252,   251,   170,
     253,   323,   170,   253,   323,    18,   156,   157,   259,   259,
     259,   259,    18,   156,   260,   260,   260,   260,   269,   269,
     270,   269,   168,   270,   293,   323,   172,   289,   323,    67,
     272,   323,   323,   318,   215,   148,   215,   215,   166,   289,
     223,   292,   150,   171,   222,   171,   215,   166,   148,   208,
     166,   148,   166,   323,    48,   148,   248,   171,   171,   251,
     272,   251,   166,    18,    18,   168,   168,   168,   168,    18,
     168,   168,   168,   168,   323,   323,   269,   323,   271,   323,
     168,   272,   172,   272,   167,    28,   273,   272,   272,   289,
     220,   150,   169,   215,   289,   168,   289,   166,    18,   289,
     323,    50,   287,   171,   166,   171,   323,   323,   273,   273,
     289,   294,   166,   274,   275,   276,   273,   273,   215,   292,
     166,   150,   211,   212,   166,   248,   166,   170,   166,   272,
     274,   274,   168,   276,   274,   274,   231,   323,   323,   252,
     273,   200,   201,   166,   171,   274,   166,   216
  };

  const short
  Parser::yyr1_[] =
  {
       0,   176,   177,   177,   178,   180,   179,   181,   182,   182,
     184,   185,   183,   186,   186,   186,   187,   187,   187,   187,
     187,   187,   187,   189,   188,   191,   190,   192,   190,   193,
     193,   193,   194,   194,   196,   195,   197,   195,   198,   198,
     200,   199,   201,   199,   202,   202,   203,   203,   204,   205,
     205,   205,   206,   207,   207,   208,   208,   209,   209,   210,
     211,   212,   212,   213,   213,   214,   214,   215,   216,   217,
     217,   218,   218,   219,   219,   219,   219,   219,   219,   219,
     219,   219,   219,   219,   219,   219,   219,   219,   219,   219,
     219,   219,   219,   219,   219,   219,   219,   219,   219,   219,
     220,   220,   221,   221,   222,   222,   223,   223,   224,   224,
     224,   225,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
     226,   227,   228,   227,   229,   229,   229,   230,   230,   231,
     231,   231,   231,   232,   233,   234,   234,   235,   235,   235,
     236,   236,   237,   238,   238,   239,   240,   241,   241,   241,
     242,   242,   244,   243,   245,   245,   246,   246,   247,   247,
     248,   248,   249,   250,   250,   251,   251,   252,   252,   253,
     253,   253,   253,   253,   253,   253,   254,   255,   256,   256,
     256,   257,   258,   258,   258,   258,   258,   258,   259,   259,
     259,   260,   260,   261,   261,   261,   261,   261,   261,   261,
     261,   261,   262,   262,   262,   262,   262,   263,   264,   265,
     265,   267,   266,   268,   268,   269,   269,   270,   270,   271,
     271,   272,   272,   273,   273,   274,   274,   275,   275,   276,
     277,   277,   278,   278,   280,   281,   279,   282,   282,   282,
     282,   283,   284,   284,   285,   285,   286,   286,   286,   286,
     286,   286,   287,   287,   288,   290,   291,   289,   292,   293,
     293,   294,   294,   295,   295,   296,   296,   296,   296,   296,
     296,   296,   296,   296,   296,   296,   296,   296,   296,   296,
     296,   296,   296,   296,   296,   296,   296,   296,   296,   296,
     296,   296,   296,   296,   296,   296,   296,   296,   296,   296,
     296,   296,   296,   296,   296,   296,   296,   296,   296,   296,
     296,   296,   296,   296,   296,   296,   296,   296,   296,   296,
     296,   296,   296,   296,   296,   296,   297,   298,   298,   299,
     299,   299,   299,   299,   299,   299,   299,   299,   299,   299,
     299,   299,   299,   299,   299,   299,   299,   299,   299,   299,
     300,   300,   300,   300,   300,   300,   300,   300,   300,   300,
     300,   300,   300,   300,   301,   301,   302,   302,   302,   303,
     303,   303,   303,   304,   304,   305,   306,   306,   306,   307,
     307,   308,   308,   309,   309,   310,   311,   311,   312,   313,
     314,   314,   316,   317,   315,   318,   318,   318,   319,   319,
     320,   320,   321,   322,   322,   323,   323
  };

  const signed char
  Parser::yyr2_[] =
  {
       0,     2,     2,     2,     1,     0,     5,     1,     1,     1,
       0,     0,     3,     2,     2,     0,     1,     1,     1,     1,
       1,     1,     1,     0,     8,     0,     7,     0,     9,     5,
       5,     7,     6,     4,     0,     7,     0,     6,     2,     4,
       0,    12,     0,    12,     3,     5,     2,     4,     3,     1,
       1,     0,     0,     1,     0,     1,     0,     3,     1,     6,
       2,     1,     0,     1,     0,     2,     0,     1,     3,     1,
       0,     2,     1,     2,     1,     1,     3,     5,     3,     2,
       2,     7,     6,     6,     8,     3,     2,     3,     2,     3,
       7,     7,     2,     2,     7,     5,     5,     3,     3,     3,
       2,     0,     2,     1,     4,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     4,     4,     4,     4,
       6,     4,     4,     1,     4,     4,     1,     1,     1,     1,
       1,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     4,     4,     3,     2,     1,
       1,     3,     4,     2,     0,     5,     4,     3,     2,     1,
       1,     3,     0,     8,     1,     0,     2,     1,     8,     6,
       2,     0,     5,     3,     0,     2,     1,     1,     0,     1,
       1,     1,     1,     1,     1,     1,     7,     4,     3,     5,
       4,     1,     8,     9,     9,     9,     9,    11,     1,     2,
       2,     1,     2,     1,     4,     4,     4,     4,     4,     4,
       4,     4,     3,     3,     3,     3,     4,     2,     3,     1,
       0,     0,     2,     1,     0,     3,     0,     3,     2,     1,
       0,     4,     0,     2,     0,     1,     1,     2,     1,     3,
       3,     0,     2,     0,     0,     0,     3,     1,     3,     1,
       1,     8,     3,     0,     2,     1,     5,     5,     4,     3,
       3,     2,     4,     0,     9,     0,     0,     3,     1,     1,
       0,     3,     1,     1,     3,     3,     3,     3,     3,     3,
       5,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     2,     2,     3,     2,     2,     4,     3,     6,
       2,     2,     3,     3,     3,     3,     1,     7,     2,     5,
       4,     4,     2,     2,     2,     5,     4,     4,     1,     1,
       7,     9,     3,     1,     1,     1,     4,     1,     1,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       2,     4,     4,     1,     1,     1,     1,     1,     1,     1,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     6,     3,     4,     1,     3,     0,     1,
       3,     1,     0,     1,     1,     1,     3,     4,     7,     4,
       7,     4,     7,     4,     9,     3,     3,     1,     3,     1,
       3,     1,     0,     0,     6,     2,     5,     0,     1,     0,
       3,     1,     3,     1,     3,     2,     0
  };


#if YYDEBUG || 1
  // YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
  // First, the terminals, then, starting at \a YYNTOKENS, nonterminals.
  const char*
  const Parser::yytname_[] =
  {
  "\"<end of input>\"", "error", "\"invalid token\"", "\"identifier\"",
  "\"scoped identifier\"", "\"dotted identifier\"", "\"hook identifier\"",
  "\"$-identifier\"", "\"attribute\"", "\"property\"",
  "\"preprocessor directive\"", "\"string value\"", "\"bytes value\"",
  "\"error value\"", "\"regular expression value\"", "\"address value\"",
  "\"port value\"", "\"real value\"", "\"unsigned integer value\"",
  "\"$<N>\"", "\"bool value\"", "\"null value\"", "\"assert\"",
  "\"assert-exception\"", "ADD", "ADDRESS", "AND", "ANY", "ARROW", "AUTO",
  "BITFIELD", "BEGIN_", "BOOL", "BREAK", "BYTES", "CADDR", "CASE", "CAST",
  "CATCH", "CONST", "CONSTANT", "CONTINUE", "DEBUG_", "DECLARE", "DEFAULT",
  "DELETE", "DIVIDEASSIGN", "DOLLARDOLLAR", "DOTDOT", "REAL", "ELSE",
  "END_", "ENUM", "EQ", "__ERROR", "EXCEPTION", "EXPORT", "FILE", "FOR",
  "FOREACH", "FROM", "FUNCTION", "GEQ", "GLOBAL", "HASATTR",
  "HOOK_COMPOSE", "HOOK_PARSE", "IF", "IMPORT", "IN", "INOUT", "INT",
  "INT16", "INT32", "INT64", "INT8", "INTERVAL", "INTERVAL_NS", "ITERATOR",
  "CONST_ITERATOR", "LEQ", "LIBRARY_TYPE", "LIBRARY_TYPE_CONST", "LIST",
  "LOCAL", "MAP", "MARK", "CAPTURES", "MINUSASSIGN", "MINUSMINUS", "MOD",
  "MODULE", "NEQ", "NETWORK", "NEW", "NONE", "NOT_IN", "OBJECT", "ON",
  "OPTIONAL", "OR", "PACK", "PLUSASSIGN", "PLUSPLUS", "PORT", "POW",
  "PRINT", "PRIORITY", "PRIVATE", "PUBLIC", "REGEXP", "RESULT", "RETURN",
  "SET", "SHIFTLEFT", "SHIFTRIGHT", "SINK", "SKIP", "STOP", "\"stream\"",
  "STRING", "STRUCT", "SWITCH", "\"confirm\"", "\"reject\"", "THROW",
  "TIME", "TIME_NS", "TIMER", "TIMESASSIGN", "TRY", "TRYATTR", "TUPLE",
  "TYPE", "TYPEINFO", "UINT", "UINT16", "UINT32", "UINT64", "UINT8",
  "UNIT", "UNPACK", "UNSET", "VAR", "VECTOR", "VIEW", "VOID", "WHILE",
  "'='", "'?'", "':'", "'<'", "'>'", "'|'", "'^'", "'&'", "'+'", "'-'",
  "'%'", "'*'", "'/'", "UNARY_PREC", "'.'", "'['", "START_MODULE",
  "START_EXPRESSION", "';'", "'('", "')'", "','", "'{'", "'}'", "']'",
  "'!'", "'~'", "'$'", "$accept", "start", "start_expr", "module", "$@1",
  "local_id", "scoped_id", "dotted_id", "$@2", "$@3", "global_scope_items",
  "global_scope_decl", "type_decl", "$@4", "constant_decl", "$@5", "$@6",
  "local_decl", "local_init_decl", "global_decl", "$@7", "$@8",
  "global_decl_type_and_init", "function_decl", "$@9", "$@10",
  "import_decl", "property_decl", "hook_decl", "opt_linkage",
  "opt_func_flavor", "opt_func_cc", "opt_func_params", "func_params",
  "func_param", "func_result", "opt_func_result", "opt_func_param_kind",
  "opt_init_expression", "block", "braced_block", "opt_stmts", "stmts",
  "stmt", "opt_else_block", "switch_cases", "switch_case", "case_exprs",
  "stmt_decl", "stmt_expr", "base_type_no_ref", "reference_type",
  "base_type", "type", "type_no_ref", "qtype", "type_param_begin",
  "type_param_end", "tuple_type", "tuple_type_elems", "tuple_type_elem",
  "struct_type", "struct_fields", "struct_field", "enum_type",
  "enum_labels", "enum_label", "bitfield_type", "$@11",
  "opt_bitfield_bit_ranges", "bitfield_bit_ranges", "bitfield_bit_range",
  "opt_bitfield_range_value", "unit_type", "opt_unit_params", "unit_items",
  "opt_unit_items", "unit_item", "unit_variable", "unit_sink",
  "unit_property", "unit_field_base_type", "unit_field", "const_sint",
  "const_uint", "unit_field_ctor", "unit_field_in_container",
  "scoped_id_in_container", "unit_wide_hook", "opt_unit_field_id",
  "opt_skip", "$@12", "opt_skip_", "opt_unit_field_args",
  "unit_field_repeat", "opt_unit_field_repeat", "opt_unit_field_condition",
  "opt_unit_field_sinks", "opt_unit_item_hooks", "unit_hooks", "unit_hook",
  "opt_unit_hook_params", "opt_unit_hook_attributes", "unit_hook_id",
  "$@13", "$@14", "unit_hook_attribute", "unit_switch",
  "opt_unit_switch_expr", "unit_switch_cases", "unit_switch_case",
  "opt_unit_block_else_items", "unit_block", "expr", "$@15", "$@16",
  "expr_no_or_error", "opt_exprs", "exprs", "expr_or_error", "expr_1",
  "call_expr", "member_expr", "ctor", "ctor_expr", "tuple",
  "opt_tuple_elems1", "opt_tuple_elems2", "tuple_elem", "tuple_expr",
  "list", "vector", "set", "map", "struct_", "struct_elems", "struct_elem",
  "regexp", "re_patterns", "re_pattern_constant", "$@17", "$@18",
  "opt_re_pattern_constant_flags", "opt_map_elems", "map_elems",
  "map_elem", "attribute", "opt_attributes", YY_NULLPTR
  };
#endif


#if YYDEBUG
  const short
  Parser::yyrline_[] =
  {
       0,   348,   348,   349,   352,   354,   354,   364,   376,   377,
     379,   381,   379,   386,   388,   390,   394,   395,   396,   397,
     398,   399,   400,   402,   402,   420,   420,   426,   426,   433,
     434,   435,   440,   442,   446,   446,   452,   452,   460,   461,
     464,   463,   474,   473,   484,   485,   488,   489,   492,   500,
     501,   502,   506,   508,   514,   518,   519,   521,   522,   524,
     527,   529,   530,   533,   534,   537,   538,   543,   550,   552,
     553,   555,   556,   558,   559,   560,   561,   562,   564,   566,
     567,   568,   570,   572,   574,   576,   577,   578,   579,   580,
     581,   583,   585,   586,   587,   589,   591,   594,   602,   610,
     621,   622,   624,   625,   627,   628,   630,   631,   633,   634,
     635,   638,   643,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   654,   655,   656,   657,   659,   660,   661,
     662,   663,   664,   665,   666,   668,   669,   670,   671,   672,
     674,   675,   676,   678,   680,   681,   684,   685,   686,   687,
     688,   693,   698,   699,   705,   706,   707,   710,   711,   714,
     715,   716,   717,   721,   725,   728,   729,   733,   735,   736,
     740,   741,   744,   746,   747,   749,   751,   753,   754,   755,
     758,   759,   763,   762,   768,   770,   773,   775,   778,   780,
     784,   785,   791,   795,   796,   798,   799,   801,   802,   805,
     806,   807,   808,   809,   810,   811,   815,   818,   820,   821,
     823,   825,   830,   832,   837,   840,   842,   844,   847,   848,
     849,   851,   852,   855,   856,   857,   858,   859,   860,   861,
     862,   863,   866,   868,   870,   872,   874,   880,   882,   885,
     886,   889,   889,   894,   895,   898,   899,   902,   903,   906,
     907,   910,   911,   914,   915,   918,   919,   921,   922,   924,
     928,   929,   932,   934,   936,   938,   936,   941,   942,   943,
     949,   956,   959,   960,   963,   965,   968,   969,   970,   971,
     972,   973,   976,   977,   979,   987,   989,   987,   994,   996,
     997,   999,  1000,  1002,  1003,  1006,  1007,  1008,  1009,  1010,
    1011,  1012,  1013,  1014,  1015,  1016,  1017,  1018,  1019,  1020,
    1021,  1022,  1023,  1024,  1025,  1026,  1027,  1028,  1029,  1030,
    1031,  1032,  1033,  1034,  1035,  1036,  1037,  1038,  1039,  1040,
    1041,  1042,  1043,  1044,  1045,  1046,  1047,  1048,  1049,  1050,
    1051,  1052,  1053,  1054,  1055,  1056,  1057,  1058,  1059,  1060,
    1061,  1062,  1063,  1064,  1065,  1066,  1073,  1077,  1078,  1082,
    1083,  1084,  1085,  1086,  1087,  1088,  1089,  1090,  1091,  1096,
    1097,  1102,  1103,  1105,  1106,  1107,  1108,  1109,  1110,  1111,
    1114,  1115,  1116,  1117,  1118,  1119,  1120,  1121,  1122,  1123,
    1124,  1125,  1126,  1127,  1130,  1131,  1134,  1135,  1136,  1139,
    1140,  1141,  1142,  1145,  1146,  1148,  1150,  1151,  1152,  1155,
    1156,  1159,  1160,  1163,  1164,  1167,  1170,  1171,  1173,  1175,
    1177,  1179,  1182,  1182,  1182,  1189,  1197,  1202,  1204,  1205,
    1207,  1208,  1210,  1214,  1221,  1230,  1235
  };

  void
  Parser::yy_stack_print_ () const
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << int (i->state);
    *yycdebug_ << '\n';
  }

  void
  Parser::yy_reduce_print_ (int yyrule) const
  {
    int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):\n";
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // YYDEBUG

  Parser::symbol_kind_type
  Parser::yytranslate_ (int t) YY_NOEXCEPT
  {
    // YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to
    // TOKEN-NUM as returned by yylex.
    static
    const unsigned char
    translate_table[] =
    {
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   173,     2,     2,   175,   158,   155,     2,
     167,   168,   159,   156,   169,   157,   162,   160,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   150,   166,
     151,   148,   152,   149,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   163,     2,   172,   154,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   170,   153,   171,   174,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   161,   164,   165
    };
    // Last valid token kind.
    const int code_max = 405;

    if (t <= 0)
      return symbol_kind::S_YYEOF;
    else if (t <= code_max)
      return static_cast <symbol_kind_type> (translate_table[t]);
    else
      return symbol_kind::S_YYUNDEF;
  }

#line 29 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
} } } // spicy::detail::parser
#line 7281 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.cc"

#line 1237 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"


void spicy::detail::parser::Parser::error(const Parser::location_type& l, const std::string& m) {
    driver->error(m, toMeta(l));
}
