// A Bison parser, made by GNU Bison 3.8.2.

// Skeleton interface for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.


/**
 ** \file /build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.h
 ** Define the spicy::detail::parser::parser class.
 */

// C++ LALR(1) parser skeleton written by Akim Demaille.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.

#ifndef YY_YY_BUILD_ZEEK_SRC_ZEEK_BUILD_AUXIL_SPICY_SPICY_SRC_AUTOGEN_PARSER_H_INCLUDED
# define YY_YY_BUILD_ZEEK_SRC_ZEEK_BUILD_AUXIL_SPICY_SPICY_SRC_AUTOGEN_PARSER_H_INCLUDED


# include <cstdlib> // std::abort
# include <iostream>
# include <stdexcept>
# include <string>
# include <vector>

#if defined __cplusplus
# define YY_CPLUSPLUS __cplusplus
#else
# define YY_CPLUSPLUS 199711L
#endif

// Support move semantics when possible.
#if 201103L <= YY_CPLUSPLUS
# define YY_MOVE           std::move
# define YY_MOVE_OR_COPY   move
# define YY_MOVE_REF(Type) Type&&
# define YY_RVREF(Type)    Type&&
# define YY_COPY(Type)     Type
#else
# define YY_MOVE
# define YY_MOVE_OR_COPY   copy
# define YY_MOVE_REF(Type) Type&
# define YY_RVREF(Type)    const Type&
# define YY_COPY(Type)     const Type&
#endif

// Support noexcept when possible.
#if 201103L <= YY_CPLUSPLUS
# define YY_NOEXCEPT noexcept
# define YY_NOTHROW
#else
# define YY_NOEXCEPT
# define YY_NOTHROW throw ()
#endif

// Support constexpr when possible.
#if 201703 <= YY_CPLUSPLUS
# define YY_CONSTEXPR constexpr
#else
# define YY_CONSTEXPR
#endif
# include "location.hh"


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

#line 29 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
namespace spicy { namespace detail { namespace parser {
#line 183 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.h"




  /// A Bison parser.
  class Parser
  {
  public:
#ifdef YYSTYPE
# ifdef __GNUC__
#  pragma GCC message "bison: do not #define YYSTYPE in C++, use %define api.value.type"
# endif
    typedef YYSTYPE value_type;
#else
  /// A buffer to store and retrieve objects.
  ///
  /// Sort of a variant, but does not keep track of the nature
  /// of the stored data, since that knowledge is available
  /// via the current parser state.
  class value_type
  {
  public:
    /// Type of *this.
    typedef value_type self_type;

    /// Empty construction.
    value_type () YY_NOEXCEPT
      : yyraw_ ()
    {}

    /// Construct and fill.
    template <typename T>
    value_type (YY_RVREF (T) t)
    {
      new (yyas_<T> ()) T (YY_MOVE (t));
    }

#if 201103L <= YY_CPLUSPLUS
    /// Non copyable.
    value_type (const self_type&) = delete;
    /// Non copyable.
    self_type& operator= (const self_type&) = delete;
#endif

    /// Destruction, allowed only if empty.
    ~value_type () YY_NOEXCEPT
    {}

# if 201103L <= YY_CPLUSPLUS
    /// Instantiate a \a T in here from \a t.
    template <typename T, typename... U>
    T&
    emplace (U&&... u)
    {
      return *new (yyas_<T> ()) T (std::forward <U>(u)...);
    }
# else
    /// Instantiate an empty \a T in here.
    template <typename T>
    T&
    emplace ()
    {
      return *new (yyas_<T> ()) T ();
    }

    /// Instantiate a \a T in here from \a t.
    template <typename T>
    T&
    emplace (const T& t)
    {
      return *new (yyas_<T> ()) T (t);
    }
# endif

    /// Instantiate an empty \a T in here.
    /// Obsolete, use emplace.
    template <typename T>
    T&
    build ()
    {
      return emplace<T> ();
    }

    /// Instantiate a \a T in here from \a t.
    /// Obsolete, use emplace.
    template <typename T>
    T&
    build (const T& t)
    {
      return emplace<T> (t);
    }

    /// Accessor to a built \a T.
    template <typename T>
    T&
    as () YY_NOEXCEPT
    {
      return *yyas_<T> ();
    }

    /// Const accessor to a built \a T (for %printer).
    template <typename T>
    const T&
    as () const YY_NOEXCEPT
    {
      return *yyas_<T> ();
    }

    /// Swap the content with \a that, of same type.
    ///
    /// Both variants must be built beforehand, because swapping the actual
    /// data requires reading it (with as()), and this is not possible on
    /// unconstructed variants: it would require some dynamic testing, which
    /// should not be the variant's responsibility.
    /// Swapping between built and (possibly) non-built is done with
    /// self_type::move ().
    template <typename T>
    void
    swap (self_type& that) YY_NOEXCEPT
    {
      std::swap (as<T> (), that.as<T> ());
    }

    /// Move the content of \a that to this.
    ///
    /// Destroys \a that.
    template <typename T>
    void
    move (self_type& that)
    {
# if 201103L <= YY_CPLUSPLUS
      emplace<T> (std::move (that.as<T> ()));
# else
      emplace<T> ();
      swap<T> (that);
# endif
      that.destroy<T> ();
    }

# if 201103L <= YY_CPLUSPLUS
    /// Move the content of \a that to this.
    template <typename T>
    void
    move (self_type&& that)
    {
      emplace<T> (std::move (that.as<T> ()));
      that.destroy<T> ();
    }
#endif

    /// Copy the content of \a that to this.
    template <typename T>
    void
    copy (const self_type& that)
    {
      emplace<T> (that.as<T> ());
    }

    /// Destroy the stored \a T.
    template <typename T>
    void
    destroy ()
    {
      as<T> ().~T ();
    }

  private:
#if YY_CPLUSPLUS < 201103L
    /// Non copyable.
    value_type (const self_type&);
    /// Non copyable.
    self_type& operator= (const self_type&);
#endif

    /// Accessor to raw memory as \a T.
    template <typename T>
    T*
    yyas_ () YY_NOEXCEPT
    {
      void *yyp = yyraw_;
      return static_cast<T*> (yyp);
     }

    /// Const accessor to raw memory as \a T.
    template <typename T>
    const T*
    yyas_ () const YY_NOEXCEPT
    {
      const void *yyp = yyraw_;
      return static_cast<const T*> (yyp);
     }

    /// An auxiliary type to compute the largest semantic type.
    union union_type
    {
      // "bool value"
      // opt_skip
      // opt_skip_
      char dummy1[sizeof (bool)];

      // "real value"
      char dummy2[sizeof (double)];

      // unit_hook_attribute
      // attribute
      char dummy3[sizeof (hilti::Attribute*)];

      // opt_unit_hook_attributes
      // opt_attributes
      char dummy4[sizeof (hilti::AttributeSet*)];

      // unit_field_ctor
      // ctor
      // tuple
      // list
      // vector
      // set
      // map
      // struct_
      // regexp
      char dummy5[sizeof (hilti::Ctor*)];

      // global_scope_decl
      // type_decl
      // constant_decl
      // local_decl
      // local_init_decl
      // global_decl
      // function_decl
      // import_decl
      // property_decl
      // hook_decl
      // struct_field
      char dummy6[sizeof (hilti::Declaration*)];

      // struct_fields
      char dummy7[sizeof (hilti::Declarations)];

      // opt_init_expression
      // opt_bitfield_range_value
      // unit_field_repeat
      // opt_unit_field_repeat
      // opt_unit_field_condition
      // opt_unit_switch_expr
      // expr
      // expr_no_or_error
      // expr_or_error
      // expr_1
      // call_expr
      // member_expr
      // ctor_expr
      // tuple_elem
      // tuple_expr
      char dummy8[sizeof (hilti::Expression*)];

      // case_exprs
      // opt_unit_field_args
      // opt_unit_field_sinks
      // opt_exprs
      // exprs
      // opt_tuple_elems1
      // opt_tuple_elems2
      char dummy9[sizeof (hilti::Expressions)];

      // local_id
      // scoped_id
      // dotted_id
      // opt_unit_field_id
      // unit_hook_id
      char dummy10[sizeof (hilti::ID)];

      // func_result
      // opt_func_result
      // qtype
      // unit_field_base_type
      char dummy11[sizeof (hilti::QualifiedType*)];

      // block
      // braced_block
      // stmt
      // opt_else_block
      // stmt_decl
      // stmt_expr
      char dummy12[sizeof (hilti::Statement*)];

      // opt_stmts
      // stmts
      char dummy13[sizeof (hilti::Statements)];

      // base_type_no_ref
      // reference_type
      // base_type
      // type
      // type_no_ref
      // tuple_type
      // struct_type
      // enum_type
      // bitfield_type
      // unit_type
      char dummy14[sizeof (hilti::UnqualifiedType*)];

      // map_elem
      char dummy15[sizeof (hilti::ctor::map::Element*)];

      // opt_map_elems
      // map_elems
      char dummy16[sizeof (hilti::ctor::map::Elements)];

      // re_pattern_constant
      // opt_re_pattern_constant_flags
      char dummy17[sizeof (hilti::ctor::regexp::Pattern)];

      // re_patterns
      char dummy18[sizeof (hilti::ctor::regexp::Patterns)];

      // struct_elem
      char dummy19[sizeof (hilti::ctor::struct_::Field*)];

      // struct_elems
      char dummy20[sizeof (hilti::ctor::struct_::Fields)];

      // opt_linkage
      char dummy21[sizeof (hilti::declaration::Linkage)];

      // opt_func_params
      // func_params
      // opt_unit_params
      // opt_unit_hook_params
      char dummy22[sizeof (hilti::declaration::Parameters)];

      // opt_func_param_kind
      char dummy23[sizeof (hilti::parameter::Kind)];

      // switch_case
      char dummy24[sizeof (hilti::statement::switch_::Case*)];

      // switch_cases
      char dummy25[sizeof (hilti::statement::switch_::Cases)];

      // bitfield_bit_range
      char dummy26[sizeof (hilti::type::bitfield::BitRange*)];

      // opt_bitfield_bit_ranges
      // bitfield_bit_ranges
      char dummy27[sizeof (hilti::type::bitfield::BitRanges)];

      // enum_label
      char dummy28[sizeof (hilti::type::enum_::Label*)];

      // enum_labels
      char dummy29[sizeof (hilti::type::enum_::Labels)];

      // opt_func_cc
      char dummy30[sizeof (hilti::type::function::CallingConvention)];

      // opt_func_flavor
      char dummy31[sizeof (hilti::type::function::Flavor)];

      // func_param
      char dummy32[sizeof (hilti::type::function::Parameter*)];

      // tuple_type_elem
      char dummy33[sizeof (hilti::type::tuple::Element*)];

      // tuple_type_elems
      char dummy34[sizeof (hilti::type::tuple::Elements)];

      // const_sint
      char dummy35[sizeof (int64_t)];

      // unit_hook
      char dummy36[sizeof (spicy::declaration::Hook*)];

      // opt_unit_item_hooks
      // unit_hooks
      char dummy37[sizeof (spicy::declaration::Hooks)];

      // unit_item
      // unit_variable
      // unit_sink
      // unit_property
      // unit_field
      // unit_field_in_container
      // scoped_id_in_container
      // unit_wide_hook
      // unit_switch
      // unit_block
      char dummy38[sizeof (spicy::type::unit::Item*)];

      // unit_items
      // opt_unit_items
      // opt_unit_block_else_items
      char dummy39[sizeof (spicy::type::unit::Items)];

      // unit_switch_case
      char dummy40[sizeof (spicy::type::unit::item::switch_::Case*)];

      // unit_switch_cases
      char dummy41[sizeof (spicy::type::unit::item::switch_::Cases)];

      // global_scope_items
      char dummy42[sizeof (std::pair<hilti::Declarations, hilti::Statements>)];

      // global_decl_type_and_init
      char dummy43[sizeof (std::pair<hilti::QualifiedType*, hilti::Expression*>)];

      // "identifier"
      // "scoped identifier"
      // "dotted identifier"
      // "hook identifier"
      // "$-identifier"
      // "attribute"
      // "property"
      // "preprocessor directive"
      // "string value"
      // "bytes value"
      // "error value"
      // "regular expression value"
      // "address value"
      // "port value"
      char dummy44[sizeof (std::string)];

      // "unsigned integer value"
      // "$<N>"
      // const_uint
      char dummy45[sizeof (uint64_t)];
    };

    /// The size of the largest semantic type.
    enum { size = sizeof (union_type) };

    /// A buffer to store semantic values.
    union
    {
      /// Strongest alignment constraints.
      long double yyalign_me_;
      /// A buffer large enough to store any of the semantic values.
      char yyraw_[size];
    };
  };

#endif
    /// Backward compatibility (Bison 3.8).
    typedef value_type semantic_type;

    /// Symbol locations.
    typedef location location_type;

    /// Syntax errors thrown from user actions.
    struct syntax_error : std::runtime_error
    {
      syntax_error (const location_type& l, const std::string& m)
        : std::runtime_error (m)
        , location (l)
      {}

      syntax_error (const syntax_error& s)
        : std::runtime_error (s.what ())
        , location (s.location)
      {}

      ~syntax_error () YY_NOEXCEPT YY_NOTHROW;

      location_type location;
    };

    /// Token kinds.
    struct token
    {
      enum token_kind_type
      {
        YYEMPTY = -2,
    EOD = 0,                       // "<end of input>"
    YYerror = 256,                 // error
    YYUNDEF = 257,                 // "invalid token"
    IDENT = 258,                   // "identifier"
    SCOPED_IDENT = 259,            // "scoped identifier"
    DOTTED_IDENT = 260,            // "dotted identifier"
    HOOK_IDENT = 261,              // "hook identifier"
    DOLLAR_IDENT = 262,            // "$-identifier"
    ATTRIBUTE = 263,               // "attribute"
    PROPERTY = 264,                // "property"
    PREPROCESSOR = 265,            // "preprocessor directive"
    CSTRING = 266,                 // "string value"
    CBYTES = 267,                  // "bytes value"
    CERROR = 268,                  // "error value"
    CREGEXP = 269,                 // "regular expression value"
    CADDRESS = 270,                // "address value"
    CPORT = 271,                   // "port value"
    CUREAL = 272,                  // "real value"
    CUINTEGER = 273,               // "unsigned integer value"
    DOLLAR_NUMBER = 274,           // "$<N>"
    CBOOL = 275,                   // "bool value"
    CNULL = 276,                   // "null value"
    ASSERT = 277,                  // "assert"
    ASSERT_EXCEPTION = 278,        // "assert-exception"
    ADD = 279,                     // ADD
    ADDRESS = 280,                 // ADDRESS
    AND = 281,                     // AND
    ANY = 282,                     // ANY
    ARROW = 283,                   // ARROW
    AUTO = 284,                    // AUTO
    BITFIELD = 285,                // BITFIELD
    BEGIN_ = 286,                  // BEGIN_
    BOOL = 287,                    // BOOL
    BREAK = 288,                   // BREAK
    BYTES = 289,                   // BYTES
    CADDR = 290,                   // CADDR
    CASE = 291,                    // CASE
    CAST = 292,                    // CAST
    CATCH = 293,                   // CATCH
    CONST = 294,                   // CONST
    CONSTANT = 295,                // CONSTANT
    CONTINUE = 296,                // CONTINUE
    DEBUG_ = 297,                  // DEBUG_
    DECLARE = 298,                 // DECLARE
    DEFAULT = 299,                 // DEFAULT
    DELETE = 300,                  // DELETE
    DIVIDEASSIGN = 301,            // DIVIDEASSIGN
    DOLLARDOLLAR = 302,            // DOLLARDOLLAR
    DOTDOT = 303,                  // DOTDOT
    REAL = 304,                    // REAL
    ELSE = 305,                    // ELSE
    END_ = 306,                    // END_
    ENUM = 307,                    // ENUM
    EQ = 308,                      // EQ
    __ERROR = 309,                 // __ERROR
    EXCEPTION = 310,               // EXCEPTION
    EXPORT = 311,                  // EXPORT
    FILE = 312,                    // FILE
    FOR = 313,                     // FOR
    FOREACH = 314,                 // FOREACH
    FROM = 315,                    // FROM
    FUNCTION = 316,                // FUNCTION
    GEQ = 317,                     // GEQ
    GLOBAL = 318,                  // GLOBAL
    HASATTR = 319,                 // HASATTR
    HOOK_COMPOSE = 320,            // HOOK_COMPOSE
    HOOK_PARSE = 321,              // HOOK_PARSE
    IF = 322,                      // IF
    IMPORT = 323,                  // IMPORT
    IN = 324,                      // IN
    INOUT = 325,                   // INOUT
    INT = 326,                     // INT
    INT16 = 327,                   // INT16
    INT32 = 328,                   // INT32
    INT64 = 329,                   // INT64
    INT8 = 330,                    // INT8
    INTERVAL = 331,                // INTERVAL
    INTERVAL_NS = 332,             // INTERVAL_NS
    ITERATOR = 333,                // ITERATOR
    CONST_ITERATOR = 334,          // CONST_ITERATOR
    LEQ = 335,                     // LEQ
    LIBRARY_TYPE = 336,            // LIBRARY_TYPE
    LIBRARY_TYPE_CONST = 337,      // LIBRARY_TYPE_CONST
    LIST = 338,                    // LIST
    LOCAL = 339,                   // LOCAL
    MAP = 340,                     // MAP
    MARK = 341,                    // MARK
    CAPTURES = 342,                // CAPTURES
    MINUSASSIGN = 343,             // MINUSASSIGN
    MINUSMINUS = 344,              // MINUSMINUS
    MOD = 345,                     // MOD
    MODULE = 346,                  // MODULE
    NEQ = 347,                     // NEQ
    NETWORK = 348,                 // NETWORK
    NEW = 349,                     // NEW
    NONE = 350,                    // NONE
    NOT_IN = 351,                  // NOT_IN
    OBJECT = 352,                  // OBJECT
    ON = 353,                      // ON
    OPTIONAL = 354,                // OPTIONAL
    OR = 355,                      // OR
    PACK = 356,                    // PACK
    PLUSASSIGN = 357,              // PLUSASSIGN
    PLUSPLUS = 358,                // PLUSPLUS
    PORT = 359,                    // PORT
    POW = 360,                     // POW
    PRINT = 361,                   // PRINT
    PRIORITY = 362,                // PRIORITY
    PRIVATE = 363,                 // PRIVATE
    PUBLIC = 364,                  // PUBLIC
    REGEXP = 365,                  // REGEXP
    RESULT = 366,                  // RESULT
    RETURN = 367,                  // RETURN
    SET = 368,                     // SET
    SHIFTLEFT = 369,               // SHIFTLEFT
    SHIFTRIGHT = 370,              // SHIFTRIGHT
    SINK = 371,                    // SINK
    SKIP = 372,                    // SKIP
    STOP = 373,                    // STOP
    STREAM = 374,                  // "stream"
    STRING = 375,                  // STRING
    STRUCT = 376,                  // STRUCT
    SWITCH = 377,                  // SWITCH
    CONFIRM = 378,                 // "confirm"
    REJECT_ = 379,                 // "reject"
    THROW = 380,                   // THROW
    TIME = 381,                    // TIME
    TIME_NS = 382,                 // TIME_NS
    TIMER = 383,                   // TIMER
    TIMESASSIGN = 384,             // TIMESASSIGN
    TRY = 385,                     // TRY
    TRYATTR = 386,                 // TRYATTR
    TUPLE = 387,                   // TUPLE
    TYPE = 388,                    // TYPE
    TYPEINFO = 389,                // TYPEINFO
    UINT = 390,                    // UINT
    UINT16 = 391,                  // UINT16
    UINT32 = 392,                  // UINT32
    UINT64 = 393,                  // UINT64
    UINT8 = 394,                   // UINT8
    UNIT = 395,                    // UNIT
    UNPACK = 396,                  // UNPACK
    UNSET = 397,                   // UNSET
    VAR = 398,                     // VAR
    VECTOR = 399,                  // VECTOR
    VIEW = 400,                    // VIEW
    VOID = 401,                    // VOID
    WHILE = 402,                   // WHILE
    UNARY_PREC = 403,              // UNARY_PREC
    START_MODULE = 404,            // START_MODULE
    START_EXPRESSION = 405         // START_EXPRESSION
      };
      /// Backward compatibility alias (Bison 3.6).
      typedef token_kind_type yytokentype;
    };

    /// Token kind, as returned by yylex.
    typedef token::token_kind_type token_kind_type;

    /// Backward compatibility alias (Bison 3.6).
    typedef token_kind_type token_type;

    /// Symbol kinds.
    struct symbol_kind
    {
      enum symbol_kind_type
      {
        YYNTOKENS = 176, ///< Number of tokens.
        S_YYEMPTY = -2,
        S_YYEOF = 0,                             // "<end of input>"
        S_YYerror = 1,                           // error
        S_YYUNDEF = 2,                           // "invalid token"
        S_IDENT = 3,                             // "identifier"
        S_SCOPED_IDENT = 4,                      // "scoped identifier"
        S_DOTTED_IDENT = 5,                      // "dotted identifier"
        S_HOOK_IDENT = 6,                        // "hook identifier"
        S_DOLLAR_IDENT = 7,                      // "$-identifier"
        S_ATTRIBUTE = 8,                         // "attribute"
        S_PROPERTY = 9,                          // "property"
        S_PREPROCESSOR = 10,                     // "preprocessor directive"
        S_CSTRING = 11,                          // "string value"
        S_CBYTES = 12,                           // "bytes value"
        S_CERROR = 13,                           // "error value"
        S_CREGEXP = 14,                          // "regular expression value"
        S_CADDRESS = 15,                         // "address value"
        S_CPORT = 16,                            // "port value"
        S_CUREAL = 17,                           // "real value"
        S_CUINTEGER = 18,                        // "unsigned integer value"
        S_DOLLAR_NUMBER = 19,                    // "$<N>"
        S_CBOOL = 20,                            // "bool value"
        S_CNULL = 21,                            // "null value"
        S_ASSERT = 22,                           // "assert"
        S_ASSERT_EXCEPTION = 23,                 // "assert-exception"
        S_ADD = 24,                              // ADD
        S_ADDRESS = 25,                          // ADDRESS
        S_AND = 26,                              // AND
        S_ANY = 27,                              // ANY
        S_ARROW = 28,                            // ARROW
        S_AUTO = 29,                             // AUTO
        S_BITFIELD = 30,                         // BITFIELD
        S_BEGIN_ = 31,                           // BEGIN_
        S_BOOL = 32,                             // BOOL
        S_BREAK = 33,                            // BREAK
        S_BYTES = 34,                            // BYTES
        S_CADDR = 35,                            // CADDR
        S_CASE = 36,                             // CASE
        S_CAST = 37,                             // CAST
        S_CATCH = 38,                            // CATCH
        S_CONST = 39,                            // CONST
        S_CONSTANT = 40,                         // CONSTANT
        S_CONTINUE = 41,                         // CONTINUE
        S_DEBUG_ = 42,                           // DEBUG_
        S_DECLARE = 43,                          // DECLARE
        S_DEFAULT = 44,                          // DEFAULT
        S_DELETE = 45,                           // DELETE
        S_DIVIDEASSIGN = 46,                     // DIVIDEASSIGN
        S_DOLLARDOLLAR = 47,                     // DOLLARDOLLAR
        S_DOTDOT = 48,                           // DOTDOT
        S_REAL = 49,                             // REAL
        S_ELSE = 50,                             // ELSE
        S_END_ = 51,                             // END_
        S_ENUM = 52,                             // ENUM
        S_EQ = 53,                               // EQ
        S___ERROR = 54,                          // __ERROR
        S_EXCEPTION = 55,                        // EXCEPTION
        S_EXPORT = 56,                           // EXPORT
        S_FILE = 57,                             // FILE
        S_FOR = 58,                              // FOR
        S_FOREACH = 59,                          // FOREACH
        S_FROM = 60,                             // FROM
        S_FUNCTION = 61,                         // FUNCTION
        S_GEQ = 62,                              // GEQ
        S_GLOBAL = 63,                           // GLOBAL
        S_HASATTR = 64,                          // HASATTR
        S_HOOK_COMPOSE = 65,                     // HOOK_COMPOSE
        S_HOOK_PARSE = 66,                       // HOOK_PARSE
        S_IF = 67,                               // IF
        S_IMPORT = 68,                           // IMPORT
        S_IN = 69,                               // IN
        S_INOUT = 70,                            // INOUT
        S_INT = 71,                              // INT
        S_INT16 = 72,                            // INT16
        S_INT32 = 73,                            // INT32
        S_INT64 = 74,                            // INT64
        S_INT8 = 75,                             // INT8
        S_INTERVAL = 76,                         // INTERVAL
        S_INTERVAL_NS = 77,                      // INTERVAL_NS
        S_ITERATOR = 78,                         // ITERATOR
        S_CONST_ITERATOR = 79,                   // CONST_ITERATOR
        S_LEQ = 80,                              // LEQ
        S_LIBRARY_TYPE = 81,                     // LIBRARY_TYPE
        S_LIBRARY_TYPE_CONST = 82,               // LIBRARY_TYPE_CONST
        S_LIST = 83,                             // LIST
        S_LOCAL = 84,                            // LOCAL
        S_MAP = 85,                              // MAP
        S_MARK = 86,                             // MARK
        S_CAPTURES = 87,                         // CAPTURES
        S_MINUSASSIGN = 88,                      // MINUSASSIGN
        S_MINUSMINUS = 89,                       // MINUSMINUS
        S_MOD = 90,                              // MOD
        S_MODULE = 91,                           // MODULE
        S_NEQ = 92,                              // NEQ
        S_NETWORK = 93,                          // NETWORK
        S_NEW = 94,                              // NEW
        S_NONE = 95,                             // NONE
        S_NOT_IN = 96,                           // NOT_IN
        S_OBJECT = 97,                           // OBJECT
        S_ON = 98,                               // ON
        S_OPTIONAL = 99,                         // OPTIONAL
        S_OR = 100,                              // OR
        S_PACK = 101,                            // PACK
        S_PLUSASSIGN = 102,                      // PLUSASSIGN
        S_PLUSPLUS = 103,                        // PLUSPLUS
        S_PORT = 104,                            // PORT
        S_POW = 105,                             // POW
        S_PRINT = 106,                           // PRINT
        S_PRIORITY = 107,                        // PRIORITY
        S_PRIVATE = 108,                         // PRIVATE
        S_PUBLIC = 109,                          // PUBLIC
        S_REGEXP = 110,                          // REGEXP
        S_RESULT = 111,                          // RESULT
        S_RETURN = 112,                          // RETURN
        S_SET = 113,                             // SET
        S_SHIFTLEFT = 114,                       // SHIFTLEFT
        S_SHIFTRIGHT = 115,                      // SHIFTRIGHT
        S_SINK = 116,                            // SINK
        S_SKIP = 117,                            // SKIP
        S_STOP = 118,                            // STOP
        S_STREAM = 119,                          // "stream"
        S_STRING = 120,                          // STRING
        S_STRUCT = 121,                          // STRUCT
        S_SWITCH = 122,                          // SWITCH
        S_CONFIRM = 123,                         // "confirm"
        S_REJECT_ = 124,                         // "reject"
        S_THROW = 125,                           // THROW
        S_TIME = 126,                            // TIME
        S_TIME_NS = 127,                         // TIME_NS
        S_TIMER = 128,                           // TIMER
        S_TIMESASSIGN = 129,                     // TIMESASSIGN
        S_TRY = 130,                             // TRY
        S_TRYATTR = 131,                         // TRYATTR
        S_TUPLE = 132,                           // TUPLE
        S_TYPE = 133,                            // TYPE
        S_TYPEINFO = 134,                        // TYPEINFO
        S_UINT = 135,                            // UINT
        S_UINT16 = 136,                          // UINT16
        S_UINT32 = 137,                          // UINT32
        S_UINT64 = 138,                          // UINT64
        S_UINT8 = 139,                           // UINT8
        S_UNIT = 140,                            // UNIT
        S_UNPACK = 141,                          // UNPACK
        S_UNSET = 142,                           // UNSET
        S_VAR = 143,                             // VAR
        S_VECTOR = 144,                          // VECTOR
        S_VIEW = 145,                            // VIEW
        S_VOID = 146,                            // VOID
        S_WHILE = 147,                           // WHILE
        S_148_ = 148,                            // '='
        S_149_ = 149,                            // '?'
        S_150_ = 150,                            // ':'
        S_151_ = 151,                            // '<'
        S_152_ = 152,                            // '>'
        S_153_ = 153,                            // '|'
        S_154_ = 154,                            // '^'
        S_155_ = 155,                            // '&'
        S_156_ = 156,                            // '+'
        S_157_ = 157,                            // '-'
        S_158_ = 158,                            // '%'
        S_159_ = 159,                            // '*'
        S_160_ = 160,                            // '/'
        S_UNARY_PREC = 161,                      // UNARY_PREC
        S_162_ = 162,                            // '.'
        S_163_ = 163,                            // '['
        S_START_MODULE = 164,                    // START_MODULE
        S_START_EXPRESSION = 165,                // START_EXPRESSION
        S_166_ = 166,                            // ';'
        S_167_ = 167,                            // '('
        S_168_ = 168,                            // ')'
        S_169_ = 169,                            // ','
        S_170_ = 170,                            // '{'
        S_171_ = 171,                            // '}'
        S_172_ = 172,                            // ']'
        S_173_ = 173,                            // '!'
        S_174_ = 174,                            // '~'
        S_175_ = 175,                            // '$'
        S_YYACCEPT = 176,                        // $accept
        S_start = 177,                           // start
        S_start_expr = 178,                      // start_expr
        S_module = 179,                          // module
        S_180_1 = 180,                           // $@1
        S_local_id = 181,                        // local_id
        S_scoped_id = 182,                       // scoped_id
        S_dotted_id = 183,                       // dotted_id
        S_184_2 = 184,                           // $@2
        S_185_3 = 185,                           // $@3
        S_global_scope_items = 186,              // global_scope_items
        S_global_scope_decl = 187,               // global_scope_decl
        S_type_decl = 188,                       // type_decl
        S_189_4 = 189,                           // $@4
        S_constant_decl = 190,                   // constant_decl
        S_191_5 = 191,                           // $@5
        S_192_6 = 192,                           // $@6
        S_local_decl = 193,                      // local_decl
        S_local_init_decl = 194,                 // local_init_decl
        S_global_decl = 195,                     // global_decl
        S_196_7 = 196,                           // $@7
        S_197_8 = 197,                           // $@8
        S_global_decl_type_and_init = 198,       // global_decl_type_and_init
        S_function_decl = 199,                   // function_decl
        S_200_9 = 200,                           // $@9
        S_201_10 = 201,                          // $@10
        S_import_decl = 202,                     // import_decl
        S_property_decl = 203,                   // property_decl
        S_hook_decl = 204,                       // hook_decl
        S_opt_linkage = 205,                     // opt_linkage
        S_opt_func_flavor = 206,                 // opt_func_flavor
        S_opt_func_cc = 207,                     // opt_func_cc
        S_opt_func_params = 208,                 // opt_func_params
        S_func_params = 209,                     // func_params
        S_func_param = 210,                      // func_param
        S_func_result = 211,                     // func_result
        S_opt_func_result = 212,                 // opt_func_result
        S_opt_func_param_kind = 213,             // opt_func_param_kind
        S_opt_init_expression = 214,             // opt_init_expression
        S_block = 215,                           // block
        S_braced_block = 216,                    // braced_block
        S_opt_stmts = 217,                       // opt_stmts
        S_stmts = 218,                           // stmts
        S_stmt = 219,                            // stmt
        S_opt_else_block = 220,                  // opt_else_block
        S_switch_cases = 221,                    // switch_cases
        S_switch_case = 222,                     // switch_case
        S_case_exprs = 223,                      // case_exprs
        S_stmt_decl = 224,                       // stmt_decl
        S_stmt_expr = 225,                       // stmt_expr
        S_base_type_no_ref = 226,                // base_type_no_ref
        S_reference_type = 227,                  // reference_type
        S_base_type = 228,                       // base_type
        S_type = 229,                            // type
        S_type_no_ref = 230,                     // type_no_ref
        S_qtype = 231,                           // qtype
        S_type_param_begin = 232,                // type_param_begin
        S_type_param_end = 233,                  // type_param_end
        S_tuple_type = 234,                      // tuple_type
        S_tuple_type_elems = 235,                // tuple_type_elems
        S_tuple_type_elem = 236,                 // tuple_type_elem
        S_struct_type = 237,                     // struct_type
        S_struct_fields = 238,                   // struct_fields
        S_struct_field = 239,                    // struct_field
        S_enum_type = 240,                       // enum_type
        S_enum_labels = 241,                     // enum_labels
        S_enum_label = 242,                      // enum_label
        S_bitfield_type = 243,                   // bitfield_type
        S_244_11 = 244,                          // $@11
        S_opt_bitfield_bit_ranges = 245,         // opt_bitfield_bit_ranges
        S_bitfield_bit_ranges = 246,             // bitfield_bit_ranges
        S_bitfield_bit_range = 247,              // bitfield_bit_range
        S_opt_bitfield_range_value = 248,        // opt_bitfield_range_value
        S_unit_type = 249,                       // unit_type
        S_opt_unit_params = 250,                 // opt_unit_params
        S_unit_items = 251,                      // unit_items
        S_opt_unit_items = 252,                  // opt_unit_items
        S_unit_item = 253,                       // unit_item
        S_unit_variable = 254,                   // unit_variable
        S_unit_sink = 255,                       // unit_sink
        S_unit_property = 256,                   // unit_property
        S_unit_field_base_type = 257,            // unit_field_base_type
        S_unit_field = 258,                      // unit_field
        S_const_sint = 259,                      // const_sint
        S_const_uint = 260,                      // const_uint
        S_unit_field_ctor = 261,                 // unit_field_ctor
        S_unit_field_in_container = 262,         // unit_field_in_container
        S_scoped_id_in_container = 263,          // scoped_id_in_container
        S_unit_wide_hook = 264,                  // unit_wide_hook
        S_opt_unit_field_id = 265,               // opt_unit_field_id
        S_opt_skip = 266,                        // opt_skip
        S_267_12 = 267,                          // $@12
        S_opt_skip_ = 268,                       // opt_skip_
        S_opt_unit_field_args = 269,             // opt_unit_field_args
        S_unit_field_repeat = 270,               // unit_field_repeat
        S_opt_unit_field_repeat = 271,           // opt_unit_field_repeat
        S_opt_unit_field_condition = 272,        // opt_unit_field_condition
        S_opt_unit_field_sinks = 273,            // opt_unit_field_sinks
        S_opt_unit_item_hooks = 274,             // opt_unit_item_hooks
        S_unit_hooks = 275,                      // unit_hooks
        S_unit_hook = 276,                       // unit_hook
        S_opt_unit_hook_params = 277,            // opt_unit_hook_params
        S_opt_unit_hook_attributes = 278,        // opt_unit_hook_attributes
        S_unit_hook_id = 279,                    // unit_hook_id
        S_280_13 = 280,                          // $@13
        S_281_14 = 281,                          // $@14
        S_unit_hook_attribute = 282,             // unit_hook_attribute
        S_unit_switch = 283,                     // unit_switch
        S_opt_unit_switch_expr = 284,            // opt_unit_switch_expr
        S_unit_switch_cases = 285,               // unit_switch_cases
        S_unit_switch_case = 286,                // unit_switch_case
        S_opt_unit_block_else_items = 287,       // opt_unit_block_else_items
        S_unit_block = 288,                      // unit_block
        S_expr = 289,                            // expr
        S_290_15 = 290,                          // $@15
        S_291_16 = 291,                          // $@16
        S_expr_no_or_error = 292,                // expr_no_or_error
        S_opt_exprs = 293,                       // opt_exprs
        S_exprs = 294,                           // exprs
        S_expr_or_error = 295,                   // expr_or_error
        S_expr_1 = 296,                          // expr_1
        S_call_expr = 297,                       // call_expr
        S_member_expr = 298,                     // member_expr
        S_ctor = 299,                            // ctor
        S_ctor_expr = 300,                       // ctor_expr
        S_tuple = 301,                           // tuple
        S_opt_tuple_elems1 = 302,                // opt_tuple_elems1
        S_opt_tuple_elems2 = 303,                // opt_tuple_elems2
        S_tuple_elem = 304,                      // tuple_elem
        S_tuple_expr = 305,                      // tuple_expr
        S_list = 306,                            // list
        S_vector = 307,                          // vector
        S_set = 308,                             // set
        S_map = 309,                             // map
        S_struct_ = 310,                         // struct_
        S_struct_elems = 311,                    // struct_elems
        S_struct_elem = 312,                     // struct_elem
        S_regexp = 313,                          // regexp
        S_re_patterns = 314,                     // re_patterns
        S_re_pattern_constant = 315,             // re_pattern_constant
        S_316_17 = 316,                          // $@17
        S_317_18 = 317,                          // $@18
        S_opt_re_pattern_constant_flags = 318,   // opt_re_pattern_constant_flags
        S_opt_map_elems = 319,                   // opt_map_elems
        S_map_elems = 320,                       // map_elems
        S_map_elem = 321,                        // map_elem
        S_attribute = 322,                       // attribute
        S_opt_attributes = 323                   // opt_attributes
      };
    };

    /// (Internal) symbol kind.
    typedef symbol_kind::symbol_kind_type symbol_kind_type;

    /// The number of tokens.
    static const symbol_kind_type YYNTOKENS = symbol_kind::YYNTOKENS;

    /// A complete symbol.
    ///
    /// Expects its Base type to provide access to the symbol kind
    /// via kind ().
    ///
    /// Provide access to semantic value and location.
    template <typename Base>
    struct basic_symbol : Base
    {
      /// Alias to Base.
      typedef Base super_type;

      /// Default constructor.
      basic_symbol () YY_NOEXCEPT
        : value ()
        , location ()
      {}

#if 201103L <= YY_CPLUSPLUS
      /// Move constructor.
      basic_symbol (basic_symbol&& that)
        : Base (std::move (that))
        , value ()
        , location (std::move (that.location))
      {
        switch (this->kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
      case symbol_kind::S_opt_skip: // opt_skip
      case symbol_kind::S_opt_skip_: // opt_skip_
        value.move< bool > (std::move (that.value));
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.move< double > (std::move (that.value));
        break;

      case symbol_kind::S_unit_hook_attribute: // unit_hook_attribute
      case symbol_kind::S_attribute: // attribute
        value.move< hilti::Attribute* > (std::move (that.value));
        break;

      case symbol_kind::S_opt_unit_hook_attributes: // opt_unit_hook_attributes
      case symbol_kind::S_opt_attributes: // opt_attributes
        value.move< hilti::AttributeSet* > (std::move (that.value));
        break;

      case symbol_kind::S_unit_field_ctor: // unit_field_ctor
      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_vector: // vector
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.move< hilti::Ctor* > (std::move (that.value));
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_hook_decl: // hook_decl
      case symbol_kind::S_struct_field: // struct_field
        value.move< hilti::Declaration* > (std::move (that.value));
        break;

      case symbol_kind::S_struct_fields: // struct_fields
        value.move< hilti::Declarations > (std::move (that.value));
        break;

      case symbol_kind::S_opt_init_expression: // opt_init_expression
      case symbol_kind::S_opt_bitfield_range_value: // opt_bitfield_range_value
      case symbol_kind::S_unit_field_repeat: // unit_field_repeat
      case symbol_kind::S_opt_unit_field_repeat: // opt_unit_field_repeat
      case symbol_kind::S_opt_unit_field_condition: // opt_unit_field_condition
      case symbol_kind::S_opt_unit_switch_expr: // opt_unit_switch_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.move< hilti::Expression* > (std::move (that.value));
        break;

      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_unit_field_args: // opt_unit_field_args
      case symbol_kind::S_opt_unit_field_sinks: // opt_unit_field_sinks
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.move< hilti::Expressions > (std::move (that.value));
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_opt_unit_field_id: // opt_unit_field_id
      case symbol_kind::S_unit_hook_id: // unit_hook_id
        value.move< hilti::ID > (std::move (that.value));
        break;

      case symbol_kind::S_func_result: // func_result
      case symbol_kind::S_opt_func_result: // opt_func_result
      case symbol_kind::S_qtype: // qtype
      case symbol_kind::S_unit_field_base_type: // unit_field_base_type
        value.move< hilti::QualifiedType* > (std::move (that.value));
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.move< hilti::Statement* > (std::move (that.value));
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.move< hilti::Statements > (std::move (that.value));
        break;

      case symbol_kind::S_base_type_no_ref: // base_type_no_ref
      case symbol_kind::S_reference_type: // reference_type
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_type_no_ref: // type_no_ref
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
      case symbol_kind::S_unit_type: // unit_type
        value.move< hilti::UnqualifiedType* > (std::move (that.value));
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.move< hilti::ctor::map::Element* > (std::move (that.value));
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.move< hilti::ctor::map::Elements > (std::move (that.value));
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.move< hilti::ctor::regexp::Pattern > (std::move (that.value));
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.move< hilti::ctor::regexp::Patterns > (std::move (that.value));
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.move< hilti::ctor::struct_::Field* > (std::move (that.value));
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.move< hilti::ctor::struct_::Fields > (std::move (that.value));
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.move< hilti::declaration::Linkage > (std::move (that.value));
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_unit_params: // opt_unit_params
      case symbol_kind::S_opt_unit_hook_params: // opt_unit_hook_params
        value.move< hilti::declaration::Parameters > (std::move (that.value));
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.move< hilti::parameter::Kind > (std::move (that.value));
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.move< hilti::statement::switch_::Case* > (std::move (that.value));
        break;

      case symbol_kind::S_switch_cases: // switch_cases
        value.move< hilti::statement::switch_::Cases > (std::move (that.value));
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.move< hilti::type::bitfield::BitRange* > (std::move (that.value));
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.move< hilti::type::bitfield::BitRanges > (std::move (that.value));
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.move< hilti::type::enum_::Label* > (std::move (that.value));
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.move< hilti::type::enum_::Labels > (std::move (that.value));
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.move< hilti::type::function::CallingConvention > (std::move (that.value));
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
        value.move< hilti::type::function::Flavor > (std::move (that.value));
        break;

      case symbol_kind::S_func_param: // func_param
        value.move< hilti::type::function::Parameter* > (std::move (that.value));
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.move< hilti::type::tuple::Element* > (std::move (that.value));
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.move< hilti::type::tuple::Elements > (std::move (that.value));
        break;

      case symbol_kind::S_const_sint: // const_sint
        value.move< int64_t > (std::move (that.value));
        break;

      case symbol_kind::S_unit_hook: // unit_hook
        value.move< spicy::declaration::Hook* > (std::move (that.value));
        break;

      case symbol_kind::S_opt_unit_item_hooks: // opt_unit_item_hooks
      case symbol_kind::S_unit_hooks: // unit_hooks
        value.move< spicy::declaration::Hooks > (std::move (that.value));
        break;

      case symbol_kind::S_unit_item: // unit_item
      case symbol_kind::S_unit_variable: // unit_variable
      case symbol_kind::S_unit_sink: // unit_sink
      case symbol_kind::S_unit_property: // unit_property
      case symbol_kind::S_unit_field: // unit_field
      case symbol_kind::S_unit_field_in_container: // unit_field_in_container
      case symbol_kind::S_scoped_id_in_container: // scoped_id_in_container
      case symbol_kind::S_unit_wide_hook: // unit_wide_hook
      case symbol_kind::S_unit_switch: // unit_switch
      case symbol_kind::S_unit_block: // unit_block
        value.move< spicy::type::unit::Item* > (std::move (that.value));
        break;

      case symbol_kind::S_unit_items: // unit_items
      case symbol_kind::S_opt_unit_items: // opt_unit_items
      case symbol_kind::S_opt_unit_block_else_items: // opt_unit_block_else_items
        value.move< spicy::type::unit::Items > (std::move (that.value));
        break;

      case symbol_kind::S_unit_switch_case: // unit_switch_case
        value.move< spicy::type::unit::item::switch_::Case* > (std::move (that.value));
        break;

      case symbol_kind::S_unit_switch_cases: // unit_switch_cases
        value.move< spicy::type::unit::item::switch_::Cases > (std::move (that.value));
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.move< std::pair<hilti::Declarations, hilti::Statements> > (std::move (that.value));
        break;

      case symbol_kind::S_global_decl_type_and_init: // global_decl_type_and_init
        value.move< std::pair<hilti::QualifiedType*, hilti::Expression*> > (std::move (that.value));
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_HOOK_IDENT: // "hook identifier"
      case symbol_kind::S_DOLLAR_IDENT: // "$-identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_PREPROCESSOR: // "preprocessor directive"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CERROR: // "error value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.move< std::string > (std::move (that.value));
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
      case symbol_kind::S_DOLLAR_NUMBER: // "$<N>"
      case symbol_kind::S_const_uint: // const_uint
        value.move< uint64_t > (std::move (that.value));
        break;

      default:
        break;
    }

      }
#endif

      /// Copy constructor.
      basic_symbol (const basic_symbol& that);

      /// Constructors for typed symbols.
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, location_type&& l)
        : Base (t)
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const location_type& l)
        : Base (t)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, bool&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const bool& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, double&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const double& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Attribute*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Attribute*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::AttributeSet*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::AttributeSet*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Ctor*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Ctor*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Declaration*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Declaration*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Declarations&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Declarations& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Expression*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Expression*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Expressions&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Expressions& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ID&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ID& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::QualifiedType*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::QualifiedType*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Statement*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Statement*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Statements&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Statements& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::UnqualifiedType*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::UnqualifiedType*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ctor::map::Element*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ctor::map::Element*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ctor::map::Elements&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ctor::map::Elements& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ctor::regexp::Pattern&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ctor::regexp::Pattern& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ctor::regexp::Patterns&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ctor::regexp::Patterns& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ctor::struct_::Field*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ctor::struct_::Field*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ctor::struct_::Fields&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ctor::struct_::Fields& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::declaration::Linkage&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::declaration::Linkage& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::declaration::Parameters&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::declaration::Parameters& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::parameter::Kind&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::parameter::Kind& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::statement::switch_::Case*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::statement::switch_::Case*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::statement::switch_::Cases&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::statement::switch_::Cases& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::bitfield::BitRange*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::bitfield::BitRange*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::bitfield::BitRanges&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::bitfield::BitRanges& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::enum_::Label*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::enum_::Label*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::enum_::Labels&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::enum_::Labels& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::function::CallingConvention&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::function::CallingConvention& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::function::Flavor&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::function::Flavor& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::function::Parameter*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::function::Parameter*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::tuple::Element*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::tuple::Element*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::tuple::Elements&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::tuple::Elements& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, int64_t&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const int64_t& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, spicy::declaration::Hook*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const spicy::declaration::Hook*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, spicy::declaration::Hooks&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const spicy::declaration::Hooks& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, spicy::type::unit::Item*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const spicy::type::unit::Item*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, spicy::type::unit::Items&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const spicy::type::unit::Items& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, spicy::type::unit::item::switch_::Case*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const spicy::type::unit::item::switch_::Case*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, spicy::type::unit::item::switch_::Cases&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const spicy::type::unit::item::switch_::Cases& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, std::pair<hilti::Declarations, hilti::Statements>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const std::pair<hilti::Declarations, hilti::Statements>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, std::pair<hilti::QualifiedType*, hilti::Expression*>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const std::pair<hilti::QualifiedType*, hilti::Expression*>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, std::string&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const std::string& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, uint64_t&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const uint64_t& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

      /// Destroy the symbol.
      ~basic_symbol ()
      {
        clear ();
      }



      /// Destroy contents, and record that is empty.
      void clear () YY_NOEXCEPT
      {
        // User destructor.
        symbol_kind_type yykind = this->kind ();
        basic_symbol<Base>& yysym = *this;
        (void) yysym;
        switch (yykind)
        {
       default:
          break;
        }

        // Value type destructor.
switch (yykind)
    {
      case symbol_kind::S_CBOOL: // "bool value"
      case symbol_kind::S_opt_skip: // opt_skip
      case symbol_kind::S_opt_skip_: // opt_skip_
        value.template destroy< bool > ();
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.template destroy< double > ();
        break;

      case symbol_kind::S_unit_hook_attribute: // unit_hook_attribute
      case symbol_kind::S_attribute: // attribute
        value.template destroy< hilti::Attribute* > ();
        break;

      case symbol_kind::S_opt_unit_hook_attributes: // opt_unit_hook_attributes
      case symbol_kind::S_opt_attributes: // opt_attributes
        value.template destroy< hilti::AttributeSet* > ();
        break;

      case symbol_kind::S_unit_field_ctor: // unit_field_ctor
      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_vector: // vector
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.template destroy< hilti::Ctor* > ();
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_hook_decl: // hook_decl
      case symbol_kind::S_struct_field: // struct_field
        value.template destroy< hilti::Declaration* > ();
        break;

      case symbol_kind::S_struct_fields: // struct_fields
        value.template destroy< hilti::Declarations > ();
        break;

      case symbol_kind::S_opt_init_expression: // opt_init_expression
      case symbol_kind::S_opt_bitfield_range_value: // opt_bitfield_range_value
      case symbol_kind::S_unit_field_repeat: // unit_field_repeat
      case symbol_kind::S_opt_unit_field_repeat: // opt_unit_field_repeat
      case symbol_kind::S_opt_unit_field_condition: // opt_unit_field_condition
      case symbol_kind::S_opt_unit_switch_expr: // opt_unit_switch_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.template destroy< hilti::Expression* > ();
        break;

      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_unit_field_args: // opt_unit_field_args
      case symbol_kind::S_opt_unit_field_sinks: // opt_unit_field_sinks
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.template destroy< hilti::Expressions > ();
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_opt_unit_field_id: // opt_unit_field_id
      case symbol_kind::S_unit_hook_id: // unit_hook_id
        value.template destroy< hilti::ID > ();
        break;

      case symbol_kind::S_func_result: // func_result
      case symbol_kind::S_opt_func_result: // opt_func_result
      case symbol_kind::S_qtype: // qtype
      case symbol_kind::S_unit_field_base_type: // unit_field_base_type
        value.template destroy< hilti::QualifiedType* > ();
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.template destroy< hilti::Statement* > ();
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.template destroy< hilti::Statements > ();
        break;

      case symbol_kind::S_base_type_no_ref: // base_type_no_ref
      case symbol_kind::S_reference_type: // reference_type
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_type_no_ref: // type_no_ref
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
      case symbol_kind::S_unit_type: // unit_type
        value.template destroy< hilti::UnqualifiedType* > ();
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.template destroy< hilti::ctor::map::Element* > ();
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.template destroy< hilti::ctor::map::Elements > ();
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.template destroy< hilti::ctor::regexp::Pattern > ();
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.template destroy< hilti::ctor::regexp::Patterns > ();
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.template destroy< hilti::ctor::struct_::Field* > ();
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.template destroy< hilti::ctor::struct_::Fields > ();
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.template destroy< hilti::declaration::Linkage > ();
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_unit_params: // opt_unit_params
      case symbol_kind::S_opt_unit_hook_params: // opt_unit_hook_params
        value.template destroy< hilti::declaration::Parameters > ();
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.template destroy< hilti::parameter::Kind > ();
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.template destroy< hilti::statement::switch_::Case* > ();
        break;

      case symbol_kind::S_switch_cases: // switch_cases
        value.template destroy< hilti::statement::switch_::Cases > ();
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.template destroy< hilti::type::bitfield::BitRange* > ();
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.template destroy< hilti::type::bitfield::BitRanges > ();
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.template destroy< hilti::type::enum_::Label* > ();
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.template destroy< hilti::type::enum_::Labels > ();
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.template destroy< hilti::type::function::CallingConvention > ();
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
        value.template destroy< hilti::type::function::Flavor > ();
        break;

      case symbol_kind::S_func_param: // func_param
        value.template destroy< hilti::type::function::Parameter* > ();
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.template destroy< hilti::type::tuple::Element* > ();
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.template destroy< hilti::type::tuple::Elements > ();
        break;

      case symbol_kind::S_const_sint: // const_sint
        value.template destroy< int64_t > ();
        break;

      case symbol_kind::S_unit_hook: // unit_hook
        value.template destroy< spicy::declaration::Hook* > ();
        break;

      case symbol_kind::S_opt_unit_item_hooks: // opt_unit_item_hooks
      case symbol_kind::S_unit_hooks: // unit_hooks
        value.template destroy< spicy::declaration::Hooks > ();
        break;

      case symbol_kind::S_unit_item: // unit_item
      case symbol_kind::S_unit_variable: // unit_variable
      case symbol_kind::S_unit_sink: // unit_sink
      case symbol_kind::S_unit_property: // unit_property
      case symbol_kind::S_unit_field: // unit_field
      case symbol_kind::S_unit_field_in_container: // unit_field_in_container
      case symbol_kind::S_scoped_id_in_container: // scoped_id_in_container
      case symbol_kind::S_unit_wide_hook: // unit_wide_hook
      case symbol_kind::S_unit_switch: // unit_switch
      case symbol_kind::S_unit_block: // unit_block
        value.template destroy< spicy::type::unit::Item* > ();
        break;

      case symbol_kind::S_unit_items: // unit_items
      case symbol_kind::S_opt_unit_items: // opt_unit_items
      case symbol_kind::S_opt_unit_block_else_items: // opt_unit_block_else_items
        value.template destroy< spicy::type::unit::Items > ();
        break;

      case symbol_kind::S_unit_switch_case: // unit_switch_case
        value.template destroy< spicy::type::unit::item::switch_::Case* > ();
        break;

      case symbol_kind::S_unit_switch_cases: // unit_switch_cases
        value.template destroy< spicy::type::unit::item::switch_::Cases > ();
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.template destroy< std::pair<hilti::Declarations, hilti::Statements> > ();
        break;

      case symbol_kind::S_global_decl_type_and_init: // global_decl_type_and_init
        value.template destroy< std::pair<hilti::QualifiedType*, hilti::Expression*> > ();
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_HOOK_IDENT: // "hook identifier"
      case symbol_kind::S_DOLLAR_IDENT: // "$-identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_PREPROCESSOR: // "preprocessor directive"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CERROR: // "error value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.template destroy< std::string > ();
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
      case symbol_kind::S_DOLLAR_NUMBER: // "$<N>"
      case symbol_kind::S_const_uint: // const_uint
        value.template destroy< uint64_t > ();
        break;

      default:
        break;
    }

        Base::clear ();
      }

      /// The user-facing name of this symbol.
      std::string name () const YY_NOEXCEPT
      {
        return Parser::symbol_name (this->kind ());
      }

      /// Backward compatibility (Bison 3.6).
      symbol_kind_type type_get () const YY_NOEXCEPT;

      /// Whether empty.
      bool empty () const YY_NOEXCEPT;

      /// Destructive move, \a s is emptied into this.
      void move (basic_symbol& s);

      /// The semantic value.
      value_type value;

      /// The location.
      location_type location;

    private:
#if YY_CPLUSPLUS < 201103L
      /// Assignment operator.
      basic_symbol& operator= (const basic_symbol& that);
#endif
    };

    /// Type access provider for token (enum) based symbols.
    struct by_kind
    {
      /// The symbol kind as needed by the constructor.
      typedef token_kind_type kind_type;

      /// Default constructor.
      by_kind () YY_NOEXCEPT;

#if 201103L <= YY_CPLUSPLUS
      /// Move constructor.
      by_kind (by_kind&& that) YY_NOEXCEPT;
#endif

      /// Copy constructor.
      by_kind (const by_kind& that) YY_NOEXCEPT;

      /// Constructor from (external) token numbers.
      by_kind (kind_type t) YY_NOEXCEPT;



      /// Record that this symbol is empty.
      void clear () YY_NOEXCEPT;

      /// Steal the symbol kind from \a that.
      void move (by_kind& that);

      /// The (internal) type number (corresponding to \a type).
      /// \a empty when empty.
      symbol_kind_type kind () const YY_NOEXCEPT;

      /// Backward compatibility (Bison 3.6).
      symbol_kind_type type_get () const YY_NOEXCEPT;

      /// The symbol kind.
      /// \a S_YYEMPTY when empty.
      symbol_kind_type kind_;
    };

    /// Backward compatibility for a private implementation detail (Bison 3.6).
    typedef by_kind by_type;

    /// "External" symbols: returned by the scanner.
    struct symbol_type : basic_symbol<by_kind>
    {
      /// Superclass.
      typedef basic_symbol<by_kind> super_type;

      /// Empty symbol.
      symbol_type () YY_NOEXCEPT {}

      /// Constructor for valueless symbols, and symbols from each type.
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, location_type l)
        : super_type (token_kind_type (tok), std::move (l))
#else
      symbol_type (int tok, const location_type& l)
        : super_type (token_kind_type (tok), l)
#endif
      {}
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, bool v, location_type l)
        : super_type (token_kind_type (tok), std::move (v), std::move (l))
#else
      symbol_type (int tok, const bool& v, const location_type& l)
        : super_type (token_kind_type (tok), v, l)
#endif
      {}
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, double v, location_type l)
        : super_type (token_kind_type (tok), std::move (v), std::move (l))
#else
      symbol_type (int tok, const double& v, const location_type& l)
        : super_type (token_kind_type (tok), v, l)
#endif
      {}
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, std::string v, location_type l)
        : super_type (token_kind_type (tok), std::move (v), std::move (l))
#else
      symbol_type (int tok, const std::string& v, const location_type& l)
        : super_type (token_kind_type (tok), v, l)
#endif
      {}
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, uint64_t v, location_type l)
        : super_type (token_kind_type (tok), std::move (v), std::move (l))
#else
      symbol_type (int tok, const uint64_t& v, const location_type& l)
        : super_type (token_kind_type (tok), v, l)
#endif
      {}
    };

    /// Build a parser object.
    Parser (Driver* driver_yyarg, Builder* builder_yyarg);
    virtual ~Parser ();

#if 201103L <= YY_CPLUSPLUS
    /// Non copyable.
    Parser (const Parser&) = delete;
    /// Non copyable.
    Parser& operator= (const Parser&) = delete;
#endif

    /// Parse.  An alias for parse ().
    /// \returns  0 iff parsing succeeded.
    int operator() ();

    /// Parse.
    /// \returns  0 iff parsing succeeded.
    virtual int parse ();

#if YYDEBUG
    /// The current debugging stream.
    std::ostream& debug_stream () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging stream.
    void set_debug_stream (std::ostream &);

    /// Type for debugging levels.
    typedef int debug_level_type;
    /// The current debugging level.
    debug_level_type debug_level () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging level.
    void set_debug_level (debug_level_type l);
#endif

    /// Report a syntax error.
    /// \param loc    where the syntax error is found.
    /// \param msg    a description of the syntax error.
    virtual void error (const location_type& loc, const std::string& msg);

    /// Report a syntax error.
    void error (const syntax_error& err);

    /// The user-facing name of the symbol whose (internal) number is
    /// YYSYMBOL.  No bounds checking.
    static std::string symbol_name (symbol_kind_type yysymbol);

    // Implementation of make_symbol for each token kind.
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EOD (location_type l)
      {
        return symbol_type (token::EOD, std::move (l));
      }
#else
      static
      symbol_type
      make_EOD (const location_type& l)
      {
        return symbol_type (token::EOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YYerror (location_type l)
      {
        return symbol_type (token::YYerror, std::move (l));
      }
#else
      static
      symbol_type
      make_YYerror (const location_type& l)
      {
        return symbol_type (token::YYerror, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YYUNDEF (location_type l)
      {
        return symbol_type (token::YYUNDEF, std::move (l));
      }
#else
      static
      symbol_type
      make_YYUNDEF (const location_type& l)
      {
        return symbol_type (token::YYUNDEF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IDENT (std::string v, location_type l)
      {
        return symbol_type (token::IDENT, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_IDENT (const std::string& v, const location_type& l)
      {
        return symbol_type (token::IDENT, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SCOPED_IDENT (std::string v, location_type l)
      {
        return symbol_type (token::SCOPED_IDENT, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_SCOPED_IDENT (const std::string& v, const location_type& l)
      {
        return symbol_type (token::SCOPED_IDENT, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DOTTED_IDENT (std::string v, location_type l)
      {
        return symbol_type (token::DOTTED_IDENT, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_DOTTED_IDENT (const std::string& v, const location_type& l)
      {
        return symbol_type (token::DOTTED_IDENT, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HOOK_IDENT (std::string v, location_type l)
      {
        return symbol_type (token::HOOK_IDENT, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_HOOK_IDENT (const std::string& v, const location_type& l)
      {
        return symbol_type (token::HOOK_IDENT, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DOLLAR_IDENT (std::string v, location_type l)
      {
        return symbol_type (token::DOLLAR_IDENT, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_DOLLAR_IDENT (const std::string& v, const location_type& l)
      {
        return symbol_type (token::DOLLAR_IDENT, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ATTRIBUTE (std::string v, location_type l)
      {
        return symbol_type (token::ATTRIBUTE, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_ATTRIBUTE (const std::string& v, const location_type& l)
      {
        return symbol_type (token::ATTRIBUTE, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPERTY (std::string v, location_type l)
      {
        return symbol_type (token::PROPERTY, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_PROPERTY (const std::string& v, const location_type& l)
      {
        return symbol_type (token::PROPERTY, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PREPROCESSOR (std::string v, location_type l)
      {
        return symbol_type (token::PREPROCESSOR, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_PREPROCESSOR (const std::string& v, const location_type& l)
      {
        return symbol_type (token::PREPROCESSOR, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CSTRING (std::string v, location_type l)
      {
        return symbol_type (token::CSTRING, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CSTRING (const std::string& v, const location_type& l)
      {
        return symbol_type (token::CSTRING, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CBYTES (std::string v, location_type l)
      {
        return symbol_type (token::CBYTES, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CBYTES (const std::string& v, const location_type& l)
      {
        return symbol_type (token::CBYTES, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CERROR (std::string v, location_type l)
      {
        return symbol_type (token::CERROR, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CERROR (const std::string& v, const location_type& l)
      {
        return symbol_type (token::CERROR, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CREGEXP (std::string v, location_type l)
      {
        return symbol_type (token::CREGEXP, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CREGEXP (const std::string& v, const location_type& l)
      {
        return symbol_type (token::CREGEXP, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CADDRESS (std::string v, location_type l)
      {
        return symbol_type (token::CADDRESS, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CADDRESS (const std::string& v, const location_type& l)
      {
        return symbol_type (token::CADDRESS, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CPORT (std::string v, location_type l)
      {
        return symbol_type (token::CPORT, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CPORT (const std::string& v, const location_type& l)
      {
        return symbol_type (token::CPORT, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CUREAL (double v, location_type l)
      {
        return symbol_type (token::CUREAL, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CUREAL (const double& v, const location_type& l)
      {
        return symbol_type (token::CUREAL, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CUINTEGER (uint64_t v, location_type l)
      {
        return symbol_type (token::CUINTEGER, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CUINTEGER (const uint64_t& v, const location_type& l)
      {
        return symbol_type (token::CUINTEGER, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DOLLAR_NUMBER (uint64_t v, location_type l)
      {
        return symbol_type (token::DOLLAR_NUMBER, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_DOLLAR_NUMBER (const uint64_t& v, const location_type& l)
      {
        return symbol_type (token::DOLLAR_NUMBER, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CBOOL (bool v, location_type l)
      {
        return symbol_type (token::CBOOL, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CBOOL (const bool& v, const location_type& l)
      {
        return symbol_type (token::CBOOL, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CNULL (location_type l)
      {
        return symbol_type (token::CNULL, std::move (l));
      }
#else
      static
      symbol_type
      make_CNULL (const location_type& l)
      {
        return symbol_type (token::CNULL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ASSERT (location_type l)
      {
        return symbol_type (token::ASSERT, std::move (l));
      }
#else
      static
      symbol_type
      make_ASSERT (const location_type& l)
      {
        return symbol_type (token::ASSERT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ASSERT_EXCEPTION (location_type l)
      {
        return symbol_type (token::ASSERT_EXCEPTION, std::move (l));
      }
#else
      static
      symbol_type
      make_ASSERT_EXCEPTION (const location_type& l)
      {
        return symbol_type (token::ASSERT_EXCEPTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADD (location_type l)
      {
        return symbol_type (token::ADD, std::move (l));
      }
#else
      static
      symbol_type
      make_ADD (const location_type& l)
      {
        return symbol_type (token::ADD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADDRESS (location_type l)
      {
        return symbol_type (token::ADDRESS, std::move (l));
      }
#else
      static
      symbol_type
      make_ADDRESS (const location_type& l)
      {
        return symbol_type (token::ADDRESS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AND (location_type l)
      {
        return symbol_type (token::AND, std::move (l));
      }
#else
      static
      symbol_type
      make_AND (const location_type& l)
      {
        return symbol_type (token::AND, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ANY (location_type l)
      {
        return symbol_type (token::ANY, std::move (l));
      }
#else
      static
      symbol_type
      make_ANY (const location_type& l)
      {
        return symbol_type (token::ANY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ARROW (location_type l)
      {
        return symbol_type (token::ARROW, std::move (l));
      }
#else
      static
      symbol_type
      make_ARROW (const location_type& l)
      {
        return symbol_type (token::ARROW, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AUTO (location_type l)
      {
        return symbol_type (token::AUTO, std::move (l));
      }
#else
      static
      symbol_type
      make_AUTO (const location_type& l)
      {
        return symbol_type (token::AUTO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BITFIELD (location_type l)
      {
        return symbol_type (token::BITFIELD, std::move (l));
      }
#else
      static
      symbol_type
      make_BITFIELD (const location_type& l)
      {
        return symbol_type (token::BITFIELD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BEGIN_ (location_type l)
      {
        return symbol_type (token::BEGIN_, std::move (l));
      }
#else
      static
      symbol_type
      make_BEGIN_ (const location_type& l)
      {
        return symbol_type (token::BEGIN_, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BOOL (location_type l)
      {
        return symbol_type (token::BOOL, std::move (l));
      }
#else
      static
      symbol_type
      make_BOOL (const location_type& l)
      {
        return symbol_type (token::BOOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BREAK (location_type l)
      {
        return symbol_type (token::BREAK, std::move (l));
      }
#else
      static
      symbol_type
      make_BREAK (const location_type& l)
      {
        return symbol_type (token::BREAK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BYTES (location_type l)
      {
        return symbol_type (token::BYTES, std::move (l));
      }
#else
      static
      symbol_type
      make_BYTES (const location_type& l)
      {
        return symbol_type (token::BYTES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CADDR (location_type l)
      {
        return symbol_type (token::CADDR, std::move (l));
      }
#else
      static
      symbol_type
      make_CADDR (const location_type& l)
      {
        return symbol_type (token::CADDR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CASE (location_type l)
      {
        return symbol_type (token::CASE, std::move (l));
      }
#else
      static
      symbol_type
      make_CASE (const location_type& l)
      {
        return symbol_type (token::CASE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CAST (location_type l)
      {
        return symbol_type (token::CAST, std::move (l));
      }
#else
      static
      symbol_type
      make_CAST (const location_type& l)
      {
        return symbol_type (token::CAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CATCH (location_type l)
      {
        return symbol_type (token::CATCH, std::move (l));
      }
#else
      static
      symbol_type
      make_CATCH (const location_type& l)
      {
        return symbol_type (token::CATCH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONST (location_type l)
      {
        return symbol_type (token::CONST, std::move (l));
      }
#else
      static
      symbol_type
      make_CONST (const location_type& l)
      {
        return symbol_type (token::CONST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONSTANT (location_type l)
      {
        return symbol_type (token::CONSTANT, std::move (l));
      }
#else
      static
      symbol_type
      make_CONSTANT (const location_type& l)
      {
        return symbol_type (token::CONSTANT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONTINUE (location_type l)
      {
        return symbol_type (token::CONTINUE, std::move (l));
      }
#else
      static
      symbol_type
      make_CONTINUE (const location_type& l)
      {
        return symbol_type (token::CONTINUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DEBUG_ (location_type l)
      {
        return symbol_type (token::DEBUG_, std::move (l));
      }
#else
      static
      symbol_type
      make_DEBUG_ (const location_type& l)
      {
        return symbol_type (token::DEBUG_, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DECLARE (location_type l)
      {
        return symbol_type (token::DECLARE, std::move (l));
      }
#else
      static
      symbol_type
      make_DECLARE (const location_type& l)
      {
        return symbol_type (token::DECLARE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DEFAULT (location_type l)
      {
        return symbol_type (token::DEFAULT, std::move (l));
      }
#else
      static
      symbol_type
      make_DEFAULT (const location_type& l)
      {
        return symbol_type (token::DEFAULT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DELETE (location_type l)
      {
        return symbol_type (token::DELETE, std::move (l));
      }
#else
      static
      symbol_type
      make_DELETE (const location_type& l)
      {
        return symbol_type (token::DELETE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIVIDEASSIGN (location_type l)
      {
        return symbol_type (token::DIVIDEASSIGN, std::move (l));
      }
#else
      static
      symbol_type
      make_DIVIDEASSIGN (const location_type& l)
      {
        return symbol_type (token::DIVIDEASSIGN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DOLLARDOLLAR (location_type l)
      {
        return symbol_type (token::DOLLARDOLLAR, std::move (l));
      }
#else
      static
      symbol_type
      make_DOLLARDOLLAR (const location_type& l)
      {
        return symbol_type (token::DOLLARDOLLAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DOTDOT (location_type l)
      {
        return symbol_type (token::DOTDOT, std::move (l));
      }
#else
      static
      symbol_type
      make_DOTDOT (const location_type& l)
      {
        return symbol_type (token::DOTDOT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REAL (location_type l)
      {
        return symbol_type (token::REAL, std::move (l));
      }
#else
      static
      symbol_type
      make_REAL (const location_type& l)
      {
        return symbol_type (token::REAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ELSE (location_type l)
      {
        return symbol_type (token::ELSE, std::move (l));
      }
#else
      static
      symbol_type
      make_ELSE (const location_type& l)
      {
        return symbol_type (token::ELSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_END_ (location_type l)
      {
        return symbol_type (token::END_, std::move (l));
      }
#else
      static
      symbol_type
      make_END_ (const location_type& l)
      {
        return symbol_type (token::END_, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ENUM (location_type l)
      {
        return symbol_type (token::ENUM, std::move (l));
      }
#else
      static
      symbol_type
      make_ENUM (const location_type& l)
      {
        return symbol_type (token::ENUM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQ (location_type l)
      {
        return symbol_type (token::EQ, std::move (l));
      }
#else
      static
      symbol_type
      make_EQ (const location_type& l)
      {
        return symbol_type (token::EQ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make___ERROR (location_type l)
      {
        return symbol_type (token::__ERROR, std::move (l));
      }
#else
      static
      symbol_type
      make___ERROR (const location_type& l)
      {
        return symbol_type (token::__ERROR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXCEPTION (location_type l)
      {
        return symbol_type (token::EXCEPTION, std::move (l));
      }
#else
      static
      symbol_type
      make_EXCEPTION (const location_type& l)
      {
        return symbol_type (token::EXCEPTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXPORT (location_type l)
      {
        return symbol_type (token::EXPORT, std::move (l));
      }
#else
      static
      symbol_type
      make_EXPORT (const location_type& l)
      {
        return symbol_type (token::EXPORT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILE (location_type l)
      {
        return symbol_type (token::FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_FILE (const location_type& l)
      {
        return symbol_type (token::FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FOR (location_type l)
      {
        return symbol_type (token::FOR, std::move (l));
      }
#else
      static
      symbol_type
      make_FOR (const location_type& l)
      {
        return symbol_type (token::FOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FOREACH (location_type l)
      {
        return symbol_type (token::FOREACH, std::move (l));
      }
#else
      static
      symbol_type
      make_FOREACH (const location_type& l)
      {
        return symbol_type (token::FOREACH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FROM (location_type l)
      {
        return symbol_type (token::FROM, std::move (l));
      }
#else
      static
      symbol_type
      make_FROM (const location_type& l)
      {
        return symbol_type (token::FROM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FUNCTION (location_type l)
      {
        return symbol_type (token::FUNCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_FUNCTION (const location_type& l)
      {
        return symbol_type (token::FUNCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GEQ (location_type l)
      {
        return symbol_type (token::GEQ, std::move (l));
      }
#else
      static
      symbol_type
      make_GEQ (const location_type& l)
      {
        return symbol_type (token::GEQ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GLOBAL (location_type l)
      {
        return symbol_type (token::GLOBAL, std::move (l));
      }
#else
      static
      symbol_type
      make_GLOBAL (const location_type& l)
      {
        return symbol_type (token::GLOBAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HASATTR (location_type l)
      {
        return symbol_type (token::HASATTR, std::move (l));
      }
#else
      static
      symbol_type
      make_HASATTR (const location_type& l)
      {
        return symbol_type (token::HASATTR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HOOK_COMPOSE (location_type l)
      {
        return symbol_type (token::HOOK_COMPOSE, std::move (l));
      }
#else
      static
      symbol_type
      make_HOOK_COMPOSE (const location_type& l)
      {
        return symbol_type (token::HOOK_COMPOSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HOOK_PARSE (location_type l)
      {
        return symbol_type (token::HOOK_PARSE, std::move (l));
      }
#else
      static
      symbol_type
      make_HOOK_PARSE (const location_type& l)
      {
        return symbol_type (token::HOOK_PARSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IF (location_type l)
      {
        return symbol_type (token::IF, std::move (l));
      }
#else
      static
      symbol_type
      make_IF (const location_type& l)
      {
        return symbol_type (token::IF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IMPORT (location_type l)
      {
        return symbol_type (token::IMPORT, std::move (l));
      }
#else
      static
      symbol_type
      make_IMPORT (const location_type& l)
      {
        return symbol_type (token::IMPORT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IN (location_type l)
      {
        return symbol_type (token::IN, std::move (l));
      }
#else
      static
      symbol_type
      make_IN (const location_type& l)
      {
        return symbol_type (token::IN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INOUT (location_type l)
      {
        return symbol_type (token::INOUT, std::move (l));
      }
#else
      static
      symbol_type
      make_INOUT (const location_type& l)
      {
        return symbol_type (token::INOUT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INT (location_type l)
      {
        return symbol_type (token::INT, std::move (l));
      }
#else
      static
      symbol_type
      make_INT (const location_type& l)
      {
        return symbol_type (token::INT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INT16 (location_type l)
      {
        return symbol_type (token::INT16, std::move (l));
      }
#else
      static
      symbol_type
      make_INT16 (const location_type& l)
      {
        return symbol_type (token::INT16, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INT32 (location_type l)
      {
        return symbol_type (token::INT32, std::move (l));
      }
#else
      static
      symbol_type
      make_INT32 (const location_type& l)
      {
        return symbol_type (token::INT32, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INT64 (location_type l)
      {
        return symbol_type (token::INT64, std::move (l));
      }
#else
      static
      symbol_type
      make_INT64 (const location_type& l)
      {
        return symbol_type (token::INT64, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INT8 (location_type l)
      {
        return symbol_type (token::INT8, std::move (l));
      }
#else
      static
      symbol_type
      make_INT8 (const location_type& l)
      {
        return symbol_type (token::INT8, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INTERVAL (location_type l)
      {
        return symbol_type (token::INTERVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_INTERVAL (const location_type& l)
      {
        return symbol_type (token::INTERVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INTERVAL_NS (location_type l)
      {
        return symbol_type (token::INTERVAL_NS, std::move (l));
      }
#else
      static
      symbol_type
      make_INTERVAL_NS (const location_type& l)
      {
        return symbol_type (token::INTERVAL_NS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ITERATOR (location_type l)
      {
        return symbol_type (token::ITERATOR, std::move (l));
      }
#else
      static
      symbol_type
      make_ITERATOR (const location_type& l)
      {
        return symbol_type (token::ITERATOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONST_ITERATOR (location_type l)
      {
        return symbol_type (token::CONST_ITERATOR, std::move (l));
      }
#else
      static
      symbol_type
      make_CONST_ITERATOR (const location_type& l)
      {
        return symbol_type (token::CONST_ITERATOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LEQ (location_type l)
      {
        return symbol_type (token::LEQ, std::move (l));
      }
#else
      static
      symbol_type
      make_LEQ (const location_type& l)
      {
        return symbol_type (token::LEQ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIBRARY_TYPE (location_type l)
      {
        return symbol_type (token::LIBRARY_TYPE, std::move (l));
      }
#else
      static
      symbol_type
      make_LIBRARY_TYPE (const location_type& l)
      {
        return symbol_type (token::LIBRARY_TYPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIBRARY_TYPE_CONST (location_type l)
      {
        return symbol_type (token::LIBRARY_TYPE_CONST, std::move (l));
      }
#else
      static
      symbol_type
      make_LIBRARY_TYPE_CONST (const location_type& l)
      {
        return symbol_type (token::LIBRARY_TYPE_CONST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIST (location_type l)
      {
        return symbol_type (token::LIST, std::move (l));
      }
#else
      static
      symbol_type
      make_LIST (const location_type& l)
      {
        return symbol_type (token::LIST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOCAL (location_type l)
      {
        return symbol_type (token::LOCAL, std::move (l));
      }
#else
      static
      symbol_type
      make_LOCAL (const location_type& l)
      {
        return symbol_type (token::LOCAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAP (location_type l)
      {
        return symbol_type (token::MAP, std::move (l));
      }
#else
      static
      symbol_type
      make_MAP (const location_type& l)
      {
        return symbol_type (token::MAP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MARK (location_type l)
      {
        return symbol_type (token::MARK, std::move (l));
      }
#else
      static
      symbol_type
      make_MARK (const location_type& l)
      {
        return symbol_type (token::MARK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CAPTURES (location_type l)
      {
        return symbol_type (token::CAPTURES, std::move (l));
      }
#else
      static
      symbol_type
      make_CAPTURES (const location_type& l)
      {
        return symbol_type (token::CAPTURES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MINUSASSIGN (location_type l)
      {
        return symbol_type (token::MINUSASSIGN, std::move (l));
      }
#else
      static
      symbol_type
      make_MINUSASSIGN (const location_type& l)
      {
        return symbol_type (token::MINUSASSIGN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MINUSMINUS (location_type l)
      {
        return symbol_type (token::MINUSMINUS, std::move (l));
      }
#else
      static
      symbol_type
      make_MINUSMINUS (const location_type& l)
      {
        return symbol_type (token::MINUSMINUS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MOD (location_type l)
      {
        return symbol_type (token::MOD, std::move (l));
      }
#else
      static
      symbol_type
      make_MOD (const location_type& l)
      {
        return symbol_type (token::MOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODULE (location_type l)
      {
        return symbol_type (token::MODULE, std::move (l));
      }
#else
      static
      symbol_type
      make_MODULE (const location_type& l)
      {
        return symbol_type (token::MODULE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NEQ (location_type l)
      {
        return symbol_type (token::NEQ, std::move (l));
      }
#else
      static
      symbol_type
      make_NEQ (const location_type& l)
      {
        return symbol_type (token::NEQ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NETWORK (location_type l)
      {
        return symbol_type (token::NETWORK, std::move (l));
      }
#else
      static
      symbol_type
      make_NETWORK (const location_type& l)
      {
        return symbol_type (token::NETWORK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NEW (location_type l)
      {
        return symbol_type (token::NEW, std::move (l));
      }
#else
      static
      symbol_type
      make_NEW (const location_type& l)
      {
        return symbol_type (token::NEW, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NONE (location_type l)
      {
        return symbol_type (token::NONE, std::move (l));
      }
#else
      static
      symbol_type
      make_NONE (const location_type& l)
      {
        return symbol_type (token::NONE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOT_IN (location_type l)
      {
        return symbol_type (token::NOT_IN, std::move (l));
      }
#else
      static
      symbol_type
      make_NOT_IN (const location_type& l)
      {
        return symbol_type (token::NOT_IN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OBJECT (location_type l)
      {
        return symbol_type (token::OBJECT, std::move (l));
      }
#else
      static
      symbol_type
      make_OBJECT (const location_type& l)
      {
        return symbol_type (token::OBJECT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ON (location_type l)
      {
        return symbol_type (token::ON, std::move (l));
      }
#else
      static
      symbol_type
      make_ON (const location_type& l)
      {
        return symbol_type (token::ON, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OPTIONAL (location_type l)
      {
        return symbol_type (token::OPTIONAL, std::move (l));
      }
#else
      static
      symbol_type
      make_OPTIONAL (const location_type& l)
      {
        return symbol_type (token::OPTIONAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OR (location_type l)
      {
        return symbol_type (token::OR, std::move (l));
      }
#else
      static
      symbol_type
      make_OR (const location_type& l)
      {
        return symbol_type (token::OR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PACK (location_type l)
      {
        return symbol_type (token::PACK, std::move (l));
      }
#else
      static
      symbol_type
      make_PACK (const location_type& l)
      {
        return symbol_type (token::PACK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLUSASSIGN (location_type l)
      {
        return symbol_type (token::PLUSASSIGN, std::move (l));
      }
#else
      static
      symbol_type
      make_PLUSASSIGN (const location_type& l)
      {
        return symbol_type (token::PLUSASSIGN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLUSPLUS (location_type l)
      {
        return symbol_type (token::PLUSPLUS, std::move (l));
      }
#else
      static
      symbol_type
      make_PLUSPLUS (const location_type& l)
      {
        return symbol_type (token::PLUSPLUS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PORT (location_type l)
      {
        return symbol_type (token::PORT, std::move (l));
      }
#else
      static
      symbol_type
      make_PORT (const location_type& l)
      {
        return symbol_type (token::PORT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POW (location_type l)
      {
        return symbol_type (token::POW, std::move (l));
      }
#else
      static
      symbol_type
      make_POW (const location_type& l)
      {
        return symbol_type (token::POW, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRINT (location_type l)
      {
        return symbol_type (token::PRINT, std::move (l));
      }
#else
      static
      symbol_type
      make_PRINT (const location_type& l)
      {
        return symbol_type (token::PRINT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIORITY (location_type l)
      {
        return symbol_type (token::PRIORITY, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIORITY (const location_type& l)
      {
        return symbol_type (token::PRIORITY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIVATE (location_type l)
      {
        return symbol_type (token::PRIVATE, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIVATE (const location_type& l)
      {
        return symbol_type (token::PRIVATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PUBLIC (location_type l)
      {
        return symbol_type (token::PUBLIC, std::move (l));
      }
#else
      static
      symbol_type
      make_PUBLIC (const location_type& l)
      {
        return symbol_type (token::PUBLIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REGEXP (location_type l)
      {
        return symbol_type (token::REGEXP, std::move (l));
      }
#else
      static
      symbol_type
      make_REGEXP (const location_type& l)
      {
        return symbol_type (token::REGEXP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESULT (location_type l)
      {
        return symbol_type (token::RESULT, std::move (l));
      }
#else
      static
      symbol_type
      make_RESULT (const location_type& l)
      {
        return symbol_type (token::RESULT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RETURN (location_type l)
      {
        return symbol_type (token::RETURN, std::move (l));
      }
#else
      static
      symbol_type
      make_RETURN (const location_type& l)
      {
        return symbol_type (token::RETURN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SET (location_type l)
      {
        return symbol_type (token::SET, std::move (l));
      }
#else
      static
      symbol_type
      make_SET (const location_type& l)
      {
        return symbol_type (token::SET, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHIFTLEFT (location_type l)
      {
        return symbol_type (token::SHIFTLEFT, std::move (l));
      }
#else
      static
      symbol_type
      make_SHIFTLEFT (const location_type& l)
      {
        return symbol_type (token::SHIFTLEFT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHIFTRIGHT (location_type l)
      {
        return symbol_type (token::SHIFTRIGHT, std::move (l));
      }
#else
      static
      symbol_type
      make_SHIFTRIGHT (const location_type& l)
      {
        return symbol_type (token::SHIFTRIGHT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SINK (location_type l)
      {
        return symbol_type (token::SINK, std::move (l));
      }
#else
      static
      symbol_type
      make_SINK (const location_type& l)
      {
        return symbol_type (token::SINK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SKIP (location_type l)
      {
        return symbol_type (token::SKIP, std::move (l));
      }
#else
      static
      symbol_type
      make_SKIP (const location_type& l)
      {
        return symbol_type (token::SKIP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STOP (location_type l)
      {
        return symbol_type (token::STOP, std::move (l));
      }
#else
      static
      symbol_type
      make_STOP (const location_type& l)
      {
        return symbol_type (token::STOP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STREAM (location_type l)
      {
        return symbol_type (token::STREAM, std::move (l));
      }
#else
      static
      symbol_type
      make_STREAM (const location_type& l)
      {
        return symbol_type (token::STREAM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STRING (location_type l)
      {
        return symbol_type (token::STRING, std::move (l));
      }
#else
      static
      symbol_type
      make_STRING (const location_type& l)
      {
        return symbol_type (token::STRING, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STRUCT (location_type l)
      {
        return symbol_type (token::STRUCT, std::move (l));
      }
#else
      static
      symbol_type
      make_STRUCT (const location_type& l)
      {
        return symbol_type (token::STRUCT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SWITCH (location_type l)
      {
        return symbol_type (token::SWITCH, std::move (l));
      }
#else
      static
      symbol_type
      make_SWITCH (const location_type& l)
      {
        return symbol_type (token::SWITCH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONFIRM (location_type l)
      {
        return symbol_type (token::CONFIRM, std::move (l));
      }
#else
      static
      symbol_type
      make_CONFIRM (const location_type& l)
      {
        return symbol_type (token::CONFIRM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REJECT_ (location_type l)
      {
        return symbol_type (token::REJECT_, std::move (l));
      }
#else
      static
      symbol_type
      make_REJECT_ (const location_type& l)
      {
        return symbol_type (token::REJECT_, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_THROW (location_type l)
      {
        return symbol_type (token::THROW, std::move (l));
      }
#else
      static
      symbol_type
      make_THROW (const location_type& l)
      {
        return symbol_type (token::THROW, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TIME (location_type l)
      {
        return symbol_type (token::TIME, std::move (l));
      }
#else
      static
      symbol_type
      make_TIME (const location_type& l)
      {
        return symbol_type (token::TIME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TIME_NS (location_type l)
      {
        return symbol_type (token::TIME_NS, std::move (l));
      }
#else
      static
      symbol_type
      make_TIME_NS (const location_type& l)
      {
        return symbol_type (token::TIME_NS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TIMER (location_type l)
      {
        return symbol_type (token::TIMER, std::move (l));
      }
#else
      static
      symbol_type
      make_TIMER (const location_type& l)
      {
        return symbol_type (token::TIMER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TIMESASSIGN (location_type l)
      {
        return symbol_type (token::TIMESASSIGN, std::move (l));
      }
#else
      static
      symbol_type
      make_TIMESASSIGN (const location_type& l)
      {
        return symbol_type (token::TIMESASSIGN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TRY (location_type l)
      {
        return symbol_type (token::TRY, std::move (l));
      }
#else
      static
      symbol_type
      make_TRY (const location_type& l)
      {
        return symbol_type (token::TRY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TRYATTR (location_type l)
      {
        return symbol_type (token::TRYATTR, std::move (l));
      }
#else
      static
      symbol_type
      make_TRYATTR (const location_type& l)
      {
        return symbol_type (token::TRYATTR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TUPLE (location_type l)
      {
        return symbol_type (token::TUPLE, std::move (l));
      }
#else
      static
      symbol_type
      make_TUPLE (const location_type& l)
      {
        return symbol_type (token::TUPLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TYPE (location_type l)
      {
        return symbol_type (token::TYPE, std::move (l));
      }
#else
      static
      symbol_type
      make_TYPE (const location_type& l)
      {
        return symbol_type (token::TYPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TYPEINFO (location_type l)
      {
        return symbol_type (token::TYPEINFO, std::move (l));
      }
#else
      static
      symbol_type
      make_TYPEINFO (const location_type& l)
      {
        return symbol_type (token::TYPEINFO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UINT (location_type l)
      {
        return symbol_type (token::UINT, std::move (l));
      }
#else
      static
      symbol_type
      make_UINT (const location_type& l)
      {
        return symbol_type (token::UINT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UINT16 (location_type l)
      {
        return symbol_type (token::UINT16, std::move (l));
      }
#else
      static
      symbol_type
      make_UINT16 (const location_type& l)
      {
        return symbol_type (token::UINT16, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UINT32 (location_type l)
      {
        return symbol_type (token::UINT32, std::move (l));
      }
#else
      static
      symbol_type
      make_UINT32 (const location_type& l)
      {
        return symbol_type (token::UINT32, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UINT64 (location_type l)
      {
        return symbol_type (token::UINT64, std::move (l));
      }
#else
      static
      symbol_type
      make_UINT64 (const location_type& l)
      {
        return symbol_type (token::UINT64, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UINT8 (location_type l)
      {
        return symbol_type (token::UINT8, std::move (l));
      }
#else
      static
      symbol_type
      make_UINT8 (const location_type& l)
      {
        return symbol_type (token::UINT8, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNIT (location_type l)
      {
        return symbol_type (token::UNIT, std::move (l));
      }
#else
      static
      symbol_type
      make_UNIT (const location_type& l)
      {
        return symbol_type (token::UNIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNPACK (location_type l)
      {
        return symbol_type (token::UNPACK, std::move (l));
      }
#else
      static
      symbol_type
      make_UNPACK (const location_type& l)
      {
        return symbol_type (token::UNPACK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNSET (location_type l)
      {
        return symbol_type (token::UNSET, std::move (l));
      }
#else
      static
      symbol_type
      make_UNSET (const location_type& l)
      {
        return symbol_type (token::UNSET, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAR (location_type l)
      {
        return symbol_type (token::VAR, std::move (l));
      }
#else
      static
      symbol_type
      make_VAR (const location_type& l)
      {
        return symbol_type (token::VAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VECTOR (location_type l)
      {
        return symbol_type (token::VECTOR, std::move (l));
      }
#else
      static
      symbol_type
      make_VECTOR (const location_type& l)
      {
        return symbol_type (token::VECTOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VIEW (location_type l)
      {
        return symbol_type (token::VIEW, std::move (l));
      }
#else
      static
      symbol_type
      make_VIEW (const location_type& l)
      {
        return symbol_type (token::VIEW, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VOID (location_type l)
      {
        return symbol_type (token::VOID, std::move (l));
      }
#else
      static
      symbol_type
      make_VOID (const location_type& l)
      {
        return symbol_type (token::VOID, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WHILE (location_type l)
      {
        return symbol_type (token::WHILE, std::move (l));
      }
#else
      static
      symbol_type
      make_WHILE (const location_type& l)
      {
        return symbol_type (token::WHILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNARY_PREC (location_type l)
      {
        return symbol_type (token::UNARY_PREC, std::move (l));
      }
#else
      static
      symbol_type
      make_UNARY_PREC (const location_type& l)
      {
        return symbol_type (token::UNARY_PREC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_START_MODULE (location_type l)
      {
        return symbol_type (token::START_MODULE, std::move (l));
      }
#else
      static
      symbol_type
      make_START_MODULE (const location_type& l)
      {
        return symbol_type (token::START_MODULE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_START_EXPRESSION (location_type l)
      {
        return symbol_type (token::START_EXPRESSION, std::move (l));
      }
#else
      static
      symbol_type
      make_START_EXPRESSION (const location_type& l)
      {
        return symbol_type (token::START_EXPRESSION, l);
      }
#endif


    class context
    {
    public:
      context (const Parser& yyparser, const symbol_type& yyla);
      const symbol_type& lookahead () const YY_NOEXCEPT { return yyla_; }
      symbol_kind_type token () const YY_NOEXCEPT { return yyla_.kind (); }
      const location_type& location () const YY_NOEXCEPT { return yyla_.location; }

      /// Put in YYARG at most YYARGN of the expected tokens, and return the
      /// number of tokens stored in YYARG.  If YYARG is null, return the
      /// number of expected tokens (guaranteed to be less than YYNTOKENS).
      int expected_tokens (symbol_kind_type yyarg[], int yyargn) const;

    private:
      const Parser& yyparser_;
      const symbol_type& yyla_;
    };

  private:
#if YY_CPLUSPLUS < 201103L
    /// Non copyable.
    Parser (const Parser&);
    /// Non copyable.
    Parser& operator= (const Parser&);
#endif


    /// Stored state numbers (used for stacks).
    typedef short state_type;

    /// The arguments of the error message.
    int yy_syntax_error_arguments_ (const context& yyctx,
                                    symbol_kind_type yyarg[], int yyargn) const;

    /// Generate an error message.
    /// \param yyctx     the context in which the error occurred.
    virtual std::string yysyntax_error_ (const context& yyctx) const;
    /// Compute post-reduction state.
    /// \param yystate   the current state
    /// \param yysym     the nonterminal to push on the stack
    static state_type yy_lr_goto_state_ (state_type yystate, int yysym);

    /// Whether the given \c yypact_ value indicates a defaulted state.
    /// \param yyvalue   the value to check
    static bool yy_pact_value_is_default_ (int yyvalue) YY_NOEXCEPT;

    /// Whether the given \c yytable_ value indicates a syntax error.
    /// \param yyvalue   the value to check
    static bool yy_table_value_is_error_ (int yyvalue) YY_NOEXCEPT;

    static const short yypact_ninf_;
    static const short yytable_ninf_;

    /// Convert a scanner token kind \a t to a symbol kind.
    /// In theory \a t should be a token_kind_type, but character literals
    /// are valid, yet not members of the token_kind_type enum.
    static symbol_kind_type yytranslate_ (int t) YY_NOEXCEPT;

    /// Convert the symbol name \a n to a form suitable for a diagnostic.
    static std::string yytnamerr_ (const char *yystr);

    /// For a symbol, its name in clear.
    static const char* const yytname_[];


    // Tables.
    // YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
    // STATE-NUM.
    static const short yypact_[];

    // YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
    // Performed when YYTABLE does not specify something else to do.  Zero
    // means the default is an error.
    static const short yydefact_[];

    // YYPGOTO[NTERM-NUM].
    static const short yypgoto_[];

    // YYDEFGOTO[NTERM-NUM].
    static const short yydefgoto_[];

    // YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
    // positive, shift that token.  If negative, reduce the rule whose
    // number is the opposite.  If YYTABLE_NINF, syntax error.
    static const short yytable_[];

    static const short yycheck_[];

    // YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
    // state STATE-NUM.
    static const short yystos_[];

    // YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.
    static const short yyr1_[];

    // YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.
    static const signed char yyr2_[];


#if YYDEBUG
    // YYRLINE[YYN] -- Source line where rule number YYN was defined.
    static const short yyrline_[];
    /// Report on the debug stream that the rule \a r is going to be reduced.
    virtual void yy_reduce_print_ (int r) const;
    /// Print the state stack on the debug stream.
    virtual void yy_stack_print_ () const;

    /// Debugging level.
    int yydebug_;
    /// Debug stream.
    std::ostream* yycdebug_;

    /// \brief Display a symbol kind, value and location.
    /// \param yyo    The output stream.
    /// \param yysym  The symbol.
    template <typename Base>
    void yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const;
#endif

    /// \brief Reclaim the memory associated to a symbol.
    /// \param yymsg     Why this token is reclaimed.
    ///                  If null, print nothing.
    /// \param yysym     The symbol.
    template <typename Base>
    void yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const;

  private:
    /// Type access provider for state based symbols.
    struct by_state
    {
      /// Default constructor.
      by_state () YY_NOEXCEPT;

      /// The symbol kind as needed by the constructor.
      typedef state_type kind_type;

      /// Constructor.
      by_state (kind_type s) YY_NOEXCEPT;

      /// Copy constructor.
      by_state (const by_state& that) YY_NOEXCEPT;

      /// Record that this symbol is empty.
      void clear () YY_NOEXCEPT;

      /// Steal the symbol kind from \a that.
      void move (by_state& that);

      /// The symbol kind (corresponding to \a state).
      /// \a symbol_kind::S_YYEMPTY when empty.
      symbol_kind_type kind () const YY_NOEXCEPT;

      /// The state number used to denote an empty symbol.
      /// We use the initial state, as it does not have a value.
      enum { empty_state = 0 };

      /// The state.
      /// \a empty when empty.
      state_type state;
    };

    /// "Internal" symbol: element of the stack.
    struct stack_symbol_type : basic_symbol<by_state>
    {
      /// Superclass.
      typedef basic_symbol<by_state> super_type;
      /// Construct an empty symbol.
      stack_symbol_type ();
      /// Move or copy construction.
      stack_symbol_type (YY_RVREF (stack_symbol_type) that);
      /// Steal the contents from \a sym to build this.
      stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) sym);
#if YY_CPLUSPLUS < 201103L
      /// Assignment, needed by push_back by some old implementations.
      /// Moves the contents of that.
      stack_symbol_type& operator= (stack_symbol_type& that);

      /// Assignment, needed by push_back by other implementations.
      /// Needed by some other old implementations.
      stack_symbol_type& operator= (const stack_symbol_type& that);
#endif
    };

    /// A stack with random access from its top.
    template <typename T, typename S = std::vector<T> >
    class stack
    {
    public:
      // Hide our reversed order.
      typedef typename S::iterator iterator;
      typedef typename S::const_iterator const_iterator;
      typedef typename S::size_type size_type;
      typedef typename std::ptrdiff_t index_type;

      stack (size_type n = 200) YY_NOEXCEPT
        : seq_ (n)
      {}

#if 201103L <= YY_CPLUSPLUS
      /// Non copyable.
      stack (const stack&) = delete;
      /// Non copyable.
      stack& operator= (const stack&) = delete;
#endif

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      const T&
      operator[] (index_type i) const
      {
        return seq_[size_type (size () - 1 - i)];
      }

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      T&
      operator[] (index_type i)
      {
        return seq_[size_type (size () - 1 - i)];
      }

      /// Steal the contents of \a t.
      ///
      /// Close to move-semantics.
      void
      push (YY_MOVE_REF (T) t)
      {
        seq_.push_back (T ());
        operator[] (0).move (t);
      }

      /// Pop elements from the stack.
      void
      pop (std::ptrdiff_t n = 1) YY_NOEXCEPT
      {
        for (; 0 < n; --n)
          seq_.pop_back ();
      }

      /// Pop all elements from the stack.
      void
      clear () YY_NOEXCEPT
      {
        seq_.clear ();
      }

      /// Number of elements on the stack.
      index_type
      size () const YY_NOEXCEPT
      {
        return index_type (seq_.size ());
      }

      /// Iterator on top of the stack (going downwards).
      const_iterator
      begin () const YY_NOEXCEPT
      {
        return seq_.begin ();
      }

      /// Bottom of the stack.
      const_iterator
      end () const YY_NOEXCEPT
      {
        return seq_.end ();
      }

      /// Present a slice of the top of a stack.
      class slice
      {
      public:
        slice (const stack& stack, index_type range) YY_NOEXCEPT
          : stack_ (stack)
          , range_ (range)
        {}

        const T&
        operator[] (index_type i) const
        {
          return stack_[range_ - i];
        }

      private:
        const stack& stack_;
        index_type range_;
      };

    private:
#if YY_CPLUSPLUS < 201103L
      /// Non copyable.
      stack (const stack&);
      /// Non copyable.
      stack& operator= (const stack&);
#endif
      /// The wrapped container.
      S seq_;
    };


    /// Stack type.
    typedef stack<stack_symbol_type> stack_type;

    /// The stack.
    stack_type yystack_;

    /// Push a new state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param sym  the symbol
    /// \warning the contents of \a s.value is stolen.
    void yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym);

    /// Push a new look ahead token on the state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param s    the state
    /// \param sym  the symbol (for its value and location).
    /// \warning the contents of \a sym.value is stolen.
    void yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym);

    /// Pop \a n symbols from the stack.
    void yypop_ (int n = 1) YY_NOEXCEPT;

    /// Constants.
    enum
    {
      yylast_ = 4249,     ///< Last index in yytable_.
      yynnts_ = 148,  ///< Number of nonterminal symbols.
      yyfinal_ = 9 ///< Termination state number.
    };


    // User arguments.
    Driver* driver;
    Builder* builder;

  };


#line 29 "/build/zeek/src/zeek/auxil/spicy/spicy/toolchain/src/compiler/parser/parser.yy"
} } } // spicy::detail::parser
#line 5202 "/build/zeek/src/zeek/build/auxil/spicy/spicy/src/autogen/__parser.h"




#endif // !YY_YY_BUILD_ZEEK_SRC_ZEEK_BUILD_AUXIL_SPICY_SPICY_SRC_AUTOGEN_PARSER_H_INCLUDED
