// NOLINTBEGIN(bugprone-branch-clone)
case OP_VECTOR_ELEM_ASSIGN_VVV:
	{
	EvalVectorElemAssign(frame[z.v1], frame[z.v2],, copy_vec_elem(vv, ind, frame[z.v3], Z_TYPE))
	}
	break;

case OP_ANY_VECTOR_ELEM_ASSIGN_VVV:
	{
	auto ind = frame[z.v2].AsCount();
	auto vv = frame[z.v1].AsVector();
	auto yt = vv->RawYieldTypes();
	if ( ind < vv->Size() && yt && (*yt)[ind] && ZVal::IsManagedType((*yt)[ind]) )
		{
		auto orig_elem = vv->RawVec()[ind];
		if ( ! vv->Assign(ind, frame[z.v3].ToVal(Z_TYPE)) )
			ERROR("value used but not set");
		if ( orig_elem )
			ZVal::DeleteManagedType(*orig_elem);
		}
	else if ( ! vv->Assign(ind, frame[z.v3].ToVal(Z_TYPE)) )
		ERROR("value used but not set");
	}
	break;

case OP_ANY_VECTOR_ELEM_ASSIGN_VVC:
	{
	auto ind = frame[z.v2].AsCount();
	auto vv = frame[z.v1].AsVector();
	auto yt = vv->RawYieldTypes();
	if ( ind < vv->Size() && yt && (*yt)[ind] && ZVal::IsManagedType((*yt)[ind]) )
		{
		auto orig_elem = vv->RawVec()[ind];
		if ( ! vv->Assign(ind, z.c.ToVal(Z_TYPE)) )
			ERROR("value used but not set");
		if ( orig_elem )
			ZVal::DeleteManagedType(*orig_elem);
		}
	else if ( ! vv->Assign(ind, z.c.ToVal(Z_TYPE)) )
		ERROR("value used but not set");
	}
	break;

case OP_VECTOR_ELEM_ASSIGN_ANY_VVV:
	{
	EvalVectorElemAssign(frame[z.v1], frame[z.v2], auto any_v = frame[z.v3].AsAny();, vv->Assign(ind, {NewRef{}, any_v}))
	}
	break;

case OP_VECTOR_ELEM_ASSIGN_VVC:
	{
	VectorElemAssignPre(frame[z.v1], frame[z.v2])
	(void) copy_vec_elem(vv, ind, z.c, Z_TYPE);
	}
	break;

case OP_VECTOR_ELEM_ASSIGN_VVi:
	{
	auto vv = frame[z.v1].AsVector();
	if ( ! copy_vec_elem(vv, zeek_uint_t(z.v3), frame[z.v2], Z_TYPE) )
		ERROR("value used but not set");
	}
	break;

case OP_ANY_VECTOR_ELEM_ASSIGN_VVi:
	{
	auto vv = frame[z.v1].AsVector();
	if ( ! vv->Assign(z.v3, frame[z.v2].ToVal(Z_TYPE)) )
		ERROR("value used but not set");
	}
	break;

case OP_VECTOR_ELEM_ASSIGN_ANY_VVi:
	{
	auto vv = frame[z.v1].AsVector();
	auto any_v = frame[z.v2].AsAny();
	vv->Assign(z.v3, {NewRef{}, any_v});
	}
	break;

case OP_VECTOR_SLICE_ASSIGN_VV:
	{
	ValPtr vec = {NewRef{}, frame[z.v1].AsVector()};
	auto indices = Z_AUX->ToListVal(frame);
	ValPtr vals = {NewRef{}, frame[z.v2].AsVector()};
	bool iterators_invalidated;
	auto error = assign_to_index(std::move(vec), std::move(indices), std::move(vals), iterators_invalidated);
	if ( error )
		ERROR(error);
	if ( iterators_invalidated )
		WARN("possible loop/iterator invalidation");
	}
	break;

case OP_TABLE_ELEM_ASSIGN_VV:
	{
	auto indices = Z_AUX->ToListVal(frame);
	auto val = frame[z.v2].ToVal(Z_TYPE);
	bool iterators_invalidated = false;
	frame[z.v1].AsTable()->Assign(std::move(indices), std::move(val), true, &iterators_invalidated);
	if ( iterators_invalidated )
		WARN("possible loop/iterator invalidation");
	}
	break;

case OP_TABLE_ELEM_ASSIGN_VC:
	{
	auto indices = Z_AUX->ToListVal(frame);
	auto val = z.c.ToVal(Z_TYPE);
	bool iterators_invalidated = false;
	frame[z.v1].AsTable()->Assign(std::move(indices), std::move(val), true, &iterators_invalidated);
	if ( iterators_invalidated )
		WARN("possible loop/iterator invalidation");
	}
	break;

case OP_ADD_VCV_S:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	vector<const String*> strings;
		strings.push_back(z.c.AsString()->AsString());
		strings.push_back(frame[z.v2].AsString()->AsString());
		auto res = new StringVal(concatenate(strings));
		frame[z.v1].AsStringRef() = res;
	Unref(hold_lhs);
	}
	break;

case OP_ADD_VCV_D:
	{
	frame[z.v1].AsDoubleRef() = z.c.AsDouble() + frame[z.v2].AsDouble();
	}
	break;

case OP_ADD_VCV_U:
	{
	frame[z.v1].AsCountRef() = z.c.AsCount() + frame[z.v2].AsCount();
	}
	break;

case OP_ADD_VCV_I:
	{
	frame[z.v1].AsIntRef() = z.c.AsInt() + frame[z.v2].AsInt();
	}
	break;

case OP_ADD_VCVi_field_S:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v3).ManagedVal();
	vector<const String*> strings;
		strings.push_back(z.c.AsString()->AsString());
		strings.push_back(frame[z.v2].AsString()->AsString());
		auto res = new StringVal(concatenate(strings));
		DirectField(frame[z.v1].AsRecord(), z.v3).AsStringRef() = res;
	Unref(hold_lhs);
	}
	break;

case OP_ADD_VCVi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsDoubleRef() = z.c.AsDouble() + frame[z.v2].AsDouble();
	}
	break;

case OP_ADD_VCVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = z.c.AsCount() + frame[z.v2].AsCount();
	}
	break;

case OP_ADD_VCVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = z.c.AsInt() + frame[z.v2].AsInt();
	}
	break;

case OP_ADD_VVC_S:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	vector<const String*> strings;
		strings.push_back(frame[z.v2].AsString()->AsString());
		strings.push_back(z.c.AsString()->AsString());
		auto res = new StringVal(concatenate(strings));
		frame[z.v1].AsStringRef() = res;
	Unref(hold_lhs);
	}
	break;

case OP_ADD_VVC_D:
	{
	frame[z.v1].AsDoubleRef() = frame[z.v2].AsDouble() + z.c.AsDouble();
	}
	break;

case OP_ADD_VVC_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() + z.c.AsCount();
	}
	break;

case OP_ADD_VVC_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() + z.c.AsInt();
	}
	break;

case OP_ADD_VVCi_field_S:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v3).ManagedVal();
	vector<const String*> strings;
		strings.push_back(frame[z.v2].AsString()->AsString());
		strings.push_back(z.c.AsString()->AsString());
		auto res = new StringVal(concatenate(strings));
		DirectField(frame[z.v1].AsRecord(), z.v3).AsStringRef() = res;
	Unref(hold_lhs);
	}
	break;

case OP_ADD_VVCi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsDoubleRef() = frame[z.v2].AsDouble() + z.c.AsDouble();
	}
	break;

case OP_ADD_VVCi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = frame[z.v2].AsCount() + z.c.AsCount();
	}
	break;

case OP_ADD_VVCi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = frame[z.v2].AsInt() + z.c.AsInt();
	}
	break;

case OP_ADD_VVV_S:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	vector<const String*> strings;
		strings.push_back(frame[z.v2].AsString()->AsString());
		strings.push_back(frame[z.v3].AsString()->AsString());
		auto res = new StringVal(concatenate(strings));
		frame[z.v1].AsStringRef() = res;
	Unref(hold_lhs);
	}
	break;

case OP_ADD_VVV_D:
	{
	frame[z.v1].AsDoubleRef() = frame[z.v2].AsDouble() + frame[z.v3].AsDouble();
	}
	break;

case OP_ADD_VVV_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() + frame[z.v3].AsCount();
	}
	break;

case OP_ADD_VVV_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() + frame[z.v3].AsInt();
	}
	break;

case OP_ADD_VVVi_field_S:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v4).ManagedVal();
	vector<const String*> strings;
		strings.push_back(frame[z.v2].AsString()->AsString());
		strings.push_back(frame[z.v3].AsString()->AsString());
		auto res = new StringVal(concatenate(strings));
		DirectField(frame[z.v1].AsRecord(), z.v4).AsStringRef() = res;
	Unref(hold_lhs);
	}
	break;

case OP_ADD_VVVi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsDoubleRef() = frame[z.v2].AsDouble() + frame[z.v3].AsDouble();
	}
	break;

case OP_ADD_VVVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsCountRef() = frame[z.v2].AsCount() + frame[z.v3].AsCount();
	}
	break;

case OP_ADD_VVVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsIntRef() = frame[z.v2].AsInt() + frame[z.v3].AsInt();
	}
	break;

case OP_ADD_VVV_vec_S:
	{
	vec_exec(OP_ADD_VVV_vec_S, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_ADD_VVV_vec_D:
	{
	vec_exec(OP_ADD_VVV_vec_D, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_ADD_VVV_vec_U:
	{
	vec_exec(OP_ADD_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_ADD_VVV_vec_I:
	{
	vec_exec(OP_ADD_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_SUB_VCV_T:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	auto v = z.c.AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		frame[z.v2].AsTable()->RemoveFrom(s);
		frame[z.v1].AsTableRef() = s;
	Unref(hold_lhs);
	}
	break;

case OP_SUB_VCV_D:
	{
	frame[z.v1].AsDoubleRef() = z.c.AsDouble() - frame[z.v2].AsDouble();
	}
	break;

case OP_SUB_VCV_U:
	{
	frame[z.v1].AsCountRef() = z.c.AsCount() - frame[z.v2].AsCount();
	}
	break;

case OP_SUB_VCV_I:
	{
	frame[z.v1].AsIntRef() = z.c.AsInt() - frame[z.v2].AsInt();
	}
	break;

case OP_SUB_VCVi_field_T:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v3).ManagedVal();
	auto v = z.c.AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		frame[z.v2].AsTable()->RemoveFrom(s);
		DirectField(frame[z.v1].AsRecord(), z.v3).AsTableRef() = s;
	Unref(hold_lhs);
	}
	break;

case OP_SUB_VCVi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsDoubleRef() = z.c.AsDouble() - frame[z.v2].AsDouble();
	}
	break;

case OP_SUB_VCVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = z.c.AsCount() - frame[z.v2].AsCount();
	}
	break;

case OP_SUB_VCVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = z.c.AsInt() - frame[z.v2].AsInt();
	}
	break;

case OP_SUB_VVC_T:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	auto v = frame[z.v2].AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		z.c.AsTable()->RemoveFrom(s);
		frame[z.v1].AsTableRef() = s;
	Unref(hold_lhs);
	}
	break;

case OP_SUB_VVC_D:
	{
	frame[z.v1].AsDoubleRef() = frame[z.v2].AsDouble() - z.c.AsDouble();
	}
	break;

case OP_SUB_VVC_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() - z.c.AsCount();
	}
	break;

case OP_SUB_VVC_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() - z.c.AsInt();
	}
	break;

case OP_SUB_VVCi_field_T:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v3).ManagedVal();
	auto v = frame[z.v2].AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		z.c.AsTable()->RemoveFrom(s);
		DirectField(frame[z.v1].AsRecord(), z.v3).AsTableRef() = s;
	Unref(hold_lhs);
	}
	break;

case OP_SUB_VVCi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsDoubleRef() = frame[z.v2].AsDouble() - z.c.AsDouble();
	}
	break;

case OP_SUB_VVCi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = frame[z.v2].AsCount() - z.c.AsCount();
	}
	break;

case OP_SUB_VVCi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = frame[z.v2].AsInt() - z.c.AsInt();
	}
	break;

case OP_SUB_VVV_T:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	auto v = frame[z.v2].AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		frame[z.v3].AsTable()->RemoveFrom(s);
		frame[z.v1].AsTableRef() = s;
	Unref(hold_lhs);
	}
	break;

case OP_SUB_VVV_D:
	{
	frame[z.v1].AsDoubleRef() = frame[z.v2].AsDouble() - frame[z.v3].AsDouble();
	}
	break;

case OP_SUB_VVV_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() - frame[z.v3].AsCount();
	}
	break;

case OP_SUB_VVV_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() - frame[z.v3].AsInt();
	}
	break;

case OP_SUB_VVVi_field_T:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v4).ManagedVal();
	auto v = frame[z.v2].AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		frame[z.v3].AsTable()->RemoveFrom(s);
		DirectField(frame[z.v1].AsRecord(), z.v4).AsTableRef() = s;
	Unref(hold_lhs);
	}
	break;

case OP_SUB_VVVi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsDoubleRef() = frame[z.v2].AsDouble() - frame[z.v3].AsDouble();
	}
	break;

case OP_SUB_VVVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsCountRef() = frame[z.v2].AsCount() - frame[z.v3].AsCount();
	}
	break;

case OP_SUB_VVVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsIntRef() = frame[z.v2].AsInt() - frame[z.v3].AsInt();
	}
	break;

case OP_SUB_VVV_vec_T:
	{
	vec_exec(OP_SUB_VVV_vec_T, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_SUB_VVV_vec_D:
	{
	vec_exec(OP_SUB_VVV_vec_D, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_SUB_VVV_vec_U:
	{
	vec_exec(OP_SUB_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_SUB_VVV_vec_I:
	{
	vec_exec(OP_SUB_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_TIMES_VCV_D:
	{
	frame[z.v1].AsDoubleRef() = z.c.AsDouble() * frame[z.v2].AsDouble();
	}
	break;

case OP_TIMES_VCV_U:
	{
	frame[z.v1].AsCountRef() = z.c.AsCount() * frame[z.v2].AsCount();
	}
	break;

case OP_TIMES_VCV_I:
	{
	frame[z.v1].AsIntRef() = z.c.AsInt() * frame[z.v2].AsInt();
	}
	break;

case OP_TIMES_VCVi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsDoubleRef() = z.c.AsDouble() * frame[z.v2].AsDouble();
	}
	break;

case OP_TIMES_VCVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = z.c.AsCount() * frame[z.v2].AsCount();
	}
	break;

case OP_TIMES_VCVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = z.c.AsInt() * frame[z.v2].AsInt();
	}
	break;

case OP_TIMES_VVC_D:
	{
	frame[z.v1].AsDoubleRef() = frame[z.v2].AsDouble() * z.c.AsDouble();
	}
	break;

case OP_TIMES_VVC_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() * z.c.AsCount();
	}
	break;

case OP_TIMES_VVC_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() * z.c.AsInt();
	}
	break;

case OP_TIMES_VVCi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsDoubleRef() = frame[z.v2].AsDouble() * z.c.AsDouble();
	}
	break;

case OP_TIMES_VVCi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = frame[z.v2].AsCount() * z.c.AsCount();
	}
	break;

case OP_TIMES_VVCi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = frame[z.v2].AsInt() * z.c.AsInt();
	}
	break;

case OP_TIMES_VVV_D:
	{
	frame[z.v1].AsDoubleRef() = frame[z.v2].AsDouble() * frame[z.v3].AsDouble();
	}
	break;

case OP_TIMES_VVV_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() * frame[z.v3].AsCount();
	}
	break;

case OP_TIMES_VVV_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() * frame[z.v3].AsInt();
	}
	break;

case OP_TIMES_VVVi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsDoubleRef() = frame[z.v2].AsDouble() * frame[z.v3].AsDouble();
	}
	break;

case OP_TIMES_VVVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsCountRef() = frame[z.v2].AsCount() * frame[z.v3].AsCount();
	}
	break;

case OP_TIMES_VVVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsIntRef() = frame[z.v2].AsInt() * frame[z.v3].AsInt();
	}
	break;

case OP_TIMES_VVV_vec_D:
	{
	vec_exec(OP_TIMES_VVV_vec_D, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_TIMES_VVV_vec_U:
	{
	vec_exec(OP_TIMES_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_TIMES_VVV_vec_I:
	{
	vec_exec(OP_TIMES_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_DIVIDE_VCV_D:
	{
	if ( frame[z.v2].AsDouble() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	frame[z.v1].AsDoubleRef() = z.c.AsDouble() / frame[z.v2].AsDouble();

	}
	}
	break;

case OP_DIVIDE_VCV_U:
	{
	if ( frame[z.v2].AsCount() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	frame[z.v1].AsCountRef() = z.c.AsCount() / frame[z.v2].AsCount();

	}
	}
	break;

case OP_DIVIDE_VCV_I:
	{
	if ( frame[z.v2].AsInt() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	frame[z.v1].AsIntRef() = z.c.AsInt() / frame[z.v2].AsInt();

	}
	}
	break;

case OP_DIVIDE_VCVi_field_D:
	{
	if ( frame[z.v2].AsDouble() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsDoubleRef() = z.c.AsDouble() / frame[z.v2].AsDouble();

	}
	}
	break;

case OP_DIVIDE_VCVi_field_U:
	{
	if ( frame[z.v2].AsCount() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = z.c.AsCount() / frame[z.v2].AsCount();

	}
	}
	break;

case OP_DIVIDE_VCVi_field_I:
	{
	if ( frame[z.v2].AsInt() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = z.c.AsInt() / frame[z.v2].AsInt();

	}
	}
	break;

case OP_DIVIDE_VVC_D:
	{
	if ( z.c.AsDouble() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	frame[z.v1].AsDoubleRef() = frame[z.v2].AsDouble() / z.c.AsDouble();

	}
	}
	break;

case OP_DIVIDE_VVC_U:
	{
	if ( z.c.AsCount() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() / z.c.AsCount();

	}
	}
	break;

case OP_DIVIDE_VVC_I:
	{
	if ( z.c.AsInt() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() / z.c.AsInt();

	}
	}
	break;

case OP_DIVIDE_VVCi_field_D:
	{
	if ( z.c.AsDouble() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsDoubleRef() = frame[z.v2].AsDouble() / z.c.AsDouble();

	}
	}
	break;

case OP_DIVIDE_VVCi_field_U:
	{
	if ( z.c.AsCount() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = frame[z.v2].AsCount() / z.c.AsCount();

	}
	}
	break;

case OP_DIVIDE_VVCi_field_I:
	{
	if ( z.c.AsInt() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = frame[z.v2].AsInt() / z.c.AsInt();

	}
	}
	break;

case OP_DIVIDE_VVV_D:
	{
	if ( frame[z.v3].AsDouble() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	frame[z.v1].AsDoubleRef() = frame[z.v2].AsDouble() / frame[z.v3].AsDouble();

	}
	}
	break;

case OP_DIVIDE_VVV_U:
	{
	if ( frame[z.v3].AsCount() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() / frame[z.v3].AsCount();

	}
	}
	break;

case OP_DIVIDE_VVV_I:
	{
	if ( frame[z.v3].AsInt() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() / frame[z.v3].AsInt();

	}
	}
	break;

case OP_DIVIDE_VVVi_field_D:
	{
	if ( frame[z.v3].AsDouble() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsDoubleRef() = frame[z.v2].AsDouble() / frame[z.v3].AsDouble();

	}
	}
	break;

case OP_DIVIDE_VVVi_field_U:
	{
	if ( frame[z.v3].AsCount() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsCountRef() = frame[z.v2].AsCount() / frame[z.v3].AsCount();

	}
	}
	break;

case OP_DIVIDE_VVVi_field_I:
	{
	if ( frame[z.v3].AsInt() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsIntRef() = frame[z.v2].AsInt() / frame[z.v3].AsInt();

	}
	}
	break;

case OP_DIVIDE_VVV_vec_D:
	{
	vec_exec(OP_DIVIDE_VVV_vec_D, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_DIVIDE_VVV_vec_U:
	{
	vec_exec(OP_DIVIDE_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_DIVIDE_VVV_vec_I:
	{
	vec_exec(OP_DIVIDE_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_MASK_VCV_AU:
	{
	DoMask(frame[z.v1], z.c.AsAddr(), frame[z.v2].AsCount())
	}
	break;

case OP_MASK_VCV_AI:
	{
	DoMask(frame[z.v1], z.c.AsAddr(), static_cast<uint32_t>(frame[z.v2].AsInt()))
	}
	break;

case OP_MASK_VCVi_field_AU:
	{
	DoMask(DirectField(frame[z.v1].AsRecord(), z.v3), z.c.AsAddr(), frame[z.v2].AsCount())
	}
	break;

case OP_MASK_VCVi_field_AI:
	{
	DoMask(DirectField(frame[z.v1].AsRecord(), z.v3), z.c.AsAddr(), static_cast<uint32_t>(frame[z.v2].AsInt()))
	}
	break;

case OP_MASK_VVC_AU:
	{
	DoMask(frame[z.v1], frame[z.v2].AsAddr(), z.c.AsCount())
	}
	break;

case OP_MASK_VVC_AI:
	{
	DoMask(frame[z.v1], frame[z.v2].AsAddr(), static_cast<uint32_t>(z.c.AsInt()))
	}
	break;

case OP_MASK_VVCi_field_AU:
	{
	DoMask(DirectField(frame[z.v1].AsRecord(), z.v3), frame[z.v2].AsAddr(), z.c.AsCount())
	}
	break;

case OP_MASK_VVCi_field_AI:
	{
	DoMask(DirectField(frame[z.v1].AsRecord(), z.v3), frame[z.v2].AsAddr(), static_cast<uint32_t>(z.c.AsInt()))
	}
	break;

case OP_MASK_VVV_AU:
	{
	DoMask(frame[z.v1], frame[z.v2].AsAddr(), frame[z.v3].AsCount())
	}
	break;

case OP_MASK_VVV_AI:
	{
	DoMask(frame[z.v1], frame[z.v2].AsAddr(), static_cast<uint32_t>(frame[z.v3].AsInt()))
	}
	break;

case OP_MASK_VVVi_field_AU:
	{
	DoMask(DirectField(frame[z.v1].AsRecord(), z.v4), frame[z.v2].AsAddr(), frame[z.v3].AsCount())
	}
	break;

case OP_MASK_VVVi_field_AI:
	{
	DoMask(DirectField(frame[z.v1].AsRecord(), z.v4), frame[z.v2].AsAddr(), static_cast<uint32_t>(frame[z.v3].AsInt()))
	}
	break;

case OP_MOD_VCV_U:
	{
	if ( frame[z.v2].AsCount() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	frame[z.v1].AsCountRef() = z.c.AsCount() % frame[z.v2].AsCount();

	}
	}
	break;

case OP_MOD_VCV_I:
	{
	if ( frame[z.v2].AsInt() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	frame[z.v1].AsIntRef() = z.c.AsInt() % frame[z.v2].AsInt();

	}
	}
	break;

case OP_MOD_VCVi_field_U:
	{
	if ( frame[z.v2].AsCount() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = z.c.AsCount() % frame[z.v2].AsCount();

	}
	}
	break;

case OP_MOD_VCVi_field_I:
	{
	if ( frame[z.v2].AsInt() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = z.c.AsInt() % frame[z.v2].AsInt();

	}
	}
	break;

case OP_MOD_VVC_U:
	{
	if ( z.c.AsCount() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() % z.c.AsCount();

	}
	}
	break;

case OP_MOD_VVC_I:
	{
	if ( z.c.AsInt() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() % z.c.AsInt();

	}
	}
	break;

case OP_MOD_VVCi_field_U:
	{
	if ( z.c.AsCount() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = frame[z.v2].AsCount() % z.c.AsCount();

	}
	}
	break;

case OP_MOD_VVCi_field_I:
	{
	if ( z.c.AsInt() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = frame[z.v2].AsInt() % z.c.AsInt();

	}
	}
	break;

case OP_MOD_VVV_U:
	{
	if ( frame[z.v3].AsCount() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() % frame[z.v3].AsCount();

	}
	}
	break;

case OP_MOD_VVV_I:
	{
	if ( frame[z.v3].AsInt() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() % frame[z.v3].AsInt();

	}
	}
	break;

case OP_MOD_VVVi_field_U:
	{
	if ( frame[z.v3].AsCount() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsCountRef() = frame[z.v2].AsCount() % frame[z.v3].AsCount();

	}
	}
	break;

case OP_MOD_VVVi_field_I:
	{
	if ( frame[z.v3].AsInt() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsIntRef() = frame[z.v2].AsInt() % frame[z.v3].AsInt();

	}
	}
	break;

case OP_MOD_VVV_vec_U:
	{
	vec_exec(OP_MOD_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_MOD_VVV_vec_I:
	{
	vec_exec(OP_MOD_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_AND_AND_VCV_I:
	{
	frame[z.v1].AsIntRef() = zeek_int_t(z.c.AsInt() && frame[z.v2].AsInt());
	}
	break;

case OP_AND_AND_VCVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = zeek_int_t(z.c.AsInt() && frame[z.v2].AsInt());
	}
	break;

case OP_AND_AND_VVC_I:
	{
	frame[z.v1].AsIntRef() = zeek_int_t(frame[z.v2].AsInt() && z.c.AsInt());
	}
	break;

case OP_AND_AND_VVCi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = zeek_int_t(frame[z.v2].AsInt() && z.c.AsInt());
	}
	break;

case OP_AND_AND_VVV_I:
	{
	frame[z.v1].AsIntRef() = zeek_int_t(frame[z.v2].AsInt() && frame[z.v3].AsInt());
	}
	break;

case OP_AND_AND_VVVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsIntRef() = zeek_int_t(frame[z.v2].AsInt() && frame[z.v3].AsInt());
	}
	break;

case OP_AND_AND_VVV_vec_I:
	{
	vec_exec(OP_AND_AND_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_OR_OR_VCV_I:
	{
	frame[z.v1].AsIntRef() = zeek_int_t(z.c.AsInt() || frame[z.v2].AsInt());
	}
	break;

case OP_OR_OR_VCVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = zeek_int_t(z.c.AsInt() || frame[z.v2].AsInt());
	}
	break;

case OP_OR_OR_VVC_I:
	{
	frame[z.v1].AsIntRef() = zeek_int_t(frame[z.v2].AsInt() || z.c.AsInt());
	}
	break;

case OP_OR_OR_VVCi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = zeek_int_t(frame[z.v2].AsInt() || z.c.AsInt());
	}
	break;

case OP_OR_OR_VVV_I:
	{
	frame[z.v1].AsIntRef() = zeek_int_t(frame[z.v2].AsInt() || frame[z.v3].AsInt());
	}
	break;

case OP_OR_OR_VVVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsIntRef() = zeek_int_t(frame[z.v2].AsInt() || frame[z.v3].AsInt());
	}
	break;

case OP_OR_OR_VVV_vec_I:
	{
	vec_exec(OP_OR_OR_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_AND_VCV_T:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	frame[z.v1].AsTableRef() = z.c.AsTable()->Intersection(*frame[z.v2].AsTable()).release();
	Unref(hold_lhs);
	}
	break;

case OP_AND_VCV_P:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	frame[z.v1].AsPatternRef() = new PatternVal(RE_Matcher_conjunction(z.c.AsPattern()->AsPattern(), frame[z.v2].AsPattern()->AsPattern()));
	Unref(hold_lhs);
	}
	break;

case OP_AND_VCV_U:
	{
	frame[z.v1].AsCountRef() = z.c.AsCount() & frame[z.v2].AsCount();
	}
	break;

case OP_AND_VCVi_field_T:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v3).ManagedVal();
	DirectField(frame[z.v1].AsRecord(), z.v3).AsTableRef() = z.c.AsTable()->Intersection(*frame[z.v2].AsTable()).release();
	Unref(hold_lhs);
	}
	break;

case OP_AND_VCVi_field_P:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v3).ManagedVal();
	DirectField(frame[z.v1].AsRecord(), z.v3).AsPatternRef() = new PatternVal(RE_Matcher_conjunction(z.c.AsPattern()->AsPattern(), frame[z.v2].AsPattern()->AsPattern()));
	Unref(hold_lhs);
	}
	break;

case OP_AND_VCVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = z.c.AsCount() & frame[z.v2].AsCount();
	}
	break;

case OP_AND_VVC_T:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	frame[z.v1].AsTableRef() = frame[z.v2].AsTable()->Intersection(*z.c.AsTable()).release();
	Unref(hold_lhs);
	}
	break;

case OP_AND_VVC_P:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	frame[z.v1].AsPatternRef() = new PatternVal(RE_Matcher_conjunction(frame[z.v2].AsPattern()->AsPattern(), z.c.AsPattern()->AsPattern()));
	Unref(hold_lhs);
	}
	break;

case OP_AND_VVC_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() & z.c.AsCount();
	}
	break;

case OP_AND_VVCi_field_T:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v3).ManagedVal();
	DirectField(frame[z.v1].AsRecord(), z.v3).AsTableRef() = frame[z.v2].AsTable()->Intersection(*z.c.AsTable()).release();
	Unref(hold_lhs);
	}
	break;

case OP_AND_VVCi_field_P:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v3).ManagedVal();
	DirectField(frame[z.v1].AsRecord(), z.v3).AsPatternRef() = new PatternVal(RE_Matcher_conjunction(frame[z.v2].AsPattern()->AsPattern(), z.c.AsPattern()->AsPattern()));
	Unref(hold_lhs);
	}
	break;

case OP_AND_VVCi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = frame[z.v2].AsCount() & z.c.AsCount();
	}
	break;

case OP_AND_VVV_T:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	frame[z.v1].AsTableRef() = frame[z.v2].AsTable()->Intersection(*frame[z.v3].AsTable()).release();
	Unref(hold_lhs);
	}
	break;

case OP_AND_VVV_P:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	frame[z.v1].AsPatternRef() = new PatternVal(RE_Matcher_conjunction(frame[z.v2].AsPattern()->AsPattern(), frame[z.v3].AsPattern()->AsPattern()));
	Unref(hold_lhs);
	}
	break;

case OP_AND_VVV_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() & frame[z.v3].AsCount();
	}
	break;

case OP_AND_VVVi_field_T:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v4).ManagedVal();
	DirectField(frame[z.v1].AsRecord(), z.v4).AsTableRef() = frame[z.v2].AsTable()->Intersection(*frame[z.v3].AsTable()).release();
	Unref(hold_lhs);
	}
	break;

case OP_AND_VVVi_field_P:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v4).ManagedVal();
	DirectField(frame[z.v1].AsRecord(), z.v4).AsPatternRef() = new PatternVal(RE_Matcher_conjunction(frame[z.v2].AsPattern()->AsPattern(), frame[z.v3].AsPattern()->AsPattern()));
	Unref(hold_lhs);
	}
	break;

case OP_AND_VVVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsCountRef() = frame[z.v2].AsCount() & frame[z.v3].AsCount();
	}
	break;

case OP_AND_VVV_vec_T:
	{
	vec_exec(OP_AND_VVV_vec_T, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_AND_VVV_vec_P:
	{
	vec_exec(OP_AND_VVV_vec_P, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_AND_VVV_vec_U:
	{
	vec_exec(OP_AND_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_OR_VCV_T:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	auto v = z.c.AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		(void) frame[z.v2].AsTable()->AddTo(s, false, false);
		frame[z.v1].AsTableRef() = s;
	Unref(hold_lhs);
	}
	break;

case OP_OR_VCV_P:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	frame[z.v1].AsPatternRef() = new PatternVal(RE_Matcher_disjunction(z.c.AsPattern()->AsPattern(), frame[z.v2].AsPattern()->AsPattern()));
	Unref(hold_lhs);
	}
	break;

case OP_OR_VCV_U:
	{
	frame[z.v1].AsCountRef() = z.c.AsCount() | frame[z.v2].AsCount();
	}
	break;

case OP_OR_VCVi_field_T:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v3).ManagedVal();
	auto v = z.c.AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		(void) frame[z.v2].AsTable()->AddTo(s, false, false);
		DirectField(frame[z.v1].AsRecord(), z.v3).AsTableRef() = s;
	Unref(hold_lhs);
	}
	break;

case OP_OR_VCVi_field_P:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v3).ManagedVal();
	DirectField(frame[z.v1].AsRecord(), z.v3).AsPatternRef() = new PatternVal(RE_Matcher_disjunction(z.c.AsPattern()->AsPattern(), frame[z.v2].AsPattern()->AsPattern()));
	Unref(hold_lhs);
	}
	break;

case OP_OR_VCVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = z.c.AsCount() | frame[z.v2].AsCount();
	}
	break;

case OP_OR_VVC_T:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	auto v = frame[z.v2].AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		(void) z.c.AsTable()->AddTo(s, false, false);
		frame[z.v1].AsTableRef() = s;
	Unref(hold_lhs);
	}
	break;

case OP_OR_VVC_P:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	frame[z.v1].AsPatternRef() = new PatternVal(RE_Matcher_disjunction(frame[z.v2].AsPattern()->AsPattern(), z.c.AsPattern()->AsPattern()));
	Unref(hold_lhs);
	}
	break;

case OP_OR_VVC_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() | z.c.AsCount();
	}
	break;

case OP_OR_VVCi_field_T:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v3).ManagedVal();
	auto v = frame[z.v2].AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		(void) z.c.AsTable()->AddTo(s, false, false);
		DirectField(frame[z.v1].AsRecord(), z.v3).AsTableRef() = s;
	Unref(hold_lhs);
	}
	break;

case OP_OR_VVCi_field_P:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v3).ManagedVal();
	DirectField(frame[z.v1].AsRecord(), z.v3).AsPatternRef() = new PatternVal(RE_Matcher_disjunction(frame[z.v2].AsPattern()->AsPattern(), z.c.AsPattern()->AsPattern()));
	Unref(hold_lhs);
	}
	break;

case OP_OR_VVCi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = frame[z.v2].AsCount() | z.c.AsCount();
	}
	break;

case OP_OR_VVV_T:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	auto v = frame[z.v2].AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		(void) frame[z.v3].AsTable()->AddTo(s, false, false);
		frame[z.v1].AsTableRef() = s;
	Unref(hold_lhs);
	}
	break;

case OP_OR_VVV_P:
	{
	auto hold_lhs = frame[z.v1].ManagedVal();
	frame[z.v1].AsPatternRef() = new PatternVal(RE_Matcher_disjunction(frame[z.v2].AsPattern()->AsPattern(), frame[z.v3].AsPattern()->AsPattern()));
	Unref(hold_lhs);
	}
	break;

case OP_OR_VVV_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() | frame[z.v3].AsCount();
	}
	break;

case OP_OR_VVVi_field_T:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v4).ManagedVal();
	auto v = frame[z.v2].AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		(void) frame[z.v3].AsTable()->AddTo(s, false, false);
		DirectField(frame[z.v1].AsRecord(), z.v4).AsTableRef() = s;
	Unref(hold_lhs);
	}
	break;

case OP_OR_VVVi_field_P:
	{
	auto hold_lhs = DirectField(frame[z.v1].AsRecord(), z.v4).ManagedVal();
	DirectField(frame[z.v1].AsRecord(), z.v4).AsPatternRef() = new PatternVal(RE_Matcher_disjunction(frame[z.v2].AsPattern()->AsPattern(), frame[z.v3].AsPattern()->AsPattern()));
	Unref(hold_lhs);
	}
	break;

case OP_OR_VVVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsCountRef() = frame[z.v2].AsCount() | frame[z.v3].AsCount();
	}
	break;

case OP_OR_VVV_vec_T:
	{
	vec_exec(OP_OR_VVV_vec_T, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_OR_VVV_vec_P:
	{
	vec_exec(OP_OR_VVV_vec_P, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_OR_VVV_vec_U:
	{
	vec_exec(OP_OR_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_XOR_VCV_U:
	{
	frame[z.v1].AsCountRef() = z.c.AsCount() ^ frame[z.v2].AsCount();
	}
	break;

case OP_XOR_VCVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = z.c.AsCount() ^ frame[z.v2].AsCount();
	}
	break;

case OP_XOR_VVC_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() ^ z.c.AsCount();
	}
	break;

case OP_XOR_VVCi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = frame[z.v2].AsCount() ^ z.c.AsCount();
	}
	break;

case OP_XOR_VVV_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() ^ frame[z.v3].AsCount();
	}
	break;

case OP_XOR_VVVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsCountRef() = frame[z.v2].AsCount() ^ frame[z.v3].AsCount();
	}
	break;

case OP_XOR_VVV_vec_U:
	{
	vec_exec(OP_XOR_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LSHIFT_VCV_U:
	{
	frame[z.v1].AsCountRef() = z.c.AsCount() << frame[z.v2].AsCount();
	}
	break;

case OP_LSHIFT_VCV_I:
	{
	if ( z.c.AsInt() < 0 )
			ERROR("left shifting a negative number is undefined");
		frame[z.v1].AsIntRef() = z.c.AsInt() << frame[z.v2].AsInt();
	}
	break;

case OP_LSHIFT_VCVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = z.c.AsCount() << frame[z.v2].AsCount();
	}
	break;

case OP_LSHIFT_VCVi_field_I:
	{
	if ( z.c.AsInt() < 0 )
			ERROR("left shifting a negative number is undefined");
		DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = z.c.AsInt() << frame[z.v2].AsInt();
	}
	break;

case OP_LSHIFT_VVC_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() << z.c.AsCount();
	}
	break;

case OP_LSHIFT_VVC_I:
	{
	if ( frame[z.v2].AsInt() < 0 )
			ERROR("left shifting a negative number is undefined");
		frame[z.v1].AsIntRef() = frame[z.v2].AsInt() << z.c.AsInt();
	}
	break;

case OP_LSHIFT_VVCi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = frame[z.v2].AsCount() << z.c.AsCount();
	}
	break;

case OP_LSHIFT_VVCi_field_I:
	{
	if ( frame[z.v2].AsInt() < 0 )
			ERROR("left shifting a negative number is undefined");
		DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = frame[z.v2].AsInt() << z.c.AsInt();
	}
	break;

case OP_LSHIFT_VVV_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() << frame[z.v3].AsCount();
	}
	break;

case OP_LSHIFT_VVV_I:
	{
	if ( frame[z.v2].AsInt() < 0 )
			ERROR("left shifting a negative number is undefined");
		frame[z.v1].AsIntRef() = frame[z.v2].AsInt() << frame[z.v3].AsInt();
	}
	break;

case OP_LSHIFT_VVVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsCountRef() = frame[z.v2].AsCount() << frame[z.v3].AsCount();
	}
	break;

case OP_LSHIFT_VVVi_field_I:
	{
	if ( frame[z.v2].AsInt() < 0 )
			ERROR("left shifting a negative number is undefined");
		DirectField(frame[z.v1].AsRecord(), z.v4).AsIntRef() = frame[z.v2].AsInt() << frame[z.v3].AsInt();
	}
	break;

case OP_LSHIFT_VVV_vec_U:
	{
	vec_exec(OP_LSHIFT_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LSHIFT_VVV_vec_I:
	{
	vec_exec(OP_LSHIFT_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_RSHIFT_VCV_U:
	{
	frame[z.v1].AsCountRef() = z.c.AsCount() >> frame[z.v2].AsCount();
	}
	break;

case OP_RSHIFT_VCV_I:
	{
	frame[z.v1].AsIntRef() = z.c.AsInt() >> frame[z.v2].AsInt();
	}
	break;

case OP_RSHIFT_VCVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = z.c.AsCount() >> frame[z.v2].AsCount();
	}
	break;

case OP_RSHIFT_VCVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = z.c.AsInt() >> frame[z.v2].AsInt();
	}
	break;

case OP_RSHIFT_VVC_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() >> z.c.AsCount();
	}
	break;

case OP_RSHIFT_VVC_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() >> z.c.AsInt();
	}
	break;

case OP_RSHIFT_VVCi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = frame[z.v2].AsCount() >> z.c.AsCount();
	}
	break;

case OP_RSHIFT_VVCi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = frame[z.v2].AsInt() >> z.c.AsInt();
	}
	break;

case OP_RSHIFT_VVV_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount() >> frame[z.v3].AsCount();
	}
	break;

case OP_RSHIFT_VVV_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() >> frame[z.v3].AsInt();
	}
	break;

case OP_RSHIFT_VVVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsCountRef() = frame[z.v2].AsCount() >> frame[z.v3].AsCount();
	}
	break;

case OP_RSHIFT_VVVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v4).AsIntRef() = frame[z.v2].AsInt() >> frame[z.v3].AsInt();
	}
	break;

case OP_RSHIFT_VVV_vec_U:
	{
	vec_exec(OP_RSHIFT_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_RSHIFT_VVV_vec_I:
	{
	vec_exec(OP_RSHIFT_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_CALL0_X:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
(void) Z_AUX->func->Invoke(&args, f);
ZAM_PROFILE_POST_CALL
	}
	break;

case OP_CALL0_V_A:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_a:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_U:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsCount());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_D:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsDouble());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_f:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_F:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_I:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsInt());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_L:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_O:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_P:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_R:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_S:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_N:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_T:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_t:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL0_V_V:
	{
	std::vector<ValPtr> args;
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_V:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v1].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
(void) Z_AUX->func->Invoke(&args, f);
ZAM_PROFILE_POST_CALL
	}
	break;

case OP_CALL1_C:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
(void) Z_AUX->func->Invoke(&args, f);
ZAM_PROFILE_POST_CALL
	}
	break;

case OP_CALL1_VV_A:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_a:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_U:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsCount());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_D:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsDouble());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_f:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_F:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_I:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsInt());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_L:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_O:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_P:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_R:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_S:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_N:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_T:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_t:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VV_V:
	{
	std::vector<ValPtr> args;
args.push_back(frame[z.v2].ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_A:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_a:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_U:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsCount());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_D:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsDouble());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_f:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_F:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_I:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsInt());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_L:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_O:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_P:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_R:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_S:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_N:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_T:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_t:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL1_VC_V:
	{
	std::vector<ValPtr> args;
args.push_back(z.c.ToVal(Z_TYPE));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_X:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
(void) Z_AUX->func->Invoke(&args, f);
ZAM_PROFILE_POST_CALL
	}
	break;

case OP_CALL2_V_A:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_a:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_U:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsCount());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_D:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsDouble());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_f:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_F:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_I:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsInt());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_L:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_O:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_P:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_R:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_S:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_N:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_T:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_t:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL2_V_V:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_X:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
(void) Z_AUX->func->Invoke(&args, f);
ZAM_PROFILE_POST_CALL
	}
	break;

case OP_CALL3_V_A:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_a:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_U:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsCount());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_D:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsDouble());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_f:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_F:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_I:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsInt());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_L:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_O:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_P:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_R:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_S:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_N:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_T:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_t:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL3_V_V:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_X:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
(void) Z_AUX->func->Invoke(&args, f);
ZAM_PROFILE_POST_CALL
	}
	break;

case OP_CALL4_V_A:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_a:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_U:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsCount());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_D:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsDouble());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_f:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_F:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_I:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsInt());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_L:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_O:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_P:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_R:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_S:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_N:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_T:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_t:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL4_V_V:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_X:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
(void) Z_AUX->func->Invoke(&args, f);
ZAM_PROFILE_POST_CALL
	}
	break;

case OP_CALL5_V_A:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_a:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_U:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsCount());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_D:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsDouble());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_f:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_F:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_I:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsInt());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_L:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_O:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_P:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_R:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_S:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_N:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_T:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_t:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALL5_V_V:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
args.push_back(aux->ToVal(frame, 0));
args.push_back(aux->ToVal(frame, 1));
args.push_back(aux->ToVal(frame, 2));
args.push_back(aux->ToVal(frame, 3));
args.push_back(aux->ToVal(frame, 4));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_X:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
(void) Z_AUX->func->Invoke(&args, f);
ZAM_PROFILE_POST_CALL
	}
	break;

case OP_CALLN_V_A:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_a:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_U:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsCount());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_D:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsDouble());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_f:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_F:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_I:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsInt());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_L:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_O:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_P:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_R:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_S:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_N:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_T:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_t:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_CALLN_V_V:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = Z_AUX->func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_X:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
(void) func->Invoke(&args, f);
ZAM_PROFILE_POST_CALL
	}
	break;

case OP_INDCALLN_V_A:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_a:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_U:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsCount());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_D:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsDouble());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_f:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_F:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_I:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsInt());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_L:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_O:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_P:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_R:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_S:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_N:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_T:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_t:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_INDCALLN_V_V:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func_v = aux->id_val->GetVal();
auto func = func_v ? func_v->AsFunc() : nullptr;
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_V:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v1].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
(void) func->Invoke(&args, f);
ZAM_PROFILE_POST_CALL
	}
	break;

case OP_LOCAL_INDCALLN_VV_A:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_a:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_U:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsCount());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_D:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsDouble());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_f:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_F:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_I:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
frame[z.v1] = ZVal(v->AsInt());
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_L:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_O:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_P:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_R:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_S:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_N:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_T:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_t:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_LOCAL_INDCALLN_VV_V:
	{
	std::vector<ValPtr> args;
auto aux = Z_AUX;
auto func = frame[z.v2].AsFunc();
if ( ! func )
	{
	ZAM_run_time_error(Z_LOC, "value used but not set");
	break;
	}
auto n = aux->n;
args.reserve(n);
for ( auto i = 0; i < n; ++i )
	args.push_back(aux->ToVal(frame, i));
f->SetOnlyCall(Z_AUX->call_expr.get());
ZAM_PROFILE_PRE_CALL
auto v = func->Invoke(&args, f);
if ( ! v ) { ZAM_error = true; break; }
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	ZAM_PROFILE_POST_CALL
	break;
	}
case OP_WHENCALLN_V:
	{
	WhenCall(frame[z.v1], Z_AUX_FUNC)
	}
	break;

case OP_WHENINDCALLN_VV:
	{
	WhenCall(frame[z.v1], frame[z.v2].AsFunc())
	}
	break;

case OP_WHEN_ID_INDCALLN_V:
	{
	WhenCall(frame[z.v1], Z_AUX_ID->GetVal()->AsFunc())
	}
	break;

case OP_COERCE_UI_VV:
	{
	auto v = frame[z.v2].AsInt();
	if ( v < 0 )
		ERROR("underflow converting int to count");
	else
		frame[z.v1].AsCountRef() = zeek_uint_t(v);
	}
	break;

case OP_COERCE_UD_VV:
	{
	auto v = frame[z.v2].AsDouble();
	if ( v < 0.0 )
		ERROR("underflow converting double to count");
	else if ( v > static_cast<double>(UINT64_MAX) )
		ERROR("overflow converting double to count");
	else
		frame[z.v1].AsCountRef() = zeek_uint_t(v);
	}
	break;

case OP_COERCE_IU_VV:
	{
	auto v = frame[z.v2].AsCount();
	if ( v > INT64_MAX )
		ERROR("overflow converting count to int");
	else
		frame[z.v1].AsIntRef() = zeek_int_t(v);
	}
	break;

case OP_COERCE_ID_VV:
	{
	auto v = frame[z.v2].AsDouble();
	if ( v < static_cast<double>(INT64_MIN) )
		ERROR("underflow converting double to int");
	else if ( v > static_cast<double>(INT64_MAX) )
		ERROR("overflow converting double to int");
	else
		frame[z.v1].AsIntRef() = zeek_int_t(v);
	}
	break;

case OP_COERCE_DI_VV:
	{
	frame[z.v1].AsDoubleRef() = double(frame[z.v2].AsInt());
	}
	break;

case OP_COERCE_DU_VV:
	{
	frame[z.v1].AsDoubleRef() = double(frame[z.v2].AsCount());
	}
	break;

case OP_COERCE_UI_VEC_VV:
	{
	EvalCoerceVec(frame[z.v1], frame[z.v2], vec_coerce_UI)
	}
	break;

case OP_COERCE_UD_VEC_VV:
	{
	EvalCoerceVec(frame[z.v1], frame[z.v2], vec_coerce_UD)
	}
	break;

case OP_COERCE_IU_VEC_VV:
	{
	EvalCoerceVec(frame[z.v1], frame[z.v2], vec_coerce_IU)
	}
	break;

case OP_COERCE_ID_VEC_VV:
	{
	EvalCoerceVec(frame[z.v1], frame[z.v2], vec_coerce_ID)
	}
	break;

case OP_COERCE_DI_VEC_VV:
	{
	EvalCoerceVec(frame[z.v1], frame[z.v2], vec_coerce_DI)
	}
	break;

case OP_COERCE_DU_VEC_VV:
	{
	EvalCoerceVec(frame[z.v1], frame[z.v2], vec_coerce_DU)
	}
	break;

case OP_RECORD_COERCE_VV:
	{
	auto rt = cast_intrusive<RecordType>(Z_TYPE);
	auto v = frame[z.v2].AsRecord();
	auto to_r = coerce_to_record(std::move(rt), v, Z_AUX_MAP);
	Unref(frame[z.v1].AsRecordRef());
	frame[z.v1].AsRecordRef() = to_r.release();
	}
	break;

case OP_TABLE_COERCE_VV:
	{
	auto tv = frame[z.v2].AsTable();
	if ( tv->Size() > 0 )
		ERROR("coercion of non-empty table/set");
	else
		{
		auto tt = cast_intrusive<TableType>(Z_TYPE);
		AttributesPtr attrs = tv->GetAttrs();
		auto t = make_intrusive<TableVal>(tt, attrs);
		Unref(frame[z.v1].AsTableRef());
		frame[z.v1].AsTableRef() = t.release();
		}
	}
	break;

case OP_VECTOR_COERCE_VV:
	{
	if ( frame[z.v2].AsVector()->Size() > 0 )
		ERROR("coercion of non-empty vector");
	else
		{
		auto vv = new VectorVal(cast_intrusive<VectorType>(Z_TYPE));
		Unref(frame[z.v1].AsVectorRef());
		frame[z.v1].AsVectorRef() = vv;
		}
	}
	break;

case OP_TO_ANY_COERCE_VC:
	{
	auto orig_lhs = frame[z.v1]; /* hold in case frame[z.v1] = z.c */
	frame[z.v1] = ZVal(z.c.ToVal(Z_TYPE), ZAM::any_base_type);
	ZVal::DeleteManagedType(orig_lhs);
	}
	break;

case OP_TO_ANY_COERCE_VV:
	{
	auto orig_lhs = frame[z.v1]; /* hold in case frame[z.v1] = frame[z.v2] */
	frame[z.v1] = ZVal(frame[z.v2].ToVal(Z_TYPE), ZAM::any_base_type);
	ZVal::DeleteManagedType(orig_lhs);
	}
	break;

case OP_FROM_ANY_COERCE_VV:
	{
	auto v = frame[z.v2].AsAny();
	AssignTarget(frame[z.v1], ZVal({NewRef{}, v}, Z_TYPE))
	}
	break;

case OP_FROM_ANY_VEC_COERCE_VV:
	{
	auto vv = frame[z.v2].AsVector();
	if ( ! vv->Concretize(Z_TYPE->Yield()) )
		ERROR("incompatible vector-of-any");
	else
		{
		zeek::Ref(vv);
		AssignTarget(frame[z.v1], ZVal(vv))
		}
	}
	break;

case OP_CONSTRUCT_TABLE_Vi:
	{
	ConstructTableOrSetPre(z.v2)
	for ( auto i = 0; i < n; ++i )
		{
		auto indices = aux->ToIndices(frame, i, ind_width);
		auto v = aux->ToVal(frame, i + ind_width);
		new_t->Assign(indices, v);
		i += ind_width;
		}
	ConstructTableOrSetPost(frame[z.v1])
	}
	break;

case OP_SET_TABLE_DEFAULT_LAMBDA_VV:
	{
	auto tbl = frame[z.v1].AsTable();
	auto lambda = frame[z.v2].ToVal(Z_TYPE);
	tbl->InitDefaultVal(std::move(lambda));
	}
	break;

case OP_CONSTRUCT_SET_Vi:
	{
	ConstructTableOrSetPre(z.v2)
	for ( auto i = 0; i < n; i += ind_width )
		{
		auto indices = aux->ToIndices(frame, i, ind_width);
		new_t->Assign(indices, nullptr);
		}
	ConstructTableOrSetPost(frame[z.v1])
	}
	break;

case OP_CONSTRUCT_DIRECT_RECORD_V:
	{
	auto init_vals = Z_AUX->ToZValVec(frame);
	ConstructRecordPost(frame[z.v1].AsRecordRef())
	}
	break;

case OP_CONSTRUCT_KNOWN_RECORD_V:
	{
	auto init_vals = Z_AUX->ToZValVecWithMap(frame);
	ConstructRecordPost(frame[z.v1].AsRecordRef())
	}
	break;

case OP_CONSTRUCT_KNOWN_RECORD_FROM_VV:
	{
	auto init_vals = Z_AUX->ToZValVecWithMap(frame);
	AssignFromRec(frame[z.v2].AsRecord())
	ConstructRecordPost(frame[z.v1].AsRecordRef())
	}
	break;

case OP_CONSTRUCT_KNOWN_RECORD_WITH_NT_Vi:
	{
	auto init_vals = Z_AUX->ToZValVecWithMap(frame);
	DoNetworkTimeInit(z.v2)
	ConstructRecordPost(frame[z.v1].AsRecordRef())
	}
	break;

case OP_CONSTRUCT_KNOWN_RECORD_WITH_NT_FROM_VVi:
	{
	auto init_vals = Z_AUX->ToZValVecWithMap(frame);
	DoNetworkTimeInit(z.v3)
	AssignFromRec(frame[z.v2].AsRecord())
	ConstructRecordPost(frame[z.v1].AsRecordRef())
	}
	break;

case OP_CONSTRUCT_KNOWN_RECORD_WITH_INITS_V:
	{
	GenInits()
	ConstructRecordPost(frame[z.v1].AsRecordRef())
	}
	break;

case OP_CONSTRUCT_KNOWN_RECORD_WITH_INITS_FROM_VV:
	{
	GenInits()
	AssignFromRec(frame[z.v2].AsRecord())
	ConstructRecordPost(frame[z.v1].AsRecordRef())
	}
	break;

case OP_CONSTRUCT_KNOWN_RECORD_WITH_INITS_AND_NT_Vi:
	{
	GenInits()
	DoNetworkTimeInit(z.v2)
	ConstructRecordPost(frame[z.v1].AsRecordRef())
	}
	break;

case OP_CONSTRUCT_KNOWN_RECORD_WITH_INITS_AND_NT_FROM_VVi:
	{
	GenInits()
	DoNetworkTimeInit(z.v3)
	AssignFromRec(frame[z.v2].AsRecord())
	ConstructRecordPost(frame[z.v1].AsRecordRef())
	}
	break;

case OP_REC_ASSIGN_FIELDS_VV:
	{
	SetUpRecFieldOps(map)
	for ( size_t i = 0U; i < n; ++i )
		frame[z.v1].AsRecord()->RawOptField(lhs_map[i]) = FieldValWithCheck(frame[z.v2].AsRecord(), rhs_map[i]);
	}
	break;

case OP_REC_ASSIGN_FIELDS_MANAGED_VV:
	{
	SetUpRecFieldOps(map)
	DoManagedRecAssign(frame[z.v1].AsRecord(), frame[z.v2].AsRecord())
	}
	break;

case OP_REC_ASSIGN_FIELDS_ALL_MANAGED_VV:
	{
	SetUpRecFieldOps(map)
	for ( size_t i = 0U; i < n; ++i )
		{
		auto& lhs_i = frame[z.v1].AsRecord()->RawOptField(lhs_map[i]);
		auto rhs_i = FieldValWithCheck(frame[z.v2].AsRecord(), rhs_map[i]);
		zeek::Ref(rhs_i.ManagedVal());
		lhs_i = rhs_i;
		}
	}
	break;

case OP_REC_ADD_INT_FIELDS_VV:
	{
	SetUpRecFieldOps(map)
	for ( size_t i = 0U; i < n; ++i )
		frame[z.v1].AsRecord()->RawField(lhs_map[i]).AsIntRef() =
			FieldValWithCheck(frame[z.v1].AsRecord(), lhs_map[i]).AsInt() +
			FieldValWithCheck(frame[z.v2].AsRecord(), rhs_map[i]).AsInt();
	}
	break;

case OP_REC_ADD_DOUBLE_FIELDS_VV:
	{
	SetUpRecFieldOps(map)
	for ( size_t i = 0U; i < n; ++i )
		frame[z.v1].AsRecord()->RawField(lhs_map[i]).AsDoubleRef() =
			FieldValWithCheck(frame[z.v1].AsRecord(), lhs_map[i]).AsDouble() +
			FieldValWithCheck(frame[z.v2].AsRecord(), rhs_map[i]).AsDouble();
	}
	break;

case OP_REC_ADD_FIELDS_VV:
	{
	SetUpRecFieldOps(map)
	auto& types = Z_AUX->types;
	for ( size_t i = 0U; i < n; ++i )
		{
		// We make this call to ensure that the field exists.
		(void) FieldValWithCheck(frame[z.v1].AsRecord(), lhs_map[i]);
		auto& lhs_i = frame[z.v1].AsRecord()->RawField(lhs_map[i]);
		auto rhs_i = FieldValWithCheck(frame[z.v2].AsRecord(), rhs_map[i]);
		auto tag = types[i]->Tag();
		if ( tag == TYPE_INT )
			lhs_i.AsIntRef() += rhs_i.AsInt();
		else if ( tag == TYPE_COUNT )
			lhs_i.AsCountRef() += rhs_i.AsCount();
		else
			lhs_i.AsDoubleRef() += rhs_i.AsDouble();
		}
	}
	break;

case OP_CONCRETIZE_VECTOR_FIELDS_V:
	{
	auto rt = cast_intrusive<RecordType>(Z_TYPE);
	auto r = frame[z.v1].AsRecord();
	auto aux = Z_AUX;
	auto n = aux->n;
	for ( auto i = 0; i < n; ++i )
		{
		auto ind = RecordField(r, aux->elems[i].IntVal());
		auto v_i = r->GetField(ind);
		ASSERT(v_i);
		if ( v_i->GetType<VectorType>()->IsUnspecifiedVector() )
			{
			const auto& t_i = rt->GetFieldType(ind);
			v_i->AsVectorVal()->Concretize(t_i->Yield());
			}
		}
	}
	break;

case OP_CONSTRUCT_VECTOR_V:
	{
	auto new_vv = new VectorVal(cast_intrusive<VectorType>(Z_TYPE));
	auto aux = Z_AUX;
	auto n = aux->n;
	for ( auto i = 0; i < n; ++i )
		new_vv->Assign(i, aux->ToVal(frame, i));
	auto& vv = frame[z.v1].AsVectorRef();
	Unref(vv);
	vv = new_vv;
	}
	break;

case OP_INDEXVECBOOLSELECT_VVV:
	{
	if ( frame[z.v2].AsVector()->Size() != frame[z.v3].AsVector()->Size() )
		ERROR("size mismatch, boolean index and vector");
	else
		{
		auto vt = cast_intrusive<VectorType>(Z_TYPE);
		auto v2 = frame[z.v2].AsVector();
		auto v3 = frame[z.v3].AsVector();
		auto v = vector_bool_select(std::move(vt), v2, v3);
		Unref(frame[z.v1].AsVectorRef());
		frame[z.v1].AsVectorRef() = v.release();
		}
	}
	break;

case OP_INDEXVECBOOLSELECT_VCV:
	{
	if ( z.c.AsVector()->Size() != frame[z.v2].AsVector()->Size() )
		ERROR("size mismatch, boolean index and vector");
	else
		{
		auto vt = cast_intrusive<VectorType>(Z_TYPE);
		auto v2 = z.c.AsVector();
		auto v3 = frame[z.v2].AsVector();
		auto v = vector_bool_select(std::move(vt), v2, v3);
		Unref(frame[z.v1].AsVectorRef());
		frame[z.v1].AsVectorRef() = v.release();
		}
	}
	break;

case OP_INDEXVECINTSELECT_VVV:
	{
	auto vt = cast_intrusive<VectorType>(Z_TYPE);
	auto v2 = frame[z.v2].AsVector();
	auto v3 = frame[z.v3].AsVector();
	auto v = vector_int_select(std::move(vt), v2, v3);
	Unref(frame[z.v1].AsVectorRef());
	frame[z.v1].AsVectorRef() = v.release();
	}
	break;

case OP_INDEXVECINTSELECT_VCV:
	{
	auto vt = cast_intrusive<VectorType>(Z_TYPE);
	auto v2 = z.c.AsVector();
	auto v3 = frame[z.v2].AsVector();
	auto v = vector_int_select(std::move(vt), v2, v3);
	Unref(frame[z.v1].AsVectorRef());
	frame[z.v1].AsVectorRef() = v.release();
	}
	break;

case OP_INDEX_VEC_VVV:
	{
	EvalIndexVec(frame[z.v1], frame[z.v2].AsVector(), frame[z.v3].AsInt())
	}
	break;

case OP_INDEX_VECC_VVi:
	{
	EvalIndexVec(frame[z.v1], frame[z.v2].AsVector(), z.v3)
	}
	break;

case OP_INDEX_ANY_VEC_VVV:
	{
	EvalIndexAnyVec(frame[z.v1], frame[z.v2].AsVector(), frame[z.v3].AsInt())
	}
	break;

case OP_INDEX_ANY_VECC_VVi:
	{
	EvalIndexAnyVec(frame[z.v1], frame[z.v2].AsVector(), z.v3)
	}
	break;

case OP_WHEN_INDEX_VEC_VVV:
	{
	EvalIndexAnyVec(frame[z.v1], frame[z.v2].AsVector(), frame[z.v3].AsInt())
	WhenIndexResCheck(frame[z.v1].AsVector())
	}
	break;

case OP_WHEN_INDEX_VECC_VVi:
	{
	EvalIndexAnyVec(frame[z.v1], frame[z.v2].AsVector(), z.v3)
	WhenIndexResCheck(frame[z.v1].AsVector())
	}
	break;

case OP_INDEX_VEC_SLICE_VV:
	{
	auto indices = Z_AUX->ToListVal(frame);
	EvalVecSlice(frame[z.v1].AsVectorRef(), frame[z.v2].AsVector())
	}
	break;

case OP_WHEN_INDEX_VEC_SLICE_VV:
	{
	auto indices = Z_AUX->ToListVal(frame);
	EvalVecSlice(frame[z.v1].AsVectorRef(), frame[z.v2].AsVector())
	WhenIndexResCheck(frame[z.v1].AsVectorRef())
	}
	break;

case OP_TABLE_INDEX_VV:
	{
	auto indices = Z_AUX->ToListVal(frame);
	EvalTableIndex(frame[z.v2], indices)
	if ( v )
		AssignTarget(frame[z.v1], BuildVal(v, Z_TYPE))
	}
	break;

case OP_TABLE_PATSTR_INDEX_VVV:
	{
	auto vec = ZVal(frame[z.v2].AsTable()->LookupPattern({NewRef{}, frame[z.v3].AsString()}));
	ZVal::DeleteManagedType(frame[z.v1]);
	frame[z.v1] = vec;
	}
	break;

case OP_TABLE_PATSTR_INDEX_VVC:
	{
	auto vec = ZVal(frame[z.v2].AsTable()->LookupPattern({NewRef{}, z.c.AsString()}));
	ZVal::DeleteManagedType(frame[z.v1]);
	frame[z.v1] = vec;
	}
	break;

case OP_WHEN_TABLE_INDEX_VV:
	{
	auto indices = Z_AUX->ToListVal(frame);
	EvalTableIndex(frame[z.v2], indices)
	if ( v )
		{
		if ( IndexExprWhen::evaluating > 0 )
			IndexExprWhen::results.emplace_back(v);
		AssignTarget(frame[z.v1], BuildVal(v, Z_TYPE))
		}
	}
	break;

case OP_WHEN_PATSTR_INDEX_VV:
	{
	auto indices = Z_AUX->ToListVal(frame);
	auto arg0 = indices->Idx(0);
	auto v = frame[z.v2].AsTable()->LookupPattern({NewRef{}, arg0->AsStringVal()});
	if ( IndexExprWhen::evaluating > 0 )
		IndexExprWhen::results.emplace_back(v);
	AssignTarget(frame[z.v1], BuildVal(v, Z_TYPE))
	}
	break;

case OP_TABLE_INDEX1_VVV_A:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVV_a:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVV_U:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
frame[z.v1] = ZVal(v->AsCount());
	break;
	}
case OP_TABLE_INDEX1_VVV_D:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
frame[z.v1] = ZVal(v->AsDouble());
	break;
	}
case OP_TABLE_INDEX1_VVV_f:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVV_F:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVV_I:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
frame[z.v1] = ZVal(v->AsInt());
	break;
	}
case OP_TABLE_INDEX1_VVV_L:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVV_O:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVV_P:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVV_R:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVV_S:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVV_N:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVV_T:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVV_t:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVV_V:
	{
	EvalTableIndex(frame[z.v2], frame[z.v3].ToVal(Z_TYPE))
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVC_A:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVC_a:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVC_U:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
frame[z.v1] = ZVal(v->AsCount());
	break;
	}
case OP_TABLE_INDEX1_VVC_D:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
frame[z.v1] = ZVal(v->AsDouble());
	break;
	}
case OP_TABLE_INDEX1_VVC_f:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVC_F:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVC_I:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
frame[z.v1] = ZVal(v->AsInt());
	break;
	}
case OP_TABLE_INDEX1_VVC_L:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVC_O:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVC_P:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVC_R:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVC_S:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVC_N:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVC_T:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVC_t:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_TABLE_INDEX1_VVC_V:
	{
	EvalTableIndex(frame[z.v2], z.c.ToVal(Z_TYPE))
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_INDEX_STRING_VVV:
	{
	EvalIndexString(frame[z.v1].AsStringRef(), frame[z.v2].AsString(), frame[z.v3].AsInt())
	}
	break;

case OP_INDEX_STRINGC_VVi:
	{
	EvalIndexString(frame[z.v1].AsStringRef(), frame[z.v2].AsString(), z.v3)
	}
	break;

case OP_INDEX_STRING_SLICE_VV:
	{
	auto str = frame[z.v2].AsString()->AsString();
	auto indices = Z_AUX->ToListVal(frame);
	auto slice = index_string(str, indices.get());
	Unref(frame[z.v1].AsStringRef());
	frame[z.v1].AsStringRef() = new StringVal(slice->ToStdString());
	}
	break;

case OP_ANYINDEX_VVi:
	{
	auto lv = frame[z.v2].AsAny()->AsListVal();
	if ( z.v3 < 0 || z.v3 >= lv->Length() )
		reporter->InternalError("bad \"any\" element index");
	ValPtr elem = lv->Idx(z.v3);
	if ( CheckAnyType(elem->GetType(), Z_TYPE, Z_LOC) )
		AssignTarget(frame[z.v1], BuildVal(elem, Z_TYPE))
	else
		ZAM_error = true;
	}
	break;

case OP_ASSIGN_ANY_VV:
	{
	auto v = frame[z.v2].ToVal(Z_TYPE);
	frame[z.v1].AsAnyRef() = v.release();
	}
	break;

case OP_ASSIGN_ANY_VC:
	{
	auto v = z.c.ToVal(Z_TYPE);
	frame[z.v1].AsAnyRef() = v.release();
	}
	break;

case OP_ASSIGN_CONST_VC:
	{
	AssignTarget(frame[z.v1], BuildVal(z.c.ToVal(Z_TYPE), Z_TYPE))
	}
	break;

case OP_LOAD_VAL_Vi_A:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_VAL_Vi_a:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_VAL_Vi_U:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
frame[z.v1] = ZVal(v->AsCount());
	break;
	}
case OP_LOAD_VAL_Vi_D:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
frame[z.v1] = ZVal(v->AsDouble());
	break;
	}
case OP_LOAD_VAL_Vi_f:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_VAL_Vi_F:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_VAL_Vi_I:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
frame[z.v1] = ZVal(v->AsInt());
	break;
	}
case OP_LOAD_VAL_Vi_L:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_VAL_Vi_O:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_VAL_Vi_P:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_VAL_Vi_R:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_VAL_Vi_S:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_VAL_Vi_N:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_VAL_Vi_T:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_VAL_Vi_t:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_VAL_Vi_V:
	{
	auto& v = Z_FRAME->GetElement(z.v2);
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_Vg_A:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
auto rhs = v->AsAddrVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_Vg_a:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
auto rhs = v.get();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_Vg_U:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
frame[z.v1] = ZVal(v->AsCount());
	break;
	}
case OP_LOAD_GLOBAL_Vg_D:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
frame[z.v1] = ZVal(v->AsDouble());
	break;
	}
case OP_LOAD_GLOBAL_Vg_f:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
auto rhs = v->AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_Vg_F:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
auto rhs = v->AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_Vg_I:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
frame[z.v1] = ZVal(v->AsInt());
	break;
	}
case OP_LOAD_GLOBAL_Vg_L:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
auto rhs = v->AsListVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_Vg_O:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
auto rhs = v->AsOpaqueVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_Vg_P:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
auto rhs = v->AsPatternVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_Vg_R:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
auto rhs = v->AsRecordVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_Vg_S:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
auto rhs = v->AsStringVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_Vg_N:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
auto rhs = v->AsSubNetVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_Vg_T:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
auto rhs = v->AsTableVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_Vg_t:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
auto rhs = v->AsTypeVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_Vg_V:
	{
	auto& v = GlobalID(z.v2)->GetVal();
	if ( ! v )
		ERROR2("value used but not set", Z_AUX_ID.get());
auto rhs = v->AsVectorVal();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_LOAD_GLOBAL_TYPE_Vg:
	{
	auto& v = frame[z.v1].AsTypeRef();
	Unref(v);
	auto& t = GlobalID(z.v2)->GetType();
	v = new TypeVal(t, true);
	}
	break;

case OP_LOAD_CAPTURE_Vi:
	{
	frame[z.v1] = static_cast<const ScriptFunc*>(Z_FRAME->GetFunction())->GetCapturesVec()[z.v2];
	}
	break;

case OP_LOAD_MANAGED_CAPTURE_Vi:
	{
	auto& lhs = frame[z.v1];
	auto& rhs = static_cast<const ScriptFunc*>(Z_FRAME->GetFunction())->GetCapturesVec()[z.v2];
	zeek::Ref(rhs.ManagedVal());
	ZVal::DeleteManagedType(lhs);
	lhs = rhs;
	}
	break;

case OP_STORE_GLOBAL_g:
	{
	GlobalID(z.v1)->SetVal(GlobalVal(z.v1).ToVal(Z_TYPE));
	}
	break;

case OP_STORE_CAPTURE_Vi:
	{
	static_cast<const ScriptFunc*>(Z_FRAME->GetFunction())->GetCapturesVec()[z.v2] = frame[z.v1];
	}
	break;

case OP_STORE_MANAGED_CAPTURE_Vi:
	{
	auto& lhs = static_cast<const ScriptFunc*>(Z_FRAME->GetFunction())->GetCapturesVec()[z.v2];
	auto& rhs = frame[z.v1];
	zeek::Ref(rhs.ManagedVal());
	ZVal::DeleteManagedType(lhs);
	lhs = rhs;
	}
	break;

case OP_COPY_TO_VC:
	{
	AssignTarget(frame[z.v1], CopyVal(z.c))
	}
	break;

case OP_GOTO_b:
	{
	Branch(z.v1)
	}
	break;

case OP_HOOK_BREAK_X:
	{
	flow = FLOW_BREAK;
	pc = end_pc;
	DO_ZAM_PROFILE
	continue;
	}
	break;

case OP_LAMBDA_Vi:
	{
	auto& primary_func = Z_AUX_PRIMARY_FUNC;
	auto& body = primary_func->GetBodies()[0].stmts;
	ASSERT(body->Tag() == STMT_ZAM);
	auto lamb = make_intrusive<ScriptFunc>(Z_AUX_ID);
	lamb->AddBody(body, z.v2);
	lamb->SetName(Z_AUX_LAMBDA_NAME.c_str());
	auto& aux = Z_AUX;
	if ( aux->n > 0 )
		{
		auto captures = std::make_unique<std::vector<ZVal>>();
		for ( auto i = 0; i < aux->n; ++i )
			{
			auto slot = aux->elems[i].Slot();
			if ( slot >= 0 )
				{
				auto& cp = frame[slot];
				if ( aux->elems[i].IsManaged() )
					zeek::Ref(cp.ManagedVal());
				captures->push_back(cp);
				}
			else
				/* Used for when-locals. */
				captures->push_back(ZVal());
			}
		lamb->CreateCaptures(std::move(captures));
		}
	Unref(frame[z.v1].AsFuncRef());
	frame[z.v1].AsFuncRef() = lamb.release();
	}
	break;

case OP_INIT_TABLE_LOOP_Vf:
	{
	TableIter(z.v2).BeginLoop({NewRef{}, frame[z.v1].AsTable()}, frame, Z_AUX);
	}
	break;

case OP_NEXT_TABLE_ITER_fb:
	{
	NextTableIterPre(TableIter(z.v1), Branch(z.v2))
	TableIter(z.v1).NextIter();
	}
	break;

case OP_NEXT_TABLE_ITER_NO_VARS_fb:
	{
	NextTableIterPre(TableIter(z.v1), Branch(z.v2))
	TableIter(z.v1).IterFinished();
	}
	break;

case OP_NEXT_TABLE_ITER_VAL_VAR_Vfb:
	{
	NextTableIterPre(TableIter(z.v2), Branch(z.v3))
	AssignTarget(frame[z.v1], TableIter(z.v2).IterValue());
	TableIter(z.v2).NextIter();
	}
	break;

case OP_NEXT_TABLE_ITER_VAL_VAR_NO_VARS_Vfb:
	{
	NextTableIterPre(TableIter(z.v2), Branch(z.v3))
	AssignTarget(frame[z.v1], TableIter(z.v2).IterValue());
	TableIter(z.v2).IterFinished();
	}
	break;

case OP_INIT_VECTOR_LOOP_Vs:
	{
	auto& vv = frame[z.v1].AsVector()->RawVec();
	StepIter(z.v2).InitLoop(&vv);
	}
	break;

case OP_NEXT_VECTOR_ITER_Vsb:
	{
	NextVectorIterCore(StepIter(z.v2), Branch(z.v3))
	frame[z.v1].AsCountRef() = StepIter(z.v2).iter;
	StepIter(z.v2).IterFinished();
	}
	break;

case OP_NEXT_VECTOR_BLANK_ITER_sb:
	{
	NextVectorIterCore(StepIter(z.v1), Branch(z.v2))
	StepIter(z.v1).IterFinished();
	}
	break;

case OP_NEXT_VECTOR_ITER_VAL_VAR_VVsb:
	{
	NextVectorIterCore(StepIter(z.v3), Branch(z.v4))
	frame[z.v1].AsCountRef() = StepIter(z.v3).iter;
	if ( Z_IS_MANAGED )
		{
		ZVal::DeleteManagedType(frame[z.v2]);
		frame[z.v2] = BuildVal(vv[StepIter(z.v3).iter]->ToVal(Z_TYPE), Z_TYPE);
		}
	else
		frame[z.v2] = *vv[StepIter(z.v3).iter];
	StepIter(z.v3).IterFinished();
	}
	break;

case OP_NEXT_VECTOR_BLANK_ITER_VAL_VAR_Vsb:
	{
	NextVectorIterCore(StepIter(z.v2), Branch(z.v3))
	if ( Z_IS_MANAGED )
		{
		ZVal::DeleteManagedType(frame[z.v1]);
		frame[z.v1] = BuildVal(vv[StepIter(z.v2).iter]->ToVal(Z_TYPE), Z_TYPE);
		}
	else
		frame[z.v1] = *vv[StepIter(z.v2).iter];
	StepIter(z.v2).IterFinished();
	}
	break;

case OP_INIT_STRING_LOOP_Vs:
	{
	StepIter(z.v2).InitLoop(frame[z.v1].AsString()->AsString());
	}
	break;

case OP_INIT_STRING_LOOP_Cs:
	{
	StepIter(z.v1).InitLoop(z.c.AsString()->AsString());
	}
	break;

case OP_NEXT_STRING_ITER_Vsb:
	{
	if ( StepIter(z.v2).IsDoneIterating() )
		Branch(z.v3)
	auto bytes = reinterpret_cast<const char*>(StepIter(z.v2).s->Bytes()) + StepIter(z.v2).iter;
	auto sv = new StringVal(1, bytes);
	Unref(frame[z.v1].AsStringRef());
	frame[z.v1].AsStringRef() = sv;
	StepIter(z.v2).IterFinished();
	}
	break;

case OP_NEXT_STRING_BLANK_ITER_sb:
	{
	if ( StepIter(z.v1).IsDoneIterating() )
		Branch(z.v2)
	StepIter(z.v1).IterFinished();
	}
	break;

case OP_END_TABLE_LOOP_f:
	{
	TableIter(z.v1).Clear();
	}
	break;

case OP_FIELD_RCi_A:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsAddr();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RCi_a:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsAny();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RCi_U:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
frame[z.v1] = ZVal(v.AsCount());
	break;
	}
case OP_FIELD_RCi_D:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
frame[z.v1] = ZVal(v.AsDouble());
	break;
	}
case OP_FIELD_RCi_f:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RCi_F:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RCi_I:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
frame[z.v1] = ZVal(v.AsInt());
	break;
	}
case OP_FIELD_RCi_L:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsList();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RCi_O:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsOpaque();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RCi_P:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsPattern();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RCi_R:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsRecord();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RCi_S:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsString();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RCi_N:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsSubNet();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RCi_T:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsTable();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RCi_t:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsType();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RCi_V:
	{
	auto r = z.c.AsRecord();
	auto& rv = DirectOptField(r, z.v2);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v2);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsVector();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RVi_A:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsAddr();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RVi_a:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsAny();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RVi_U:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
frame[z.v1] = ZVal(v.AsCount());
	break;
	}
case OP_FIELD_RVi_D:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
frame[z.v1] = ZVal(v.AsDouble());
	break;
	}
case OP_FIELD_RVi_f:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsFile();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RVi_F:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsFunc();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RVi_I:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
frame[z.v1] = ZVal(v.AsInt());
	break;
	}
case OP_FIELD_RVi_L:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsList();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RVi_O:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsOpaque();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RVi_P:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsPattern();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RVi_R:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsRecord();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RVi_S:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsString();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RVi_N:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsSubNet();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RVi_T:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsTable();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RVi_t:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsType();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_FIELD_RVi_V:
	{
	auto r = frame[z.v2].AsRecord();
	auto& rv = DirectOptField(r, z.v3);
	ZVal v;
	if ( ! rv )
		{
		auto field = RecordField(r, z.v3);
		auto def = r->GetType<RecordType>()->FieldDefault(field);
		if ( def )
			v = ZVal(def, Z_TYPE);
		else
			ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
		}
	else
		v = *rv;
auto rhs = v.AsVector();
zeek::Ref(rhs);
Unref(frame[z.v1].ManagedVal());
frame[z.v1] = ZVal(rhs);
	break;
	}
case OP_HAS_FIELD_VRi:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsRecord()->HasField(RecordField(frame[z.v2].AsRecord(), z.v3));
	}
	break;

case OP_HAS_FIELD_VRii:
	{
	DirectOptField(frame[z.v1].AsRecordRef(), z.v3) = ZVal(zeek_int_t(frame[z.v2].AsRecord()->HasField(RecordField(frame[z.v2].AsRecord(), z.v4))));
	}
	break;

case OP_HAS_FIELD_VVi:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsRecord()->HasField(RecordField(frame[z.v2].AsRecord(), z.v3));
	}
	break;

case OP_HAS_FIELD_COND_Vib:
	{
	if ( ! (frame[z.v1].AsRecord()->HasField(RecordField(frame[z.v1].AsRecord(), z.v2))) )
		Branch(z.v3)
	}
	break;

case OP_NOT_HAS_FIELD_COND_Vib:
	{
	if ( (frame[z.v1].AsRecord()->HasField(RecordField(frame[z.v1].AsRecord(), z.v2))) )
		Branch(z.v3)
	}
	break;

case OP_TABLE_HAS_ELEMENTS_VV:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsTable()->Size() > 0;
	}
	break;

case OP_TABLE_HAS_ELEMENTS_COND_Vb:
	{
	if ( ! (frame[z.v1].AsTable()->Size() > 0) )
		Branch(z.v2)
	}
	break;

case OP_NOT_TABLE_HAS_ELEMENTS_COND_Vb:
	{
	if ( (frame[z.v1].AsTable()->Size() > 0) )
		Branch(z.v2)
	}
	break;

case OP_VECTOR_HAS_ELEMENTS_VV:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsVector()->Size() > 0;
	}
	break;

case OP_VECTOR_HAS_ELEMENTS_COND_Vb:
	{
	if ( ! (frame[z.v1].AsVector()->Size() > 0) )
		Branch(z.v2)
	}
	break;

case OP_NOT_VECTOR_HAS_ELEMENTS_COND_Vb:
	{
	if ( (frame[z.v1].AsVector()->Size() > 0) )
		Branch(z.v2)
	}
	break;

case OP_P_IN_S_VVV:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsPattern()->MatchAnywhere(frame[z.v3].AsString()->AsString()) != 0;
	}
	break;

case OP_P_IN_S_VCV:
	{
	frame[z.v1].AsIntRef() = z.c.AsPattern()->MatchAnywhere(frame[z.v2].AsString()->AsString()) != 0;
	}
	break;

case OP_P_IN_S_VVC:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsPattern()->MatchAnywhere(z.c.AsString()->AsString()) != 0;
	}
	break;

case OP_STR_IN_PAT_TBL_VVV:
	{
	frame[z.v1].AsIntRef() = frame[z.v3].AsTable()->MatchPattern({NewRef{}, frame[z.v2].AsString()});
	}
	break;

case OP_STR_IN_PAT_TBL_VCV:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsTable()->MatchPattern({NewRef{}, z.c.AsString()});
	}
	break;

case OP_S_IN_S_VVV:
	{
	auto sc = reinterpret_cast<const unsigned char*>(frame[z.v2].AsString()->CheckString());
	auto cmp = util::strstr_n(frame[z.v3].AsString()->Len(), frame[z.v3].AsString()->Bytes(), frame[z.v2].AsString()->Len(), sc);
	frame[z.v1].AsIntRef() = cmp != -1;
	}
	break;

case OP_S_IN_S_VCV:
	{
	auto sc = reinterpret_cast<const unsigned char*>(z.c.AsString()->CheckString());
	auto cmp = util::strstr_n(frame[z.v2].AsString()->Len(), frame[z.v2].AsString()->Bytes(), z.c.AsString()->Len(), sc);
	frame[z.v1].AsIntRef() = cmp != -1;
	}
	break;

case OP_S_IN_S_VVC:
	{
	auto sc = reinterpret_cast<const unsigned char*>(frame[z.v2].AsString()->CheckString());
	auto cmp = util::strstr_n(z.c.AsString()->Len(), z.c.AsString()->Bytes(), frame[z.v2].AsString()->Len(), sc);
	frame[z.v1].AsIntRef() = cmp != -1;
	}
	break;

case OP_A_IN_S_VVV:
	{
	frame[z.v1].AsIntRef() = frame[z.v3].AsSubNet()->Contains(frame[z.v2].AsAddr()->AsAddr());
	}
	break;

case OP_A_IN_S_VCV:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsSubNet()->Contains(z.c.AsAddr()->AsAddr());
	}
	break;

case OP_A_IN_S_VVC:
	{
	frame[z.v1].AsIntRef() = z.c.AsSubNet()->Contains(frame[z.v2].AsAddr()->AsAddr());
	}
	break;

case OP_VAL_IS_IN_TABLE_VVV:
	{
	frame[z.v1].AsIntRef() = frame[z.v3].AsTable()->Find(frame[z.v2].ToVal(Z_TYPE)) != nullptr;
	}
	break;

case OP_VAL_IS_IN_TABLE_COND_VVb:
	{
	if ( ! (frame[z.v2].AsTable()->Find(frame[z.v1].ToVal(Z_TYPE)) != nullptr) )
		Branch(z.v3)
	}
	break;

case OP_NOT_VAL_IS_IN_TABLE_COND_VVb:
	{
	if ( (frame[z.v2].AsTable()->Find(frame[z.v1].ToVal(Z_TYPE)) != nullptr) )
		Branch(z.v3)
	}
	break;

case OP_VAL2_IS_IN_TABLE_VVVV:
	{
	EvalVal2InTablePre(frame[z.v2],frame[z.v3],frame[z.v4])
	EvalVal2InTableAssignCore(frame[z.v1], frame[z.v4])
	}
	break;

case OP_VAL2_IS_IN_TABLE_COND_VVVb:
	{
	EvalVal2InTablePre(frame[z.v1],frame[z.v2],frame[z.v3])
	EvalVal2InTableCond(frame[z.v3], INDEX_LIST, Branch(z.v4), !)
	}
	break;

case OP_VAL2_IS_NOT_IN_TABLE_COND_VVVb:
	{
	EvalVal2InTablePre(frame[z.v1],frame[z.v2],frame[z.v3])
	EvalVal2InTableCond(frame[z.v3], INDEX_LIST, Branch(z.v4),)
	}
	break;

case OP_VAL2_IS_IN_TABLE_VVVC:
	{
	EvalVal2InTableCore(frame[z.v2].ToVal(Z_TYPE2), z.c.ToVal(Z_TYPE))
	EvalVal2InTableAssignCore(frame[z.v1], frame[z.v3])
	}
	break;

case OP_VAL2_IS_IN_TABLE_VVCV:
	{
	EvalVal2InTableCore(z.c.ToVal(Z_TYPE), frame[z.v2].ToVal(Z_TYPE2))
	EvalVal2InTableAssignCore(frame[z.v1], frame[z.v3])
	}
	break;

case OP_VAL2_IS_IN_TABLE_COND_VVbC:
	{
	EvalVal2InTableCore(frame[z.v1].ToVal(Z_TYPE2), z.c.ToVal(Z_TYPE))
	EvalVal2InTableCond(frame[z.v2], INDEX_LIST, Branch(z.v3), !)
	}
	break;

case OP_VAL2_IS_IN_TABLE_COND_VVCb:
	{
	EvalVal2InTableCore(z.c.ToVal(Z_TYPE), frame[z.v1].ToVal(Z_TYPE2))
	EvalVal2InTableCond(frame[z.v2], INDEX_LIST, Branch(z.v3), !)
	}
	break;

case OP_VAL2_IS_NOT_IN_TABLE_COND_VVbC:
	{
	EvalVal2InTableCore(frame[z.v1].ToVal(Z_TYPE2), z.c.ToVal(Z_TYPE))
	EvalVal2InTableCond(frame[z.v2], INDEX_LIST, Branch(z.v3), )
	}
	break;

case OP_VAL2_IS_NOT_IN_TABLE_COND_VVCb:
	{
	EvalVal2InTableCore(z.c.ToVal(Z_TYPE), frame[z.v1].ToVal(Z_TYPE2))
	EvalVal2InTableCond(frame[z.v2], INDEX_LIST, Branch(z.v3), )
	}
	break;

case OP_CONST_IS_IN_TABLE_VVC:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsTable()->Find(z.c.ToVal(Z_TYPE)) != nullptr;
	}
	break;

case OP_CONST_IS_IN_TABLE_COND_VCb:
	{
	if ( ! (frame[z.v1].AsTable()->Find(z.c.ToVal(Z_TYPE)) != nullptr) )
		Branch(z.v2)
	}
	break;

case OP_NOT_CONST_IS_IN_TABLE_COND_VCb:
	{
	if ( (frame[z.v1].AsTable()->Find(z.c.ToVal(Z_TYPE)) != nullptr) )
		Branch(z.v2)
	}
	break;

case OP_LIST_IS_IN_TABLE_VV:
	{
	auto indices = Z_AUX->ToListVal(frame);
	frame[z.v1].AsIntRef() = frame[z.v2].AsTable()->Find(std::move(indices)) != nullptr;
	}
	break;

case OP_LIST_IS_IN_TABLE_VC:
	{
	auto indices = Z_AUX->ToListVal(frame);
	frame[z.v1].AsIntRef() = z.c.AsTable()->Find(std::move(indices)) != nullptr;
	}
	break;

case OP_VAL_IS_IN_VECTOR_VVV:
	{
	auto vec = frame[z.v3].AsVector();
	auto ind = frame[z.v2].AsInt();
	frame[z.v1].AsIntRef() = vec->Has(ind);
	}
	break;

case OP_CONST_IS_IN_VECTOR_VCV:
	{
	auto vec = frame[z.v2].AsVector();
	auto ind = z.c.AsInt();
	frame[z.v1].AsIntRef() = vec->Has(ind);
	}
	break;

case OP_COND_VVVV:
	{
	AssignTarget(frame[z.v1], frame[z.v2].AsInt() ? CopyVal(frame[z.v3]) : CopyVal(frame[z.v4]))
	}
	break;

case OP_COND_VVVC:
	{
	AssignTarget(frame[z.v1], frame[z.v2].AsInt() ? CopyVal(frame[z.v3]) : CopyVal(z.c))
	}
	break;

case OP_COND_VVCV:
	{
	AssignTarget(frame[z.v1], frame[z.v2].AsInt() ? CopyVal(z.c) : CopyVal(frame[z.v3]))
	}
	break;

case OP_BOOL_VEC_COND_VVVV:
	{
	auto& vsel = frame[z.v2].AsVector()->RawVec();
	auto& v1 = frame[z.v3].AsVector()->RawVec();
	auto& v2 = frame[z.v4].AsVector()->RawVec();
	auto n = v1.size();
	vector<std::optional<ZVal>> res(n);
	for ( auto i = 0U; i < n; ++i )
		if ( vsel[i] )
			res[i] = vsel[i]->AsInt() ? v1[i] : v2[i];
	auto& full_res = frame[z.v1].AsVectorRef();
	Unref(full_res);
	full_res = new VectorVal(cast_intrusive<VectorType>(Z_TYPE), &res);
	}
	break;

case OP_CONDC1_VVC:
	{
	if ( frame[z.v2].AsInt() )
		AssignTarget(frame[z.v1], CopyVal(z.c))
	}
	break;

case OP_CONDC2_VVC:
	{
	if ( ! frame[z.v2].AsInt() )
		AssignTarget(frame[z.v1], CopyVal(z.c))
	}
	break;

case OP_LT_VCV_A:
	{
	frame[z.v1].AsIntRef() = z.c.AsAddr()->AsAddr() < frame[z.v2].AsAddr()->AsAddr();
	}
	break;

case OP_LT_VCV_T:
	{
	frame[z.v1].AsIntRef() = z.c.AsTable()->IsSubsetOf(*frame[z.v2].AsTable()) && z.c.AsTable()->Size() < frame[z.v2].AsTable()->Size();
	}
	break;

case OP_LT_VCV_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(z.c.AsString()->AsString(), frame[z.v2].AsString()->AsString()) < 0;
	}
	break;

case OP_LT_VCV_D:
	{
	frame[z.v1].AsIntRef() = z.c.AsDouble() < frame[z.v2].AsDouble();
	}
	break;

case OP_LT_VCV_U:
	{
	frame[z.v1].AsIntRef() = z.c.AsCount() < frame[z.v2].AsCount();
	}
	break;

case OP_LT_VCV_I:
	{
	frame[z.v1].AsIntRef() = z.c.AsInt() < frame[z.v2].AsInt();
	}
	break;

case OP_LT_CVb_cond_A:
	{
	if ( ! (z.c.AsAddr()->AsAddr() < frame[z.v1].AsAddr()->AsAddr()) ) Branch(z.v2)
	}
	break;

case OP_LT_CVb_cond_T:
	{
	if ( ! (z.c.AsTable()->IsSubsetOf(*frame[z.v1].AsTable()) && z.c.AsTable()->Size() < frame[z.v1].AsTable()->Size()) ) Branch(z.v2)
	}
	break;

case OP_LT_CVb_cond_S:
	{
	if ( ! (Bstr_cmp(z.c.AsString()->AsString(), frame[z.v1].AsString()->AsString()) < 0) ) Branch(z.v2)
	}
	break;

case OP_LT_CVb_cond_D:
	{
	if ( ! (z.c.AsDouble() < frame[z.v1].AsDouble()) ) Branch(z.v2)
	}
	break;

case OP_LT_CVb_cond_U:
	{
	if ( ! (z.c.AsCount() < frame[z.v1].AsCount()) ) Branch(z.v2)
	}
	break;

case OP_LT_CVb_cond_I:
	{
	if ( ! (z.c.AsInt() < frame[z.v1].AsInt()) ) Branch(z.v2)
	}
	break;

case OP_LT_VVC_A:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsAddr()->AsAddr() < z.c.AsAddr()->AsAddr();
	}
	break;

case OP_LT_VVC_T:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsTable()->IsSubsetOf(*z.c.AsTable()) && frame[z.v2].AsTable()->Size() < z.c.AsTable()->Size();
	}
	break;

case OP_LT_VVC_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(frame[z.v2].AsString()->AsString(), z.c.AsString()->AsString()) < 0;
	}
	break;

case OP_LT_VVC_D:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsDouble() < z.c.AsDouble();
	}
	break;

case OP_LT_VVC_U:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsCount() < z.c.AsCount();
	}
	break;

case OP_LT_VVC_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() < z.c.AsInt();
	}
	break;

case OP_LT_VCb_cond_A:
	{
	if ( ! (frame[z.v1].AsAddr()->AsAddr() < z.c.AsAddr()->AsAddr()) ) Branch(z.v2)
	}
	break;

case OP_LT_VCb_cond_T:
	{
	if ( ! (frame[z.v1].AsTable()->IsSubsetOf(*z.c.AsTable()) && frame[z.v1].AsTable()->Size() < z.c.AsTable()->Size()) ) Branch(z.v2)
	}
	break;

case OP_LT_VCb_cond_S:
	{
	if ( ! (Bstr_cmp(frame[z.v1].AsString()->AsString(), z.c.AsString()->AsString()) < 0) ) Branch(z.v2)
	}
	break;

case OP_LT_VCb_cond_D:
	{
	if ( ! (frame[z.v1].AsDouble() < z.c.AsDouble()) ) Branch(z.v2)
	}
	break;

case OP_LT_VCb_cond_U:
	{
	if ( ! (frame[z.v1].AsCount() < z.c.AsCount()) ) Branch(z.v2)
	}
	break;

case OP_LT_VCb_cond_I:
	{
	if ( ! (frame[z.v1].AsInt() < z.c.AsInt()) ) Branch(z.v2)
	}
	break;

case OP_LT_VVV_A:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsAddr()->AsAddr() < frame[z.v3].AsAddr()->AsAddr();
	}
	break;

case OP_LT_VVV_T:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsTable()->IsSubsetOf(*frame[z.v3].AsTable()) && frame[z.v2].AsTable()->Size() < frame[z.v3].AsTable()->Size();
	}
	break;

case OP_LT_VVV_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(frame[z.v2].AsString()->AsString(), frame[z.v3].AsString()->AsString()) < 0;
	}
	break;

case OP_LT_VVV_D:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsDouble() < frame[z.v3].AsDouble();
	}
	break;

case OP_LT_VVV_U:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsCount() < frame[z.v3].AsCount();
	}
	break;

case OP_LT_VVV_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() < frame[z.v3].AsInt();
	}
	break;

case OP_LT_VVV_vec_A:
	{
	vec_exec(OP_LT_VVV_vec_A, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LT_VVV_vec_T:
	{
	vec_exec(OP_LT_VVV_vec_T, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LT_VVV_vec_S:
	{
	vec_exec(OP_LT_VVV_vec_S, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LT_VVV_vec_D:
	{
	vec_exec(OP_LT_VVV_vec_D, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LT_VVV_vec_U:
	{
	vec_exec(OP_LT_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LT_VVV_vec_I:
	{
	vec_exec(OP_LT_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LT_VVb_cond_A:
	{
	if ( ! (frame[z.v1].AsAddr()->AsAddr() < frame[z.v2].AsAddr()->AsAddr()) ) Branch(z.v3)
	}
	break;

case OP_LT_VVb_cond_T:
	{
	if ( ! (frame[z.v1].AsTable()->IsSubsetOf(*frame[z.v2].AsTable()) && frame[z.v1].AsTable()->Size() < frame[z.v2].AsTable()->Size()) ) Branch(z.v3)
	}
	break;

case OP_LT_VVb_cond_S:
	{
	if ( ! (Bstr_cmp(frame[z.v1].AsString()->AsString(), frame[z.v2].AsString()->AsString()) < 0) ) Branch(z.v3)
	}
	break;

case OP_LT_VVb_cond_D:
	{
	if ( ! (frame[z.v1].AsDouble() < frame[z.v2].AsDouble()) ) Branch(z.v3)
	}
	break;

case OP_LT_VVb_cond_U:
	{
	if ( ! (frame[z.v1].AsCount() < frame[z.v2].AsCount()) ) Branch(z.v3)
	}
	break;

case OP_LT_VVb_cond_I:
	{
	if ( ! (frame[z.v1].AsInt() < frame[z.v2].AsInt()) ) Branch(z.v3)
	}
	break;

case OP_LE_VCV_A:
	{
	frame[z.v1].AsIntRef() = z.c.AsAddr()->AsAddr() < frame[z.v2].AsAddr()->AsAddr() || z.c.AsAddr()->AsAddr() == frame[z.v2].AsAddr()->AsAddr();
	}
	break;

case OP_LE_VCV_T:
	{
	frame[z.v1].AsIntRef() = z.c.AsTable()->IsSubsetOf(*frame[z.v2].AsTable());
	}
	break;

case OP_LE_VCV_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(z.c.AsString()->AsString(), frame[z.v2].AsString()->AsString()) <= 0;
	}
	break;

case OP_LE_VCV_D:
	{
	frame[z.v1].AsIntRef() = z.c.AsDouble() <= frame[z.v2].AsDouble();
	}
	break;

case OP_LE_VCV_U:
	{
	frame[z.v1].AsIntRef() = z.c.AsCount() <= frame[z.v2].AsCount();
	}
	break;

case OP_LE_VCV_I:
	{
	frame[z.v1].AsIntRef() = z.c.AsInt() <= frame[z.v2].AsInt();
	}
	break;

case OP_LE_CVb_cond_A:
	{
	if ( ! (z.c.AsAddr()->AsAddr() < frame[z.v1].AsAddr()->AsAddr() || z.c.AsAddr()->AsAddr() == frame[z.v1].AsAddr()->AsAddr()) ) Branch(z.v2)
	}
	break;

case OP_LE_CVb_cond_T:
	{
	if ( ! (z.c.AsTable()->IsSubsetOf(*frame[z.v1].AsTable())) ) Branch(z.v2)
	}
	break;

case OP_LE_CVb_cond_S:
	{
	if ( ! (Bstr_cmp(z.c.AsString()->AsString(), frame[z.v1].AsString()->AsString()) <= 0) ) Branch(z.v2)
	}
	break;

case OP_LE_CVb_cond_D:
	{
	if ( ! (z.c.AsDouble() <= frame[z.v1].AsDouble()) ) Branch(z.v2)
	}
	break;

case OP_LE_CVb_cond_U:
	{
	if ( ! (z.c.AsCount() <= frame[z.v1].AsCount()) ) Branch(z.v2)
	}
	break;

case OP_LE_CVb_cond_I:
	{
	if ( ! (z.c.AsInt() <= frame[z.v1].AsInt()) ) Branch(z.v2)
	}
	break;

case OP_LE_VVC_A:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsAddr()->AsAddr() < z.c.AsAddr()->AsAddr() || frame[z.v2].AsAddr()->AsAddr() == z.c.AsAddr()->AsAddr();
	}
	break;

case OP_LE_VVC_T:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsTable()->IsSubsetOf(*z.c.AsTable());
	}
	break;

case OP_LE_VVC_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(frame[z.v2].AsString()->AsString(), z.c.AsString()->AsString()) <= 0;
	}
	break;

case OP_LE_VVC_D:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsDouble() <= z.c.AsDouble();
	}
	break;

case OP_LE_VVC_U:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsCount() <= z.c.AsCount();
	}
	break;

case OP_LE_VVC_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() <= z.c.AsInt();
	}
	break;

case OP_LE_VCb_cond_A:
	{
	if ( ! (frame[z.v1].AsAddr()->AsAddr() < z.c.AsAddr()->AsAddr() || frame[z.v1].AsAddr()->AsAddr() == z.c.AsAddr()->AsAddr()) ) Branch(z.v2)
	}
	break;

case OP_LE_VCb_cond_T:
	{
	if ( ! (frame[z.v1].AsTable()->IsSubsetOf(*z.c.AsTable())) ) Branch(z.v2)
	}
	break;

case OP_LE_VCb_cond_S:
	{
	if ( ! (Bstr_cmp(frame[z.v1].AsString()->AsString(), z.c.AsString()->AsString()) <= 0) ) Branch(z.v2)
	}
	break;

case OP_LE_VCb_cond_D:
	{
	if ( ! (frame[z.v1].AsDouble() <= z.c.AsDouble()) ) Branch(z.v2)
	}
	break;

case OP_LE_VCb_cond_U:
	{
	if ( ! (frame[z.v1].AsCount() <= z.c.AsCount()) ) Branch(z.v2)
	}
	break;

case OP_LE_VCb_cond_I:
	{
	if ( ! (frame[z.v1].AsInt() <= z.c.AsInt()) ) Branch(z.v2)
	}
	break;

case OP_LE_VVV_A:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsAddr()->AsAddr() < frame[z.v3].AsAddr()->AsAddr() || frame[z.v2].AsAddr()->AsAddr() == frame[z.v3].AsAddr()->AsAddr();
	}
	break;

case OP_LE_VVV_T:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsTable()->IsSubsetOf(*frame[z.v3].AsTable());
	}
	break;

case OP_LE_VVV_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(frame[z.v2].AsString()->AsString(), frame[z.v3].AsString()->AsString()) <= 0;
	}
	break;

case OP_LE_VVV_D:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsDouble() <= frame[z.v3].AsDouble();
	}
	break;

case OP_LE_VVV_U:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsCount() <= frame[z.v3].AsCount();
	}
	break;

case OP_LE_VVV_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() <= frame[z.v3].AsInt();
	}
	break;

case OP_LE_VVV_vec_A:
	{
	vec_exec(OP_LE_VVV_vec_A, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LE_VVV_vec_T:
	{
	vec_exec(OP_LE_VVV_vec_T, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LE_VVV_vec_S:
	{
	vec_exec(OP_LE_VVV_vec_S, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LE_VVV_vec_D:
	{
	vec_exec(OP_LE_VVV_vec_D, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LE_VVV_vec_U:
	{
	vec_exec(OP_LE_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LE_VVV_vec_I:
	{
	vec_exec(OP_LE_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_LE_VVb_cond_A:
	{
	if ( ! (frame[z.v1].AsAddr()->AsAddr() < frame[z.v2].AsAddr()->AsAddr() || frame[z.v1].AsAddr()->AsAddr() == frame[z.v2].AsAddr()->AsAddr()) ) Branch(z.v3)
	}
	break;

case OP_LE_VVb_cond_T:
	{
	if ( ! (frame[z.v1].AsTable()->IsSubsetOf(*frame[z.v2].AsTable())) ) Branch(z.v3)
	}
	break;

case OP_LE_VVb_cond_S:
	{
	if ( ! (Bstr_cmp(frame[z.v1].AsString()->AsString(), frame[z.v2].AsString()->AsString()) <= 0) ) Branch(z.v3)
	}
	break;

case OP_LE_VVb_cond_D:
	{
	if ( ! (frame[z.v1].AsDouble() <= frame[z.v2].AsDouble()) ) Branch(z.v3)
	}
	break;

case OP_LE_VVb_cond_U:
	{
	if ( ! (frame[z.v1].AsCount() <= frame[z.v2].AsCount()) ) Branch(z.v3)
	}
	break;

case OP_LE_VVb_cond_I:
	{
	if ( ! (frame[z.v1].AsInt() <= frame[z.v2].AsInt()) ) Branch(z.v3)
	}
	break;

case OP_EQ_VCV_P:
	{
	frame[z.v1].AsIntRef() = strcmp(z.c.AsPattern()->Get()->PatternText(), frame[z.v2].AsPattern()->Get()->PatternText()) == 0;
	}
	break;

case OP_EQ_VCV_F:
	{
	frame[z.v1].AsIntRef() = z.c.AsFunc()->GetName() == frame[z.v2].AsFunc()->GetName();
	}
	break;

case OP_EQ_VCV_N:
	{
	frame[z.v1].AsIntRef() = z.c.AsSubNet()->AsSubNet() == frame[z.v2].AsSubNet()->AsSubNet();
	}
	break;

case OP_EQ_VCV_A:
	{
	frame[z.v1].AsIntRef() = z.c.AsAddr()->AsAddr() == frame[z.v2].AsAddr()->AsAddr();
	}
	break;

case OP_EQ_VCV_T:
	{
	frame[z.v1].AsIntRef() = z.c.AsTable()->EqualTo(*frame[z.v2].AsTable());
	}
	break;

case OP_EQ_VCV_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(z.c.AsString()->AsString(), frame[z.v2].AsString()->AsString()) == 0;
	}
	break;

case OP_EQ_VCV_D:
	{
	frame[z.v1].AsIntRef() = z.c.AsDouble() == frame[z.v2].AsDouble();
	}
	break;

case OP_EQ_VCV_U:
	{
	frame[z.v1].AsIntRef() = z.c.AsCount() == frame[z.v2].AsCount();
	}
	break;

case OP_EQ_VCV_I:
	{
	frame[z.v1].AsIntRef() = z.c.AsInt() == frame[z.v2].AsInt();
	}
	break;

case OP_EQ_VCV_PS:
	{
	frame[z.v1].AsIntRef() = z.c.AsPattern()->MatchExactly(frame[z.v2].AsString()->AsString());
	}
	break;

case OP_EQ_CVb_cond_P:
	{
	if ( ! (strcmp(z.c.AsPattern()->Get()->PatternText(), frame[z.v1].AsPattern()->Get()->PatternText()) == 0) ) Branch(z.v2)
	}
	break;

case OP_EQ_CVb_cond_F:
	{
	if ( ! (z.c.AsFunc()->GetName() == frame[z.v1].AsFunc()->GetName()) ) Branch(z.v2)
	}
	break;

case OP_EQ_CVb_cond_N:
	{
	if ( ! (z.c.AsSubNet()->AsSubNet() == frame[z.v1].AsSubNet()->AsSubNet()) ) Branch(z.v2)
	}
	break;

case OP_EQ_CVb_cond_A:
	{
	if ( ! (z.c.AsAddr()->AsAddr() == frame[z.v1].AsAddr()->AsAddr()) ) Branch(z.v2)
	}
	break;

case OP_EQ_CVb_cond_T:
	{
	if ( ! (z.c.AsTable()->EqualTo(*frame[z.v1].AsTable())) ) Branch(z.v2)
	}
	break;

case OP_EQ_CVb_cond_S:
	{
	if ( ! (Bstr_cmp(z.c.AsString()->AsString(), frame[z.v1].AsString()->AsString()) == 0) ) Branch(z.v2)
	}
	break;

case OP_EQ_CVb_cond_D:
	{
	if ( ! (z.c.AsDouble() == frame[z.v1].AsDouble()) ) Branch(z.v2)
	}
	break;

case OP_EQ_CVb_cond_U:
	{
	if ( ! (z.c.AsCount() == frame[z.v1].AsCount()) ) Branch(z.v2)
	}
	break;

case OP_EQ_CVb_cond_I:
	{
	if ( ! (z.c.AsInt() == frame[z.v1].AsInt()) ) Branch(z.v2)
	}
	break;

case OP_EQ_CVb_cond_PS:
	{
	if ( ! (z.c.AsPattern()->MatchExactly(frame[z.v1].AsString()->AsString())) ) Branch(z.v2)
	}
	break;

case OP_EQ_VVC_P:
	{
	frame[z.v1].AsIntRef() = strcmp(frame[z.v2].AsPattern()->Get()->PatternText(), z.c.AsPattern()->Get()->PatternText()) == 0;
	}
	break;

case OP_EQ_VVC_F:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsFunc()->GetName() == z.c.AsFunc()->GetName();
	}
	break;

case OP_EQ_VVC_N:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsSubNet()->AsSubNet() == z.c.AsSubNet()->AsSubNet();
	}
	break;

case OP_EQ_VVC_A:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsAddr()->AsAddr() == z.c.AsAddr()->AsAddr();
	}
	break;

case OP_EQ_VVC_T:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsTable()->EqualTo(*z.c.AsTable());
	}
	break;

case OP_EQ_VVC_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(frame[z.v2].AsString()->AsString(), z.c.AsString()->AsString()) == 0;
	}
	break;

case OP_EQ_VVC_D:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsDouble() == z.c.AsDouble();
	}
	break;

case OP_EQ_VVC_U:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsCount() == z.c.AsCount();
	}
	break;

case OP_EQ_VVC_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() == z.c.AsInt();
	}
	break;

case OP_EQ_VVC_PS:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsPattern()->MatchExactly(z.c.AsString()->AsString());
	}
	break;

case OP_EQ_VCb_cond_P:
	{
	if ( ! (strcmp(frame[z.v1].AsPattern()->Get()->PatternText(), z.c.AsPattern()->Get()->PatternText()) == 0) ) Branch(z.v2)
	}
	break;

case OP_EQ_VCb_cond_F:
	{
	if ( ! (frame[z.v1].AsFunc()->GetName() == z.c.AsFunc()->GetName()) ) Branch(z.v2)
	}
	break;

case OP_EQ_VCb_cond_N:
	{
	if ( ! (frame[z.v1].AsSubNet()->AsSubNet() == z.c.AsSubNet()->AsSubNet()) ) Branch(z.v2)
	}
	break;

case OP_EQ_VCb_cond_A:
	{
	if ( ! (frame[z.v1].AsAddr()->AsAddr() == z.c.AsAddr()->AsAddr()) ) Branch(z.v2)
	}
	break;

case OP_EQ_VCb_cond_T:
	{
	if ( ! (frame[z.v1].AsTable()->EqualTo(*z.c.AsTable())) ) Branch(z.v2)
	}
	break;

case OP_EQ_VCb_cond_S:
	{
	if ( ! (Bstr_cmp(frame[z.v1].AsString()->AsString(), z.c.AsString()->AsString()) == 0) ) Branch(z.v2)
	}
	break;

case OP_EQ_VCb_cond_D:
	{
	if ( ! (frame[z.v1].AsDouble() == z.c.AsDouble()) ) Branch(z.v2)
	}
	break;

case OP_EQ_VCb_cond_U:
	{
	if ( ! (frame[z.v1].AsCount() == z.c.AsCount()) ) Branch(z.v2)
	}
	break;

case OP_EQ_VCb_cond_I:
	{
	if ( ! (frame[z.v1].AsInt() == z.c.AsInt()) ) Branch(z.v2)
	}
	break;

case OP_EQ_VCb_cond_PS:
	{
	if ( ! (frame[z.v1].AsPattern()->MatchExactly(z.c.AsString()->AsString())) ) Branch(z.v2)
	}
	break;

case OP_EQ_VVV_P:
	{
	frame[z.v1].AsIntRef() = strcmp(frame[z.v2].AsPattern()->Get()->PatternText(), frame[z.v3].AsPattern()->Get()->PatternText()) == 0;
	}
	break;

case OP_EQ_VVV_F:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsFunc()->GetName() == frame[z.v3].AsFunc()->GetName();
	}
	break;

case OP_EQ_VVV_N:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsSubNet()->AsSubNet() == frame[z.v3].AsSubNet()->AsSubNet();
	}
	break;

case OP_EQ_VVV_A:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsAddr()->AsAddr() == frame[z.v3].AsAddr()->AsAddr();
	}
	break;

case OP_EQ_VVV_T:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsTable()->EqualTo(*frame[z.v3].AsTable());
	}
	break;

case OP_EQ_VVV_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(frame[z.v2].AsString()->AsString(), frame[z.v3].AsString()->AsString()) == 0;
	}
	break;

case OP_EQ_VVV_D:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsDouble() == frame[z.v3].AsDouble();
	}
	break;

case OP_EQ_VVV_U:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsCount() == frame[z.v3].AsCount();
	}
	break;

case OP_EQ_VVV_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() == frame[z.v3].AsInt();
	}
	break;

case OP_EQ_VVV_PS:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsPattern()->MatchExactly(frame[z.v3].AsString()->AsString());
	}
	break;

case OP_EQ_VVV_vec_P:
	{
	vec_exec(OP_EQ_VVV_vec_P, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_EQ_VVV_vec_F:
	{
	vec_exec(OP_EQ_VVV_vec_F, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_EQ_VVV_vec_N:
	{
	vec_exec(OP_EQ_VVV_vec_N, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_EQ_VVV_vec_A:
	{
	vec_exec(OP_EQ_VVV_vec_A, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_EQ_VVV_vec_T:
	{
	vec_exec(OP_EQ_VVV_vec_T, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_EQ_VVV_vec_S:
	{
	vec_exec(OP_EQ_VVV_vec_S, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_EQ_VVV_vec_D:
	{
	vec_exec(OP_EQ_VVV_vec_D, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_EQ_VVV_vec_U:
	{
	vec_exec(OP_EQ_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_EQ_VVV_vec_I:
	{
	vec_exec(OP_EQ_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_EQ_VVb_cond_P:
	{
	if ( ! (strcmp(frame[z.v1].AsPattern()->Get()->PatternText(), frame[z.v2].AsPattern()->Get()->PatternText()) == 0) ) Branch(z.v3)
	}
	break;

case OP_EQ_VVb_cond_F:
	{
	if ( ! (frame[z.v1].AsFunc()->GetName() == frame[z.v2].AsFunc()->GetName()) ) Branch(z.v3)
	}
	break;

case OP_EQ_VVb_cond_N:
	{
	if ( ! (frame[z.v1].AsSubNet()->AsSubNet() == frame[z.v2].AsSubNet()->AsSubNet()) ) Branch(z.v3)
	}
	break;

case OP_EQ_VVb_cond_A:
	{
	if ( ! (frame[z.v1].AsAddr()->AsAddr() == frame[z.v2].AsAddr()->AsAddr()) ) Branch(z.v3)
	}
	break;

case OP_EQ_VVb_cond_T:
	{
	if ( ! (frame[z.v1].AsTable()->EqualTo(*frame[z.v2].AsTable())) ) Branch(z.v3)
	}
	break;

case OP_EQ_VVb_cond_S:
	{
	if ( ! (Bstr_cmp(frame[z.v1].AsString()->AsString(), frame[z.v2].AsString()->AsString()) == 0) ) Branch(z.v3)
	}
	break;

case OP_EQ_VVb_cond_D:
	{
	if ( ! (frame[z.v1].AsDouble() == frame[z.v2].AsDouble()) ) Branch(z.v3)
	}
	break;

case OP_EQ_VVb_cond_U:
	{
	if ( ! (frame[z.v1].AsCount() == frame[z.v2].AsCount()) ) Branch(z.v3)
	}
	break;

case OP_EQ_VVb_cond_I:
	{
	if ( ! (frame[z.v1].AsInt() == frame[z.v2].AsInt()) ) Branch(z.v3)
	}
	break;

case OP_EQ_VVb_cond_PS:
	{
	if ( ! (frame[z.v1].AsPattern()->MatchExactly(frame[z.v2].AsString()->AsString())) ) Branch(z.v3)
	}
	break;

case OP_NE_VCV_P:
	{
	frame[z.v1].AsIntRef() = strcmp(z.c.AsPattern()->Get()->PatternText(), frame[z.v2].AsPattern()->Get()->PatternText()) != 0;
	}
	break;

case OP_NE_VCV_F:
	{
	frame[z.v1].AsIntRef() = z.c.AsFunc()->GetName() != frame[z.v2].AsFunc()->GetName();
	}
	break;

case OP_NE_VCV_N:
	{
	frame[z.v1].AsIntRef() = z.c.AsSubNet()->AsSubNet() != frame[z.v2].AsSubNet()->AsSubNet();
	}
	break;

case OP_NE_VCV_A:
	{
	frame[z.v1].AsIntRef() = z.c.AsAddr()->AsAddr() != frame[z.v2].AsAddr()->AsAddr();
	}
	break;

case OP_NE_VCV_T:
	{
	frame[z.v1].AsIntRef() = ! z.c.AsTable()->EqualTo(*frame[z.v2].AsTable());
	}
	break;

case OP_NE_VCV_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(z.c.AsString()->AsString(), frame[z.v2].AsString()->AsString()) != 0;
	}
	break;

case OP_NE_VCV_D:
	{
	frame[z.v1].AsIntRef() = z.c.AsDouble() != frame[z.v2].AsDouble();
	}
	break;

case OP_NE_VCV_U:
	{
	frame[z.v1].AsIntRef() = z.c.AsCount() != frame[z.v2].AsCount();
	}
	break;

case OP_NE_VCV_I:
	{
	frame[z.v1].AsIntRef() = z.c.AsInt() != frame[z.v2].AsInt();
	}
	break;

case OP_NE_VCV_PS:
	{
	frame[z.v1].AsIntRef() = ! z.c.AsPattern()->MatchExactly(frame[z.v2].AsString()->AsString());
	}
	break;

case OP_NE_CVb_cond_P:
	{
	if ( ! (strcmp(z.c.AsPattern()->Get()->PatternText(), frame[z.v1].AsPattern()->Get()->PatternText()) != 0) ) Branch(z.v2)
	}
	break;

case OP_NE_CVb_cond_F:
	{
	if ( ! (z.c.AsFunc()->GetName() != frame[z.v1].AsFunc()->GetName()) ) Branch(z.v2)
	}
	break;

case OP_NE_CVb_cond_N:
	{
	if ( ! (z.c.AsSubNet()->AsSubNet() != frame[z.v1].AsSubNet()->AsSubNet()) ) Branch(z.v2)
	}
	break;

case OP_NE_CVb_cond_A:
	{
	if ( ! (z.c.AsAddr()->AsAddr() != frame[z.v1].AsAddr()->AsAddr()) ) Branch(z.v2)
	}
	break;

case OP_NE_CVb_cond_T:
	{
	if ( ! (! z.c.AsTable()->EqualTo(*frame[z.v1].AsTable())) ) Branch(z.v2)
	}
	break;

case OP_NE_CVb_cond_S:
	{
	if ( ! (Bstr_cmp(z.c.AsString()->AsString(), frame[z.v1].AsString()->AsString()) != 0) ) Branch(z.v2)
	}
	break;

case OP_NE_CVb_cond_D:
	{
	if ( ! (z.c.AsDouble() != frame[z.v1].AsDouble()) ) Branch(z.v2)
	}
	break;

case OP_NE_CVb_cond_U:
	{
	if ( ! (z.c.AsCount() != frame[z.v1].AsCount()) ) Branch(z.v2)
	}
	break;

case OP_NE_CVb_cond_I:
	{
	if ( ! (z.c.AsInt() != frame[z.v1].AsInt()) ) Branch(z.v2)
	}
	break;

case OP_NE_CVb_cond_PS:
	{
	if ( ! (! z.c.AsPattern()->MatchExactly(frame[z.v1].AsString()->AsString())) ) Branch(z.v2)
	}
	break;

case OP_NE_VVC_P:
	{
	frame[z.v1].AsIntRef() = strcmp(frame[z.v2].AsPattern()->Get()->PatternText(), z.c.AsPattern()->Get()->PatternText()) != 0;
	}
	break;

case OP_NE_VVC_F:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsFunc()->GetName() != z.c.AsFunc()->GetName();
	}
	break;

case OP_NE_VVC_N:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsSubNet()->AsSubNet() != z.c.AsSubNet()->AsSubNet();
	}
	break;

case OP_NE_VVC_A:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsAddr()->AsAddr() != z.c.AsAddr()->AsAddr();
	}
	break;

case OP_NE_VVC_T:
	{
	frame[z.v1].AsIntRef() = ! frame[z.v2].AsTable()->EqualTo(*z.c.AsTable());
	}
	break;

case OP_NE_VVC_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(frame[z.v2].AsString()->AsString(), z.c.AsString()->AsString()) != 0;
	}
	break;

case OP_NE_VVC_D:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsDouble() != z.c.AsDouble();
	}
	break;

case OP_NE_VVC_U:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsCount() != z.c.AsCount();
	}
	break;

case OP_NE_VVC_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() != z.c.AsInt();
	}
	break;

case OP_NE_VVC_PS:
	{
	frame[z.v1].AsIntRef() = ! frame[z.v2].AsPattern()->MatchExactly(z.c.AsString()->AsString());
	}
	break;

case OP_NE_VCb_cond_P:
	{
	if ( ! (strcmp(frame[z.v1].AsPattern()->Get()->PatternText(), z.c.AsPattern()->Get()->PatternText()) != 0) ) Branch(z.v2)
	}
	break;

case OP_NE_VCb_cond_F:
	{
	if ( ! (frame[z.v1].AsFunc()->GetName() != z.c.AsFunc()->GetName()) ) Branch(z.v2)
	}
	break;

case OP_NE_VCb_cond_N:
	{
	if ( ! (frame[z.v1].AsSubNet()->AsSubNet() != z.c.AsSubNet()->AsSubNet()) ) Branch(z.v2)
	}
	break;

case OP_NE_VCb_cond_A:
	{
	if ( ! (frame[z.v1].AsAddr()->AsAddr() != z.c.AsAddr()->AsAddr()) ) Branch(z.v2)
	}
	break;

case OP_NE_VCb_cond_T:
	{
	if ( ! (! frame[z.v1].AsTable()->EqualTo(*z.c.AsTable())) ) Branch(z.v2)
	}
	break;

case OP_NE_VCb_cond_S:
	{
	if ( ! (Bstr_cmp(frame[z.v1].AsString()->AsString(), z.c.AsString()->AsString()) != 0) ) Branch(z.v2)
	}
	break;

case OP_NE_VCb_cond_D:
	{
	if ( ! (frame[z.v1].AsDouble() != z.c.AsDouble()) ) Branch(z.v2)
	}
	break;

case OP_NE_VCb_cond_U:
	{
	if ( ! (frame[z.v1].AsCount() != z.c.AsCount()) ) Branch(z.v2)
	}
	break;

case OP_NE_VCb_cond_I:
	{
	if ( ! (frame[z.v1].AsInt() != z.c.AsInt()) ) Branch(z.v2)
	}
	break;

case OP_NE_VCb_cond_PS:
	{
	if ( ! (! frame[z.v1].AsPattern()->MatchExactly(z.c.AsString()->AsString())) ) Branch(z.v2)
	}
	break;

case OP_NE_VVV_P:
	{
	frame[z.v1].AsIntRef() = strcmp(frame[z.v2].AsPattern()->Get()->PatternText(), frame[z.v3].AsPattern()->Get()->PatternText()) != 0;
	}
	break;

case OP_NE_VVV_F:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsFunc()->GetName() != frame[z.v3].AsFunc()->GetName();
	}
	break;

case OP_NE_VVV_N:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsSubNet()->AsSubNet() != frame[z.v3].AsSubNet()->AsSubNet();
	}
	break;

case OP_NE_VVV_A:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsAddr()->AsAddr() != frame[z.v3].AsAddr()->AsAddr();
	}
	break;

case OP_NE_VVV_T:
	{
	frame[z.v1].AsIntRef() = ! frame[z.v2].AsTable()->EqualTo(*frame[z.v3].AsTable());
	}
	break;

case OP_NE_VVV_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(frame[z.v2].AsString()->AsString(), frame[z.v3].AsString()->AsString()) != 0;
	}
	break;

case OP_NE_VVV_D:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsDouble() != frame[z.v3].AsDouble();
	}
	break;

case OP_NE_VVV_U:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsCount() != frame[z.v3].AsCount();
	}
	break;

case OP_NE_VVV_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() != frame[z.v3].AsInt();
	}
	break;

case OP_NE_VVV_PS:
	{
	frame[z.v1].AsIntRef() = ! frame[z.v2].AsPattern()->MatchExactly(frame[z.v3].AsString()->AsString());
	}
	break;

case OP_NE_VVV_vec_P:
	{
	vec_exec(OP_NE_VVV_vec_P, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_NE_VVV_vec_F:
	{
	vec_exec(OP_NE_VVV_vec_F, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_NE_VVV_vec_N:
	{
	vec_exec(OP_NE_VVV_vec_N, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_NE_VVV_vec_A:
	{
	vec_exec(OP_NE_VVV_vec_A, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_NE_VVV_vec_T:
	{
	vec_exec(OP_NE_VVV_vec_T, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_NE_VVV_vec_S:
	{
	vec_exec(OP_NE_VVV_vec_S, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_NE_VVV_vec_D:
	{
	vec_exec(OP_NE_VVV_vec_D, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_NE_VVV_vec_U:
	{
	vec_exec(OP_NE_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_NE_VVV_vec_I:
	{
	vec_exec(OP_NE_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_NE_VVb_cond_P:
	{
	if ( ! (strcmp(frame[z.v1].AsPattern()->Get()->PatternText(), frame[z.v2].AsPattern()->Get()->PatternText()) != 0) ) Branch(z.v3)
	}
	break;

case OP_NE_VVb_cond_F:
	{
	if ( ! (frame[z.v1].AsFunc()->GetName() != frame[z.v2].AsFunc()->GetName()) ) Branch(z.v3)
	}
	break;

case OP_NE_VVb_cond_N:
	{
	if ( ! (frame[z.v1].AsSubNet()->AsSubNet() != frame[z.v2].AsSubNet()->AsSubNet()) ) Branch(z.v3)
	}
	break;

case OP_NE_VVb_cond_A:
	{
	if ( ! (frame[z.v1].AsAddr()->AsAddr() != frame[z.v2].AsAddr()->AsAddr()) ) Branch(z.v3)
	}
	break;

case OP_NE_VVb_cond_T:
	{
	if ( ! (! frame[z.v1].AsTable()->EqualTo(*frame[z.v2].AsTable())) ) Branch(z.v3)
	}
	break;

case OP_NE_VVb_cond_S:
	{
	if ( ! (Bstr_cmp(frame[z.v1].AsString()->AsString(), frame[z.v2].AsString()->AsString()) != 0) ) Branch(z.v3)
	}
	break;

case OP_NE_VVb_cond_D:
	{
	if ( ! (frame[z.v1].AsDouble() != frame[z.v2].AsDouble()) ) Branch(z.v3)
	}
	break;

case OP_NE_VVb_cond_U:
	{
	if ( ! (frame[z.v1].AsCount() != frame[z.v2].AsCount()) ) Branch(z.v3)
	}
	break;

case OP_NE_VVb_cond_I:
	{
	if ( ! (frame[z.v1].AsInt() != frame[z.v2].AsInt()) ) Branch(z.v3)
	}
	break;

case OP_NE_VVb_cond_PS:
	{
	if ( ! (! frame[z.v1].AsPattern()->MatchExactly(frame[z.v2].AsString()->AsString())) ) Branch(z.v3)
	}
	break;

case OP_GE_VCV_A:
	{
	frame[z.v1].AsIntRef() = ! (z.c.AsAddr()->AsAddr() < frame[z.v2].AsAddr()->AsAddr());
	}
	break;

case OP_GE_VCV_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(z.c.AsString()->AsString(), frame[z.v2].AsString()->AsString()) >= 0;
	}
	break;

case OP_GE_VCV_D:
	{
	frame[z.v1].AsIntRef() = z.c.AsDouble() >= frame[z.v2].AsDouble();
	}
	break;

case OP_GE_VCV_U:
	{
	frame[z.v1].AsIntRef() = z.c.AsCount() >= frame[z.v2].AsCount();
	}
	break;

case OP_GE_VCV_I:
	{
	frame[z.v1].AsIntRef() = z.c.AsInt() >= frame[z.v2].AsInt();
	}
	break;

case OP_GE_CVb_cond_A:
	{
	if ( ! (! (z.c.AsAddr()->AsAddr() < frame[z.v1].AsAddr()->AsAddr())) ) Branch(z.v2)
	}
	break;

case OP_GE_CVb_cond_S:
	{
	if ( ! (Bstr_cmp(z.c.AsString()->AsString(), frame[z.v1].AsString()->AsString()) >= 0) ) Branch(z.v2)
	}
	break;

case OP_GE_CVb_cond_D:
	{
	if ( ! (z.c.AsDouble() >= frame[z.v1].AsDouble()) ) Branch(z.v2)
	}
	break;

case OP_GE_CVb_cond_U:
	{
	if ( ! (z.c.AsCount() >= frame[z.v1].AsCount()) ) Branch(z.v2)
	}
	break;

case OP_GE_CVb_cond_I:
	{
	if ( ! (z.c.AsInt() >= frame[z.v1].AsInt()) ) Branch(z.v2)
	}
	break;

case OP_GE_VVC_A:
	{
	frame[z.v1].AsIntRef() = ! (frame[z.v2].AsAddr()->AsAddr() < z.c.AsAddr()->AsAddr());
	}
	break;

case OP_GE_VVC_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(frame[z.v2].AsString()->AsString(), z.c.AsString()->AsString()) >= 0;
	}
	break;

case OP_GE_VVC_D:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsDouble() >= z.c.AsDouble();
	}
	break;

case OP_GE_VVC_U:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsCount() >= z.c.AsCount();
	}
	break;

case OP_GE_VVC_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() >= z.c.AsInt();
	}
	break;

case OP_GE_VCb_cond_A:
	{
	if ( ! (! (frame[z.v1].AsAddr()->AsAddr() < z.c.AsAddr()->AsAddr())) ) Branch(z.v2)
	}
	break;

case OP_GE_VCb_cond_S:
	{
	if ( ! (Bstr_cmp(frame[z.v1].AsString()->AsString(), z.c.AsString()->AsString()) >= 0) ) Branch(z.v2)
	}
	break;

case OP_GE_VCb_cond_D:
	{
	if ( ! (frame[z.v1].AsDouble() >= z.c.AsDouble()) ) Branch(z.v2)
	}
	break;

case OP_GE_VCb_cond_U:
	{
	if ( ! (frame[z.v1].AsCount() >= z.c.AsCount()) ) Branch(z.v2)
	}
	break;

case OP_GE_VCb_cond_I:
	{
	if ( ! (frame[z.v1].AsInt() >= z.c.AsInt()) ) Branch(z.v2)
	}
	break;

case OP_GE_VVV_A:
	{
	frame[z.v1].AsIntRef() = ! (frame[z.v2].AsAddr()->AsAddr() < frame[z.v3].AsAddr()->AsAddr());
	}
	break;

case OP_GE_VVV_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(frame[z.v2].AsString()->AsString(), frame[z.v3].AsString()->AsString()) >= 0;
	}
	break;

case OP_GE_VVV_D:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsDouble() >= frame[z.v3].AsDouble();
	}
	break;

case OP_GE_VVV_U:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsCount() >= frame[z.v3].AsCount();
	}
	break;

case OP_GE_VVV_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() >= frame[z.v3].AsInt();
	}
	break;

case OP_GE_VVV_vec_A:
	{
	vec_exec(OP_GE_VVV_vec_A, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_GE_VVV_vec_S:
	{
	vec_exec(OP_GE_VVV_vec_S, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_GE_VVV_vec_D:
	{
	vec_exec(OP_GE_VVV_vec_D, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_GE_VVV_vec_U:
	{
	vec_exec(OP_GE_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_GE_VVV_vec_I:
	{
	vec_exec(OP_GE_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_GE_VVb_cond_A:
	{
	if ( ! (! (frame[z.v1].AsAddr()->AsAddr() < frame[z.v2].AsAddr()->AsAddr())) ) Branch(z.v3)
	}
	break;

case OP_GE_VVb_cond_S:
	{
	if ( ! (Bstr_cmp(frame[z.v1].AsString()->AsString(), frame[z.v2].AsString()->AsString()) >= 0) ) Branch(z.v3)
	}
	break;

case OP_GE_VVb_cond_D:
	{
	if ( ! (frame[z.v1].AsDouble() >= frame[z.v2].AsDouble()) ) Branch(z.v3)
	}
	break;

case OP_GE_VVb_cond_U:
	{
	if ( ! (frame[z.v1].AsCount() >= frame[z.v2].AsCount()) ) Branch(z.v3)
	}
	break;

case OP_GE_VVb_cond_I:
	{
	if ( ! (frame[z.v1].AsInt() >= frame[z.v2].AsInt()) ) Branch(z.v3)
	}
	break;

case OP_GT_VCV_A:
	{
	frame[z.v1].AsIntRef() = ! (z.c.AsAddr()->AsAddr() < frame[z.v2].AsAddr()->AsAddr()) && z.c.AsAddr()->AsAddr() != frame[z.v2].AsAddr()->AsAddr();
	}
	break;

case OP_GT_VCV_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(z.c.AsString()->AsString(), frame[z.v2].AsString()->AsString()) > 0;
	}
	break;

case OP_GT_VCV_D:
	{
	frame[z.v1].AsIntRef() = z.c.AsDouble() > frame[z.v2].AsDouble();
	}
	break;

case OP_GT_VCV_U:
	{
	frame[z.v1].AsIntRef() = z.c.AsCount() > frame[z.v2].AsCount();
	}
	break;

case OP_GT_VCV_I:
	{
	frame[z.v1].AsIntRef() = z.c.AsInt() > frame[z.v2].AsInt();
	}
	break;

case OP_GT_CVb_cond_A:
	{
	if ( ! (! (z.c.AsAddr()->AsAddr() < frame[z.v1].AsAddr()->AsAddr()) && z.c.AsAddr()->AsAddr() != frame[z.v1].AsAddr()->AsAddr()) ) Branch(z.v2)
	}
	break;

case OP_GT_CVb_cond_S:
	{
	if ( ! (Bstr_cmp(z.c.AsString()->AsString(), frame[z.v1].AsString()->AsString()) > 0) ) Branch(z.v2)
	}
	break;

case OP_GT_CVb_cond_D:
	{
	if ( ! (z.c.AsDouble() > frame[z.v1].AsDouble()) ) Branch(z.v2)
	}
	break;

case OP_GT_CVb_cond_U:
	{
	if ( ! (z.c.AsCount() > frame[z.v1].AsCount()) ) Branch(z.v2)
	}
	break;

case OP_GT_CVb_cond_I:
	{
	if ( ! (z.c.AsInt() > frame[z.v1].AsInt()) ) Branch(z.v2)
	}
	break;

case OP_GT_VVC_A:
	{
	frame[z.v1].AsIntRef() = ! (frame[z.v2].AsAddr()->AsAddr() < z.c.AsAddr()->AsAddr()) && frame[z.v2].AsAddr()->AsAddr() != z.c.AsAddr()->AsAddr();
	}
	break;

case OP_GT_VVC_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(frame[z.v2].AsString()->AsString(), z.c.AsString()->AsString()) > 0;
	}
	break;

case OP_GT_VVC_D:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsDouble() > z.c.AsDouble();
	}
	break;

case OP_GT_VVC_U:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsCount() > z.c.AsCount();
	}
	break;

case OP_GT_VVC_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() > z.c.AsInt();
	}
	break;

case OP_GT_VCb_cond_A:
	{
	if ( ! (! (frame[z.v1].AsAddr()->AsAddr() < z.c.AsAddr()->AsAddr()) && frame[z.v1].AsAddr()->AsAddr() != z.c.AsAddr()->AsAddr()) ) Branch(z.v2)
	}
	break;

case OP_GT_VCb_cond_S:
	{
	if ( ! (Bstr_cmp(frame[z.v1].AsString()->AsString(), z.c.AsString()->AsString()) > 0) ) Branch(z.v2)
	}
	break;

case OP_GT_VCb_cond_D:
	{
	if ( ! (frame[z.v1].AsDouble() > z.c.AsDouble()) ) Branch(z.v2)
	}
	break;

case OP_GT_VCb_cond_U:
	{
	if ( ! (frame[z.v1].AsCount() > z.c.AsCount()) ) Branch(z.v2)
	}
	break;

case OP_GT_VCb_cond_I:
	{
	if ( ! (frame[z.v1].AsInt() > z.c.AsInt()) ) Branch(z.v2)
	}
	break;

case OP_GT_VVV_A:
	{
	frame[z.v1].AsIntRef() = ! (frame[z.v2].AsAddr()->AsAddr() < frame[z.v3].AsAddr()->AsAddr()) && frame[z.v2].AsAddr()->AsAddr() != frame[z.v3].AsAddr()->AsAddr();
	}
	break;

case OP_GT_VVV_S:
	{
	frame[z.v1].AsIntRef() = Bstr_cmp(frame[z.v2].AsString()->AsString(), frame[z.v3].AsString()->AsString()) > 0;
	}
	break;

case OP_GT_VVV_D:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsDouble() > frame[z.v3].AsDouble();
	}
	break;

case OP_GT_VVV_U:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsCount() > frame[z.v3].AsCount();
	}
	break;

case OP_GT_VVV_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt() > frame[z.v3].AsInt();
	}
	break;

case OP_GT_VVV_vec_A:
	{
	vec_exec(OP_GT_VVV_vec_A, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_GT_VVV_vec_S:
	{
	vec_exec(OP_GT_VVV_vec_S, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_GT_VVV_vec_D:
	{
	vec_exec(OP_GT_VVV_vec_D, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_GT_VVV_vec_U:
	{
	vec_exec(OP_GT_VVV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_GT_VVV_vec_I:
	{
	vec_exec(OP_GT_VVV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), frame[z.v3].AsVector(), z);
	}
	break;

case OP_GT_VVb_cond_A:
	{
	if ( ! (! (frame[z.v1].AsAddr()->AsAddr() < frame[z.v2].AsAddr()->AsAddr()) && frame[z.v1].AsAddr()->AsAddr() != frame[z.v2].AsAddr()->AsAddr()) ) Branch(z.v3)
	}
	break;

case OP_GT_VVb_cond_S:
	{
	if ( ! (Bstr_cmp(frame[z.v1].AsString()->AsString(), frame[z.v2].AsString()->AsString()) > 0) ) Branch(z.v3)
	}
	break;

case OP_GT_VVb_cond_D:
	{
	if ( ! (frame[z.v1].AsDouble() > frame[z.v2].AsDouble()) ) Branch(z.v3)
	}
	break;

case OP_GT_VVb_cond_U:
	{
	if ( ! (frame[z.v1].AsCount() > frame[z.v2].AsCount()) ) Branch(z.v3)
	}
	break;

case OP_GT_VVb_cond_I:
	{
	if ( ! (frame[z.v1].AsInt() > frame[z.v2].AsInt()) ) Branch(z.v3)
	}
	break;

case OP_MINU_VVV:
	{
	frame[z.v1].AsCountRef() = std::min(frame[z.v2].AsCount(), frame[z.v3].AsCount());
	}
	break;

case OP_MINU_VVC:
	{
	frame[z.v1].AsCountRef() = std::min(frame[z.v2].AsCount(), z.c.AsCount());
	}
	break;

case OP_MINI_VVV:
	{
	frame[z.v1].AsIntRef() = std::min(frame[z.v2].AsInt(), frame[z.v3].AsInt());
	}
	break;

case OP_MINI_VVC:
	{
	frame[z.v1].AsIntRef() = std::min(frame[z.v2].AsInt(), z.c.AsInt());
	}
	break;

case OP_MIND_VVV:
	{
	frame[z.v1].AsDoubleRef() = std::min(frame[z.v2].AsDouble(), frame[z.v3].AsDouble());
	}
	break;

case OP_MIND_VVC:
	{
	frame[z.v1].AsDoubleRef() = std::min(frame[z.v2].AsDouble(), z.c.AsDouble());
	}
	break;

case OP_MAXU_VVV:
	{
	frame[z.v1].AsCountRef() = std::max(frame[z.v2].AsCount(), frame[z.v3].AsCount());
	}
	break;

case OP_MAXU_VVC:
	{
	frame[z.v1].AsCountRef() = std::max(frame[z.v2].AsCount(), z.c.AsCount());
	}
	break;

case OP_MAXI_VVV:
	{
	frame[z.v1].AsIntRef() = std::max(frame[z.v2].AsInt(), frame[z.v3].AsInt());
	}
	break;

case OP_MAXI_VVC:
	{
	frame[z.v1].AsIntRef() = std::max(frame[z.v2].AsInt(), z.c.AsInt());
	}
	break;

case OP_MAXD_VVV:
	{
	frame[z.v1].AsDoubleRef() = std::max(frame[z.v2].AsDouble(), frame[z.v3].AsDouble());
	}
	break;

case OP_MAXD_VVC:
	{
	frame[z.v1].AsDoubleRef() = std::max(frame[z.v2].AsDouble(), z.c.AsDouble());
	}
	break;

case OP_FUNC_ID_STRING_VV:
	{
	auto orig_h =
		FieldValWithCheck(frame[z.v2].AsRecord(), 0).AsAddr()->AsAddr().AsString();
	auto resp_h =
		FieldValWithCheck(frame[z.v2].AsRecord(), 2).AsAddr()->AsAddr().AsString();
	auto orig_p =
		static_cast<uint32_t>(FieldValWithCheck(frame[z.v2].AsRecord(), 1).AsCount()) &
			~PORT_SPACE_MASK;
	auto resp_p =
		static_cast<uint32_t>(FieldValWithCheck(frame[z.v2].AsRecord(), 3).AsCount()) &
			~PORT_SPACE_MASK;
	/* Maximum address size is for IPv6 with no compression. Each
	 * 8 16-bit hex elements plus 7 colons between them plus the two []'s
	 * = 8*4 + 7 + 2 = 41 characters.
	 *
	 * Maximum port size is 5.
	 *
	 * Two of these = 2*41 + 2*5 = 92.
	 * Other delimiters: two ':', one ' < ' for 5 more.
	 *
	 * TOTAL: 97 characters.
	 *
	 * We use considerably more for safety.
	 */
	char buf[128];
	snprintf(buf, sizeof buf, "%s:%u > %s:%u", orig_h.c_str(), orig_p, resp_h.c_str(), resp_p);
	Unref(frame[z.v1].AsStringRef());
	frame[z.v1].AsStringRef() = new StringVal(buf);
	}
	break;

case OP_SCHEDULE_ViHL:
	{
	EvalSchedule(frame[z.v1].AsDouble(), z.v2)
	}
	break;

case OP_SCHEDULE_CiHL:
	{
	EvalSchedule(z.c.AsDouble(), z.v1)
	}
	break;

case OP_SCHEDULE0_ViH:
	{
	EvalScheduleArgs(frame[z.v1].AsDouble(), z.v2,)
	}
	break;

case OP_SCHEDULE0_CiH:
	{
	EvalScheduleArgs(z.c.AsDouble(), z.v1,)
	}
	break;

case OP_EVENT_HL:
	{
	ValVec args;
	Z_AUX->FillValVec(args, frame);
	QueueEvent(Z_AUX_EVENT_HANDLER, args);
	}
	break;

case OP_EVENT0_X:
	{
	ValVec args(0);
	QueueEvent(Z_AUX_EVENT_HANDLER, args);
	}
	break;

case OP_EVENT1_V:
	{
	ValVec args(1);
	args[0] = frame[z.v1].ToVal(Z_TYPE);
	QueueEvent(Z_AUX_EVENT_HANDLER, args);
	}
	break;

case OP_EVENT2_VV:
	{
	ValVec args(2);
	args[0] = frame[z.v1].ToVal(Z_TYPE);
	args[1] = frame[z.v2].ToVal(Z_TYPE2);
	QueueEvent(Z_AUX_EVENT_HANDLER, args);
	}
	break;

case OP_EVENT3_VVV:
	{
	ValVec args(3);
	auto& aux = Z_AUX;
	args[0] = frame[z.v1].ToVal(Z_TYPE);
	args[1] = frame[z.v2].ToVal(Z_TYPE2);
	args[2] = frame[z.v3].ToVal(aux->elems[2].GetType());
	QueueEvent(Z_AUX_EVENT_HANDLER, args);
	}
	break;

case OP_EVENT4_VVVV:
	{
	ValVec args(4);
	auto& aux = Z_AUX;
	args[0] = frame[z.v1].ToVal(Z_TYPE);
	args[1] = frame[z.v2].ToVal(Z_TYPE2);
	args[2] = frame[z.v3].ToVal(aux->elems[2].GetType());
	args[3] = frame[z.v4].ToVal(aux->elems[3].GetType());
	QueueEvent(Z_AUX_EVENT_HANDLER, args);
	}
	break;

case OP_RETURN_X:
	{
	EvalReturn(nullptr,)
	}
	break;

case OP_RETURN_V:
	{
	EvalReturn(&frame[z.v1], SET_RET_TYPE(Z_TYPE))
	}
	break;

case OP_RETURN_C:
	{
	EvalReturn(&z.c, SET_RET_TYPE(Z_TYPE))
	}
	break;

case OP_WHEN_RETURN_X:
	{
	static auto any_val = ZVal();
	EvalReturn(&any_val,);
	}
	break;

case OP_SWITCHI_Vii:
	{
	auto v = frame[z.v1].AsInt();
	EvalSwitchBody(z.v2, z.v3, int_cases,)
	}
	break;

case OP_SWITCHU_Vii:
	{
	auto v = frame[z.v1].AsCount();
	EvalSwitchBody(z.v2, z.v3, uint_cases,)
	}
	break;

case OP_SWITCHD_Vii:
	{
	auto v = frame[z.v1].AsDouble();
	EvalSwitchBody(z.v2, z.v3, double_cases,)
	}
	break;

case OP_SWITCHS_Vii:
	{
	auto vs = frame[z.v1].AsString()->AsString()->Render();
	std::string v(vs);
	EvalSwitchBody(z.v2, z.v3, str_cases,delete[] vs;)
	}
	break;

case OP_SWITCHA_Vii:
	{
	auto v = frame[z.v1].AsAddr()->AsAddr().AsString();
	EvalSwitchBody(z.v2, z.v3, str_cases,)
	}
	break;

case OP_SWITCHN_Vii:
	{
	auto v = frame[z.v1].AsSubNet()->AsSubNet().AsString();
	EvalSwitchBody(z.v2, z.v3, str_cases,)
	}
	break;

case OP_DETERMINE_TYPE_MATCH_VV:
	{
	auto& aux = Z_AUX;
	int match = -1;
	for ( int i = 0; i < aux->n; ++i )
		{
		auto& el = aux->elems[i];
		auto& et = el.GetType();
		if ( can_cast_value_to_type(frame[z.v2].AsAny(), et.get()) )
			{
			match = i;
			if ( el.Slot() >= 0 )
				{
				auto& tv = frame[el.Slot()];
				if ( el.IsManaged() )
					Unref(tv.ManagedVal());
				tv = ZVal(cast_value_to_type(frame[z.v2].AsAny(), et.get()), et);
				}
			break;
			}
		}
	frame[z.v1].AsIntRef() = match;
	}
	break;

case OP_CHECKANYLEN_Vi:
	{
	auto v = frame[z.v1].AsList();
	if ( v->Vals().size() != zeek_uint_t(z.v2) )
		ERROR("mismatch in list lengths");
	}
	break;

case OP_PRINT_O:
	{
	do_print_stmt(Z_AUX->ToValVec(frame));
	}
	break;

case OP_PRINT1_V:
	{
	std::vector<ValPtr> vals;
	vals.push_back(frame[z.v1].ToVal(Z_TYPE));
	do_print_stmt(vals);
	}
	break;

case OP_PRINT1_C:
	{
	std::vector<ValPtr> vals;
	vals.push_back(z.c.ToVal(Z_TYPE));
	do_print_stmt(vals);
	}
	break;

case OP_IF_ELSE_Vb:
	{
	if ( ! frame[z.v1].AsInt() ) Branch(z.v2)
	}
	break;

case OP_IF_Vb:
	{
	if ( ! frame[z.v1].AsInt() ) Branch(z.v2)
	}
	break;

case OP_IF_NOT_Vb:
	{
	if ( frame[z.v1].AsInt() ) Branch(z.v2)
	}
	break;

case OP_ADDSTMT_VO:
	{
	auto indices = Z_AUX->ToListVal(frame);
	EvalAddStmt(frame[z.v1], indices)
	}
	break;

case OP_ADDSTMT1_VV:
	{
	EvalAddStmt(frame[z.v1], frame[z.v2].ToVal(Z_TYPE))
	}
	break;

case OP_ADDSTMT1_VC:
	{
	EvalAddStmt(frame[z.v1], z.c.ToVal(Z_TYPE))
	}
	break;

case OP_CLEARTABLE_V:
	{
	frame[z.v1].AsTable()->RemoveAll();
	}
	break;

case OP_CLEARVECTOR_V:
	{
	frame[z.v1].AsVector()->Resize(0);
	}
	break;

case OP_DELTABLE_VO:
	{
	auto indices = Z_AUX->ToListVal(frame);
	bool iterators_invalidated = false;
	frame[z.v1].AsTable()->Remove(*indices, true, &iterators_invalidated);
	if ( iterators_invalidated )
		WARN("possible loop/iterator invalidation");
	}
	break;

case OP_DELFIELD_Vi:
	{
	frame[z.v1].AsRecord()->Remove(RecordField(frame[z.v1].AsRecord(), z.v2));
	}
	break;

case OP_INIT_RECORD_V:
	{
	auto r = new RecordVal(cast_intrusive<RecordType>(Z_TYPE));
	Unref(frame[z.v1].AsRecordRef());
	frame[z.v1].AsRecordRef() = r;
	}
	break;

case OP_INIT_VECTOR_V:
	{
	auto vt = cast_intrusive<VectorType>(Z_TYPE);
	auto vec = new VectorVal(std::move(vt));
	Unref(frame[z.v1].AsVectorRef());
	frame[z.v1].AsVectorRef() = vec;
	}
	break;

case OP_INIT_TABLE_V:
	{
	auto tt = cast_intrusive<TableType>(Z_TYPE);
	auto t = new TableVal(tt, Z_AUX_ATTRS);
	Unref(frame[z.v1].AsTableRef());
	frame[z.v1].AsTableRef() = t;
	}
	break;

case OP_WHEN_V:
	{
	BuildWhen(frame[z.v1].AsFunc(), -1.0)
	}
	break;

case OP_WHEN_TIMEOUT_VV:
	{
	BuildWhen(frame[z.v1].AsFunc(), frame[z.v2].AsDouble())
	}
	break;

case OP_WHEN_TIMEOUT_VC:
	{
	BuildWhen(frame[z.v1].AsFunc(), z.c.AsDouble())
	}
	break;

case OP_SHOULD_REPORT_ASSERT_VV:
	{
	static auto assertion_result_hook = id::find_func("assertion_result");
	bool run_result_hook = assertion_result_hook && assertion_result_hook->HasEnabledBodies();
	frame[z.v1].AsIntRef() = ! frame[z.v2].AsInt() || run_result_hook;
	}
	break;

case OP_REPORT_ASSERT_VC:
	{
	{
	const zeek::StringValPtr& msg_val = zeek::val_mgr->EmptyString();
	report_assert(frame[z.v1].AsIntRef(), z.c.AsString()->ToStdString(), msg_val, Z_LOC->Loc());
	}
	}
	break;

case OP_REPORT_ASSERT_WITH_MESSAGE_VVC:
	{
	report_assert(frame[z.v1].AsIntRef(), z.c.AsString()->ToStdString(), {NewRef{}, frame[z.v2].AsString()}, Z_LOC->Loc());
	}
	break;

case OP_ASSIGN_VC_A:
	{
	zeek::Ref(z.c.AsAddr());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(z.c.AsAddr());
	break;
	}
case OP_ASSIGN_VC_a:
	{
	auto v = z.c.ToVal(Z_TYPE);
	auto& f = frame[z.v1];
	zeek::Unref(f.ManagedVal());
	f = ZVal(v.release());
	break;
	}
case OP_ASSIGN_VC_U:
	{
	frame[z.v1] = ZVal(z.c.AsCount());
	break;
	}
case OP_ASSIGN_VC_D:
	{
	frame[z.v1] = ZVal(z.c.AsDouble());
	break;
	}
case OP_ASSIGN_VC_f:
	{
	zeek::Ref(z.c.AsFile());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(z.c.AsFile());
	break;
	}
case OP_ASSIGN_VC_F:
	{
	zeek::Ref(z.c.AsFunc());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(z.c.AsFunc());
	break;
	}
case OP_ASSIGN_VC_I:
	{
	frame[z.v1] = ZVal(z.c.AsInt());
	break;
	}
case OP_ASSIGN_VC_L:
	{
	zeek::Ref(z.c.AsList());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(z.c.AsList());
	break;
	}
case OP_ASSIGN_VC_O:
	{
	zeek::Ref(z.c.AsOpaque());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(z.c.AsOpaque());
	break;
	}
case OP_ASSIGN_VC_P:
	{
	zeek::Ref(z.c.AsPattern());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(z.c.AsPattern());
	break;
	}
case OP_ASSIGN_VC_R:
	{
	zeek::Ref(z.c.AsRecord());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(z.c.AsRecord());
	break;
	}
case OP_ASSIGN_VC_S:
	{
	zeek::Ref(z.c.AsString());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(z.c.AsString());
	break;
	}
case OP_ASSIGN_VC_N:
	{
	zeek::Ref(z.c.AsSubNet());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(z.c.AsSubNet());
	break;
	}
case OP_ASSIGN_VC_T:
	{
	zeek::Ref(z.c.AsTable());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(z.c.AsTable());
	break;
	}
case OP_ASSIGN_VC_t:
	{
	zeek::Ref(z.c.AsType());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(z.c.AsType());
	break;
	}
case OP_ASSIGN_VC_V:
	{
	zeek::Ref(z.c.AsVector());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(z.c.AsVector());
	break;
	}
case OP_ASSIGN_VV_A:
	{
	zeek::Ref(frame[z.v2].AsAddr());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(frame[z.v2].AsAddr());
	break;
	}
case OP_ASSIGN_VV_a:
	{
	zeek::Ref(frame[z.v2].AsAny());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(frame[z.v2].AsAny());
	break;
	}
case OP_ASSIGN_VV_U:
	{
	frame[z.v1] = ZVal(frame[z.v2].AsCount());
	break;
	}
case OP_ASSIGN_VV_D:
	{
	frame[z.v1] = ZVal(frame[z.v2].AsDouble());
	break;
	}
case OP_ASSIGN_VV_f:
	{
	zeek::Ref(frame[z.v2].AsFile());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(frame[z.v2].AsFile());
	break;
	}
case OP_ASSIGN_VV_F:
	{
	zeek::Ref(frame[z.v2].AsFunc());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(frame[z.v2].AsFunc());
	break;
	}
case OP_ASSIGN_VV_I:
	{
	frame[z.v1] = ZVal(frame[z.v2].AsInt());
	break;
	}
case OP_ASSIGN_VV_L:
	{
	zeek::Ref(frame[z.v2].AsList());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(frame[z.v2].AsList());
	break;
	}
case OP_ASSIGN_VV_O:
	{
	zeek::Ref(frame[z.v2].AsOpaque());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(frame[z.v2].AsOpaque());
	break;
	}
case OP_ASSIGN_VV_P:
	{
	zeek::Ref(frame[z.v2].AsPattern());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(frame[z.v2].AsPattern());
	break;
	}
case OP_ASSIGN_VV_R:
	{
	zeek::Ref(frame[z.v2].AsRecord());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(frame[z.v2].AsRecord());
	break;
	}
case OP_ASSIGN_VV_S:
	{
	zeek::Ref(frame[z.v2].AsString());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(frame[z.v2].AsString());
	break;
	}
case OP_ASSIGN_VV_N:
	{
	zeek::Ref(frame[z.v2].AsSubNet());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(frame[z.v2].AsSubNet());
	break;
	}
case OP_ASSIGN_VV_T:
	{
	zeek::Ref(frame[z.v2].AsTable());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(frame[z.v2].AsTable());
	break;
	}
case OP_ASSIGN_VV_t:
	{
	zeek::Ref(frame[z.v2].AsType());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(frame[z.v2].AsType());
	break;
	}
case OP_ASSIGN_VV_V:
	{
	zeek::Ref(frame[z.v2].AsVector());
	zeek::Unref(frame[z.v1].ManagedVal());
	frame[z.v1] = ZVal(frame[z.v2].AsVector());
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_A:
	{
	zeek::Ref(z.c.AsAddr());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	zeek::Unref(f.ManagedVal());
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_a:
	{
	auto v = z.c.ToVal(Z_TYPE);
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	zeek::Unref(f.ManagedVal());
	f = ZVal(v.release());
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_U:
	{
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_D:
	{
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_f:
	{
	zeek::Ref(z.c.AsFile());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	zeek::Unref(f.ManagedVal());
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_F:
	{
	zeek::Ref(z.c.AsFunc());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	zeek::Unref(f.ManagedVal());
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_I:
	{
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_L:
	{
	zeek::Ref(z.c.AsList());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	zeek::Unref(f.ManagedVal());
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_O:
	{
	zeek::Ref(z.c.AsOpaque());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	zeek::Unref(f.ManagedVal());
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_P:
	{
	zeek::Ref(z.c.AsPattern());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	zeek::Unref(f.ManagedVal());
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_R:
	{
	zeek::Ref(z.c.AsRecord());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	zeek::Unref(f.ManagedVal());
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_S:
	{
	zeek::Ref(z.c.AsString());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	zeek::Unref(f.ManagedVal());
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_N:
	{
	zeek::Ref(z.c.AsSubNet());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	zeek::Unref(f.ManagedVal());
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_T:
	{
	zeek::Ref(z.c.AsTable());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	zeek::Unref(f.ManagedVal());
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_t:
	{
	zeek::Ref(z.c.AsType());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	zeek::Unref(f.ManagedVal());
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCi_V:
	{
	zeek::Ref(z.c.AsVector());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v2);
	zeek::Unref(f.ManagedVal());
	f = z.c;
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_A:
	{
	zeek::Ref(frame[z.v2].AsAddr());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	zeek::Unref(f.ManagedVal());
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_a:
	{
	zeek::Ref(frame[z.v2].AsAny());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	zeek::Unref(f.ManagedVal());
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_U:
	{
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_D:
	{
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_f:
	{
	zeek::Ref(frame[z.v2].AsFile());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	zeek::Unref(f.ManagedVal());
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_F:
	{
	zeek::Ref(frame[z.v2].AsFunc());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	zeek::Unref(f.ManagedVal());
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_I:
	{
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_L:
	{
	zeek::Ref(frame[z.v2].AsList());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	zeek::Unref(f.ManagedVal());
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_O:
	{
	zeek::Ref(frame[z.v2].AsOpaque());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	zeek::Unref(f.ManagedVal());
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_P:
	{
	zeek::Ref(frame[z.v2].AsPattern());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	zeek::Unref(f.ManagedVal());
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_R:
	{
	zeek::Ref(frame[z.v2].AsRecord());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	zeek::Unref(f.ManagedVal());
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_S:
	{
	zeek::Ref(frame[z.v2].AsString());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	zeek::Unref(f.ManagedVal());
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_N:
	{
	zeek::Ref(frame[z.v2].AsSubNet());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	zeek::Unref(f.ManagedVal());
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_T:
	{
	zeek::Ref(frame[z.v2].AsTable());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	zeek::Unref(f.ManagedVal());
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_t:
	{
	zeek::Ref(frame[z.v2].AsType());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	zeek::Unref(f.ManagedVal());
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVi_V:
	{
	zeek::Ref(frame[z.v2].AsVector());
	auto r = frame[z.v1].AsRecord();
	auto& f = DirectField(r, z.v3);
	zeek::Unref(f.ManagedVal());
	f = frame[z.v2];
	r->Modified();
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_A:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		zeek::Ref((*v).AsAddr());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_a:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		zeek::Ref((*v).AsAny());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_U:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_D:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_f:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		zeek::Ref((*v).AsFile());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_F:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		zeek::Ref((*v).AsFunc());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_I:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_L:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		zeek::Ref((*v).AsList());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_O:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		zeek::Ref((*v).AsOpaque());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_P:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		zeek::Ref((*v).AsPattern());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_R:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		zeek::Ref((*v).AsRecord());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_S:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		zeek::Ref((*v).AsString());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_N:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		zeek::Ref((*v).AsSubNet());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_T:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		zeek::Ref((*v).AsTable());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_t:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		zeek::Ref((*v).AsType());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FVii_V:
	{
	auto v = DirectOptField(frame[z.v2].AsRecord(), z.v3); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v4); // note, LHS field after RHS field
		zeek::Ref((*v).AsVector());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_A:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		zeek::Ref((*v).AsAddr());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_a:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		zeek::Ref((*v).AsAny());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_U:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_D:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_f:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		zeek::Ref((*v).AsFile());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_F:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		zeek::Ref((*v).AsFunc());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_I:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_L:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		zeek::Ref((*v).AsList());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_O:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		zeek::Ref((*v).AsOpaque());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_P:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		zeek::Ref((*v).AsPattern());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_R:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		zeek::Ref((*v).AsRecord());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_S:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		zeek::Ref((*v).AsString());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_N:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		zeek::Ref((*v).AsSubNet());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_T:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		zeek::Ref((*v).AsTable());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_t:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		zeek::Ref((*v).AsType());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_FIELD_LHS_ASSIGN_FCii_V:
	{
	auto v = DirectOptField(z.c.AsRecord(), z.v2); // note, RHS field before LHS field
	if ( ! v )
		{
		ZAM_run_time_error(Z_LOC, "field value missing");
		}
	else
		{
		auto r = frame[z.v1].AsRecord();
		auto& f = DirectField(r, z.v3); // note, LHS field after RHS field
		zeek::Ref((*v).AsVector());
		zeek::Unref(f.ManagedVal());
		f = *v;
		r->Modified();
		}
	break;
	}
case OP_CLONE_VV:
	{
	auto v = frame[z.v2].ToVal(Z_TYPE2)->Clone();
	AssignTarget(frame[z.v1], BuildVal(v, Z_TYPE))
	}
	break;

case OP_SIZE_VV:
	{
	auto v = frame[z.v2].ToVal(Z_TYPE2)->SizeVal();
	frame[z.v1] = BuildVal(v, Z_TYPE);
	}
	break;

case OP_SIZE_VV_V:
	{
	frame[z.v1] = ZVal(zeek_uint_t(frame[z.v2].AsVector()->Size()));
	}
	break;

case OP_SIZE_VV_T:
	{
	frame[z.v1] = ZVal(zeek_uint_t(frame[z.v2].AsTable()->Size()));
	}
	break;

case OP_SIZE_VV_S:
	{
	frame[z.v1] = ZVal(zeek_uint_t(frame[z.v2].AsString()->Len()));
	}
	break;

case OP_SIZE_VV_N:
	{
	frame[z.v1] = ZVal(pow(2.0, double(128 - frame[z.v2].AsSubNet()->AsSubNet().LengthIPv6())));
	}
	break;

case OP_SIZE_VV_A:
	{
	frame[z.v1] = ZVal(zeek_uint_t(frame[z.v2].AsAddr()->AsAddr().GetFamily() == IPv4 ? 32 : 128));
	}
	break;

case OP_SIZE_VV_D:
	{
	frame[z.v1] = ZVal(frame[z.v2].AsDouble() < 0 ? -frame[z.v2].AsDouble() : frame[z.v2].AsDouble());
	}
	break;

case OP_SIZE_VV_U:
	{
	frame[z.v1] = ZVal(frame[z.v2].AsCount());
	}
	break;

case OP_SIZE_VV_I:
	{
	frame[z.v1] = ZVal(zeek_int_t(frame[z.v2].AsInt() < 0 ? -frame[z.v2].AsInt() : frame[z.v2].AsInt()));
	}
	break;

case OP_SIZE_VVi_field:
	{
	auto v = frame[z.v2].ToVal(Z_TYPE2)->SizeVal();
	DirectField(frame[z.v1].AsRecord(), z.v3) = BuildVal(v, Z_TYPE);
	}
	break;

case OP_SIZE_VVi_field_V:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3) = ZVal(zeek_uint_t(frame[z.v2].AsVector()->Size()));
	}
	break;

case OP_SIZE_VVi_field_T:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3) = ZVal(zeek_uint_t(frame[z.v2].AsTable()->Size()));
	}
	break;

case OP_SIZE_VVi_field_S:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3) = ZVal(zeek_uint_t(frame[z.v2].AsString()->Len()));
	}
	break;

case OP_SIZE_VVi_field_N:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3) = ZVal(pow(2.0, double(128 - frame[z.v2].AsSubNet()->AsSubNet().LengthIPv6())));
	}
	break;

case OP_SIZE_VVi_field_A:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3) = ZVal(zeek_uint_t(frame[z.v2].AsAddr()->AsAddr().GetFamily() == IPv4 ? 32 : 128));
	}
	break;

case OP_SIZE_VVi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3) = ZVal(frame[z.v2].AsDouble() < 0 ? -frame[z.v2].AsDouble() : frame[z.v2].AsDouble());
	}
	break;

case OP_SIZE_VVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3) = ZVal(frame[z.v2].AsCount());
	}
	break;

case OP_SIZE_VVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3) = ZVal(zeek_int_t(frame[z.v2].AsInt() < 0 ? -frame[z.v2].AsInt() : frame[z.v2].AsInt()));
	}
	break;

case OP_NOT_VC_I:
	{
	frame[z.v1].AsIntRef() = ! z.c.AsInt();
	}
	break;

case OP_NOT_VCi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v2).AsIntRef() = ! z.c.AsInt();
	}
	break;

case OP_NOT_VV_I:
	{
	frame[z.v1].AsIntRef() = ! frame[z.v2].AsInt();
	}
	break;

case OP_NOT_VVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = ! frame[z.v2].AsInt();
	}
	break;

case OP_COMPLEMENT_VC_U:
	{
	frame[z.v1].AsCountRef() = ~ z.c.AsCount();
	}
	break;

case OP_COMPLEMENT_VCi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v2).AsCountRef() = ~ z.c.AsCount();
	}
	break;

case OP_COMPLEMENT_VV_U:
	{
	frame[z.v1].AsCountRef() = ~ frame[z.v2].AsCount();
	}
	break;

case OP_COMPLEMENT_VVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = ~ frame[z.v2].AsCount();
	}
	break;

case OP_POSITIVE_VC_D:
	{
	frame[z.v1].AsDoubleRef() = z.c.AsDouble();
	}
	break;

case OP_POSITIVE_VC_U:
	{
	frame[z.v1].AsCountRef() = z.c.AsCount();
	}
	break;

case OP_POSITIVE_VC_I:
	{
	frame[z.v1].AsIntRef() = z.c.AsInt();
	}
	break;

case OP_POSITIVE_VCi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v2).AsDoubleRef() = z.c.AsDouble();
	}
	break;

case OP_POSITIVE_VCi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v2).AsCountRef() = z.c.AsCount();
	}
	break;

case OP_POSITIVE_VCi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v2).AsIntRef() = z.c.AsInt();
	}
	break;

case OP_POSITIVE_VV_D:
	{
	frame[z.v1].AsDoubleRef() = frame[z.v2].AsDouble();
	}
	break;

case OP_POSITIVE_VV_U:
	{
	frame[z.v1].AsCountRef() = frame[z.v2].AsCount();
	}
	break;

case OP_POSITIVE_VV_I:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsInt();
	}
	break;

case OP_POSITIVE_VVi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsDoubleRef() = frame[z.v2].AsDouble();
	}
	break;

case OP_POSITIVE_VVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = frame[z.v2].AsCount();
	}
	break;

case OP_POSITIVE_VVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = frame[z.v2].AsInt();
	}
	break;

case OP_POSITIVE_VV_vec_D:
	{
	vec_exec(OP_POSITIVE_VV_vec_D, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), z);
	}
	break;

case OP_POSITIVE_VV_vec_U:
	{
	vec_exec(OP_POSITIVE_VV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), z);
	}
	break;

case OP_POSITIVE_VV_vec_I:
	{
	vec_exec(OP_POSITIVE_VV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), z);
	}
	break;

case OP_NEGATE_VC_D:
	{
	frame[z.v1].AsDoubleRef() = -z.c.AsDouble();
	}
	break;

case OP_NEGATE_VC_U:
	{
	frame[z.v1].AsCountRef() = -z.c.AsCount();
	}
	break;

case OP_NEGATE_VC_I:
	{
	frame[z.v1].AsIntRef() = -z.c.AsInt();
	}
	break;

case OP_NEGATE_VCi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v2).AsDoubleRef() = -z.c.AsDouble();
	}
	break;

case OP_NEGATE_VCi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v2).AsCountRef() = -z.c.AsCount();
	}
	break;

case OP_NEGATE_VCi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v2).AsIntRef() = -z.c.AsInt();
	}
	break;

case OP_NEGATE_VV_D:
	{
	frame[z.v1].AsDoubleRef() = -frame[z.v2].AsDouble();
	}
	break;

case OP_NEGATE_VV_U:
	{
	frame[z.v1].AsCountRef() = -frame[z.v2].AsCount();
	}
	break;

case OP_NEGATE_VV_I:
	{
	frame[z.v1].AsIntRef() = -frame[z.v2].AsInt();
	}
	break;

case OP_NEGATE_VVi_field_D:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsDoubleRef() = -frame[z.v2].AsDouble();
	}
	break;

case OP_NEGATE_VVi_field_U:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsCountRef() = -frame[z.v2].AsCount();
	}
	break;

case OP_NEGATE_VVi_field_I:
	{
	DirectField(frame[z.v1].AsRecord(), z.v3).AsIntRef() = -frame[z.v2].AsInt();
	}
	break;

case OP_NEGATE_VV_vec_D:
	{
	vec_exec(OP_NEGATE_VV_vec_D, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), z);
	}
	break;

case OP_NEGATE_VV_vec_U:
	{
	vec_exec(OP_NEGATE_VV_vec_U, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), z);
	}
	break;

case OP_NEGATE_VV_vec_I:
	{
	vec_exec(OP_NEGATE_VV_vec_I, Z_TYPE, frame[z.v1].AsVectorRef(), frame[z.v2].AsVector(), z);
	}
	break;

case OP_INCRI_V:
	{
	++frame[z.v1].AsIntRef();
	}
	break;

case OP_INCRU_V:
	{
	++frame[z.v1].AsCountRef();
	}
	break;

case OP_DECRI_V:
	{
	--frame[z.v1].AsIntRef();
	}
	break;

case OP_DECRU_V:
	{
	auto& u = frame[z.v1].AsCountRef();
	if ( u == 0 )
		WARN("count underflow");
	--u;
	}
	break;

case OP_APPENDTO_VC:
	{
	auto vv = frame[z.v1].AsVector();
	if ( vv->Size() == 0 )
		/* Use the slightly more expensive Assign(), since it
		 * knows how to deal with empty vectors that do not yet
		 * have concrete types.
		 */
		vv->Assign(0, z.c.ToVal(Z_TYPE));
	else
		{
		vv->RawVec().emplace_back(CopyVal(z.c));
		vv->Modified();
		}
	}
	break;

case OP_APPENDTO_VV:
	{
	auto vv = frame[z.v1].AsVector();
	if ( vv->Size() == 0 )
		/* Use the slightly more expensive Assign(), since it
		 * knows how to deal with empty vectors that do not yet
		 * have concrete types.
		 */
		vv->Assign(0, frame[z.v2].ToVal(Z_TYPE));
	else
		{
		vv->RawVec().emplace_back(CopyVal(frame[z.v2]));
		vv->Modified();
		}
	}
	break;

case OP_APPENDTOANYVEC_VC:
	{
	auto vv = frame[z.v1].AsVector();
	vv->Assign(vv->Size(), z.c.ToVal(Z_TYPE));
	}
	break;

case OP_APPENDTOANYVEC_VV:
	{
	auto vv = frame[z.v1].AsVector();
	vv->Assign(vv->Size(), frame[z.v2].ToVal(Z_TYPE));
	}
	break;

case OP_ADDPATTERNTOFIELD_VVi:
	{
	auto r = frame[z.v1].AsRecordRef();
	auto field = RecordField(frame[z.v1].AsRecordRef(), z.v3);
	auto fpat = r->GetField(field)->AsPatternVal();
	if ( fpat )
		{
		frame[z.v2].AsPattern()->AddTo(fpat, false);
		r->Modified();
		}
	else
		ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
	}
	break;

case OP_ADDPATTERNTOFIELD_VCi:
	{
	auto r = frame[z.v1].AsRecordRef();
	auto field = RecordField(frame[z.v1].AsRecordRef(), z.v2);
	auto fpat = r->GetField(field)->AsPatternVal();
	if ( fpat )
		{
		z.c.AsPattern()->AddTo(fpat, false);
		r->Modified();
		}
	else
		ERROR(util::fmt("field value missing: $%s", r->GetType()->AsRecordType()->FieldName(field)));
	}
	break;

case OP_EXTENDPATTERN_VC:
	{
	z.c.AsPattern()->AddTo(frame[z.v1].AsPattern(), false);
	}
	break;

case OP_EXTENDPATTERN_VV:
	{
	frame[z.v2].AsPattern()->AddTo(frame[z.v1].AsPattern(), false);
	}
	break;

case OP_ADDVECTOVEC_VC:
	{
	if ( ! z.c.AsVector()->AddTo(frame[z.v1].AsVector(), false) )
		ERROR("incompatible vector element assignment");
	}
	break;

case OP_ADDVECTOVEC_VV:
	{
	if ( ! frame[z.v2].AsVector()->AddTo(frame[z.v1].AsVector(), false) )
		ERROR("incompatible vector element assignment");
	}
	break;

case OP_ADDTABLETOTABLE_VC:
	{
	auto t = frame[z.v1].AsTable();
	auto v = z.c.AsTable();
	if ( v->Size() > 0 )
		{
		v->AddTo(t, false);
		t->Modified();
		}
	}
	break;

case OP_ADDTABLETOTABLE_VV:
	{
	auto t = frame[z.v1].AsTable();
	auto v = frame[z.v2].AsTable();
	if ( v->Size() > 0 )
		{
		v->AddTo(t, false);
		t->Modified();
		}
	}
	break;

case OP_REMOVETABLEFROMTABLE_VC:
	{
	auto t = frame[z.v1].AsTable();
	auto v = z.c.AsTable();
	if ( v->Size() > 0 )
		{
		v->RemoveFrom(t);
		t->Modified();
		}
	}
	break;

case OP_REMOVETABLEFROMTABLE_VV:
	{
	auto t = frame[z.v1].AsTable();
	auto v = frame[z.v2].AsTable();
	if ( v->Size() > 0 )
		{
		v->RemoveFrom(t);
		t->Modified();
		}
	}
	break;

case OP_CAST_VC:
	{
	EvalCast(frame[z.v1], z.c.ToVal(Z_TYPE2))
	}
	break;

case OP_CAST_VV:
	{
	EvalCast(frame[z.v1], frame[z.v2].ToVal(Z_TYPE2))
	}
	break;

case OP_IS_VV:
	{
	auto rhs = frame[z.v2].ToVal(Z_TYPE2).get();
	frame[z.v1].AsIntRef() = can_cast_value_to_type(rhs, Z_TYPE.get());
	}
	break;

case OP_SET_FILE_HANDLE_V:
	{
	ZAM::file_mgr_set_handle(frame[z.v1].AsString());
	}
	break;

case OP_SUBNET_TO_ADDR_VV:
	{
	auto addr_v = make_intrusive<AddrVal>(frame[z.v2].AsSubNet()->Prefix());
	ZVal::DeleteManagedType(frame[z.v1]);
	frame[z.v1] = ZVal(std::move(addr_v));
	}
	break;

case OP_SUB_BYTES_VVVV:
	{
	EvalSubBytes(frame[z.v1].AsStringRef(), frame[z.v2].AsString(), frame[z.v3].AsCount(), frame[z.v4].AsInt())
	}
	break;

case OP_SUB_BYTES_VVVC:
	{
	EvalSubBytes(frame[z.v1].AsStringRef(), frame[z.v2].AsString(), frame[z.v3].AsCount(), z.c.AsInt())
	}
	break;

case OP_SUB_BYTES_VVCV:
	{
	EvalSubBytes(frame[z.v1].AsStringRef(), frame[z.v2].AsString(), z.c.AsCount(), frame[z.v3].AsInt())
	}
	break;

case OP_SUB_BYTES_VCVV:
	{
	EvalSubBytes(frame[z.v1].AsStringRef(), z.c.AsString(), frame[z.v2].AsCount(), frame[z.v3].AsInt())
	}
	break;

case OP_SUB_BYTES_VVCi:
	{
	EvalSubBytes(frame[z.v1].AsStringRef(), frame[z.v2].AsString(), z.c.AsCount(), z.v3)
	}
	break;

case OP_SUB_BYTES_VCVi:
	{
	EvalSubBytes(frame[z.v1].AsStringRef(), z.c.AsString(), frame[z.v2].AsCount(), z.v3)
	}
	break;

case OP_SUB_BYTES2_VCVi:
	{
	EvalSubBytes(frame[z.v1].AsStringRef(), z.c.AsString(), zeek_uint_t(z.v3), frame[z.v2].AsInt())
	}
	break;

case OP_TIME_TO_DOUBLE_VV:
	{
	frame[z.v1].AsDoubleRef() = frame[z.v2].AsDouble();
	}
	break;

case OP_TO_LOWER_VV:
	{
	auto sv = ZAM_to_lower(frame[z.v2].AsString());
	Unref(frame[z.v1].AsStringRef());
	frame[z.v1].AsStringRef() = sv;
	}
	break;

case OP_LOG_WRITE_VVV:
	{
	LogWritePre(LogEnum(frame[z.v2]), frame[z.v3].AsRecord())
	LogWriteResPost(frame[z.v1].AsIntRef())
	}
	break;

case OP_LOG_WRITEC_VCV:
	{
	LogWritePre(LogEnum(z.c), frame[z.v2].AsRecord())
	LogWriteResPost(frame[z.v1].AsIntRef())
	}
	break;

case OP_LOG_WRITE_VV:
	{
	LogWritePre(LogEnum(frame[z.v1]), frame[z.v2].AsRecord())
	(void) ZAM::log_mgr_write(id->AsEnumVal(), columns->AsRecordVal());
	}
	break;

case OP_LOG_WRITE_CV:
	{
	LogWritePre(LogEnum(z.c), frame[z.v1].AsRecord())
	(void) ZAM::log_mgr_write(id->AsEnumVal(), columns->AsRecordVal());
	}
	break;

case OP_BROKER_FLUSH_LOGS_V:
	{
	frame[z.v1].AsCountRef() = ZAM::broker_mgr_flush_log_buffers();
	}
	break;

case OP_BROKER_FLUSH_LOGS_X:
	{
	(void) ZAM::broker_mgr_flush_log_buffers();
	}
	break;

case OP_GET_PORT_TRANSPORT_PROTO_VV:
	{
	auto mask = frame[z.v2].AsCount() & PORT_SPACE_MASK;
	auto v = 0; /* TRANSPORT_UNKNOWN */
	if ( mask == TCP_PORT_MASK )
		v = 1;
	else if ( mask == UDP_PORT_MASK )
		v = 2;
	else if ( mask == ICMP_PORT_MASK )
		v = 3;
	frame[z.v1].AsCountRef() = v;
	}
	break;

case OP_CONN_EXISTS_VV:
	{
	frame[z.v1].AsIntRef() = ZAM::session_mgr_find_connection(frame[z.v2].AsRecord()) != nullptr;
	}
	break;

case OP_CONN_EXISTS_COND_Vb:
	{
	if ( ! (ZAM::session_mgr_find_connection(frame[z.v1].AsRecord()) != nullptr) )
		Branch(z.v2)
	}
	break;

case OP_NOT_CONN_EXISTS_COND_Vb:
	{
	if ( (ZAM::session_mgr_find_connection(frame[z.v1].AsRecord()) != nullptr) )
		Branch(z.v2)
	}
	break;

case OP_LOOKUP_CONN_VV:
	{
	auto cid = frame[z.v2].AsRecord();
	Connection* conn = ZAM::session_mgr_find_connection(cid);
	ValPtr res;
	if ( conn )
		res = conn->GetVal();
	else
		{
		emit_builtin_error("connection ID not a known connection", cid);
		res = build_dummy_conn_record();
		}
	AssignTarget(frame[z.v1], ZVal(res, res->GetType()));
	}
	break;

case OP_IS_ICMP_PORT_VV:
	{
	frame[z.v1].AsIntRef() = (frame[z.v2].AsCount() & PORT_SPACE_MASK) == ICMP_PORT_MASK;
	}
	break;

case OP_IS_ICMP_PORT_COND_Vb:
	{
	if ( ! ((frame[z.v1].AsCount() & PORT_SPACE_MASK) == ICMP_PORT_MASK) )
		Branch(z.v2)
	}
	break;

case OP_NOT_IS_ICMP_PORT_COND_Vb:
	{
	if ( ((frame[z.v1].AsCount() & PORT_SPACE_MASK) == ICMP_PORT_MASK) )
		Branch(z.v2)
	}
	break;

case OP_IS_TCP_PORT_VV:
	{
	frame[z.v1].AsIntRef() = (frame[z.v2].AsCount() & PORT_SPACE_MASK) == TCP_PORT_MASK;
	}
	break;

case OP_IS_TCP_PORT_COND_Vb:
	{
	if ( ! ((frame[z.v1].AsCount() & PORT_SPACE_MASK) == TCP_PORT_MASK) )
		Branch(z.v2)
	}
	break;

case OP_NOT_IS_TCP_PORT_COND_Vb:
	{
	if ( ((frame[z.v1].AsCount() & PORT_SPACE_MASK) == TCP_PORT_MASK) )
		Branch(z.v2)
	}
	break;

case OP_IS_UDP_PORT_VV:
	{
	frame[z.v1].AsIntRef() = (frame[z.v2].AsCount() & PORT_SPACE_MASK) == UDP_PORT_MASK;
	}
	break;

case OP_IS_UDP_PORT_COND_Vb:
	{
	if ( ! ((frame[z.v1].AsCount() & PORT_SPACE_MASK) == UDP_PORT_MASK) )
		Branch(z.v2)
	}
	break;

case OP_NOT_IS_UDP_PORT_COND_Vb:
	{
	if ( ((frame[z.v1].AsCount() & PORT_SPACE_MASK) == UDP_PORT_MASK) )
		Branch(z.v2)
	}
	break;

case OP_IS_V4_ADDR_VV:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsAddr()->AsAddr().GetFamily() == IPv4;
	}
	break;

case OP_IS_V4_ADDR_COND_Vb:
	{
	if ( ! (frame[z.v1].AsAddr()->AsAddr().GetFamily() == IPv4) )
		Branch(z.v2)
	}
	break;

case OP_NOT_IS_V4_ADDR_COND_Vb:
	{
	if ( (frame[z.v1].AsAddr()->AsAddr().GetFamily() == IPv4) )
		Branch(z.v2)
	}
	break;

case OP_IS_V6_ADDR_VV:
	{
	frame[z.v1].AsIntRef() = frame[z.v2].AsAddr()->AsAddr().GetFamily() == IPv6;
	}
	break;

case OP_IS_V6_ADDR_COND_Vb:
	{
	if ( ! (frame[z.v1].AsAddr()->AsAddr().GetFamily() == IPv6) )
		Branch(z.v2)
	}
	break;

case OP_NOT_IS_V6_ADDR_COND_Vb:
	{
	if ( (frame[z.v1].AsAddr()->AsAddr().GetFamily() == IPv6) )
		Branch(z.v2)
	}
	break;

case OP_NETWORK_TIME_V:
	{
	frame[z.v1].AsDoubleRef() = run_state::network_time;
	}
	break;

case OP_CURRENT_TIME_V:
	{
	frame[z.v1].AsDoubleRef() = util::current_time();
	}
	break;

case OP_READING_LIVE_TRAFFIC_V:
	{
	frame[z.v1].AsIntRef() = run_state::reading_live;
	}
	break;

case OP_READING_LIVE_TRAFFIC_COND_b:
	{
	if ( ! (run_state::reading_live) )
		Branch(z.v1)
	}
	break;

case OP_NOT_READING_LIVE_TRAFFIC_COND_b:
	{
	if ( (run_state::reading_live) )
		Branch(z.v1)
	}
	break;

case OP_READING_TRACES_V:
	{
	frame[z.v1].AsIntRef() = run_state::reading_traces;
	}
	break;

case OP_READING_TRACES_COND_b:
	{
	if ( ! (run_state::reading_traces) )
		Branch(z.v1)
	}
	break;

case OP_NOT_READING_TRACES_COND_b:
	{
	if ( (run_state::reading_traces) )
		Branch(z.v1)
	}
	break;

case OP_SORT_V:
	{
	if ( frame[z.v1].AsVector()->Size() > 1 )
		frame[z.v1].AsVector()->Sort();
	}
	break;

case OP_SORT_VV:
	{
	auto vv = frame[z.v2].AsVector();
	if ( vv->Size() > 1 )
		vv->Sort();
	zeek::Ref(vv);
	Unref(frame[z.v1].AsVectorRef());
	frame[z.v1].AsVectorRef() = vv;
	}
	break;

case OP_SORT_WITH_CMP_VV:
	{
	if ( frame[z.v1].AsVector()->Size() > 1 )
		frame[z.v1].AsVector()->Sort(frame[z.v2].AsFunc());
	}
	break;

case OP_SORT_WITH_CMP_VVV:
	{
	auto vv = frame[z.v2].AsVector();
	if ( vv->Size() > 1 )
		vv->Sort(frame[z.v3].AsFunc());
	zeek::Ref(vv);
	Unref(frame[z.v1].AsVectorRef());
	frame[z.v1].AsVectorRef() = vv;
	}
	break;

case OP_STARTS_WITH_VVV:
	{
	auto str = frame[z.v2].AsString();
	auto sub = frame[z.v3].AsString();
	auto str_n = str->Len();
	auto sub_n = sub->Len();
	if ( str_n < sub_n )
		frame[z.v1].AsIntRef() = 0;
	else
		{
		auto str_b = str->Bytes();
		auto sub_b = sub->Bytes();
		int i;
		for ( i = 0; i < sub_n; ++i )
			if ( str_b[i] != sub_b[i] )
				break;
		frame[z.v1].AsIntRef() = i == sub_n;
		}
	}
	break;

case OP_STARTS_WITH_VCV:
	{
	auto str = z.c.AsString();
	auto sub = frame[z.v2].AsString();
	auto str_n = str->Len();
	auto sub_n = sub->Len();
	if ( str_n < sub_n )
		frame[z.v1].AsIntRef() = 0;
	else
		{
		auto str_b = str->Bytes();
		auto sub_b = sub->Bytes();
		int i;
		for ( i = 0; i < sub_n; ++i )
			if ( str_b[i] != sub_b[i] )
				break;
		frame[z.v1].AsIntRef() = i == sub_n;
		}
	}
	break;

case OP_STARTS_WITH_VVC:
	{
	auto str = frame[z.v2].AsString();
	auto sub = z.c.AsString();
	auto str_n = str->Len();
	auto sub_n = sub->Len();
	if ( str_n < sub_n )
		frame[z.v1].AsIntRef() = 0;
	else
		{
		auto str_b = str->Bytes();
		auto sub_b = sub->Bytes();
		int i;
		for ( i = 0; i < sub_n; ++i )
			if ( str_b[i] != sub_b[i] )
				break;
		frame[z.v1].AsIntRef() = i == sub_n;
		}
	}
	break;

case OP_STRCMP_VVV:
	{
	auto s1 = frame[z.v2].AsString();
	auto s2 = frame[z.v3].AsString();
	frame[z.v1].AsIntRef() = Bstr_cmp(s1->AsString(), s2->AsString());
	}
	break;

case OP_STRCMP_VCV:
	{
	auto s1 = z.c.AsString();
	auto s2 = frame[z.v2].AsString();
	frame[z.v1].AsIntRef() = Bstr_cmp(s1->AsString(), s2->AsString());
	}
	break;

case OP_STRCMP_VVC:
	{
	auto s1 = frame[z.v2].AsString();
	auto s2 = z.c.AsString();
	frame[z.v1].AsIntRef() = Bstr_cmp(s1->AsString(), s2->AsString());
	}
	break;

case OP_STRSTR_VVV:
	{
	auto big = frame[z.v2].AsString();
	auto little = frame[z.v3].AsString();
	frame[z.v1].AsIntRef() = 1 + big->AsString()->FindSubstring(little->AsString());
	}
	break;

case OP_STRSTR_VCV:
	{
	auto big = z.c.AsString();
	auto little = frame[z.v2].AsString();
	frame[z.v1].AsIntRef() = 1 + big->AsString()->FindSubstring(little->AsString());
	}
	break;

case OP_STRSTR_VVC:
	{
	auto big = frame[z.v2].AsString();
	auto little = z.c.AsString();
	frame[z.v1].AsIntRef() = 1 + big->AsString()->FindSubstring(little->AsString());
	}
	break;

case OP_CAT1_VV:
	{
	Cat1Op(frame[z.v1], frame[z.v2])
	zeek::Ref(v1.AsString());
	}
	break;

case OP_CAT1_VC:
	{
	Cat1Op(frame[z.v1], z.c)
	zeek::Ref(v1.AsString());
	}
	break;

case OP_CAT1FULL_VV:
	{
	auto formatted_val = ZVal(ZAM_val_cat(frame[z.v2].ToVal(Z_TYPE)));
	Cat1Op(frame[z.v1], formatted_val)
	}
	break;

case OP_CAT1FULL_VC:
	{
	auto formatted_val = ZVal(ZAM_val_cat(z.c.ToVal(Z_TYPE)));
	Cat1Op(frame[z.v1], formatted_val)
	}
	break;

case OP_CATN_V:
	{
	CatNPre()
	int n = aux->n;
	size_t max_size = 0;
	for ( int i = 0; i < n; ++i )
		max_size += ca[i]->MaxSize(aux->elems[i].ToDirectZVal(frame));
	auto res = new char[max_size + /* slop */ n + 1];
	auto res_p = res;
	for ( int i = 0; i < n; ++i )
		ca[i]->RenderInto(aux->elems[i].ToDirectZVal(frame), res_p);
	*res_p = '\0';
	auto s = new String(true, reinterpret_cast<byte_vec>(res), res_p - res);
	Cat1Op(frame[z.v1], ZVal(new StringVal(s)))
	}
	break;

case OP_CAT2_V:
	{
	CatNPre()
	size_t max_size = ca[0]->MaxSize(aux->elems[0].ToDirectZVal(frame));
	max_size += ca[1]->MaxSize(aux->elems[1].ToDirectZVal(frame));
	CatNMid()
	ca[0]->RenderInto(aux->elems[0].ToDirectZVal(frame), res_p);
	ca[1]->RenderInto(aux->elems[1].ToDirectZVal(frame), res_p);
	CatNPost(frame[z.v1])
	}
	break;

case OP_CAT3_V:
	{
	CatNPre()
	size_t max_size = ca[0]->MaxSize(aux->elems[0].ToDirectZVal(frame));
	max_size += ca[1]->MaxSize(aux->elems[1].ToDirectZVal(frame));
	max_size += ca[2]->MaxSize(aux->elems[2].ToDirectZVal(frame));
	CatNMid()
	ca[0]->RenderInto(aux->elems[0].ToDirectZVal(frame), res_p);
	ca[1]->RenderInto(aux->elems[1].ToDirectZVal(frame), res_p);
	ca[2]->RenderInto(aux->elems[2].ToDirectZVal(frame), res_p);
	CatNPost(frame[z.v1])
	}
	break;

case OP_CAT4_V:
	{
	CatNPre()
	size_t max_size = ca[0]->MaxSize(aux->elems[0].ToDirectZVal(frame));
	max_size += ca[1]->MaxSize(aux->elems[1].ToDirectZVal(frame));
	max_size += ca[2]->MaxSize(aux->elems[2].ToDirectZVal(frame));
	max_size += ca[3]->MaxSize(aux->elems[3].ToDirectZVal(frame));
	CatNMid()
	ca[0]->RenderInto(aux->elems[0].ToDirectZVal(frame), res_p);
	ca[1]->RenderInto(aux->elems[1].ToDirectZVal(frame), res_p);
	ca[2]->RenderInto(aux->elems[2].ToDirectZVal(frame), res_p);
	ca[3]->RenderInto(aux->elems[3].ToDirectZVal(frame), res_p);
	CatNPost(frame[z.v1])
	}
	break;

case OP_CAT5_V:
	{
	CatNPre()
	size_t max_size = ca[0]->MaxSize(aux->elems[0].ToDirectZVal(frame));
	max_size += ca[1]->MaxSize(aux->elems[1].ToDirectZVal(frame));
	max_size += ca[2]->MaxSize(aux->elems[2].ToDirectZVal(frame));
	max_size += ca[3]->MaxSize(aux->elems[3].ToDirectZVal(frame));
	max_size += ca[4]->MaxSize(aux->elems[4].ToDirectZVal(frame));
	CatNMid()
	ca[0]->RenderInto(aux->elems[0].ToDirectZVal(frame), res_p);
	ca[1]->RenderInto(aux->elems[1].ToDirectZVal(frame), res_p);
	ca[2]->RenderInto(aux->elems[2].ToDirectZVal(frame), res_p);
	ca[3]->RenderInto(aux->elems[3].ToDirectZVal(frame), res_p);
	ca[4]->RenderInto(aux->elems[4].ToDirectZVal(frame), res_p);
	CatNPost(frame[z.v1])
	}
	break;

case OP_CAT6_V:
	{
	CatNPre()
	size_t max_size = ca[0]->MaxSize(aux->elems[0].ToDirectZVal(frame));
	max_size += ca[1]->MaxSize(aux->elems[1].ToDirectZVal(frame));
	max_size += ca[2]->MaxSize(aux->elems[2].ToDirectZVal(frame));
	max_size += ca[3]->MaxSize(aux->elems[3].ToDirectZVal(frame));
	max_size += ca[4]->MaxSize(aux->elems[4].ToDirectZVal(frame));
	max_size += ca[5]->MaxSize(aux->elems[5].ToDirectZVal(frame));
	CatNMid()
	ca[0]->RenderInto(aux->elems[0].ToDirectZVal(frame), res_p);
	ca[1]->RenderInto(aux->elems[1].ToDirectZVal(frame), res_p);
	ca[2]->RenderInto(aux->elems[2].ToDirectZVal(frame), res_p);
	ca[3]->RenderInto(aux->elems[3].ToDirectZVal(frame), res_p);
	ca[4]->RenderInto(aux->elems[4].ToDirectZVal(frame), res_p);
	ca[5]->RenderInto(aux->elems[5].ToDirectZVal(frame), res_p);
	CatNPost(frame[z.v1])
	}
	break;

case OP_CAT7_V:
	{
	CatNPre()
	size_t max_size = ca[0]->MaxSize(aux->elems[0].ToDirectZVal(frame));
	max_size += ca[1]->MaxSize(aux->elems[1].ToDirectZVal(frame));
	max_size += ca[2]->MaxSize(aux->elems[2].ToDirectZVal(frame));
	max_size += ca[3]->MaxSize(aux->elems[3].ToDirectZVal(frame));
	max_size += ca[4]->MaxSize(aux->elems[4].ToDirectZVal(frame));
	max_size += ca[5]->MaxSize(aux->elems[5].ToDirectZVal(frame));
	max_size += ca[6]->MaxSize(aux->elems[6].ToDirectZVal(frame));
	CatNMid()
	ca[0]->RenderInto(aux->elems[0].ToDirectZVal(frame), res_p);
	ca[1]->RenderInto(aux->elems[1].ToDirectZVal(frame), res_p);
	ca[2]->RenderInto(aux->elems[2].ToDirectZVal(frame), res_p);
	ca[3]->RenderInto(aux->elems[3].ToDirectZVal(frame), res_p);
	ca[4]->RenderInto(aux->elems[4].ToDirectZVal(frame), res_p);
	ca[5]->RenderInto(aux->elems[5].ToDirectZVal(frame), res_p);
	ca[6]->RenderInto(aux->elems[6].ToDirectZVal(frame), res_p);
	CatNPost(frame[z.v1])
	}
	break;

case OP_CAT8_V:
	{
	CatNPre()
	size_t max_size = ca[0]->MaxSize(aux->elems[0].ToDirectZVal(frame));
	max_size += ca[1]->MaxSize(aux->elems[1].ToDirectZVal(frame));
	max_size += ca[2]->MaxSize(aux->elems[2].ToDirectZVal(frame));
	max_size += ca[3]->MaxSize(aux->elems[3].ToDirectZVal(frame));
	max_size += ca[4]->MaxSize(aux->elems[4].ToDirectZVal(frame));
	max_size += ca[5]->MaxSize(aux->elems[5].ToDirectZVal(frame));
	max_size += ca[6]->MaxSize(aux->elems[6].ToDirectZVal(frame));
	max_size += ca[7]->MaxSize(aux->elems[7].ToDirectZVal(frame));
	CatNMid()
	ca[0]->RenderInto(aux->elems[0].ToDirectZVal(frame), res_p);
	ca[1]->RenderInto(aux->elems[1].ToDirectZVal(frame), res_p);
	ca[2]->RenderInto(aux->elems[2].ToDirectZVal(frame), res_p);
	ca[3]->RenderInto(aux->elems[3].ToDirectZVal(frame), res_p);
	ca[4]->RenderInto(aux->elems[4].ToDirectZVal(frame), res_p);
	ca[5]->RenderInto(aux->elems[5].ToDirectZVal(frame), res_p);
	ca[6]->RenderInto(aux->elems[6].ToDirectZVal(frame), res_p);
	ca[7]->RenderInto(aux->elems[7].ToDirectZVal(frame), res_p);
	CatNPost(frame[z.v1])
	}
	break;

case OP_ANALYZER_NAME_VV:
	{
	Unref(frame[z.v1].AsStringRef());
	frame[z.v1].AsStringRef() = ZAM::analyzer_name(frame[z.v2].ToVal(Z_TYPE)->AsEnumVal());
	}
	break;

case OP_ANALYZER_NAME_VC:
	{
	Unref(frame[z.v1].AsStringRef());
	frame[z.v1].AsStringRef() = ZAM::analyzer_name(z.c.ToVal(Z_TYPE)->AsEnumVal());
	}
	break;

case OP_FILES_ADD_ANALYZER_VVV:
	{
	ZAM::file_mgr_add_analyzer(frame[z.v1].AsString(), frame[z.v2].ToVal(Z_TYPE)->AsEnumVal(), frame[z.v3].AsRecord());
	}
	break;

case OP_FILES_ADD_ANALYZER_VCV:
	{
	ZAM::file_mgr_add_analyzer(frame[z.v1].AsString(), z.c.ToVal(Z_TYPE)->AsEnumVal(), frame[z.v2].AsRecord());
	}
	break;

case OP_FILES_ADD_ANALYZER_VVVV:
	{
	frame[z.v1].AsIntRef() = ZAM::file_mgr_add_analyzer(frame[z.v2].AsString(), frame[z.v3].ToVal(Z_TYPE)->AsEnumVal(), frame[z.v4].AsRecord());
	}
	break;

case OP_FILES_ADD_ANALYZER_VVCV:
	{
	frame[z.v1].AsIntRef() = ZAM::file_mgr_add_analyzer(frame[z.v2].AsString(), z.c.ToVal(Z_TYPE)->AsEnumVal(), frame[z.v3].AsRecord());
	}
	break;

case OP_FILES_REMOVE_ANALYZER_VVV:
	{
	ZAM::file_mgr_remove_analyzer(frame[z.v1].AsString(), frame[z.v2].ToVal(Z_TYPE)->AsEnumVal(), frame[z.v3].AsRecord());
	}
	break;

case OP_FILES_REMOVE_ANALYZER_VCV:
	{
	ZAM::file_mgr_remove_analyzer(frame[z.v1].AsString(), z.c.ToVal(Z_TYPE)->AsEnumVal(), frame[z.v2].AsRecord());
	}
	break;

case OP_FILES_REMOVE_ANALYZER_VVVV:
	{
	frame[z.v1].AsIntRef() = ZAM::file_mgr_remove_analyzer(frame[z.v2].AsString(), frame[z.v3].ToVal(Z_TYPE)->AsEnumVal(), frame[z.v4].AsRecord());
	}
	break;

case OP_FILES_REMOVE_ANALYZER_VVCV:
	{
	frame[z.v1].AsIntRef() = ZAM::file_mgr_remove_analyzer(frame[z.v2].AsString(), z.c.ToVal(Z_TYPE)->AsEnumVal(), frame[z.v3].AsRecord());
	}
	break;

case OP_ANALYZER_ENABLED_VV:
	{
	frame[z.v1].AsIntRef() = ZAM::file_mgr_analyzer_enabled(frame[z.v2].ToVal(Z_TYPE)->AsEnumVal());
	}
	break;

case OP_ANALYZER_ENABLED_VC:
	{
	frame[z.v1].AsIntRef() = ZAM::file_mgr_analyzer_enabled(z.c.ToVal(Z_TYPE)->AsEnumVal());
	}
	break;

case OP_FILE_ANALYZER_NAME_VV:
	{
	auto atype = frame[z.v2].ToVal(Z_TYPE);
	Unref(frame[z.v1].AsString());
	frame[z.v1] = ZVal(ZAM::file_mgr_analyzer_name(atype->AsEnumVal()));
	}
	break;

case OP_FILE_ANALYZER_NAME_VC:
	{
	auto atype = z.c.ToVal(Z_TYPE);
	Unref(frame[z.v1].AsString());
	frame[z.v1] = ZVal(ZAM::file_mgr_analyzer_name(atype->AsEnumVal()));
	}
	break;

case OP_IS_PROTOCOL_ANALYZER_VV:
	{
	auto atype = frame[z.v2].ToVal(Z_TYPE);
	frame[z.v1].AsIntRef() = ZAM::analyzer_mgr_lookup(atype->AsEnumVal()) != nullptr;
	}
	break;

case OP_IS_PROTOCOL_ANALYZER_VC:
	{
	auto atype = z.c.ToVal(Z_TYPE);
	frame[z.v1].AsIntRef() = ZAM::analyzer_mgr_lookup(atype->AsEnumVal()) != nullptr;
	}
	break;

case OP_CLEAR_TABLE_V:
	{
	frame[z.v1].AsTable()->RemoveAll();
	}
	break;

case OP_FILES_ENABLE_REASSEMBLY_V:
	{
	ZAM::file_mgr_enable_reassembly(frame[z.v1].AsString());
	}
	break;

case OP_FILES_SET_REASSEMBLY_BUFFER_VV:
	{
	ZAM::file_mgr_set_reassembly_buffer(frame[z.v1].AsString(), frame[z.v2].AsCount());
	}
	break;

case OP_FILES_SET_REASSEMBLY_BUFFER_Vi:
	{
	ZAM::file_mgr_set_reassembly_buffer(frame[z.v1].AsString(), zeek_uint_t(z.v2));
	}
	break;

case OP_FILES_SET_REASSEMBLY_BUFFER_VVV:
	{
	frame[z.v1].AsIntRef() = ZAM::file_mgr_set_reassembly_buffer(frame[z.v2].AsString(), frame[z.v3].AsCount());
	}
	break;

case OP_FILES_SET_REASSEMBLY_BUFFER_VVi:
	{
	frame[z.v1].AsIntRef() = ZAM::file_mgr_set_reassembly_buffer(frame[z.v2].AsString(), zeek_uint_t(z.v3));
	}
	break;

case OP_TELEMETRY_COUNTER_INC_VV:
	{
	bool result;
	TelemetryCounterInc(result, frame[z.v1].AsOpaque(), frame[z.v2].AsDouble())
	}
	break;

case OP_TELEMETRY_COUNTER_INC_VC:
	{
	bool result;
	TelemetryCounterInc(result, frame[z.v1].AsOpaque(), z.c.AsDouble())
	}
	break;

case OP_TELEMETRY_COUNTER_INC_VVV:
	{
	TelemetryCounterInc(frame[z.v1].AsIntRef(), frame[z.v2].AsOpaque(), frame[z.v3].AsDouble())
	}
	break;

case OP_TELEMETRY_COUNTER_INC_VVC:
	{
	TelemetryCounterInc(frame[z.v1].AsIntRef(), frame[z.v2].AsOpaque(), z.c.AsDouble())
	}
	break;

case OP_GET_BYTES_THRESH_VVV:
	{
	frame[z.v1].AsCountRef() = ZAM::conn_size_get_bytes_threshold(frame[z.v2].AsRecord(), frame[z.v3].AsInt());
	}
	break;

case OP_GET_BYTES_THRESH_VVC:
	{
	frame[z.v1].AsCountRef() = ZAM::conn_size_get_bytes_threshold(frame[z.v2].AsRecord(), z.c.AsInt());
	}
	break;

case OP_SET_BYTES_THRESH_VVV:
	{
	SetBytesThresh(frame[z.v1].AsRecord(), frame[z.v2].AsCount(), frame[z.v3].AsInt())
	}
	break;

case OP_SET_BYTES_THRESH_VVC:
	{
	SetBytesThresh(frame[z.v1].AsRecord(), frame[z.v2].AsCount(), z.c.AsInt())
	}
	break;

case OP_SET_BYTES_THRESH_VCV:
	{
	SetBytesThresh(frame[z.v1].AsRecord(), z.c.AsCount(), frame[z.v2].AsInt())
	}
	break;

case OP_SET_BYTES_THRESH_VCi:
	{
	SetBytesThresh(frame[z.v1].AsRecord(), z.c.AsCount(), z.v2)
	}
	break;

case OP_SET_BYTES_THRESH_VVVV:
	{
	SetBytesThresh(frame[z.v2].AsRecord(), frame[z.v3].AsCount(), frame[z.v4].AsInt())
	frame[z.v1].AsIntRef() = res;
	}
	break;

case OP_SET_BYTES_THRESH_VVVC:
	{
	SetBytesThresh(frame[z.v2].AsRecord(), frame[z.v3].AsCount(), z.c.AsInt())
	frame[z.v1].AsIntRef() = res;
	}
	break;

case OP_SET_BYTES_THRESH_VVCV:
	{
	SetBytesThresh(frame[z.v2].AsRecord(), z.c.AsCount(), frame[z.v3].AsInt())
	frame[z.v1].AsIntRef() = res;
	}
	break;

case OP_SET_BYTES_THRESH_VVCi:
	{
	SetBytesThresh(frame[z.v2].AsRecord(), z.c.AsCount(), z.v3)
	frame[z.v1].AsIntRef() = res;
	}
	break;

// NOLINTEND(bugprone-branch-clone)
