case OP_ADD_VVV_vec_S:
	{
	auto hold_lhs = vec1[i] ? vec1[i]->ManagedVal() : nullptr;
	vector<const String*> strings;
		strings.push_back(vec2[i]->AsString()->AsString());
		strings.push_back(vec3[i]->AsString()->AsString());
		auto res = new StringVal(concatenate(strings));
		vec1[i] = ZVal(res);
	Unref(hold_lhs);
	}
	break;

case OP_ADD_VVV_vec_D:
	{
	vec1[i] = ZVal(vec2[i]->AsDouble() + vec3[i]->AsDouble());
	}
	break;

case OP_ADD_VVV_vec_U:
	{
	vec1[i] = ZVal(vec2[i]->AsCount() + vec3[i]->AsCount());
	}
	break;

case OP_ADD_VVV_vec_I:
	{
	vec1[i] = ZVal(vec2[i]->AsInt() + vec3[i]->AsInt());
	}
	break;

case OP_SUB_VVV_vec_T:
	{
	auto hold_lhs = vec1[i] ? vec1[i]->ManagedVal() : nullptr;
	auto v = vec2[i]->AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		vec3[i]->AsTable()->RemoveFrom(s);
		vec1[i] = ZVal(s);
	Unref(hold_lhs);
	}
	break;

case OP_SUB_VVV_vec_D:
	{
	vec1[i] = ZVal(vec2[i]->AsDouble() - vec3[i]->AsDouble());
	}
	break;

case OP_SUB_VVV_vec_U:
	{
	vec1[i] = ZVal(vec2[i]->AsCount() - vec3[i]->AsCount());
	}
	break;

case OP_SUB_VVV_vec_I:
	{
	vec1[i] = ZVal(vec2[i]->AsInt() - vec3[i]->AsInt());
	}
	break;

case OP_TIMES_VVV_vec_D:
	{
	vec1[i] = ZVal(vec2[i]->AsDouble() * vec3[i]->AsDouble());
	}
	break;

case OP_TIMES_VVV_vec_U:
	{
	vec1[i] = ZVal(vec2[i]->AsCount() * vec3[i]->AsCount());
	}
	break;

case OP_TIMES_VVV_vec_I:
	{
	vec1[i] = ZVal(vec2[i]->AsInt() * vec3[i]->AsInt());
	}
	break;

case OP_DIVIDE_VVV_vec_D:
	{
	if ( vec3[i]->AsDouble() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	vec1[i] = ZVal(vec2[i]->AsDouble() / vec3[i]->AsDouble());

	}
	}
	break;

case OP_DIVIDE_VVV_vec_U:
	{
	if ( vec3[i]->AsCount() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	vec1[i] = ZVal(vec2[i]->AsCount() / vec3[i]->AsCount());

	}
	}
	break;

case OP_DIVIDE_VVV_vec_I:
	{
	if ( vec3[i]->AsInt() == 0)
	{
	ERROR("division by zero");
	}
	else
	{
	vec1[i] = ZVal(vec2[i]->AsInt() / vec3[i]->AsInt());

	}
	}
	break;

case OP_MOD_VVV_vec_U:
	{
	if ( vec3[i]->AsCount() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	vec1[i] = ZVal(vec2[i]->AsCount() % vec3[i]->AsCount());

	}
	}
	break;

case OP_MOD_VVV_vec_I:
	{
	if ( vec3[i]->AsInt() == 0)
	{
	ERROR("modulo by zero");
	}
	else
	{
	vec1[i] = ZVal(vec2[i]->AsInt() % vec3[i]->AsInt());

	}
	}
	break;

case OP_AND_AND_VVV_vec_I:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsInt() && vec3[i]->AsInt()));
	}
	break;

case OP_OR_OR_VVV_vec_I:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsInt() || vec3[i]->AsInt()));
	}
	break;

case OP_AND_VVV_vec_T:
	{
	auto hold_lhs = vec1[i] ? vec1[i]->ManagedVal() : nullptr;
	vec1[i] = ZVal(vec2[i]->AsTable()->Intersection(*vec3[i]->AsTable()).release());
	Unref(hold_lhs);
	}
	break;

case OP_AND_VVV_vec_P:
	{
	auto hold_lhs = vec1[i] ? vec1[i]->ManagedVal() : nullptr;
	vec1[i] = ZVal(new PatternVal(RE_Matcher_conjunction(vec2[i]->AsPattern()->AsPattern(), vec3[i]->AsPattern()->AsPattern())));
	Unref(hold_lhs);
	}
	break;

case OP_AND_VVV_vec_U:
	{
	vec1[i] = ZVal(vec2[i]->AsCount() & vec3[i]->AsCount());
	}
	break;

case OP_OR_VVV_vec_T:
	{
	auto hold_lhs = vec1[i] ? vec1[i]->ManagedVal() : nullptr;
	auto v = vec2[i]->AsTable()->Clone();
		auto s = v.release()->AsTableVal();
		(void) vec3[i]->AsTable()->AddTo(s, false, false);
		vec1[i] = ZVal(s);
	Unref(hold_lhs);
	}
	break;

case OP_OR_VVV_vec_P:
	{
	auto hold_lhs = vec1[i] ? vec1[i]->ManagedVal() : nullptr;
	vec1[i] = ZVal(new PatternVal(RE_Matcher_disjunction(vec2[i]->AsPattern()->AsPattern(), vec3[i]->AsPattern()->AsPattern())));
	Unref(hold_lhs);
	}
	break;

case OP_OR_VVV_vec_U:
	{
	vec1[i] = ZVal(vec2[i]->AsCount() | vec3[i]->AsCount());
	}
	break;

case OP_XOR_VVV_vec_U:
	{
	vec1[i] = ZVal(vec2[i]->AsCount() ^ vec3[i]->AsCount());
	}
	break;

case OP_LSHIFT_VVV_vec_U:
	{
	vec1[i] = ZVal(vec2[i]->AsCount() << vec3[i]->AsCount());
	}
	break;

case OP_LSHIFT_VVV_vec_I:
	{
	if ( vec2[i]->AsInt() < 0 )
			ERROR("left shifting a negative number is undefined");
		vec1[i] = ZVal(vec2[i]->AsInt() << vec3[i]->AsInt());
	}
	break;

case OP_RSHIFT_VVV_vec_U:
	{
	vec1[i] = ZVal(vec2[i]->AsCount() >> vec3[i]->AsCount());
	}
	break;

case OP_RSHIFT_VVV_vec_I:
	{
	vec1[i] = ZVal(vec2[i]->AsInt() >> vec3[i]->AsInt());
	}
	break;

case OP_LT_VVV_vec_A:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsAddr()->AsAddr() < vec3[i]->AsAddr()->AsAddr()));
	}
	break;

case OP_LT_VVV_vec_T:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsTable()->IsSubsetOf(*vec3[i]->AsTable()) && vec2[i]->AsTable()->Size() < vec3[i]->AsTable()->Size()));
	}
	break;

case OP_LT_VVV_vec_S:
	{
	vec1[i] = ZVal(zeek_int_t(Bstr_cmp(vec2[i]->AsString()->AsString(), vec3[i]->AsString()->AsString()) < 0));
	}
	break;

case OP_LT_VVV_vec_D:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsDouble() < vec3[i]->AsDouble()));
	}
	break;

case OP_LT_VVV_vec_U:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsCount() < vec3[i]->AsCount()));
	}
	break;

case OP_LT_VVV_vec_I:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsInt() < vec3[i]->AsInt()));
	}
	break;

case OP_LE_VVV_vec_A:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsAddr()->AsAddr() < vec3[i]->AsAddr()->AsAddr() || vec2[i]->AsAddr()->AsAddr() == vec3[i]->AsAddr()->AsAddr()));
	}
	break;

case OP_LE_VVV_vec_T:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsTable()->IsSubsetOf(*vec3[i]->AsTable())));
	}
	break;

case OP_LE_VVV_vec_S:
	{
	vec1[i] = ZVal(zeek_int_t(Bstr_cmp(vec2[i]->AsString()->AsString(), vec3[i]->AsString()->AsString()) <= 0));
	}
	break;

case OP_LE_VVV_vec_D:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsDouble() <= vec3[i]->AsDouble()));
	}
	break;

case OP_LE_VVV_vec_U:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsCount() <= vec3[i]->AsCount()));
	}
	break;

case OP_LE_VVV_vec_I:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsInt() <= vec3[i]->AsInt()));
	}
	break;

case OP_EQ_VVV_vec_P:
	{
	vec1[i] = ZVal(zeek_int_t(strcmp(vec2[i]->AsPattern()->Get()->PatternText(), vec3[i]->AsPattern()->Get()->PatternText()) == 0));
	}
	break;

case OP_EQ_VVV_vec_F:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsFunc()->GetName() == vec3[i]->AsFunc()->GetName()));
	}
	break;

case OP_EQ_VVV_vec_N:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsSubNet()->AsSubNet() == vec3[i]->AsSubNet()->AsSubNet()));
	}
	break;

case OP_EQ_VVV_vec_A:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsAddr()->AsAddr() == vec3[i]->AsAddr()->AsAddr()));
	}
	break;

case OP_EQ_VVV_vec_T:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsTable()->EqualTo(*vec3[i]->AsTable())));
	}
	break;

case OP_EQ_VVV_vec_S:
	{
	vec1[i] = ZVal(zeek_int_t(Bstr_cmp(vec2[i]->AsString()->AsString(), vec3[i]->AsString()->AsString()) == 0));
	}
	break;

case OP_EQ_VVV_vec_D:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsDouble() == vec3[i]->AsDouble()));
	}
	break;

case OP_EQ_VVV_vec_U:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsCount() == vec3[i]->AsCount()));
	}
	break;

case OP_EQ_VVV_vec_I:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsInt() == vec3[i]->AsInt()));
	}
	break;

case OP_NE_VVV_vec_P:
	{
	vec1[i] = ZVal(zeek_int_t(strcmp(vec2[i]->AsPattern()->Get()->PatternText(), vec3[i]->AsPattern()->Get()->PatternText()) != 0));
	}
	break;

case OP_NE_VVV_vec_F:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsFunc()->GetName() != vec3[i]->AsFunc()->GetName()));
	}
	break;

case OP_NE_VVV_vec_N:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsSubNet()->AsSubNet() != vec3[i]->AsSubNet()->AsSubNet()));
	}
	break;

case OP_NE_VVV_vec_A:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsAddr()->AsAddr() != vec3[i]->AsAddr()->AsAddr()));
	}
	break;

case OP_NE_VVV_vec_T:
	{
	vec1[i] = ZVal(zeek_int_t(! vec2[i]->AsTable()->EqualTo(*vec3[i]->AsTable())));
	}
	break;

case OP_NE_VVV_vec_S:
	{
	vec1[i] = ZVal(zeek_int_t(Bstr_cmp(vec2[i]->AsString()->AsString(), vec3[i]->AsString()->AsString()) != 0));
	}
	break;

case OP_NE_VVV_vec_D:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsDouble() != vec3[i]->AsDouble()));
	}
	break;

case OP_NE_VVV_vec_U:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsCount() != vec3[i]->AsCount()));
	}
	break;

case OP_NE_VVV_vec_I:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsInt() != vec3[i]->AsInt()));
	}
	break;

case OP_GE_VVV_vec_A:
	{
	vec1[i] = ZVal(zeek_int_t(! (vec2[i]->AsAddr()->AsAddr() < vec3[i]->AsAddr()->AsAddr())));
	}
	break;

case OP_GE_VVV_vec_S:
	{
	vec1[i] = ZVal(zeek_int_t(Bstr_cmp(vec2[i]->AsString()->AsString(), vec3[i]->AsString()->AsString()) >= 0));
	}
	break;

case OP_GE_VVV_vec_D:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsDouble() >= vec3[i]->AsDouble()));
	}
	break;

case OP_GE_VVV_vec_U:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsCount() >= vec3[i]->AsCount()));
	}
	break;

case OP_GE_VVV_vec_I:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsInt() >= vec3[i]->AsInt()));
	}
	break;

case OP_GT_VVV_vec_A:
	{
	vec1[i] = ZVal(zeek_int_t(! (vec2[i]->AsAddr()->AsAddr() < vec3[i]->AsAddr()->AsAddr()) && vec2[i]->AsAddr()->AsAddr() != vec3[i]->AsAddr()->AsAddr()));
	}
	break;

case OP_GT_VVV_vec_S:
	{
	vec1[i] = ZVal(zeek_int_t(Bstr_cmp(vec2[i]->AsString()->AsString(), vec3[i]->AsString()->AsString()) > 0));
	}
	break;

case OP_GT_VVV_vec_D:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsDouble() > vec3[i]->AsDouble()));
	}
	break;

case OP_GT_VVV_vec_U:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsCount() > vec3[i]->AsCount()));
	}
	break;

case OP_GT_VVV_vec_I:
	{
	vec1[i] = ZVal(zeek_int_t(vec2[i]->AsInt() > vec3[i]->AsInt()));
	}
	break;

