// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_bittorrent_bittorrent_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_bittorrent_bittorrent_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


constexpr uint32_t MSGLEN_LIMIT = 0x40000;

#include "zeek/analyzer/protocol/bittorrent/events.bif.h"

namespace binpac {

namespace BitTorrent {
class ContextBitTorrent;
// NOLINTNEXTLINE(performance-enum-size)
enum BitTorrent_peer_msg_type {
    TYPE_CHOKE = 0,
    TYPE_UNCHOKE = 1,
    TYPE_INTERESTED = 2,
    TYPE_NOT_INTERESTED = 3,
    TYPE_HAVE = 4,
    TYPE_BITFIELD = 5,
    TYPE_REQUEST = 6,
    TYPE_PIECE = 7,
    TYPE_CANCEL = 8,
    TYPE_PORT = 9,
};
class BitTorrent_Handshake;
class BitTorrent_KeepAlive;
class BitTorrent_Choke;
class BitTorrent_Unchoke;
class BitTorrent_Interested;
class BitTorrent_NotInterested;
class BitTorrent_Have;
class BitTorrent_Bitfield;
class BitTorrent_Request;
class BitTorrent_PieceHeader;
class BitTorrent_Piece;
class BitTorrent_Cancel;
class BitTorrent_Port;
class BitTorrent_Unknown;
class BitTorrent_MessageID;
class BitTorrent_MessageLength;
class BitTorrent_Message;
class BitTorrent_PDU;
class BitTorrent_Conn;
class BitTorrent_Flow;
} // namespace BitTorrent

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace BitTorrent {

class ContextBitTorrent final {
public:
    ContextBitTorrent(BitTorrent_Conn* connection, BitTorrent_Flow* flow, FlowBuffer* flow_buffer);
    ~ContextBitTorrent();

    // Member access functions
    BitTorrent_Conn* connection() const { return connection_; }
    BitTorrent_Flow* flow() const { return flow_; }
    FlowBuffer* flow_buffer() const { return flow_buffer_; }

protected:
    BitTorrent_Conn* connection_;
    BitTorrent_Flow* flow_;
    FlowBuffer* flow_buffer_;
};


class BitTorrent_Handshake final {
public:
    BitTorrent_Handshake();
    ~BitTorrent_Handshake();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextBitTorrent* t_context);

    // Member access functions
    uint8 pstrlen() const { return pstrlen_; }
    bytestring const& pstr() const { return pstr_; }
    bytestring const& reserved() const { return reserved_; }
    bytestring const& info_hash() const { return info_hash_; }
    bytestring const& peer_id() const { return peer_id_; }
    bool validate() const { return validate_; }
    bool deliver() const { return deliver_; }

protected:
    uint8 pstrlen_;
    bytestring pstr_;
    bytestring reserved_;
    bytestring info_hash_;
    bytestring peer_id_;
    bool validate_;
    bool deliver_;
    int buffering_state_;
};


class BitTorrent_KeepAlive final {
public:
    BitTorrent_KeepAlive();
    ~BitTorrent_KeepAlive();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context);

    // Member access functions
    bool deliver() const { return deliver_; }

protected:
    bool deliver_;
};


class BitTorrent_Choke final {
public:
    BitTorrent_Choke();
    ~BitTorrent_Choke();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context);

    // Member access functions
    bool deliver() const { return deliver_; }

protected:
    bool deliver_;
};


class BitTorrent_Unchoke final {
public:
    BitTorrent_Unchoke();
    ~BitTorrent_Unchoke();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context);

    // Member access functions
    bool deliver() const { return deliver_; }

protected:
    bool deliver_;
};


class BitTorrent_Interested final {
public:
    BitTorrent_Interested();
    ~BitTorrent_Interested();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context);

    // Member access functions
    bool deliver() const { return deliver_; }

protected:
    bool deliver_;
};


class BitTorrent_NotInterested final {
public:
    BitTorrent_NotInterested();
    ~BitTorrent_NotInterested();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context);

    // Member access functions
    bool deliver() const { return deliver_; }

protected:
    bool deliver_;
};


class BitTorrent_Have final {
public:
    BitTorrent_Have();
    ~BitTorrent_Have();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context, int t_byteorder);

    // Member access functions
    uint32 piece_index() const { return piece_index_; }
    bool deliver() const { return deliver_; }

protected:
    uint32 piece_index_;
    bool deliver_;
};


class BitTorrent_Bitfield final {
public:
    BitTorrent_Bitfield(uint32 len);
    ~BitTorrent_Bitfield();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context);

    // Member access functions
    bytestring const& bitfield() const { return bitfield_; }
    uint32 len() const { return len_; }
    bool deliver() const { return deliver_; }

protected:
    bytestring bitfield_;
    uint32 len_;
    bool deliver_;
};


class BitTorrent_Request final {
public:
    BitTorrent_Request();
    ~BitTorrent_Request();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context, int t_byteorder);

    // Member access functions
    uint32 index() const { return index_; }
    uint32 begin() const { return begin_; }
    uint32 length() const { return length_; }
    bool deliver() const { return deliver_; }

protected:
    uint32 index_;
    uint32 begin_;
    uint32 length_;
    bool deliver_;
};


class BitTorrent_PieceHeader final {
public:
    BitTorrent_PieceHeader(uint32 len);
    ~BitTorrent_PieceHeader();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 index() const { return index_; }
    uint32 begin() const { return begin_; }
    uint32 len() const { return len_; }

protected:
    uint32 index_;
    uint32 begin_;
    uint32 len_;
};


class BitTorrent_Piece final {
public:
    BitTorrent_Piece(uint32 len);
    ~BitTorrent_Piece();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context, int t_byteorder);

    // Member access functions
    BitTorrent_PieceHeader* header() const { return header_; }
    bytestring const& anonymous_field_001() const { return anonymous_field_001_; }
    uint32 len() const { return len_; }
    bool deliver() const { return deliver_; }

protected:
    BitTorrent_PieceHeader* header_;
    bytestring anonymous_field_001_;
    uint32 len_;
    bool deliver_;
};


class BitTorrent_Cancel final {
public:
    BitTorrent_Cancel();
    ~BitTorrent_Cancel();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context, int t_byteorder);

    // Member access functions
    uint32 index() const { return index_; }
    uint32 begin() const { return begin_; }
    uint32 length() const { return length_; }
    bool deliver() const { return deliver_; }

protected:
    uint32 index_;
    uint32 begin_;
    uint32 length_;
    bool deliver_;
};


class BitTorrent_Port final {
public:
    BitTorrent_Port();
    ~BitTorrent_Port();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context, int t_byteorder);

    // Member access functions
    uint16 listen_port() const { return listen_port_; }
    bool deliver() const { return deliver_; }

protected:
    uint16 listen_port_;
    bool deliver_;
};


class BitTorrent_Unknown final {
public:
    BitTorrent_Unknown(uint8 id, uint32 len);
    ~BitTorrent_Unknown();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context);

    // Member access functions
    bytestring const& data() const { return data_; }
    uint8 id() const { return id_; }
    uint32 len() const { return len_; }
    bool deliver() const { return deliver_; }

protected:
    bytestring data_;
    uint8 id_;
    uint32 len_;
    bool deliver_;
};


class BitTorrent_MessageID final {
public:
    BitTorrent_MessageID(uint32 len);
    ~BitTorrent_MessageID();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context, int t_byteorder);

    // Member access functions
    uint8 id() const { return id_; }
    uint8 data_case_index() const	{ return data_case_index_; }
    BitTorrent_Choke* choke() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent-protocol.pac:110:choke", (int64)data_case_index(), "TYPE_CHOKE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return choke_;
    }
    BitTorrent_Unchoke* unchoke() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent-protocol.pac:111:unchoke", (int64)data_case_index(), "TYPE_UNCHOKE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return unchoke_;
    }
    BitTorrent_Interested* interested() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent-protocol.pac:112:interested", (int64)data_case_index(), "TYPE_INTERESTED");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return interested_;
    }
    BitTorrent_NotInterested* not_interested() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent-protocol.pac:113:not_interested", (int64)data_case_index(), "TYPE_NOT_INTERESTED");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return not_interested_;
    }
    BitTorrent_Have* have() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent-protocol.pac:114:have", (int64)data_case_index(), "TYPE_HAVE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return have_;
    }
    BitTorrent_Bitfield* bitfield() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent-protocol.pac:115:bitfield", (int64)data_case_index(), "TYPE_BITFIELD");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return bitfield_;
    }
    BitTorrent_Request* request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent-protocol.pac:116:request", (int64)data_case_index(), "TYPE_REQUEST");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return request_;
    }
    BitTorrent_Piece* piece() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)7):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent-protocol.pac:117:piece", (int64)data_case_index(), "TYPE_PIECE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return piece_;
    }
    BitTorrent_Cancel* cancel() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent-protocol.pac:118:cancel", (int64)data_case_index(), "TYPE_CANCEL");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return cancel_;
    }
    BitTorrent_Port* port() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint8)9):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent-protocol.pac:119:port", (int64)data_case_index(), "TYPE_PORT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return port_;
    }
    BitTorrent_Unknown* unknown() const {
        return unknown_;
    }
    uint32 len() const { return len_; }

protected:
    uint8 id_;
    uint8 data_case_index_;
    BitTorrent_Choke* choke_;
    BitTorrent_Unchoke* unchoke_;
    BitTorrent_Interested* interested_;
    BitTorrent_NotInterested* not_interested_;
    BitTorrent_Have* have_;
    BitTorrent_Bitfield* bitfield_;
    BitTorrent_Request* request_;
    BitTorrent_Piece* piece_;
    BitTorrent_Cancel* cancel_;
    BitTorrent_Port* port_;
    BitTorrent_Unknown* unknown_;
    uint32 len_;
};


class BitTorrent_MessageLength final {
public:
    BitTorrent_MessageLength();
    ~BitTorrent_MessageLength();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextBitTorrent* t_context, int t_byteorder);

    // Member access functions
    uint32 len() const { return len_; }
    bool validate() const { return validate_; }

protected:
    uint32 len_;
    bool validate_;
};


class BitTorrent_Message final {
public:
    BitTorrent_Message();
    ~BitTorrent_Message();
    int initial_buffer_length() const { return 4; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextBitTorrent* t_context, int t_byteorder);

    // Member access functions
    BitTorrent_MessageLength* len() const { return len_; }
    uint32 data_case_index() const	{ return data_case_index_; }
    BitTorrent_KeepAlive* keep_alive() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( data_case_index() ) {
            case ((uint32)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent-protocol.pac:133:keep_alive", (int64)data_case_index(), "((int) 0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return keep_alive_;
    }
    BitTorrent_MessageID* message_id() const {
        return message_id_;
    }

protected:
    BitTorrent_MessageLength* len_;
    uint32 data_case_index_;
    BitTorrent_KeepAlive* keep_alive_;
    BitTorrent_MessageID* message_id_;
    int buffering_state_;
};


class BitTorrent_PDU final {
public:
    BitTorrent_PDU();
    ~BitTorrent_PDU();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextBitTorrent* t_context);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    BitTorrent_Handshake* handshake() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent-protocol.pac:143:handshake", (int64)val_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return handshake_;
    }
    BitTorrent_Message* message() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/bittorrent/bittorrent-protocol.pac:144:message", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return message_;
    }
    int byteorder() const { return byteorder_; }

protected:
    int val_case_index_;
    BitTorrent_Handshake* handshake_;
    BitTorrent_Message* message_;
    int byteorder_;
};


class BitTorrent_Conn final : public binpac::ConnectionAnalyzer {
public:
    BitTorrent_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~BitTorrent_Conn() override;

    // Member access functions
    BitTorrent_Flow* upflow() const { return upflow_; }
    BitTorrent_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

protected:
    BitTorrent_Flow* upflow_;
    BitTorrent_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


class BitTorrent_Flow final : public binpac::FlowAnalyzer {
public:
    BitTorrent_Flow(BitTorrent_Conn* connection, bool is_orig);
    ~BitTorrent_Flow() override;

    // Member access functions
    FlowBuffer* flow_buffer() const { return flow_buffer_; }
    BitTorrent_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

    // Functions
    bool is_handshake_delivered();
    bool validate_handshake(uint8 pstrlen, const_bytestring const& pstr);
    bool validate_message_length(uint32 len);
    bool deliver_handshake(const_bytestring const& reserved, const_bytestring const& info_hash, const_bytestring const& peer_id);
    bool deliver_keep_alive();
    bool deliver_choke();
    bool deliver_unchoke();
    bool deliver_interested();
    bool deliver_not_interested();
    bool deliver_have(uint32 piece_index);
    bool deliver_bitfield(const_bytestring const& bitfield);
    bool deliver_request(uint32 index, uint32 begin, uint32 length);
    bool deliver_piece(uint32 index, uint32 begin, uint32 piece_length);
    bool deliver_cancel(uint32 index, uint32 begin, uint32 length);
    bool deliver_port(uint16 listen_port);
    bool deliver_unknown(uint8 id, const_bytestring const& data);

protected:
    BitTorrent_PDU* dataunit_;
    ContextBitTorrent* context_;

    // Additional members

		bool handshake_ok;
		//uint64 _next_message_offset;
	
    FlowBuffer* flow_buffer_;
    BitTorrent_Conn* connection_;
    bool is_orig_;
};

} // namespace BitTorrent
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_bittorrent_bittorrent_pac_h */
