// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/dce_rpc.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/dce-rpc/dce_rpc_pac.h"

namespace binpac {






namespace DCE_RPC {
// NOLINTNEXTLINE(modernize-use-equals-default)
ContextDCE_RPC::ContextDCE_RPC(DCE_RPC_Conn* connection, DCE_RPC_Flow* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextDCE_RPC::~ContextDCE_RPC() {
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Conn::DCE_RPC_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new DCE_RPC_Flow(this, true);
    downflow_ = new DCE_RPC_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;

		fid = 0;
	

		ntlm = nullptr;
		gssapi = nullptr;
		krb = nullptr;
	
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Conn::~DCE_RPC_Conn() {

		if ( gssapi )
			{
			gssapi->Done();
			delete gssapi;
			}
		if ( ntlm )
			{
			ntlm->Done();
			delete ntlm;
			}
		if ( krb )
			{
			krb->Done();
			delete krb;
			}

	
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void DCE_RPC_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void DCE_RPC_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void DCE_RPC_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

bool DCE_RPC_Conn::set_file_id(uint64 fid_in) {

		fid = fid_in;
		return true;
		
}

uint16 DCE_RPC_Conn::get_cont_id_opnum_map(uint16 cont_id) {

		return cont_id_opnum_map[cont_id];
		
}

bool DCE_RPC_Conn::set_cont_id_opnum_map(uint16 cont_id, uint16 opnum) {

		cont_id_opnum_map[cont_id] = opnum;
		return true;
		
}

bool DCE_RPC_Conn::proc_dce_rpc_pdu(DCE_RPC_PDU* pdu) {

		// If a whole pdu message parsed ok, let's confirm the protocol
		zeek_analyzer()->AnalyzerConfirmation();
		return true;
		
}

bool DCE_RPC_Conn::proc_dce_rpc_message(DCE_RPC_Header* header) {

		if ( dce_rpc_message )
			{
			zeek::BifEvent::enqueue_dce_rpc_message(zeek_analyzer(),
			                                  zeek_analyzer()->Conn(),
			                                  header->is_orig(),
			                                  fid,
			                                  header->PTYPE(),
			                                  zeek::BifType::Enum::DCE_RPC::PType->GetEnumVal(header->PTYPE()));
			}
		return true;
		
}

bool DCE_RPC_Conn::process_dce_rpc_bind(ContextRequest* req) {

		if ( dce_rpc_bind )
			{
			zeek::BifEvent::enqueue_dce_rpc_bind(zeek_analyzer(),
			                               zeek_analyzer()->Conn(),
			                               fid,
			                               req->id(),
			                               to_stringval(req->abstract_syntax()->uuid()),
			                               req->abstract_syntax()->ver_major(),
			                               req->abstract_syntax()->ver_minor());
			}

		return true;
		
}

bool DCE_RPC_Conn::process_dce_rpc_alter_context(ContextRequest* req) {

		if ( dce_rpc_alter_context )
			{
			zeek::BifEvent::enqueue_dce_rpc_alter_context(zeek_analyzer(),
			                                        zeek_analyzer()->Conn(),
			                                        fid,
			                                        req->id(),
			                                        to_stringval(req->abstract_syntax()->uuid()),
			                                        req->abstract_syntax()->ver_major(),
			                                        req->abstract_syntax()->ver_minor());
			}

		return true;
		
}

bool DCE_RPC_Conn::process_dce_rpc_bind_ack(DCE_RPC_Bind_Ack* bind) {

		if ( dce_rpc_bind_ack )
			{
			zeek::StringValPtr sec_addr;

			// Remove the null from the end of the string if it's there.
			if ( bind->sec_addr().length() > 0 &&
			     *(bind->sec_addr().begin() + bind->sec_addr().length()) == 0 )
				sec_addr = zeek::make_intrusive<zeek::StringVal>(bind->sec_addr().length()-1, reinterpret_cast<const char*>(bind->sec_addr().begin()));
			else
				sec_addr = zeek::make_intrusive<zeek::StringVal>(bind->sec_addr().length(), reinterpret_cast<const char*>(bind->sec_addr().begin()));

			zeek::BifEvent::enqueue_dce_rpc_bind_ack(zeek_analyzer(),
			                                   zeek_analyzer()->Conn(),
			                                   fid,
			                                   std::move(sec_addr));
			}
		return true;
		
}

bool DCE_RPC_Conn::process_dce_rpc_alter_context_resp(DCE_RPC_AlterContext_Resp* bind) {

		if ( dce_rpc_alter_context_resp )
			{
			zeek::BifEvent::enqueue_dce_rpc_alter_context_resp(zeek_analyzer(),
			                                             zeek_analyzer()->Conn(),
			                                             fid);
			}
		return true;
		
}

bool DCE_RPC_Conn::process_dce_rpc_request(DCE_RPC_Request* req) {

		if ( dce_rpc_request )
			{
			zeek::BifEvent::enqueue_dce_rpc_request(zeek_analyzer(),
			                                  zeek_analyzer()->Conn(),
			                                  fid,
			                                  req->context_id(),
			                                  req->opnum(),
			                                  req->stub().length());
			}

		if ( dce_rpc_request_stub )
			zeek::BifEvent::enqueue_dce_rpc_request_stub(zeek_analyzer(),
			                                  zeek_analyzer()->Conn(),
			                                  fid,
			                                  req->context_id(),
			                                  req->opnum(),
			                                  binpac::to_stringval(req->stub()));

		set_cont_id_opnum_map(req->context_id(),
		                      req->opnum());
		return true;
		
}

bool DCE_RPC_Conn::process_dce_rpc_response(DCE_RPC_Response* resp) {

		if ( dce_rpc_response )
			{
			zeek::BifEvent::enqueue_dce_rpc_response(zeek_analyzer(),
			                                   zeek_analyzer()->Conn(),
			                                   fid,
			                                   resp->context_id(),
			                                   get_cont_id_opnum_map(resp->context_id()),
			                                   resp->stub().length());
			}

		if ( dce_rpc_response_stub )
			zeek::BifEvent::enqueue_dce_rpc_response_stub(zeek_analyzer(),
			                                   zeek_analyzer()->Conn(),
			                                   fid,
			                                   resp->context_id(),
			                                   get_cont_id_opnum_map(resp->context_id()),
			                                   binpac::to_stringval(resp->stub()));

		return true;
		
}

bool DCE_RPC_Conn::forward_auth(DCE_RPC_Auth* auth, bool is_orig) {

		switch ( auth->type() )  // https://social.msdn.microsoft.com/Forums/en-US/44212c32-a4f6-4960-8799-0e00821650f4/msrpc-and-dcerpc-security?forum=os_windowsprotocols
			{
			case 0x09:
				if ( ! gssapi )
					gssapi = zeek::analyzer_mgr->InstantiateAnalyzer("GSSAPI", zeek_analyzer()->Conn());
				if ( gssapi )
					gssapi->DeliverStream(auth->blob().length(), auth->blob().begin(), is_orig);
				break;

			case 0x10:
				if ( ! krb )
					krb = zeek::analyzer_mgr->InstantiateAnalyzer("KRB", zeek_analyzer()->Conn());
				if ( krb )
					krb->DeliverStream(auth->blob().length(), auth->blob().begin(), is_orig);
				break;

			case 0x0a:
				if ( ! ntlm )
					ntlm = zeek::analyzer_mgr->InstantiateAnalyzer("NTLM", zeek_analyzer()->Conn());
				if ( ntlm )
					ntlm->DeliverStream(auth->blob().length(), auth->blob().begin(), is_orig);
				break;

			case 0x0e:
				zeek_analyzer()->Weird("tls_dce_rpc_auth_type", zeek::util::fmt("%d", auth->type()));
				break;

			case 0x44:
				zeek_analyzer()->Weird("netlogon_dce_rpc_auth_type", zeek::util::fmt("%d", auth->type()));
				break;

			default:
				zeek_analyzer()->Weird("unknown_dce_rpc_auth_type", zeek::util::fmt("%d", auth->type()));
				break;
			}

		return true;
		
}

// NOLINTNEXTLINE(modernize-use-equals-default)
context_handle::context_handle() {
    attrs_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
context_handle::~context_handle() {
    uuid_.free();
}

int context_handle::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "context_handle:attrs"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("context_handle:attrs",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "attrs"
    attrs_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "uuid"
    // Checking out-of-bound for "context_handle:uuid"
    if ( (t_begin_of_data + 4) + (16) > t_end_of_data || (t_begin_of_data + 4) + (16) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("context_handle:uuid",
        	(4) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 4) + 16;
        int t_uuid_string_length;
        t_uuid_string_length = 16;
        int t_uuid__size;
        t_uuid__size = t_uuid_string_length;
        uuid_.init((t_begin_of_data + 4), t_uuid_string_length);
    }

    int t_context_handle__size;
    const_byteptr const t_dataptr_after_uuid = (t_begin_of_data + 4) + (16);
    BINPAC_ASSERT(t_dataptr_after_uuid <= t_end_of_data);
    t_context_handle__size = t_dataptr_after_uuid - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_context_handle__size) <= t_end_of_data);
    return t_context_handle__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_PDU::DCE_RPC_PDU(bool is_orig) {
    header_ = nullptr;
    auth_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = 0;
    body_length_ = 0;
    frag_reassembled_ = false;
    body_ = nullptr;
    has_body_ = false;
    proc_ = 0;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_PDU::~DCE_RPC_PDU() {
    delete header_;
    header_ = nullptr;
    frag_.free();
    delete auth_;
    auth_ = nullptr;
    delete body_;
    body_ = nullptr;
}

bool DCE_RPC_PDU::ParseBuffer(flow_buffer_t t_flow_buffer, ContextDCE_RPC* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(16, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "header"
            header_ = new DCE_RPC_Header(is_orig());
            header_->Parse(t_begin_of_data, t_end_of_data, t_context);
            t_flow_buffer->GrowFrame(header()->frag_length());
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {

                // Parse "frag"
                int t_frag__size;
                body_length_ = header()->frag_length() - 16 - header()->auth_length() -  ( header()->auth_length() > 0 ? 8 : 0 ) ;
                t_frag__size = body_length();
                // Checking out-of-bound for "DCE_RPC_PDU:frag"
                if ( (t_begin_of_data + 16) + (t_frag__size) > t_end_of_data || (t_begin_of_data + 16) + (t_frag__size) < (t_begin_of_data + 16) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("DCE_RPC_PDU:frag",
                    	(16) + (t_frag__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 16) + t_frag__size;
                    int t_frag_string_length;
                    t_frag_string_length = body_length();
                    // check for negative sizes
                    if ( t_frag_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/dce_rpc-protocol.pac:36", t_frag_string_length);
                    frag_.init((t_begin_of_data + 16), t_frag_string_length);
                }

                const_byteptr const t_dataptr_after_frag = (t_begin_of_data + 16) + (t_frag__size);
                BINPAC_ASSERT(t_dataptr_after_frag <= t_end_of_data);
                // Parse "auth"
                auth_ = new DCE_RPC_Auth_wrapper(header());
                byteorder_ = header()->byteorder();
                int t_auth__size;
                t_auth__size = auth_->Parse(t_dataptr_after_frag, t_end_of_data, t_context, byteorder());

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    frag_reassembled_ = t_context->flow()->reassemble_fragment(header(), frag());
                    // Parse "body"
                    has_body_ =  ( frag_reassembled() ) ;
                    if ( has_body() ) {
                        body_ = new DCE_RPC_Body(header());
                        const_byteptr t_begin_of_data;
                        const_byteptr t_end_of_data;
                        get_pointers(t_context->flow()->reassembled_body(header(), frag()), &t_begin_of_data, &t_end_of_data);
                        int t_body__size;
                        t_body__size = body_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                        // Evaluate 'let' and 'withinput' fields
                    }
                    proc_ = t_context->connection()->proc_dce_rpc_pdu(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NDR_Format::NDR_Format() {
    intchar_ = 0;
    floatspec_ = 0;
    byteorder_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NDR_Format::~NDR_Format() {
}

int NDR_Format::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "NDR_Format"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NDR_Format",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "intchar"
    intchar_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "floatspec"
    floatspec_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));


    // Evaluate 'let' and 'withinput' fields
    byteorder_ =  ( intchar() >> 4 )  ? littleendian : bigendian;
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Header::DCE_RPC_Header(bool is_orig) {
    rpc_vers_ = 0;
    rpc_vers_minor_ = 0;
    PTYPE_ = 0;
    pfc_flags_ = 0;
    packed_drep_ = nullptr;
    frag_length_ = 0;
    auth_length_ = 0;
    call_id_ = 0;
    is_orig_ = is_orig;
    byteorder_ = 0;
    firstfrag_ = 0;
    lastfrag_ = 0;
    object_ = 0;
    proc_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Header::~DCE_RPC_Header() {
    delete packed_drep_;
    packed_drep_ = nullptr;
}

int DCE_RPC_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDCE_RPC* t_context) {
    // Checking out-of-bound for "DCE_RPC_Header"
    if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DCE_RPC_Header",
        	(0) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "rpc_vers"
    rpc_vers_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
    // Evaluate '&enforce' attribute
    if (! ( rpc_vers() == 5 ) ) {
        throw binpac::ExceptionEnforceViolation("DCE_RPC_Header:rpc_vers");
    }

    // Parse "rpc_vers_minor"
    rpc_vers_minor_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "PTYPE"
    PTYPE_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "pfc_flags"
    pfc_flags_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "packed_drep"
    packed_drep_ = new NDR_Format();
    packed_drep_->Parse((t_begin_of_data + 4), t_end_of_data);

    // Parse "frag_length"
    byteorder_ = packed_drep()->byteorder();
    frag_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "auth_length"
    auth_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 10))));

    // Parse "call_id"
    call_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

    // Evaluate 'let' and 'withinput' fields
    firstfrag_ = pfc_flags() & 1;
    lastfrag_ =  ( pfc_flags() >> 1 )  & 1;
    object_ =  ( pfc_flags() >> 7 )  & 1;
    proc_ = t_context->connection()->proc_dce_rpc_message(this);
    BINPAC_ASSERT(t_begin_of_data + (16) <= t_end_of_data);
    return 16;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Syntax::Syntax() {
    ver_major_ = 0;
    ver_minor_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Syntax::~Syntax() {
    uuid_.free();
}

int Syntax::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "uuid"
    // Checking out-of-bound for "Syntax:uuid"
    if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Syntax:uuid",
        	(0) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 16;
        int t_uuid_string_length;
        t_uuid_string_length = 16;
        int t_uuid__size;
        t_uuid__size = t_uuid_string_length;
        uuid_.init(t_begin_of_data, t_uuid_string_length);
    }

    const_byteptr const t_dataptr_after_uuid = t_begin_of_data + (16);
    BINPAC_ASSERT(t_dataptr_after_uuid <= t_end_of_data);
    // Checking out-of-bound for "Syntax:ver_minor"
    if ( (t_dataptr_after_uuid + 2) + (2) > t_end_of_data || (t_dataptr_after_uuid + 2) + (2) < (t_dataptr_after_uuid + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Syntax:ver_minor",
        	(((t_dataptr_after_uuid + 2) - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "ver_major"
    ver_major_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_uuid)));

    // Parse "ver_minor"
    ver_minor_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_uuid + 2))));

    int t_Syntax__size;
    t_Syntax__size = (t_dataptr_after_uuid + 4) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Syntax__size) <= t_end_of_data);
    return t_Syntax__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextRequest::ContextRequest(uint8 ptype) {
    id_ = 0;
    num_syntaxes_ = 0;
    abstract_syntax_ = nullptr;
    transfer_syntaxes_ = nullptr;
    transfer_syntaxes__elem_ = nullptr;
    ptype_ = ptype;
    proc_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextRequest::~ContextRequest() {
    delete abstract_syntax_;
    abstract_syntax_ = nullptr;
    delete transfer_syntaxes__elem_;
    transfer_syntaxes__elem_ = nullptr;
    if ( transfer_syntaxes() ) {
        for ( auto* transfer_syntaxes__elem_ : *transfer_syntaxes() ) {
            delete transfer_syntaxes__elem_;
            transfer_syntaxes__elem_ = nullptr;
        }
    }
    delete transfer_syntaxes_;
}

int ContextRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDCE_RPC* t_context, int t_byteorder) {
    // Checking out-of-bound for "ContextRequest:reserved"
    if ( (t_begin_of_data + 3) + (1) > t_end_of_data || (t_begin_of_data + 3) + (1) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ContextRequest:reserved",
        	(3) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "id"
    id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "num_syntaxes"
    num_syntaxes_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));


    // Parse "abstract_syntax"
    abstract_syntax_ = new Syntax();
    int t_abstract_syntax__size;
    t_abstract_syntax__size = abstract_syntax_->Parse((t_begin_of_data + 4), t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_abstract_syntax = (t_begin_of_data + 4) + (t_abstract_syntax__size);
    BINPAC_ASSERT(t_dataptr_after_abstract_syntax <= t_end_of_data);
    // Parse "transfer_syntaxes"
    int t_transfer_syntaxes__arraylength;
    t_transfer_syntaxes__arraylength = num_syntaxes();
    if ( t_transfer_syntaxes__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("ContextRequest:transfer_syntaxes",
          t_transfer_syntaxes__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: ContextRequest:transfer_syntaxes
    if ( t_transfer_syntaxes__arraylength > ((t_end_of_data - t_dataptr_after_abstract_syntax) / 1) )
        throw binpac::ExceptionOutOfBound("ContextRequest:transfer_syntaxes",
          t_transfer_syntaxes__arraylength, (t_end_of_data) - (t_dataptr_after_abstract_syntax));
    transfer_syntaxes__elem_ = nullptr;
    int t_transfer_syntaxes__elem__it;
    t_transfer_syntaxes__elem__it = 0;
    int t_transfer_syntaxes__size;
    transfer_syntaxes_ = new vector<Syntax*>;
    transfer_syntaxes_->reserve(t_transfer_syntaxes__arraylength);
    const_byteptr t_transfer_syntaxes__elem__dataptr = t_dataptr_after_abstract_syntax;
    for (; t_transfer_syntaxes__elem__it < t_transfer_syntaxes__arraylength; ++t_transfer_syntaxes__elem__it) {
        transfer_syntaxes__elem_ = new Syntax();
        int t_transfer_syntaxes__elem__size;
        t_transfer_syntaxes__elem__size = transfer_syntaxes__elem_->Parse(t_transfer_syntaxes__elem__dataptr, t_end_of_data, t_byteorder);
        transfer_syntaxes_->push_back(transfer_syntaxes__elem_);
        t_transfer_syntaxes__elem__dataptr += t_transfer_syntaxes__elem__size;
        BINPAC_ASSERT(t_transfer_syntaxes__elem__dataptr <= t_end_of_data);
        transfer_syntaxes__elem_ = nullptr;
    }
end_of_transfer_syntaxes: ;
    t_transfer_syntaxes__size = t_transfer_syntaxes__elem__dataptr - (t_dataptr_after_abstract_syntax);
    // Evaluate 'let' and 'withinput' fields

    int t_ContextRequest__size;
    const_byteptr const t_dataptr_after_transfer_syntaxes = t_dataptr_after_abstract_syntax + (t_transfer_syntaxes__size);
    BINPAC_ASSERT(t_dataptr_after_transfer_syntaxes <= t_end_of_data);
    t_ContextRequest__size = t_dataptr_after_transfer_syntaxes - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    bool t_t_var_001;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( ptype() ) {
        case ((uint8)11):
            t_t_var_001 = t_context->connection()->process_dce_rpc_bind(this);
            break;
        case ((uint8)14):
            t_t_var_001 = t_context->connection()->process_dce_rpc_alter_context(this);
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("/build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/dce_rpc-analyzer.pac:176", (int64)ptype());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    proc_ = t_t_var_001;
    BINPAC_ASSERT(t_begin_of_data + (t_ContextRequest__size) <= t_end_of_data);
    return t_ContextRequest__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextReply::ContextReply() {
    ack_result_ = 0;
    ack_reason_ = 0;
    syntax_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextReply::~ContextReply() {
    delete syntax_;
    syntax_ = nullptr;
}

int ContextReply::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "ContextReply:ack_reason"
    if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ContextReply:ack_reason",
        	(2) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "ack_result"
    ack_result_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "ack_reason"
    ack_reason_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "syntax"
    syntax_ = new Syntax();
    int t_syntax__size;
    t_syntax__size = syntax_->Parse((t_begin_of_data + 4), t_end_of_data, t_byteorder);

    int t_ContextReply__size;
    const_byteptr const t_dataptr_after_syntax = (t_begin_of_data + 4) + (t_syntax__size);
    BINPAC_ASSERT(t_dataptr_after_syntax <= t_end_of_data);
    t_ContextReply__size = t_dataptr_after_syntax - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ContextReply__size) <= t_end_of_data);
    return t_ContextReply__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextList::ContextList(bool is_request, uint8 ptype) {
    num_contexts_ = 0;
    req_reply_case_index_ = -1;
    request_contexts_ = nullptr;
    request_contexts__elem_ = nullptr;
    reply_contexts_ = nullptr;
    reply_contexts__elem_ = nullptr;
    is_request_ = is_request;
    ptype_ = ptype;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextList::~ContextList() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( req_reply_case_index() ) {
        case true:
            // Clean up "request_contexts"
            {
                delete request_contexts__elem_;
                request_contexts__elem_ = nullptr;
                if ( request_contexts() ) {
                    for ( auto* request_contexts__elem_ : *request_contexts() ) {
                        delete request_contexts__elem_;
                        request_contexts__elem_ = nullptr;
                    }
                }
                delete request_contexts_;
            }
            break;
        case false:
            // Clean up "reply_contexts"
            {
                delete reply_contexts__elem_;
                reply_contexts__elem_ = nullptr;
                if ( reply_contexts() ) {
                    for ( auto* reply_contexts__elem_ : *reply_contexts() ) {
                        delete reply_contexts__elem_;
                        reply_contexts__elem_ = nullptr;
                    }
                }
                delete reply_contexts_;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ContextList::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDCE_RPC* t_context, int t_byteorder) {
    // Checking out-of-bound for "ContextList:reserved"
    if ( (t_begin_of_data + 1) + (3) > t_end_of_data || (t_begin_of_data + 1) + (3) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ContextList:reserved",
        	(1) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "num_contexts"
    num_contexts_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));


    // Parse "req_reply"
    int t_req_reply__size;
    req_reply_case_index_ = is_request();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( req_reply_case_index() ) {
        case true:
            // Parse "request_contexts"
            {
                int t_request_contexts__arraylength;
                t_request_contexts__arraylength = num_contexts();
                if ( t_request_contexts__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("ContextList:request_contexts",
                      t_request_contexts__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: ContextList:request_contexts
                if ( t_request_contexts__arraylength > ((t_end_of_data - (t_begin_of_data + 4)) / 1) )
                    throw binpac::ExceptionOutOfBound("ContextList:request_contexts",
                      t_request_contexts__arraylength, (t_end_of_data) - ((t_begin_of_data + 4)));
                request_contexts__elem_ = nullptr;
                int t_request_contexts__elem__it;
                t_request_contexts__elem__it = 0;
                int t_request_contexts__size;
                request_contexts_ = new vector<ContextRequest*>;
                request_contexts_->reserve(t_request_contexts__arraylength);
                const_byteptr t_request_contexts__elem__dataptr = (t_begin_of_data + 4);
                for (; t_request_contexts__elem__it < t_request_contexts__arraylength; ++t_request_contexts__elem__it) {
                    request_contexts__elem_ = new ContextRequest(ptype());
                    int t_request_contexts__elem__size;
                    t_request_contexts__elem__size = request_contexts__elem_->Parse(t_request_contexts__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    request_contexts_->push_back(request_contexts__elem_);
                    t_request_contexts__elem__dataptr += t_request_contexts__elem__size;
                    BINPAC_ASSERT(t_request_contexts__elem__dataptr <= t_end_of_data);
                    request_contexts__elem_ = nullptr;
                }
            end_of_request_contexts: ;
                t_request_contexts__size = t_request_contexts__elem__dataptr - ((t_begin_of_data + 4));
                // Evaluate 'let' and 'withinput' fields
                t_req_reply__size = t_request_contexts__size;
            }
            break;
        case false:
            // Parse "reply_contexts"
            {
                int t_reply_contexts__arraylength;
                t_reply_contexts__arraylength = num_contexts();
                if ( t_reply_contexts__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("ContextList:reply_contexts",
                      t_reply_contexts__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: ContextList:reply_contexts
                if ( t_reply_contexts__arraylength > ((t_end_of_data - (t_begin_of_data + 4)) / 1) )
                    throw binpac::ExceptionOutOfBound("ContextList:reply_contexts",
                      t_reply_contexts__arraylength, (t_end_of_data) - ((t_begin_of_data + 4)));
                reply_contexts__elem_ = nullptr;
                int t_reply_contexts__elem__it;
                t_reply_contexts__elem__it = 0;
                int t_reply_contexts__size;
                reply_contexts_ = new vector<ContextReply*>;
                reply_contexts_->reserve(t_reply_contexts__arraylength);
                const_byteptr t_reply_contexts__elem__dataptr = (t_begin_of_data + 4);
                for (; t_reply_contexts__elem__it < t_reply_contexts__arraylength; ++t_reply_contexts__elem__it) {
                    reply_contexts__elem_ = new ContextReply();
                    int t_reply_contexts__elem__size;
                    t_reply_contexts__elem__size = reply_contexts__elem_->Parse(t_reply_contexts__elem__dataptr, t_end_of_data, t_byteorder);
                    reply_contexts_->push_back(reply_contexts__elem_);
                    t_reply_contexts__elem__dataptr += t_reply_contexts__elem__size;
                    BINPAC_ASSERT(t_reply_contexts__elem__dataptr <= t_end_of_data);
                    reply_contexts__elem_ = nullptr;
                }
            end_of_reply_contexts: ;
                t_reply_contexts__size = t_reply_contexts__elem__dataptr - ((t_begin_of_data + 4));
                // Evaluate 'let' and 'withinput' fields
                t_req_reply__size = t_reply_contexts__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("ContextList", (int64)req_reply_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_ContextList__size;
    const_byteptr const t_dataptr_after_req_reply = (t_begin_of_data + 4) + (t_req_reply__size);
    BINPAC_ASSERT(t_dataptr_after_req_reply <= t_end_of_data);
    t_ContextList__size = t_dataptr_after_req_reply - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ContextList__size) <= t_end_of_data);
    return t_ContextList__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Bind::DCE_RPC_Bind() {
    max_xmit_frag_ = 0;
    max_recv_frag_ = 0;
    assoc_group_id_ = 0;
    context_list_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Bind::~DCE_RPC_Bind() {
    delete context_list_;
    context_list_ = nullptr;
}

int DCE_RPC_Bind::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDCE_RPC* t_context, int t_byteorder) {
    // Checking out-of-bound for "DCE_RPC_Bind:assoc_group_id"
    if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DCE_RPC_Bind:assoc_group_id",
        	(4) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "max_xmit_frag"
    max_xmit_frag_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "max_recv_frag"
    max_recv_frag_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "assoc_group_id"
    assoc_group_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "context_list"
    context_list_ = new ContextList(true, DCE_RPC_BIND);
    int t_context_list__size;
    t_context_list__size = context_list_->Parse((t_begin_of_data + 8), t_end_of_data, t_context, t_byteorder);

    int t_DCE_RPC_Bind__size;
    const_byteptr const t_dataptr_after_context_list = (t_begin_of_data + 8) + (t_context_list__size);
    BINPAC_ASSERT(t_dataptr_after_context_list <= t_end_of_data);
    t_DCE_RPC_Bind__size = t_dataptr_after_context_list - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_DCE_RPC_Bind__size) <= t_end_of_data);
    return t_DCE_RPC_Bind__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Bind_Ack::DCE_RPC_Bind_Ack() {
    max_xmit_frag_ = 0;
    max_recv_frag_ = 0;
    assoc_group_id_ = 0;
    sec_addr_length_ = 0;
    contexts_ = nullptr;
    proc_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Bind_Ack::~DCE_RPC_Bind_Ack() {
    sec_addr_.free();
    delete contexts_;
    contexts_ = nullptr;
}

int DCE_RPC_Bind_Ack::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDCE_RPC* t_context, int t_byteorder) {
    // Checking out-of-bound for "DCE_RPC_Bind_Ack:sec_addr_length"
    if ( (t_begin_of_data + 8) + (2) > t_end_of_data || (t_begin_of_data + 8) + (2) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DCE_RPC_Bind_Ack:sec_addr_length",
        	(8) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "max_xmit_frag"
    max_xmit_frag_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "max_recv_frag"
    max_recv_frag_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "assoc_group_id"
    assoc_group_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "sec_addr_length"
    sec_addr_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "sec_addr"
    int t_sec_addr__size;
    t_sec_addr__size = sec_addr_length();
    // Checking out-of-bound for "DCE_RPC_Bind_Ack:sec_addr"
    if ( (t_begin_of_data + 10) + (t_sec_addr__size) > t_end_of_data || (t_begin_of_data + 10) + (t_sec_addr__size) < (t_begin_of_data + 10) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DCE_RPC_Bind_Ack:sec_addr",
        	(10) + (t_sec_addr__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 10) + t_sec_addr__size;
        int t_sec_addr_string_length;
        t_sec_addr_string_length = sec_addr_length();
        // check for negative sizes
        if ( t_sec_addr_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/dce_rpc-protocol.pac:109", t_sec_addr_string_length);
        sec_addr_.init((t_begin_of_data + 10), t_sec_addr_string_length);
    }


    const_byteptr const t_dataptr_after_sec_addr = (t_begin_of_data + 10) + (t_sec_addr__size);
    BINPAC_ASSERT(t_dataptr_after_sec_addr <= t_end_of_data);
    int pad__size = (t_dataptr_after_sec_addr - t_begin_of_data) % 4;
    pad__size = (pad__size == 0) ? 0 : 4 - pad__size;
    const_byteptr const t_dataptr_after_pad = t_dataptr_after_sec_addr + pad__size;
    // Parse "contexts"
    contexts_ = new ContextList(false, DCE_RPC_BIND_ACK);
    int t_contexts__size;
    t_contexts__size = contexts_->Parse(t_dataptr_after_pad, t_end_of_data, t_context, t_byteorder);

    int t_DCE_RPC_Bind_Ack__size;
    const_byteptr const t_dataptr_after_contexts = t_dataptr_after_pad + (t_contexts__size);
    BINPAC_ASSERT(t_dataptr_after_contexts <= t_end_of_data);
    t_DCE_RPC_Bind_Ack__size = t_dataptr_after_contexts - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->process_dce_rpc_bind_ack(this);
    BINPAC_ASSERT(t_begin_of_data + (t_DCE_RPC_Bind_Ack__size) <= t_end_of_data);
    return t_DCE_RPC_Bind_Ack__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Request::DCE_RPC_Request(DCE_RPC_Header* h) {
    alloc_hint_ = 0;
    context_id_ = 0;
    opnum_ = 0;
    has_object_case_index_ = -1;
    h_ = h;
    proc_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Request::~DCE_RPC_Request() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( has_object_case_index() ) {
        case ((int)1):
            // Clean up "uuid"
            {
                uuid_.free();
            }
            break;
        case ((int)0):
            // Clean up "no_uuid"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    stub_.free();
}

int DCE_RPC_Request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDCE_RPC* t_context, int t_byteorder) {
    // Checking out-of-bound for "DCE_RPC_Request:opnum"
    if ( (t_begin_of_data + 6) + (2) > t_end_of_data || (t_begin_of_data + 6) + (2) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DCE_RPC_Request:opnum",
        	(6) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "alloc_hint"
    alloc_hint_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "context_id"
    context_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "opnum"
    opnum_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "has_object"
    int t_has_object__size;
    has_object_case_index_ = h()->object();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( has_object_case_index() ) {
        case ((int)1):
            // Parse "uuid"
            {
                // Checking out-of-bound for "DCE_RPC_Request:uuid"
                if ( (t_begin_of_data + 8) + (16) > t_end_of_data || (t_begin_of_data + 8) + (16) < (t_begin_of_data + 8) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("DCE_RPC_Request:uuid",
                    	(8) + (16), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 8) + 16;
                    int t_uuid_string_length;
                    t_uuid_string_length = 16;
                    int t_uuid__size;
                    t_uuid__size = t_uuid_string_length;
                    uuid_.init((t_begin_of_data + 8), t_uuid_string_length);
                }
                t_has_object__size = 16;
            }
            break;
        case ((int)0):
            // Parse "no_uuid"
            {
                t_has_object__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("DCE_RPC_Request", (int64)has_object_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields


    const_byteptr const t_dataptr_after_has_object = (t_begin_of_data + 8) + (t_has_object__size);
    BINPAC_ASSERT(t_dataptr_after_has_object <= t_end_of_data);
    int stub_pad__size = (t_dataptr_after_has_object - t_begin_of_data) % 8;
    stub_pad__size = (stub_pad__size == 0) ? 0 : 8 - stub_pad__size;
    const_byteptr const t_dataptr_after_stub_pad = t_dataptr_after_has_object + stub_pad__size;
    // Parse "stub"
    int t_stub_string_length;
    t_stub_string_length = (t_end_of_data) - (t_dataptr_after_stub_pad);
    int t_stub__size;
    t_stub__size = t_stub_string_length;
    // check for negative sizes
    if ( t_stub_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/dce_rpc-protocol.pac:123", t_stub_string_length);
    stub_.init(t_dataptr_after_stub_pad, t_stub_string_length);

    int t_DCE_RPC_Request__size;
    const_byteptr const t_dataptr_after_stub = t_dataptr_after_stub_pad + (t_stub__size);
    BINPAC_ASSERT(t_dataptr_after_stub <= t_end_of_data);
    t_DCE_RPC_Request__size = t_dataptr_after_stub - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->process_dce_rpc_request(this);
    BINPAC_ASSERT(t_begin_of_data + (t_DCE_RPC_Request__size) <= t_end_of_data);
    return t_DCE_RPC_Request__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Response::DCE_RPC_Response() {
    alloc_hint_ = 0;
    context_id_ = 0;
    cancel_count_ = 0;
    reserved_ = 0;
    proc_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Response::~DCE_RPC_Response() {
    stub_.free();
}

int DCE_RPC_Response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDCE_RPC* t_context, int t_byteorder) {
    // Checking out-of-bound for "DCE_RPC_Response:stub_pad"
    if ( (t_begin_of_data + 8) + (0) > t_end_of_data || (t_begin_of_data + 8) + (0) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DCE_RPC_Response:stub_pad",
        	(8) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "alloc_hint"
    alloc_hint_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "context_id"
    context_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "cancel_count"
    cancel_count_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 6)));

    // Parse "reserved"
    reserved_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 7)));


    // Parse "stub"
    int t_stub_string_length;
    t_stub_string_length = (t_end_of_data) - ((t_begin_of_data + 8));
    int t_stub__size;
    t_stub__size = t_stub_string_length;
    // check for negative sizes
    if ( t_stub_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/dce_rpc-protocol.pac:132", t_stub_string_length);
    stub_.init((t_begin_of_data + 8), t_stub_string_length);

    int t_DCE_RPC_Response__size;
    const_byteptr const t_dataptr_after_stub = (t_begin_of_data + 8) + (t_stub__size);
    BINPAC_ASSERT(t_dataptr_after_stub <= t_end_of_data);
    t_DCE_RPC_Response__size = t_dataptr_after_stub - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->process_dce_rpc_response(this);
    BINPAC_ASSERT(t_begin_of_data + (t_DCE_RPC_Response__size) <= t_end_of_data);
    return t_DCE_RPC_Response__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_AlterContext::DCE_RPC_AlterContext() {
    max_xmit_frag_ = 0;
    max_recv_frag_ = 0;
    assoc_group_id_ = 0;
    context_list_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_AlterContext::~DCE_RPC_AlterContext() {
    delete context_list_;
    context_list_ = nullptr;
}

int DCE_RPC_AlterContext::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDCE_RPC* t_context, int t_byteorder) {
    // Checking out-of-bound for "DCE_RPC_AlterContext:assoc_group_id"
    if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DCE_RPC_AlterContext:assoc_group_id",
        	(4) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "max_xmit_frag"
    max_xmit_frag_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "max_recv_frag"
    max_recv_frag_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "assoc_group_id"
    assoc_group_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "context_list"
    context_list_ = new ContextList(true, DCE_RPC_ALTER_CONTEXT);
    int t_context_list__size;
    t_context_list__size = context_list_->Parse((t_begin_of_data + 8), t_end_of_data, t_context, t_byteorder);

    int t_DCE_RPC_AlterContext__size;
    const_byteptr const t_dataptr_after_context_list = (t_begin_of_data + 8) + (t_context_list__size);
    BINPAC_ASSERT(t_dataptr_after_context_list <= t_end_of_data);
    t_DCE_RPC_AlterContext__size = t_dataptr_after_context_list - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_DCE_RPC_AlterContext__size) <= t_end_of_data);
    return t_DCE_RPC_AlterContext__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_AlterContext_Resp::DCE_RPC_AlterContext_Resp() {
    max_xmit_frag_ = 0;
    max_recv_frag_ = 0;
    assoc_group_id_ = 0;
    sec_addr_length_ = 0;
    contexts_ = nullptr;
    proc_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_AlterContext_Resp::~DCE_RPC_AlterContext_Resp() {
    sec_addr_.free();
    delete contexts_;
    contexts_ = nullptr;
}

int DCE_RPC_AlterContext_Resp::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDCE_RPC* t_context, int t_byteorder) {
    // Checking out-of-bound for "DCE_RPC_AlterContext_Resp:sec_addr_length"
    if ( (t_begin_of_data + 8) + (2) > t_end_of_data || (t_begin_of_data + 8) + (2) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DCE_RPC_AlterContext_Resp:sec_addr_length",
        	(8) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "max_xmit_frag"
    max_xmit_frag_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "max_recv_frag"
    max_recv_frag_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "assoc_group_id"
    assoc_group_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "sec_addr_length"
    sec_addr_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "sec_addr"
    int t_sec_addr__size;
    t_sec_addr__size = sec_addr_length();
    // Checking out-of-bound for "DCE_RPC_AlterContext_Resp:sec_addr"
    if ( (t_begin_of_data + 10) + (t_sec_addr__size) > t_end_of_data || (t_begin_of_data + 10) + (t_sec_addr__size) < (t_begin_of_data + 10) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DCE_RPC_AlterContext_Resp:sec_addr",
        	(10) + (t_sec_addr__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 10) + t_sec_addr__size;
        int t_sec_addr_string_length;
        t_sec_addr_string_length = sec_addr_length();
        // check for negative sizes
        if ( t_sec_addr_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/dce_rpc-protocol.pac:147", t_sec_addr_string_length);
        sec_addr_.init((t_begin_of_data + 10), t_sec_addr_string_length);
    }


    const_byteptr const t_dataptr_after_sec_addr = (t_begin_of_data + 10) + (t_sec_addr__size);
    BINPAC_ASSERT(t_dataptr_after_sec_addr <= t_end_of_data);
    int pad__size = (t_dataptr_after_sec_addr - t_begin_of_data) % 4;
    pad__size = (pad__size == 0) ? 0 : 4 - pad__size;
    const_byteptr const t_dataptr_after_pad = t_dataptr_after_sec_addr + pad__size;
    // Parse "contexts"
    contexts_ = new ContextList(false, DCE_RPC_ALTER_CONTEXT_RESP);
    int t_contexts__size;
    t_contexts__size = contexts_->Parse(t_dataptr_after_pad, t_end_of_data, t_context, t_byteorder);

    int t_DCE_RPC_AlterContext_Resp__size;
    const_byteptr const t_dataptr_after_contexts = t_dataptr_after_pad + (t_contexts__size);
    BINPAC_ASSERT(t_dataptr_after_contexts <= t_end_of_data);
    t_DCE_RPC_AlterContext_Resp__size = t_dataptr_after_contexts - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->process_dce_rpc_alter_context_resp(this);
    BINPAC_ASSERT(t_begin_of_data + (t_DCE_RPC_AlterContext_Resp__size) <= t_end_of_data);
    return t_DCE_RPC_AlterContext_Resp__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Body::DCE_RPC_Body(DCE_RPC_Header* header) {
    val_case_index_ = -1;
    bind_ = nullptr;
    bind_ack_ = nullptr;
    request_ = nullptr;
    response_ = nullptr;
    alter_context_ = nullptr;
    alter_resp_ = nullptr;
    header_ = header;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Body::~DCE_RPC_Body() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)11):
            // Clean up "bind"
            {
                delete bind_;
                bind_ = nullptr;
            }
            break;
        case ((uint8)12):
            // Clean up "bind_ack"
            {
                delete bind_ack_;
                bind_ack_ = nullptr;
            }
            break;
        case ((uint8)0):
            // Clean up "request"
            {
                delete request_;
                request_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "response"
            {
                delete response_;
                response_ = nullptr;
            }
            break;
        case ((uint8)14):
            // Clean up "alter_context"
            {
                delete alter_context_;
                alter_context_ = nullptr;
            }
            break;
        case ((uint8)15):
            // Clean up "alter_resp"
            {
                delete alter_resp_;
                alter_resp_ = nullptr;
            }
            break;
        default:
            // Clean up "other"
            {
                other_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int DCE_RPC_Body::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDCE_RPC* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = header()->PTYPE();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)11):
            // Parse "bind"
            {
                bind_ = new DCE_RPC_Bind();
                int t_bind__size;
                t_bind__size = bind_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_bind__size;
            }
            break;
        case ((uint8)12):
            // Parse "bind_ack"
            {
                bind_ack_ = new DCE_RPC_Bind_Ack();
                int t_bind_ack__size;
                t_bind_ack__size = bind_ack_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_bind_ack__size;
            }
            break;
        case ((uint8)0):
            // Parse "request"
            {
                request_ = new DCE_RPC_Request(header());
                int t_request__size;
                t_request__size = request_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_request__size;
            }
            break;
        case ((uint8)2):
            // Parse "response"
            {
                response_ = new DCE_RPC_Response();
                int t_response__size;
                t_response__size = response_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_response__size;
            }
            break;
        case ((uint8)14):
            // Parse "alter_context"
            {
                alter_context_ = new DCE_RPC_AlterContext();
                int t_alter_context__size;
                t_alter_context__size = alter_context_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_alter_context__size;
            }
            break;
        case ((uint8)15):
            // Parse "alter_resp"
            {
                alter_resp_ = new DCE_RPC_AlterContext_Resp();
                int t_alter_resp__size;
                t_alter_resp__size = alter_resp_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_alter_resp__size;
            }
            break;
        default:
            // Parse "other"
            {
                int t_other_string_length;
                t_other_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_other__size;
                t_other__size = t_other_string_length;
                // check for negative sizes
                if ( t_other_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/dce_rpc-protocol.pac:159", t_other_string_length);
                other_.init(t_begin_of_data, t_other_string_length);
                t_val__size = t_other__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Auth_wrapper::DCE_RPC_Auth_wrapper(DCE_RPC_Header* header) {
    val_case_index_ = -1;
    auth_ = nullptr;
    header_ = header;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Auth_wrapper::~DCE_RPC_Auth_wrapper() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint16)0):
            // Clean up "none"
            {
            }
            break;
        default:
            // Clean up "auth"
            {
                delete auth_;
                auth_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int DCE_RPC_Auth_wrapper::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDCE_RPC* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = header()->auth_length();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint16)0):
            // Parse "none"
            {
                t_val__size = 0;
            }
            break;
        default:
            // Parse "auth"
            {
                auth_ = new DCE_RPC_Auth(header());
                int t_auth__size;
                t_auth__size = auth_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_auth__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Auth::DCE_RPC_Auth(DCE_RPC_Header* header) {
    type_ = 0;
    level_ = 0;
    pad_len_ = 0;
    reserved_ = 0;
    context_id_ = 0;
    header_ = header;
    proc_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Auth::~DCE_RPC_Auth() {
    blob_.free();
}

int DCE_RPC_Auth::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDCE_RPC* t_context, int t_byteorder) {
    // Checking out-of-bound for "DCE_RPC_Auth:context_id"
    if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DCE_RPC_Auth:context_id",
        	(4) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "type"
    type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "level"
    level_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "pad_len"
    pad_len_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "reserved"
    reserved_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "context_id"
    context_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "blob"
    int t_blob__size;
    t_blob__size = header()->auth_length();
    // Checking out-of-bound for "DCE_RPC_Auth:blob"
    if ( (t_begin_of_data + 8) + (t_blob__size) > t_end_of_data || (t_begin_of_data + 8) + (t_blob__size) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DCE_RPC_Auth:blob",
        	(8) + (t_blob__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 8) + t_blob__size;
        int t_blob_string_length;
        t_blob_string_length = header()->auth_length();
        // check for negative sizes
        if ( t_blob_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/dce_rpc-protocol.pac:173", t_blob_string_length);
        blob_.init((t_begin_of_data + 8), t_blob_string_length);
    }

    int t_DCE_RPC_Auth__size;
    const_byteptr const t_dataptr_after_blob = (t_begin_of_data + 8) + (t_blob__size);
    BINPAC_ASSERT(t_dataptr_after_blob <= t_end_of_data);
    t_DCE_RPC_Auth__size = t_dataptr_after_blob - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->forward_auth(this, true);
    BINPAC_ASSERT(t_begin_of_data + (t_DCE_RPC_Auth__size) <= t_end_of_data);
    return t_DCE_RPC_Auth__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Flow::DCE_RPC_Flow(DCE_RPC_Conn* connection, bool is_orig) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DCE_RPC_Flow::~DCE_RPC_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void DCE_RPC_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new DCE_RPC_PDU(is_orig());
                flow_buffer_->NewFrame(0, false);
                context_ = new ContextDCE_RPC(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            while ( ! t_dataunit_parsing_complete && flow_buffer_->ready() ) {
                const_byteptr t_begin_of_data = flow_buffer()->begin();
                const_byteptr t_end_of_data = flow_buffer()->end();
                t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
                if ( t_dataunit_parsing_complete ) {
                }
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e; // NOLINT(bugprone-exception-copy-constructor-throws)
    }
}

void DCE_RPC_Flow::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void DCE_RPC_Flow::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
bool DCE_RPC_Flow::reassemble_fragment(DCE_RPC_Header* header, bytestring const& frag) {

		auto it = fb.find(header->call_id());

		if ( header->firstfrag() )
			{
			if ( it != fb.end() )
				{
				// We already had a first frag earlier.
				connection()->zeek_analyzer()->Weird("multiple_first_fragments_in_dce_rpc_reassembly");
				connection()->zeek_analyzer()->SetSkip(true);
				return false;
				}

			if ( header->lastfrag() )
				{
				// all-in-one packet
				return true;
				}
			else
				{
				// first frag, but not last so we start a flowbuffer
				auto it = fb.emplace(header->call_id(),
				                     std::make_unique<FlowBuffer>());
				auto& flowbuf = it.first->second;
				flowbuf->NewFrame(0, true);
				flowbuf->BufferData(frag.begin(), frag.end());

				if ( fb.size() > zeek::BifConst::DCE_RPC::max_cmd_reassembly )
					{
					connection()->zeek_analyzer()->Weird("too_many_dce_rpc_msgs_in_reassembly");
					connection()->zeek_analyzer()->SetSkip(true);
					}

				if ( flowbuf->data_length() > (int)zeek::BifConst::DCE_RPC::max_frag_data )
					{
					connection()->zeek_analyzer()->Weird("too_much_dce_rpc_fragment_data");
					connection()->zeek_analyzer()->SetSkip(true);
					}

				return false;
				}
			}
		else if ( it != fb.end() )
			{
			// not the first frag, but we have a flow buffer so add to it
			auto& flowbuf = it->second;
			flowbuf->BufferData(frag.begin(), frag.end());

			if ( flowbuf->data_length() > (int)zeek::BifConst::DCE_RPC::max_frag_data )
				{
				connection()->zeek_analyzer()->Weird("too_much_dce_rpc_fragment_data");
				connection()->zeek_analyzer()->SetSkip(true);
				}

			return header->lastfrag();
			}
		else
			{
			// no flow buffer and not a first frag, ignore it.
			return false;
			}

		// can't reach here.
		return false;
		
}

const_bytestring DCE_RPC_Flow::reassembled_body(DCE_RPC_Header* h, bytestring const& body) {

		const_bytestring bd = body;
		auto it = fb.find(h->call_id());

		if ( it == fb.end() )
			return bd;

		auto& flowbuf = it->second;
		bd = const_bytestring(flowbuf->begin(), flowbuf->end());
		fb.erase(it);

		return bd;
		
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ATSVC_Request::ATSVC_Request(bool unicode, uint8 opnum) {
    op_case_index_ = -1;
    add_ = nullptr;
    unicode_ = unicode;
    opnum_ = opnum;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ATSVC_Request::~ATSVC_Request() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( op_case_index() ) {
        case ((uint8)0):
            // Clean up "add"
            {
                delete add_;
                add_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ATSVC_Request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {

    // Parse "op"
    int t_op__size;
    op_case_index_ = opnum();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( op_case_index() ) {
        case ((uint8)0):
            // Parse "add"
            {
                add_ = new ATSVC_NetrJobAdd(unicode());
                int t_add__size;
                t_add__size = add_->Parse((t_begin_of_data + 1), t_end_of_data, t_byteorder);
                t_op__size = t_add__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                int t_unknown_string_length;
                t_unknown_string_length = (t_end_of_data) - ((t_begin_of_data + 1));
                int t_unknown__size;
                t_unknown__size = t_unknown_string_length;
                // check for negative sizes
                if ( t_unknown_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/endpoint-atsvc.pac:6", t_unknown_string_length);
                unknown_.init((t_begin_of_data + 1), t_unknown_string_length);
                t_op__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_ATSVC_Request__size;
    const_byteptr const t_dataptr_after_op = (t_begin_of_data + 1) + (t_op__size);
    BINPAC_ASSERT(t_dataptr_after_op <= t_end_of_data);
    t_ATSVC_Request__size = t_dataptr_after_op - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ATSVC_Request__size) <= t_end_of_data);
    return t_ATSVC_Request__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ATSVC_String_Pointer::ATSVC_String_Pointer(bool unicode) {
    referent_id_ = 0;
    max_count_ = 0;
    offset_ = 0;
    actual_count_ = 0;
    unicode_ = unicode;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ATSVC_String_Pointer::~ATSVC_String_Pointer() {
    string_.free();
}

int ATSVC_String_Pointer::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "ATSVC_String_Pointer:actual_count"
    if ( (t_begin_of_data + 12) + (4) > t_end_of_data || (t_begin_of_data + 12) + (4) < (t_begin_of_data + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ATSVC_String_Pointer:actual_count",
        	(12) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "referent_id"
    referent_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "max_count"
    max_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "offset"
    offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "actual_count"
    actual_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

    // Parse "string"
    int t_string__size;
    t_string__size = max_count();
    // Checking out-of-bound for "ATSVC_String_Pointer:string"
    if ( (t_begin_of_data + 16) + (t_string__size) > t_end_of_data || (t_begin_of_data + 16) + (t_string__size) < (t_begin_of_data + 16) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ATSVC_String_Pointer:string",
        	(16) + (t_string__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 16) + t_string__size;
        int t_string_string_length;
        t_string_string_length = max_count();
        // check for negative sizes
        if ( t_string_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/endpoint-atsvc.pac:15", t_string_string_length);
        string_.init((t_begin_of_data + 16), t_string_string_length);
    }

    int t_ATSVC_String_Pointer__size;
    const_byteptr const t_dataptr_after_string = (t_begin_of_data + 16) + (t_string__size);
    BINPAC_ASSERT(t_dataptr_after_string <= t_end_of_data);
    t_ATSVC_String_Pointer__size = t_dataptr_after_string - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ATSVC_String_Pointer__size) <= t_end_of_data);
    return t_ATSVC_String_Pointer__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ATSVC_NetrJobAdd::ATSVC_NetrJobAdd(bool unicode) {
    server_ = nullptr;
    job_time_ = 0;
    days_of_month_ = 0;
    days_of_week_ = 0;
    flags_ = 0;
    command_ = nullptr;
    unicode_ = unicode;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ATSVC_NetrJobAdd::~ATSVC_NetrJobAdd() {
    delete server_;
    server_ = nullptr;
    delete command_;
    command_ = nullptr;
}

int ATSVC_NetrJobAdd::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "server"
    server_ = new ATSVC_String_Pointer(unicode());
    int t_server__size;
    t_server__size = server_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);


    const_byteptr const t_dataptr_after_server = t_begin_of_data + (t_server__size);
    BINPAC_ASSERT(t_dataptr_after_server <= t_end_of_data);
    // Checking out-of-bound for "ATSVC_NetrJobAdd:unknown2"
    if ( (t_dataptr_after_server + 12) + (2) > t_end_of_data || (t_dataptr_after_server + 12) + (2) < (t_dataptr_after_server + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ATSVC_NetrJobAdd:unknown2",
        	(((t_dataptr_after_server + 12) - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "job_time"
    job_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_server + 2))));

    // Parse "days_of_month"
    days_of_month_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_server + 6))));

    // Parse "days_of_week"
    days_of_week_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_server + 10)));

    // Parse "flags"
    flags_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_server + 11)));


    // Parse "command"
    command_ = new ATSVC_String_Pointer(unicode());
    int t_command__size;
    t_command__size = command_->Parse((t_dataptr_after_server + 14), t_end_of_data, t_byteorder);

    int t_ATSVC_NetrJobAdd__size;
    const_byteptr const t_dataptr_after_command = (t_dataptr_after_server + 14) + (t_command__size);
    BINPAC_ASSERT(t_dataptr_after_command <= t_end_of_data);
    t_ATSVC_NetrJobAdd__size = t_dataptr_after_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ATSVC_NetrJobAdd__size) <= t_end_of_data);
    return t_ATSVC_NetrJobAdd__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ATSVC_Reply::ATSVC_Reply(bool unicode, uint16 opnum) {
    op_case_index_ = -1;
    add_ = nullptr;
    unicode_ = unicode;
    opnum_ = opnum;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ATSVC_Reply::~ATSVC_Reply() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( op_case_index() ) {
        case ((uint16)0):
            // Clean up "add"
            {
                delete add_;
                add_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ATSVC_Reply::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "op"
    int t_op__size;
    op_case_index_ = opnum();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( op_case_index() ) {
        case ((uint16)0):
            // Parse "add"
            {
                add_ = new ATSVC_JobID(unicode());
                add_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_op__size = 8;
            }
            break;
        default:
            // Parse "unknown"
            {
                int t_unknown_string_length;
                t_unknown_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_unknown__size;
                t_unknown__size = t_unknown_string_length;
                // check for negative sizes
                if ( t_unknown_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/endpoint-atsvc.pac:32", t_unknown_string_length);
                unknown_.init(t_begin_of_data, t_unknown_string_length);
                t_op__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_ATSVC_Reply__size;
    const_byteptr const t_dataptr_after_op = t_begin_of_data + (t_op__size);
    BINPAC_ASSERT(t_dataptr_after_op <= t_end_of_data);
    t_ATSVC_Reply__size = t_dataptr_after_op - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ATSVC_Reply__size) <= t_end_of_data);
    return t_ATSVC_Reply__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ATSVC_JobID::ATSVC_JobID(bool unicode) {
    id_ = 0;
    status_ = 0;
    unicode_ = unicode;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ATSVC_JobID::~ATSVC_JobID() {
}

int ATSVC_JobID::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "ATSVC_JobID"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ATSVC_JobID",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "id"
    id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "status"
    status_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epmapper_lookup_req::epmapper_lookup_req() {
    inquiry_type_ = 0;
    object_ = 0;
    interface_id_ = 0;
    vers_option_ = 0;
    entry_handle_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epmapper_lookup_req::~epmapper_lookup_req() {
    delete entry_handle_;
    entry_handle_ = nullptr;
}

int epmapper_lookup_req::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "epmapper_lookup_req:vers_option"
    if ( (t_begin_of_data + 12) + (4) > t_end_of_data || (t_begin_of_data + 12) + (4) < (t_begin_of_data + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epmapper_lookup_req:vers_option",
        	(12) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "inquiry_type"
    inquiry_type_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "object"
    object_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "interface_id"
    interface_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "vers_option"
    vers_option_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

    // Parse "entry_handle"
    entry_handle_ = new context_handle();
    int t_entry_handle__size;
    t_entry_handle__size = entry_handle_->Parse((t_begin_of_data + 16), t_end_of_data, t_byteorder);

    int t_epmapper_lookup_req__size;
    const_byteptr const t_dataptr_after_entry_handle = (t_begin_of_data + 16) + (t_entry_handle__size);
    BINPAC_ASSERT(t_dataptr_after_entry_handle <= t_end_of_data);
    t_epmapper_lookup_req__size = t_dataptr_after_entry_handle - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_epmapper_lookup_req__size) <= t_end_of_data);
    return t_epmapper_lookup_req__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epmapper_map_req::epmapper_map_req() {
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epmapper_map_req::~epmapper_map_req() {
}

int epmapper_map_req::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "epmapper_map_req"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epmapper_map_req",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_uuid::epm_uuid() {
    if_version_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_uuid::~epm_uuid() {
    if_uuid_.free();
}

int epm_uuid::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "if_uuid"
    // Checking out-of-bound for "epm_uuid:if_uuid"
    if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epm_uuid:if_uuid",
        	(0) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 16;
        int t_if_uuid_string_length;
        t_if_uuid_string_length = 16;
        int t_if_uuid__size;
        t_if_uuid__size = t_if_uuid_string_length;
        if_uuid_.init(t_begin_of_data, t_if_uuid_string_length);
    }

    const_byteptr const t_dataptr_after_if_uuid = t_begin_of_data + (16);
    BINPAC_ASSERT(t_dataptr_after_if_uuid <= t_end_of_data);
    // Checking out-of-bound for "epm_uuid:if_version"
    if ( t_dataptr_after_if_uuid + (2) > t_end_of_data || t_dataptr_after_if_uuid + (2) < t_dataptr_after_if_uuid ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epm_uuid:if_version",
        	((t_dataptr_after_if_uuid - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "if_version"
    if_version_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_dataptr_after_if_uuid)));

    int t_epm_uuid__size;
    t_epm_uuid__size = (t_dataptr_after_if_uuid + 2) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_epm_uuid__size) <= t_end_of_data);
    return t_epm_uuid__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_port::epm_port() {
    val_ = 0;
    byteorder_ = bigendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_port::~epm_port() {
}

int epm_port::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "epm_port:val"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epm_port:val",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    val_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_ip::epm_ip() {
    val_ = 0;
    byteorder_ = bigendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_ip::~epm_ip() {
}

int epm_ip::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "epm_ip:val"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epm_ip:val",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    val_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_lhs_data::epm_lhs_data(uint16 length, uint8 protocol) {
    val_case_index_ = -1;
    uuid_ = nullptr;
    length_ = length;
    protocol_ = protocol;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_lhs_data::~epm_lhs_data() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)13):
            // Clean up "uuid"
            {
                delete uuid_;
                uuid_ = nullptr;
            }
            break;
        default:
            // Clean up "other"
            {
                other_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int epm_lhs_data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    int t_val__size;
    val_case_index_ = protocol();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)13):
            // Parse "uuid"
            {
                uuid_ = new epm_uuid();
                int t_uuid__size;
                t_uuid__size = uuid_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_uuid__size;
            }
            break;
        default:
            // Parse "other"
            {
                int t_other__size;
                t_other__size = length();
                // Checking out-of-bound for "epm_lhs_data:other"
                if ( t_begin_of_data + (t_other__size) > t_end_of_data || t_begin_of_data + (t_other__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("epm_lhs_data:other",
                    	(0) + (t_other__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_other__size;
                    int t_other_string_length;
                    t_other_string_length = length();
                    // check for negative sizes
                    if ( t_other_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/endpoint-epmapper.pac:31", t_other_string_length);
                    other_.init(t_begin_of_data, t_other_string_length);
                }
                t_val__size = t_other__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_rhs_data::epm_rhs_data(uint16 length, uint8 protocol) {
    val_case_index_ = -1;
    tcp_ = 0;
    udp_ = 0;
    ip_ = 0;
    length_ = length;
    protocol_ = protocol;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_rhs_data::~epm_rhs_data() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)7):
            // Clean up "tcp"
            {
            }
            break;
        case ((uint8)8):
            // Clean up "udp"
            {
            }
            break;
        case ((uint8)9):
            // Clean up "ip"
            {
            }
            break;
        default:
            // Clean up "other"
            {
                other_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int epm_rhs_data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    int t_val__size;
    val_case_index_ = protocol();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)7):
            // Parse "tcp"
            {
                // Checking out-of-bound for "epm_rhs_data:tcp"
                if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("epm_rhs_data:tcp",
                    	(0) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                tcp_ = FixByteOrder(bigendian, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
                t_val__size = 2;
            }
            break;
        case ((uint8)8):
            // Parse "udp"
            {
                // Checking out-of-bound for "epm_rhs_data:udp"
                if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("epm_rhs_data:udp",
                    	(0) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                udp_ = FixByteOrder(bigendian, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
                t_val__size = 2;
            }
            break;
        case ((uint8)9):
            // Parse "ip"
            {
                // Checking out-of-bound for "epm_rhs_data:ip"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("epm_rhs_data:ip",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                ip_ = FixByteOrder(bigendian, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
                t_val__size = 4;
            }
            break;
        default:
            // Parse "other"
            {
                int t_other__size;
                t_other__size = length();
                // Checking out-of-bound for "epm_rhs_data:other"
                if ( t_begin_of_data + (t_other__size) > t_end_of_data || t_begin_of_data + (t_other__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("epm_rhs_data:other",
                    	(0) + (t_other__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_other__size;
                    int t_other_string_length;
                    t_other_string_length = length();
                    // check for negative sizes
                    if ( t_other_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dce-rpc/endpoint-epmapper.pac:38", t_other_string_length);
                    other_.init(t_begin_of_data, t_other_string_length);
                }
                t_val__size = t_other__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_lhs::epm_lhs() {
    length_ = 0;
    protocol_ = 0;
    data_ = nullptr;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_lhs::~epm_lhs() {
    delete data_;
    data_ = nullptr;
}

int epm_lhs::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "epm_lhs:protocol"
    if ( (t_begin_of_data + 2) + (1) > t_end_of_data || (t_begin_of_data + 2) + (1) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epm_lhs:protocol",
        	(2) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "protocol"
    protocol_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "data"
    data_ = new epm_lhs_data(length() - 1, protocol());
    int t_data__size;
    t_data__size = data_->Parse((t_begin_of_data + 3), t_end_of_data);

    int t_epm_lhs__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 3) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_epm_lhs__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_epm_lhs__size) <= t_end_of_data);
    return t_epm_lhs__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_rhs::epm_rhs(uint8 protocol) {
    length_ = 0;
    data_ = nullptr;
    protocol_ = protocol;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_rhs::~epm_rhs() {
    delete data_;
    data_ = nullptr;
}

int epm_rhs::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "epm_rhs:length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epm_rhs:length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "data"
    data_ = new epm_rhs_data(length(), protocol());
    int t_data__size;
    t_data__size = data_->Parse((t_begin_of_data + 2), t_end_of_data);

    int t_epm_rhs__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 2) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_epm_rhs__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_epm_rhs__size) <= t_end_of_data);
    return t_epm_rhs__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_floor::epm_floor() {
    lhs_ = nullptr;
    rhs_ = nullptr;
    protocol_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_floor::~epm_floor() {
    delete lhs_;
    lhs_ = nullptr;
    delete rhs_;
    rhs_ = nullptr;
}

int epm_floor::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "lhs"
    lhs_ = new epm_lhs();
    int t_lhs__size;
    t_lhs__size = lhs_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_lhs = t_begin_of_data + (t_lhs__size);
    BINPAC_ASSERT(t_dataptr_after_lhs <= t_end_of_data);
    // Parse "rhs"
    protocol_ = lhs()->protocol();
    rhs_ = new epm_rhs(protocol());
    int t_rhs__size;
    t_rhs__size = rhs_->Parse(t_dataptr_after_lhs, t_end_of_data);

    int t_epm_floor__size;
    const_byteptr const t_dataptr_after_rhs = t_dataptr_after_lhs + (t_rhs__size);
    BINPAC_ASSERT(t_dataptr_after_rhs <= t_end_of_data);
    t_epm_floor__size = t_dataptr_after_rhs - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_epm_floor__size) <= t_end_of_data);
    return t_epm_floor__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_tower::epm_tower() {
    num_floors_ = 0;
    floors_ = nullptr;
    floors__elem_ = nullptr;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_tower::~epm_tower() {
    delete floors__elem_;
    floors__elem_ = nullptr;
    if ( floors() ) {
        for ( auto* floors__elem_ : *floors() ) {
            delete floors__elem_;
            floors__elem_ = nullptr;
        }
    }
    delete floors_;
}

int epm_tower::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "epm_tower:num_floors"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epm_tower:num_floors",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "num_floors"
    num_floors_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "floors"
    int t_floors__arraylength;
    t_floors__arraylength = num_floors();
    if ( t_floors__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("epm_tower:floors",
          t_floors__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: epm_tower:floors
    if ( t_floors__arraylength > ((t_end_of_data - (t_begin_of_data + 2)) / 1) )
        throw binpac::ExceptionOutOfBound("epm_tower:floors",
          t_floors__arraylength, (t_end_of_data) - ((t_begin_of_data + 2)));
    floors__elem_ = nullptr;
    int t_floors__elem__it;
    t_floors__elem__it = 0;
    int t_floors__size;
    floors_ = new vector<epm_floor*>;
    floors_->reserve(t_floors__arraylength);
    const_byteptr t_floors__elem__dataptr = (t_begin_of_data + 2);
    for (; t_floors__elem__it < t_floors__arraylength; ++t_floors__elem__it) {
        floors__elem_ = new epm_floor();
        int t_floors__elem__size;
        t_floors__elem__size = floors__elem_->Parse(t_floors__elem__dataptr, t_end_of_data);
        floors_->push_back(floors__elem_);
        t_floors__elem__dataptr += t_floors__elem__size;
        BINPAC_ASSERT(t_floors__elem__dataptr <= t_end_of_data);
        floors__elem_ = nullptr;
    }
end_of_floors: ;
    t_floors__size = t_floors__elem__dataptr - ((t_begin_of_data + 2));
    // Evaluate 'let' and 'withinput' fields

    int t_epm_tower__size;
    const_byteptr const t_dataptr_after_floors = (t_begin_of_data + 2) + (t_floors__size);
    BINPAC_ASSERT(t_dataptr_after_floors <= t_end_of_data);
    t_epm_tower__size = t_dataptr_after_floors - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_epm_tower__size) <= t_end_of_data);
    return t_epm_tower__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_twr_p::epm_twr_p() {
    ref_ = 0;
    length_ = 0;
    tower_length_ = 0;
    tower_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_twr_p::~epm_twr_p() {
    delete tower_;
    tower_ = nullptr;
}

int epm_twr_p::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "epm_twr_p:tower_length"
    if ( (t_begin_of_data + 8) + (4) > t_end_of_data || (t_begin_of_data + 8) + (4) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epm_twr_p:tower_length",
        	(8) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "ref"
    ref_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "tower_length"
    tower_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "tower"
    tower_ = new epm_tower();
    int t_tower__size;
    t_tower__size = tower_length();
    // Checking out-of-bound for "epm_twr_p:tower"
    if ( (t_begin_of_data + 12) + (t_tower__size) > t_end_of_data || (t_begin_of_data + 12) + (t_tower__size) < (t_begin_of_data + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epm_twr_p:tower",
        	(12) + (t_tower__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 12) + t_tower__size;
        tower_->Parse((t_begin_of_data + 12), t_end_of_data);
    }

    int t_epm_twr_p__size;
    const_byteptr const t_dataptr_after_tower = (t_begin_of_data + 12) + (t_tower__size);
    BINPAC_ASSERT(t_dataptr_after_tower <= t_end_of_data);
    t_epm_twr_p__size = t_dataptr_after_tower - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_epm_twr_p__size) <= t_end_of_data);
    return t_epm_twr_p__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_tower_array::epm_tower_array() {
    max_count_ = 0;
    offset_ = 0;
    actual_count_ = 0;
    towers_ = nullptr;
    towers__elem_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epm_tower_array::~epm_tower_array() {
    delete towers__elem_;
    towers__elem_ = nullptr;
    if ( towers() ) {
        for ( auto* towers__elem_ : *towers() ) {
            delete towers__elem_;
            towers__elem_ = nullptr;
        }
    }
    delete towers_;
}

int epm_tower_array::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "epm_tower_array:actual_count"
    if ( (t_begin_of_data + 8) + (4) > t_end_of_data || (t_begin_of_data + 8) + (4) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epm_tower_array:actual_count",
        	(8) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "max_count"
    max_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "offset"
    offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "actual_count"
    actual_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "towers"
    int t_towers__arraylength;
    t_towers__arraylength = actual_count();
    if ( t_towers__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("epm_tower_array:towers",
          t_towers__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: epm_tower_array:towers
    if ( t_towers__arraylength > ((t_end_of_data - (t_begin_of_data + 12)) / 1) )
        throw binpac::ExceptionOutOfBound("epm_tower_array:towers",
          t_towers__arraylength, (t_end_of_data) - ((t_begin_of_data + 12)));
    towers__elem_ = nullptr;
    int t_towers__elem__it;
    t_towers__elem__it = 0;
    int t_towers__size;
    towers_ = new vector<epm_twr_p*>;
    towers_->reserve(t_towers__arraylength);
    const_byteptr t_towers__elem__dataptr = (t_begin_of_data + 12);
    for (; t_towers__elem__it < t_towers__arraylength; ++t_towers__elem__it) {
        towers__elem_ = new epm_twr_p();
        int t_towers__elem__size;
        t_towers__elem__size = towers__elem_->Parse(t_towers__elem__dataptr, t_end_of_data, t_byteorder);
        towers_->push_back(towers__elem_);
        t_towers__elem__dataptr += t_towers__elem__size;
        BINPAC_ASSERT(t_towers__elem__dataptr <= t_end_of_data);
        towers__elem_ = nullptr;
    }
end_of_towers: ;
    t_towers__size = t_towers__elem__dataptr - ((t_begin_of_data + 12));
    // Evaluate 'let' and 'withinput' fields

    int t_epm_tower_array__size;
    const_byteptr const t_dataptr_after_towers = (t_begin_of_data + 12) + (t_towers__size);
    BINPAC_ASSERT(t_dataptr_after_towers <= t_end_of_data);
    t_epm_tower_array__size = t_dataptr_after_towers - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_epm_tower_array__size) <= t_end_of_data);
    return t_epm_tower_array__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epmapper_map_resp::epmapper_map_resp() {
    entry_handle_ = nullptr;
    num_towers_ = 0;
    towers_ = nullptr;
    return_code_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
epmapper_map_resp::~epmapper_map_resp() {
    delete entry_handle_;
    entry_handle_ = nullptr;
    delete towers_;
    towers_ = nullptr;
}

int epmapper_map_resp::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "entry_handle"
    entry_handle_ = new context_handle();
    int t_entry_handle__size;
    t_entry_handle__size = entry_handle_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_entry_handle = t_begin_of_data + (t_entry_handle__size);
    BINPAC_ASSERT(t_dataptr_after_entry_handle <= t_end_of_data);
    // Checking out-of-bound for "epmapper_map_resp:num_towers"
    if ( t_dataptr_after_entry_handle + (4) > t_end_of_data || t_dataptr_after_entry_handle + (4) < t_dataptr_after_entry_handle ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epmapper_map_resp:num_towers",
        	((t_dataptr_after_entry_handle - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "num_towers"
    num_towers_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_entry_handle)));

    // Parse "towers"
    towers_ = new epm_tower_array();
    int t_towers__size;
    t_towers__size = towers_->Parse((t_dataptr_after_entry_handle + 4), t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_towers = (t_dataptr_after_entry_handle + 4) + (t_towers__size);
    BINPAC_ASSERT(t_dataptr_after_towers <= t_end_of_data);
    // Checking out-of-bound for "epmapper_map_resp:return_code"
    if ( t_dataptr_after_towers + (4) > t_end_of_data || t_dataptr_after_towers + (4) < t_dataptr_after_towers ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("epmapper_map_resp:return_code",
        	((t_dataptr_after_towers - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "return_code"
    return_code_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_towers)));

    int t_epmapper_map_resp__size;
    t_epmapper_map_resp__size = (t_dataptr_after_towers + 4) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_epmapper_map_resp__size) <= t_end_of_data);
    return t_epmapper_map_resp__size;
}

} // namespace DCE_RPC
}  // namespace binpac
