// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/dhcp/dhcp_pac.h"

namespace binpac {






namespace DHCP {
// NOLINTNEXTLINE(modernize-use-equals-default)
ContextDHCP::ContextDHCP(DHCP_Conn* connection, DHCP_Flow* flow) {
    connection_ = connection;
    flow_ = flow;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextDHCP::~ContextDHCP() {
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DHCP_Conn::DHCP_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new DHCP_Flow(this, true);
    downflow_ = new DHCP_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DHCP_Conn::~DHCP_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void DHCP_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void DHCP_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void DHCP_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DHCP_Flow::DHCP_Flow(DHCP_Conn* connection, bool is_orig) {
    connection_ = connection;
    is_orig_ = is_orig;

		options = nullptr;
		all_options = nullptr;
	

		sum_len = 0;
	
    dataunit_ = nullptr;
    context_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DHCP_Flow::~DHCP_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;

		options = nullptr;
		all_options = nullptr;
	

		sum_len = 0;
	
}

void DHCP_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        dataunit_ = new DHCP_Message(is_orig());
        context_ = new ContextDHCP(connection(), this);
        int t_dataunit__size;
        t_dataunit__size = dataunit_->Parse(t_begin_of_data, t_end_of_data, context_);
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;

		options = nullptr;
		all_options = nullptr;
	

		sum_len = 0;
	
        throw e; // NOLINT(bugprone-exception-copy-constructor-throws)
    }
}

void DHCP_Flow::NewGap(int gap_length) {
}
void DHCP_Flow::FlowEOF() {
}
uint8 DHCP_Flow::get_dhcp_msgtype(vector<Option*>* options) {

		uint8 type = 0;
		for ( auto ptr = options->begin();
		      ptr != options->end() && ! (*ptr)->last(); ++ptr )
			{
			if ( (*ptr)->code() == MSG_TYPE_OPTION )
				{
				type = (*ptr)->info()->value()->msg_type();
				break;
				}
			}

		if ( type == 0 )
			connection()->zeek_analyzer()->AnalyzerViolation("no DHCP message type option");

		return type;
		
}

bool DHCP_Flow::init_options() {

		if ( ! options )
			{
			options = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::DHCP::Options);
			all_options = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);
			options->Assign(0, all_options);
			}

		return true;
		
}

bool DHCP_Flow::create_options(uint8 code) {

		init_options();

		if ( code != 255 )
			all_options->Assign(all_options->Size(), zeek::val_mgr->Count(code));

		return true;
		
}

bool DHCP_Flow::process_dhcp_message(DHCP_Message* msg) {

		// Check whether the options in the message conform to
		// DHCP or BOOTP.  If not, we are unable to interpret
		// the message options.
		if ( msg->cookie() != 0x63825363 )
			{
			connection()->zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("bad cookie (%d)", msg->cookie()));
			return false;
			}

		if ( dhcp_message )
			{
			std::string mac_str = zeek::fmt_mac(msg->chaddr().data(), msg->chaddr().length());
			double secs = static_cast<double>(msg->secs());

			auto dhcp_msg_val = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::DHCP::Msg);
			dhcp_msg_val->Assign(0, msg->op());
			dhcp_msg_val->Assign(1, msg->type());
			dhcp_msg_val->Assign(2, msg->xid());
			dhcp_msg_val->AssignInterval(3, secs);
			dhcp_msg_val->Assign(4, msg->flags());
			dhcp_msg_val->Assign(5, zeek::make_intrusive<zeek::AddrVal>(htonl(msg->ciaddr())));
			dhcp_msg_val->Assign(6, zeek::make_intrusive<zeek::AddrVal>(htonl(msg->yiaddr())));
			dhcp_msg_val->Assign(7, zeek::make_intrusive<zeek::AddrVal>(htonl(msg->siaddr())));
			dhcp_msg_val->Assign(8, zeek::make_intrusive<zeek::AddrVal>(htonl(msg->giaddr())));
			dhcp_msg_val->Assign(9, mac_str);

			int last_non_null = 0;

			for ( int i = 0; i < msg->sname().length(); ++i )
				{
				if ( *(msg->sname().begin() + i) != 0 )
					last_non_null = i;
				}

			if ( last_non_null > 0 )
				dhcp_msg_val->Assign(10, zeek::make_intrusive<zeek::StringVal>(last_non_null + 1,
				                                                   reinterpret_cast<const char*>(msg->sname().begin())));

			last_non_null = 0;

			for ( int i = 0; i < msg->file_n().length(); ++i )
				{
				if ( *(msg->file_n().begin() + i) != 0 )
					last_non_null = i;
				}

			if ( last_non_null > 0 )
				dhcp_msg_val->Assign(11, zeek::make_intrusive<zeek::StringVal>(last_non_null + 1,
				                                                   reinterpret_cast<const char*>(msg->file_n().begin())));

			init_options();

			zeek::BifEvent::enqueue_dhcp_message(connection()->zeek_analyzer(),
			                               connection()->zeek_analyzer()->Conn(),
			                               msg->is_orig(),
			                               std::move(dhcp_msg_val),
			                               std::move(options));

			options = nullptr;
			all_options = nullptr;
			}

		// A single message reaching this point is enough to confirm the protocol
		// because it's not uncommon to see a single DHCP message
		// on a "connection".
		// The binpac analyzer would have thrown an error before this point
		// if there was a problem too (and subsequently called AnalyzerViolation).
		connection()->zeek_analyzer()->AnalyzerConfirmation();

		return true;
		
}

bool DHCP_Flow::process_subnet_option(OptionValue* v) {

		context_->flow()->options->Assign(1, zeek::make_intrusive<zeek::AddrVal>(htonl(v->subnet())));
		return true;
		
}

bool DHCP_Flow::process_time_offset_option(OptionValue* v) {

		context_->flow()->options->Assign(25, v->time_offset());
		return true;
		
}

bool DHCP_Flow::process_router_option(OptionValue* v) {

		auto router_list = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::DHCP::Addrs);
		int num_routers = v->router_list()->size();
		vector<uint32>* rlist = v->router_list();

		for ( int i = 0; i < num_routers; ++i )
			{
			uint32 raddr = (*rlist)[i];
			router_list->Assign(i, zeek::make_intrusive<zeek::AddrVal>(htonl(raddr)));
			}

		context_->flow()->options->Assign(2, std::move(router_list));

		return true;
		
}

bool DHCP_Flow::process_timeserver_option(OptionValue* v) {

		auto timeserver_list = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::DHCP::Addrs);
		int num_servers = v->timeserver_list()->size();
		vector<uint32>* rlist = v->timeserver_list();

		for ( int i = 0; i < num_servers; ++i )
			{
			uint32 raddr = (*rlist)[i];
			timeserver_list->Assign(i, zeek::make_intrusive<zeek::AddrVal>(htonl(raddr)));
			}

		context_->flow()->options->Assign(26, std::move(timeserver_list));

		return true;
		
}

bool DHCP_Flow::process_nameserver_option(OptionValue* v) {

		auto nameserver_list = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::DHCP::Addrs);
		int num_servers = v->nameserver_list()->size();
		vector<uint32>* rlist = v->nameserver_list();

		for ( int i = 0; i < num_servers; ++i )
			{
			uint32 raddr = (*rlist)[i];
			nameserver_list->Assign(i, zeek::make_intrusive<zeek::AddrVal>(htonl(raddr)));
			}

		context_->flow()->options->Assign(27, std::move(nameserver_list));

		return true;
		
}

bool DHCP_Flow::process_dns_server_option(OptionValue* v) {

		auto server_list = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::DHCP::Addrs);
		int num_servers = v->dns_server_list()->size();
		vector<uint32>* rlist = v->dns_server_list();

		for ( int i = 0; i < num_servers; ++i )
			{
			uint32 raddr = (*rlist)[i];
			server_list->Assign(i, zeek::make_intrusive<zeek::AddrVal>(htonl(raddr)));
			}

		context_->flow()->options->Assign(3, std::move(server_list));
		return true;
		
}

bool DHCP_Flow::process_host_name_option(OptionValue* v) {

		context_->flow()->options->Assign(4, zeek::make_intrusive<zeek::StringVal>(v->host_name().length(),
		                                                  reinterpret_cast<const char*>(v->host_name().begin())));

		return true;
		
}

bool DHCP_Flow::process_domain_name_option(OptionValue* v) {

		int last_non_null = 0;

		for ( int i = 0; i < v->domain_name().length(); ++i )
			{
			if ( *(v->domain_name().begin() + i ) != 0 )
				last_non_null = i;
			}

		context_->flow()->options->Assign(5, zeek::make_intrusive<zeek::StringVal>(last_non_null == 0 ? 0 : last_non_null + 1,
		                                                  reinterpret_cast<const char*>(v->domain_name().begin())));

		return true;
		
}

bool DHCP_Flow::process_forwarding_option(OptionValue* v) {

		context_->flow()->options->Assign(6, v->forwarding() == 0 ? false : true);

		return true;
		
}

bool DHCP_Flow::process_broadcast_address_option(OptionValue* v) {

		context_->flow()->options->Assign(7, zeek::make_intrusive<zeek::AddrVal>(htonl(v->broadcast_address())));

		return true;
		
}

bool DHCP_Flow::process_ntpserver_option(OptionValue* v) {

		auto ntpserver_list = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::DHCP::Addrs);
		int num_servers = v->ntpserver_list()->size();
		vector<uint32>* rlist = v->ntpserver_list();

		for ( int i = 0; i < num_servers; ++i )
			{
			uint32 raddr = (*rlist)[i];
			ntpserver_list->Assign(i, zeek::make_intrusive<zeek::AddrVal>(htonl(raddr)));
			}

		context_->flow()->options->Assign(28, std::move(ntpserver_list));

		return true;
		
}

bool DHCP_Flow::process_vendor_specific_option(OptionValue* v) {

		context_->flow()->options->Assign(8, zeek::make_intrusive<zeek::StringVal>(v->vendor_specific().length(),
		                                                  reinterpret_cast<const char*>(v->vendor_specific().begin())));

		return true;
		
}

bool DHCP_Flow::process_nbns_option(OptionValue* v) {

		auto server_list = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::DHCP::Addrs);
		int num_servers = v->nbns()->size();
		vector<uint32>* rlist = v->nbns();

		for ( int i = 0; i < num_servers; ++i )
			{
			uint32 raddr = (*rlist)[i];
			server_list->Assign(i, zeek::make_intrusive<zeek::AddrVal>(htonl(raddr)));
			}

		context_->flow()->options->Assign(9, std::move(server_list));
		return true;
		
}

bool DHCP_Flow::process_addr_request_option(OptionValue* v) {

		context_->flow()->options->Assign(10, zeek::make_intrusive<zeek::AddrVal>(htonl(v->addr_request())));

		return true;
		
}

bool DHCP_Flow::process_lease_option(OptionValue* v) {

		double lease = static_cast<double>(v->lease());
		context_->flow()->options->AssignInterval(11, lease);

		return true;
		
}

bool DHCP_Flow::process_serv_id_option(OptionValue* v) {

		context_->flow()->options->Assign(12, zeek::make_intrusive<zeek::AddrVal>(htonl(v->serv_addr())));

		return true;
		
}

bool DHCP_Flow::process_par_req_list_option(OptionValue* v) {

		auto params = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);
		int num_params = v->par_req_list()->size();
		vector<uint8>* plist = v->par_req_list();

		for ( int i = 0; i < num_params; ++i )
			{
			uint8 param = (*plist)[i];
			params->Assign(i, zeek::val_mgr->Count(param));
			}

		context_->flow()->options->Assign(13, std::move(params));

		return true;
		
}

bool DHCP_Flow::process_message_option(OptionValue* v) {

		context_->flow()->options->Assign(14, zeek::make_intrusive<zeek::StringVal>(v->message().length(),
		                                                   reinterpret_cast<const char*>(v->message().begin())));

		return true;
		
}

bool DHCP_Flow::process_max_message_size_option(OptionValue* v) {

		context_->flow()->options->Assign(15, v->max_msg_size());

		return true;
		
}

bool DHCP_Flow::process_renewal_time_option(OptionValue* v) {

		double renewal_time = static_cast<double>(v->renewal_time());
		context_->flow()->options->AssignInterval(16, renewal_time);

		return true;
		
}

bool DHCP_Flow::process_rebinding_time_option(OptionValue* v) {

		double rebinding_time = static_cast<double>(v->rebinding_time());
		context_->flow()->options->AssignInterval(17, rebinding_time);

		return true;
		
}

bool DHCP_Flow::process_vendor_class_option(OptionValue* v) {

		context_->flow()->options->Assign(18, zeek::make_intrusive<zeek::StringVal>(v->vendor_class().length(),
		                                                   reinterpret_cast<const char*>(v->vendor_class().begin())));

		return true;
		
}

bool DHCP_Flow::process_client_id_option(OptionValue* v) {

		auto client_id = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::DHCP::ClientID);
		client_id->Assign(0, v->client_id()->hwtype());
		zeek::StringValPtr sv;

		if ( v->client_id()->hwtype() == 0 )
			sv = zeek::make_intrusive<zeek::StringVal>(v->client_id()->hwaddr().length(),
			                                     reinterpret_cast<const char*>(v->client_id()->hwaddr().begin()));
		else
			sv = zeek::make_intrusive<zeek::StringVal>(zeek::fmt_mac(v->client_id()->hwaddr().begin(),
			                                     v->client_id()->hwaddr().length()));

		client_id->Assign(1, std::move(sv));

		context_->flow()->options->Assign(19, std::move(client_id));

		return true;
		
}

bool DHCP_Flow::process_user_class_option(OptionValue* v) {

		context_->flow()->options->Assign(20, zeek::make_intrusive<zeek::StringVal>(v->user_class().length(),
		                                                   reinterpret_cast<const char*>(v->user_class().begin())));

		return true;
		
}

bool DHCP_Flow::process_client_fqdn_option(OptionValue* v) {

		auto client_fqdn = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::DHCP::ClientFQDN);
		client_fqdn->Assign(0, v->client_fqdn()->flags());
		client_fqdn->Assign(1, v->client_fqdn()->rcode1());
		client_fqdn->Assign(2, v->client_fqdn()->rcode2());
		const char* domain_name = reinterpret_cast<const char*>(v->client_fqdn()->domain_name().begin());
		client_fqdn->Assign(3, zeek::make_intrusive<zeek::StringVal>(v->client_fqdn()->domain_name().length(), domain_name));

		context_->flow()->options->Assign(21, std::move(client_fqdn));

		return true;
		
}

uint8 DHCP_Flow::get_dhcp_sumlen(uint8 len) {

		sum_len = len + sum_len;
		return sum_len;
		
}

bool DHCP_Flow::process_relay_agent_inf_option(OptionValue* v) {

		auto relay_agent_sub_opt = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::DHCP::SubOpts);

		uint16 i = 0;

		for ( const auto& ptrsubopt : *v->relay_agent_inf() )
			{
			auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::DHCP::SubOpt);
			r->Assign(0, ptrsubopt->code());
			r->Assign(1, to_stringval(ptrsubopt->value()));

			relay_agent_sub_opt->Assign(i, std::move(r));
			++i;
			}

		context_->flow()->options->Assign(22, std::move(relay_agent_sub_opt));
		return true;
		
}

bool DHCP_Flow::process_auto_config_option(OptionValue* v) {

		context_->flow()->options->Assign(23, v->auto_config() == 0 ? false : true);

		return true;
		
}

bool DHCP_Flow::process_auto_proxy_config_option(OptionValue* v) {

		int string_len = v->auto_proxy_config().length();

		if ( string_len == 0 )
			{
			context_->flow()->options->Assign(24, zeek::make_intrusive<zeek::StringVal>(0, ""));
			return true;
			}


		const char* last_char = reinterpret_cast<const char*>(v->auto_proxy_config().begin() + string_len - 1);

		bool has_newline = *last_char == '\x0a';

		if ( has_newline )
			--string_len;

		context_->flow()->options->Assign(24, zeek::make_intrusive<zeek::StringVal>(string_len,
		                                                   reinterpret_cast<const char*>(v->auto_proxy_config().begin())));

		return true;
		
}

int const MSG_TYPE_OPTION = 53;
// NOLINTNEXTLINE(modernize-use-equals-default)
OptionValue::OptionValue(uint8 code, uint8 length) {
    val_case_index_ = -1;
    msg_type_ = 0;
    subnet_ = 0;
    time_offset_ = 0;
    router_list_ = nullptr;
    router_list__elem_ = 0;
    timeserver_list_ = nullptr;
    timeserver_list__elem_ = 0;
    nameserver_list_ = nullptr;
    nameserver_list__elem_ = 0;
    dns_server_list_ = nullptr;
    dns_server_list__elem_ = 0;
    forwarding_ = 0;
    broadcast_address_ = 0;
    ntpserver_list_ = nullptr;
    ntpserver_list__elem_ = 0;
    nbns_ = nullptr;
    nbns__elem_ = 0;
    addr_request_ = 0;
    lease_ = 0;
    serv_addr_ = 0;
    par_req_list_ = nullptr;
    par_req_list__elem_ = 0;
    max_msg_size_ = 0;
    renewal_time_ = 0;
    rebinding_time_ = 0;
    client_id_ = nullptr;
    client_fqdn_ = nullptr;
    relay_agent_inf_ = nullptr;
    relay_agent_inf__elem_ = nullptr;
    auto_config_ = 0;
    code_ = code;
    length_ = length;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
OptionValue::~OptionValue() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)53):
            // Clean up "msg_type"
            {
            }
            break;
        case ((uint8)1):
            // Clean up "subnet"
            {
            }
            break;
        case ((uint8)2):
            // Clean up "time_offset"
            {
            }
            break;
        case ((uint8)3):
            // Clean up "router_list"
            {
                delete router_list_;
            }
            break;
        case ((uint8)4):
            // Clean up "timeserver_list"
            {
                delete timeserver_list_;
            }
            break;
        case ((uint8)5):
            // Clean up "nameserver_list"
            {
                delete nameserver_list_;
            }
            break;
        case ((uint8)6):
            // Clean up "dns_server_list"
            {
                delete dns_server_list_;
            }
            break;
        case ((uint8)12):
            // Clean up "host_name"
            {
                host_name_.free();
            }
            break;
        case ((uint8)15):
            // Clean up "domain_name"
            {
                domain_name_.free();
            }
            break;
        case ((uint8)19):
            // Clean up "forwarding"
            {
            }
            break;
        case ((uint8)28):
            // Clean up "broadcast_address"
            {
            }
            break;
        case ((uint8)42):
            // Clean up "ntpserver_list"
            {
                delete ntpserver_list_;
            }
            break;
        case ((uint8)43):
            // Clean up "vendor_specific"
            {
                vendor_specific_.free();
            }
            break;
        case ((uint8)44):
            // Clean up "nbns"
            {
                delete nbns_;
            }
            break;
        case ((uint8)50):
            // Clean up "addr_request"
            {
            }
            break;
        case ((uint8)51):
            // Clean up "lease"
            {
            }
            break;
        case ((uint8)54):
            // Clean up "serv_addr"
            {
            }
            break;
        case ((uint8)55):
            // Clean up "par_req_list"
            {
                delete par_req_list_;
            }
            break;
        case ((uint8)56):
            // Clean up "message"
            {
                message_.free();
            }
            break;
        case ((uint8)57):
            // Clean up "max_msg_size"
            {
            }
            break;
        case ((uint8)58):
            // Clean up "renewal_time"
            {
            }
            break;
        case ((uint8)59):
            // Clean up "rebinding_time"
            {
            }
            break;
        case ((uint8)60):
            // Clean up "vendor_class"
            {
                vendor_class_.free();
            }
            break;
        case ((uint8)61):
            // Clean up "client_id"
            {
                delete client_id_;
                client_id_ = nullptr;
            }
            break;
        case ((uint8)77):
            // Clean up "user_class"
            {
                user_class_.free();
            }
            break;
        case ((uint8)81):
            // Clean up "client_fqdn"
            {
                delete client_fqdn_;
                client_fqdn_ = nullptr;
            }
            break;
        case ((uint8)82):
            // Clean up "relay_agent_inf"
            {
                delete relay_agent_inf__elem_;
                relay_agent_inf__elem_ = nullptr;
                if ( relay_agent_inf() ) {
                    for ( auto* relay_agent_inf__elem_ : *relay_agent_inf() ) {
                        delete relay_agent_inf__elem_;
                        relay_agent_inf__elem_ = nullptr;
                    }
                }
                delete relay_agent_inf_;
            }
            break;
        case ((uint8)116):
            // Clean up "auto_config"
            {
            }
            break;
        case ((uint8)252):
            // Clean up "auto_proxy_config"
            {
                auto_proxy_config_.free();
            }
            break;
        default:
            // Clean up "other"
            {
                other_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int OptionValue::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDHCP* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = code();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)53):
            // Parse "msg_type"
            {
                // Checking out-of-bound for "OptionValue:msg_type"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("OptionValue:msg_type",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                msg_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
                t_val__size = 1;
            }
            break;
        case ((uint8)1):
            // Parse "subnet"
            {
                // Checking out-of-bound for "SUBNET_OPTION:subnet"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SUBNET_OPTION:subnet",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                subnet_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
                t_val__size = 4;
            }
            break;
        case ((uint8)2):
            // Parse "time_offset"
            {
                // Checking out-of-bound for "TIME_OFFSET_OPTION:time_offset"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("TIME_OFFSET_OPTION:time_offset",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                time_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int32 const*>(t_begin_of_data)));
                t_val__size = 4;
            }
            break;
        case ((uint8)3):
            // Parse "router_list"
            {
                int t_router_list__arraylength;
                t_router_list__arraylength = length() / 4;
                if ( t_router_list__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("ROUTER_OPTION:router_list",
                      t_router_list__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: ROUTER_OPTION:router_list
                if ( t_router_list__arraylength > ((t_end_of_data - t_begin_of_data) / 4) )
                    throw binpac::ExceptionOutOfBound("ROUTER_OPTION:router_list",
                      t_router_list__arraylength, (t_end_of_data) - (t_begin_of_data));
                router_list__elem_ = 0;
                int t_router_list__elem__it;
                t_router_list__elem__it = 0;
                int t_router_list__size;
                router_list_ = new vector<uint32>;
                router_list_->reserve(t_router_list__arraylength);
                const_byteptr t_router_list__elem__dataptr = t_begin_of_data;
                for (; t_router_list__elem__it < t_router_list__arraylength; ++t_router_list__elem__it) {
                    router_list__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_router_list__elem__dataptr)));
                    router_list_->push_back(router_list__elem_);
                    t_router_list__elem__dataptr += 4;
                    BINPAC_ASSERT(t_router_list__elem__dataptr <= t_end_of_data);
                }
            end_of_router_list: ;
                t_router_list__size = t_router_list__elem__dataptr - (t_begin_of_data);
                // Evaluate 'let' and 'withinput' fields
                t_val__size = t_router_list__size;
            }
            break;
        case ((uint8)4):
            // Parse "timeserver_list"
            {
                int t_timeserver_list__arraylength;
                t_timeserver_list__arraylength = length() / 4;
                if ( t_timeserver_list__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("TIME_SERVER_OPTION:timeserver_list",
                      t_timeserver_list__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: TIME_SERVER_OPTION:timeserver_list
                if ( t_timeserver_list__arraylength > ((t_end_of_data - t_begin_of_data) / 4) )
                    throw binpac::ExceptionOutOfBound("TIME_SERVER_OPTION:timeserver_list",
                      t_timeserver_list__arraylength, (t_end_of_data) - (t_begin_of_data));
                timeserver_list__elem_ = 0;
                int t_timeserver_list__elem__it;
                t_timeserver_list__elem__it = 0;
                int t_timeserver_list__size;
                timeserver_list_ = new vector<uint32>;
                timeserver_list_->reserve(t_timeserver_list__arraylength);
                const_byteptr t_timeserver_list__elem__dataptr = t_begin_of_data;
                for (; t_timeserver_list__elem__it < t_timeserver_list__arraylength; ++t_timeserver_list__elem__it) {
                    timeserver_list__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_timeserver_list__elem__dataptr)));
                    timeserver_list_->push_back(timeserver_list__elem_);
                    t_timeserver_list__elem__dataptr += 4;
                    BINPAC_ASSERT(t_timeserver_list__elem__dataptr <= t_end_of_data);
                }
            end_of_timeserver_list: ;
                t_timeserver_list__size = t_timeserver_list__elem__dataptr - (t_begin_of_data);
                // Evaluate 'let' and 'withinput' fields
                t_val__size = t_timeserver_list__size;
            }
            break;
        case ((uint8)5):
            // Parse "nameserver_list"
            {
                int t_nameserver_list__arraylength;
                t_nameserver_list__arraylength = length() / 4;
                if ( t_nameserver_list__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("NAME_SERVER_OPTION:nameserver_list",
                      t_nameserver_list__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: NAME_SERVER_OPTION:nameserver_list
                if ( t_nameserver_list__arraylength > ((t_end_of_data - t_begin_of_data) / 4) )
                    throw binpac::ExceptionOutOfBound("NAME_SERVER_OPTION:nameserver_list",
                      t_nameserver_list__arraylength, (t_end_of_data) - (t_begin_of_data));
                nameserver_list__elem_ = 0;
                int t_nameserver_list__elem__it;
                t_nameserver_list__elem__it = 0;
                int t_nameserver_list__size;
                nameserver_list_ = new vector<uint32>;
                nameserver_list_->reserve(t_nameserver_list__arraylength);
                const_byteptr t_nameserver_list__elem__dataptr = t_begin_of_data;
                for (; t_nameserver_list__elem__it < t_nameserver_list__arraylength; ++t_nameserver_list__elem__it) {
                    nameserver_list__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_nameserver_list__elem__dataptr)));
                    nameserver_list_->push_back(nameserver_list__elem_);
                    t_nameserver_list__elem__dataptr += 4;
                    BINPAC_ASSERT(t_nameserver_list__elem__dataptr <= t_end_of_data);
                }
            end_of_nameserver_list: ;
                t_nameserver_list__size = t_nameserver_list__elem__dataptr - (t_begin_of_data);
                // Evaluate 'let' and 'withinput' fields
                t_val__size = t_nameserver_list__size;
            }
            break;
        case ((uint8)6):
            // Parse "dns_server_list"
            {
                int t_dns_server_list__arraylength;
                t_dns_server_list__arraylength = length() / 4;
                if ( t_dns_server_list__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("DNS_SERVER_OPTION:dns_server_list",
                      t_dns_server_list__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: DNS_SERVER_OPTION:dns_server_list
                if ( t_dns_server_list__arraylength > ((t_end_of_data - t_begin_of_data) / 4) )
                    throw binpac::ExceptionOutOfBound("DNS_SERVER_OPTION:dns_server_list",
                      t_dns_server_list__arraylength, (t_end_of_data) - (t_begin_of_data));
                dns_server_list__elem_ = 0;
                int t_dns_server_list__elem__it;
                t_dns_server_list__elem__it = 0;
                int t_dns_server_list__size;
                dns_server_list_ = new vector<uint32>;
                dns_server_list_->reserve(t_dns_server_list__arraylength);
                const_byteptr t_dns_server_list__elem__dataptr = t_begin_of_data;
                for (; t_dns_server_list__elem__it < t_dns_server_list__arraylength; ++t_dns_server_list__elem__it) {
                    dns_server_list__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dns_server_list__elem__dataptr)));
                    dns_server_list_->push_back(dns_server_list__elem_);
                    t_dns_server_list__elem__dataptr += 4;
                    BINPAC_ASSERT(t_dns_server_list__elem__dataptr <= t_end_of_data);
                }
            end_of_dns_server_list: ;
                t_dns_server_list__size = t_dns_server_list__elem__dataptr - (t_begin_of_data);
                // Evaluate 'let' and 'withinput' fields
                t_val__size = t_dns_server_list__size;
            }
            break;
        case ((uint8)12):
            // Parse "host_name"
            {
                int t_host_name__size;
                t_host_name__size = length();
                // Checking out-of-bound for "HOST_NAME_OPTION:host_name"
                if ( t_begin_of_data + (t_host_name__size) > t_end_of_data || t_begin_of_data + (t_host_name__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("HOST_NAME_OPTION:host_name",
                    	(0) + (t_host_name__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_host_name__size;
                    int t_host_name_string_length;
                    t_host_name_string_length = length();
                    // check for negative sizes
                    if ( t_host_name_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:189", t_host_name_string_length);
                    host_name_.init(t_begin_of_data, t_host_name_string_length);
                }
                t_val__size = t_host_name__size;
            }
            break;
        case ((uint8)15):
            // Parse "domain_name"
            {
                int t_domain_name__size;
                t_domain_name__size = length();
                // Checking out-of-bound for "DOMAIN_NAME_OPTION:domain_name"
                if ( t_begin_of_data + (t_domain_name__size) > t_end_of_data || t_begin_of_data + (t_domain_name__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("DOMAIN_NAME_OPTION:domain_name",
                    	(0) + (t_domain_name__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_domain_name__size;
                    int t_domain_name_string_length;
                    t_domain_name_string_length = length();
                    // check for negative sizes
                    if ( t_domain_name_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:214", t_domain_name_string_length);
                    domain_name_.init(t_begin_of_data, t_domain_name_string_length);
                }
                t_val__size = t_domain_name__size;
            }
            break;
        case ((uint8)19):
            // Parse "forwarding"
            {
                // Checking out-of-bound for "FORWARDING_OPTION:forwarding"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("FORWARDING_OPTION:forwarding",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                forwarding_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
                t_val__size = 1;
            }
            break;
        case ((uint8)28):
            // Parse "broadcast_address"
            {
                // Checking out-of-bound for "BROADCAST_ADDRESS_OPTION:broadcast_address"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("BROADCAST_ADDRESS_OPTION:broadcast_address",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                broadcast_address_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
                t_val__size = 4;
            }
            break;
        case ((uint8)42):
            // Parse "ntpserver_list"
            {
                int t_ntpserver_list__arraylength;
                t_ntpserver_list__arraylength = length() / 4;
                if ( t_ntpserver_list__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("NTP_SERVER_OPTION:ntpserver_list",
                      t_ntpserver_list__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: NTP_SERVER_OPTION:ntpserver_list
                if ( t_ntpserver_list__arraylength > ((t_end_of_data - t_begin_of_data) / 4) )
                    throw binpac::ExceptionOutOfBound("NTP_SERVER_OPTION:ntpserver_list",
                      t_ntpserver_list__arraylength, (t_end_of_data) - (t_begin_of_data));
                ntpserver_list__elem_ = 0;
                int t_ntpserver_list__elem__it;
                t_ntpserver_list__elem__it = 0;
                int t_ntpserver_list__size;
                ntpserver_list_ = new vector<uint32>;
                ntpserver_list_->reserve(t_ntpserver_list__arraylength);
                const_byteptr t_ntpserver_list__elem__dataptr = t_begin_of_data;
                for (; t_ntpserver_list__elem__it < t_ntpserver_list__arraylength; ++t_ntpserver_list__elem__it) {
                    ntpserver_list__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_ntpserver_list__elem__dataptr)));
                    ntpserver_list_->push_back(ntpserver_list__elem_);
                    t_ntpserver_list__elem__dataptr += 4;
                    BINPAC_ASSERT(t_ntpserver_list__elem__dataptr <= t_end_of_data);
                }
            end_of_ntpserver_list: ;
                t_ntpserver_list__size = t_ntpserver_list__elem__dataptr - (t_begin_of_data);
                // Evaluate 'let' and 'withinput' fields
                t_val__size = t_ntpserver_list__size;
            }
            break;
        case ((uint8)43):
            // Parse "vendor_specific"
            {
                int t_vendor_specific__size;
                t_vendor_specific__size = length();
                // Checking out-of-bound for "VENDOR_SPECIFIC_OPTION:vendor_specific"
                if ( t_begin_of_data + (t_vendor_specific__size) > t_end_of_data || t_begin_of_data + (t_vendor_specific__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("VENDOR_SPECIFIC_OPTION:vendor_specific",
                    	(0) + (t_vendor_specific__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_vendor_specific__size;
                    int t_vendor_specific_string_length;
                    t_vendor_specific_string_length = length();
                    // check for negative sizes
                    if ( t_vendor_specific_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:328", t_vendor_specific_string_length);
                    vendor_specific_.init(t_begin_of_data, t_vendor_specific_string_length);
                }
                t_val__size = t_vendor_specific__size;
            }
            break;
        case ((uint8)44):
            // Parse "nbns"
            {
                int t_nbns__arraylength;
                t_nbns__arraylength = length() / 4;
                if ( t_nbns__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("NBNS_OPTION:nbns",
                      t_nbns__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: NBNS_OPTION:nbns
                if ( t_nbns__arraylength > ((t_end_of_data - t_begin_of_data) / 4) )
                    throw binpac::ExceptionOutOfBound("NBNS_OPTION:nbns",
                      t_nbns__arraylength, (t_end_of_data) - (t_begin_of_data));
                nbns__elem_ = 0;
                int t_nbns__elem__it;
                t_nbns__elem__it = 0;
                int t_nbns__size;
                nbns_ = new vector<uint32>;
                nbns_->reserve(t_nbns__arraylength);
                const_byteptr t_nbns__elem__dataptr = t_begin_of_data;
                for (; t_nbns__elem__it < t_nbns__arraylength; ++t_nbns__elem__it) {
                    nbns__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_nbns__elem__dataptr)));
                    nbns_->push_back(nbns__elem_);
                    t_nbns__elem__dataptr += 4;
                    BINPAC_ASSERT(t_nbns__elem__dataptr <= t_end_of_data);
                }
            end_of_nbns: ;
                t_nbns__size = t_nbns__elem__dataptr - (t_begin_of_data);
                // Evaluate 'let' and 'withinput' fields
                t_val__size = t_nbns__size;
            }
            break;
        case ((uint8)50):
            // Parse "addr_request"
            {
                // Checking out-of-bound for "ADDR_REQUEST_OPTION:addr_request"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ADDR_REQUEST_OPTION:addr_request",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                addr_request_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
                t_val__size = 4;
            }
            break;
        case ((uint8)51):
            // Parse "lease"
            {
                // Checking out-of-bound for "LEASE_OPTION:lease"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("LEASE_OPTION:lease",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                lease_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
                t_val__size = 4;
            }
            break;
        case ((uint8)54):
            // Parse "serv_addr"
            {
                // Checking out-of-bound for "SERV_ID_OPTION:serv_addr"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SERV_ID_OPTION:serv_addr",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                serv_addr_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
                t_val__size = 4;
            }
            break;
        case ((uint8)55):
            // Parse "par_req_list"
            {
                int t_par_req_list__arraylength;
                t_par_req_list__arraylength = length();
                if ( t_par_req_list__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("PAR_REQ_LIST_OPTION:par_req_list",
                      t_par_req_list__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: PAR_REQ_LIST_OPTION:par_req_list
                if ( t_par_req_list__arraylength > ((t_end_of_data - t_begin_of_data) / 1) )
                    throw binpac::ExceptionOutOfBound("PAR_REQ_LIST_OPTION:par_req_list",
                      t_par_req_list__arraylength, (t_end_of_data) - (t_begin_of_data));
                par_req_list__elem_ = 0;
                int t_par_req_list__elem__it;
                t_par_req_list__elem__it = 0;
                int t_par_req_list__size;
                par_req_list_ = new vector<uint8>;
                par_req_list_->reserve(t_par_req_list__arraylength);
                const_byteptr t_par_req_list__elem__dataptr = t_begin_of_data;
                for (; t_par_req_list__elem__it < t_par_req_list__arraylength; ++t_par_req_list__elem__it) {
                    par_req_list__elem_ = *(reinterpret_cast<uint8 const*>(t_par_req_list__elem__dataptr));
                    par_req_list_->push_back(par_req_list__elem_);
                    t_par_req_list__elem__dataptr += 1;
                    BINPAC_ASSERT(t_par_req_list__elem__dataptr <= t_end_of_data);
                }
            end_of_par_req_list: ;
                t_par_req_list__size = t_par_req_list__elem__dataptr - (t_begin_of_data);
                // Evaluate 'let' and 'withinput' fields
                t_val__size = t_par_req_list__size;
            }
            break;
        case ((uint8)56):
            // Parse "message"
            {
                int t_message__size;
                t_message__size = length();
                // Checking out-of-bound for "MESSAGE_OPTION:message"
                if ( t_begin_of_data + (t_message__size) > t_end_of_data || t_begin_of_data + (t_message__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("MESSAGE_OPTION:message",
                    	(0) + (t_message__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_message__size;
                    int t_message_string_length;
                    t_message_string_length = length();
                    // check for negative sizes
                    if ( t_message_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:493", t_message_string_length);
                    message_.init(t_begin_of_data, t_message_string_length);
                }
                t_val__size = t_message__size;
            }
            break;
        case ((uint8)57):
            // Parse "max_msg_size"
            {
                // Checking out-of-bound for "MAX_MESSAGE_SIZE_OPTION:max_msg_size"
                if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("MAX_MESSAGE_SIZE_OPTION:max_msg_size",
                    	(0) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                max_msg_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
                t_val__size = 2;
            }
            break;
        case ((uint8)58):
            // Parse "renewal_time"
            {
                // Checking out-of-bound for "RENEWAL_TIME_OPTION:renewal_time"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RENEWAL_TIME_OPTION:renewal_time",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                renewal_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
                t_val__size = 4;
            }
            break;
        case ((uint8)59):
            // Parse "rebinding_time"
            {
                // Checking out-of-bound for "REBINDING_TIME_OPTION:rebinding_time"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("REBINDING_TIME_OPTION:rebinding_time",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                rebinding_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
                t_val__size = 4;
            }
            break;
        case ((uint8)60):
            // Parse "vendor_class"
            {
                int t_vendor_class__size;
                t_vendor_class__size = length();
                // Checking out-of-bound for "VENDOR_CLASS_OPTION:vendor_class"
                if ( t_begin_of_data + (t_vendor_class__size) > t_end_of_data || t_begin_of_data + (t_vendor_class__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("VENDOR_CLASS_OPTION:vendor_class",
                    	(0) + (t_vendor_class__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_vendor_class__size;
                    int t_vendor_class_string_length;
                    t_vendor_class_string_length = length();
                    // check for negative sizes
                    if ( t_vendor_class_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:592", t_vendor_class_string_length);
                    vendor_class_.init(t_begin_of_data, t_vendor_class_string_length);
                }
                t_val__size = t_vendor_class__size;
            }
            break;
        case ((uint8)61):
            // Parse "client_id"
            {
                client_id_ = new Client_Identifier(length());
                int t_client_id__size;
                t_client_id__size = client_id_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_client_id__size;
            }
            break;
        case ((uint8)77):
            // Parse "user_class"
            {
                int t_user_class__size;
                t_user_class__size = length();
                // Checking out-of-bound for "USER_CLASS_OPTION:user_class"
                if ( t_begin_of_data + (t_user_class__size) > t_end_of_data || t_begin_of_data + (t_user_class__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("USER_CLASS_OPTION:user_class",
                    	(0) + (t_user_class__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_user_class__size;
                    int t_user_class_string_length;
                    t_user_class_string_length = length();
                    // check for negative sizes
                    if ( t_user_class_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:659", t_user_class_string_length);
                    user_class_.init(t_begin_of_data, t_user_class_string_length);
                }
                t_val__size = t_user_class__size;
            }
            break;
        case ((uint8)81):
            // Parse "client_fqdn"
            {
                client_fqdn_ = new Client_FQDN(length());
                int t_client_fqdn__size;
                t_client_fqdn__size = client_fqdn_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_client_fqdn__size;
            }
            break;
        case ((uint8)82):
            // Parse "relay_agent_inf"
            {
                int t_relay_agent_inf__arraylength;
                t_relay_agent_inf__arraylength = 0;
                relay_agent_inf__elem_ = nullptr;
                int t_relay_agent_inf__elem__it;
                t_relay_agent_inf__elem__it = 0;
                int t_relay_agent_inf__size;
                relay_agent_inf_ = new vector<Relay_Agent_SubOption*>;
                const_byteptr t_relay_agent_inf__elem__dataptr = t_begin_of_data;
                for (; /* forever */; ++t_relay_agent_inf__elem__it) {
                    // Check &until(relay_agent_inf__elem__dataptr >= end_of_data)
                    if ( t_relay_agent_inf__elem__dataptr >= t_end_of_data ) {
                        relay_agent_inf__elem_ = nullptr;
                        goto end_of_relay_agent_inf;
                    }
                    relay_agent_inf__elem_ = new Relay_Agent_SubOption(length());
                    int t_relay_agent_inf__elem__size;
                    t_relay_agent_inf__elem__size = relay_agent_inf__elem_->Parse(t_relay_agent_inf__elem__dataptr, t_end_of_data, t_context);
                    relay_agent_inf_->push_back(relay_agent_inf__elem_);
                    t_relay_agent_inf__elem__dataptr += t_relay_agent_inf__elem__size;
                    BINPAC_ASSERT(t_relay_agent_inf__elem__dataptr <= t_end_of_data);
                    // Check &until( ( @$element->last@ ) )
                    if (  ( relay_agent_inf__elem_->last() )  ) {
                        relay_agent_inf__elem_ = nullptr;
                        goto end_of_relay_agent_inf;
                    }
                    relay_agent_inf__elem_ = nullptr;
                }
            end_of_relay_agent_inf: ;
                t_relay_agent_inf__size = t_relay_agent_inf__elem__dataptr - (t_begin_of_data);
                // Evaluate 'let' and 'withinput' fields
                t_val__size = t_relay_agent_inf__size;
            }
            break;
        case ((uint8)116):
            // Parse "auto_config"
            {
                // Checking out-of-bound for "AUTO_CONFIG_OPTION:auto_config"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("AUTO_CONFIG_OPTION:auto_config",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                auto_config_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
                t_val__size = 1;
            }
            break;
        case ((uint8)252):
            // Parse "auto_proxy_config"
            {
                int t_auto_proxy_config__size;
                t_auto_proxy_config__size = length();
                // Checking out-of-bound for "AUTO_PROXY_CONFIG_OPTION:auto_proxy_config"
                if ( t_begin_of_data + (t_auto_proxy_config__size) > t_end_of_data || t_begin_of_data + (t_auto_proxy_config__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("AUTO_PROXY_CONFIG_OPTION:auto_proxy_config",
                    	(0) + (t_auto_proxy_config__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_auto_proxy_config__size;
                    int t_auto_proxy_config_string_length;
                    t_auto_proxy_config_string_length = length();
                    // check for negative sizes
                    if ( t_auto_proxy_config_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:810", t_auto_proxy_config_string_length);
                    auto_proxy_config_.init(t_begin_of_data, t_auto_proxy_config_string_length);
                }
                t_val__size = t_auto_proxy_config__size;
            }
            break;
        default:
            // Parse "other"
            {
                int t_other__size;
                t_other__size = length();
                // Checking out-of-bound for "OptionValue:other"
                if ( t_begin_of_data + (t_other__size) > t_end_of_data || t_begin_of_data + (t_other__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("OptionValue:other",
                    	(0) + (t_other__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_other__size;
                    int t_other_string_length;
                    t_other_string_length = length();
                    // check for negative sizes
                    if ( t_other_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-protocol.pac:14", t_other_string_length);
                    other_.init(t_begin_of_data, t_other_string_length);
                }
                t_val__size = t_other__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
OptionValueWrapper::OptionValueWrapper(uint8 code) {
    length_ = 0;
    value_ = nullptr;
    code_ = code;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
OptionValueWrapper::~OptionValueWrapper() {
    delete value_;
    value_ = nullptr;
}

int OptionValueWrapper::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDHCP* t_context, int t_byteorder) {
    // Checking out-of-bound for "OptionValueWrapper:length"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("OptionValueWrapper:length",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = new OptionValue(code(), length());
    int t_value__size;
    t_value__size = value_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);

    int t_OptionValueWrapper__size;
    const_byteptr const t_dataptr_after_value = (t_begin_of_data + 1) + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_OptionValueWrapper__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_OptionValueWrapper__size) <= t_end_of_data);
    return t_OptionValueWrapper__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Option::Option() {
    code_ = 0;
    data_case_index_ = -1;
    info_ = nullptr;
    last_ = 0;
    proc_create_options_ = 0;
    proc_subnet_option_ = 0;
    has_proc_subnet_option_ = false;
    proc_timeoffset_option_ = 0;
    has_proc_timeoffset_option_ = false;
    proc_router_option_ = 0;
    has_proc_router_option_ = false;
    proc_timeserver_option_ = 0;
    has_proc_timeserver_option_ = false;
    proc_nameserver_option_ = 0;
    has_proc_nameserver_option_ = false;
    proc_dns_server_option_ = 0;
    has_proc_dns_server_option_ = false;
    proc_host_name_option_ = 0;
    has_proc_host_name_option_ = false;
    proc_domain_name_option_ = 0;
    has_proc_domain_name_option_ = false;
    proc_forwarding_option_ = 0;
    has_proc_forwarding_option_ = false;
    proc_broadcast_address_option_ = 0;
    has_proc_broadcast_address_option_ = false;
    proc_ntpserver_option_ = 0;
    has_proc_ntpserver_option_ = false;
    proc_vendor_specific_option_ = 0;
    has_proc_vendor_specific_option_ = false;
    proc_nbns_option_ = 0;
    has_proc_nbns_option_ = false;
    proc_addr_request_option_ = 0;
    has_proc_addr_request_option_ = false;
    proc_lease_option_ = 0;
    has_proc_lease_option_ = false;
    proc_serv_id_option_ = 0;
    has_proc_serv_id_option_ = false;
    proc_par_req_list_option_ = 0;
    has_proc_par_req_list_option_ = false;
    proc_message_option_ = 0;
    has_proc_message_option_ = false;
    proc_max_message_size_option_ = 0;
    has_proc_max_message_size_option_ = false;
    proc_renewal_time_option_ = 0;
    has_proc_renewal_time_option_ = false;
    proc_rebinding_time_option_ = 0;
    has_proc_rebinding_time_option_ = false;
    proc_vendor_class_option_ = 0;
    has_proc_vendor_class_option_ = false;
    proc_client_id_option_ = 0;
    has_proc_client_id_option_ = false;
    proc_user_class_option_ = 0;
    has_proc_user_class_option_ = false;
    proc_client_fqdn_option_ = 0;
    has_proc_client_fqdn_option_ = false;
    proc_relay_agent_info_option_ = 0;
    has_proc_relay_agent_info_option_ = false;
    proc_auto_config_option_ = 0;
    has_proc_auto_config_option_ = false;
    proc_auto_proxy_config_option_ = 0;
    has_proc_auto_proxy_config_option_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Option::~Option() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint8)0):
        case ((uint8)255):
            // Clean up "none"
            {
            }
            break;
        default:
            // Clean up "info"
            {
                delete info_;
                info_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Option::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDHCP* t_context, int t_byteorder) {
    // Checking out-of-bound for "Option:code"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Option:code",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "code"
    code_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "data"
    int t_data__size;
    data_case_index_ = code();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint8)0):
        case ((uint8)255):
            // Parse "none"
            {
                t_data__size = 0;
            }
            break;
        default:
            // Parse "info"
            {
                info_ = new OptionValueWrapper(code());
                int t_info__size;
                t_info__size = info_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_data__size = t_info__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Option__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 1) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Option__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    last_ =  ( code() == 255 ) ;
    proc_create_options_ = t_context->flow()->create_options(code());
    has_proc_subnet_option_ =  ( code() == SUBNET_OPTION ) ;
    if ( has_proc_subnet_option() ) {
        proc_subnet_option_ = t_context->flow()->process_subnet_option(info()->value());
    }
    has_proc_timeoffset_option_ =  ( code() == TIME_OFFSET_OPTION ) ;
    if ( has_proc_timeoffset_option() ) {
        proc_timeoffset_option_ = t_context->flow()->process_time_offset_option(info()->value());
    }
    has_proc_router_option_ =  ( code() == ROUTER_OPTION ) ;
    if ( has_proc_router_option() ) {
        proc_router_option_ = t_context->flow()->process_router_option(info()->value());
    }
    has_proc_timeserver_option_ =  ( code() == TIME_SERVER_OPTION ) ;
    if ( has_proc_timeserver_option() ) {
        proc_timeserver_option_ = t_context->flow()->process_timeserver_option(info()->value());
    }
    has_proc_nameserver_option_ =  ( code() == NAME_SERVER_OPTION ) ;
    if ( has_proc_nameserver_option() ) {
        proc_nameserver_option_ = t_context->flow()->process_nameserver_option(info()->value());
    }
    has_proc_dns_server_option_ =  ( code() == DNS_SERVER_OPTION ) ;
    if ( has_proc_dns_server_option() ) {
        proc_dns_server_option_ = t_context->flow()->process_dns_server_option(info()->value());
    }
    has_proc_host_name_option_ =  ( code() == HOST_NAME_OPTION ) ;
    if ( has_proc_host_name_option() ) {
        proc_host_name_option_ = t_context->flow()->process_host_name_option(info()->value());
    }
    has_proc_domain_name_option_ =  ( code() == DOMAIN_NAME_OPTION ) ;
    if ( has_proc_domain_name_option() ) {
        proc_domain_name_option_ = t_context->flow()->process_domain_name_option(info()->value());
    }
    has_proc_forwarding_option_ =  ( code() == FORWARDING_OPTION ) ;
    if ( has_proc_forwarding_option() ) {
        proc_forwarding_option_ = t_context->flow()->process_forwarding_option(info()->value());
    }
    has_proc_broadcast_address_option_ =  ( code() == BROADCAST_ADDRESS_OPTION ) ;
    if ( has_proc_broadcast_address_option() ) {
        proc_broadcast_address_option_ = t_context->flow()->process_broadcast_address_option(info()->value());
    }
    has_proc_ntpserver_option_ =  ( code() == NTP_SERVER_OPTION ) ;
    if ( has_proc_ntpserver_option() ) {
        proc_ntpserver_option_ = t_context->flow()->process_ntpserver_option(info()->value());
    }
    has_proc_vendor_specific_option_ =  ( code() == VENDOR_SPECIFIC_OPTION ) ;
    if ( has_proc_vendor_specific_option() ) {
        proc_vendor_specific_option_ = t_context->flow()->process_vendor_specific_option(info()->value());
    }
    has_proc_nbns_option_ =  ( code() == NBNS_OPTION ) ;
    if ( has_proc_nbns_option() ) {
        proc_nbns_option_ = t_context->flow()->process_nbns_option(info()->value());
    }
    has_proc_addr_request_option_ =  ( code() == ADDR_REQUEST_OPTION ) ;
    if ( has_proc_addr_request_option() ) {
        proc_addr_request_option_ = t_context->flow()->process_addr_request_option(info()->value());
    }
    has_proc_lease_option_ =  ( code() == LEASE_OPTION ) ;
    if ( has_proc_lease_option() ) {
        proc_lease_option_ = t_context->flow()->process_lease_option(info()->value());
    }
    has_proc_serv_id_option_ =  ( code() == SERV_ID_OPTION ) ;
    if ( has_proc_serv_id_option() ) {
        proc_serv_id_option_ = t_context->flow()->process_serv_id_option(info()->value());
    }
    has_proc_par_req_list_option_ =  ( code() == PAR_REQ_LIST_OPTION ) ;
    if ( has_proc_par_req_list_option() ) {
        proc_par_req_list_option_ = t_context->flow()->process_par_req_list_option(info()->value());
    }
    has_proc_message_option_ =  ( code() == MESSAGE_OPTION ) ;
    if ( has_proc_message_option() ) {
        proc_message_option_ = t_context->flow()->process_message_option(info()->value());
    }
    has_proc_max_message_size_option_ =  ( code() == MAX_MESSAGE_SIZE_OPTION ) ;
    if ( has_proc_max_message_size_option() ) {
        proc_max_message_size_option_ = t_context->flow()->process_max_message_size_option(info()->value());
    }
    has_proc_renewal_time_option_ =  ( code() == RENEWAL_TIME_OPTION ) ;
    if ( has_proc_renewal_time_option() ) {
        proc_renewal_time_option_ = t_context->flow()->process_renewal_time_option(info()->value());
    }
    has_proc_rebinding_time_option_ =  ( code() == REBINDING_TIME_OPTION ) ;
    if ( has_proc_rebinding_time_option() ) {
        proc_rebinding_time_option_ = t_context->flow()->process_rebinding_time_option(info()->value());
    }
    has_proc_vendor_class_option_ =  ( code() == VENDOR_CLASS_OPTION ) ;
    if ( has_proc_vendor_class_option() ) {
        proc_vendor_class_option_ = t_context->flow()->process_vendor_class_option(info()->value());
    }
    has_proc_client_id_option_ =  ( code() == CLIENT_ID_OPTION ) ;
    if ( has_proc_client_id_option() ) {
        proc_client_id_option_ = t_context->flow()->process_client_id_option(info()->value());
    }
    has_proc_user_class_option_ =  ( code() == USER_CLASS_OPTION ) ;
    if ( has_proc_user_class_option() ) {
        proc_user_class_option_ = t_context->flow()->process_user_class_option(info()->value());
    }
    has_proc_client_fqdn_option_ =  ( code() == CLIENT_FQDN_OPTION ) ;
    if ( has_proc_client_fqdn_option() ) {
        proc_client_fqdn_option_ = t_context->flow()->process_client_fqdn_option(info()->value());
    }
    has_proc_relay_agent_info_option_ =  ( code() == RELAY_AGENT_INF_OPTION ) ;
    if ( has_proc_relay_agent_info_option() ) {
        proc_relay_agent_info_option_ = t_context->flow()->process_relay_agent_inf_option(info()->value());
    }
    has_proc_auto_config_option_ =  ( code() == AUTO_CONFIG_OPTION ) ;
    if ( has_proc_auto_config_option() ) {
        proc_auto_config_option_ = t_context->flow()->process_auto_config_option(info()->value());
    }
    has_proc_auto_proxy_config_option_ =  ( code() == AUTO_PROXY_CONFIG_OPTION ) ;
    if ( has_proc_auto_proxy_config_option() ) {
        proc_auto_proxy_config_option_ = t_context->flow()->process_auto_proxy_config_option(info()->value());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_Option__size) <= t_end_of_data);
    return t_Option__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DHCP_Message::DHCP_Message(bool is_orig) {
    op_ = 0;
    htype_ = 0;
    hlen_ = 0;
    hops_ = 0;
    xid_ = 0;
    secs_ = 0;
    flags_ = 0;
    ciaddr_ = 0;
    yiaddr_ = 0;
    siaddr_ = 0;
    giaddr_ = 0;
    cookie_ = 0;
    options_ = nullptr;
    options__elem_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
    type_ = 0;
    proc_dhcp_message_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DHCP_Message::~DHCP_Message() {
    chaddr_.free();
    sname_.free();
    file_n_.free();
    delete options__elem_;
    options__elem_ = nullptr;
    if ( options() ) {
        for ( auto* options__elem_ : *options() ) {
            delete options__elem_;
            options__elem_ = nullptr;
        }
    }
    delete options_;
}

int DHCP_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDHCP* t_context) {
    // Checking out-of-bound for "DHCP_Message:giaddr"
    if ( (t_begin_of_data + 24) + (4) > t_end_of_data || (t_begin_of_data + 24) + (4) < (t_begin_of_data + 24) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DHCP_Message:giaddr",
        	(24) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "op"
    op_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "htype"
    htype_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "hlen"
    hlen_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "hops"
    hops_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "xid"
    xid_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "secs"
    secs_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "flags"
    flags_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 10))));

    // Parse "ciaddr"
    ciaddr_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

    // Parse "yiaddr"
    yiaddr_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 16))));

    // Parse "siaddr"
    siaddr_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 20))));

    // Parse "giaddr"
    giaddr_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 24))));

    // Parse "chaddr"
    // Checking out-of-bound for "DHCP_Message:chaddr"
    if ( (t_begin_of_data + 28) + (16) > t_end_of_data || (t_begin_of_data + 28) + (16) < (t_begin_of_data + 28) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DHCP_Message:chaddr",
        	(28) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 28) + 16;
        int t_chaddr_string_length;
        t_chaddr_string_length = 16;
        int t_chaddr__size;
        t_chaddr__size = t_chaddr_string_length;
        chaddr_.init((t_begin_of_data + 28), t_chaddr_string_length);
    }

    const_byteptr const t_dataptr_after_chaddr = (t_begin_of_data + 28) + (16);
    BINPAC_ASSERT(t_dataptr_after_chaddr <= t_end_of_data);
    // Parse "sname"
    // Checking out-of-bound for "DHCP_Message:sname"
    if ( t_dataptr_after_chaddr + (64) > t_end_of_data || t_dataptr_after_chaddr + (64) < t_dataptr_after_chaddr ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DHCP_Message:sname",
        	((t_dataptr_after_chaddr - t_begin_of_data)) + (64), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_chaddr + 64;
        int t_sname_string_length;
        t_sname_string_length = 64;
        int t_sname__size;
        t_sname__size = t_sname_string_length;
        sname_.init(t_dataptr_after_chaddr, t_sname_string_length);
    }

    const_byteptr const t_dataptr_after_sname = t_dataptr_after_chaddr + (64);
    BINPAC_ASSERT(t_dataptr_after_sname <= t_end_of_data);
    // Parse "file_n"
    // Checking out-of-bound for "DHCP_Message:file_n"
    if ( t_dataptr_after_sname + (128) > t_end_of_data || t_dataptr_after_sname + (128) < t_dataptr_after_sname ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DHCP_Message:file_n",
        	((t_dataptr_after_sname - t_begin_of_data)) + (128), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_sname + 128;
        int t_file_n_string_length;
        t_file_n_string_length = 128;
        int t_file_n__size;
        t_file_n__size = t_file_n_string_length;
        file_n_.init(t_dataptr_after_sname, t_file_n_string_length);
    }

    const_byteptr const t_dataptr_after_file_n = t_dataptr_after_sname + (128);
    BINPAC_ASSERT(t_dataptr_after_file_n <= t_end_of_data);
    // Checking out-of-bound for "DHCP_Message:cookie"
    if ( t_dataptr_after_file_n + (4) > t_end_of_data || t_dataptr_after_file_n + (4) < t_dataptr_after_file_n ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DHCP_Message:cookie",
        	((t_dataptr_after_file_n - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cookie"
    cookie_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_dataptr_after_file_n)));

    // Parse "options"
    int t_options__arraylength;
    t_options__arraylength = 0;
    options__elem_ = nullptr;
    int t_options__elem__it;
    t_options__elem__it = 0;
    int t_options__size;
    options_ = new vector<Option*>;
    const_byteptr t_options__elem__dataptr = (t_dataptr_after_file_n + 4);
    for (; /* forever */; ++t_options__elem__it) {
        // Check &until(options__elem__dataptr >= end_of_data)
        if ( t_options__elem__dataptr >= t_end_of_data ) {
            options__elem_ = nullptr;
            goto end_of_options;
        }
        options__elem_ = new Option();
        int t_options__elem__size;
        t_options__elem__size = options__elem_->Parse(t_options__elem__dataptr, t_end_of_data, t_context, byteorder());
        options_->push_back(options__elem_);
        t_options__elem__dataptr += t_options__elem__size;
        BINPAC_ASSERT(t_options__elem__dataptr <= t_end_of_data);
        // Check &until( ( @$element->last@ ) )
        if (  ( options__elem_->last() )  ) {
            options__elem_ = nullptr;
            goto end_of_options;
        }
        options__elem_ = nullptr;
    }
end_of_options: ;
    t_options__size = t_options__elem__dataptr - ((t_dataptr_after_file_n + 4));
    // Evaluate 'let' and 'withinput' fields

    int t_DHCP_Message__size;
    const_byteptr const t_dataptr_after_options = (t_dataptr_after_file_n + 4) + (t_options__size);
    BINPAC_ASSERT(t_dataptr_after_options <= t_end_of_data);
    t_DHCP_Message__size = t_dataptr_after_options - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    type_ = t_context->flow()->get_dhcp_msgtype(options());
    proc_dhcp_message_ = t_context->flow()->process_dhcp_message(this);
    BINPAC_ASSERT(t_begin_of_data + (t_DHCP_Message__size) <= t_end_of_data);
    return t_DHCP_Message__size;
}

int const SUBNET_OPTION = 1;
int const TIME_OFFSET_OPTION = 2;
int const ROUTER_OPTION = 3;
int const TIME_SERVER_OPTION = 4;
int const NAME_SERVER_OPTION = 5;
int const DNS_SERVER_OPTION = 6;
int const HOST_NAME_OPTION = 12;
int const DOMAIN_NAME_OPTION = 15;
int const FORWARDING_OPTION = 19;
int const BROADCAST_ADDRESS_OPTION = 28;
int const NTP_SERVER_OPTION = 42;
int const VENDOR_SPECIFIC_OPTION = 43;
int const NBNS_OPTION = 44;
int const ADDR_REQUEST_OPTION = 50;
int const LEASE_OPTION = 51;
int const SERV_ID_OPTION = 54;
int const PAR_REQ_LIST_OPTION = 55;
int const MESSAGE_OPTION = 56;
int const MAX_MESSAGE_SIZE_OPTION = 57;
int const RENEWAL_TIME_OPTION = 58;
int const REBINDING_TIME_OPTION = 59;
int const VENDOR_CLASS_OPTION = 60;
int const CLIENT_ID_OPTION = 61;
// NOLINTNEXTLINE(modernize-use-equals-default)
Client_Identifier::Client_Identifier(uint8 length) {
    hwtype_ = 0;
    length_ = length;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Client_Identifier::~Client_Identifier() {
    hwaddr_.free();
}

int Client_Identifier::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Client_Identifier:hwtype"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Identifier:hwtype",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "hwtype"
    hwtype_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "hwaddr"
    int t_hwaddr__size;
    t_hwaddr__size = length() - 1;
    // Checking out-of-bound for "Client_Identifier:hwaddr"
    if ( (t_begin_of_data + 1) + (t_hwaddr__size) > t_end_of_data || (t_begin_of_data + 1) + (t_hwaddr__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Identifier:hwaddr",
        	(1) + (t_hwaddr__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_hwaddr__size;
        int t_hwaddr_string_length;
        t_hwaddr_string_length = length() - 1;
        // check for negative sizes
        if ( t_hwaddr_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:617", t_hwaddr_string_length);
        hwaddr_.init((t_begin_of_data + 1), t_hwaddr_string_length);
    }

    int t_Client_Identifier__size;
    const_byteptr const t_dataptr_after_hwaddr = (t_begin_of_data + 1) + (t_hwaddr__size);
    BINPAC_ASSERT(t_dataptr_after_hwaddr <= t_end_of_data);
    t_Client_Identifier__size = t_dataptr_after_hwaddr - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Client_Identifier__size) <= t_end_of_data);
    return t_Client_Identifier__size;
}

int const USER_CLASS_OPTION = 77;
int const CLIENT_FQDN_OPTION = 81;
// NOLINTNEXTLINE(modernize-use-equals-default)
Client_FQDN::Client_FQDN(uint8 length) {
    flags_ = 0;
    rcode1_ = 0;
    rcode2_ = 0;
    length_ = length;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Client_FQDN::~Client_FQDN() {
    domain_name_.free();
}

int Client_FQDN::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Client_FQDN:rcode2"
    if ( (t_begin_of_data + 2) + (1) > t_end_of_data || (t_begin_of_data + 2) + (1) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_FQDN:rcode2",
        	(2) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flags"
    flags_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "rcode1"
    rcode1_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "rcode2"
    rcode2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "domain_name"
    int t_domain_name__size;
    t_domain_name__size = length() - 3;
    // Checking out-of-bound for "Client_FQDN:domain_name"
    if ( (t_begin_of_data + 3) + (t_domain_name__size) > t_end_of_data || (t_begin_of_data + 3) + (t_domain_name__size) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_FQDN:domain_name",
        	(3) + (t_domain_name__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 3) + t_domain_name__size;
        int t_domain_name_string_length;
        t_domain_name_string_length = length() - 3;
        // check for negative sizes
        if ( t_domain_name_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:686", t_domain_name_string_length);
        domain_name_.init((t_begin_of_data + 3), t_domain_name_string_length);
    }

    int t_Client_FQDN__size;
    const_byteptr const t_dataptr_after_domain_name = (t_begin_of_data + 3) + (t_domain_name__size);
    BINPAC_ASSERT(t_dataptr_after_domain_name <= t_end_of_data);
    t_Client_FQDN__size = t_dataptr_after_domain_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Client_FQDN__size) <= t_end_of_data);
    return t_Client_FQDN__size;
}

int const RELAY_AGENT_INF_OPTION = 82;
// NOLINTNEXTLINE(modernize-use-equals-default)
Relay_Agent_SubOption::Relay_Agent_SubOption(uint8 tot_len) {
    code_ = 0;
    length_ = 0;
    tot_len_ = tot_len;
    sum_len_ = 0;
    last_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Relay_Agent_SubOption::~Relay_Agent_SubOption() {
    value_.free();
}

int Relay_Agent_SubOption::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDHCP* t_context) {
    // Checking out-of-bound for "Relay_Agent_SubOption:length"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Relay_Agent_SubOption:length",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "code"
    code_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "length"
    length_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "value"
    int t_value__size;
    t_value__size = length();
    // Checking out-of-bound for "Relay_Agent_SubOption:value"
    if ( (t_begin_of_data + 2) + (t_value__size) > t_end_of_data || (t_begin_of_data + 2) + (t_value__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Relay_Agent_SubOption:value",
        	(2) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_value__size;
        int t_value_string_length;
        t_value_string_length = length();
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:723", t_value_string_length);
        value_.init((t_begin_of_data + 2), t_value_string_length);
    }

    int t_Relay_Agent_SubOption__size;
    const_byteptr const t_dataptr_after_value = (t_begin_of_data + 2) + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_Relay_Agent_SubOption__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    sum_len_ = t_context->flow()->get_dhcp_sumlen(length() + 2);
    last_ =  ( sum_len() == tot_len() ) ;
    BINPAC_ASSERT(t_begin_of_data + (t_Relay_Agent_SubOption__size) <= t_end_of_data);
    return t_Relay_Agent_SubOption__size;
}

int const AUTO_CONFIG_OPTION = 116;
int const AUTO_PROXY_CONFIG_OPTION = 252;
} // namespace DHCP
}  // namespace binpac
