// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/mqtt/mqtt.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_mqtt_mqtt_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_mqtt_mqtt_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


	#include "zeek/analyzer/protocol/mqtt/MQTT.h"
	#include "zeek/analyzer/protocol/mqtt/events.bif.h"
	#include "zeek/analyzer/protocol/mqtt/types.bif.h"

namespace binpac {

namespace MQTT {
class ContextMQTT;
class MQTT_Conn;
// NOLINTNEXTLINE(performance-enum-size)
enum MQTT_msg_type {
    MQTT_RESERVED = 0,
    MQTT_CONNECT = 1,
    MQTT_CONNACK = 2,
    MQTT_PUBLISH = 3,
    MQTT_PUBACK = 4,
    MQTT_PUBREC = 5,
    MQTT_PUBREL = 6,
    MQTT_PUBCOMP = 7,
    MQTT_SUBSCRIBE = 8,
    MQTT_SUBACK = 9,
    MQTT_UNSUBSCRIBE = 10,
    MQTT_UNSUBACK = 11,
    MQTT_PINGREQ = 12,
    MQTT_PINGRESP = 13,
    MQTT_DISCONNECT = 14,
};
class MQTT_string;
class Command;
class MQTT_PDU;
class MQTT_Flow;
class MQTT_will;
class MQTT_connect;
class MQTT_connack;
class MQTT_publish;
class MQTT_puback;
class MQTT_pubrec;
class MQTT_pubrel;
class MQTT_pubcomp;
class MQTT_subscribe_topic;
class MQTT_subscribe;
class MQTT_suback;
class MQTT_unsuback;
class MQTT_unsubscribe;
class MQTT_disconnect;
class MQTT_pingreq;
class MQTT_pingresp;
} // namespace MQTT

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace MQTT {

class ContextMQTT final {
public:
    ContextMQTT(MQTT_Conn* connection, MQTT_Flow* flow);
    ~ContextMQTT();

    // Member access functions
    MQTT_Conn* connection() const { return connection_; }
    MQTT_Flow* flow() const { return flow_; }

protected:
    MQTT_Conn* connection_;
    MQTT_Flow* flow_;
};


class MQTT_Conn final : public binpac::ConnectionAnalyzer {
public:
    MQTT_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~MQTT_Conn() override;

    // Member access functions
    MQTT_Flow* upflow() const { return upflow_; }
    MQTT_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    uint32 calc_header_length(vector<uint8>* vals);

protected:
    MQTT_Flow* upflow_;
    MQTT_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


class MQTT_string final {
public:
    MQTT_string();
    ~MQTT_string();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 len() const { return len_; }
    bytestring const& str() const { return str_; }

protected:
    uint16 len_;
    bytestring str_;
};


class Command final {
public:
    Command(MQTT_PDU* pdu, uint8 msg_type);
    ~Command();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    MQTT_connect* connect() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/connect.pac:2:connect", (int64)val_case_index(), "MQTT_CONNECT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return connect_;
    }
    MQTT_connack* connack() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/connack.pac:2:connack", (int64)val_case_index(), "MQTT_CONNACK");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return connack_;
    }
    MQTT_publish* publish() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/publish.pac:2:publish", (int64)val_case_index(), "MQTT_PUBLISH");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return publish_;
    }
    MQTT_puback* puback() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/puback.pac:2:puback", (int64)val_case_index(), "MQTT_PUBACK");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return puback_;
    }
    MQTT_pubrec* pubrec() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/pubrec.pac:2:pubrec", (int64)val_case_index(), "MQTT_PUBREC");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pubrec_;
    }
    MQTT_pubrel* pubrel() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/pubrel.pac:2:pubrel", (int64)val_case_index(), "MQTT_PUBREL");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pubrel_;
    }
    MQTT_pubcomp* pubcomp() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)7):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/pubcomp.pac:2:pubcomp", (int64)val_case_index(), "MQTT_PUBCOMP");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pubcomp_;
    }
    MQTT_subscribe* subscribe() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/subscribe.pac:2:subscribe", (int64)val_case_index(), "MQTT_SUBSCRIBE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return subscribe_;
    }
    MQTT_suback* suback() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)9):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/suback.pac:2:suback", (int64)val_case_index(), "MQTT_SUBACK");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return suback_;
    }
    MQTT_unsuback* unsuback() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)11):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/unsuback.pac:2:unsuback", (int64)val_case_index(), "MQTT_UNSUBACK");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return unsuback_;
    }
    MQTT_unsubscribe* unsubscribe() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/unsubscribe.pac:2:unsubscribe", (int64)val_case_index(), "MQTT_UNSUBSCRIBE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return unsubscribe_;
    }
    MQTT_disconnect* disconnect() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)14):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/disconnect.pac:2:disconnect", (int64)val_case_index(), "MQTT_DISCONNECT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return disconnect_;
    }
    MQTT_pingreq* pingreq() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)12):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/pingreq.pac:2:pingreq", (int64)val_case_index(), "MQTT_PINGREQ");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pingreq_;
    }
    MQTT_pingresp* pingresp() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)13):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/pingresp.pac:2:pingresp", (int64)val_case_index(), "MQTT_PINGRESP");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pingresp_;
    }
    MQTT_PDU* pdu() const { return pdu_; }
    uint8 msg_type() const { return msg_type_; }

protected:
    uint8 val_case_index_;
    MQTT_connect* connect_;
    MQTT_connack* connack_;
    MQTT_publish* publish_;
    MQTT_puback* puback_;
    MQTT_pubrec* pubrec_;
    MQTT_pubrel* pubrel_;
    MQTT_pubcomp* pubcomp_;
    MQTT_subscribe* subscribe_;
    MQTT_suback* suback_;
    MQTT_unsuback* unsuback_;
    MQTT_unsubscribe* unsubscribe_;
    MQTT_disconnect* disconnect_;
    MQTT_pingreq* pingreq_;
    MQTT_pingresp* pingresp_;
    MQTT_PDU* pdu_;
    uint8 msg_type_;
};


class MQTT_PDU final {
public:
    MQTT_PDU(bool is_orig);
    ~MQTT_PDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context);

    // Member access functions
    uint8 fixed_header() const { return fixed_header_; }
    vector<uint8>* remaining_length() const { return remaining_length_; }
    Command* command() const { return command_; }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }
    uint8 msg_type() const { return msg_type_; }
    int real_length() const { return real_length_; }

protected:
    uint8 fixed_header_;
    vector<uint8>* remaining_length_;
    uint8 remaining_length__elem_;
    Command* command_;
    bool is_orig_;
    int byteorder_;
    uint8 msg_type_;
    int real_length_;
};


class MQTT_Flow final : public binpac::FlowAnalyzer {
public:
    MQTT_Flow(MQTT_Conn* connection, bool is_orig);
    ~MQTT_Flow() override;

    // Member access functions
    MQTT_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

    // Functions
    bool proc_mqtt_connect(MQTT_connect* msg);
    bool proc_mqtt_connack(MQTT_connack* msg);
    bool proc_mqtt_publish(MQTT_publish* msg, MQTT_PDU* pdu);
    bool proc_mqtt_puback(MQTT_puback* msg, bool is_orig);
    bool proc_mqtt_pubrec(MQTT_pubrec* msg, bool is_orig);
    bool proc_mqtt_pubrel(MQTT_pubrel* msg, bool is_orig);
    bool proc_mqtt_pubcomp(MQTT_pubcomp* msg, bool is_orig);
    bool proc_mqtt_subscribe(MQTT_subscribe* msg);
    bool proc_mqtt_suback(MQTT_suback* msg);
    bool proc_mqtt_unsuback(MQTT_unsuback* msg);
    bool proc_mqtt_unsubscribe(MQTT_unsubscribe* msg);
    bool proc_mqtt_disconnect(MQTT_disconnect* msg);
    bool proc_mqtt_pingreq(MQTT_pingreq* msg);
    bool proc_mqtt_pingresp(MQTT_pingresp* msg);

protected:
    MQTT_PDU* dataunit_;
    ContextMQTT* context_;
    MQTT_Conn* connection_;
    bool is_orig_;
};


class MQTT_will final {
public:
    MQTT_will();
    ~MQTT_will();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    MQTT_string* topic() const { return topic_; }
    MQTT_string* msg() const { return msg_; }

protected:
    MQTT_string* topic_;
    MQTT_string* msg_;
};


class MQTT_connect final {
public:
    MQTT_connect();
    ~MQTT_connect();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder);

    // Member access functions
    MQTT_string* protocol_name() const { return protocol_name_; }
    int8 protocol_version() const { return protocol_version_; }
    uint8 connect_flags() const { return connect_flags_; }
    uint16 keep_alive() const { return keep_alive_; }
    MQTT_string* client_id() const { return client_id_; }
    int will_fields_case_index() const	{ return will_fields_case_index_; }
    MQTT_will* will() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( will_fields_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/connect.pac:19:will", (int64)will_fields_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return will_;
    }
    int username_fields_case_index() const	{ return username_fields_case_index_; }
    MQTT_string* uname() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( username_fields_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/connect.pac:23:uname", (int64)username_fields_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return uname_;
    }
    int password_fields_case_index() const	{ return password_fields_case_index_; }
    MQTT_string* pass() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( password_fields_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mqtt/commands/connect.pac:27:pass", (int64)password_fields_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pass_;
    }
    bool username() const { return username_; }
    bool password() const { return password_; }
    bool will_retain() const { return will_retain_; }
    uint8 will_qos() const { return will_qos_; }
    bool will_flag() const { return will_flag_; }
    bool clean_session() const { return clean_session_; }
    bool proc() const { return proc_; }

protected:
    MQTT_string* protocol_name_;
    int8 protocol_version_;
    uint8 connect_flags_;
    uint16 keep_alive_;
    MQTT_string* client_id_;
    int will_fields_case_index_;
    MQTT_will* will_;
    int username_fields_case_index_;
    MQTT_string* uname_;
    int password_fields_case_index_;
    MQTT_string* pass_;
    bool username_;
    bool password_;
    bool will_retain_;
    uint8 will_qos_;
    bool will_flag_;
    bool clean_session_;
    bool proc_;
};


class MQTT_connack final {
public:
    MQTT_connack();
    ~MQTT_connack();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context);

    // Member access functions
    uint8 flags() const { return flags_; }
    uint8 return_code() const { return return_code_; }
    bool session_present() const { return session_present_; }
    bool proc() const { return proc_; }

protected:
    uint8 flags_;
    uint8 return_code_;
    bool session_present_;
    bool proc_;
};


class MQTT_publish final {
public:
    MQTT_publish(MQTT_PDU* pdu);
    ~MQTT_publish();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder);

    // Member access functions
    MQTT_string* topic() const { return topic_; }
    uint8 has_msg_id_case_index() const	{ return has_msg_id_case_index_; }
    uint16 msg_id() const {
        return msg_id_;
    }
    bytestring const& payload() const { return payload_; }
    MQTT_PDU* pdu() const { return pdu_; }
    bool dup() const { return dup_; }
    uint8 qos() const { return qos_; }
    bool retain() const { return retain_; }
    bool proc() const { return proc_; }

protected:
    MQTT_string* topic_;
    uint8 has_msg_id_case_index_;
    uint16 msg_id_;
    bytestring payload_;
    MQTT_PDU* pdu_;
    bool dup_;
    uint8 qos_;
    bool retain_;
    bool proc_;
};


class MQTT_puback final {
public:
    MQTT_puback(MQTT_PDU* pdu);
    ~MQTT_puback();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder);

    // Member access functions
    uint16 msg_id() const { return msg_id_; }
    MQTT_PDU* pdu() const { return pdu_; }
    bool proc() const { return proc_; }

protected:
    uint16 msg_id_;
    MQTT_PDU* pdu_;
    bool proc_;
};


class MQTT_pubrec final {
public:
    MQTT_pubrec(MQTT_PDU* pdu);
    ~MQTT_pubrec();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder);

    // Member access functions
    uint16 msg_id() const { return msg_id_; }
    MQTT_PDU* pdu() const { return pdu_; }
    bool proc() const { return proc_; }

protected:
    uint16 msg_id_;
    MQTT_PDU* pdu_;
    bool proc_;
};


class MQTT_pubrel final {
public:
    MQTT_pubrel(MQTT_PDU* pdu);
    ~MQTT_pubrel();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder);

    // Member access functions
    uint16 msg_id() const { return msg_id_; }
    MQTT_PDU* pdu() const { return pdu_; }
    bool proc() const { return proc_; }

protected:
    uint16 msg_id_;
    MQTT_PDU* pdu_;
    bool proc_;
};


class MQTT_pubcomp final {
public:
    MQTT_pubcomp(MQTT_PDU* pdu);
    ~MQTT_pubcomp();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder);

    // Member access functions
    uint16 msg_id() const { return msg_id_; }
    MQTT_PDU* pdu() const { return pdu_; }
    bool proc() const { return proc_; }

protected:
    uint16 msg_id_;
    MQTT_PDU* pdu_;
    bool proc_;
};


class MQTT_subscribe_topic final {
public:
    MQTT_subscribe_topic();
    ~MQTT_subscribe_topic();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    MQTT_string* name() const { return name_; }
    uint8 requested_QoS() const { return requested_QoS_; }

protected:
    MQTT_string* name_;
    uint8 requested_QoS_;
};


class MQTT_subscribe final {
public:
    MQTT_subscribe();
    ~MQTT_subscribe();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder);

    // Member access functions
    uint16 msg_id() const { return msg_id_; }
    vector<MQTT_subscribe_topic*>* topics() const { return topics_; }
    bool proc() const { return proc_; }

protected:
    uint16 msg_id_;
    vector<MQTT_subscribe_topic*>* topics_;
    MQTT_subscribe_topic* topics__elem_;
    bool proc_;
};


class MQTT_suback final {
public:
    MQTT_suback();
    ~MQTT_suback();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder);

    // Member access functions
    uint16 msg_id() const { return msg_id_; }
    uint8 granted_QoS() const { return granted_QoS_; }
    bool proc() const { return proc_; }

protected:
    uint16 msg_id_;
    uint8 granted_QoS_;
    bool proc_;
};


class MQTT_unsuback final {
public:
    MQTT_unsuback();
    ~MQTT_unsuback();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder);

    // Member access functions
    uint16 msg_id() const { return msg_id_; }
    bool proc() const { return proc_; }

protected:
    uint16 msg_id_;
    bool proc_;
};


class MQTT_unsubscribe final {
public:
    MQTT_unsubscribe();
    ~MQTT_unsubscribe();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context, int t_byteorder);

    // Member access functions
    uint16 msg_id() const { return msg_id_; }
    vector<MQTT_string*>* topics() const { return topics_; }
    bool proc() const { return proc_; }

protected:
    uint16 msg_id_;
    vector<MQTT_string*>* topics_;
    MQTT_string* topics__elem_;
    bool proc_;
};


class MQTT_disconnect final {
public:
    MQTT_disconnect();
    ~MQTT_disconnect();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context);

    // Member access functions
    bool proc() const { return proc_; }

protected:
    bool proc_;
};


class MQTT_pingreq final {
public:
    MQTT_pingreq();
    ~MQTT_pingreq();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context);

    // Member access functions
    bool proc() const { return proc_; }

protected:
    bool proc_;
};


class MQTT_pingresp final {
public:
    MQTT_pingresp();
    ~MQTT_pingresp();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMQTT* t_context);

    // Member access functions
    bool proc() const { return proc_; }

protected:
    bool proc_;
};

} // namespace MQTT
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_mqtt_mqtt_pac_h */
