// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_mysql_mysql_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_mysql_mysql_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"



namespace zeek::analyzer::mysql { class MySQL_Analyzer; }
namespace binpac { namespace MySQL { class MySQL_Conn; } }
using MySQLAnalyzer = zeek::analyzer::mysql::MySQL_Analyzer*;

#include "zeek/analyzer/protocol/mysql/MySQL.h"

#include "zeek/analyzer/protocol/mysql/events.bif.h"


namespace binpac {

namespace MySQL {
class ContextMySQL;
class MySQL_Conn;
class uint24le;
class LengthEncodedInteger;
class LengthEncodedIntegerArg;
class LengthEncodedIntegerLookahead;
class LengthEncodedString;
class LengthEncodedStringArg;
// NOLINTNEXTLINE(performance-enum-size)
enum command_consts {
    COM_SLEEP = 0,
    COM_QUIT = 1,
    COM_INIT_DB = 2,
    COM_QUERY = 3,
    COM_FIELD_LIST = 4,
    COM_CREATE_DB = 5,
    COM_DROP_DB = 6,
    COM_REFRESH = 7,
    COM_SHUTDOWN = 8,
    COM_STATISTICS = 9,
    COM_PROCESS_INFO = 10,
    COM_CONNECT = 11,
    COM_PROCESS_KILL = 12,
    COM_DEBUG = 13,
    COM_PING = 14,
    COM_TIME = 15,
    COM_DELAYED_INSERT = 16,
    COM_CHANGE_USER = 17,
    COM_BINLOG_DUMP = 18,
    COM_TABLE_DUMP = 19,
    COM_CONNECT_OUT = 20,
    COM_REGISTER_SLAVE = 21,
    COM_STMT_PREPARE = 22,
    COM_STMT_EXECUTE = 23,
    COM_STMT_SEND_LONG_DATA = 24,
    COM_STMT_CLOSE = 25,
    COM_STMT_RESET = 26,
    COM_SET_OPTION = 27,
    COM_STMT_FETCH = 28,
    COM_DAEMON = 29,
    COM_BINLOG_DUMP_GTID = 30,
    COM_RESET_CONNECTION = 31,
};
// NOLINTNEXTLINE(performance-enum-size)
enum state {
    CONNECTION_PHASE = 0,
    COMMAND_PHASE = 1,
};
// NOLINTNEXTLINE(performance-enum-size)
enum ConnectionExpected {
    EXPECT_HANDSHAKE,
    EXPECT_AUTH_DATA,
};
// NOLINTNEXTLINE(performance-enum-size)
enum Expected {
    NO_EXPECTATION,
    EXPECT_STATUS,
    EXPECT_COLUMN_DEFINITION,
    EXPECT_COLUMN_DEFINITION_OR_EOF,
    EXPECT_COLUMN_COUNT,
    EXPECT_EOF_THEN_RESULTSET,
    EXPECT_RESULTSET,
    EXPECT_REST_OF_PACKET,
};
// NOLINTNEXTLINE(performance-enum-size)
enum EOFType {
    EOF_INTERMEDIATE,
    EOF_END,
};
// NOLINTNEXTLINE(performance-enum-size)
enum Client_Capabilities {
    CLIENT_CONNECT_WITH_DB = 8,
    CLIENT_SSL = 2048,
    CLIENT_PLUGIN_AUTH = 524288,
    CLIENT_CONNECT_ATTRS = 1048576,
    CLIENT_DEPRECATE_EOF = 16777216,
    CLIENT_ZSTD_COMPRESSION_ALGORITHM = 67108864,
    CLIENT_QUERY_ATTRIBUTES = 134217728,
};
// NOLINTNEXTLINE(performance-enum-size)
enum field_types {
    TYPE_DECIMAL = 0,
    TYPE_TINY = 1,
    TYPE_SHORT = 2,
    TYPE_LONG = 3,
    TYPE_FLOAT = 4,
    TYPE_DOUBLE = 5,
    TYPE_NULL = 6,
    TYPE_TIMESTAMP = 7,
    TYPE_LONGLONG = 8,
    TYPE_INT24 = 9,
    TYPE_DATE = 10,
    TYPE_TIME = 11,
    TYPE_DATETIME = 12,
    TYPE_YEAR = 13,
    TYPE_VARCHAR = 15,
    TYPE_BIT = 16,
    TYPE_TIMESTAMP2 = 17,
    TYPE_JSON = 245,
    TYPE_NEWDECIMAL = 246,
    TYPE_ENUM = 247,
    TYPE_SET = 248,
    TYPE_TINYBLOB = 249,
    TYPE_MEDIUMBLOB = 250,
    TYPE_LONGBLOB = 251,
    TYPE_BLOB = 252,
    TYPE_VARSTRING = 253,
    TYPE_STRING = 254,
    TYPE_GEOMETRY = 255,
};
class Date;
class Time;
class BinaryDate;
class DurationTime;
class BinaryTime;
class BinaryValue;
extern RegExMatcher NUL_String_re_001;

class NUL_String;
extern RegExMatcher EmptyOrNUL_String_re_002;

class EmptyOrNUL_String;
class MySQL_PDU;
class Header;
class Server_Message;
class Server_Connection_Phase;
class Initial_Handshake_Packet;
class Handshake_v10;
class Handshake_v9;
class Server_Connection_Phase_Packets;
class Handshake_Response_Packet;
class Handshake_Credentials_v10;
class Connection_Attribute;
class Handshake_Connection_Attributes;
class Handshake_Plain_v10;
class Handshake_Response_Packet_v10;
class Handshake_Response_Packet_v9;
class Client_Message;
class Connection_Phase_Packets;
class AttributeTypeAndName;
class AttributeValue;
class Attributes;
class Query_Attributes;
class Command_Request_Packet;
class Change_User_Packet;
class Command_Response;
class Command_Response_Status;
class ColumnCountMeta;
class ColumnCount;
class ColumnDefinition;
class EOFOrOK;
class ColumnDefinitionOrEOF;
class EOFIfLegacyThenResultset;
class Resultset;
class ResultsetRow;
class ColumnDefinition41;
class AuthMoreData;
class AuthSwitchRequest;
class ColumnDefinition320;
class OK_Packet;
class ERR_Packet;
class EOF_Packet;
class EOF_Packet_With_Marker;
class MySQL_Flow;
} // namespace MySQL

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace MySQL {

class ContextMySQL final {
public:
    ContextMySQL(MySQL_Conn* connection, MySQL_Flow* flow, FlowBuffer* flow_buffer);
    ~ContextMySQL();

    // Member access functions
    MySQL_Conn* connection() const { return connection_; }
    MySQL_Flow* flow() const { return flow_; }
    FlowBuffer* flow_buffer() const { return flow_buffer_; }

protected:
    MySQL_Conn* connection_;
    MySQL_Flow* flow_;
    FlowBuffer* flow_buffer_;
};


class MySQL_Conn final : public binpac::ConnectionAnalyzer {
public:
    MySQL_Conn(MySQLAnalyzer const& zeek_analyzer);
    ~MySQL_Conn() override;

    // Member access functions
    MySQL_Flow* upflow() const { return upflow_; }
    MySQL_Flow* downflow() const { return downflow_; }
    MySQLAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    uint8 get_version();
    bool set_version(uint8 v);
    uint8 get_previous_seq_id();
    bool set_previous_seq_id(uint8 s);
    int get_state();
    bool update_state(state s);
    bool get_deprecate_eof();
    bool set_deprecate_eof(bool d);
    bool get_server_query_attrs();
    bool set_server_query_attrs(bool q);
    bool get_client_query_attrs();
    bool set_client_query_attrs(bool q);
    bool set_client_capabilities(uint32 c);
    uint32 get_client_capabilities();
    Expected get_expectation();
    bool set_next_expected(Expected e);
    ConnectionExpected get_conn_expectation();
    bool set_next_conn_expected(ConnectionExpected c);
    bool set_next_expected_from_command(uint8 cmd);
    uint32 get_col_count();
    bool set_col_count(uint32 i);
    uint32 get_remaining_cols();
    bool set_remaining_cols(uint32 i);
    bool dec_remaining_cols();
    uint32 get_results_seen();
    bool set_results_seen(uint32 i);
    bool inc_results_seen();
    int query_attr_idx();
    bool new_query_attrs();
    bool next_query_attr();

protected:

    // Additional members

		uint8 version_;
		uint8 previous_seq_id_;
		int state_;
		Expected expected_;
		ConnectionExpected conn_expected_;
		uint32 col_count_;
		uint32 remaining_cols_;
		uint32 results_seen_;
		bool deprecate_eof_;
		bool server_query_attrs_;
		bool client_query_attrs_;
		uint32 client_capabilities_;
		std::string auth_plugin_;
		int query_attr_idx_;
	
    MySQL_Flow* upflow_;
    MySQL_Flow* downflow_;
    MySQLAnalyzer zeek_analyzer_;
};


class uint24le final {
public:
    uint24le();
    ~uint24le();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 byte3() const { return byte3_; }
    uint8 byte2() const { return byte2_; }
    uint8 byte1() const { return byte1_; }

protected:
    uint8 byte3_;
    uint8 byte2_;
    uint8 byte1_;
};


class LengthEncodedInteger final {
public:
    LengthEncodedInteger();
    ~LengthEncodedInteger();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 length() const { return length_; }
    LengthEncodedIntegerLookahead* integer() const { return integer_; }

protected:
    uint8 length_;
    LengthEncodedIntegerLookahead* integer_;
};


class LengthEncodedIntegerArg final {
public:
    LengthEncodedIntegerArg(uint8 length);
    ~LengthEncodedIntegerArg();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    LengthEncodedIntegerLookahead* integer() const { return integer_; }
    uint8 length() const { return length_; }

protected:
    LengthEncodedIntegerLookahead* integer_;
    uint8 length_;
};


class LengthEncodedIntegerLookahead final {
public:
    LengthEncodedIntegerLookahead(uint8 length);
    ~LengthEncodedIntegerLookahead();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    uint16 i2() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)252):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:27:i2", (int64)val_case_index(), "((int) 0xfc)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return i2_;
    }
    uint24le* i3() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)253):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:28:i3", (int64)val_case_index(), "((int) 0xfd)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return i3_;
    }
    uint64 i4() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)254):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:29:i4", (int64)val_case_index(), "((int) 0xfe)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return i4_;
    }
    uint8 length() const { return length_; }

protected:
    uint8 val_case_index_;
    uint16 i2_;
    uint24le* i3_;
    uint64 i4_;
    uint8 length_;
};


class LengthEncodedString final {
public:
    LengthEncodedString();
    ~LengthEncodedString();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    LengthEncodedInteger* len() const { return len_; }
    bytestring const& val() const { return val_; }

protected:
    LengthEncodedInteger* len_;
    bytestring val_;
};


class LengthEncodedStringArg final {
public:
    LengthEncodedStringArg(uint8 first_byte);
    ~LengthEncodedStringArg();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    LengthEncodedIntegerArg* len() const { return len_; }
    bytestring const& val() const { return val_; }
    uint8 first_byte() const { return first_byte_; }

protected:
    LengthEncodedIntegerArg* len_;
    bytestring val_;
    uint8 first_byte_;
};


	class to_int
		{
		public:
		int operator()(uint24le* num) const
			{
			// Convert 24bit little endian int parsed as 3 uint8 into host endianness.
			return (num->byte1() << 16) | (num->byte2() << 8) | num->byte3();
			}

		int operator()(LengthEncodedInteger* lei) const
			{
			if ( lei->length() < 0xfb )
				return lei->length();
			else if ( lei->length() == 0xfc )
				return lei->integer()->i2();
			else if ( lei->length() == 0xfd )
				return to_int()(lei->integer()->i3());
			else if ( lei->length() == 0xfe )
				return lei->integer()->i4();
			else
				return 0;
			}

		int operator()(LengthEncodedIntegerArg* lei) const
			{
			if ( lei->length() < 0xfb )
				return lei->length();
			else if ( lei->length() == 0xfc )
				return lei->integer()->i2();
			else if ( lei->length() == 0xfd )
				return to_int()(lei->integer()->i3());
			else if ( lei->length() == 0xfe )
				return lei->integer()->i4();
			else
				return 0;
			}

		int operator()(LengthEncodedIntegerLookahead* lei) const
			{
			if ( lei->length() < 0xfb )
				return lei->length();
			else if ( lei->length() == 0xfc )
				return lei->i2();
			else if ( lei->length() == 0xfd )
				return to_int()(lei->i3());
			else if ( lei->length() == 0xfe )
				return lei->i4();
			else
				return 0;
			}
		};


class Date final {
public:
    Date();
    ~Date();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    int16 year() const { return year_; }
    int8 month() const { return month_; }
    int8 day() const { return day_; }

protected:
    int16 year_;
    int8 month_;
    int8 day_;
};


class Time final {
public:
    Time();
    ~Time();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    int8 hour() const { return hour_; }
    int8 minute() const { return minute_; }
    int8 second() const { return second_; }

protected:
    int8 hour_;
    int8 minute_;
    int8 second_;
};


class BinaryDate final {
public:
    BinaryDate();
    ~BinaryDate();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 len() const { return len_; }
    int have_date_case_index() const	{ return have_date_case_index_; }
    Date* date() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_date_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:226:date", (int64)have_date_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return date_;
    }
    int have_time_case_index() const	{ return have_time_case_index_; }
    Time* time() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_time_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:230:time", (int64)have_time_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return time_;
    }
    int have_micros_case_index() const	{ return have_micros_case_index_; }
    int32 micros() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_micros_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:234:micros", (int64)have_micros_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return micros_;
    }

protected:
    uint8 len_;
    int have_date_case_index_;
    Date* date_;
    int have_time_case_index_;
    Time* time_;
    int have_micros_case_index_;
    int32 micros_;
};


class DurationTime final {
public:
    DurationTime();
    ~DurationTime();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    int8 is_negative() const { return is_negative_; }
    int32 days() const { return days_; }
    Time* time() const { return time_; }

protected:
    int8 is_negative_;
    int32 days_;
    Time* time_;
};


class BinaryTime final {
public:
    BinaryTime();
    ~BinaryTime();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 len() const { return len_; }
    int have_time_case_index() const	{ return have_time_case_index_; }
    DurationTime* time() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_time_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:248:time", (int64)have_time_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return time_;
    }
    int have_micros_case_index() const	{ return have_micros_case_index_; }
    int32 micros() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_micros_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:252:micros", (int64)have_micros_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return micros_;
    }

protected:
    uint8 len_;
    int have_time_case_index_;
    DurationTime* time_;
    int have_micros_case_index_;
    int32 micros_;
};


class BinaryValue final {
public:
    BinaryValue(uint16 type);
    ~BinaryValue();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 value_case_index() const	{ return value_case_index_; }
    LengthEncodedInteger* decimal_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:259:decimal_val", (int64)value_case_index(), "TYPE_DECIMAL");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return decimal_val_;
    }
    int8 tiny_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:260:tiny_val", (int64)value_case_index(), "TYPE_TINY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tiny_val_;
    }
    int16 short_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:261:short_val", (int64)value_case_index(), "TYPE_SHORT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return short_val_;
    }
    int32 long_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:262:long_val", (int64)value_case_index(), "TYPE_LONG");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return long_val_;
    }
    bytestring const& float_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:263:float_val", (int64)value_case_index(), "TYPE_FLOAT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return float_val_;
    }
    bytestring const& double_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:264:double_val", (int64)value_case_index(), "TYPE_DOUBLE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return double_val_;
    }
    BinaryDate* timestamp_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)7):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:266:timestamp_val", (int64)value_case_index(), "TYPE_TIMESTAMP");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return timestamp_val_;
    }
    int64 longlong_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:267:longlong_val", (int64)value_case_index(), "TYPE_LONGLONG");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return longlong_val_;
    }
    int32 int24_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)9):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:268:int24_val", (int64)value_case_index(), "TYPE_INT24");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return int24_val_;
    }
    BinaryDate* date_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:269:date_val", (int64)value_case_index(), "TYPE_DATE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return date_val_;
    }
    BinaryTime* time_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)11):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:270:time_val", (int64)value_case_index(), "TYPE_TIME");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return time_val_;
    }
    BinaryDate* datetime_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)12):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:271:datetime_val", (int64)value_case_index(), "TYPE_DATETIME");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return datetime_val_;
    }
    int16 year_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)13):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:272:year_val", (int64)value_case_index(), "TYPE_YEAR");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return year_val_;
    }
    LengthEncodedString* varchar_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)15):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:273:varchar_val", (int64)value_case_index(), "TYPE_VARCHAR");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return varchar_val_;
    }
    LengthEncodedString* bit_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:274:bit_val", (int64)value_case_index(), "TYPE_BIT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return bit_val_;
    }
    BinaryDate* timestamp2_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)17):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:275:timestamp2_val", (int64)value_case_index(), "TYPE_TIMESTAMP2");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return timestamp2_val_;
    }
    LengthEncodedString* json_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)245):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:276:json_val", (int64)value_case_index(), "TYPE_JSON");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return json_val_;
    }
    LengthEncodedString* newdecimal_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)246):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:277:newdecimal_val", (int64)value_case_index(), "TYPE_NEWDECIMAL");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return newdecimal_val_;
    }
    LengthEncodedString* enum_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)247):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:278:enum_val", (int64)value_case_index(), "TYPE_ENUM");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return enum_val_;
    }
    LengthEncodedString* set_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)248):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:279:set_val", (int64)value_case_index(), "TYPE_SET");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return set_val_;
    }
    LengthEncodedString* tinyblob_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)249):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:280:tinyblob_val", (int64)value_case_index(), "TYPE_TINYBLOB");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tinyblob_val_;
    }
    LengthEncodedString* mediumblob_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)250):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:281:mediumblob_val", (int64)value_case_index(), "TYPE_MEDIUMBLOB");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return mediumblob_val_;
    }
    LengthEncodedString* longblob_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)251):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:282:longblob_val", (int64)value_case_index(), "TYPE_LONGBLOB");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return longblob_val_;
    }
    LengthEncodedString* blob_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)252):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:283:blob_val", (int64)value_case_index(), "TYPE_BLOB");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return blob_val_;
    }
    LengthEncodedString* varstring_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)253):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:284:varstring_val", (int64)value_case_index(), "TYPE_VARSTRING");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return varstring_val_;
    }
    LengthEncodedString* string_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)254):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:285:string_val", (int64)value_case_index(), "TYPE_STRING");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return string_val_;
    }
    LengthEncodedString* geometry_val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint16)255):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:286:geometry_val", (int64)value_case_index(), "TYPE_GEOMETRY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return geometry_val_;
    }
    uint16 type() const { return type_; }

protected:
    uint16 value_case_index_;
    LengthEncodedInteger* decimal_val_;
    int8 tiny_val_;
    int16 short_val_;
    int32 long_val_;
    bytestring float_val_;
    bytestring double_val_;
    BinaryDate* timestamp_val_;
    int64 longlong_val_;
    int32 int24_val_;
    BinaryDate* date_val_;
    BinaryTime* time_val_;
    BinaryDate* datetime_val_;
    int16 year_val_;
    LengthEncodedString* varchar_val_;
    LengthEncodedString* bit_val_;
    BinaryDate* timestamp2_val_;
    LengthEncodedString* json_val_;
    LengthEncodedString* newdecimal_val_;
    LengthEncodedString* enum_val_;
    LengthEncodedString* set_val_;
    LengthEncodedString* tinyblob_val_;
    LengthEncodedString* mediumblob_val_;
    LengthEncodedString* longblob_val_;
    LengthEncodedString* blob_val_;
    LengthEncodedString* varstring_val_;
    LengthEncodedString* string_val_;
    LengthEncodedString* geometry_val_;
    uint16 type_;
};


class MySQL_PDU final {
public:
    MySQL_PDU(bool is_orig);
    ~MySQL_PDU();
    int initial_buffer_length() const { return 4; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextMySQL* t_context);

    // Member access functions
    Header* hdr() const { return hdr_; }
    int msg_case_index() const	{ return msg_case_index_; }
    Server_Message* server_msg() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:298:server_msg", (int64)msg_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return server_msg_;
    }
    Client_Message* client_msg() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:299:client_msg", (int64)msg_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return client_msg_;
    }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }
    int state() const { return state_; }

protected:
    Header* hdr_;
    int msg_case_index_;
    Server_Message* server_msg_;
    Client_Message* client_msg_;
    bool is_orig_;
    int byteorder_;
    int state_;
    int buffering_state_;
};


class Header final {
public:
    Header();
    ~Header();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint24le* le_len() const { return le_len_; }
    uint8 seq_id() const { return seq_id_; }
    uint32 len() const { return len_; }

protected:
    uint24le* le_len_;
    uint8 seq_id_;
    uint32 len_;
};


class Server_Message final {
public:
    Server_Message(uint8 seq_id, uint32 pkt_len, int state);
    ~Server_Message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    Server_Connection_Phase* connection_phase() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:313:connection_phase", (int64)val_case_index(), "CONNECTION_PHASE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return connection_phase_;
    }
    Command_Response* command_response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:314:command_response", (int64)val_case_index(), "COMMAND_PHASE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return command_response_;
    }
    uint8 seq_id() const { return seq_id_; }
    uint32 pkt_len() const { return pkt_len_; }
    int state() const { return state_; }
    bool is_initial() const { return is_initial_; }
    bool update_seq_id() const { return update_seq_id_; }

protected:
    int val_case_index_;
    Server_Connection_Phase* connection_phase_;
    Command_Response* command_response_;
    uint8 seq_id_;
    uint32 pkt_len_;
    int state_;
    bool is_initial_;
    bool update_seq_id_;
};


class Server_Connection_Phase final {
public:
    Server_Connection_Phase(bool is_initial);
    ~Server_Connection_Phase();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    Initial_Handshake_Packet* initial_handshake() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:321:initial_handshake", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return initial_handshake_;
    }
    Server_Connection_Phase_Packets* subsequent_handshake() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:322:subsequent_handshake", (int64)val_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return subsequent_handshake_;
    }
    bool is_initial() const { return is_initial_; }

protected:
    int val_case_index_;
    Initial_Handshake_Packet* initial_handshake_;
    Server_Connection_Phase_Packets* subsequent_handshake_;
    bool is_initial_;
};


class Initial_Handshake_Packet final {
public:
    Initial_Handshake_Packet();
    ~Initial_Handshake_Packet();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    uint8 version() const { return version_; }
    uint8 pkt_case_index() const	{ return pkt_case_index_; }
    Handshake_v10* handshake10() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( pkt_case_index() ) {
            case ((uint8)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:330:handshake10", (int64)pkt_case_index(), "((int) 10)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return handshake10_;
    }
    Handshake_v9* handshake9() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( pkt_case_index() ) {
            case ((uint8)9):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:331:handshake9", (int64)pkt_case_index(), "((int) 9)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return handshake9_;
    }
    ERR_Packet* error() const {
        return error_;
    }
    bool set_version() const { return set_version_; }
    int proc() const { return proc_; }

protected:
    uint8 version_;
    uint8 pkt_case_index_;
    Handshake_v10* handshake10_;
    Handshake_v9* handshake9_;
    ERR_Packet* error_;
    bool set_version_;
    int proc_;
};


class Handshake_v10 final {
public:
    Handshake_v10();
    ~Handshake_v10();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    bytestring const& server_version() const { return server_version_; }
    uint32 connection_id() const { return connection_id_; }
    bytestring const& auth_plugin_data_part_1() const { return auth_plugin_data_part_1_; }
    uint8 filler_1() const { return filler_1_; }
    uint16 capability_flag_1() const { return capability_flag_1_; }
    uint8 character_set() const { return character_set_; }
    uint16 status_flags() const { return status_flags_; }
    uint16 capability_flags_2() const { return capability_flags_2_; }
    uint8 auth_plugin_data_len() const { return auth_plugin_data_len_; }
    bytestring const& auth_plugin_data_part_2() const { return auth_plugin_data_part_2_; }
    int have_plugin_case_index() const	{ return have_plugin_case_index_; }
    bytestring const& auth_plugin() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_plugin_case_index() ) {
            case ((int)524288):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:351:auth_plugin", (int64)have_plugin_case_index(), "CLIENT_PLUGIN_AUTH");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return auth_plugin_;
    }
    int auth_plugin_data_part_2_len() const { return auth_plugin_data_part_2_len_; }
    bool server_query_attrs() const { return server_query_attrs_; }

protected:
    bytestring server_version_;
    uint32 connection_id_;
    bytestring auth_plugin_data_part_1_;
    uint8 filler_1_;
    uint16 capability_flag_1_;
    uint8 character_set_;
    uint16 status_flags_;
    uint16 capability_flags_2_;
    uint8 auth_plugin_data_len_;
    bytestring auth_plugin_data_part_2_;
    int have_plugin_case_index_;
    bytestring auth_plugin_;
    int auth_plugin_data_part_2_len_;
    bool server_query_attrs_;
};


class Handshake_v9 final {
public:
    Handshake_v9();
    ~Handshake_v9();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    bytestring const& server_version() const { return server_version_; }
    uint32 connection_id() const { return connection_id_; }
    bytestring const& scramble() const { return scramble_; }

protected:
    bytestring server_version_;
    uint32 connection_id_;
    bytestring scramble_;
};


class Server_Connection_Phase_Packets final {
public:
    Server_Connection_Phase_Packets();
    ~Server_Connection_Phase_Packets();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    uint8 pkt_type() const { return pkt_type_; }
    uint8 packet_case_index() const	{ return packet_case_index_; }
    OK_Packet* data_ok() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( packet_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:377:data_ok", (int64)packet_case_index(), "((int) 0x00)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_ok_;
    }
    AuthMoreData* auth_more_data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( packet_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:378:auth_more_data", (int64)packet_case_index(), "((int) 0x01)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return auth_more_data_;
    }
    AuthSwitchRequest* auth_switch_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( packet_case_index() ) {
            case ((uint8)254):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:379:auth_switch_request", (int64)packet_case_index(), "((int) 0xfe)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return auth_switch_request_;
    }
    ERR_Packet* data_err() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( packet_case_index() ) {
            case ((uint8)255):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:380:data_err", (int64)packet_case_index(), "((int) 0xff)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_err_;
    }

protected:
    uint8 pkt_type_;
    uint8 packet_case_index_;
    OK_Packet* data_ok_;
    AuthMoreData* auth_more_data_;
    AuthSwitchRequest* auth_switch_request_;
    ERR_Packet* data_err_;
};


class Handshake_Response_Packet final {
public:
    Handshake_Response_Packet();
    ~Handshake_Response_Packet();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    Handshake_Response_Packet_v10* v10_response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:387:v10_response", (int64)val_case_index(), "((int) 10)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return v10_response_;
    }
    Handshake_Response_Packet_v9* v9_response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)9):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:388:v9_response", (int64)val_case_index(), "((int) 9)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return v9_response_;
    }
    uint8 version() const { return version_; }
    int proc() const { return proc_; }

protected:
    uint8 val_case_index_;
    Handshake_Response_Packet_v10* v10_response_;
    Handshake_Response_Packet_v9* v9_response_;
    uint8 version_;
    int proc_;
};


class Handshake_Credentials_v10 final {
public:
    Handshake_Credentials_v10();
    ~Handshake_Credentials_v10();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    bytestring const& username() const { return username_; }
    LengthEncodedString* password() const { return password_; }

protected:
    bytestring username_;
    LengthEncodedString* password_;
};


class Connection_Attribute final {
public:
    Connection_Attribute();
    ~Connection_Attribute();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    LengthEncodedString* name() const { return name_; }
    LengthEncodedString* value() const { return value_; }

protected:
    LengthEncodedString* name_;
    LengthEncodedString* value_;
};


class Handshake_Connection_Attributes final {
public:
    Handshake_Connection_Attributes();
    ~Handshake_Connection_Attributes();
    int initial_buffer_length() const { return 1; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 length() const { return length_; }
    vector<Connection_Attribute*>* attrs() const { return attrs_; }

protected:
    uint8 length_;
    vector<Connection_Attribute*>* attrs_;
    Connection_Attribute* attrs__elem_;
};


class Handshake_Plain_v10 final {
public:
    Handshake_Plain_v10(uint32 cap_flags);
    ~Handshake_Plain_v10();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    Handshake_Credentials_v10* credentials() const { return credentials_; }
    int have_db_case_index() const	{ return have_db_case_index_; }
    bytestring const& database() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_db_case_index() ) {
            case ((int)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:411:database", (int64)have_db_case_index(), "CLIENT_CONNECT_WITH_DB");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return database_;
    }
    int have_plugin_case_index() const	{ return have_plugin_case_index_; }
    bytestring const& auth_plugin() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_plugin_case_index() ) {
            case ((int)524288):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:415:auth_plugin", (int64)have_plugin_case_index(), "CLIENT_PLUGIN_AUTH");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return auth_plugin_;
    }
    int have_attrs_case_index() const	{ return have_attrs_case_index_; }
    Handshake_Connection_Attributes* conn_attrs() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_attrs_case_index() ) {
            case ((int)1048576):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:419:conn_attrs", (int64)have_attrs_case_index(), "CLIENT_CONNECT_ATTRS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return conn_attrs_;
    }
    int have_zstd_case_index() const	{ return have_zstd_case_index_; }
    uint8 zstd_compression_level() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_zstd_case_index() ) {
            case ((int)67108864):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:423:zstd_compression_level", (int64)have_zstd_case_index(), "CLIENT_ZSTD_COMPRESSION_ALGORITHM");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return zstd_compression_level_;
    }
    uint32 cap_flags() const { return cap_flags_; }
    bool update_conn_expectation() const { BINPAC_ASSERT(has_update_conn_expectation()); return update_conn_expectation_; }
    bool has_update_conn_expectation() const { return has_update_conn_expectation_; }

protected:
    Handshake_Credentials_v10* credentials_;
    int have_db_case_index_;
    bytestring database_;
    int have_plugin_case_index_;
    bytestring auth_plugin_;
    int have_attrs_case_index_;
    Handshake_Connection_Attributes* conn_attrs_;
    int have_zstd_case_index_;
    uint8 zstd_compression_level_;
    uint32 cap_flags_;
    bool update_conn_expectation_;
    bool has_update_conn_expectation_;
};


class Handshake_Response_Packet_v10 final {
public:
    Handshake_Response_Packet_v10();
    ~Handshake_Response_Packet_v10();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    uint32 cap_flags() const { return cap_flags_; }
    uint32 max_pkt_size() const { return max_pkt_size_; }
    uint8 char_set() const { return char_set_; }
    int use_ssl_case_index() const	{ return use_ssl_case_index_; }
    Handshake_Plain_v10* plain() const {
        return plain_;
    }
    bool deprecate_eof() const { return deprecate_eof_; }
    bool client_query_attrs() const { return client_query_attrs_; }
    bool proc_cap_flags() const { return proc_cap_flags_; }

protected:
    uint32 cap_flags_;
    uint32 max_pkt_size_;
    uint8 char_set_;
    int use_ssl_case_index_;
    Handshake_Plain_v10* plain_;
    bool deprecate_eof_;
    bool client_query_attrs_;
    bool proc_cap_flags_;
};


class Handshake_Response_Packet_v9 final {
public:
    Handshake_Response_Packet_v9();
    ~Handshake_Response_Packet_v9();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 cap_flags() const { return cap_flags_; }
    uint24le* max_pkt_size() const { return max_pkt_size_; }
    bytestring const& username() const { return username_; }
    bytestring const& auth_response() const { return auth_response_; }
    int have_db_case_index() const	{ return have_db_case_index_; }
    bytestring const& database() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_db_case_index() ) {
            case ((int)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:454:database", (int64)have_db_case_index(), "CLIENT_CONNECT_WITH_DB");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return database_;
    }
    bytestring const& password() const { return password_; }

protected:
    uint16 cap_flags_;
    uint24le* max_pkt_size_;
    bytestring username_;
    bytestring auth_response_;
    int have_db_case_index_;
    bytestring database_;
    bytestring password_;
};


class Client_Message final {
public:
    Client_Message(uint32 pkt_len, int state);
    ~Client_Message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    Connection_Phase_Packets* connection_phase() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:463:connection_phase", (int64)val_case_index(), "CONNECTION_PHASE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return connection_phase_;
    }
    Command_Request_Packet* command_phase() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:464:command_phase", (int64)val_case_index(), "COMMAND_PHASE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return command_phase_;
    }
    uint32 pkt_len() const { return pkt_len_; }
    int state() const { return state_; }

protected:
    int val_case_index_;
    Connection_Phase_Packets* connection_phase_;
    Command_Request_Packet* command_phase_;
    uint32 pkt_len_;
    int state_;
};


class Connection_Phase_Packets final {
public:
    Connection_Phase_Packets();
    ~Connection_Phase_Packets();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    Handshake_Response_Packet* handshake_resp() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((ConnectionExpected)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:468:handshake_resp", (int64)val_case_index(), "EXPECT_HANDSHAKE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return handshake_resp_;
    }
    AuthMoreData* auth_data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((ConnectionExpected)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:469:auth_data", (int64)val_case_index(), "EXPECT_AUTH_DATA");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return auth_data_;
    }

protected:
    int val_case_index_;
    Handshake_Response_Packet* handshake_resp_;
    AuthMoreData* auth_data_;
};


class AttributeTypeAndName final {
public:
    AttributeTypeAndName();
    ~AttributeTypeAndName();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 type() const { return type_; }
    uint8 unsigned_flag() const { return unsigned_flag_; }
    LengthEncodedString* name() const { return name_; }

protected:
    uint8 type_;
    uint8 unsigned_flag_;
    LengthEncodedString* name_;
};


class AttributeValue final {
public:
    AttributeValue(bool is_null, uint8 type);
    ~AttributeValue();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    int null_case_index() const	{ return null_case_index_; }
    BinaryValue* val() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( null_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:482:val", (int64)null_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return val_;
    }
    bool is_null() const { return is_null_; }
    uint8 type() const { return type_; }
    int done() const { return done_; }

protected:
    int null_case_index_;
    BinaryValue* val_;
    bool is_null_;
    uint8 type_;
    int done_;
};


class Attributes final {
public:
    Attributes(int count);
    ~Attributes();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    bytestring const& null_bitmap() const { return null_bitmap_; }
    uint8 send_types_to_server() const { return send_types_to_server_; }
    vector<AttributeTypeAndName*>* names() const { return names_; }
    vector<AttributeValue*>* values() const { return values_; }
    int count() const { return count_; }

protected:
    bytestring null_bitmap_;
    uint8 send_types_to_server_;
    vector<AttributeTypeAndName*>* names_;
    AttributeTypeAndName* names__elem_;
    vector<AttributeValue*>* values_;
    AttributeValue* values__elem_;
    int count_;
};


class Query_Attributes final {
public:
    Query_Attributes();
    ~Query_Attributes();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    LengthEncodedInteger* count() const { return count_; }
    LengthEncodedInteger* set_count() const { return set_count_; }
    int have_attr_case_index() const	{ return have_attr_case_index_; }
    Attributes* attrs() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_attr_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:507:attrs", (int64)have_attr_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return attrs_;
    }
    int attr_count() const { return attr_count_; }
    int new_query_attrs() const { return new_query_attrs_; }

protected:
    LengthEncodedInteger* count_;
    LengthEncodedInteger* set_count_;
    int have_attr_case_index_;
    Attributes* attrs_;
    int attr_count_;
    int new_query_attrs_;
};


class Command_Request_Packet final {
public:
    Command_Request_Packet(uint32 pkt_len);
    ~Command_Request_Packet();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    uint8 command() const { return command_; }
    int attrs_case_index() const	{ return attrs_case_index_; }
    Query_Attributes* query_attrs() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( attrs_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:520:query_attrs", (int64)attrs_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return query_attrs_;
    }
    int have_change_user_case_index() const	{ return have_change_user_case_index_; }
    Change_User_Packet* change_user() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_change_user_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:525:change_user", (int64)have_change_user_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return change_user_;
    }
    bytestring const& arg() const { return arg_; }
    uint32 pkt_len() const { return pkt_len_; }
    int is_change_user() const { return is_change_user_; }
    bool update_expectation() const { return update_expectation_; }
    int proc() const { return proc_; }
    int proc_change_user() const { BINPAC_ASSERT(has_proc_change_user()); return proc_change_user_; }
    bool has_proc_change_user() const { return has_proc_change_user_; }

protected:
    uint8 command_;
    int attrs_case_index_;
    Query_Attributes* query_attrs_;
    int have_change_user_case_index_;
    Change_User_Packet* change_user_;
    bytestring arg_;
    uint32 pkt_len_;
    int is_change_user_;
    bool update_expectation_;
    int proc_;
    int proc_change_user_;
    bool has_proc_change_user_;
};


class Change_User_Packet final {
public:
    Change_User_Packet(uint32 pkt_len);
    ~Change_User_Packet();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    bytestring const& username() const { return username_; }
    uint8 auth_plugin_data_len() const { return auth_plugin_data_len_; }
    bytestring const& auth_plugin_data() const { return auth_plugin_data_; }
    bytestring const& database() const { return database_; }
    uint16 charset() const { return charset_; }
    int auth_plugin_name_case_case_index() const	{ return auth_plugin_name_case_case_index_; }
    bytestring const& auth_plugin_name() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( auth_plugin_name_case_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:546:auth_plugin_name", (int64)auth_plugin_name_case_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return auth_plugin_name_;
    }
    int conn_attrs_case_case_index() const	{ return conn_attrs_case_case_index_; }
    Handshake_Connection_Attributes* conn_attrs() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( conn_attrs_case_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:551:conn_attrs", (int64)conn_attrs_case_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return conn_attrs_;
    }
    uint32 pkt_len() const { return pkt_len_; }
    int have_more_data() const { return have_more_data_; }
    int have_auth_plugin_name() const { return have_auth_plugin_name_; }
    int have_conn_attrs() const { return have_conn_attrs_; }
    const_bytestring const& sourcedata() const { return sourcedata_; }

protected:
    bytestring username_;
    uint8 auth_plugin_data_len_;
    bytestring auth_plugin_data_;
    bytestring database_;
    uint16 charset_;
    int auth_plugin_name_case_case_index_;
    bytestring auth_plugin_name_;
    int conn_attrs_case_case_index_;
    Handshake_Connection_Attributes* conn_attrs_;
    uint32 pkt_len_;
    int have_more_data_;
    int have_auth_plugin_name_;
    int have_conn_attrs_;
    const_bytestring sourcedata_;
};


class Command_Response final {
public:
    Command_Response(uint32 pkt_len);
    ~Command_Response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    ColumnCountMeta* col_count_meta() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((Expected)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:563:col_count_meta", (int64)val_case_index(), "EXPECT_COLUMN_COUNT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return col_count_meta_;
    }
    ColumnDefinition* col_def() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((Expected)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:564:col_def", (int64)val_case_index(), "EXPECT_COLUMN_DEFINITION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return col_def_;
    }
    ColumnDefinitionOrEOF* def_or_eof() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((Expected)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:565:def_or_eof", (int64)val_case_index(), "EXPECT_COLUMN_DEFINITION_OR_EOF");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return def_or_eof_;
    }
    Resultset* resultset() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((Expected)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:566:resultset", (int64)val_case_index(), "EXPECT_RESULTSET");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return resultset_;
    }
    bytestring const& rest() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((Expected)7):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:567:rest", (int64)val_case_index(), "EXPECT_REST_OF_PACKET");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return rest_;
    }
    Command_Response_Status* status() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((Expected)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:568:status", (int64)val_case_index(), "EXPECT_STATUS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return status_;
    }
    EOFIfLegacyThenResultset* eof() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((Expected)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:569:eof", (int64)val_case_index(), "EXPECT_EOF_THEN_RESULTSET");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return eof_;
    }
    uint32 pkt_len() const { return pkt_len_; }

protected:
    int val_case_index_;
    ColumnCountMeta* col_count_meta_;
    ColumnDefinition* col_def_;
    ColumnDefinitionOrEOF* def_or_eof_;
    Resultset* resultset_;
    bytestring rest_;
    Command_Response_Status* status_;
    EOFIfLegacyThenResultset* eof_;
    uint32 pkt_len_;
};


class Command_Response_Status final {
public:
    Command_Response_Status();
    ~Command_Response_Status();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    uint8 pkt_type() const { return pkt_type_; }
    uint8 response_case_index() const	{ return response_case_index_; }
    OK_Packet* data_ok() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( response_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:576:data_ok", (int64)response_case_index(), "((int) 0x00)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_ok_;
    }
    EOF_Packet* data_eof() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( response_case_index() ) {
            case ((uint8)254):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:577:data_eof", (int64)response_case_index(), "((int) 0xfe)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_eof_;
    }
    ERR_Packet* data_err() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( response_case_index() ) {
            case ((uint8)255):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:578:data_err", (int64)response_case_index(), "((int) 0xff)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_err_;
    }

protected:
    uint8 pkt_type_;
    uint8 response_case_index_;
    OK_Packet* data_ok_;
    EOF_Packet* data_eof_;
    ERR_Packet* data_err_;
};


class ColumnCountMeta final {
public:
    ColumnCountMeta();
    ~ColumnCountMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    uint8 byte() const { return byte_; }
    uint8 pkt_type_case_index() const	{ return pkt_type_case_index_; }
    OK_Packet* ok() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( pkt_type_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:586:ok", (int64)pkt_type_case_index(), "((int) 0x00)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ok_;
    }
    ERR_Packet* err() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( pkt_type_case_index() ) {
            case ((uint8)255):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:587:err", (int64)pkt_type_case_index(), "((int) 0xff)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return err_;
    }
    ColumnCount* col_count() const {
        return col_count_;
    }

protected:
    uint8 byte_;
    uint8 pkt_type_case_index_;
    OK_Packet* ok_;
    ERR_Packet* err_;
    ColumnCount* col_count_;
};


class ColumnCount final {
public:
    ColumnCount(uint8 byte);
    ~ColumnCount();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    LengthEncodedIntegerLookahead* le_column_count() const { return le_column_count_; }
    uint8 byte() const { return byte_; }
    uint32 col_num() const { return col_num_; }
    bool update_col_num() const { return update_col_num_; }
    bool update_remain() const { return update_remain_; }
    bool update_expectation() const { return update_expectation_; }

protected:
    LengthEncodedIntegerLookahead* le_column_count_;
    uint8 byte_;
    uint32 col_num_;
    bool update_col_num_;
    bool update_remain_;
    bool update_expectation_;
};


class ColumnDefinition final {
public:
    ColumnDefinition();
    ~ColumnDefinition();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    uint8 dummy() const { return dummy_; }
    ColumnDefinition41* def() const { return def_; }
    bool update_remain() const { return update_remain_; }
    bool update_expectation() const { return update_expectation_; }

protected:
    uint8 dummy_;
    ColumnDefinition41* def_;
    bool update_remain_;
    bool update_expectation_;
};


class EOFOrOK final {
public:
    EOFOrOK(uint32 pkt_len);
    ~EOFOrOK();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    EOF_Packet* eof() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:615:eof", (int64)val_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return eof_;
    }
    OK_Packet* ok() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:616:ok", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ok_;
    }
    uint32 pkt_len() const { return pkt_len_; }

protected:
    int val_case_index_;
    EOF_Packet* eof_;
    OK_Packet* ok_;
    uint32 pkt_len_;
};


class ColumnDefinitionOrEOF final {
public:
    ColumnDefinitionOrEOF(uint32 pkt_len);
    ~ColumnDefinitionOrEOF();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    uint8 marker() const { return marker_; }
    int def_or_eof_case_index() const	{ return def_or_eof_case_index_; }
    EOFOrOK* eof() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( def_or_eof_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:622:eof", (int64)def_or_eof_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return eof_;
    }
    ColumnDefinition41* def() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( def_or_eof_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:623:def", (int64)def_or_eof_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return def_;
    }
    uint32 pkt_len() const { return pkt_len_; }
    bool is_eof_or_ok() const { return is_eof_or_ok_; }

protected:
    uint8 marker_;
    int def_or_eof_case_index_;
    EOFOrOK* eof_;
    ColumnDefinition41* def_;
    uint32 pkt_len_;
    bool is_eof_or_ok_;
};


class EOFIfLegacyThenResultset final {
public:
    EOFIfLegacyThenResultset(uint32 pkt_len);
    ~EOFIfLegacyThenResultset();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    EOF_Packet_With_Marker* eof() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:631:eof", (int64)val_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return eof_;
    }
    Resultset* resultset() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:632:resultset", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return resultset_;
    }
    uint32 pkt_len() const { return pkt_len_; }
    bool update_result_seen() const { return update_result_seen_; }
    bool update_expectation() const { BINPAC_ASSERT(has_update_expectation()); return update_expectation_; }
    bool has_update_expectation() const { return has_update_expectation_; }

protected:
    int val_case_index_;
    EOF_Packet_With_Marker* eof_;
    Resultset* resultset_;
    uint32 pkt_len_;
    bool update_result_seen_;
    bool update_expectation_;
    bool has_update_expectation_;
};


class Resultset final {
public:
    Resultset(uint32 pkt_len);
    ~Resultset();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    uint8 marker() const { return marker_; }
    int row_or_eof_case_index() const	{ return row_or_eof_case_index_; }
    EOFOrOK* eof() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( row_or_eof_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:641:eof", (int64)row_or_eof_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return eof_;
    }
    ResultsetRow* row() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( row_or_eof_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/mysql/mysql-protocol.pac:642:row", (int64)row_or_eof_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return row_;
    }
    uint32 pkt_len() const { return pkt_len_; }
    bool is_eof_or_ok() const { return is_eof_or_ok_; }
    bool update_result_seen() const { return update_result_seen_; }
    bool update_expectation() const { return update_expectation_; }
    int proc() const { return proc_; }

protected:
    uint8 marker_;
    int row_or_eof_case_index_;
    EOFOrOK* eof_;
    ResultsetRow* row_;
    uint32 pkt_len_;
    bool is_eof_or_ok_;
    bool update_result_seen_;
    bool update_expectation_;
    int proc_;
};


class ResultsetRow final {
public:
    ResultsetRow(uint8 first_byte);
    ~ResultsetRow();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    LengthEncodedStringArg* first_field() const { return first_field_; }
    vector<LengthEncodedString*>* fields() const { return fields_; }
    uint8 first_byte() const { return first_byte_; }

protected:
    LengthEncodedStringArg* first_field_;
    vector<LengthEncodedString*>* fields_;
    LengthEncodedString* fields__elem_;
    uint8 first_byte_;
};


class ColumnDefinition41 final {
public:
    ColumnDefinition41(uint8 first_byte);
    ~ColumnDefinition41();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    LengthEncodedStringArg* catalog() const { return catalog_; }
    LengthEncodedString* schema() const { return schema_; }
    LengthEncodedString* table() const { return table_; }
    LengthEncodedString* org_table() const { return org_table_; }
    LengthEncodedString* name() const { return name_; }
    LengthEncodedString* org_name() const { return org_name_; }
    LengthEncodedInteger* next_len() const { return next_len_; }
    uint16 char_set() const { return char_set_; }
    uint32 col_len() const { return col_len_; }
    uint8 type() const { return type_; }
    uint16 flags() const { return flags_; }
    uint8 decimals() const { return decimals_; }
    uint8 first_byte() const { return first_byte_; }

protected:
    LengthEncodedStringArg* catalog_;
    LengthEncodedString* schema_;
    LengthEncodedString* table_;
    LengthEncodedString* org_table_;
    LengthEncodedString* name_;
    LengthEncodedString* org_name_;
    LengthEncodedInteger* next_len_;
    uint16 char_set_;
    uint32 col_len_;
    uint8 type_;
    uint16 flags_;
    uint8 decimals_;
    uint8 first_byte_;
};


class AuthMoreData final {
public:
    AuthMoreData(bool is_orig);
    ~AuthMoreData();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context);

    // Member access functions
    bytestring const& data() const { return data_; }
    bool is_orig() const { return is_orig_; }
    int proc() const { return proc_; }

protected:
    bytestring data_;
    bool is_orig_;
    int proc_;
};


class AuthSwitchRequest final {
public:
    AuthSwitchRequest();
    ~AuthSwitchRequest();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context);

    // Member access functions
    bytestring const& name() const { return name_; }
    bytestring const& data() const { return data_; }
    bool update_conn_expectation() const { return update_conn_expectation_; }
    bool update_expectation() const { return update_expectation_; }
    int proc() const { return proc_; }

protected:
    bytestring name_;
    bytestring data_;
    bool update_conn_expectation_;
    bool update_expectation_;
    int proc_;
};


class ColumnDefinition320 final {
public:
    ColumnDefinition320();
    ~ColumnDefinition320();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    LengthEncodedString* table() const { return table_; }
    LengthEncodedString* name() const { return name_; }
    LengthEncodedInteger* length_of_col_len() const { return length_of_col_len_; }
    uint24le* col_len() const { return col_len_; }
    LengthEncodedInteger* type_len() const { return type_len_; }
    uint8 type() const { return type_; }

protected:
    LengthEncodedString* table_;
    LengthEncodedString* name_;
    LengthEncodedInteger* length_of_col_len_;
    uint24le* col_len_;
    LengthEncodedInteger* type_len_;
    uint8 type_;
};


class OK_Packet final {
public:
    OK_Packet();
    ~OK_Packet();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    LengthEncodedInteger* le_rows() const { return le_rows_; }
    bytestring const& todo() const { return todo_; }
    uint32 rows() const { return rows_; }
    bool update_state() const { return update_state_; }
    int proc() const { return proc_; }

protected:
    LengthEncodedInteger* le_rows_;
    bytestring todo_;
    uint32 rows_;
    bool update_state_;
    int proc_;
};


class ERR_Packet final {
public:
    ERR_Packet();
    ~ERR_Packet();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    uint16 code() const { return code_; }
    bytestring const& state() const { return state_; }
    bytestring const& msg() const { return msg_; }
    bool update_state() const { return update_state_; }
    int proc() const { return proc_; }

protected:
    uint16 code_;
    bytestring state_;
    bytestring msg_;
    bool update_state_;
    int proc_;
};


class EOF_Packet final {
public:
    EOF_Packet(EOFType typ);
    ~EOF_Packet();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    uint16 warnings() const { return warnings_; }
    uint16 status() const { return status_; }
    EOFType typ() const { return typ_; }
    int proc() const { return proc_; }

protected:
    uint16 warnings_;
    uint16 status_;
    EOFType typ_;
    int proc_;
};


class EOF_Packet_With_Marker final {
public:
    EOF_Packet_With_Marker(EOFType typ);
    ~EOF_Packet_With_Marker();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextMySQL* t_context, int t_byteorder);

    // Member access functions
    uint8 marker() const { return marker_; }
    EOF_Packet* payload() const { return payload_; }
    EOFType typ() const { return typ_; }
    bool update_state() const { return update_state_; }

protected:
    uint8 marker_;
    EOF_Packet* payload_;
    EOFType typ_;
    bool update_state_;
};


class MySQL_Flow final : public binpac::FlowAnalyzer {
public:
    MySQL_Flow(MySQL_Conn* connection, bool is_orig);
    ~MySQL_Flow() override;

    // Member access functions
    FlowBuffer* flow_buffer() const { return flow_buffer_; }
    MySQL_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

    // Functions
    bool proc_mysql_initial_handshake_packet(Initial_Handshake_Packet* msg);
    bool proc_mysql_handshake_response_packet(Handshake_Response_Packet* msg);
    bool proc_mysql_command_request_packet(Command_Request_Packet* msg);
    bool proc_mysql_change_user_packet(Change_User_Packet* msg);
    bool proc_err_packet(ERR_Packet* msg);
    bool proc_ok_packet(OK_Packet* msg);
    bool proc_eof_packet(EOF_Packet* msg);
    bool proc_resultset(Resultset* msg);
    bool proc_auth_switch_request(AuthSwitchRequest* msg);
    bool proc_auth_more_data(AuthMoreData* msg);

protected:
    MySQL_PDU* dataunit_;
    ContextMySQL* context_;
    FlowBuffer* flow_buffer_;
    MySQL_Conn* connection_;
    bool is_orig_;
};

} // namespace MySQL
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_mysql_mysql_pac_h */
