// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/ntlm/ntlm_pac.h"

namespace binpac {






namespace NTLM {
// NOLINTNEXTLINE(modernize-use-equals-default)
ContextNTLM::ContextNTLM(NTLM_Conn* connection, NTLM_Flow* flow) {
    connection_ = connection;
    flow_ = flow;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextNTLM::~ContextNTLM() {
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Conn::NTLM_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new NTLM_Flow(this, true);
    downflow_ = new NTLM_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Conn::~NTLM_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void NTLM_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void NTLM_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void NTLM_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

ZeekVal NTLM_Conn::build_av_record(NTLM_AV_Pair_Sequence* val, uint16 len) {

		zeek::RecordVal* result = new zeek::RecordVal(zeek::BifType::Record::NTLM::AVs);
		for ( uint i = 0; ; i++ )
			{
			if ( i >= val->pairs()->size() )
				{
				if ( len != 0 )
					// According to spec, the TargetInfo MUST be a sequence of
					// AV_PAIRs and terminated by the null AV_PAIR when the
					// TargetInfoLen is non-zero, so this is in violation.
					zeek_analyzer()->AnalyzerViolation("NTLM AV Pair loop underflow");

				return result;
				}

			switch ( (*(val->pairs()))[i]->id() )
				{
				case 0:
					return result;
				case 1:
					result->Assign(0, utf16_to_utf8_val(zeek_analyzer()->Conn(), (*(val->pairs()))[i]->nb_computer_name()->data()));
					break;
				case 2:
					result->Assign(1, utf16_to_utf8_val(zeek_analyzer()->Conn(), (*(val->pairs()))[i]->nb_domain_name()->data()));
					break;
				case 3:
					result->Assign(2, utf16_to_utf8_val(zeek_analyzer()->Conn(), (*(val->pairs()))[i]->dns_computer_name()->data()));
					break;
				case 4:
					result->Assign(3, utf16_to_utf8_val(zeek_analyzer()->Conn(), (*(val->pairs()))[i]->dns_domain_name()->data()));
					break;
				case 5:
					result->Assign(4, utf16_to_utf8_val(zeek_analyzer()->Conn(), (*(val->pairs()))[i]->dns_tree_name()->data()));
					break;
				case 6:
					result->Assign(5, (*(val->pairs()))[i]->constrained_auth());
					break;
				case 7:
					result->Assign(6, filetime2zeektime((*(val->pairs()))[i]->timestamp()));
					break;
				case 8:
					result->Assign(7, (*(val->pairs()))[i]->single_host()->machine_id());
					break;
				case 9:
					result->Assign(8, utf16_to_utf8_val(zeek_analyzer()->Conn(), (*(val->pairs()))[i]->target_name()->data()));
					break;
				}
			}
		return result;
		
}

bool NTLM_Conn::proc_ntlm_negotiate(NTLM_Negotiate* val) {

		if ( ! ntlm_negotiate )
			return true;

		auto result = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::NTLM::Negotiate);
		result->Assign(0, build_negotiate_flag_record(val->flags()));

		if ( val->has_domain_name() )
		        result->Assign(1, utf16_to_utf8_val(zeek_analyzer()->Conn(), val->domain_name()->string()->data()));

		if ( val->has_workstation() )
		        result->Assign(2, utf16_to_utf8_val(zeek_analyzer()->Conn(), val->workstation()->string()->data()));

		if ( val->has_version() )
		        result->Assign(3, build_version_record(val->version()));

		zeek::BifEvent::enqueue_ntlm_negotiate(zeek_analyzer(),
		                                 zeek_analyzer()->Conn(),
		                                 std::move(result));

		return true;
		
}

bool NTLM_Conn::proc_ntlm_challenge(NTLM_Challenge* val) {

		if ( ! ntlm_challenge )
			return true;

		auto result = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::NTLM::Challenge);
		result->Assign(0, build_negotiate_flag_record(val->flags()));
		result->Assign(1, val->challenge());

		if ( val->has_target_name() )
			result->Assign(2, utf16_to_utf8_val(zeek_analyzer()->Conn(), val->target_name()->string()->data()));

		if ( val->has_version() )
			result->Assign(3, build_version_record(val->version()));

		if ( val->has_target_info() )
			result->Assign(4, {zeek::AdoptRef{}, build_av_record(val->target_info(),  val->target_info_fields()->length())});

		zeek::BifEvent::enqueue_ntlm_challenge(zeek_analyzer(),
		                                 zeek_analyzer()->Conn(),
		                                 std::move(result));

		return true;
		
}

bool NTLM_Conn::proc_ntlm_authenticate(NTLM_Authenticate* val) {

		if ( ! ntlm_authenticate )
			return true;

		auto result = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::NTLM::Authenticate);
		result->Assign(0, build_negotiate_flag_record(val->flags()));

		if ( val->has_domain_name() )
			result->Assign(1, utf16_to_utf8_val(zeek_analyzer()->Conn(), val->domain_name()->string()->data()));

		if ( val->has_user_name() )
			result->Assign(2, utf16_to_utf8_val(zeek_analyzer()->Conn(), val->user_name()->string()->data()));

		if ( val->has_workstation() )
			result->Assign(3, utf16_to_utf8_val(zeek_analyzer()->Conn(), val->workstation()->string()->data()));

		if ( val->has_encrypted_session_key() )
			result->Assign(4, to_stringval(val->encrypted_session_key()->string()->data()));

		if ( val->has_version() )
			result->Assign(5, build_version_record(val->version()));

		if ( val->has_response() )
			result->Assign(6, to_stringval(val->response()->string()->data()));

		zeek::BifEvent::enqueue_ntlm_authenticate(zeek_analyzer(),
		                                    zeek_analyzer()->Conn(),
		                                    std::move(result));
		return true;
		
}

uint32 min(uint32 v1, uint32 v2) {

	return v1 < v2 ? v1 : v2;
	
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_SSP_Token::NTLM_SSP_Token(bool is_orig) {
    msg_type_ = 0;
    msg_case_index_ = -1;
    negotiate_ = nullptr;
    challenge_ = nullptr;
    authenticate_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_SSP_Token::~NTLM_SSP_Token() {
    signature_.free();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_case_index() ) {
        case ((uint32)1):
            // Clean up "negotiate"
            {
                delete negotiate_;
                negotiate_ = nullptr;
            }
            break;
        case ((uint32)2):
            // Clean up "challenge"
            {
                delete challenge_;
                challenge_ = nullptr;
            }
            break;
        case ((uint32)3):
            // Clean up "authenticate"
            {
                delete authenticate_;
                authenticate_ = nullptr;
            }
            break;
        default:
            // Clean up "def"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int NTLM_SSP_Token::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextNTLM* t_context) {
    // Parse "signature"
    // Checking out-of-bound for "NTLM_SSP_Token:signature"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLM_SSP_Token:signature",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 8;
        int t_signature_string_length;
        t_signature_string_length = 8;
        int t_signature__size;
        t_signature__size = t_signature_string_length;
        signature_.init(t_begin_of_data, t_signature_string_length);
    }

    const_byteptr const t_dataptr_after_signature = t_begin_of_data + (8);
    BINPAC_ASSERT(t_dataptr_after_signature <= t_end_of_data);
    // Checking out-of-bound for "NTLM_SSP_Token:msg_type"
    if ( t_dataptr_after_signature + (4) > t_end_of_data || t_dataptr_after_signature + (4) < t_dataptr_after_signature ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLM_SSP_Token:msg_type",
        	((t_dataptr_after_signature - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "msg_type"
    msg_type_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_dataptr_after_signature)));

    // Parse "msg"
    int t_msg__size;
    msg_case_index_ = msg_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_case_index() ) {
        case ((uint32)1):
            // Parse "negotiate"
            {
                negotiate_ = new NTLM_Negotiate(((t_dataptr_after_signature + 4) - t_begin_of_data) - 0);
                int t_negotiate__size;
                t_negotiate__size = negotiate_->Parse((t_dataptr_after_signature + 4), t_end_of_data, t_context, byteorder());
                t_msg__size = t_negotiate__size;
            }
            break;
        case ((uint32)2):
            // Parse "challenge"
            {
                challenge_ = new NTLM_Challenge(((t_dataptr_after_signature + 4) - t_begin_of_data) - 0);
                int t_challenge__size;
                t_challenge__size = challenge_->Parse((t_dataptr_after_signature + 4), t_end_of_data, t_context, byteorder());
                t_msg__size = t_challenge__size;
            }
            break;
        case ((uint32)3):
            // Parse "authenticate"
            {
                authenticate_ = new NTLM_Authenticate(((t_dataptr_after_signature + 4) - t_begin_of_data) - 0);
                int t_authenticate__size;
                t_authenticate__size = authenticate_->Parse((t_dataptr_after_signature + 4), t_end_of_data, t_context, byteorder());
                t_msg__size = t_authenticate__size;
            }
            break;
        default:
            // Parse "def"
            {
                int t_def_string_length;
                t_def_string_length = (t_end_of_data) - ((t_dataptr_after_signature + 4));
                int t_def__size;
                t_def__size = t_def_string_length;
                // check for negative sizes
                if ( t_def_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:14", t_def_string_length);
                def_.init((t_dataptr_after_signature + 4), t_def_string_length);
                t_msg__size = t_def__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_NTLM_SSP_Token__size;
    const_byteptr const t_dataptr_after_msg = (t_dataptr_after_signature + 4) + (t_msg__size);
    BINPAC_ASSERT(t_dataptr_after_msg <= t_end_of_data);
    t_NTLM_SSP_Token__size = t_dataptr_after_msg - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_NTLM_SSP_Token__size) <= t_end_of_data);
    return t_NTLM_SSP_Token__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Negotiate::NTLM_Negotiate(uint16 offset) {
    flags_ = nullptr;
    domain_name_fields_ = nullptr;
    workstation_fields_ = nullptr;
    offset_ = offset;
    absolute_offset_ = 0;
    version_ = nullptr;
    has_version_ = false;
    domain_name_ = nullptr;
    has_domain_name_ = false;
    workstation_ = nullptr;
    has_workstation_ = false;
    proc_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Negotiate::~NTLM_Negotiate() {
    delete flags_;
    flags_ = nullptr;
    delete domain_name_fields_;
    domain_name_fields_ = nullptr;
    delete workstation_fields_;
    workstation_fields_ = nullptr;
    payload_.free();
    delete version_;
    version_ = nullptr;
    delete domain_name_;
    domain_name_ = nullptr;
    delete workstation_;
    workstation_ = nullptr;
}

int NTLM_Negotiate::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextNTLM* t_context, int t_byteorder) {
    // Checking out-of-bound for "NTLM_Negotiate:workstation_fields"
    if ( (t_begin_of_data + 12) + (8) > t_end_of_data || (t_begin_of_data + 12) + (8) < (t_begin_of_data + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLM_Negotiate:workstation_fields",
        	(12) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flags"
    flags_ = new NTLM_Negotiate_Flags();
    flags_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    // Parse "domain_name_fields"
    domain_name_fields_ = new NTLM_StringData();
    domain_name_fields_->Parse((t_begin_of_data + 4), t_end_of_data, t_byteorder);

    // Parse "workstation_fields"
    workstation_fields_ = new NTLM_StringData();
    workstation_fields_->Parse((t_begin_of_data + 12), t_end_of_data, t_byteorder);

    // Parse "payload"
    int t_payload_string_length;
    t_payload_string_length = (t_end_of_data) - ((t_begin_of_data + 20));
    int t_payload__size;
    t_payload__size = t_payload_string_length;
    // check for negative sizes
    if ( t_payload_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:22", t_payload_string_length);
    payload_.init((t_begin_of_data + 20), t_payload_string_length);

    int t_NTLM_Negotiate__size;
    const_byteptr const t_dataptr_after_payload = (t_begin_of_data + 20) + (t_payload__size);
    BINPAC_ASSERT(t_dataptr_after_payload <= t_end_of_data);
    t_NTLM_Negotiate__size = t_dataptr_after_payload - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    absolute_offset_ = 20 + offset();
    // Parse "version"
    has_version_ =  ( flags()->negotiate_version() &&  ( absolute_offset() < min(domain_name_fields()->offset(), workstation_fields()->offset()) )  ) ;
    if ( has_version() ) {
        version_ = new NTLM_Version();
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(payload(), &t_begin_of_data, &t_end_of_data);
        version_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
        // Evaluate 'let' and 'withinput' fields
    }
    // Parse "domain_name"
    has_domain_name_ =  ( flags()->negotiate_oem_domain_supplied() ) ;
    if ( has_domain_name() ) {
        domain_name_ = new NTLM_String(domain_name_fields(), absolute_offset(), flags()->negotiate_unicode());
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(payload(), &t_begin_of_data, &t_end_of_data);
        int t_domain_name__size;
        t_domain_name__size = domain_name_->Parse(t_begin_of_data, t_end_of_data);
        // Evaluate 'let' and 'withinput' fields
    }
    // Parse "workstation"
    has_workstation_ =  ( flags()->negotiate_oem_workstation_supplied() ) ;
    if ( has_workstation() ) {
        workstation_ = new NTLM_String(workstation_fields(), absolute_offset(), flags()->negotiate_unicode());
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(payload(), &t_begin_of_data, &t_end_of_data);
        int t_workstation__size;
        t_workstation__size = workstation_->Parse(t_begin_of_data, t_end_of_data);
        // Evaluate 'let' and 'withinput' fields
    }
    proc_ = t_context->connection()->proc_ntlm_negotiate(this);
    BINPAC_ASSERT(t_begin_of_data + (t_NTLM_Negotiate__size) <= t_end_of_data);
    return t_NTLM_Negotiate__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Challenge::NTLM_Challenge(uint16 offset) {
    target_name_fields_ = nullptr;
    flags_ = nullptr;
    challenge_ = 0;
    target_info_fields_ = nullptr;
    offset_ = offset;
    absolute_offset_ = 0;
    version_ = nullptr;
    has_version_ = false;
    target_name_ = nullptr;
    has_target_name_ = false;
    target_info_ = nullptr;
    has_target_info_ = false;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Challenge::~NTLM_Challenge() {
    delete target_name_fields_;
    target_name_fields_ = nullptr;
    delete flags_;
    flags_ = nullptr;
    delete target_info_fields_;
    target_info_fields_ = nullptr;
    payload_.free();
    delete version_;
    version_ = nullptr;
    delete target_name_;
    target_name_ = nullptr;
    delete target_info_;
    target_info_ = nullptr;
}

int NTLM_Challenge::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextNTLM* t_context, int t_byteorder) {
    // Checking out-of-bound for "NTLM_Challenge:target_info_fields"
    if ( (t_begin_of_data + 28) + (8) > t_end_of_data || (t_begin_of_data + 28) + (8) < (t_begin_of_data + 28) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLM_Challenge:target_info_fields",
        	(28) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "target_name_fields"
    target_name_fields_ = new NTLM_StringData();
    target_name_fields_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    // Parse "flags"
    flags_ = new NTLM_Negotiate_Flags();
    flags_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

    // Parse "challenge"
    challenge_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 12))));


    // Parse "target_info_fields"
    target_info_fields_ = new NTLM_StringData();
    target_info_fields_->Parse((t_begin_of_data + 28), t_end_of_data, t_byteorder);

    // Parse "payload"
    int t_payload_string_length;
    t_payload_string_length = (t_end_of_data) - ((t_begin_of_data + 36));
    int t_payload__size;
    t_payload__size = t_payload_string_length;
    // check for negative sizes
    if ( t_payload_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:36", t_payload_string_length);
    payload_.init((t_begin_of_data + 36), t_payload_string_length);

    int t_NTLM_Challenge__size;
    const_byteptr const t_dataptr_after_payload = (t_begin_of_data + 36) + (t_payload__size);
    BINPAC_ASSERT(t_dataptr_after_payload <= t_end_of_data);
    t_NTLM_Challenge__size = t_dataptr_after_payload - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    absolute_offset_ = 36 + offset();
    // Parse "version"
    has_version_ =  ( flags()->negotiate_version() &&  ( absolute_offset() < min(target_name_fields()->offset(), target_info_fields()->offset()) )  ) ;
    if ( has_version() ) {
        version_ = new NTLM_Version();
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(payload(), &t_begin_of_data, &t_end_of_data);
        version_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
        // Evaluate 'let' and 'withinput' fields
    }
    // Parse "target_name"
    has_target_name_ =  ( flags()->request_target() ) ;
    if ( has_target_name() ) {
        target_name_ = new NTLM_String(target_name_fields(), absolute_offset(), flags()->negotiate_unicode());
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(payload(), &t_begin_of_data, &t_end_of_data);
        int t_target_name__size;
        t_target_name__size = target_name_->Parse(t_begin_of_data, t_end_of_data);
        // Evaluate 'let' and 'withinput' fields
    }
    // Parse "target_info"
    has_target_info_ =  ( flags()->negotiate_target_info() ) ;
    if ( has_target_info() ) {
        target_info_ = new NTLM_AV_Pair_Sequence(target_info_fields()->offset() - absolute_offset());
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(payload(), &t_begin_of_data, &t_end_of_data);
        int t_target_info__size;
        t_target_info__size = target_info_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
        // Evaluate 'let' and 'withinput' fields
    }
    proc_ = t_context->connection()->proc_ntlm_challenge(this);
    BINPAC_ASSERT(t_begin_of_data + (t_NTLM_Challenge__size) <= t_end_of_data);
    return t_NTLM_Challenge__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Authenticate::NTLM_Authenticate(uint16 offset) {
    lm_challenge_response_fields_ = nullptr;
    nt_challenge_response_fields_ = nullptr;
    domain_name_fields_ = nullptr;
    user_name_fields_ = nullptr;
    workstation_fields_ = nullptr;
    encrypted_session_key_fields_ = nullptr;
    flags_ = nullptr;
    offset_ = offset;
    absolute_offset_ = 0;
    version_ = nullptr;
    has_version_ = false;
    response_ = nullptr;
    has_response_ = false;
    domain_name_ = nullptr;
    has_domain_name_ = false;
    user_name_ = nullptr;
    has_user_name_ = false;
    workstation_ = nullptr;
    has_workstation_ = false;
    encrypted_session_key_ = nullptr;
    has_encrypted_session_key_ = false;
    proc_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Authenticate::~NTLM_Authenticate() {
    delete lm_challenge_response_fields_;
    lm_challenge_response_fields_ = nullptr;
    delete nt_challenge_response_fields_;
    nt_challenge_response_fields_ = nullptr;
    delete domain_name_fields_;
    domain_name_fields_ = nullptr;
    delete user_name_fields_;
    user_name_fields_ = nullptr;
    delete workstation_fields_;
    workstation_fields_ = nullptr;
    delete encrypted_session_key_fields_;
    encrypted_session_key_fields_ = nullptr;
    delete flags_;
    flags_ = nullptr;
    payload_.free();
    delete version_;
    version_ = nullptr;
    delete response_;
    response_ = nullptr;
    delete domain_name_;
    domain_name_ = nullptr;
    delete user_name_;
    user_name_ = nullptr;
    delete workstation_;
    workstation_ = nullptr;
    delete encrypted_session_key_;
    encrypted_session_key_ = nullptr;
}

int NTLM_Authenticate::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextNTLM* t_context, int t_byteorder) {
    // Checking out-of-bound for "NTLM_Authenticate:flags"
    if ( (t_begin_of_data + 48) + (4) > t_end_of_data || (t_begin_of_data + 48) + (4) < (t_begin_of_data + 48) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLM_Authenticate:flags",
        	(48) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "lm_challenge_response_fields"
    lm_challenge_response_fields_ = new NTLM_StringData();
    lm_challenge_response_fields_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    // Parse "nt_challenge_response_fields"
    nt_challenge_response_fields_ = new NTLM_StringData();
    nt_challenge_response_fields_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

    // Parse "domain_name_fields"
    domain_name_fields_ = new NTLM_StringData();
    domain_name_fields_->Parse((t_begin_of_data + 16), t_end_of_data, t_byteorder);

    // Parse "user_name_fields"
    user_name_fields_ = new NTLM_StringData();
    user_name_fields_->Parse((t_begin_of_data + 24), t_end_of_data, t_byteorder);

    // Parse "workstation_fields"
    workstation_fields_ = new NTLM_StringData();
    workstation_fields_->Parse((t_begin_of_data + 32), t_end_of_data, t_byteorder);

    // Parse "encrypted_session_key_fields"
    encrypted_session_key_fields_ = new NTLM_StringData();
    encrypted_session_key_fields_->Parse((t_begin_of_data + 40), t_end_of_data, t_byteorder);

    // Parse "flags"
    flags_ = new NTLM_Negotiate_Flags();
    flags_->Parse((t_begin_of_data + 48), t_end_of_data, t_byteorder);

    // Parse "payload"
    int t_payload_string_length;
    t_payload_string_length = (t_end_of_data) - ((t_begin_of_data + 52));
    int t_payload__size;
    t_payload__size = t_payload_string_length;
    // check for negative sizes
    if ( t_payload_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:57", t_payload_string_length);
    payload_.init((t_begin_of_data + 52), t_payload_string_length);

    int t_NTLM_Authenticate__size;
    const_byteptr const t_dataptr_after_payload = (t_begin_of_data + 52) + (t_payload__size);
    BINPAC_ASSERT(t_dataptr_after_payload <= t_end_of_data);
    t_NTLM_Authenticate__size = t_dataptr_after_payload - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    absolute_offset_ = 52 + offset();
    // Parse "version"
    has_version_ =  ( flags()->negotiate_version() &&  ( absolute_offset() < min(min(min(domain_name_fields()->offset(), user_name_fields()->offset()), workstation_fields()->offset()), encrypted_session_key_fields()->offset()) )  ) ;
    if ( has_version() ) {
        version_ = new NTLM_Version();
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(payload(), &t_begin_of_data, &t_end_of_data);
        version_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
        // Evaluate 'let' and 'withinput' fields
    }
    // Parse "response"
    has_response_ =  ( nt_challenge_response_fields()->length() > 0 ) ;
    if ( has_response() ) {
        response_ = new NTLM_String(nt_challenge_response_fields(), absolute_offset(), flags()->negotiate_unicode());
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(payload(), &t_begin_of_data, &t_end_of_data);
        int t_response__size;
        t_response__size = response_->Parse(t_begin_of_data, t_end_of_data);
        // Evaluate 'let' and 'withinput' fields
    }
    // Parse "domain_name"
    has_domain_name_ =  ( domain_name_fields()->length() > 0 ) ;
    if ( has_domain_name() ) {
        domain_name_ = new NTLM_String(domain_name_fields(), absolute_offset(), flags()->negotiate_unicode());
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(payload(), &t_begin_of_data, &t_end_of_data);
        int t_domain_name__size;
        t_domain_name__size = domain_name_->Parse(t_begin_of_data, t_end_of_data);
        // Evaluate 'let' and 'withinput' fields
    }
    // Parse "user_name"
    has_user_name_ =  ( user_name_fields()->length() > 0 ) ;
    if ( has_user_name() ) {
        user_name_ = new NTLM_String(user_name_fields(), absolute_offset(), flags()->negotiate_unicode());
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(payload(), &t_begin_of_data, &t_end_of_data);
        int t_user_name__size;
        t_user_name__size = user_name_->Parse(t_begin_of_data, t_end_of_data);
        // Evaluate 'let' and 'withinput' fields
    }
    // Parse "workstation"
    has_workstation_ =  ( workstation_fields()->length() > 0 ) ;
    if ( has_workstation() ) {
        workstation_ = new NTLM_String(workstation_fields(), absolute_offset(), flags()->negotiate_unicode());
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(payload(), &t_begin_of_data, &t_end_of_data);
        int t_workstation__size;
        t_workstation__size = workstation_->Parse(t_begin_of_data, t_end_of_data);
        // Evaluate 'let' and 'withinput' fields
    }
    // Parse "encrypted_session_key"
    has_encrypted_session_key_ =  ( encrypted_session_key_fields()->length() > 0 ) ;
    if ( has_encrypted_session_key() ) {
        encrypted_session_key_ = new NTLM_String(encrypted_session_key_fields(), absolute_offset(), flags()->negotiate_unicode());
        const_byteptr t_begin_of_data;
        const_byteptr t_end_of_data;
        get_pointers(payload(), &t_begin_of_data, &t_end_of_data);
        int t_encrypted_session_key__size;
        t_encrypted_session_key__size = encrypted_session_key_->Parse(t_begin_of_data, t_end_of_data);
        // Evaluate 'let' and 'withinput' fields
    }
    proc_ = t_context->connection()->proc_ntlm_authenticate(this);
    BINPAC_ASSERT(t_begin_of_data + (t_NTLM_Authenticate__size) <= t_end_of_data);
    return t_NTLM_Authenticate__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Version::NTLM_Version() {
    major_version_ = 0;
    minor_version_ = 0;
    build_number_ = 0;
    ntlm_revision_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Version::~NTLM_Version() {
}

int NTLM_Version::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "NTLM_Version"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLM_Version",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "major_version"
    major_version_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "minor_version"
    minor_version_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "build_number"
    build_number_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));


    // Parse "ntlm_revision"
    ntlm_revision_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 7)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_StringData::NTLM_StringData() {
    length_ = 0;
    max_length_ = 0;
    offset_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_StringData::~NTLM_StringData() {
}

int NTLM_StringData::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "NTLM_StringData"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLM_StringData",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "max_length"
    max_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "offset"
    offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Fixed_Length_String::Fixed_Length_String(bool unicode) {
    unicode_ = unicode;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Fixed_Length_String::~Fixed_Length_String() {
    data_.free();
}

int Fixed_Length_String::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:83", t_data_string_length);
    data_.init(t_begin_of_data, t_data_string_length);

    int t_Fixed_Length_String__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Fixed_Length_String__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Fixed_Length_String__size) <= t_end_of_data);
    return t_Fixed_Length_String__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_String::NTLM_String(NTLM_StringData* fields, uint16 offset, bool unicode) {
    string_ = nullptr;
    fields_ = fields;
    offset_ = offset;
    unicode_ = unicode;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_String::~NTLM_String() {
    delete string_;
    string_ = nullptr;
}

int NTLM_String::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {

    const_byteptr t_dataptr_after_pad1 = t_begin_of_data + (fields()->offset() - offset());
    if ( t_dataptr_after_pad1 < t_begin_of_data ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:87:pad1", t_begin_of_data - t_begin_of_data, fields()->offset() - offset());
        t_dataptr_after_pad1 = t_begin_of_data;
    }
    if ( t_dataptr_after_pad1 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("NTLM_String:pad1",
        	(fields()->offset() - offset()), 
        	(t_end_of_data) - (t_dataptr_after_pad1));
    }
    // Parse "string"
    string_ = new Fixed_Length_String(unicode());
    int t_string__size;
    t_string__size = fields()->length();
    // Checking out-of-bound for "NTLM_String:string"
    if ( t_dataptr_after_pad1 + (t_string__size) > t_end_of_data || t_dataptr_after_pad1 + (t_string__size) < t_dataptr_after_pad1 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLM_String:string",
        	((t_dataptr_after_pad1 - t_begin_of_data)) + (t_string__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad1 + t_string__size;
        string_->Parse(t_dataptr_after_pad1, t_end_of_data);
    }

    int t_NTLM_String__size;
    const_byteptr const t_dataptr_after_string = t_dataptr_after_pad1 + (t_string__size);
    BINPAC_ASSERT(t_dataptr_after_string <= t_end_of_data);
    t_NTLM_String__size = t_dataptr_after_string - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_NTLM_String__size) <= t_end_of_data);
    return t_NTLM_String__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_AV_Pair_Sequence::NTLM_AV_Pair_Sequence(uint16 offset) {
    pairs_ = nullptr;
    pairs__elem_ = nullptr;
    offset_ = offset;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_AV_Pair_Sequence::~NTLM_AV_Pair_Sequence() {
    delete pairs__elem_;
    pairs__elem_ = nullptr;
    if ( pairs() ) {
        for ( auto* pairs__elem_ : *pairs() ) {
            delete pairs__elem_;
            pairs__elem_ = nullptr;
        }
    }
    delete pairs_;
}

int NTLM_AV_Pair_Sequence::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {

    const_byteptr t_dataptr_after_pad1 = t_begin_of_data + (offset());
    if ( t_dataptr_after_pad1 < t_begin_of_data ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:92:pad1", t_begin_of_data - t_begin_of_data, offset());
        t_dataptr_after_pad1 = t_begin_of_data;
    }
    if ( t_dataptr_after_pad1 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("NTLM_AV_Pair_Sequence:pad1",
        	(offset()), 
        	(t_end_of_data) - (t_dataptr_after_pad1));
    }
    // Parse "pairs"
    int t_pairs__arraylength;
    t_pairs__arraylength = 0;
    pairs__elem_ = nullptr;
    int t_pairs__elem__it;
    t_pairs__elem__it = 0;
    int t_pairs__size;
    pairs_ = new vector<NTLM_AV_Pair*>;
    const_byteptr t_pairs__elem__dataptr = t_dataptr_after_pad1;
    for (; /* forever */; ++t_pairs__elem__it) {
        // Check &until(pairs__elem__dataptr >= end_of_data)
        if ( t_pairs__elem__dataptr >= t_end_of_data ) {
            pairs__elem_ = nullptr;
            goto end_of_pairs;
        }
        pairs__elem_ = new NTLM_AV_Pair();
        int t_pairs__elem__size;
        t_pairs__elem__size = pairs__elem_->Parse(t_pairs__elem__dataptr, t_end_of_data, t_byteorder);
        pairs_->push_back(pairs__elem_);
        t_pairs__elem__dataptr += t_pairs__elem__size;
        BINPAC_ASSERT(t_pairs__elem__dataptr <= t_end_of_data);
        // Check &until( ( @$element->last@ ) )
        if (  ( pairs__elem_->last() )  ) {
            pairs__elem_ = nullptr;
            goto end_of_pairs;
        }
        pairs__elem_ = nullptr;
    }
end_of_pairs: ;
    t_pairs__size = t_pairs__elem__dataptr - (t_dataptr_after_pad1);
    // Evaluate 'let' and 'withinput' fields

    int t_NTLM_AV_Pair_Sequence__size;
    const_byteptr const t_dataptr_after_pairs = t_dataptr_after_pad1 + (t_pairs__size);
    BINPAC_ASSERT(t_dataptr_after_pairs <= t_end_of_data);
    t_NTLM_AV_Pair_Sequence__size = t_dataptr_after_pairs - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_NTLM_AV_Pair_Sequence__size) <= t_end_of_data);
    return t_NTLM_AV_Pair_Sequence__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_AV_Pair::NTLM_AV_Pair() {
    id_ = 0;
    length_ = 0;
    value_case_case_index_ = -1;
    nb_computer_name_ = nullptr;
    nb_domain_name_ = nullptr;
    dns_computer_name_ = nullptr;
    dns_domain_name_ = nullptr;
    dns_tree_name_ = nullptr;
    av_flags_ = 0;
    timestamp_ = 0;
    single_host_ = nullptr;
    target_name_ = nullptr;
    channel_bindings_ = 0;
    last_ = false;
    constrained_auth_ = false;
    has_constrained_auth_ = false;
    mic_present_ = false;
    has_mic_present_ = false;
    untrusted_source_ = false;
    has_untrusted_source_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_AV_Pair::~NTLM_AV_Pair() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( value_case_case_index() ) {
        case ((uint16)0):
            // Clean up "av_eol"
            {
            }
            break;
        case ((uint16)1):
            // Clean up "nb_computer_name"
            {
                delete nb_computer_name_;
                nb_computer_name_ = nullptr;
            }
            break;
        case ((uint16)2):
            // Clean up "nb_domain_name"
            {
                delete nb_domain_name_;
                nb_domain_name_ = nullptr;
            }
            break;
        case ((uint16)3):
            // Clean up "dns_computer_name"
            {
                delete dns_computer_name_;
                dns_computer_name_ = nullptr;
            }
            break;
        case ((uint16)4):
            // Clean up "dns_domain_name"
            {
                delete dns_domain_name_;
                dns_domain_name_ = nullptr;
            }
            break;
        case ((uint16)5):
            // Clean up "dns_tree_name"
            {
                delete dns_tree_name_;
                dns_tree_name_ = nullptr;
            }
            break;
        case ((uint16)6):
            // Clean up "av_flags"
            {
            }
            break;
        case ((uint16)7):
            // Clean up "timestamp"
            {
            }
            break;
        case ((uint16)8):
            // Clean up "single_host"
            {
                delete single_host_;
                single_host_ = nullptr;
            }
            break;
        case ((uint16)9):
            // Clean up "target_name"
            {
                delete target_name_;
                target_name_ = nullptr;
            }
            break;
        case ((uint16)10):
            // Clean up "channel_bindings"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int NTLM_AV_Pair::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "NTLM_AV_Pair:length"
    if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLM_AV_Pair:length",
        	(2) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "id"
    id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "value_case"
    int t_value_case__size;
    value_case_case_index_ = id();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( value_case_case_index() ) {
        case ((uint16)0):
            // Parse "av_eol"
            {
                t_value_case__size = 0;
            }
            break;
        case ((uint16)1):
            // Parse "nb_computer_name"
            {
                nb_computer_name_ = new Fixed_Length_String(true);
                int t_nb_computer_name__size;
                t_nb_computer_name__size = length();
                // Checking out-of-bound for "NTLM_AV_Pair:nb_computer_name"
                if ( (t_begin_of_data + 4) + (t_nb_computer_name__size) > t_end_of_data || (t_begin_of_data + 4) + (t_nb_computer_name__size) < (t_begin_of_data + 4) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("NTLM_AV_Pair:nb_computer_name",
                    	(4) + (t_nb_computer_name__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_nb_computer_name__size;
                    nb_computer_name_->Parse((t_begin_of_data + 4), t_end_of_data);
                }
                t_value_case__size = t_nb_computer_name__size;
            }
            break;
        case ((uint16)2):
            // Parse "nb_domain_name"
            {
                nb_domain_name_ = new Fixed_Length_String(true);
                int t_nb_domain_name__size;
                t_nb_domain_name__size = length();
                // Checking out-of-bound for "NTLM_AV_Pair:nb_domain_name"
                if ( (t_begin_of_data + 4) + (t_nb_domain_name__size) > t_end_of_data || (t_begin_of_data + 4) + (t_nb_domain_name__size) < (t_begin_of_data + 4) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("NTLM_AV_Pair:nb_domain_name",
                    	(4) + (t_nb_domain_name__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_nb_domain_name__size;
                    nb_domain_name_->Parse((t_begin_of_data + 4), t_end_of_data);
                }
                t_value_case__size = t_nb_domain_name__size;
            }
            break;
        case ((uint16)3):
            // Parse "dns_computer_name"
            {
                dns_computer_name_ = new Fixed_Length_String(true);
                int t_dns_computer_name__size;
                t_dns_computer_name__size = length();
                // Checking out-of-bound for "NTLM_AV_Pair:dns_computer_name"
                if ( (t_begin_of_data + 4) + (t_dns_computer_name__size) > t_end_of_data || (t_begin_of_data + 4) + (t_dns_computer_name__size) < (t_begin_of_data + 4) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("NTLM_AV_Pair:dns_computer_name",
                    	(4) + (t_dns_computer_name__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_dns_computer_name__size;
                    dns_computer_name_->Parse((t_begin_of_data + 4), t_end_of_data);
                }
                t_value_case__size = t_dns_computer_name__size;
            }
            break;
        case ((uint16)4):
            // Parse "dns_domain_name"
            {
                dns_domain_name_ = new Fixed_Length_String(true);
                int t_dns_domain_name__size;
                t_dns_domain_name__size = length();
                // Checking out-of-bound for "NTLM_AV_Pair:dns_domain_name"
                if ( (t_begin_of_data + 4) + (t_dns_domain_name__size) > t_end_of_data || (t_begin_of_data + 4) + (t_dns_domain_name__size) < (t_begin_of_data + 4) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("NTLM_AV_Pair:dns_domain_name",
                    	(4) + (t_dns_domain_name__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_dns_domain_name__size;
                    dns_domain_name_->Parse((t_begin_of_data + 4), t_end_of_data);
                }
                t_value_case__size = t_dns_domain_name__size;
            }
            break;
        case ((uint16)5):
            // Parse "dns_tree_name"
            {
                dns_tree_name_ = new Fixed_Length_String(true);
                int t_dns_tree_name__size;
                t_dns_tree_name__size = length();
                // Checking out-of-bound for "NTLM_AV_Pair:dns_tree_name"
                if ( (t_begin_of_data + 4) + (t_dns_tree_name__size) > t_end_of_data || (t_begin_of_data + 4) + (t_dns_tree_name__size) < (t_begin_of_data + 4) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("NTLM_AV_Pair:dns_tree_name",
                    	(4) + (t_dns_tree_name__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_dns_tree_name__size;
                    dns_tree_name_->Parse((t_begin_of_data + 4), t_end_of_data);
                }
                t_value_case__size = t_dns_tree_name__size;
            }
            break;
        case ((uint16)6):
            // Parse "av_flags"
            {
                // Checking out-of-bound for "NTLM_AV_Pair:av_flags"
                if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("NTLM_AV_Pair:av_flags",
                    	(4) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                av_flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));
                t_value_case__size = 4;
            }
            break;
        case ((uint16)7):
            // Parse "timestamp"
            {
                // Checking out-of-bound for "NTLM_AV_Pair:timestamp"
                if ( (t_begin_of_data + 4) + (8) > t_end_of_data || (t_begin_of_data + 4) + (8) < (t_begin_of_data + 4) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("NTLM_AV_Pair:timestamp",
                    	(4) + (8), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                timestamp_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 4))));
                t_value_case__size = 8;
            }
            break;
        case ((uint16)8):
            // Parse "single_host"
            {
                single_host_ = new NTLM_Single_Host();
                int t_single_host__size;
                t_single_host__size = single_host_->Parse((t_begin_of_data + 4), t_end_of_data, t_byteorder);
                t_value_case__size = t_single_host__size;
            }
            break;
        case ((uint16)9):
            // Parse "target_name"
            {
                target_name_ = new Fixed_Length_String(true);
                int t_target_name__size;
                t_target_name__size = length();
                // Checking out-of-bound for "NTLM_AV_Pair:target_name"
                if ( (t_begin_of_data + 4) + (t_target_name__size) > t_end_of_data || (t_begin_of_data + 4) + (t_target_name__size) < (t_begin_of_data + 4) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("NTLM_AV_Pair:target_name",
                    	(4) + (t_target_name__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_target_name__size;
                    target_name_->Parse((t_begin_of_data + 4), t_end_of_data);
                }
                t_value_case__size = t_target_name__size;
            }
            break;
        case ((uint16)10):
            // Parse "channel_bindings"
            {
                // Checking out-of-bound for "NTLM_AV_Pair:channel_bindings"
                if ( (t_begin_of_data + 4) + (2) > t_end_of_data || (t_begin_of_data + 4) + (2) < (t_begin_of_data + 4) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("NTLM_AV_Pair:channel_bindings",
                    	(4) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                channel_bindings_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));
                t_value_case__size = 2;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("NTLM_AV_Pair", (int64)value_case_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_NTLM_AV_Pair__size;
    const_byteptr const t_dataptr_after_value_case = (t_begin_of_data + 4) + (t_value_case__size);
    BINPAC_ASSERT(t_dataptr_after_value_case <= t_end_of_data);
    t_NTLM_AV_Pair__size = t_dataptr_after_value_case - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    last_ =  ( id() == 0x0000 ) ;
    has_constrained_auth_ =  ( id() == 0x0006 ) ;
    if ( has_constrained_auth() ) {
        constrained_auth_ =  ( av_flags() & 0x00000001 )  > 0;
    }
    has_mic_present_ =  ( id() == 0x0006 ) ;
    if ( has_mic_present() ) {
        mic_present_ =  ( av_flags() & 0x00000002 )  > 0;
    }
    has_untrusted_source_ =  ( id() == 0x0006 ) ;
    if ( has_untrusted_source() ) {
        untrusted_source_ =  ( av_flags() & 0x00000004 )  > 0;
    }
    BINPAC_ASSERT(t_begin_of_data + (t_NTLM_AV_Pair__size) <= t_end_of_data);
    return t_NTLM_AV_Pair__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Single_Host::NTLM_Single_Host() {
    size_ = 0;
    data_present_ = 0;
    optional_case_index_ = -1;
    machine_id_ = 0;
    custom_data_present_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Single_Host::~NTLM_Single_Host() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( optional_case_index() ) {
        case true:
            // Clean up "custom_data"
            {
                custom_data_.free();
            }
            break;
        case false:
            // Clean up "nothing"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int NTLM_Single_Host::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "NTLM_Single_Host:data_present"
    if ( (t_begin_of_data + 8) + (4) > t_end_of_data || (t_begin_of_data + 8) + (4) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLM_Single_Host:data_present",
        	(8) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "size"
    size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));


    // Parse "data_present"
    data_present_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "optional"
    int t_optional__size;
    custom_data_present_ =  ( data_present() & 0x00000001 )  > 0;
    optional_case_index_ = custom_data_present();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( optional_case_index() ) {
        case true:
            // Parse "custom_data"
            {
                // Checking out-of-bound for "NTLM_Single_Host:custom_data"
                if ( (t_begin_of_data + 12) + (4) > t_end_of_data || (t_begin_of_data + 12) + (4) < (t_begin_of_data + 12) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("NTLM_Single_Host:custom_data",
                    	(12) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 12) + 4;
                    int t_custom_data_string_length;
                    t_custom_data_string_length = 4;
                    int t_custom_data__size;
                    t_custom_data__size = t_custom_data_string_length;
                    custom_data_.init((t_begin_of_data + 12), t_custom_data_string_length);
                }
                t_optional__size = 4;
            }
            break;
        case false:
            // Parse "nothing"
            {
                t_optional__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("NTLM_Single_Host", (int64)optional_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_optional = (t_begin_of_data + 12) + (t_optional__size);
    BINPAC_ASSERT(t_dataptr_after_optional <= t_end_of_data);
    // Checking out-of-bound for "NTLM_Single_Host:machine_id"
    if ( t_dataptr_after_optional + (4) > t_end_of_data || t_dataptr_after_optional + (4) < t_dataptr_after_optional ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLM_Single_Host:machine_id",
        	((t_dataptr_after_optional - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "machine_id"
    machine_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_optional)));

    int t_NTLM_Single_Host__size;
    t_NTLM_Single_Host__size = (t_dataptr_after_optional + 4) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_NTLM_Single_Host__size) <= t_end_of_data);
    return t_NTLM_Single_Host__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
LM_Response::LM_Response(uint16 offset) {
    offset_ = offset;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
LM_Response::~LM_Response() {
    response_.free();
}

int LM_Response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {

    const_byteptr t_dataptr_after_padpad = t_begin_of_data + (offset());
    if ( t_dataptr_after_padpad < t_begin_of_data ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:137:padpad", t_begin_of_data - t_begin_of_data, offset());
        t_dataptr_after_padpad = t_begin_of_data;
    }
    if ( t_dataptr_after_padpad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("LM_Response:padpad",
        	(offset()), 
        	(t_end_of_data) - (t_dataptr_after_padpad));
    }
    // Parse "response"
    // Checking out-of-bound for "LM_Response:response"
    if ( t_dataptr_after_padpad + (24) > t_end_of_data || t_dataptr_after_padpad + (24) < t_dataptr_after_padpad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("LM_Response:response",
        	((t_dataptr_after_padpad - t_begin_of_data)) + (24), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_padpad + 24;
        int t_response_string_length;
        t_response_string_length = 24;
        int t_response__size;
        t_response__size = t_response_string_length;
        response_.init(t_dataptr_after_padpad, t_response_string_length);
    }

    int t_LM_Response__size;
    const_byteptr const t_dataptr_after_response = t_dataptr_after_padpad + (24);
    BINPAC_ASSERT(t_dataptr_after_response <= t_end_of_data);
    t_LM_Response__size = t_dataptr_after_response - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_LM_Response__size) <= t_end_of_data);
    return t_LM_Response__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Response::NTLM_Response(uint16 offset) {
    offset_ = offset;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Response::~NTLM_Response() {
    response_.free();
}

int NTLM_Response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {

    const_byteptr t_dataptr_after_padpad = t_begin_of_data + (offset());
    if ( t_dataptr_after_padpad < t_begin_of_data ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:142:padpad", t_begin_of_data - t_begin_of_data, offset());
        t_dataptr_after_padpad = t_begin_of_data;
    }
    if ( t_dataptr_after_padpad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("NTLM_Response:padpad",
        	(offset()), 
        	(t_end_of_data) - (t_dataptr_after_padpad));
    }
    // Parse "response"
    // Checking out-of-bound for "NTLM_Response:response"
    if ( t_dataptr_after_padpad + (24) > t_end_of_data || t_dataptr_after_padpad + (24) < t_dataptr_after_padpad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLM_Response:response",
        	((t_dataptr_after_padpad - t_begin_of_data)) + (24), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_padpad + 24;
        int t_response_string_length;
        t_response_string_length = 24;
        int t_response__size;
        t_response__size = t_response_string_length;
        response_.init(t_dataptr_after_padpad, t_response_string_length);
    }

    int t_NTLM_Response__size;
    const_byteptr const t_dataptr_after_response = t_dataptr_after_padpad + (24);
    BINPAC_ASSERT(t_dataptr_after_response <= t_end_of_data);
    t_NTLM_Response__size = t_dataptr_after_response - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_NTLM_Response__size) <= t_end_of_data);
    return t_NTLM_Response__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLMv2_Response::NTLMv2_Response(NTLM_Negotiate_Flags* flags, uint16 offset) {
    client_challenge_ = nullptr;
    flags_ = flags;
    offset_ = offset;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLMv2_Response::~NTLMv2_Response() {
    response_.free();
    delete client_challenge_;
    client_challenge_ = nullptr;
}

int NTLMv2_Response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {

    const_byteptr t_dataptr_after_padpad = t_begin_of_data + (offset());
    if ( t_dataptr_after_padpad < t_begin_of_data ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:147:padpad", t_begin_of_data - t_begin_of_data, offset());
        t_dataptr_after_padpad = t_begin_of_data;
    }
    if ( t_dataptr_after_padpad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("NTLMv2_Response:padpad",
        	(offset()), 
        	(t_end_of_data) - (t_dataptr_after_padpad));
    }
    // Parse "response"
    // Checking out-of-bound for "NTLMv2_Response:response"
    if ( t_dataptr_after_padpad + (16) > t_end_of_data || t_dataptr_after_padpad + (16) < t_dataptr_after_padpad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLMv2_Response:response",
        	((t_dataptr_after_padpad - t_begin_of_data)) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_padpad + 16;
        int t_response_string_length;
        t_response_string_length = 16;
        int t_response__size;
        t_response__size = t_response_string_length;
        response_.init(t_dataptr_after_padpad, t_response_string_length);
    }

    const_byteptr const t_dataptr_after_response = t_dataptr_after_padpad + (16);
    BINPAC_ASSERT(t_dataptr_after_response <= t_end_of_data);
    // Parse "client_challenge"
    client_challenge_ = new NTLMv2_Client_Challenge(flags());
    int t_client_challenge__size;
    t_client_challenge__size = client_challenge_->Parse(t_dataptr_after_response, t_end_of_data, t_byteorder);

    int t_NTLMv2_Response__size;
    const_byteptr const t_dataptr_after_client_challenge = t_dataptr_after_response + (t_client_challenge__size);
    BINPAC_ASSERT(t_dataptr_after_client_challenge <= t_end_of_data);
    t_NTLMv2_Response__size = t_dataptr_after_client_challenge - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_NTLMv2_Response__size) <= t_end_of_data);
    return t_NTLMv2_Response__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLMv2_Client_Challenge::NTLMv2_Client_Challenge(NTLM_Negotiate_Flags* flags) {
    resp_type_ = 0;
    max_resp_type_ = 0;
    timestamp_ = 0;
    av_pairs_ = nullptr;
    flags_ = flags;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLMv2_Client_Challenge::~NTLMv2_Client_Challenge() {
    client_challenge_.free();
    delete av_pairs_;
    av_pairs_ = nullptr;
}

int NTLMv2_Client_Challenge::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "NTLMv2_Client_Challenge:timestamp"
    if ( (t_begin_of_data + 8) + (8) > t_end_of_data || (t_begin_of_data + 8) + (8) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLMv2_Client_Challenge:timestamp",
        	(8) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "resp_type"
    resp_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "max_resp_type"
    max_resp_type_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));


    // Parse "timestamp"
    timestamp_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 8))));

    // Parse "client_challenge"
    // Checking out-of-bound for "NTLMv2_Client_Challenge:client_challenge"
    if ( (t_begin_of_data + 16) + (8) > t_end_of_data || (t_begin_of_data + 16) + (8) < (t_begin_of_data + 16) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLMv2_Client_Challenge:client_challenge",
        	(16) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 16) + 8;
        int t_client_challenge_string_length;
        t_client_challenge_string_length = 8;
        int t_client_challenge__size;
        t_client_challenge__size = t_client_challenge_string_length;
        client_challenge_.init((t_begin_of_data + 16), t_client_challenge_string_length);
    }


    const_byteptr const t_dataptr_after_client_challenge = (t_begin_of_data + 16) + (8);
    BINPAC_ASSERT(t_dataptr_after_client_challenge <= t_end_of_data);
    // Parse "av_pairs"
    av_pairs_ = new NTLM_AV_Pair_Sequence(0);
    int t_av_pairs__size;
    t_av_pairs__size = av_pairs_->Parse((t_dataptr_after_client_challenge + 4), t_end_of_data, t_byteorder);

    int t_NTLMv2_Client_Challenge__size;
    const_byteptr const t_dataptr_after_av_pairs = (t_dataptr_after_client_challenge + 4) + (t_av_pairs__size);
    BINPAC_ASSERT(t_dataptr_after_av_pairs <= t_end_of_data);
    t_NTLMv2_Client_Challenge__size = t_dataptr_after_av_pairs - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_NTLMv2_Client_Challenge__size) <= t_end_of_data);
    return t_NTLMv2_Client_Challenge__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Negotiate_Flags::NTLM_Negotiate_Flags() {
    flags_ = 0;
    negotiate_56_ = false;
    negotiate_key_exch_ = false;
    negotiate_128_ = false;
    negotiate_version_ = false;
    negotiate_target_info_ = false;
    request_non_nt_session_key_ = false;
    negotiate_identify_ = false;
    negotiate_extended_sessionsecurity_ = false;
    target_type_server_ = false;
    target_type_domain_ = false;
    negotiate_always_sign_ = false;
    negotiate_oem_workstation_supplied_ = false;
    negotiate_oem_domain_supplied_ = false;
    negotiate_anonymous_connection_ = false;
    negotiate_ntlm_ = false;
    negotiate_lm_key_ = false;
    negotiate_datagram_ = false;
    negotiate_seal_ = false;
    negotiate_sign_ = false;
    request_target_ = false;
    negotiate_oem_ = false;
    negotiate_unicode_ = false;
    is_oem_ = false;
    is_invalid_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Negotiate_Flags::~NTLM_Negotiate_Flags() {
}

int NTLM_Negotiate_Flags::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "NTLM_Negotiate_Flags"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("NTLM_Negotiate_Flags",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    negotiate_56_ =  ( flags() & 0x80000000 )  > 0;
    negotiate_key_exch_ =  ( flags() & 0x40000000 )  > 0;
    negotiate_128_ =  ( flags() & 0x20000000 )  > 0;
    negotiate_version_ =  ( flags() & 0x02000000 )  > 0;
    negotiate_target_info_ =  ( flags() & 0x00800000 )  > 0;
    request_non_nt_session_key_ =  ( flags() & 0x00400000 )  > 0;
    negotiate_identify_ =  ( flags() & 0x00100000 )  > 0;
    negotiate_extended_sessionsecurity_ =  ( flags() & 0x00080000 )  > 0;
    target_type_server_ =  ( flags() & 0x00020000 )  > 0;
    target_type_domain_ =  ( flags() & 0x00010000 )  > 0;
    negotiate_always_sign_ =  ( flags() & 0x00008000 )  > 0;
    negotiate_oem_workstation_supplied_ =  ( flags() & 0x00002000 )  > 0;
    negotiate_oem_domain_supplied_ =  ( flags() & 0x00001000 )  > 0;
    negotiate_anonymous_connection_ =  ( flags() & 0x00000800 )  > 0;
    negotiate_ntlm_ =  ( flags() & 0x00000200 )  > 0;
    negotiate_lm_key_ =  ( flags() & 0x00000080 )  > 0;
    negotiate_datagram_ =  ( flags() & 0x00000040 )  > 0;
    negotiate_seal_ =  ( flags() & 0x00000020 )  > 0;
    negotiate_sign_ =  ( flags() & 0x00000010 )  > 0;
    request_target_ =  ( flags() & 0x00000004 )  > 0;
    negotiate_oem_ =  ( flags() & 0x00000002 )  > 0;
    negotiate_unicode_ =  ( flags() & 0x00000001 )  > 0;
    is_oem_ = ! negotiate_unicode() && negotiate_oem();
    is_invalid_ = ! negotiate_unicode() && ! negotiate_oem();
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Encoding::ASN1Encoding() {
    meta_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Encoding::~ASN1Encoding() {
    delete meta_;
    meta_ = nullptr;
    content_.free();
}

int ASN1Encoding::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "meta"
    meta_ = new ASN1EncodingMeta();
    int t_meta__size;
    t_meta__size = meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_meta = t_begin_of_data + (t_meta__size);
    BINPAC_ASSERT(t_dataptr_after_meta <= t_end_of_data);
    // Parse "content"
    int t_content__size;
    t_content__size = meta()->length();
    // Checking out-of-bound for "ASN1Encoding:content"
    if ( t_dataptr_after_meta + (t_content__size) > t_end_of_data || t_dataptr_after_meta + (t_content__size) < t_dataptr_after_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1Encoding:content",
        	((t_dataptr_after_meta - t_begin_of_data)) + (t_content__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_meta + t_content__size;
        int t_content_string_length;
        t_content_string_length = meta()->length();
        // check for negative sizes
        if ( t_content_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/../asn1/asn1.pac:36", t_content_string_length);
        content_.init(t_dataptr_after_meta, t_content_string_length);
    }

    int t_ASN1Encoding__size;
    const_byteptr const t_dataptr_after_content = t_dataptr_after_meta + (t_content__size);
    BINPAC_ASSERT(t_dataptr_after_content <= t_end_of_data);
    t_ASN1Encoding__size = t_dataptr_after_content - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Encoding__size) <= t_end_of_data);
    return t_ASN1Encoding__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1EncodingMeta::ASN1EncodingMeta() {
    tag_ = 0;
    len_ = 0;
    long_len_ = false;
    length_ = 0;
    index_ = 0;
    tag_class_ = 0;
    simple_type_ = false;
    tag_num_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1EncodingMeta::~ASN1EncodingMeta() {
    more_len_.free();
}

int ASN1EncodingMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "ASN1EncodingMeta:len"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1EncodingMeta:len",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "tag"
    tag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "len"
    len_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "more_len"
    int t_more_len__size;
    long_len_ =  ( len() & 0x80 )  > 0;
    t_more_len__size = long_len() ? len() & 0x7f : 0;
    // Checking out-of-bound for "ASN1EncodingMeta:more_len"
    if ( (t_begin_of_data + 2) + (t_more_len__size) > t_end_of_data || (t_begin_of_data + 2) + (t_more_len__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1EncodingMeta:more_len",
        	(2) + (t_more_len__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_more_len__size;
        int t_more_len_string_length;
        t_more_len_string_length = long_len() ? len() & 0x7f : 0;
        // check for negative sizes
        if ( t_more_len_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/../asn1/asn1.pac:42", t_more_len_string_length);
        more_len_.init((t_begin_of_data + 2), t_more_len_string_length);
    }

    int t_ASN1EncodingMeta__size;
    const_byteptr const t_dataptr_after_more_len = (t_begin_of_data + 2) + (t_more_len__size);
    BINPAC_ASSERT(t_dataptr_after_more_len <= t_end_of_data);
    t_ASN1EncodingMeta__size = t_dataptr_after_more_len - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    length_ = long_len() ? binary_to_int64(more_len()) : len();
    index_ = tag() - ASN1_INDEX_TAG_OFFSET;
    tag_class_ =  ( tag() & 0xC0 )  >> 6;
    simple_type_ =  ( tag() & 20 )  >> 5;
    tag_num_ = tag() & 0x1F;
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1EncodingMeta__size) <= t_end_of_data);
    return t_ASN1EncodingMeta__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1OptionalEncodingMeta::ASN1OptionalEncodingMeta(bool is_present, ASN1EncodingMeta* previous_metadata) {
    val_case_index_ = -1;
    data_ = nullptr;
    is_present_ = is_present;
    previous_metadata_ = previous_metadata;
    length_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1OptionalEncodingMeta::~ASN1OptionalEncodingMeta() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "data"
            {
                delete data_;
                data_ = nullptr;
            }
            break;
        case false:
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ASN1OptionalEncodingMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    int t_val__size;
    val_case_index_ = is_present();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "data"
            {
                data_ = new ASN1EncodingMeta();
                int t_data__size;
                t_data__size = data_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_data__size;
            }
            break;
        case false:
            // Parse "none"
            {
                t_val__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("ASN1OptionalEncodingMeta", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    length_ = is_present() ? data()->length() : previous_metadata()->length();
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1SequenceMeta::ASN1SequenceMeta() {
    encoding_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1SequenceMeta::~ASN1SequenceMeta() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1SequenceMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1EncodingMeta();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1SequenceMeta__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1SequenceMeta__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1SequenceMeta__size) <= t_end_of_data);
    return t_ASN1SequenceMeta__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Integer::ASN1Integer() {
    encoding_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Integer::~ASN1Integer() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Integer::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Integer__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Integer__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Integer__size) <= t_end_of_data);
    return t_ASN1Integer__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1OctetString::ASN1OctetString() {
    encoding_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1OctetString::~ASN1OctetString() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1OctetString::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1OctetString__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1OctetString__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1OctetString__size) <= t_end_of_data);
    return t_ASN1OctetString__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1ObjectIdentifier::ASN1ObjectIdentifier() {
    encoding_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1ObjectIdentifier::~ASN1ObjectIdentifier() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1ObjectIdentifier::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1ObjectIdentifier__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1ObjectIdentifier__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1ObjectIdentifier__size) <= t_end_of_data);
    return t_ASN1ObjectIdentifier__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Boolean::ASN1Boolean() {
    encoding_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Boolean::~ASN1Boolean() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Boolean::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Boolean__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Boolean__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Boolean__size) <= t_end_of_data);
    return t_ASN1Boolean__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Enumerated::ASN1Enumerated() {
    encoding_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ASN1Enumerated::~ASN1Enumerated() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Enumerated::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Enumerated__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Enumerated__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Enumerated__size) <= t_end_of_data);
    return t_ASN1Enumerated__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SequenceElement::SequenceElement(bool grab_content) {
    index_meta_ = nullptr;
    have_content_case_index_ = -1;
    data_ = nullptr;
    meta_ = nullptr;
    grab_content_ = grab_content;
    index_ = 0;
    length_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
SequenceElement::~SequenceElement() {
    delete index_meta_;
    index_meta_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_content_case_index() ) {
        case true:
            // Clean up "data"
            {
                delete data_;
                data_ = nullptr;
            }
            break;
        case false:
            // Clean up "meta"
            {
                delete meta_;
                meta_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SequenceElement::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "index_meta"
    index_meta_ = new ASN1EncodingMeta();
    int t_index_meta__size;
    t_index_meta__size = index_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_index_meta = t_begin_of_data + (t_index_meta__size);
    BINPAC_ASSERT(t_dataptr_after_index_meta <= t_end_of_data);
    // Parse "have_content"
    int t_have_content__size;
    have_content_case_index_ = grab_content();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_content_case_index() ) {
        case true:
            // Parse "data"
            {
                data_ = new ASN1Encoding();
                int t_data__size;
                t_data__size = data_->Parse(t_dataptr_after_index_meta, t_end_of_data);
                t_have_content__size = t_data__size;
            }
            break;
        case false:
            // Parse "meta"
            {
                meta_ = new ASN1EncodingMeta();
                int t_meta__size;
                t_meta__size = meta_->Parse(t_dataptr_after_index_meta, t_end_of_data);
                t_have_content__size = t_meta__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SequenceElement", (int64)have_content_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SequenceElement__size;
    const_byteptr const t_dataptr_after_have_content = t_dataptr_after_index_meta + (t_have_content__size);
    BINPAC_ASSERT(t_dataptr_after_have_content <= t_end_of_data);
    t_SequenceElement__size = t_dataptr_after_have_content - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    index_ = index_meta()->index();
    length_ = index_meta()->length();
    BINPAC_ASSERT(t_begin_of_data + (t_SequenceElement__size) <= t_end_of_data);
    return t_SequenceElement__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Array::Array() {
    array_meta_ = nullptr;
    data_ = nullptr;
    data__elem_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Array::~Array() {
    delete array_meta_;
    array_meta_ = nullptr;
    delete data__elem_;
    data__elem_ = nullptr;
    if ( data() ) {
        for ( auto* data__elem_ : *data() ) {
            delete data__elem_;
            data__elem_ = nullptr;
        }
    }
    delete data_;
}

int Array::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "array_meta"
    array_meta_ = new ASN1EncodingMeta();
    int t_array_meta__size;
    t_array_meta__size = array_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_array_meta = t_begin_of_data + (t_array_meta__size);
    BINPAC_ASSERT(t_dataptr_after_array_meta <= t_end_of_data);
    // Parse "data"
    int t_data__arraylength;
    t_data__arraylength = 0;
    data__elem_ = nullptr;
    int t_data__elem__it;
    t_data__elem__it = 0;
    int t_data__size;
    data_ = new vector<ASN1Encoding*>;
    const_byteptr t_data__elem__dataptr = t_dataptr_after_array_meta;
    for (; /* forever */; ++t_data__elem__it) {
        // Check &until(data__elem__dataptr >= end_of_data)
        if ( t_data__elem__dataptr >= t_end_of_data ) {
            data__elem_ = nullptr;
            goto end_of_data;
        }
        data__elem_ = new ASN1Encoding();
        int t_data__elem__size;
        t_data__elem__size = data__elem_->Parse(t_data__elem__dataptr, t_end_of_data);
        data_->push_back(data__elem_);
        t_data__elem__dataptr += t_data__elem__size;
        BINPAC_ASSERT(t_data__elem__dataptr <= t_end_of_data);
        data__elem_ = nullptr;
    }
end_of_data: ;
    t_data__size = t_data__elem__dataptr - (t_dataptr_after_array_meta);
    // Evaluate 'let' and 'withinput' fields

    int t_Array__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_array_meta + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Array__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Array__size) <= t_end_of_data);
    return t_Array__size;
}

int64 binary_to_int64(bytestring const& bs) {

	int64 rval = 0;

	if ( bs.length() > 8 )
		{
		zeek::reporter->Weird("asn_binary_to_int64_shift_too_large", zeek::util::fmt("%d", bs.length()));
		return 0;
		}

	for ( int i = 0; i < bs.length(); ++i )
		{
		uint64 byte = bs[i];
		rval |= byte << (8 * (bs.length() - (i + 1)));
		}

	return rval;
	
}



zeek::ValPtr asn1_integer_to_val(const ASN1Integer* i, zeek::TypeTag t)
	{
	return asn1_integer_to_val(i->encoding(), t);
	}

zeek::ValPtr asn1_integer_to_val(const ASN1Encoding* i, zeek::TypeTag t)
	{
	auto v = binary_to_int64(i->content());

	switch ( t ) {
	case zeek::TYPE_BOOL:
		return zeek::val_mgr->Bool(v);
	case zeek::TYPE_INT:
		return zeek::val_mgr->Int(v);
	case zeek::TYPE_COUNT:
		return zeek::val_mgr->Count(v);
	default:
		zeek::reporter->Error("bad asn1_integer_to_val tag: %s", zeek::type_name(t));
		return zeek::val_mgr->Count(v);
	}
	}

zeek::StringValPtr asn1_oid_to_val(const ASN1ObjectIdentifier* oid)
	{
	return asn1_oid_to_val(oid->encoding());
	}

zeek::StringValPtr asn1_oid_to_val(const ASN1Encoding* oid)
	{
	vector<uint64> oid_components;
	vector<vector<uint8> > subidentifiers;
	vector<uint64> subidentifier_values;
	vector<uint8> subidentifier;
	bytestring const& bs = oid->content();

	for ( int i = 0; i < bs.length(); ++i )
		{
		if ( bs[i] & 0x80 )
			subidentifier.push_back(bs[i] & 0x7f);
		else
			{
			subidentifier.push_back(bs[i]);
			subidentifiers.push_back(subidentifier);
			subidentifier.clear();
			}
		}

	if ( ! subidentifier.empty() || subidentifiers.empty() )
		// Underflow.
		return zeek::val_mgr->EmptyString();

	for ( const auto& subidentifier : subidentifiers )
		{
		uint64 value = 0;

		for ( size_t j = 0; j < subidentifier.size(); ++j )
			{
			uint64 byte = subidentifier[j];
			value |= byte << (7 * (subidentifier.size() - (j + 1)));
			}

		subidentifier_values.push_back(value);
		}

	string rval;

	for ( size_t i = 0; i < subidentifier_values.size(); ++i )
		{
		char tmp[32];

		if ( i > 0 )
			{
			snprintf(tmp, sizeof(tmp), ".%" PRIu64, subidentifier_values[i]);
			rval += tmp;
			}
		else
			{
			std::div_t result = std::div(subidentifier_values[i], 40);
			snprintf(tmp, sizeof(tmp), "%d.%d", result.quot, result.rem);
			rval += tmp;
			}
		}

	return zeek::make_intrusive<zeek::StringVal>(rval);
	}

zeek::StringValPtr asn1_octet_string_to_val(const ASN1OctetString* s)
	{
	return asn1_octet_string_to_val(s->encoding());
	}

zeek::StringValPtr asn1_octet_string_to_val(const ASN1Encoding* s)
	{
	bytestring const& bs = s->content();
	return zeek::make_intrusive<zeek::StringVal>(bs.length(), reinterpret_cast<const char*>(bs.data()));
	}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Flow::NTLM_Flow(NTLM_Conn* connection, bool is_orig) {
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
NTLM_Flow::~NTLM_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
}

void NTLM_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        dataunit_ = new NTLM_SSP_Token(is_orig());
        context_ = new ContextNTLM(connection(), this);
        int t_dataunit__size;
        t_dataunit__size = dataunit_->Parse(t_begin_of_data, t_end_of_data, context_);
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        throw e; // NOLINT(bugprone-exception-copy-constructor-throws)
    }
}

void NTLM_Flow::NewGap(int gap_length) {
}
void NTLM_Flow::FlowEOF() {
}

	// This is replicated from the SMB analyzer. :(
	zeek::IntrusivePtr<zeek::TimeVal> filetime2zeektime(uint64_t ts)
		{
		double secs = (ts / 10000000.0);

		// Zeek can't support times back to the 1600's
		// so we subtract a lot of seconds.
		auto zeek_ts = zeek::make_intrusive<zeek::TimeVal>(secs - 11644473600.0);

		return zeek_ts;
		}

	zeek::RecordValPtr build_version_record(NTLM_Version* val)
		{
		auto result = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::NTLM::Version);
		result->Assign(0, val->major_version());
		result->Assign(1, val->minor_version());
		result->Assign(2, val->build_number());
		result->Assign(3, val->ntlm_revision());

		return result;
		}

	zeek::RecordValPtr build_negotiate_flag_record(NTLM_Negotiate_Flags* val)
		{
		auto flags = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::NTLM::NegotiateFlags);
		flags->Assign(0, val->negotiate_56());
		flags->Assign(1, val->negotiate_key_exch());
		flags->Assign(2, val->negotiate_128());
		flags->Assign(3, val->negotiate_version());
		flags->Assign(4, val->negotiate_target_info());
		flags->Assign(5, val->request_non_nt_session_key());
		flags->Assign(6, val->negotiate_identify());
		flags->Assign(7, val->negotiate_extended_sessionsecurity());
		flags->Assign(8, val->target_type_server());
		flags->Assign(9, val->target_type_domain());
		flags->Assign(10, val->negotiate_always_sign());
		flags->Assign(11, val->negotiate_oem_workstation_supplied());
		flags->Assign(12, val->negotiate_oem_domain_supplied());
		flags->Assign(13, val->negotiate_anonymous_connection());
		flags->Assign(14, val->negotiate_ntlm());
		flags->Assign(15, val->negotiate_lm_key());
		flags->Assign(16, val->negotiate_datagram());
		flags->Assign(17, val->negotiate_seal());
		flags->Assign(18, val->negotiate_sign());
		flags->Assign(19, val->request_target());
		flags->Assign(20, val->negotiate_oem());
		flags->Assign(21, val->negotiate_unicode());

		return flags;
		}

} // namespace NTLM
}  // namespace binpac
